@device(postscript)
@make(article, FORM 1) 
@style(fontfamily=timesRoman, size=11, indent 5, widowaction=force, spacing 1.0)
@pageheading(left "@b[@value(sectiontitle)]", center "@b[ACCT20 User Manual]",
    right "@b[Page @value(page)]")
@modify(Hd2, centered, pagebreak before, below 2 lines)
@modify(appendix, numbered <Appendix @A.>, referenced <@A>)
@modify(itemize, above .5 line, spacing 1.2)
@modify(enumerate, above .5 line, spacing 1.2)
@begin(titlepage)
@blankspace(.5 in)
@begin(titlebox)
@majorheading[ACCT20

DECSYSTEM-20 Resource-Usage 
Accounting Program

@i{Version 2.0}

User Manual]
@end(titlebox)

@heading(Written by
David Todd
Director of University Computing
Wesleyan University
Middletown, CT  06457
@value(date))
@end(titlepage)
@begin(text)
@set(page=1)
@section(Overview)

        ACCT20 analyzes the TOPS-20 @t{SYSTEM-DATA.BIN}
files that contain audit trails of DECSYSTEM-20 usage and  produces summary or
detailed reports of usage statistics.  The reports that may be generated
include a general summary of use by each directory or account, a detailed
report of all use by a specific directory or account, a report of usage of
printer forms, a report of usage by category of directory or account, and a
list of billable users.  

	The program is designed primarily to serve as an
end-of-month summary and limited billing program.  It is not designed to
efficiently generate bills for every user.  Rather, the underlying philosophy
of its development is that only summaries are needed for most users and that
detailed account trails are needed for only a few users. 

        The program is designed to provide great flexibility in the types of
charges, rates charged, and types of reports generated.  In order to avoid the
need for lengthy command sequences to generate basic usage reports,
most commands assume defaults for values or source filenames.  Report formats
are rigidly defined, which some users might find a disadvantage, but the
emphasis in developing the program was to  provide an efficient method for
generating the desired reports at (possibly) the expense of some generality in
the way the information is processed.

        ACCT20 reads in charge rates for use of various resources from
user-specified data files.  Resources include CPU and terminal connect time,
disk storage allocations and quotas, printer pages (both NORMAL and special
forms), cards read, and plotter use.  ACCT20 permits use of different rates for
CPU and terminal time charges for different shifts  of the day (defined by the
administrator) and different charges for internal vs. external users. 

        The summary reports generated may be based upon either directory name
or account string.  The summary listings include summaries at each level of the
tree-structured directory (or account-string).  For example, usage under CHEM,
CHEM.J-JONES, and CHEM.S-SMITH is summarized under each individual name. 

        Summary information may be also analyzed according to a categorization
scheme.  For example, it may be desirable to categorize all use under academic
accounts under a heading ACADEMIC, all use under administrative accounts under
a heading ADMINISTRATIVE, and all use under system administration accounts
under the heading SYSTEM.  This can be done by creating a file which contains
the categorizations desired and using the CATEGORIZE command.

@section(Version 2 Release Notes)

        Version 2 fixes a number of bugs that were reported in Version 1,
implements several new commands (LIST-CATEGORY-TOTALS, LIST-SUMMARY-TOTALS,
and REPROCESS), and includes a new tree-management system (using
height-balanced trees -- see the program logic manual).  The new features were
needed for the routine use we made of ACCT20 here for analyzing computer use,
and they are likely to be valuable for others, too.

        This version has been in use at Wesleyan for about four years (sorry, I
just couldn't get around to documenting and redistributing the system).  The
following bugs are still known:
@itemize{When processing tables from data files (e.g., CATEGORIZE), the
internal command buffer may overflow.  See the @i[ACCT20 Program Logic Manual]
for a patch suggested by Rob Austein to fix this bug.

Recovery from errors found while processing data files is still poor.
}

	One minor change in Version 2 is that I converted documentation
to SCRIBE, hence the @t[.MSS] files on the tape.  I processed the @t[.MSS]
file into a @t[.LPT] file (printable on a standard line printer) and a @t[.PS]
file (printable on a PostScript printer) for those without SCRIBE licenses.

	Unfortunately, I have no time to continue working on the program (as much fun
as it was!), and the only DEC-20 left at Wesleyan is being phased out.  As I
have forgotten many of the details of implementation of ACCT20, I cannot offer
to support it.  However, I do invite anyone with improvements or bug fixes to
submit revisions to the DECUS Library, which remains the repository for the
code.

@section(Use)

        ACCT20 runs in native TOPS-20 mode, and command-recognition features
are used heavily.  Most commands simply establish processing conditions or select
files which establish charge rates, etc.  Commands that use filenames also
have default filenames so that lengthy command strings are
avoided.  Two commands, the @t{PROCESS} and @t{REPROCESS} commands, actually
causes processing of the system data files from @t{<ACCOUNTS>}.
        
	The normal sequence of commands to use ACCT20 on a monthly basis
might be:
@itemize{
Use the @t[NAME] command to establish a name prefix for the data files used
and generated (of the form "MONYY").

Use the @t[CHARGE] command to indicate that some users will be billed and
to give the name of the file that identifies those users.

Use the @t[CATEGORIZE] command to read a file describing the categories
to which departments or individual usres should be assigned and to ask that
a listing of use by those categories be generated.       

Use the @t[PRINTER-CHARGES] command to establish charge rates for special
forms.

Use the @t[FORMS] command to request a text-file dump of use of special
forms (for other possible analyses by other programs).

Use the @t[DUMP] command to request a dump of the summary information as
a binary file that can be subsequently reprocessed -- with other binary
summary files for a year-to-date summary, for example.

Use the @t[WRITE] command to request that the detailed accounting entries
for the billable users be dumped, in binary, for a subsequent billing run.

Use the @t[STATISTICS] to request a summary of the number of different types
of records processed.

Use the @t[LIST-CATEGORIES] and @t[LIST-SUMMARY] commands to request text-file
listings of the category and summary reports in a format suitable for use
with a database system.

Use the @t[PROCESS] command to initiate processing of the binary accounting
files and subsequently generate requested reports.

@t[EXIT] to close files and exit from ACCT20.}

        Interactive use is not required, and batch operation may be preferred.
The files which establish rate and categorizations may be  created, then the
monthly accounting can be run with a standard batch control file (usually
edited to indicate the month of the accounting).  The file @t{MONTHLY.CTL}
that is distributed with the ACCT20 package can serve as a prototype for other
users' batch files to generate summary information.  The file @t{BILLER.CTL}
can serve as a prototype for other users' batch files to generate bills for
billable users identified in the MONTHLY batch file run.

        ACCT20 is intended to operate with the CLSACT program, also distributed
with the ACCT20 package, which closes the @t{SYSTEM-DATA.BIN} file each day and
renames it to a name of the form '@t{ddmonyy.BIN}', which records the day on
which the file was closed.  The processing of this sequence of files by ACCT20
for a month can be commanded by using a wildcard filename construction,
'*monyy', in the @t{PROCESS} command which causes the system data files to be
processed, or by defining a default filename prefix 'monyy' through the
@t{NAME} command and permitting ACCT20 to use this default name in the
@t{PROCESS} command.  If the latter method is used, many of the report files
generated will also bear the name prefix 'monyy', which is helpful on listing
banner pages and on directory listings.

        A description of the use of ACCT20 necessarily involves a description
of both the commands ACCT20 takes and the files and file formats it expects to
use, since in most cases its actions are driven by data files.  The following
two sections describe the commands first, then the input and output files.

@section(ACCT20 Commands)

        The following commands are available in ACCT20.  These descriptions
are in the form seen by the interactive user with command recognition. 
The items in "()" are guide phrases; the items in "<>" are to be supplied
by the user.
@description{
BEGIN (with starting date/time) <date-time>@\Sets the starting date/time for
records to be accepted for processing.

CATEGORIZE (using file) <filename>@\Use the specified file to determine how the
directories or accounts processed are to be categorized under broad headings in
the categorized summary report. Default name is @t{ACCT20.CAT}. @t{TTY:} is a
valid <filename> specifier; command recognition is in effect at this subcommand
level, too. 

CHARGE-RATES (from file) <filename>@\Use the specified file to establish charge
rates for various resources. Default name is @t{ACCT20.CHG}.  If this command
isn't given, or resources are not specifically given in the CHG file, the
default rate values are taken from the charge rates predefined in the ACCT20
program (users beware!). @t{TTY:} is a valid <filename> specifier; command
recognition is in effect at this subcommand level, too. 

DEBUG@\This option enables output of certain detailed information in cases when errors
occur.  To get maximum benefit, the @t{DEBUG} assembly switch should also be
set in the MACRO code.

@begin(multiple)
DETAIL (use of resources) <resource> (by user) <username>@\This causes the
PROCESS command to generate a report of all entries in the system data files
for the specified user.  The <resource> field can be one of the following:
@description{
CPU-USE

DISK-USE

INPUT-SPOOLER

NONE

OUTPUT-SPOOLERS

SYSTEM-USE

TAPE-USE

TTY-USE}

SYSTEM-USE includes all entry types; TTY-USE and CPU-USE include just session
records; the others are self explanatory. The <resource> field is required.
The <username> field is either the directory name or the account name of the
user(s)  (this choice is selected by the @t{REPORT} command) for whom detailed
listings are desired. Wildcards function in this field.  If omitted, the
<username> field defaults to '*' (list usage for all users).  The output file
name defaults to @i{<username>}@t{.LPT} or to @t{ACCT20.LPT} if the
@i{<username>} field is omitted.  See @t{DETAILS} file description below for
information about the output file contents. 
@end(multiple)

DUMP (binary summary to file) <filename>@\This causes the internal summary
database to be dumped to the specified file in binary form, sorted by
directory/account name. The default name for the output file is
@t{ACCT20-SUMMARY.BIN} or, if the @t{NAMES} command was given before the
@t{DUMP} command, the name defaults to @i{<periodname>}@t{-SUMMARY.BIN}.  The
binary file can be used to provide annual summary information through the use
of the @t{REPROCESS} command.  Developers should see the structure of the
internal summary tree nodes and the output routines in the section titled 'DUMP
Command Processing' of ACCT20.MAC if they wish to use this file.

END (at starting date/time) <date-time>@\Process no entries with date-time
stamps later than  the <date-time> specified. 

EXIT@\Exits from ACCT20.  @u{This is required for normal processing
termination!}  The @t[PROCESS] command does not close certain report files
after the end of the last input file under the presumption that the user may
wish to process more than one set of commands into the same output file.  A
@t{CNTL-C}-exit from ACCT20 will lose some report files.

FORMS <usage to be generated>@\This requests that all printer output spooler
entries from the input system data files be listed to an output file in ASCII
format for possible subsequent processing by other programs.  The default name
is @t{ACCT20-FORMS.DMI} unless the @t{NAME} command was given before the
@t{FORMS} command, in which case the name defaults to
@i{<periodname>}@t{-FORMS.DMI}. The output format is satisfactory for use with
a database system, and a SYSTEM 1022 database description file included in the
ACCT20 package, @t{FORMS.DMD}, can be used to load the file generated into a
database. The procedures for using the @t{FORMUS.DMC} and @t{FORMTY.DMC} report
generators are given in the @t{MONTHLY.CTL} batch control file and can be used
to generate year-to-date forms usage reports by username and by form type. See
@t{FORMS OUTPUT FILE} description below for more information on the contents of
this file. 

HELP@\This simply lists the commands with a brief description of each. 

LIST-CATEGORY-TOTAL (to file) <filename>@\This lists the category totals
to a text file in a format suitable for loading and processing by a database
system (no page headers!).

LIST-SUMMARY-TOTAL (to file) <filename>@\This lists the summary totals to
a text file in a format suitable for loading and processing by a database
system (no page headers!).

NAME (default for file is) <periodname>@\This command establishes a default
prefix name, <periodname>, for the files to be processed by the @t{PROCESS}
command and for files  subsequently generated by other report-generating
commands.  In normal use with the CLSACT program (run with the daily system
backups), the <periodname> field will have a form such as 'monyy', where 'mon'
is the month of the system data files to be process and 'yy' is the year of
those files, e.g,. @t{AUG81}.  The @t{PROCESS} command then attempts to process
files @t{<ACCOUNTS>*AUG81.BIN}, for example, unless the filename is explicitly
given on the @t{PROCESS} command, and the @t{AUG81} prefix is used for report
files generated, e.g., @t{AUG81-SUMMARY.LST}.

NO-MTA-DETAILS@\Various bugs in the TOPS-20 MOUNTR code cause it to generate
incorrect entries in the system data files (primarily manifested as using an
incorrect username (directory/account) on a tape usage record). This seems to
now have been corrected by various SPR's.  This switch does not list under the
command-recognition features, but it is  intended to be used if magtape records
appear to be incorrect and it is desired not to bill any users for magtape
usage.

PRINTER-CHARGES (from file) <filename>@\This command prepares ACCT20 to account
for use of special printer forms at rates other than the rate for NORMAL forms
(which is specified in the @t{CHARGES} command).  Default filename is
@t{ACCT20.PCG}. See the description of @t{PRINTER-CHARGES} file for more
information. 

PROCESS (from file (sequence)) <filename>@\This causes the system data files to
be processed and the reports to be generated.  Default filename is
@t{SYSTEM-DATA.BIN} unless the @t{NAME} command was previously given, in which
case the default filename is '@t{*<periodname>.BIN}'.  Wildcards can be used if
the filename is specified.  The @t{PROCESS} command does not close certain
report files so that the user may @t{PROCESS} more than one set of files or
@t{PROCESS} one set of files with several processing conditions into just one
set of output reports.  Be sure to use the @t{EXIT} or @t{RESET} command for
normal termination of processing.

REPORT (by) <ACCOUNT or DIRECTORY>@\Commands ACCT20 to perform its accounting
summaries by matching on account string or on directory name.  Default is
@t{DIRECTORY} if the command is not given at all. 

REPROCESS (from binary summary file named) <filename>@\This processes a
summary file into a new internal summary table, perhaps to be concatenated
with other summary files as in a year-to-date summary, and also permits
a recategorization of usage if the @t[CATEGORIZE] command had been issued
before @t[REPROCESS].

RESET@\This command closes all open files and resets all internal tables to
zero.  Subsequent processing must again provide charge rates, categorization
schemes, etc., and statistics from prior processing of system data files are
deleted from internal tables.  This command is primarily used in generation of
bills for multiple users with a single run of ACCT20. 

STATISTICS@\This command is a toggle which requests that statistics on the
performance of ACCT20 be typed to the user at the end of a @t{PROCESS} command.
Statistics provided currently include the number of different types of entries
processed and the time required to process all entries.  

SUMMARIZE (use of resources) <resource> (by) <username>@\This commands ACCT20
to generate a summary report of all use of the specified resources by the users
defined by the @i{<username>} string.  The options for the @i{<resources>}
field are given in the @t{DETAILS} command description.  The @i{<username>}
field may contain wildcards.  It defaults to '*'.  The default filename of the
report file is ACCT20-SUMMARY.LST unless the NAME command was previously given,
in which case the default name is @i{<periodname>}@t{-SUMMARY.LST}. See the
description of @t{SUMMARY} file for information about the contents of this
file. 

WRITE-DETAIL-BINARY (to file) <filename>@\This commands ACCT20 to copy to the
@t{DETAIL.BIN} file all records in the system data files which were generated
by billable users.  The @i{<username>} of billable customers is established in
the @t{CHARGES} file.  The @t{DETAIL.BIN} output file can be used in subsequent
@t{PROCESS} commands to generate @t{DETAIL} listings of use by each of the
billable customers, and the reduced size of the @t{DETAIL.BIN} file makes this
billing process much less expensive and time-consuming.  The default filename
for the @t{DETAIL.BIN} file is @t{ACCT20-DETAILS.BIN} unless the @t{NAME}
command specified a @i{<periodname>} prefix, in which case the default filename
is @i{<periodname>}@t{-DETAILS.BIN}. The file contents are in exactly the same
format as the  @t{SYSTEM-DATA.BIN} files.
}

@section(ACCT20 Files)

        There may be many different files involved in a run of ACCT20.  The
following summary may help avoid confusion about their purposes:
@description{
SYSTEM-DATA.BIN@\This file is the one produced by the system with usage
statistics recorded in it.  It is the file into which entries are made by the
USAGE JSYS, and it is the file which is processed into an ASCII USAGE file by
the DEC CHKPNT program.  ACCT20 uses this file directly and @u{does not process
USAGE files and does not require the CHKPNT program}.  The CLSACT program
supplied with the ACCT20 package can be used to close the
@t{<ACCOUNTS>SYSTEM-DATA.BIN} file each day and rename it to a file with a name
of the form "@t[nnmonyy.BIN]" so that daily binary files can be kept separately
if desired.  In this case, there will be a series of @t[SYSTEM-DATA.BIN] files
which must be processed together, and ACCT20 will accept wildcard filenames for
the @t[SYSTEM-DATA.BIN] file to be processed.

@begin(multiple)
CHARGES file@\Charges for resources may be typed in at the terminal during a
run of ACCT20 or may be entered in advance into a charges file. The resources
for which ACCT20 is prepared to charge are described in the following format,
used by the ACCT20 @t{CHARGES} command processor:
@description{Bill (user) <username> [COMMERCIAL or NON-PROFIT]

Cards-read (is $) <cost in $/card>

Connect-time (is $) <charge> [/HR or /MIN or /SEC]

Core-occupancy [not supported by DEC]

CPU-time (is $) <charge> [/HR or /MIN or /SEC]

Disk-allocation (in pages/month is $) <charge> 

Disk-reads (not supported by DEC) 

Disk-storage (in pages/month is $) <charge>

Disk-writes (not supported by DEC)

Printer-pages (for printed pages is $) <charge> 

Shift (starts at) <time> (and is billed at base rate times) <ratio> 

Structure-mounts (for structure mounts requiring operator attention is $)
<charge> 

Structure-usage (for use of operator-mounted structures is $) <charge> [/HR or
/MIN or /SEC] 

Tape-mounts (for tape mounts is $) <charge>

Tape-usage (for tape use is $) <charge> [/HR or /MIN or /SEC]

Tax (commercial users at percentage rate) <percentage tax rate> 
TTY-characters-in (not supported by DEC)

TTY-characters-out (not supported by DEC)

Weekend (rates for commercial users is base rate times) <ratio>
}
Charges for any or all of these resources may be set by input from the terminal
or from the CHARGES input file.  An example of the file is included with the
ACCT20 package as @t{ACCT20.CHG}.  @u[The CHARGES file must end with the
command @t{END-CHARGES}];  interactive input uses command  prompting.  Default
values of the charge rates are embedded in the @t{ACCT20.MAC} file and may be
changed if a firm rate structure is to be used for extended periods of time. 

        The charges file has a default name @t{ACCT20.CHG}.  If the @t{CHARGES}
command is given to ACCT20 but no file is specified, that file is used as the
source of resource charge information.
@end(multiple)

Printer charges@\It is possible to charge different rates for different types
of special forms.  The "@t{PRINTER-PAGES}" charge rate associated with the
@t{CHARGES} command establishes the rate only for NORMAL forms.  Rates for any
special forms are established by the @t{PRINTER-CHARGES} command, which will
accept printer charges from either the terminal or an input file.  The default
name of the file used for @t{PRINTER-CHARGES} is @t{ACCT20.PCG}.  The entries
in the file are of the form @t[formname   price], where the @t[formname] must
be no more than 6 characters long and the price is in units of dollars per
page, where a page is defined by the amount of physical medium between
successive top-of-form locations on the VFU associated with the form. There is
no prompting for optional names for forms, since any form name can be used.
@u[The file must be terminated by @t{PRTEND}.] The default filename is
@t[ACCT20.PCG]; an example of this file is included in the ACCT20 package. 

Categorization file@\This optional input file provides the categorizations of
the different users into broad possible categories, e.g., CHEM* as ACADEMIC and
REGISTRAR* as ADMINISTRATIVE.  Entries in the file are of the form
@t[<username>@# <category name>], where <username> is the directory or account
name string to be categorized and <category name> is the name of the category
under which the usage by the specified <username> is to be categorized. The
<username> string may (and usually will) contain wildcards so that it is
essentially the superior directory name for the users to be categorized.  Each
<username> must map into just one category; many <username>s may map into a
single category. The default file name for the @t[CATEGORIZE] command is
@t[ACCT20.CAT];  an example of this file is included in the ACCT20 package.
@u[Note that the last entry of the file must be @t{END-CATEGORIES}].

DETAILS.BIN@\This optional output file is written by the first pass of ACCT20
as it processes the @t[SYSTEM-DATA.BIN] file if the @t[WRITE-DETAIL-BINARY]
command had been given.  This file contains the entries of the
@t[SYSTEM-DATA.BIN] file with directory names or account strings which match
entries in the @t[BILL] subcommand of the @t[CHARGE] command. This file can be
read on the second pass of ACCT20 to generate the detailed listings of usage.

Details user-name file (@t[ACCT20-BILLED-USERS.TMP])@\This file lists the
directory or account strings for which detailed entries in the @t[DETAILS.BIN]
binary file were written.  This file is written as a result of the
@t[WRITE-DETAIL-BINARY] command. The default filename is
@t[ACCT20-BILLED-USERS.TMP], unless the @t[NAME] command was used to specify a
@i[<periodname>], in which case the filename is
@i[<periodname>]@t[-BILLED-USERS.TMP].

DETAILS listing files@\These output files contain the detailed listings of
usage by directories or accounts selected with the @t[DETAIL] command. The
listings include date/time stamp, username, and a record of the activity
generated by the user(s) specified in the @t[DETAIL] command.

LIST files@\These files are text files without page headers, in fixed-field
format, suitable for use with a database system.  The information is the
same as that of the SUMMARY and CATEGORIES output files, but without headers.

SUMMARY listing file@\This file contains a summary of use of the system by all
users selected by the @i[<username>] field of the @t[SUMMARIZE] command.  The
summary listings are given in alphabetical order and contain the username,
summary of timesharing and batch computer use, printer and plotter output
spooler use, card reader input spooler use, disk use, tape use, and total value
of services rendered.  A grand total is given at the end of the listing.
}

@end(text)

