@device(postscript)
@make(article, FORM 1) 
@style(fontfamily=timesRoman, SIZE=11, indent 5, widowaction=force, spacing 1.0)
@pageheading(left "@b[ACCT20 Program Logic Manual]",
	center "@b[@value(sectiontitle)]",
    	right "@b[Page @value(page)]")
@modify(Hd2, centered, pagebreak before, below 2 lines)
@modify(appendix, numbered <Appendix @A.>, referenced <@A>)
@modify(itemize, above .5 line, spacing 1.2)
@modify(enumerate, above .5 line, spacing 1.2)
@begin(titlepage)
@blankspace(.5 in)
@begin(titlebox)
@majorheading[ACCT20

DECSYSTEM-20 Resource-Usage
Accounting Program

@i{Version 2.0}

Program Logic Manual
]
@end(titlebox)
@heading(Written by
David Todd
Director of University Computing
Wesleyan University
Middletown, CT 06457

@i[@value(date)]
)
@end(titlepage)
@begin(text)
@set(page=1)
@section(Introduction)

        ACCT20  analyzes the TOPS-20 @T[SYSTEM-DATA.BIN] files
that contain audit trails of DEC-20 usage and produces summary and detailed
reports of usage statistics.  The @i[ACCT20 User Manual] explains the use of
the program for usage accounting.  This @i[ACCT20 Program Logic Manual]
outlines the internal operation of ACCT20 and explains how to assemble and load
the necessary program modules.

        Before attempting to understand the operation of program, you will need
to have read the Digital @i[DEC-20 Accounting System Specifications] manual,
Order Number DEC-20-UASSA-A-D (part of the TOPS-20 documentation set).  This
document explains the internal format of the @t[SYSTEM-DATA.BIN] file that TOPS
generates to record system usage.  The binary, variable-length records in that
file contain information about CPU usage, structure and tape mounts, printer
usage, etc.  It is that file that ACCT20 processes to summarize system usage.

        It will also be helpful to have access to the files that generate
and are used by ACCT20.  The distribution tape for ACCT20 contains the
following files:
@description{
@t[ACCT20.MAC, .REL, .EXE]@\The assembly-language source program, assembled
code, and executable code for ACCT20.

@t[BINTAB.MAC, .REL]@\A package of routines for handling binary tables.

@t[TREES.MAC, .REL]@\A package of routines used for binary-tree manipulation by
ACCT20.

@t[CLSACT.MAC, .REL, .EXE]@\A program that can be used to close the
TOPS-maintained file @t[SYSTEM-DATA.BIN] daily, giving a unique name to the
file that summarizes the accounting data for that day.

@t[MONTHLY.CTL]@\A prototype for a batch control file that can be used to
perform monthly accounting with ACCT20.

@t[ACCT20.CHG]@\An example of a file that can be used to specify charges to be
assessed for resources used.

@t[ACCT20.PCG]@\An example of a file that can be used to specify charges to be
assessed for different types of printer forms used.

@t[ACCT20.CAT]@\An example file to demonstrate how specific users and
departments can be grouped together into categories for summarization of use by
broad categories instead of use by individual users.

@t[ACCT20-USER.MSS, .PS, .LPT]@\The SCRIBE source file, PostScript-printable,
and line-printable text files for the user manual.

@t[ACCT20-PLM.MSS, .PS, .LPT]@\The SCRIBE source file, PostScript-printable,
and line-printable text files for this manual.
} 
               
	The latter, data files are used by ACCT20 in processing the accounting
information into usage summaries, and much of the program deals with building
tables from these files.

@section(Internal Operation)

        The ACCT20 program is table-driven by various commands.  The primary loop of
the program is a very simple one beginning at @t[LOOP], shortly after the
@t[ACCT20] starting address, and is driven by the processing of a COMAND JSYS
call (to DPROMP) that takes a command from the user and dispatches to the
appropriate routine to process the command.  Most commands set status bits in a
flag accumulator to indicate post-processing output routine to be invoked, 
open and process auxiliary data files to build internal data
tables, and open output JFN's.

        The main processing routine is the one that processes the system data
file (@t[SYSTEM-DATA.BIN]).  This processing is initiated by the @t[PROCESS]
command.  The code in that section, starting at address @t[.PRO]: 
@itemize[reads in a record and validates it as best it can,  

dispatches to the processing routine appropriate for the type of entry of the
accounting record,

returns to read the next record to process, and

at the end of the last input file (from a possible sequence of input files),
invokes procedures to dump and list summary data tables.]

        The summary information is maintained in a binary tree that is
dynamically created during the @t[PROCESS]ing of the accounting files.  The
@t[DUMP] command dumps the (memory-independent) information in this tree, along
with some header information, into the @t[SUMMARY.BIN] file.   This file is can
be used for @t[REPROCESS]ing, to re@t[CATEGORIZE] the summarized data for
various usage analyses, for example.  The @t[LIST] commands process the binary
summary tree into  text files.

        Most of the processing is actually straightforward, and there are,
hopefully, few interdependencies between sections of code. The addition of new
commands should be relatively easy should new developments be desired.

@section(Assembly and Loading)

        ACCT20 must be compiled with several standard Digital symbol-definition
modules and loaded with two other modules written specifically for ACCT20,
BINTAB and TREES.  BINTAB is a set of routines to keep one-word-entry binary
tables (similar to TBLUK JSYS methods but with binary keys).  TREES builds,
maintains, and processes the internal binary trees used for data  storage for
summary purposes (among other things). The LOAD command then takes the form
@programexample{@@LOAD ACCT20,BINTAB,TREES
@@SAVE}

        The TREES routines use height-balancing algorithms explained by Knuth
in Volume 1, @i[Fundamental Algorithms] in his series on @i[The Art of
Computer Programming].  Version 1 of ACCT20 did not use height-balancing.
Height balancing was expected to improve performance, but the net effect was
minimal: sometimes an improvement, sometimes not, depending upon the data
stream.  Version 2 retains the height-balancing algorithms, though.

        There are numerous demonstration and support files supplied with the
ACCT20 package.  Most of these are described in the ACCT20 User Manual. The
@t[MONTHLY.CTL] and @t[BILLER.CTL] files serve as prototypes for a monthly
summary report generating batch control file and for a monthly billing file.
Instructions on use of these files are contained in the files themselves.

@section(Deficiencies)

        The following are the major decificiencies of which I'm
aware in ACCT20:
@itemize{Error recovery for various commands processing from disk files is poor.
For example, if a keyword is mistyped in the @t[ACCT20.CHG] file, no recovery
is attempted and the user must @t[CNTL-C] and search through the file to
attempt to find and fix the problem.

The binary tree routines do height balancing, but it appears that algorithm
does not improve execution time of the program (and may make it worse in
some cases).
It appears that the efficiency of the summarizing process depends upon the 
order
in which entries appear in the system data file.  Use of a height-balancing
algorithm for tree maintenance may help in the generation of the tree
but not in its processing.  Further analyses might be useful (but
probably won't effect significant performance improvements).

The summary listing file does not visually group summary lines by directory
level.  This should be a relatively easy fix.

Generation of details listings for bills should be made automatic rather than
requiring a separate processing step.

@begin(multiple)
Rob Austein has pointed out that while reading a data file to establish tables
(e.g., @i[ACCT20.CAT]), the message "too big for internal buffer" can
occasionally be generated.  He points out that this is because even in
processing a file the DPROMP JSYS should be called to set up state pointers.  I
haven't had a chance to try his suggested patches and so haven't installed them
in Version 2, but I trust that these will solve that problem:

Replace
@programexample{
HRROI   A,[ASCIZ "Foo>"]
TXNE    F,F%TTIN
 CALL DPROMP}
with code such as
@programexample{
HRROI   A,[ASCIZ "Foo>"]
TXNN    F,F%TTIN
 HRROI  A,[Z]
CALL    DPROMP}

This will invoke DPROMP with a null string if not interactive, so the state
block is initialized as it should be.
@end(multiple)
}

        Unfortunately I will be unable to provide ongoing support or future
versions of ACCT20.  I invite anyone who has additional edits to submit the
revised code to the DECUS Library, Marlboro, MA.

@end(text)
