IDENTIFICATION DIVISION.
PROGRAM-ID.	RPGFFF.
DATE-WRITTEN.	APRIL 13, 1976.
AUTHOR.	HAL ROACH.
INSTALLATION.	CERRITOS COLLEGE.
REMARKS.	PROGRAM TO UPDATE F DATA CARD.
ENVIRONMENT DIVISION.
CONFIGURATION SECTION.
SOURCE-COMPUTER.	DECSYSTEM-10.
OBJECT-COMPUTER.	DECSYSTEM-10.
SPECIAL-NAMES.
	CONSOLE IS TTY.
	CHANNEL (1) IS HOF.
INPUT-OUTPUT SECTION.
FILE-CONTROL.
	SELECT PROGRAM-FILE ASSIGN TO DSK
	ACCESS MODE IS RANDOM
	ACTUAL KEY IS PROGRAM-KEY
	FILE LIMIT IS 99999.
DATA DIVISION.
FILE SECTION.
FD	PROGRAM-FILE
	BLOCK CONTAINS 8 RECORDS
	LABEL RECORDS ARE STANDARD
	VALUE OF IDENTIFICATION IS PROGRAM-IDENTIFICATION
	DATA RECORD IS PROGRAM-RECORD.
01	PROGRAM-RECORD	PIC X(90).
WORKING-STORAGE SECTION.
77	HOLD-23				PIC XX.
77	SIDE-CHANGE-CHECK		PIC X.
77	NUM-IT-1			PIC 9.
77	NUM-IT-2			PIC 99.
77	NUM-IT-4			PIC 9(4).
77	NUM-IT-6		PIC 9(6).
77	ELE-9			PIC 99.
77	FINAL-VALUE		PIC 99.
77	CLEAR-IT		PIC X(31)	VALUE SPACES.
77	CLEAR-3300		PIC X(23)	VALUE SPACES.
77	ERROR-CODE		PIC X.
77	I			PIC S9(5)	COMP.
77	J			PIC S9(5)	COMP.
77	K			PIC S9(5)	COMP.
77	L			PIC S9(5)	COMP.
77	PROGRAM-KEY		PIC 9(5)	COMP.
77	NEXT-PROGRAM		PIC X(6).
01	END-SIDE	PIC X.
01	END-CHG REDEFINES END-SIDE.
	02 THE-SIDE	PIC 9.
01	ELEM-NO.
	02 ELE-NUM	PIC XX.
01	NO-ELEM REDEFINES ELEM-NO.
	02 NUM-ELE	PIC 99.
01	DATA-STORAGE.
	02 DATA-A	PIC X(8)	OCCURS 29 TIMES.
01	THE-DATA.
	02 DATA-17.
	  03 DATA-16.
	    04 DATA-14.
	      05 DATA-12.
	        06 DATA-1	PIC X.
	        06 DATA-2	PIC X.
	      05 DATA-3		PIC XX.
	    04 DATA-4		PIC XX.
	  03 DATA-5		PIC X.
	02 DATA-6		PIC X.
01	A-DATA REDEFINES THE-DATA.
	02 DATA-18	PIC 9(8).
01	PROGRAM-ZERO.
	02 FILLER		PIC X(80).
	02 PROGRAM-REC-NO	PIC 9(5).
	02 PROGRAM-LAST-REC	PIC 9(5).
01	PROGRAM-MAIN.
	02 PROGRAM-PAGE		PIC 99.
	02 PROGRAM-LINE		PIC 999.
	02 PROGRAM-FORM		PIC X.
	02 PROGRAM-INFO.
	  03 FILLER		PIC X.
	  03 STAR-COMMENT	PIC X(67).
	02 PROGRAM-IDENT	PIC X(6).
	02 PROGRAM-ACT-REC	PIC 9(5).
	02 PROGRAM-FILL		PIC 9(5).
01	PROG-INFO.
	02 FILENAME.
	  03 THE-STARE	PIC X.
	  03 FILLER	PIC X(7).
	02 FIL-TYP	PIC X.
	02 FIL-DES	PIC X.
	02 END-FIL	PIC X.
	02 SEQUENCE	PIC X.
	02 FIL-FOR	PIC X.
	02 BLO-LEN	PIC X(4).
	02 LEN-BLO REDEFINES BLO-LEN	PIC ZZZ9.
	02 REC-LEN	PIC X(4).
	02 LEN-REC REDEFINES REC-LEN	PIC ZZZ9.
	02 MOD-PRO	PIC X.
	02 LEN-KEY	PIC XX.
	02 KEY-LEN REDEFINES LEN-KEY	PIC Z9.
	02 REC-ADD	PIC X.
	02 FIL-ORG	PIC X.
	02 OVE-IND	PIC XX.
	02 KEY-FIE	PIC X(4).
	02 FIE-KEY REDEFINES KEY-FIE	PIC ZZZ9.
	02 EXT-COD	PIC X.
	02 DEVICE	PIC X(7).
	02 SYM-DEV	PIC X(6).
	02 CON-LIN	PIC X.
	02 CON-OPT	PIC X(6).
	02 CON-ENT	PIC X(6).
	02 ENT-CON REDEFINES CON-ENT	PIC Z(5)9.
	02 FIL-ADD	PIC X.
	02 FILLER	PIC X.
	02 NUM-EXT	PIC XX.
	02 EXT-NUM REDEFINES NUM-EXT	PIC Z9.
	02 TAP-REW	PIC X.
	02 FIL-CON	PIC XX.
	02 FILLER	PIC XX.
01	PROG-COMMENT.
	02 THE-STAR	PIC X	VALUE "*".
	02 THE-COMMENT	PIC X(67).
01	TUBE-TITLE.
	02 TUBE-LINE-0.
	  03 FILLER		PIC X(4)	VALUE "PAGE".
	  03 DISPLAY-PAGE	PIC ZZZ.
	  03 FILLER		PIC X(5)	VALUE " LINE".
	  03 DISPLAY-LINE	PIC Z(4).
	  03 FILLER		PIC X(19)	VALUE
	" F DATA CARD - SIDE".
	  03 DISPLAY-SIDE	PIC ZZ.
	02 TUBE-LINE-1	PIC X(48)	VALUE
	"ELEMENT ELEMENT                       ELEMENT".
	02 TUBE-LINE-2	PIC X(48)	VALUE
	"NUMBER  DESCRIPTION                   [ENTRY]".
01	TUBE-DISPLAY.
	02 FILLER	PIC X(40)	VALUE
	"FILENAME                      [        ]".
	02 FILLER	PIC X(40)	VALUE
	"FILE TYPE                     [ ]".
	02 FILLER	PIC X(40)	VALUE
	"FILE DESIGNATION              [ ]".
	02 FILLER	PIC X(40)	VALUE
	"END OF FILE                   [ ]".
	02 FILLER	PIC X(40)	VALUE
	"SEQUENCE                      [ ]".
	02 FILLER	PIC X(40)	VALUE
	"FILE FORMAT                   [ ] ".
	02 FILLER	PIC X(40)	VALUE
	"BLOCK LENGTH                  [    ]".
	02 FILLER	PIC X(40)	VALUE
	"RECORD LENGTH                 [    ]".
	02 FILLER	PIC X(40)	VALUE
	"MODE OF PROCESSING            [ ]".
	02 FILLER	PIC X(40)	VALUE
	"LENGTH OF KEY FIELD OR            ".
	02 FILLER	PIC X(40)	VALUE
	"RECORD ADDRESS FIELD          [  ]".
	02 FILLER	PIC X(40)	VALUE
	"RECORD ADDRESS TYPE           [ ]".
	02 FILLER	PIC X(40)	VALUE
	"FILE ORGANIZATION OR             ".
	02 FILLER	PIC X(40)	VALUE
	"ADDITIONAL I/O AREA           [ ]".
	02 FILLER	PIC X(40)	VALUE
	"OVERFLOW INDICATION           [  ]".
	02 FILLER	PIC X(40)	VALUE
	"KEY FIELD STARTING LOCATION   [    ]".
	02 FILLER	PIC X(40)	VALUE
	"EXTENSION CODE                [ ]".
	02 FILLER	PIC X(40)	VALUE
	"DEVICE                        [       ]".
	02 FILLER	PIC X(40)	VALUE
	"SYMBOLIC DEVICE               [      ]".
	02 FILLER	PIC X(40)	VALUE
	"CONTINUATION LINES OR            ".
	02 FILLER	PIC X(40)	VALUE
	"LABELS                        [ ]".
	02 FILLER	PIC X(40)	VALUE
	"CONTINUATION LINES OPTION OR          ".
	02 FILLER	PIC X(40)	VALUE
	"NAME OF LABEL EXIT            [      ]".
	02 FILLER	PIC X(40)	VALUE
	"CONTINUATION LINE ENTRY OR            ".
	02 FILLER	PIC X(40)	VALUE
	"CORE INDEX                    [      ]".
	02 FILLER	PIC X(40)	VALUE
	"FILE ADDITION                 [ ]".
	02 FILLER	PIC X(40)	VALUE
	"NUMBER OF EXTENTS             [  ]".
	02 FILLER	PIC X(40)	VALUE
	"TAPE REWIND                   [ ]".
	02 FILLER	PIC X(40)	VALUE
	"FILE CONDITION                [  ]".
01	DISPLAY-TUBE REDEFINES TUBE-DISPLAY.
	02 FILLER	OCCURS 29 TIMES.
	  03 THE-TUBE	PIC X(40).
01	THE-NUMBER.
	02 II		PIC Z(5).
	02 FILLER	PIC XXX.
01	PROGRAM-IDENTIFICATION.
	02 PROGRAM-NAME		PIC X(6).
	02 PROGRAM-EXT		PIC XXX		VALUE "TMP".
01	PASS-IT.
	02 THE-FILE	PIC X(6).
	02 THE-TERM	PIC X.
	02 THE-ACTION	PIC XXX.
	02 THE-PAGE	PIC 99.
	02 THE-LINE	PIC 999.
	02 THE-FORM	PIC X.
	02 R-TYPE	PIC X.
01	ALL-DATA.
	02 ALL-1	PIC X.
	02 ALL-23.
	  03 ALL-2	PIC X.
	  03 ALL-3	PIC X.
	02 FILLER	PIC X(5).
PROCEDURE DIVISION.
START SECTION.
BEGIN.
	ENTER MACRO TRAP.
	MOVE SPACES TO PASS-IT.
*	DISPLAY "PASS-IT = " WITH NO ADVANCING ACCEPT PASS-IT.
	ENTER MACRO GTPRMS USING PASS-IT "X".
	IF THE-TERM = "A" OR "D" OR "V" OR "3" OR "B"
		GO TO CONT-PROG.
	DISPLAY "THE DRIVER PROGRAM WAS NOT USED".
	STOP RUN.
CONT-PROG.
	PERFORM CLEAR-SCREEN.
	ENTER MACRO SETTY USING "NO CRLF".
	ENTER MACRO SETTY USING "WIDTH 80".
	ENTER MACRO SETTY USING "FORM".
	MOVE THE-FILE TO PROGRAM-NAME.
	MOVE ZERO TO THE-SIDE.
	IF THE-ACTION = "CHG"
		PERFORM FIND-REC THRU END-FIND-REC
		PERFORM FIND-SIDE THRU END-FIND-SIDE
		GO TO CONT-SIDE.
NEW-SIDE.
	ADD 1 TO THE-SIDE.
	IF THE-SIDE = 1
		MOVE 3 TO I
		MOVE 17 TO FINAL-VALUE.
	IF THE-SIDE = 2
		MOVE 17 TO I
		MOVE 32 TO FINAL-VALUE.
	IF THE-SIDE > 2
		GO TO END-DISPLAY.
CONT-SIDE.
	PERFORM CLEAR-SCREEN.
	IF END-CHG = "E"
		CLOSE PROGRAM-FILE
		GO TO END-IT.
	IF THE-STARE = "*"
		MOVE 1 TO K
		MOVE THE-STARE TO DATA-1
		GO TO COMMENT-CHECK.
	MOVE THE-PAGE TO DISPLAY-PAGE.
	MOVE THE-LINE TO DISPLAY-LINE.
	MOVE THE-SIDE TO DISPLAY-SIDE.
	DISPLAY TUBE-LINE-0.
	DISPLAY TUBE-LINE-1.
	DISPLAY TUBE-LINE-2.
LOOP-DISPLAY.
	ADD 1 TO I.
	IF I > FINAL-VALUE GO TO END-DISPLAY.
	SUBTRACT 3 FROM I GIVING K.
	MOVE K TO L.
	IF THE-SIDE = 2
		SUBTRACT 2 FROM K GIVING L.
	MOVE L TO II.
	IF THE-SIDE = 1
		AND I > 14
		SUBTRACT 1 FROM L
		MOVE L TO II.
	IF THE-SIDE = 2
		AND I > 24
		SUBTRACT 1 FROM L
		MOVE L TO II.
	IF THE-SIDE = 2
		AND I > 26
		SUBTRACT 1 FROM L
		MOVE L TO II.
	IF THE-SIDE = 2
		AND I > 28
		SUBTRACT 1 FROM L
		MOVE L TO II.
	MOVE 1 TO J.
	IF THE-SIDE = 2
		SUBTRACT 14 FROM I.
	PERFORM CURSOR.
	IF THE-SIDE = 1
		AND (I = 14 OR 17)
		MOVE SPACE TO II.
	IF THE-SIDE = 2
		AND (I = 10 OR 12 OR 14)
		MOVE SPACE TO II.
	DISPLAY THE-NUMBER THE-TUBE (K) WITH NO ADVANCING.
	MOVE 40 TO J.
	PERFORM CURSOR.
	DISPLAY DATA-A (K).
	IF THE-SIDE = 2
		ADD 14 TO I.
	GO TO LOOP-DISPLAY.
END-DISPLAY.
	IF THE-ACTION = "CHG"
		GO TO FIND-NUMBER.
	IF THE-ACTION = "ADD" AND THE-SIDE = 1
		MOVE 3 TO I
		MOVE 15 TO FINAL-VALUE.
	IF THE-ACTION = "ADD" AND THE-SIDE = 2
		MOVE 15 TO I
		MOVE 27 TO FINAL-VALUE.
	IF THE-ACTION = "ADD" AND THE-SIDE < 3
		GO TO ADD-IT.
	IF THE-ACTION = "ADD" AND THE-SIDE > 2
		PERFORM CLEAR-SCREEN
		PERFORM WRITE-ADD THRU END-WRITE-ADD
		GO TO END-IT.
FIND-NUMBER.
	MOVE 23 TO I.
	MOVE 1 TO J.
	PERFORM CURSOR.
	DISPLAY "ELEMENT NUMBER = " WITH NO ADVANCING.
	MOVE SPACES TO ELE-NUM.
	DISPLAY ELE-NUM WITH NO ADVANCING.
	MOVE 18 TO J.
	PERFORM CURSOR.
	ACCEPT ELE-NUM.
	IF ELE-NUM = "EN"
		PERFORM CHG-REC THRU END-CHG-REC
		PERFORM CLEAR-SCREEN
		PERFORM FIND-SIDE THRU END-FIND-SIDE
		GO TO CONT-SIDE.
	MOVE NUM-ELE TO ELE-9.
	EXAMINE ELE-NUM REPLACING ALL SPACES BY ZERO.
	IF ELE-NUM IS NOT NUMERIC
		PERFORM BAD-NUMBER
		GO TO FIND-NUMBER.
	IF (THE-SIDE = 1) AND
		(ELE-9 < 1 OR ELE-9 > 12)
		PERFORM BAD-NUMBER
		GO TO FIND-NUMBER.
	IF (THE-SIDE = 2) AND
		(ELE-9 < 13 OR ELE-9 > 24)
		PERFORM BAD-NUMBER
		GO TO FIND-NUMBER.
	MOVE 23 TO I.
	MOVE 20 TO J.
	PERFORM CURSOR.
	PERFORM CLEAR-LINE.
	MOVE ELE-9 TO I.
	ADD 3 TO I.
BY-NUM.
	MOVE 40 TO J.
	SUBTRACT 3 FROM I GIVING K.
	MOVE K TO II.
	IF THE-SIDE = 2
		SUBTRACT 12 FROM I.
	IF THE-SIDE = 1
		AND K > 9
		ADD 1 TO I
		ADD 1 TO K
		MOVE K TO II.
	IF THE-SIDE = 1
		AND K > 12
		ADD 1 TO I
		ADD 1 TO K.
	IF THE-SIDE = 1
		AND (K = 11 OR 14)
		MOVE SPACE TO II.
	IF THE-SIDE = 2
		ADD 2 TO K.
	IF THE-SIDE = 2
		AND K > 19
		ADD 1 TO I
		ADD 1 TO K.
	IF THE-SIDE = 2
		AND K > 21
		ADD 1 TO I
		ADD 1 TO K.
	IF THE-SIDE = 2
		AND K > 23
		ADD 1 TO I
		ADD 1 TO K.
	IF THE-SIDE = 2
		AND K = 21 OR 23 OR 25
		MOVE SPACES TO II.
ACCEPT-CHG.
	PERFORM CURSOR.
	IF SIDE-CHANGE-CHECK = "X"
		MOVE SPACES TO SIDE-CHANGE-CHECK
		GO TO CHECK-SLASH.
	ACCEPT DATA-A (K).
	IF THE-ACTION = "ADD"
		MOVE DATA-A (K) TO ALL-DATA.
	IF ALL-1 = "/"
		MOVE SPACE TO DATA-A (K)
		GO TO CHECK-SLASH.
	IF K = 1 GO TO COMMENT-CHECK.
EDIT-IT.
	PERFORM THE-EDIT THRU END-THE-EDIT.
	IF ERROR-CODE = "X"
		MOVE SPACE TO ERROR-CODE
		MOVE 40 TO J
		PERFORM CURSOR
		GO TO ACCEPT-CHG.
	PERFORM CLEAN-IT.
	MOVE 40 TO J.
	PERFORM CURSOR.
	DISPLAY DATA-A (K).
	IF THE-ACTION = "ADD" GO TO LOOP-VALUE.
	GO TO FIND-NUMBER.
CHECK-SLASH.
	IF ALL-2 = "E"
		MOVE 2 TO THE-SIDE
		GO TO END-VALUE.
	IF ALL-23 = "S1"
		PERFORM CLEAN-IT
		MOVE ZERO TO THE-SIDE
		GO TO END-VALUE.
	IF ALL-23 = "S2"
		PERFORM CLEAN-IT
		MOVE 1 TO THE-SIDE
		GO TO END-VALUE.
	MOVE ALL-23 TO NUM-IT-2, HOLD-23.
	EXAMINE ALL-23 REPLACING ALL SPACES BY ZEROS.
	IF ALL-23 NOT NUMERIC
		GO TO BAD-ERROR.
	IF NUM-IT-2 < 1 OR NUM-IT-2 > 24
		GO TO BAD-ERROR.
	IF (THE-SIDE = 1) AND
		(NUM-IT-2 > 12 AND NUM-IT-2 < 25)
		MOVE HOLD-23 TO ALL-23
		MOVE "X" TO SIDE-CHANGE-CHECK
		MOVE 1 TO THE-SIDE
		GO TO END-VALUE.
	IF (THE-SIDE = 2) AND
		(NUM-IT-2 > 0 AND NUM-IT-2 < 13)
		MOVE HOLD-23 TO ALL-23
		MOVE "X" TO SIDE-CHANGE-CHECK
		MOVE ZERO TO THE-SIDE
		GO TO END-VALUE.
	MOVE NUM-IT-2 TO L.
	ADD 2 TO L.
	PERFORM CLEAN-IT.
	GO TO LOOP-VALUE.
BAD-ERROR.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " BAD SWITCH".
	MOVE 40 TO J.
	PERFORM CURSOR.
	GO TO ACCEPT-CHG.
CLEAN-IT.
	MOVE 49 TO J.
	PERFORM CURSOR.
	PERFORM CLEAR-LINE.
	MOVE 1 TO J.
	PERFORM CURSOR.
	IF THE-SIDE = 1
		AND K = 12
		MOVE 11 TO II.
	DISPLAY THE-NUMBER THE-TUBE (K) WITH NO ADVANCING.
COMMENT-CHECK.
	MOVE DATA-A (K) TO THE-DATA.
	IF DATA-1 NOT = "*" GO TO EDIT-IT.
	PERFORM CLEAR-SCREEN.
	IF THE-ACTION = "CHG"
		DISPLAY "OLD COM" STAR-COMMENT.
	DISPLAY "         1    1    2    2    3    3    4    4    5    5    6    6    7   7".
	DISPLAY "       8901234567890123456789012345678901234567890123456789012345678901234".
	DISPLAY "NEW COM" WITH NO ADVANCING ACCEPT THE-COMMENT.
	MOVE PROG-COMMENT TO PROG-INFO.
	IF THE-ACTION = "CHG"
		PERFORM CHG-REC THRU END-CHG-REC
		PERFORM CLEAR-SCREEN
		CLOSE PROGRAM-FILE
		GO TO END-IT.
	MOVE 2 TO THE-SIDE.
	GO TO NEW-SIDE.
BAD-NUMBER.
	MOVE 23 TO I.
	MOVE 20 TO J.
	PERFORM CURSOR.
	DISPLAY " BAD NUMBER " ELE-NUM.
FIND-REC.
	OPEN I-O PROGRAM-FILE.
	MOVE 1 TO PROGRAM-KEY.
	READ PROGRAM-FILE INVALID KEY
	DISPLAY "BAD READ CHG FILE " PROGRAM-KEY STOP RUN.
	MOVE PROGRAM-RECORD TO PROGRAM-ZERO.
LOOP-CHG.
	ADD 1 TO PROGRAM-KEY.
	IF PROGRAM-KEY > PROGRAM-LAST-REC
		DISPLAY "LOGIC ERROR IN PROGRAM" STOP RUN.
	READ PROGRAM-FILE INVALID KEY
	DISPLAY "BAD READ CHG FILE " PROGRAM-KEY STOP RUN.
	MOVE PROGRAM-RECORD TO PROGRAM-MAIN.
	IF PROGRAM-PAGE NOT = THE-PAGE GO TO LOOP-CHG.
	IF PROGRAM-LINE NOT = THE-LINE GO TO LOOP-CHG.
	MOVE PROGRAM-INFO TO PROG-INFO.
	MOVE FILENAME TO DATA-A (1).
	MOVE FIL-TYP TO DATA-A (2).
	MOVE FIL-DES TO DATA-A (3).
	MOVE END-FIL TO DATA-A (4).
	MOVE SEQUENCE TO DATA-A (5).
	MOVE FIL-FOR TO DATA-A (6).
	MOVE BLO-LEN TO DATA-A (7).
	MOVE REC-LEN TO DATA-A (8).
	MOVE MOD-PRO TO DATA-A (9).
	MOVE SPACE TO DATA-A (10).
	MOVE LEN-KEY TO DATA-A (11).
	MOVE REC-ADD TO DATA-A (12).
	MOVE SPACES TO DATA-A (13).
	MOVE FIL-ORG TO DATA-A (14).
	MOVE OVE-IND TO DATA-A (15).
	MOVE KEY-FIE TO DATA-A (16).
	MOVE EXT-COD TO DATA-A (17).
	MOVE DEVICE TO DATA-A (18).
	MOVE SYM-DEV TO DATA-A (19).
	MOVE SPACES TO DATA-A (20).
	MOVE CON-LIN TO DATA-A (21).
	MOVE SPACES TO DATA-A (22).
	MOVE CON-OPT TO DATA-A (23).
	MOVE SPACES TO DATA-A (24).
	MOVE CON-ENT TO DATA-A (25).
	MOVE FIL-ADD TO DATA-A (26).
	MOVE NUM-EXT TO DATA-A (27).
	MOVE TAP-REW TO DATA-A (28).
	MOVE FIL-CON TO DATA-A (29).
END-FIND-REC.
	EXIT.
FIND-SIDE.
	DISPLAY "SIDE = " WITH NO ADVANCING ACCEPT END-SIDE.
	IF END-SIDE = "E" GO TO END-FIND-SIDE.
	IF THE-SIDE = 1
		MOVE 3 TO I
		MOVE 17 TO FINAL-VALUE
		GO TO END-FIND-SIDE.
	IF THE-SIDE = 2
		MOVE 17 TO I
		MOVE 32 TO FINAL-VALUE
		GO TO END-FIND-SIDE.
	DISPLAY "BAD SIDE " THE-SIDE GO TO FIND-SIDE.
END-FIND-SIDE.
	EXIT.
CHG-REC.
	MOVE PROG-INFO TO PROGRAM-INFO.
	MOVE PROGRAM-MAIN TO PROGRAM-RECORD.
	WRITE PROGRAM-RECORD INVALID KEY
	DISPLAY "BAD WRITE CHG " PROGRAM-KEY STOP RUN.
END-CHG-REC.
	EXIT.
ADD-IT.
	MOVE I TO L.
LOOP-VALUE.
	ADD 1 TO L.
	IF L > FINAL-VALUE
		GO TO END-VALUE.
	MOVE L TO I.
	GO TO BY-NUM.
END-VALUE.
	PERFORM CLEAR-SCREEN.
	GO TO NEW-SIDE.
CURSOR.
	IF THE-TERM = "A" ENTER MACRO CURSER USING I,J.
	IF THE-TERM = "D" ENTER MACRO CA1520 USING I,J.
	IF THE-TERM = "V" ENTER MACRO CAVT52 USING I,J.
	IF THE-TERM = "3" ENTER MACRO CA3300 USING I,J.
	IF THE-TERM = "B" ENTER MACRO CAB100 USING I,J.
CLEAR-SCREEN.
	IF THE-TERM = "A" OR "D"
		ENTER MACRO TTYOUT USING 14.
	IF THE-TERM = "V"
		ENTER MACRO CLVT52.
	IF THE-TERM = "3"
		ENTER MACRO TTYOUT USING 35,37,37,37,37.
	IF THE-TERM = "B"
		ENTER MACRO CLB100.
CLEAR-LINE.
	IF THE-TERM = "A" OR "V" OR "B"
		DISPLAY CLEAR-IT WITH NO ADVANCING.
	IF THE-TERM = "D"
		ENTER MACRO TTYOUT USING 35.
	IF THE-TERM = "3"
		DISPLAY CLEAR-3300 WITH NO ADVANCING.
SIDE-2.
	IF THE-SIDE = 2
		ADD 14 TO I.
THE-EDIT.
	IF K = 1 PERFORM EDIT-1 THRU END-EDIT-1 GO TO END-THE-EDIT.
	IF K = 2 PERFORM EDIT-2 THRU END-EDIT-2 GO TO END-THE-EDIT.
	IF K = 3 PERFORM EDIT-3 THRU END-EDIT-3 GO TO END-THE-EDIT.
	IF K = 4 PERFORM EDIT-4 THRU END-EDIT-4 GO TO END-THE-EDIT.
	IF K = 5 PERFORM EDIT-5 THRU END-EDIT-5 GO TO END-THE-EDIT.
	IF K = 6 PERFORM EDIT-6 THRU END-EDIT-6 GO TO END-THE-EDIT.
	IF K = 7 PERFORM EDIT-7 THRU END-EDIT-7 GO TO END-THE-EDIT.
	IF K = 8 PERFORM EDIT-8 THRU END-EDIT-8 GO TO END-THE-EDIT.
	IF K = 9 PERFORM EDIT-9 THRU END-EDIT-9 GO TO END-THE-EDIT.
	IF K = 10 PERFORM EDIT-10 THRU END-EDIT-10 GO TO END-THE-EDIT.
	IF K = 11 PERFORM EDIT-11 THRU END-EDIT-11 GO TO END-THE-EDIT.
	IF K = 12 PERFORM EDIT-12 THRU END-EDIT-12 GO TO END-THE-EDIT.
	IF K = 13 PERFORM EDIT-13 THRU END-EDIT-13 GO TO END-THE-EDIT.
	IF K = 14 PERFORM EDIT-14 THRU END-EDIT-14 GO TO END-THE-EDIT.
	IF K = 15 PERFORM EDIT-15 THRU END-EDIT-15 GO TO END-THE-EDIT.
	IF K = 16 PERFORM EDIT-16 THRU END-EDIT-16 GO TO END-THE-EDIT.
	IF K = 17 PERFORM EDIT-17 THRU END-EDIT-17 GO TO END-THE-EDIT.
	IF K = 18 PERFORM EDIT-18 THRU END-EDIT-18 GO TO END-THE-EDIT.
	IF K = 19 PERFORM EDIT-19 THRU END-EDIT-19 GO TO END-THE-EDIT.
	IF K = 20 PERFORM EDIT-20 THRU END-EDIT-20 GO TO END-THE-EDIT.
	IF K = 21 PERFORM EDIT-21 THRU END-EDIT-21 GO TO END-THE-EDIT.
	IF K = 22 PERFORM EDIT-22 THRU END-EDIT-22 GO TO END-THE-EDIT.
	IF K = 23 PERFORM EDIT-23 THRU END-EDIT-23 GO TO END-THE-EDIT.
	IF K = 24 PERFORM EDIT-24 THRU END-EDIT-24 GO TO END-THE-EDIT.
	IF K = 25 PERFORM EDIT-25 THRU END-EDIT-25 GO TO END-THE-EDIT.
	IF K = 26 PERFORM EDIT-26 THRU END-EDIT-26 GO TO END-THE-EDIT.
	IF K = 27 PERFORM EDIT-27 THRU END-EDIT-27 GO TO END-THE-EDIT.
	IF K = 28 PERFORM EDIT-28 THRU END-EDIT-28 GO TO END-THE-EDIT.
	IF K = 29 PERFORM EDIT-29 THRU END-EDIT-29 GO TO END-THE-EDIT.
END-THE-EDIT.
	EXIT.
EDIT-1.
	MOVE DATA-A (1) TO THE-DATA.
	IF THE-DATA NOT = SPACE
		MOVE THE-DATA TO FILENAME
		MOVE FILENAME TO DATA-A (1)
		GO TO END-EDIT-1.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " SPACES ILLEGAL".
	MOVE "X" TO ERROR-CODE.
END-EDIT-1.
	EXIT.
EDIT-2.
	MOVE DATA-A (2) TO THE-DATA.
	IF DATA-1 = "I" OR "O" OR "U" OR "C" OR "D"
		MOVE DATA-1 TO FIL-TYP
		MOVE FIL-TYP TO DATA-A (2)
		GO TO END-EDIT-2.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER I,O,U,C OR D".
	MOVE "X" TO ERROR-CODE.
END-EDIT-2.
	EXIT.
EDIT-3.
	MOVE DATA-A (3) TO THE-DATA.
	IF DATA-1 = SPACE OR "P" OR "S" OR "C" OR "R" OR "T" OR "D"
		MOVE DATA-1 TO FIL-DES
		MOVE FIL-DES TO DATA-A (3)
		GO TO END-EDIT-3.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,P,S,C,R, OR D".
	MOVE "X" TO ERROR-CODE.
END-EDIT-3.
	EXIT.
EDIT-4.
	MOVE DATA-A (4) TO THE-DATA.
	IF DATA-1 = SPACE OR "E"
		MOVE DATA-1 TO END-FIL
		MOVE END-FIL TO DATA-A (4)
		GO TO END-EDIT-4.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR E".
	MOVE "X" TO ERROR-CODE.
END-EDIT-4.
	EXIT.
EDIT-5.
	MOVE DATA-A (5) TO THE-DATA.
	IF DATA-1 = SPACE OR "A" OR "D"
		MOVE DATA-1 TO SEQUENCE
		MOVE SEQUENCE TO DATA-A (5)
		GO TO END-EDIT-5.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,A, OR D".
	MOVE "X" TO ERROR-CODE.
END-EDIT-5.
	EXIT.
EDIT-6.
	MOVE DATA-A (6) TO THE-DATA.
	IF DATA-1 = "F" OR "V" OR "D"
		MOVE DATA-1 TO FIL-FOR
		MOVE FIL-FOR TO DATA-A (6)
		GO TO END-EDIT-6.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER ,F,V, OR D".
	MOVE "X" TO ERROR-CODE.
END-EDIT-6.
	EXIT.
EDIT-7.
	MOVE DATA-A (7) TO THE-DATA.
	IF DATA-14 = SPACES
		MOVE DATA-14 TO BLO-LEN
		MOVE BLO-LEN TO DATA-A (7)
		GO TO END-EDIT-7.
	MOVE DATA-14 TO NUM-IT-4.
	EXAMINE THE-DATA REPLACING ALL SPACES BY ZEROS.
	IF DATA-14 NOT NUMERIC GO TO ERROR-7.
	IF ((NUM-IT-4 > ZERO) AND (NUM-IT-4 < 10000))
		MOVE NUM-IT-4 TO LEN-BLO
		MOVE BLO-LEN TO DATA-A (7)
		GO TO END-EDIT-7.
ERROR-7.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR 1-9999".
	MOVE "X" TO ERROR-CODE.
END-EDIT-7.
	EXIT.
EDIT-8.
	MOVE DATA-A (8) TO THE-DATA.
	MOVE DATA-14 TO NUM-IT-4.
	EXAMINE THE-DATA REPLACING ALL SPACES BY ZEROS.
	IF THE-DATA NOT NUMERIC GO TO ERROR-8.
	IF ((NUM-IT-4 > ZERO) AND (NUM-IT-4 < 10000))
		MOVE NUM-IT-4 TO LEN-REC
		MOVE REC-LEN TO DATA-A (8)
		GO TO END-EDIT-8.
ERROR-8.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER 1-9999".
	MOVE "X" TO ERROR-CODE.
END-EDIT-8.
	EXIT.
EDIT-9.
	MOVE DATA-A (9) TO THE-DATA.
	IF DATA-1 = SPACE OR "L" OR "R"
		MOVE DATA-1 TO MOD-PRO
		MOVE MOD-PRO TO DATA-A (9)
		GO TO END-EDIT-9.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,L, OR R".
	MOVE "X" TO ERROR-CODE.
END-EDIT-9.
	EXIT.
EDIT-10.
END-EDIT-10.
	EXIT.
EDIT-11.
	MOVE DATA-A (11) TO THE-DATA.
	IF DATA-12 = SPACES
		MOVE DATA-12 TO LEN-KEY
		MOVE LEN-KEY TO DATA-A (11)
		GO TO END-EDIT-11.
	MOVE DATA-12 TO NUM-IT-2.
	EXAMINE THE-DATA REPLACING ALL SPACES BY ZEROS.
	IF THE-DATA NOT NUMERIC GO TO ERROR-11.
	IF ((NUM-IT-2 > ZERO) AND (NUM-IT-2 < 24))
		MOVE NUM-IT-2 TO KEY-LEN
		MOVE LEN-KEY TO DATA-A (11)
		GO TO END-EDIT-11.
ERROR-11.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR 1-23".
	MOVE "X" TO ERROR-CODE.
END-EDIT-11.
	EXIT.
EDIT-12.
	MOVE DATA-A (12) TO THE-DATA.
	IF DATA-1 = SPACE OR "A" OR "I" OR "P"
		MOVE DATA-1 TO REC-ADD
		MOVE REC-ADD TO DATA-A (12)
		GO TO END-EDIT-12.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,A,I, OR P".
	MOVE "X" TO ERROR-CODE.
END-EDIT-12.
	EXIT.
EDIT-13.
END-EDIT-13.
	EXIT.
EDIT-14.
	MOVE DATA-A (14) TO THE-DATA.
	IF (DATA-1 = SPACE OR "I" OR "T")
		MOVE DATA-1 TO FIL-ORG
		GO TO END-EDIT-14.
	MOVE DATA-1 TO NUM-IT-1.
	EXAMINE THE-DATA REPLACING ALL SPACES BY ZEROS.
	IF THE-DATA NOT NUMERIC GO TO ERROR-14.
	IF ((NUM-IT-1 > ZERO) AND (NUM-IT-1 < 10))
		MOVE NUM-IT-1 TO FIL-ORG
		MOVE FIL-ORG TO DATA-A (14)
		GO TO END-EDIT-14.
ERROR-14.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,I,T, OR 1-9".
	MOVE "X" TO ERROR-CODE.
END-EDIT-14.
	EXIT.
EDIT-15.
	MOVE DATA-A (15) TO THE-DATA.
	IF (DATA-12 = SPACE OR "OA" OR "OB" OR "OC" OR  "OD" OR
		"OE" OR "OF" OR "OG" OR "OV")
		MOVE DATA-12 TO OVE-IND
		MOVE OVE-IND TO DATA-A (15)
		GO TO END-EDIT-15.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,OA-OG, OR OV".
	MOVE "X" TO ERROR-CODE.
END-EDIT-15.
	EXIT.
EDIT-16.
	MOVE DATA-A (16) TO THE-DATA.
	IF DATA-14 = SPACES
		MOVE DATA-14 TO KEY-FIE
		MOVE KEY-FIE TO DATA-A (16)
		GO TO END-EDIT-16.
	MOVE DATA-14 TO NUM-IT-4.
	EXAMINE THE-DATA REPLACING ALL SPACES BY ZEROS.
	IF THE-DATA IS NOT NUMERIC GO TO ERROR-16.
	IF ((NUM-IT-4 > ZERO) AND (NUM-IT-4 < 10000))
		MOVE NUM-IT-4 TO FIE-KEY
		MOVE KEY-FIE TO DATA-A (16)
		GO TO END-EDIT-16.
ERROR-16.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR 1-9999".
	MOVE "X" TO ERROR-CODE.
END-EDIT-16.
	EXIT.
EDIT-17.
	MOVE DATA-A (17) TO THE-DATA.
	IF DATA-1 = SPACE OR "E" OR "L"
		MOVE DATA-1 TO EXT-COD
		GO TO END-EDIT-17.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,E, OR L".
	MOVE "X" TO ERROR-CODE.
END-EDIT-17.
	EXIT.
EDIT-18.
	MOVE DATA-A (18) TO THE-DATA.
	IF DATA-17 = "MFCU1" OR "MFCU2" OR "PRINTER" OR
		"PRINTR2" OR "PRINT84" OR "CONSOLE" OR "DISK" OR
		"DISK45" OR "TAPE" OR "SPECIAL" OR "CRT77" OR
		"READ01" OR "MFCM1" OR "MFCM2" OR "READ42" OR
		"BSCA" OR SPACES OR "DISKET" OR "DISK40"
		MOVE DATA-17 TO DEVICE
		MOVE DEVICE TO DATA-A (18)
		GO TO END-EDIT-18.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER LEGAL DEVICE".
	MOVE "X" TO ERROR-CODE.
END-EDIT-18.
	EXIT.
EDIT-19.
	MOVE DATA-A (19) TO THE-DATA.
	MOVE DATA-16 TO SYM-DEV.
	MOVE SYM-DEV TO DATA-A (19).
END-EDIT-19.
	EXIT.
EDIT-20.
END-EDIT-20.
	EXIT.
EDIT-21.
	MOVE DATA-A (21) TO THE-DATA.
	IF DATA-1 = SPACE OR "K"
		MOVE DATA-1 TO CON-LIN
		MOVE CON-LIN TO DATA-A (21)
		GO TO END-EDIT-21.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR K".
	MOVE "X" TO ERROR-CODE.
END-EDIT-21.
	EXIT.
EDIT-22.
END-EDIT-22.
	EXIT.
EDIT-23.
	MOVE DATA-A (23) TO THE-DATA.
	IF (DATA-A (21) = "K") AND (DATA-16 = "ASCII" OR
		"BUFOFF" OR "INDEX")
		MOVE DATA-16 TO CON-OPT
		MOVE CON-OPT TO DATA-A (23)
		GO TO END-EDIT-23.
	IF (DATA-A (21) = SPACE) AND (DATA-16 = "SUBRXX" OR
		"SRYZZZ" OR SPACES)
		MOVE DATA-16 TO CON-OPT
		MOVE CON-OPT TO DATA-A (23)
		GO TO END-EDIT-23.
	MOVE DATA-16 TO CON-OPT
	GO TO END-EDIT-23.
END-EDIT-23.
	EXIT.
EDIT-24.
END-EDIT-24.
	EXIT.
EDIT-25.
	MOVE DATA-A (25) TO THE-DATA.
	IF DATA-16 = SPACES
		MOVE DATA-16 TO CON-ENT
		MOVE CON-ENT TO DATA-A (25)
		GO TO END-EDIT-25.
	MOVE DATA-16 TO NUM-IT-6.
	EXAMINE THE-DATA REPLACING ALL SPACES BY ZEROS.
	IF THE-DATA NOT NUMERIC GO TO ERROR-25.
	IF (DATA-A (21) = "K") AND (NUM-IT-6 < 100)
		MOVE NUM-IT-6 TO ENT-CON
		MOVE CON-ENT TO DATA-A (25)
		GO TO END-EDIT-25.
	IF (DATA-A (21) = SPACE)
		AND (NUM-IT-6 > 5 AND NUM-IT-6 < 10000)
		MOVE NUM-IT-6 TO ENT-CON
		MOVE CON-ENT TO DATA-A (25)
		GO TO END-EDIT-25.
ERROR-25.
	MOVE 49 TO J.
	PERFORM CURSOR.
	IF DATA-A (21) = "K"
		DISPLAY " ENTER , , OR 0-99".
	IF DATA-A (21) = SPACE
		DISPLAY " ENTER , , OR 6-9999".
	MOVE "X" TO ERROR-CODE.
END-EDIT-25.
	EXIT.
EDIT-26.
	MOVE DATA-A (26) TO THE-DATA.
	IF DATA-1 = SPACE OR "A" OR "U"
		MOVE DATA-1 TO FIL-ADD
		MOVE FIL-ADD TO DATA-A (26)
		GO TO END-EDIT-26.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,A, OR U".
	MOVE "X" TO ERROR-CODE.
END-EDIT-26.
	EXIT.
EDIT-27.
	MOVE DATA-A (27) TO THE-DATA.
	IF DATA-12 = SPACES
		MOVE DATA-12 TO NUM-EXT
		GO TO END-EDIT-27.
	MOVE DATA-12 TO NUM-IT-2.
	EXAMINE THE-DATA REPLACING ALL SPACES BY ZEROS.
	IF THE-DATA NOT NUMERIC GO TO ERROR-27.
	IF (NUM-IT-2 > ZERO AND NUM-IT-2 < 51)
		MOVE NUM-IT-2 TO EXT-NUM
		MOVE NUM-EXT TO DATA-A (27)
		GO TO END-EDIT-27.
ERROR-27.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR 1-50".
	MOVE "X" TO ERROR-CODE.
END-EDIT-27.
	EXIT.
EDIT-28.
	MOVE DATA-A (28) TO THE-DATA.
	IF DATA-1 = SPACE OR "R" OR "U" OR "N"
		MOVE DATA-1 TO TAP-REW
		MOVE TAP-REW TO DATA-A (28)
		GO TO END-EDIT-28.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , ,R,U, OR N".
	MOVE "X" TO ERROR-CODE.
END-EDIT-28.
	EXIT.
EDIT-29.
	MOVE DATA-A (29) TO THE-DATA.
	IF DATA-12 = SPACES
		MOVE SPACES TO FIL-CON
		MOVE FIL-CON TO DATA-A (29)
		GO TO END-EDIT-29.
	IF DATA-1 NOT = "U"
		GO TO ERROR-29.
	IF DATA-2 > ZERO AND DATA-2 < 9
		MOVE DATA-12 TO FIL-CON
		MOVE FIL-CON TO DATA-A (29)
		GO TO END-EDIT-29.
ERROR-29.
	MOVE 49 TO J.
	PERFORM CURSOR.
	DISPLAY " ENTER , , OR U1-U8".
	MOVE "X" TO ERROR-CODE.
END-EDIT-29.
	EXIT.
WRITE-ADD.
	OPEN I-O PROGRAM-FILE.
	MOVE 1 TO PROGRAM-KEY.
	READ PROGRAM-FILE INVALID KEY
	DISPLAY "BAD READ " PROGRAM-KEY STOP RUN.
	MOVE PROGRAM-RECORD TO PROGRAM-ZERO.
	MOVE PROGRAM-LAST-REC TO PROGRAM-REC-NO PROGRAM-ACT-REC.
	ADD 1 TO PROGRAM-LAST-REC.
	MOVE PROGRAM-LAST-REC TO PROGRAM-KEY.
	MOVE THE-FILE TO PROGRAM-IDENT.
	MOVE THE-PAGE TO PROGRAM-PAGE.
	MOVE THE-LINE TO PROGRAM-LINE.
	MOVE "F" TO PROGRAM-FORM.
	MOVE PROG-INFO TO PROGRAM-INFO.
	MOVE PROGRAM-MAIN TO PROGRAM-RECORD.
WRITE-ADD-A.
	WRITE PROGRAM-RECORD INVALID KEY
	DISPLAY "BAD WRITE " PROGRAM-KEY STOP RUN.
	MOVE 1 TO PROGRAM-KEY.
	MOVE PROGRAM-ZERO TO PROGRAM-RECORD.
	WRITE PROGRAM-RECORD INVALID KEY
	DISPLAY "BAD WRITE " PROGRAM-KEY STOP RUN.
	CLOSE PROGRAM-FILE.
END-WRITE-ADD.
	EXIT.
END-IT.
	MOVE PROGRAM-NAME TO THE-FILE.
	MOVE "RPGSYS" TO NEXT-PROGRAM.
	ENTER MACRO SYSPRG USING NEXT-PROGRAM, PASS-IT.
END-PROGRAM.
	STOP RUN.
 
