      SUBROUTINE DASPAN(KONTRL,KONECT,IBUFFR,MAXBFR,LOWBFR,
         1    MANY  ,KIND  ,INIGOT,INCGOT,LMTGOT,INIVAL,INCVAL,
         2    LMTVAL,VALINI,VALINC,VALLMT)
C     RENBR(/INTERPRETS FREE FORMAT RANGE SPECIFICATIONS)
 C
  C     DONALD BARTH, HARVARD BUSINESS SCHOOL
C
  C     DASPAN EVALUATES RANGE SPECIFICATIONS  TYPED  BY  THE
    C     USER  AND READ BY THE CALLING PROGRAM WITH A MULTIPLE
    C     OF AN  A1  FORMAT.   SUCH  RANGE  SPECIFICATIONS  CAN
    C     CONSIST OF A SINGLE NUMBER, OR OF 2 NUMBERS SEPARATED
    C     BY AN ASTERISK, OR OF EITHER 2 OR 3 NUMBERS SEPARATED
                                  C     BY SLASHES OR BY COLONS WHICH ARE TAKEN AS EQUIVALENT
    C     TO SLASHES.    THE  ASTERISK  NOTATION  IS  MEANT  TO
    C     INDICATE THAT THE VALUE TO THE RIGHT OF THE  ASTERISK
    C     IS  TO  BE  REPEATED THE NUMBER OF TIMES INDICATED BY
    C     THE NUMBER TO THE  LEFT  OF  THE  ASTERISK.   NUMBERS
    C     SPECIFIED IN THE SLASH NOTATION CAN BE INTERPRETED AS
    C     THE LOWER AND UPPER BOUNDS OF A RANGE  IF  2  NUMBERS
    C     ARE  PRESENT,  OR  AS THE LOWER BOUND, THE INCREMENT,
    C     AND THE UPPER BOUND, IF 3 NUMBERS ARE INCLUDED.
C
                                                              C     DASPAN REPORTS TO THE  CALLING  PROGRAM  WHETHER  THE
    C     NUMBERS  ARE  PRESENT IN THE SERIES SPECIFICATION, AS
    C     WELL  AS  THE  VALUES  OF  THOSE  NUMBERS  WHICH  ARE
    C     PRESENT.   THE  CALLING  PROGRAM  WILL HAVE TO ASSIGN
    C     DEFAULT VALUES FOR ANY  NUMBERS  WHICH  ARE  MISSING.
    C     THE  RANGE  SPECIFICATION  /2/10  INDICATES  THAT THE
    C     RANGE IS TO EXTEND FROM THE DEFAULT LOWER BOUND  WITH
    C     AN  INCRMENT  OF  2  THROUGH  THE  UPPER BOUND OF 10.
    C     EITHER RANGE SPECIFICATION 1/10 OR 1//10 IS TAKEN  TO
                                                           C     MEAN  THAT  THE  RANGE IS TO EXTEND FROM 1 THROUGH 10
    C     WITH THE DEFAULT INCREMENT.  IF THE  NUMBERS  SPECIFY
    C     THE VALUES OF A SUBSCRIPT OF AN ARRAY, THEN A MISSING
    C     LOWER BOUND MIGHT  BE  TAKEN  TO  INDICATE  THAT  THE
    C     SUBSCRIPT BEING VARIED STARTS AT ITS MINIMUM POSSIBLE
    C     VALUE (USUALLY 1), WHILE A MISSING UPPER BOUND  MIGHT
    C     INDICATE  THAT  THE  SUBSCRIPT IS TO TERMINATE AT ITS
    C     MAXIMUM POSSIBLE VALUE.
    C
  C     TWO VERSIONS OF THE ROUTINE ARE SUPPLIED.  DASPAN CAN
    C     EVALUATE  REAL  NUMBERS AS WELL AS INTEGERS INCLUDING
                   C     E, K AND M NOTATIONS FOR SPECIFYING EITHER OF  THESE.
    C     IF  THE  CALLING PROGRAM DOES NOT OTHERWISE REFERENCE
    C     THE  FREE  FORMAT  INPUT  ROUTINE  DAHEFT,   IF   THE
    C     EVALUATION  OF  REAL  NUMBERS  IS  NOT NEEDED, AND IF
    C     INTEGERS CAN BE SPECIFIED WITHOUT RESORTING TO THE E,
    C     K  AND M NOTATIONS, THEN THE ROUTINE DAISPN SHOULD BE
    C     USED INSTEAD OF DASPAN.  NUMBERS EVALUATED BY  DAISPN
    C     MUST  CONSIST  ONLY  OF DIGITS FOLLOWING THE OPTIONAL
    C     SIGN.  DAISPN TREATS THE CHARACTERS ., %, K AND M THE
    C     SAME AS ANY OTHER DELIMITER CHARACTER.
    C
  C     FOLLOWING ARGUMENTS ARE USED FOR INPUT ONLY AND ARE
 C     RETURNED UNCHANGED.
   C
  C     KONTRL = 1  OR  GREATER,  ITEM  IN  IBUFFR  ARRAY  IS
    C              FLOATING  POINT.   IF POSSIBLE, THE FLOATING
    C              POINT  NUMBER  WILL  BE  ACCUMULATED  AS  AN
    C              INTEGER, THEN BE CONVERTED TO FLOATING POINT
    C              AND SHIFTED IF NECESSARY.   KONTRL  IS  THEN
    C              THE MAXIMUM NUMBER OF DIGITS IN THE INTEGER.
    C              THE VALUE IS OUTPUT AS THE  ARGUMENT  VALUE.
    C              IF  THE  ITEM  HAS  MORE THAN KONTRL DIGITS,
                             C              THEN  THE  ENTIRE  EVALUATION  IS  DONE   IN
    C              FLOATING    POINT.     THE    ADVANTAGE   OF
    C              CALCULATING THE  FLOATING  POINT  VALUES  IN
    C              INTEGER  AS  LONG  AS  THE  PRECISION OF THE
    C              COMPUTER  IS  NOT  OVERFLOWED  IS  THAT  THE
    C              CALCULATION  OF  THE  PORTION  OF THE NUMBER
    C              RIGHT OF THE DECIMAL POINT  IS  MORE  EXACT.
    C              AS  AN EXAMPLE, IF KONTRL IS GREATER THAN OR
    C              EQUAL TO 4, THEN THE  NUMBER  33.33  CAN  BE
                                                           C              STORED   AS   THE   INTEGER  3333,  THEN  BE
    C              CONVERTED TO FLOATING POINT VALUE 3333.0 AND
    C              DIVIDED   BY  100.0  TO  OBTAIN   THE  FINAL
    C              ANSWER.  IF IT MAKES NO  DIFFERENCE  WHETHER
    C              THE NUMBER TYPED AS 33.33 HAS VALUE 33.33 OR
    C              33.32999...  THEN KONTRL CAN  BE  GIVEN  THE
    C              VALUE 1.
C            = 0, ITEM IN IBUFFR ARRAY IS INTEGER  DECIMAL.
    C              THE NUMBER CAN BE TYPED WITH A DECIMAL POINT
    C              (FOR EXAMPLE 1.23K OR 1.23E3  EQUALS  1230),
                                  C              BUT  IS  STORED AS AN INTEGER IN DAHEFT, AND
    C              IS OUTPUT  AS ARGUMENT IVALUE.   ANY DECIMAL
    C              INTEGER WHICH THE COMPUTER CAN REPRESENT CAN
    C              BE  EVALUATED.    THIS  INCLUDES,   ON  TWOS
    C              COMPLEMENT  COMPUTERS, THE  LARGEST NEGATIVE
    C              NUMBER THE ABSOLUTE VALUE OF WHICH CANNOT BE
    C              STORED.   ON THE  PDP10,  A 36 BIT  COMPUTER
    C              WITH TWOS COMPLEMENT  NOTATION, THE RANGE OF
    C              DECIMAL  INTEGERS  IS  -34359738368  THROUGH
                                                           C              34359738367  (OCTAL NOTATION OF BIT PATTERNS
    C              BEING  400000000000  THROUGH  377777777777).
    C            = -1, ITEM IN  IBUFFR  ARRAY  IS  OCTAL.   THE
    C              NUMBER  CAN  BE  TYPED  WITH A DECIMAL POINT
    C              AND/OR  WITH  AN  EXPONENT.   HOWEVER,   THE
    C              NUMBER   FOLLOWING   THE  LETTER  E  OF  THE
    C              EXPONENT IS EVALUATED IN DECIMAL.  THE VALUE
    C              OF  THE  OCTAL  NUMBER  IS  RETURNED  AS THE
    C              ARGUMENT  IVALUE.   IT  MUST  BE NOTED  THAT
                                                           C              NUMBERS EVALUATED AS NEGATIVE OCTAL INTEGERS
    C              HAVE THE  NEGATIVE  OCTAL  INTEGER  AS THEIR
    C              VALUE,  NOT AS  THEIR BIT  REPRESENTATION IN
    C              COMPUTER STORAGE.   FOR EXAMPLE, ON A 36 BIT
    C              TWOS COMPLEMENT  COMPUTER,  THE OCTAL NUMBER
    C              -400000000000 (WHICH COULD  ALSO BE TYPED AS
    C              -4E11 OR -4E+11 WHERE  THE 11 AFTER THE E IS
    C              IN DECIMAL)  IS REPRESENTED  AS BIT  PATTERN
    C              HAVING OCTAL  NOTATION  400000000000 AND THE
                                                           C              OCTAL NUMBER -377777777777 IS REPRESENTED BY
    C              THE BIT PATTERN 400000000001.
    C     KONECT = -1, ONCE A SLASH, AN ASTERISK OR A NUMBER IS
    C              FOUND   IN  THE  IBUFFR  ARRAY,  THE  SERIES
    C              SPECIFICATION WILL EXTEND TO THE NEXT  SPACE
    C              OR  TAB CHARACTER, OR TO ANY CHARACTER OTHER
    C              THAN A SLASH OR AN ASTERISK WHICH IMMEDITELY
    C              FOLLOWS    A    NUMBER    IN    THE   SERIES
    C              SPECIFICATION.  IF KONECT=-1,  THEN THE TEXT
    C                   1/2+3/4 5/6+7/+8
                                C              WOULD CONTAIN THE RANGE SPECIFICATIONS 1  TO
    C              2, 3 TO 4, 5 TO 6, AND 7 TO 8.
   C            = 0, SPACES CAN APPEAR  BETWEEN THE NUMBERS OF
    C              A SERIES IN ADDITION TO SLASHES OR ASTERISK.
    C              THE SLASHES  OR THE  ASTERISK ARE,  HOWEVER,
    C              REQUIRED.
    C            = 1, SPACES AND/OR TAB  CHARACTERS CAN  APPEAR
    C              BETWEEN  THE NUMBERS OF A SERIES IN ADDITION
    C              TO OR IN PLACE OF SLASHES OR ASTERISKS.   IF
    C              KONECT=1, THEN THE TEXT
C                   1 2 3,4/5 6,7 8/9,10 / 11 12
               C              IS EXACTLY EQUIVALENT, EXCEPT FOR THE  VALUE
    C              OF  KIND  RETURNED  FOR THE FIRST SERIES, TO
    C              THE TEXT
C                   1/2/3,4/5/6,7/8/9,10/11/12
  C              THE FIRST  SERIES  (1  2  3)  IN  THE  FIRST
    C              EXAMPLE  WOULD  RETURN  KIND=6  INDICATING A
    C              SERIES IN  WHICH  NEITHER  A  SLASH  NOR  AN
    C              ASTERISK  APPEARED,  WHILE THE CORRESPONDING
    C              SERIES SPECIFICATION IN THE  SECOND  EXAMPLE
    C              WOULD RETURN KIND=7 INDICATING THAT AT LEAST
                                                 C              1  SLASH  WAS  ENCOUNTERED  IN  THE   SERIES
    C              SPECIFICATION.
    C     IBUFFR = INPUT  BUFFER  ARRAY  CONTAINING  CHARACTERS
    C              TYPED BY USER,  READ BY A  MULTIPLE OF AN A1
    C              FORMAT,  WHICH IS TO BE SEARCHED  FOR SERIES
    C              SPECIFICATIONS.   IBUFFR THEN  CONTAINS  ONE
    C              CHARACTER PER COMPUTER STORAGE LOCATION.
   C     MAXBFR = MAXIMUM SUBSCRIPT  OF  IBUFFR  ARRAY  TO  BE
    C              SEARCHED
C
  C     FOLLOWING ARGUMENTS ARE USED AS BOTH INPUT AND OUTPUT
    C
                                                         C     LOWBFR = INPUT CONTAINING THE  SUBSCRIPT  WITHIN  THE
    C              IBUFFR   ARRAY   OF   THE  FIRST  (LEFTMOST)
    C              CHARACTER WHICH CAN BE SCANNED FOR A  SERIES
    C              SPECIFICATION.    LOWBFR  WILL  BE  RETURNED
    C              POINTING TO THE NEXT  CHARACTER  BEYOND  THE
    C              SERIES  SPECIFICATION.   IF  KONECT IS .LE.0
    C              FORCING A SERIES  SPECIFICATION  TO  CONTAIN
    C              EITHER  A  SLASH  OR AN ASTERISK BETWEEN THE
    C              NUMBERS OF A SERIES, AND IF A SECOND  NUMBER
                                                           C              IMMEDIATELY   FOLLOWS   A  FIRST  WITHOUT  A
    C              SEPARATING SLASH OR  ASTERISK,  THEN  LOWBFR
    C              WILL  BE  RETURNED  POINTING  TO  THE  FIRST
    C              CHARACTER OF THE SECOND NUMBER.   IF  KONECT
    C              IS  -1  AND IF  EITHER  A  SPACE  OR  A  TAB
    C              CHARACTER FOLLOWS  A  SERIES  SPECIFICATION,
    C              THEN LOWBFR WILL BE RETURNED POINTING TO THE
    C              SPACE OR TAB CHARACTER.  IF KONECT IS .GE.0,
    C              ALLOWING SPACES AND TAB CHARACTERS TO APPEAR
                                                           C              WITHIN A SERIES SPECIFICATION,  THEN  LOWBFR
    C              WILL  BE  RETURNED  POINTING  TO  THE  FIRST
    C              CHARACTER TO THE RIGHT  OF  THE  SERIES  AND
    C              WHICH IS NOT ITSELF A SPACE, A TAB CHRACTER,
    C              A SLASH OR  AN  ASTERISK  AND  WHICH  CANNOT
    C              APPEAR WITHIN A NUMBER.  IF THERE IS NOTHING
    C              AT OR TO RIGHT OF LOWBFR, THEN  LOWBFR  WILL
    C              BE  LEFT  POINTING AT MAXBFR+1 AND KIND WILL
    C              BE RETURNED CONTAINING ONE.  LOWBFR AND MANY
                                                           C              MUST  BE  SET  BY THE CALLING PROGRAM BEFORE
    C              ANYTHING  IS  PROCESSED   IN   THE   CURRENT
    C              CONTENTS  OF  THE  IBUFFR  ARRAY,  BUT  THEN
    C              SHOULD  NOT  BE  MODIFIED  BY  THE   CALLING
    C              PROGRAM  UNTIL  THE  ENTIRE  CONTENTS OF THE
    C              IBUFFR ARRAY HAS BEEN PROCESSED.
 C     MANY   = SHOULD BE INPUT CONTAINING  ZERO  EACH  TIME
    C              THIS  ROUTINE  IS CALLED TO BEGIN PROCESSING
    C              OF A NEW LOGICAL SECTION  OF  TEXT,  AS  FOR
    C              EXAMPLE  WHEN BEGINNING PROCESSING OF A LINE
         C              OF TEXT NOT TIED TO THE PREVIOUS LINE BY  AN
    C              AMPERSAND  AT  THE END OF THE PREVIOUS LINE,
    C              OR WHEN PROCESSING THE TEXT TO THE RIGHT  OF
    C              A  SEMICOLON.   MANY IS RETURNED SET TO ZERO
    C              WHENEVER AN  END OF LINE  (KIND=1)  IS FOUND
    C              WHICH IS NOT  TIED TO THE  FOLLOWING LINE BY
    C              AN AMPERSAND,  AND  WHENEVER  A SEMICOLON IS
    C              FOUND (KIND=2). MANY IS RETURNED INCREMENTED
    C              BY 1 EACH TIME A  DESCRIPTION  OF  A  SERIES
                                                           C              SPECIFICATION  IS  RETURNED BY THIS ROUTINE,
    C              EACH TIME AN ERRONEOUS SERIES  SPECIFICATION
    C              IS  FOUND,  OR  EACH TIME AN INDICATION OF A
    C              MISSING SERIES SPECIFICATION IS FOUND.  KIND
    C              IS  RETURNED CONTAINING THE VALUE 3 AND MANY
    C              IS RETURNED CONTAINING THE NEGATIVE  OF  THE
    C              NUMBER  OF  ITEMS FOUND IF THE NEXT PRINTING
    C              CHARACTER FOLLOWING A COMMA IS AN AMPERSAND.
    C              MANY  SHOULD  NOT  BE CHANGED BY THE CALLING
                                                           C              PROGRAM  IF   AN   AMPERSAND   (KIND   BEING
    C              RETURNED=3)  IS  FOUND  INDICATING  THAT THE
    C              SUBSEQUENT  CALL  TO  THIS  ROUTINE  IS   TO
    C              PROCESS  TEXT  WHICH  IS  TO  BE  TREATED AS
    C              THOUGH IT APPEARED IN PLACE OF THE AMPERSAND
    C              AND THE CHARACTERS TO ITS RIGHT.  THE EFFECT
    C              IS NOT QUITE THE SAME AS  IF  THE  USER  HAD
    C              TYPED ALL OF THE TEXT ON A SINGLE LINE SINCE
    C              A  SINGLE  SERIES  SPECIFICATION  CANNOT  BE
    C              SPLIT ACROSS THE LINE BOUNDARY.
  C
  C              IF MANY IS INPUT CONTAINING  ZERO,  THEN  AN
    C              INITIAL  COMMA  IN  THE INPUT TEXT BUFFER IS
    C              TAKEN TO INDICATE AN INITIAL  MISSING  ITEM,
    C              AND  MANY IS THEN RETURNED CONTAINING 1.  IF
    C              MANY IS INPUT GREATER  THAN  ZERO,  THEN  AN
    C              INITIAL  COMMA  IS  IGNORED IF FOLLOWED BY A
    C              SERIES  SPECIFICATION.   IF  MANY  IS  INPUT
    C              GREATER  THAN  ZERO,  THEN  AN INITIAL COMMA
    C              FOLLOWED BY NO OTHER PRINTING CHARACTERS, BY
                                                           C              A  SEMICOLON,  OR  BY  AN  EXCLAMATION POINT
    C              INDICATES A MISSING ITEM.  IF MANY IS  INPUT
    C              GREATER  THAN  ZERO,  THEN  AN INITIAL COMMA
    C              FOLLOWED BY  AN  AMPERSAND  WILL  CAUSE  THE
    C              REMAINING  CHARACTERS  IN  THE  BUFFER TO BE
    C              IGNORED,   AND   MANY   WILL   BE   RETURNED
    C              CONTAINING  THE NEGATIVE OF ITS INPUT VALUE.
    C              IF  MANY  IS  INPUT  NEGATIVE,  THEN  IT  IS
    C              ASSUMED  THAT  THE  CONTENTS  OF THE CURRENT
                                                           C              BUFFER  CONTINUE  A  PREVIOUS   LINE   WHICH
    C              TERMINATED  WITH  A  COMMA  FOLLOWED  BY  AN
    C              AMPERSAND, AND MANY IS RETURNED GREATER THAN
    C              ZERO.
   C
  C     FOLLOWING ARGUMENTS ARE USED ONLY FOR OUTPUT
   C
  C     KIND   = RETURNED DESCRIBING THE KIND OF ITEM LOCATED
    C              IN THE IBUFFR ARRAY.
   C            = 1, EITHER NO PRINTING  CHARACTERS OR ELSE AN
    C              EXCLAMATION  POINT  AS  THE  FIRST  PRINTING
    C              CHARACTER (MARKING THE REST OF THE LINE AS A
                                                           C              COMMENT)  WAS FOUND  AT OR TO THE  RIGHT  OF
    C              LOWBFR.   THE  CALLING PROGRAM SHOULD READ A
    C              NEW LINE INTO IBUFFR.   MANY, INIGOT, INCGOT
    C              AND LMTGOT ARE ALL RETURNED WITH VALUE ZERO.
    C            = 2,  A  SEMICOLON  WAS  FOUND  AS  THE  FIRST
    C              PRINTING  CHARACTER  AT  OR  TO THE RIGHT OF
    C              LOWBFR.  LOWBFR IS RETURNED POINTING TO  THE
    C              NEXT  CHARACTER  BEYOND  THE LOCATION OF THE
    C              SEMICOLON.   IT  IS  ASSUMED   THE   CALLING
                                                           C              PROGRAM  WILL  TREAT  THE  APPEARANCE OF THE
    C              SEMICOLON AS MARKING THE END OF A STATEMENT.
    C              MANY IS RETURNED WITH THE VALUE ZERO.
 C            = 3, AN  AMPERSAND  WAS  FOUND  AS  THE  FIRST
    C              PRINTING  CHARACTER  AT  OR  TO THE RIGHT OF
    C              LOWBFR.   THE  TEXT  TO  THE  RIGHT  OF  THE
    C              AMPERSAND IS TAKEN AS A COMMENT SO LOWBFR IS
    C              RETURNED POINTING BEYOND THE  RIGHT  END  OF
    C              THE  BUFFER.  IT IS ASSUMED THAT THE CALLING
    C              PROGRAM WILL READ IN THE CONTENTS OF  A  NEW
    C              BUFFER,  THEN  AGAIN  REQUEST  A  NEW SERIES
    C              EVALUATION FROM THIS ROUTINE.   THE VALUE OF
    C              MANY MUST NOT BE CHANGED BY  CALLING PROGRAM
    C              PRIOR TO THIS FOLLOWING CALL.  THE EFFECT IS
    C              NOT  QUITE THE SAME AS IF THE USER HAD TYPED
    C              ALL OF THE TEXT ON A  SINGLE  LINE  SINCE  A
    C              SERIES  SPECIFICATION CANNOT BE SPLIT ACROSS
    C              A LINE BOUNDARY.
  C            = 4, A NUMBER OR SERIES SPECIFICATION WAS  NOT
    C              FOUND BUT INITIAL COMMA WAS FOUND INDICATING
                        C              A  MISSING  SERIES  SPECIFICATION.   INIGOT,
    C              INCGOT AND LMTGOT ARE EACH RETURNED WITH THE
    C              VALUE  ZERO  SO  KIND=4  CAN  BE  CONSIDERED
    C              EQUIVALENT  TO KIND=5 IF SUCH IS APPROPRIATE
    C              TO THE APPLICATION FOR WHICH THIS ROUTINE IS
    C              BEING USED.
  C            = 5, A SINGLE NUMBER WITH NEITHER A SLASH  NOR
    C              AN  ASTERISK  WAS FOUND IN THE INPUT BUFFER.
    C              BOTH  INIGOT   AND   LMTGOT   ARE   RETURNED
    C              CONTAINING 1, AND THE VALUE OF THE NUMBER IS
                             C              RETURNED EITHER IN BOTH INIVAL AND LMTVAL OR
    C              IN  BOTH  VALINI  AND  VALLMT,  WHICHEVER IS
    C              APPROPRIATE.  INCGOT IS RETURNED  CONTAINING
    C              ZERO.
   C            = 6, EITHER 2 OR 3  NUMBERS  WERE  FOUND,  BUT
    C              WITHOUT  SLASHES OR ASTERISKS.  THE VALUE OF
    C              THE  LEFT   NUMBER  IS  RETURNED  IN  EITHER
    C              INIVAL  OR  VALINI,  OF THE RIGHT  IN EITHER
    C              LMTVAL OR  VALLMT,  AND  OF  THE MIDDLE,  IF
    C              PRESENT,   IN   EITHER   INCVAL  OR  VALINC,
                                  C              WHICHEVER IS APPROPRIATE.  INIGOT AND LMTGOT
    C              ARE  EACH  RETURNED CONTAINING 1.  INCGOT IS
    C              RETURNED CONTAINING 1 ONLY IF 3 NUMBERS WERE
    C              FOUND.   KONECT  WOULD HAVE TO BE INPUT AS 1
    C              FOR KIND TO BE RETURNED AS 6.
    C            = 7, A SERIES SPECIFICATION CONTAINING ONE  OR
    C              MORE SLASHES WAS FOUND.  THE LOCATION OF THE
    C              SLASH OR SLASHES RELATIVE TO THE NUMBERS, IF
    C              ANY,   IN   THE   SERIES   SPECIFICATION  IS
    C              INDICATED BY THE RETURNED VALUES OF  INIGOT,
         C              INCGOT AND LMTGOT.
C            = 8,  A  SERIES  SPECIFICATION  CONTAINING   A
    C              SINGLE   ASTERISK   WAS  FOUND.   INCGOT  IS
    C              RETURNED CONTAINING ZERO.  THE  LOCATION  OF
    C              THE  ASTERISK  RELATIVE  TO  THE NUMBERS, IF
    C              ANY,  IN   THE   SERIES   SPECIFICATION   IS
    C              INDICATED  BY  THE RETURNED VALUES OF INIGOT
    C              AND LMTGOT.
  C            = 9, A SERIES SPECIFICATION  WAS  FOUND  WHICH
    C              INCLUDED  TOO MANY NUMBERS, TOO MANY SLASHES
                                                           C              OR TOO MANY ASTERISKS.  INIGOT,  INCGOT  AND
    C              LMTGOT ARE EACH RETURNED CONTAINING ZERO.
  C            = 10, FIRST PRINTING CHARACTER IN OR TO  RIGHT
    C              OF  LOWBFR  WAS  NOT A CHARACTER WHICH COULD
    C              APPEAR IN A NUMBER OR NUMBER RANGE, AND  WAS
    C              NOT A COMMA, SEMICOLON OR EXCLAMATION POINT.
    C              LOWBFR  IS  RETURNED  POINTING  TO  THE NEXT
    C              CHARACTER BEYOND THIS CHARACTER.
 C     INIGOT = 0, RETURNED IF THE CONTENTS OF THE BUFFER DO
    C              NOT  SPECIFY THE START OF THE RANGE.  INIVAL
              C              OR  VALINI,  WHICHEVER  IS  APPROPRIATE,  IS
    C              RETURNED UNDEFINED, BUT PROBABLY CHANGED.
  C            = 1, RETURNED IF THE CONTENTS  OF  THE  BUFFER
    C              SPECIFY  THE  START OF THE RANGE.  INIVAL OR
    C              VALINI,   WHICHEVER   IS   APPROPRIATE,   IS
    C              RETURNED CONTAINING THIS STARTING NUMBER.
  C     INCGOT = 0, RETURNED IF THE CONTENTS OF THE BUFFER DO
    C              NOT   SPECIFY  AN  INCREMENT  BY  WHICH  THE
    C              STARTING VALUE IS  TO  BE  VARIED  UNTIL  IT
    C              REACHES THE ENDING VALUE.  INCVAL OR VALINC,
    C              WHICHEVER  IS   APPROPRIATE,   IS   RETURNED
    C              UNDEFINED, BUT PROBABLY CHANGED.
 C            = 1, RETURNED IF THE CONTENTS  OF  THE  BUFFER
    C              SPECIFY  AN  INCREMENT BY WHICH THE STARTING
    C              VALUE IS TO BE VARIED UNTIL IT  REACHES  THE
    C              ENDING  VALUE.   INCVAL OR VALINC, WHICHEVER
    C              IS APPROPRIATE, IS RETURNED CONTAINING  THIS
    C              INCREMENT.
   C     LMTGOT = 0, RETURNED IF THE CONTENTS OF THE BUFFER DO
    C              NOT  SPECIFY  A NUMBER AT WHICH THE RANGE IS
                                            C              TO END.   LMTVAL  OR  VALLMT,  WHICHEVER  IS
    C              APPROPRIATE,   IS  RETURNED  UNDEFINED,  BUT
    C              PROBABLY CHANGED.
 C            = 1, RETURNED IF THE CONTENTS  OF  THE  BUFFER
    C              SPECIFY  A  NUMBER  AT WHICH THE RANGE IS TO
    C              END.   LMTVAL  OR   VALLMT,   WHICHEVER   IS
    C              APPROPRIATE,  IS  RETURNED  CONTAINING  THIS
    C              ENDING VALUE.
C     INIVAL = RETURNED CONTAINING THE START OF  THE  RANGE
    C              IF   THIS   IS  SPECIFIED  AND  IF  THIS  IS
                                                           C              EVALUATED AS AN INTEGER (KONTRL INPUT  .LE.0
    C              AND INIGOT RETURNED = 1)
    C     INCVAL = RETURNED CONTAINING THE INCREMENT IF THIS IS
    C              SPECIFIED  AND  IF  THIS  IS EVALUATED AS AN
    C              INTEGER  (KONTRL  INPUT  .LE.0  AND   INCGOT
    C              RETURNED = 1)
C     LMTVAL = RETURNED CONTAINING THE END OF THE RANGE  IF
    C              THIS  IS  SPECIFIED AND IF THIS IS EVALUATED
    C              AS AN INTEGER (KONTRL INPUT .LE.0 AND LMTGOT
    C              RETURNED = 1)
C     VALINI = RETURNED CONTAINING THE START OF  THE  RANGE
                   C              IF   THIS   IS  SPECIFIED  AND  IF  THIS  IS
    C              EVALUATED AS A FLOATING POINT NUMBER (KONTRL
    C              INPUT .GT.0 AND INIGOT RETURNED = 1)
  C     VALINC = RETURNED CONTAINING THE INCREMENT IF THIS IS
    C              SPECIFIED  AND  IF  THIS  IS  EVALUATED AS A
    C              FLOATING POINT NUMBER  (KONTRL  INPUT  .GT.0
    C              AND INCGOT RETURNED = 1)
    C     VALLMT = RETURNED CONTAINING THE END OF THE RANGE  IF
    C              THIS  IS  SPECIFIED AND IF THIS IS EVALUATED
    C              AS A FLOATING  POINT  NUMBER  (KONTRL  INPUT
                        C              .GT.0 AND LMTGOT RETURNED = 1)
   C
  C     EVALUATION  OF  RANGE  SPECIFICATIONS          LMTVAL
    C     SHOWN  BELOW WOULD  PRODUCE  ARGUMENT        INCVAL !
    C     VALUES TO THEIR RIGHT.  "U" INDICATES      INIVAL ! !
    C     THAT THE ARGUMENT IS UNDEFINED.        LMTGOT   ! ! !
    C                                          INCGOT !   ! ! !
    C                                        INIGOT ! !   ! ! !
    C     EMPTY  OR  /      OR  //     OR  *      0 0 0   U U U
    C     ///    OR  5///9  OR  5 2 2 9           0 0 0   U U U
    C     /9     OR  //9    OR  *9                0 0 1   U U 9
    C     /2/                                     0 1 0   U 2 U
    C     /2/9   OR  /2 9                         0 1 1   U 2 9
    C     5/     OR  5//    OR  5*                1 0 0   5 U U
    C     5                                       1 0 1   5 U 5
    C     5/9    OR  5//9   OR  5 9    OR  5*9    1 0 1   5 U 9
    C     5/2/   OR  5 2/                         1 1 0   5 2 U
    C     5/2/9  OR  5 2/9  OR  5/2 9  OR  5 2 9  1 1 1   5 2 9
    C
        DIMENSION IBUFFR(MAXBFR),IDIGIT(13)
        DATA IDIGIT/
     11H+,1H-,1H.,1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9/
                                                             DATA ISLASH,ICOLON,ISTAR,KOMENT,IEND,IAND,KOMMA,
         1ISPACE,ITAB/1H/,1H:,1H*,1H!,1H;,1H&,1H,,1H ,1H	/
          IRADIX=13
         IF(KONTRL.LT.0)IRADIX=11
         ISTATE=0
          KOUNT=0
      INIGOT=1
          KNTSEP=0
          LMTGOT=1
          KIND=1
       ITEST=2
      IF(MANY.GE.0)GO TO 1
        KIND=4
       MANY=-MANY
      1 IF(KONTRL.GT.0)GO TO 2
      INCVAL=0
          LMTVAL=0
          GO TO 4
    2 VALINC=0.
         VALLMT=0.
         GO TO 4
C
  C     TEST IF NEXT CHARACTER CAN BE IN SERIES SPECIFICATION
        3 LOWBFR=LOWBFR+1
      4 IF(LOWBFR.GT.MAXBFR)GO TO 22
          LETTER=IBUFFR(LOWBFR)
       IF(LETTER.EQ.ISPACE)GO TO 13
          IF(LETTER.EQ.ITAB)GO TO 13
       IF(LETTER.EQ.ISLASH)GO TO 11
          IF(LETTER.EQ.ICOLON)GO TO 11
          IF(LETTER.EQ.ISTAR)GO TO 10
      IF(LETTER.EQ.KOMENT)GO TO 20
          IF(LETTER.EQ.IEND)GO TO 14
       IF(LETTER.EQ.KOMMA)GO TO 9
       IF(LETTER.EQ.IAND)GO TO 15
       IF(KONECT.GT.0)GO TO 5
      IF(ISTATE.GT.0)GO TO 22
        5 IF(KONTRL.LT.-1)GO TO 7
          DO 6 I=1,IRADIX
        IF(LETTER.EQ.IDIGIT(I))GO TO 17
     6 CONTINUE
        7 IF(KIND.EQ.4)GO TO 8
        IF(KIND.NE.1)GO TO 22
     8 LOWBFR=LOWBFR+1
             KIND=10
      GO TO 22
    C
  C     TEST IF DELIMITER CHARACTER CAN PRECEDE A SERIES
        9 IF(KIND.NE.1)GO TO 22
       KIND=4
       IF(MANY.EQ.0)GO TO 23
       GO TO 3
C
  C     ASTERISK FOUND
      10 IF(KIND.EQ.7)ITEST=0
        IF(ITEST.GT.0)ITEST=1
       KIND=8
       GO TO 12
    C
  C     SLASH FOUND
    11 IF(KIND.EQ.8)ITEST=0
        KIND=7
    12 IF(KOUNT.EQ.0)INIGOT=0
      LMTGOT=0
          KNTSEP=KNTSEP+1
        ISTATE=-1
         GO TO 3
C
  C     SPACE FOUND
    13 IF(ISTATE.EQ.0)GO TO 3
      IF(KONECT.GE.0)GO TO 3
      GO TO 22
    C
  C     SEMICOLON FOUND
               14 IF(KIND.NE.1)GO TO 22
       LOWBFR=LOWBFR+1
        KIND=2
       GO TO 22
    C
  C     AMPERSAND FOUND
     15 IF(KIND.EQ.1)GO TO 16
       IF(KIND.NE.4)GO TO 22
       MANY=-MANY
     16 KIND=3
       GO TO 21
    C
  C     EVALUATE NUMBER AND PLACE INTO PUSH-DOWN STACK
    17 IF(KIND.LE.5)KIND=KOUNT+5
        KOUNT=KOUNT+1
          IF(ISTATE.LT.0)KNTSEP=KNTSEP-1
        ISTATE=1
          LMTGOT=1
          IF(KONTRL.GT.0)GO TO 18
          INIVAL=INCVAL
          INCVAL=LMTVAL
          GO TO 19
       18 VALINI=VALINC
          VALINC=VALLMT
                                                      C     IDUMMY PRESERVES VARIABLE LOCAL TO THIS ROUTINE
   19 CALL DAHEFT(KONTRL,1,0,IBUFFR,MAXBFR,
     1LOWBFR,IDUMMY,ISHIFT,JSHIFT,KSHIFT,LSHIFT,LMTVAL,
        2VALLMT)
      GO TO 4
C
  C     TEST IF TOO MANY ITEMS WERE FOUND IN SPECIFICATION
     20 IF(KIND.NE.1)GO TO 22
    21 LOWBFR=MAXBFR+1
     22 IF((KOUNT+KNTSEP-INIGOT).LE.ITEST)GO TO 23
      KIND=9
       GO TO 24
    C
  C     CONVERT PUSH-DOWN STACK INTO RANGE DESCRIPTION
    23 IF(KOUNT.GE.3)GO TO 30
      IF(KOUNT.EQ.2)GO TO 25
      IF(KOUNT.EQ.1)GO TO 27
   24 INIGOT=0
          LMTGOT=0
          GO TO 33
       25 IF(INIGOT.EQ.0)GO TO 30
          IF(KONTRL.GT.0)GO TO 26
          INIVAL=INCVAL
          GO TO 28
       26 VALINI=VALINC
          GO TO 28
       27 IF(INIGOT.NE.0)GO TO 31
       28 IF(LMTGOT.NE.0)GO TO 33
          IF(KONTRL.GT.0)GO TO 29
          INCVAL=LMTVAL
          GO TO 30
       29 VALINC=VALLMT
       30 INCGOT=1
          GO TO 34
       31 IF(KONTRL.GT.0)GO TO 32
          INIVAL=LMTVAL
          GO TO 33
       32 VALINI=VALLMT
       33 INCGOT=0
    C
  C     EVERYTHING IS IN ITS PLACE, RETURN TO CALLING ROUTINE
       34 IF(KIND.GT.3)MANY=MANY+1
         IF(KIND.LT.3)MANY=0
      35 RETURN
 C
                      C     KNTSEP = NUMBER OF SLASHES AND ASTERISKS NOT FOLLOWED
    C              BY A NUMBER.
 C     ISTATE = 1, WITHIN NUMBER
  C            = 0, SPACE
C            = -1, SLASH FOUND
   C     ITEST  = MAXIMUM NUMBER OF SLASHES OR ASTERISKS
C              ALLOWED IN A SINGLE SERIES SPECIFICATION.
  C     JSIGN  = -1, MINUS SIGN AT START OF NUMBER
C            = 0, NO SIGN AT START OF NUMBER
    C            = 1, PLUS SIGN AT START OF NUMBER
  C     KOUNT  = NUMBER OF NUMBERS ALREADY FOUND
  C
  C770127366001:!;&
       END
    
