	SUBROUTINE SEND(CMD, DISNUM, X, Y)
C************************************************************
C
C  THIS ROUTINE IS USED TO TRANSMIT COMMAND INFORMATION
C  TO THE GT40. IN GENERAL A COMMAND CONSISTS OF A
C  COMMAND WORD, FOLLOWED BY A DISPLAY NUMBER, FOLLOWED
C  BY X & Y CO-ORDINATES (IN RASTER UNITS). THIS ROUTINE
C  BREAKS EACH WORD INTO EIGHT BIT BYTES AND TRANSMITS
C  THEM TO THE GT40 IN IMAGE MODE. EACH COMMAND IS PRECEDED
C  BY A "1" BYTE (I.E. ^A) TO SIGNAL GIDUS THAT A COMMAND
C  IS COMING. IF THE DISLIB LOG IS ENABLED, THEN EACH
C  COMMAND TRANSMITTED WILL BE DUMPED IN THE LOG.
C
C  POSSIBLE ERRORS:
C	NONE
C
C  ROUTINES CALLED:
C	SETTTY - SETS TERMINAL CHARACTERISTICS FOR I/O
C	SNDCHR - TRANSMITS AN IMAGE BYTE TO THE GT40
C	BYTES  - SPLITS LOW ORDER 16 BITS OF A WORD INTO 2 BYTES
C
C************************************************************
	IMPLICIT INTEGER(A - Z)
	INTEGER COMAND(16,2)
	LOGICAL LOG
	COMMON /LOGBLK/ LOG, GTLOG, FATAL, WARN

	DATA (COMAND(1,I),I=1,2) /'ENABL', 'E    '/
	DATA (COMAND(2,I),I=1,2) /'DISAB', 'LE   '/
	DATA (COMAND(3,I),I=1,2) /'MOVE ', 'FILE '/
	DATA (COMAND(4,I),I=1,2) /'GET M', 'P    '/
	DATA (COMAND(5,I),I=1,2) /'GET A', 'P    '/
	DATA (COMAND(6,I),I=1,2) /'LPOFF', 'F    '/
	DATA (COMAND(7,I),I=1,2) /'LPON ', '     '/
	DATA (COMAND(8,I),I=1,2) /'LAST ', 'HIT  '/
	DATA (COMAND(9,I),I=1,2) /'NEW H', 'IT   '/
	DATA (COMAND(10,I),I=1,2) /'REQ T', 'O ADD'/
	DATA (COMAND(11,I),I=1,2) /'ADD B', 'LOCK '/
	DATA (COMAND(12,I),I=1,2) /'DELET', 'E    '/
	DATA (COMAND(13,I),I=1,2) /'RE-SE', 'ND   '/
	DATA (COMAND(14,I),I=1,2) /'CLEAR', '     '/
	DATA (COMAND(15,I),I=1,2) /'RESET', '     '/
	DATA (COMAND(16,I),I=1,2) /'OPT. ', 'HIT  '/

1	FORMAT(//5X,'SENDING: ',2A5,6(2X,'"',O3))
2	FORMAT(5X,'CHECKSUM = "',O3//)

	CALL SETTTY
	CALL SNDCHR(1)
	CALL BYTES(CMD, CMDL, CMDH)
	CALL SNDCHR(CMDL)
	CALL SNDCHR(CMDH)
	CALL BYTES(DISNUM, DISL, DISH)
	CALL SNDCHR(DISL)
	CALL SNDCHR(DISH)
	CALL BYTES(X, XL, XH)
	CALL SNDCHR(XL)
	CALL SNDCHR(XH)
	CALL BYTES(Y, YL, YH)
	CALL SNDCHR(YL)
	CALL SNDCHR(YH)
	CSUM=CMDL+CMDH+DISL+DISH+XL+XH+YL+YH
	CSUM = -CSUM .AND. "377
	CALL SNDCHR(CSUM)

	IF(.NOT. LOG) RETURN
	WRITE(GTLOG, 1) (COMAND(CMD,I),I=1,2), DISL, DISH,
	1                XL, XH, YL, YH
	WRITE(GTLOG, 2) CSUM
	RETURN
	END
