	SUBROUTINE ENABLE(DISNUM)
C************************************************************
C
C  THIS SUBROUTINE IS USED TO ENABLE (I.E. TURN ON)
C  A DISPLAY FILE, THAT ALREADY EXISTS IN THE GT40
C
C  POSSIBLE ERRORS:
C	%TRYING TO ENABLE A NON-EXISTENT DISPLAY
C	%TRYING TO ENABLE AN ILLEGAL DISPLAY NUMBER
C	?INVALID REPLY FROM GT40 (RETURNS DISNUM = 0)
C
C  ROUTINES CALLED:
C	SEND   - SEND COMMAND TO GT40
C	GET    - GET STATUS TRANSMISSION FROM GT40
C	ERROR  - ERROR LOGGING ROUTINE
C
C************************************************************
	IMPLICIT INTEGER (A - Z)

100	CALL SEND(1, DISNUM, 0, 0)
	CALL GET(STATUS, X, Y, DNUM)
	IF(STATUS .EQ. "66) GO TO 100
	IF(STATUS .EQ. 0) RETURN

	IF(STATUS .NE. 1) GO TO 200
	CALL ERROR('%TRYING TO ENABLE A NON-EXISTENT DISPLAY =', DISNUM)
	RETURN

200	IF(STATUS .NE. 3) GO TO 300
	CALL ERROR('%TRYING TO ENABLE A BAD DISPLAY # =', DISNUM)
	RETURN

300	CALL ERROR('?INVALID RESPONSE TO ENABLE, STATUS =', STATUS)
	DISNUM = 0
	RETURN
	END
