	SUBROUTINE DISABL(DISNUM)
C************************************************************
C
C  THIS SUBROUTINE IS USED TO DISABLE (I.E. TURN OFF)
C  A DISPLAY THAT ALREADY EXISTS IN THE GT40.
C
C  POSSIBLE ERRORS:
C	%TRYING TO DISABLE A NON-EXISTENT DISPLAY
C	%TRYING TO DISABLE A SYSTEM DISPLAY
C	%TRYING TO DISABLE AN ILLEGAL DISPLAY NUMBER
C	?INVALID RESPONSE TO DISABLE (RETURNS DISNUM = 0)
C
C  ROUTINES CALLED:
C	SEND   - SEND COMMAND TO GT40
C	GET    - RECEIVE STATUS TRANSMISSION FROM GT40
C	ERROR  - ERROR LOGGING ROUTINE
C
C************************************************************
	IMPLICIT INTEGER (A - Z)

100	CALL SEND(2, DISNUM, 0, 0)
	CALL GET(STATUS, X, Y, DNUM)
	IF(STATUS .EQ. "66) GO TO 100
	IF(STATUS .EQ. 0) RETURN

	IF(STATUS .NE. 1) GO TO 200
	CALL ERROR('%TRYING TO DISABLE A NON-EXISTENT DISPLAY =', DISNUM)
	RETURN

200	IF(STATUS .NE. 2) GO TO 300
	CALL ERROR('%CANNOT DISABLE THIS DISPLAY =', DISNUM)
	RETURN

300	IF(STATUS .NE. 3) GO TO 400
	CALL ERROR('%TRYING TO DISABLE A BAD DISPLAY NUMBER =', DISNUM)
	RETURN

400	CALL ERROR('?INVALID RESPONSE TO DISABLE, STATUS =', STATUS)
	DISNUM = 0
	RETURN
	END
