C     [DEM34]
C     DEMONSTRATION FOR THE ORTHOGRAPHIC RELIEF PROGRAM.  THE SURFACE
C     SHOWN IS RELATED TO THE SURFACE OF DEM30, DEM31, AND DEM33, BY THE
C     SUBTRACTION OF THE VARIABLE Z. THE OBJECTIVE IS TO LOCATE POINTS
C     WHERE THAT SURFACE EQUALS Z; ORTHOGRAPHIC RELIEF WILL SOMETIMES
C     AID TO DISTINGUISH DEPRESSIONS IN A SURFACE FROM PROTRUBERANCES.
C     OPTION L ALLOWS GENERATION OF AN ORTHOGRAPHIC RELIEF (L=2) OR AN
C     ORDINARY CONTOUR (L=1).  IF THESE ARE DONE IN TWO DIFFERENT COLORS
C     AND SUPERPOSED, THEY WILL SOMETIMES ENHANCE ONE ANOTHER.
C     [08-JUN-75]

      EXTERNAL    PLTCA
      COMPLEX     P,U,V,Z
      DIMENSION   W(121,121)

      P(Z)=1.0+Z*(1.0+Z*(1.0+Z*(1.0+Z*(1.0+Z))))

      L=1
      NX=121
      NY=121
      X1=-1.5
      X2= 1.5
      Y1=-1.5
      Y2= 1.5
      DX=(X2-X1)/FLOAT(NX-1)
      DY=(Y2-Y1)/FLOAT(NY-1)
      Y=Y1
      DO 20 I=1,NY
      X=X1
      DO 10 J=1,NX
      Z=CMPLX(X,Y)
      U=1.0/P(Z)-Z
      W(J,I)=TANH(CABS(U))
   10 X=X+DX
   20 Y=Y+DY

      CALL PLT00
      CALL PLTBO
      CALL PLTUR (X1,X1,1.0,X2,X2,Y1,Y1,1.0,Y2,Y2,0.01,PLTCA)
      CALL PLTLA ('DEM34')
      IF (L.EQ.1) CALL PLTKP (0.0,W,1.0,101,4,NX,4,NY,PLTCA)
      IF (L.EQ.2) CALL PLTOR (0.0,W,1.0,151,4,NX,4,NY,PLTCA)
      CALL PLTEJ
      CALL EXIT
      END

