C     [DEM28]
C     DEMONSTRATION OF THE POTENTIAL FELT BY TWO PARTICLES IN A GAUSSIAN
C     WELL. THE SURFACE ARISES FROM THE USE OF HYPERSPHERICAL HARMONICS
C     IN QUANTUM MECHANICS.  HERE IT IS USED TO ILLUSTRATE A TECHNIQUE
C     OF SKETCHING OUT A COARSE SURFACE INTO WHICH IS INSERTED A DENSER
C     REGION OF SPECIAL INTEREST.  THE DETAIL WHICH IS DESIRED IS THE
C     SHAPE OF THE BOTTOM OF THE TROUGHS CROSSING AT THE CENTER OF THE
C     DRAWING.
C     [06-OCT-74]

      EXTERNAL    PLTCA
      DIMENSION   VE(97,97)

      EX(I)=0.0667*FLOAT(I-57)
      WY(J)=0.0487*FLOAT(J-41)

      NX=97
      NY=97
      DO 10 I=1,NX
      DO 10 J=1,NY
      X1=EX(I)
      X2=WY(J)
      R1=EXP(-X1*X1)
      R2=EXP(-X2*X2)
      RR=EXP(-0.25*(X1-X2)*(X1-X2))
   10 VE(I,J)=TANH(0.4*(-2.0*R1-2.0*R2+RR))

      CALL PLT00
      CALL PLTFR
      CALL PLTLA ('DEM28')
      CALL DEMS1 (-1.0,VE,1.0,NX,NY)
      CALL PLTEJ
      CALL PLTBO
      CALL PLTLA ('DEM28')
      CALL PLTKP (-1.0,VE,1.0,51,5,NX,5,NY,PLTCA)
      CALL PLTEJ
      CALL EXIT

      END


C     ==================================================================


      SUBROUTINE  DEMS1 (Z1,Z,Z2,NX,NY)

C     [06-OCT-74]

      EXTERNAL    PLTCA
      DIMENSION   Z(1)
      COMMON/VIS/ N0

      N0=0
      CALL VISDS (Z1,Z,Z2,1,NX,NX,1,NY,NY,0.2,0.2,-8,8,PLTCA)
      N0=0
      CALL VISDS (Z1,Z,Z2,1,57,NX,41,NY,NY,0.2,0.2,-1,1,PLTCA)
      RETURN

      END

