C
C TTTTTTTTT BBBBBBBBB  LLL   TTTTTTTTT RRRRRRRRR  NNN   NNN
C    TTT    BBB   BBB  LLL      TTT    RRR   RRR  NNNN  NNN
C    TTT    BBBBBBB    LLL      TTT    RRRRRRR    NNN N NNN
C    TTT    BBB   BBB  LLL      TTT    RRR  RRR   NNN  NNNN
C    TTT    BBBBBBBBB  LLLLLLLL TTT    RRR   RRR  NNN   NNN
C
C     TBLTRN, SYMBOLIC TABLE ASSEMBLER WRITTEN IN FORTRAN
C
C     DONALD BARTH, CHEM. DEPT., HARVARD UNIVERSITY
C
C     MASTER IS BOTH STORAGE AND TEMPLATE ARRAY
C     TEMPLATE PART IS FORMED OF CELLS WITH POINTERS
C     CELL FUNTION IS DEFINED BY VALUE AFTER POINTER
C     THESE DEFINITIONS ARE AS FOLLOW...
C
C     -1      OR LESS, CELL CONTAINS  BYTE INFORMATION
C             AND ABSOLUTE VALUE OF ID IS BACKPOINTER TO
C             ASSOCIATED SYMBOL
C      0      SYMBOL OF UNKNOWN VALUE
C      1      LABEL OF UNKNOWN ADDRESS
C      2      LABEL OF KNOWN ADDRESS
C      3  POP (POP) POP VALUE FROM STACK
C      4  '   (APOSTROPHE OR SINGE QUOTE) COPY REST OF
C             LINE INTO OUTPUT FILE DIRECTLY
C      5  ,   (COMMA) INSTRUCTION TERMINATOR
C      6  ... (3 PERIODS) IGNORE REMAINDER OF LINE
C      7  ,,, (3 COMMAS) CONTINUE ON NEXT LINE
C      8      TEXT REPLACEMENT OPERATOR
C      9  -   (MINUS) SUBTRACT FOLLOWING SYMBOL
C     10  +   (PLUS) ADD FOLLOWING SYMBOL
C     11  OCT (OCTAL) FOLLOWING NUMBER IS OCTAL
C     12  DEC (DECIMAL) FOLLOWING NUMBER IS DECIMAL
C     13  LOC (LOCATION) LOCATION OF FOLLOWING LABEL
C     14  XSY (EXPUNGE SYMBOL) REMOVE FROM TABLE
C     15  =   (EQUALS SIGN) ASSIGN VALUE
C     16  .   (PERIOD) LOCATION OF THIS INSTRUCTION
C     17  DMP (DUMP) LIST TEMPLATE ARRAY
C     18  DBG (DEBUG) COMBINED DMP AND LST
C     19  LST (LIST) LIST ASSEMBLED TABLE
C     20  BLK (BLOCK) END OF PRESENT TABLE
C     21  FIN (FINISH) END OF FINAL TABLE
C     22  SAV (SAVE) END OF PRESENT TABLE BUT RETAIN
C             = AND == DEFINED SYMBOLS IN DICTIONARY
C     23  TTL (TITLE) NAME OF OUTPUT ARRAY
C     24  TEL (TELL) PRINTS OUT SELECTED DEBUG OUTPUT
C     25  TTY (TELETYPE) GIVES TELETYPE CONTROL
C     26  END (END) TERMINATES CONDITIONAL ASSEMBLY
C     27  IFE (IF EQUAL) ASSEMBLE IF EQUAL ZERO
C     28 IFLE (IF LESS THAN OR EQUAL)
C     29      BYTE MASK
C     29  MSK (MASK) NULL BYTE MASK
C     30  LFT (LEFT) LEFT SHIFT OPERATOR
C     31      NUMBER IN RANGE OF OPERATOR 30
C     32  RIT (RIGHT) RIGHT SHIFT OPERATOR
C     33      NUMBER IN RANGE OF OPERATOR 32
C     34  SIZ (SIZE) SIZE OF PACKING BYTE
C     35      NUMBER IN RANGE OF OPERATOR 34
C     36  ''  (DOUBLE APOSTROPHE) TYPE LINE AS COMMENT
C     37  ==  (DOUBLE EQUAL SIGN) REQUESTS FROM TELETYPE
C     38  IOR (INCLUSIVE OR) IOR FOLLOWING SYMBOL
C     39  TON (TURN ON BYTE MASK)
C     40  BIT (BIT) SET SPECIFIED BIT ON
C     41      SET BIT ON IN SPECIFIED ENTRY
C     42  DUP (DUPLICATE) DUPLICATE FOLLOWING ENTRY
C     43      NUMBER IN RANGE OF OPERATOR 42
C     44  SRX (SYMBOL RADIX) SET RADIX FOR SYMBOL
C             DEFINITONS
C     45      NUMBER IN RANGE OF OPERATOR 44
C     46  TRX (TABLE RADIX) SET RADIX FOR TABLE ENTRIES
C     47      NUMBER IN RANGE OF OPERATOR 46
C     48  WID (WIDTH) SET WIDTH OF DATA STATEMENT
C     49      NUMBER IN RANGE OF OPERATOR 48
C     50  CLM (COLUMN) SET COLUMN WIDTH OF DATA STATEMENT
C     51      NUMBER IN RANGE OF OPERATOR 50
C     52  TST (TEST) PRESENT TABLE IS TEST CASE
C     53      NUMBER IN RANGE OF OPERATOR 52
C     54  (   START OF CONSTANT SHIFT PHRASE
C     54  ((  START OF CONSTANT SHIFT PHRASE
C     55  )   END OF CONSTANT SHIFT PHRASE
C     56  ))  END BYTE MASK ARGUMENT LIST
C     57  NUL (NULL) NULL ARGUMENT OF BYTE PATTERN
C     58  WRD (WORD) DEPOSIT IN FOLLOWING ENTRY
C     59      NUMBER IN RNGE OF OPERATOR 58
C     60  IFN (IF NOT EQUAL) ASSEMBLE IF NOT EQUAL ZERO
C     61 IFGE (IF GREATER THAN OR EQUAL)
C     62  FIL (FILL) FILL TABLE TO LENGTH WITH ZEROES
C     63      NUMBER IN RANGE OF OPERATOR 62
C     64  BPR (BIT PRECISION) SET NUMBER OF BITS PER WORD
C     65      NUMBER IN RANGE OF OPERATOR 64
C     66      MULTIPLE ENTRY CONSTANT
C     67  ARG (ARGUMENT) END ARGUMENT DEFINITION
C     68  ADR (ADDRESS) NEXT SYMBOL IS ADDRESS OF TABLE
C             ENTRY ORIGIN
C     69  ,,  LINE IS CONTINUATION OF FORMER
C     70  HIA (HIGH ADDRESS) NEXT SYMBOL IS LABEL OF
C             HIGHEST TABLE ENTRY ASSEMBLED.
C     71  LOA (LOW ADDRESS) NEXT SYMBOL IS LABEL OF
C             LOWEST ADDRESS ASSEMBLED BY STATEMENT.
C     72  ACC (ALTER CHARACTER CLASS)
C     73  IFD (IF DEFINED) ASSEMBLE IF DEFINED
C     74  BSZ (BIT SIZE) SET BYTE SIZE FOR BIT OPERATOR
C     75      NUMBER IN RANGE OF OPERATOR 74
C     76  IFU (IF UNDEFINED) ASSEMBLE IF UNDEFINED
C     77  IFA (IF ADDRESS) ASSEMBLE IF ADDRESS
C     78  IFO (IF OTHER) ASSEMBLE IF OTHER THAN ADDRESS
C     79  LMT (LIMIT) SET NUMBER OF TEXT REPLACEMENTS
C     80      NUMBER IN RANGE OF OPERATOR 79
C     81  XAD (EXPUNGE ADDRESS) REMOVE ADDRESS FROM TABLE
C     82  IFL (IF LESS) ASSEMBLE IF LESS THAN ZERO
C     83  EAC (END AUTOMATIC CONTINUE)
C     84  IFG (IF GREATER) ASSEMBLE IF GREATER THAN ZERO
C     85  ROT (ROTATE) ROTATE PRECISION OF FOLLOWING
C             MULTIPLE ENTRY CONSTANT
C     86 IFNA (IF NOT ADDRESS) ASSEMBLE IF NOT ADDRESS
C     87 IFNO (IF NOT OTHER) ASSEMBLE IF NOT OTHER
C             THAN ADDRESS
C     88  DIE (DO IF EQUAL ZERO)
C     89      NUMBER IN RANGE OF OPERATOR 88
C     90  DIN (DO IF NOT EQUAL ZERO)
C     91      NUMBER IN RANGE OF OPERATOR 90
C     92  DIL (DO IF LESS THAN ZERO)
C     93      NUMBER IN RANGE OF OPERATOR 92
C     94  DIG (DO IF GREATER THAN ZERO)
C     95      NUMBER IN RANGE OF OPERATOR 94
C     96  DID (DO IF DEFINED)
C     97      NUMBER IN RANGE OF OPERATOR 96
C     98  DIU (DO IF UNDEFINED)
C     99      NUMBER IN RANGE OF OPERATOR 98
C    100  DIA (DO IF ADDRESS)
C    101      NUMBER IN RANGE OF OPERATOR 100
C    102  DIO (DO IF OTHER THAN ADDRESS)
C    103      NUMBER IN RANGE OF OPERATOR 102
C    104 DINA (DO IF NOT ADDRESS)
C    105      NUMBER IN RANGE OF OPERATOR 104
C    106 DINO (DO IF NOT OTHER THAN ADDRESS)
C    107      NUMBER IN RANGE OF OPERATOR 106
C    108  RED (REDUCE) REDUCE CONSTANT'S VALUE
C    109      NUMBER IN RANGE OF OPERATOR 108
C    110  INC (INCREASE) INCREASE CONSTANT'S VALUE
C    111      NUMBER IN RANGE OF OPERATOR 110
C    112  DEF (DEFINE) DEFINE CONSTANT'S VALUE
C    113      NUMBER IN RANGE OF OPERATOR 112
C    114 DILE (DO IF LESS THAN OR EQUAL ZERO)
C    115      NUMBER IN RANGE OF OPERATOR 114
C    116 DIGE (DO IF GREATER THAN OR EQUAL ZERO)
C    117      NUMBER IN RANGE OF OPERATOR 116
C    118  NSN (NUMERIC SYMBOL NAME)
C    119  NSV (NUMERIC SYMBOL VALUE)
C    120      NUMBER IN RANGE OF OPERATOR 119
C    121  NST (NUMERIC SYMBOL TEXT)
C    122  JST (JUSTIFY) JUSTIFY NUMERIC PART OF NST
C             REPLACEMENT
C    123      NUMBER IN RANGE OF OPERATOR 122
C    124  XOR (EXCLUSIVE OR)
C    125  AND (AND)
C    126  PFX (PREFIX) PRECISION OF PREFIX OPERATORS
C    127      NUMBER IN RANGE OF OPERATOR 126
C    128  STK (STACK) STACK INTO HIGH PRECISION ENTRY
C             OF MULTIPLE PRECISION CONSTANT
C    129      NUMBER IN RANGE OF OPERATOR 128
C    130  PSH (PUSH) PUSH INTO LOW PRECISION ENTRY
C             OF MULTIPLE PRECISION CONSTANT.
C    131      NUMBER IN RANGE OF OPERATOR 130
C    132  SFT (SHIFT) SHIFT FOLLOWING CONSTANT
C    133      NUMBER IN RANGE OF OPERATOR 132
C    134  BAC (BEGIN AUTOMATIC CONTINUE)
C    135  BOD (BEGIN ORDERED DICTIONARY)
C    136  EOD (END ORDERED DICTIONARY)
C   1001      OR GREATER IS SINGLE PRECISION CONSTANT
C   1001  NEG (NEGATIVE) SUPPLIED CONSTANT WITH
C             SIGN BIT ON AND ALL OTHER BITS OFF
C
      COMMON/TBLTRN/I,IADDRS,IADJST,IBASE,IBLANK,IDGT(16),
     1IERR,IFILL,IFKNT,IKODE,ILEFT,ILINE,ILPT,ILTR,IBYTE,
     2IMASK,LMAX,NMORE,IMOST,INSERT,IOCT(13),IOPRTR,IOUT,
     3IPAREN,IPNCTN(11),IPRCN,IRADIX,IREAD,IREPT,IRIGHT,
     4ISHIFT,ISIGN,ISTAR,ISTORE(478),ITEN,ITEST,ITITLE(6),
     5ITTY,IWIDE,IWRITE,J,JADJST,JBASE,JBLANK,JERR,KPAREN,
     6JFKNT,JKODE(37),JLEFT,JMASK,JMORE,JPAREN,JRADIX,LOOP,
     7JRIGHT,JSHIFT,JSIGN,K,KADJST,KBASE,KERR,KIND,KLINE,
     8KLM,KLTR,KMASK,KNT,KNTLTR,KNTWRD,KODE,KRADIX,IDBG,
     9KREAD,KSHIFT,L,LEAST,LETTER(160),LMASK,LOCK,LSTNEW,
     1LTTR(160),M,MASK,MASTER(5000),MAX,MLEFT,MORE,MOST,
     2MRIGHT,MULT,N,NEW,NEXT,NSIGN,NTITLE(6),NUMBER,LRADIX,
     3KMAX,INLINE,JPNCTN(50),KPNCTN(50),LPNCTN,JOPRTR,NLTR,
     4JBYTE,ILOOP,ISKIP,IVALUE,INSN(6),JNSN,IMAX,JMAX,
     5KNSN,MLTR,JLTR,JLOOP,IPFX,JPFX,LSIGN,IIARG,JJARG,
     6KKARG,LLARG,JVALUE,MIN,IAC,IARG,JARG,KARG,LARG,JSTFY,
     7LENGTH(20),LNGMIN,IORDER,IRMV,KSIGN
C
C     ISHORT ARRAY IS USED FOR READING INPUT FROM INPUT
C     FILE AND SHOULD BE DIMENSIONED AT IMAX.  ILONG
C     IS USED FOR READING FROM TELETYPE AND SHOULD BE
C     DIMENSIONED AT JMAX.  THESE ARE BOTH EQUIVALENCED
C     WITH A BUFFER ARRAY CALLED LETTER DIMENSIONED AT
C     KMAX.  KMAX IS GREATER THAN EITHER IMAX OR JMAX TO
C     ALLOW FOR EXPANSION OF THE INPUT TEXT STRING BY A
C     TEXT REPLACEMENT OPERATOR.
      DIMENSION ISHORT(80),ILONG(120)
      EQUIVALENCE (LETTER(1),ISHORT(1),ILONG(1))
C
C     CALL TBLNMB TO DEFINE I/O UNIT NUMBERS
      ILINE=0
      ILTR=0
    1 CALL TBLNMB
      LMAX=IMAX
      IF(IREAD.EQ.ITTY)LMAX=JMAX
      IF(ILTR.NE.0)GO TO 136
      KREAD=ITTY
C
C     PREPARE FOR FIRST TABLE
      KLINE=0
      ILEFT=0
      JLTR=0
      KLTR=0
      JBLANK=0
      IERR=0
      JERR=0
      KERR=0
      JLOOP=0
      JSIGN=-1
      INLINE=1
C
C     RESTORE ORIGINAL SYMBOL DICTIONARY
    2 DO 3 I=1,20
    3 LENGTH(I)=0
      I=1
      LEAST=MAX
    4 K=ISTORE(I)
      IF(K.LE.0)GO TO 7
      IF(K.GT.20)GO TO 5
      IF(LENGTH(K).EQ.0)LENGTH(K)=LEAST
    5 J=I+1
      LEAST=LEAST-3
      MASTER(LEAST+3)=LEAST-K
      MASTER(LEAST+2)=ISTORE(J)
      MASTER(LEAST+1)=0
      IF(ISTORE(J).EQ.1001)MASTER(LEAST+1)=ITBSIN(0)
      K=K+J
      I=K+1
    6 MASTER(LEAST)=ISTORE(K)
      LEAST=LEAST-1
      K=K-1
      IF(K.LE.J)GO TO 4
      GO TO 6
    7 LSTNEW=LEAST+ISTORE(J-1)+2
      MASTER(LEAST)=0
      LNGMIN=LEAST
C
C     RESTORE ORIGINAL CHARACTER CLASSES
      LPNCTN=11
      DO 8 I=1,LPNCTN
      JPNCTN(I)=IPNCTN(I)
    8 KPNCTN(I)=I+4
C
C     PREPARE FOR NEXT TABLE
    9 MOST=0
      IPFX=0
      JPFX=0
      IFKNT=0
      JFKNT=0
      IMASK=0
      KBASE=2
      KADJST=1
      JRADIX=10
      KRADIX=10
      KLM=55
      IWIDE=1
      IOPRTR=0
      ITEST=0
      IFILL=0
      KNTWRD=0
      IPRCN=32
      JOPRTR=1
      IBYTE=2
      JBYTE=1
      IORDER=1
      ILOOP=1000
      IAC=0
      MIN=LEAST-1
      DO 10 I=1,6
      INSN(I)=NTITLE(I)
   10 ITITLE(I)=NTITLE(I)
      JNSN=6
      KNTLTR=6
      KNSN=0
      IARG=0
      IIARG=0
      JSTFY=0
      GO TO 14
C
C     PREPARE FOR NEXT STATEMENT
C     ENTER HERE IF HAVE ASSEMBLED TABLE ENTRY
   11 IF(ILEFT.LT.0)GO TO 29
      MOST=MOST-MULT+INSERT
      IF(IREPT.EQ.0)GO TO 14
      MULT=INSERT
      IF((MOST+(IREPT*MULT)).GE.LEAST)GO TO 132
      K=MOST-MULT+1
      DO 13 I=1,IREPT
      L=K
      DO 12 J=1,MULT
      MOST=MOST+1
      MASTER(MOST)=MASTER(L)
   12 L=L+1
   13 CONTINUE
      KODE=2
      GO TO 80
   14 IBASE=KBASE
      IADJST=KADJST
      IREPT=0
      MULT=0
      INSERT=0
      IMOST=MOST
      NEXT=0
      LOCK=0
C
C     ENTER HERE IF HAVE NOT ASSEMBLED TABLE ENTRY
   15 LRADIX=JRADIX
      JMASK=IMASK
      KMASK=LMASK
      KNTWRD=0
      ISKIP=0
      IF(MIN.GT.(LEAST-MOST-1))MIN=LEAST-MOST-1
      IF(IPFX.LT.0)IPFX=JPFX
C
C     WRITE ERROR MESSAGE IF NECESSARY
C     IERR =-1, ERROR IF MORE SYMBOLS IN STATEMENT
C          = 0, NO ERRORS ENCOUNTERED
C          = 1, ERROR ENCOUNTERED BUT NOT PRINTED
C          = 2, FIRST LINE OF ERROR ALREADY PRINTED
   16 IF(IERR.LE.0)GO TO 18
      IF(IERR.EQ.1)WRITE(ITTY,17)ILINE,(IBLANK,
     1 I=JLEFT,MLEFT),(ISTAR,I=MLEFT,MRIGHT)
   17 FORMAT(11H ERROR LINE,1I5/160A1)
      IF(JRIGHT.GE.JLEFT)WRITE(ITTY,25)IBLANK,
     1(LETTER(I),I=JLEFT,JRIGHT)
      JBLANK=1
      IERR=2
   18 IF(JOPRTR.EQ.21)GO TO 81
      IF(ILEFT.GT.KMAX)GO TO 21
      IF(ILTR.EQ.0)GO TO 21
C
C     BRANCH TO PERFORM DEFERRED OPERATION IF ANY
C     IOPRTR=14, XSY
C           =20, BLK
C           =21, FIN
C           =22, SAV
C           =24, TEL
C           =25, TTY
C           =27, IFE
C           =60, IFN
C           =82, IFL
C           =84, IFG
C           =77, IFA
C           =78, IFO
C           =28, IFLE
C           =61, IFGE
C           =86, IFNA
C           =87, IFNO
C           =73, IFD
C           =76, IFU
C           =81, XAD
      IF(IOPRTR.EQ.0)GO TO 20
      IF(IOPRTR.EQ.14)GO TO 19
      IF(IOPRTR.EQ.20)GO TO 81
      IF(IOPRTR.EQ.22)GO TO 81
      IF(IOPRTR.EQ.24)GO TO 19
      IF(IOPRTR.EQ.25)GO TO 90
      IF(IOPRTR.EQ.27)GO TO 19
      IF(IOPRTR.EQ.60)GO TO 19
      IF(IOPRTR.EQ.73)GO TO 19
      IF(IOPRTR.EQ.76)GO TO 19
      IF(IOPRTR.EQ.77)GO TO 19
      IF(IOPRTR.EQ.78)GO TO 19
      IF(IOPRTR.EQ.82)GO TO 19
      IF(IOPRTR.EQ.84)GO TO 19
      IF(IOPRTR.EQ.86)GO TO 19
      IF(IOPRTR.EQ.87)GO TO 19
      IF(IOPRTR.EQ.28)GO TO 19
      IF(IOPRTR.EQ.61)GO TO 19
      IF(IOPRTR.NE.81)GO TO 27
   19 KNTWRD=1
      IKODE=IOPRTR
      GO TO 39
C
C     READ IN NEXT LINE
C     ILEFT.LT.0, GET MASK INFO AFTER ORIGIN INCREMENT
C          .LT.KMAX, NEXT STATEMENT IS IN PRESENT LINE
C          .GT.KMAX, CONTINUE STATEMENT ON NEXT LINE
   20 IF(ILEFT.LE.KMAX)GO TO 27
   21 IF(JBLANK.EQ.0)GO TO 22
      IF(IREAD.NE.ITTY)GO TO 22
      JBLANK=0
      WRITE(ITTY,25)IBLANK
   22 ILINE=ILINE+1
      ILTR=LMAX+1
      IF(IREAD.EQ.ITTY)GO TO 23
      READ(IREAD,25,END=134)ISHORT
      GO TO 24
   23 READ(IREAD,25,END=134)ILONG
   24 ILTR=ILTR-1
      IF(ILTR.EQ.0)GO TO 22
      IF(LETTER(ILTR).EQ.IBLANK)GO TO 24
      IF(IREAD.NE.ITTY)GO TO 26
      IF(IOUT.NE.ITTY)WRITE(IOUT,25)(LETTER(I),I=1,ILTR)
   25 FORMAT(150A1)
   26 IRIGHT=0
      LOOP=0
      MLTR=ILTR
      NLTR=MLTR
      LARG=0
   27 JLEFT=IRIGHT
   28 JLEFT=JLEFT+1
      IF(LETTER(JLEFT).EQ.IBLANK)GO TO 28
      IRIGHT=JLEFT-1
C
C     PREPARE FOR NEXT TABLE ENTRY
      IF(ILEFT.GT.KMAX)GO TO 39
      IERR=0
      KNT=0
      IRADIX=KRADIX
      KPAREN=0
      IF(IMASK.EQ.0)GO TO 35
      MASK=IMASK
      GO TO 33
   29 MORE=MASTER(MASK)
      MOST=MOST+MORE
      MULT=MULT+MORE
      KNT=0
      IRADIX=KRADIX
      KPAREN=0
      ILEFT=0
      NEXT=NEXT-MORE
      IF(NEXT.GT.0)GO TO 33
      LOCK=0
      MOST=MOST+NEXT
   30 IF(NEXT.EQ.0)GO TO 33
      MOST=MOST+1
      NEXT=NEXT+1
      MASTER(MOST)=0
      GO TO 30
C
C     PREPARE FOR NEXT SYMBOL
   31 IF(KPAREN.LE.0)GO TO 32
      ISIGN=IPAREN
      MORE=JPAREN
      ISHIFT=KSHIFT*IADJST
      GO TO 38
   32 IF(MASK.EQ.0)GO TO 35
   33 MASK=MASK-2
      IF(MASK.LT.LMASK)GO TO 35
      MORE=MASTER(MASK+1)
      IF(MORE.EQ.0)GO TO 34
      ISHIFT=MASTER(MASK)
      IBASE=2+(ISHIFT/505)
      ISIGN=10+(ISHIFT/101)-(5*IBASE)
      ISHIFT=ISHIFT+960-(505*IBASE)-(101*ISIGN)
      IADJST=1
      KSHIFT=ISHIFT
      IF(MORE.GT.0)GO TO 38
      KODE=66
      NUMBER=MASK
      MASK=MASK+MORE
      GO TO 75
   34 ILEFT=-1
      MORE=MASTER(MASK)
      IF((MOST+MORE).GE.LEAST)GO TO 132
      IF(NEXT.EQ.0)GO TO 29
      IF(NEXT.LE.MORE)GO TO 127
      IF(JSIGN.LT.0)GO TO 29
      IF(JMORE.LE.MORE)GO TO 127
      JMORE=JMORE-MORE
      GO TO 29
   35 MASK=0
      IF(IOPRTR.EQ.0)GO TO 36
      IBASE=JBASE
      IADJST=JADJST
      GO TO 37
   36 IBASE=KBASE
      IADJST=KADJST
   37 ISIGN=-1
      ISHIFT=0
      KSHIFT=0
      MORE=1
   38 NMORE=0
      NSIGN=-1
C
C     ***********************************
C     *  IDENTIFY SYMBOL AND OPERATION  *
C     ***********************************
C
   39 KODE=0
   40 CALL TBLNXT
      GO TO(41,67,105,107,63,62,131,132),KODE
C
C     SYMBOL FOUND OR ADDED TO SYMBOL DICTIONARY
   41 KODE=MASTER(NEW)
C
C     TEST FOR TERMINATOR SYMBOLS , ... ,,, END
C     TEST FOR TEXT REPLACEMENT OPERATOR
   42 IF(KODE.EQ.5)GO TO 115
      IF(KODE.EQ.6)GO TO 104
      IF(KODE.EQ.7)GO TO 103
      IF(KODE.EQ.8)GO TO 54
      IF(KODE.EQ.26)GO TO 109
C
C     TEST IF PRESENT LINE IS CONTINUATION
   43 IF(INLINE.NE.0)GO TO 46
      INLINE=1
      IF(KODE.EQ.69)GO TO 39
      IRIGHT=ILEFT-1
      IF(IOPRTR.NE.37)GO TO 44
      IF(MASTER(IADDRS).NE.8)GO TO 44
      IF(MASTER(IADDRS-1).NE.0)GO TO 44
      IF(IERR.EQ.0)GO TO 20
   44 IF(IARG.EQ.0)GO TO 45
      IF(IRIGHT.LT.LARG)GO TO 45
      IF(IFKNT.NE.0)GO TO 45
      IF(JARG.EQ.-1)GO TO 52
      IF(JARG.LT.0)JARG=JARG+1
      IF(JARG.GT.0)IARG=0
   45 IF(IOPRTR.EQ.37)GO TO 129
      GO TO 118
   46 INLINE=1
      IF(KODE.EQ.4)GO TO 57
      IF(KODE.EQ.36)GO TO 57
      IF(KODE.EQ.69)GO TO 39
      IF(ISKIP.NE.0)GO TO 61
      IF(IFKNT.NE.0)GO TO 58
      IF(KODE.EQ.121)GO TO 49
      IF(IARG.EQ.0)GO TO 47
      IF(ILEFT.LE.LARG)GO TO 47
      IF(JARG.GT.0)JARG=JARG-1
   47 IF(NEW.EQ.0)GO TO 70
C
C     TEST IF HAVE A SYMBOL WITH INTEGER PREFIX
      IF(KIND.NE.3)GO TO 69
      IF(ILEFT.LT.NUMBER)GO TO 48
      ILEFT=NUMBER
      IF(KODE.NE.0)GO TO 64
      KODE=2
      GO TO 40
   48 IF(KODE.NE.0)GO TO 68
      I=ILEFT
      ILEFT=NUMBER
      NUMBER=I
      KODE=1
      GO TO 40
C
C     NUMERIC SYMBOL REPLACEMENT
   49 NUMBER=MOST+NEXT
      IF((NUMBER+JNSN+2).GE.LEAST)GO TO 132
      I=0
   50 NUMBER=NUMBER+1
      I=I+1
      MASTER(NUMBER)=INSN(I)
      IF(I.LT.JNSN)GO TO 50
      I=NUMBER+JSTFY
      CALL DANUMB(JSTFY,KNSN,10,MASTER,NUMBER,I,LEAST-3)
      MASTER(NUMBER+1)=NUMBER-MOST-NEXT
      NUMBER=NUMBER+1
      JSTFY=0
      GO TO 56
C
C     INSERT TEXT BEFORE END THIS STATEMENT
   51 ITEN=IRIGHT-MLTR-1
      GO TO 53
   52 ITEN=MLTR-IRIGHT+1
   53 MLTR=IRIGHT
      KODE=3
      GO TO 40
C
C     TEXT REPLACEMENT OPERATOR
   54 NUMBER=MASTER(NEW-1)
      IF(IOPRTR.EQ.14)GO TO 43
      IF(IOPRTR.EQ.24)GO TO 43
      IF(NUMBER.EQ.0)GO TO 39
      IF(ISKIP.NE.0)GO TO 43
      IF(IFKNT.NE.0)GO TO 43
      NUMBER=-NUMBER-1
      I=NUMBER-1-MASTER(NUMBER)
      IF(MASTER(NUMBER+2).EQ.I)GO TO 56
      IF(IARG.EQ.0)GO TO 55
      IF(INLINE.EQ.0)GO TO 43
   55 IARG=NUMBER+1
      KARG=1
      JARG=0
      LARG=IRIGHT
      GO TO 39
   56 KODE=4
      GO TO 40
C
C     KODE=4, ' (APOSTROPHE OR SINGLE QUOTE) OPERATOR
C     KODE=36, '' (DOUBLE APOSTROPHE) OPERATOR
   57 CALL TBLSTR
      IF(KODE.EQ.0)GO TO 40
      GO TO(131,132),KODE
C
C     PROCESS STATEMENTS BEYOND UNFULFILLED IF
   58 IF(KNTWRD.NE.0)GO TO 60
      IF(KODE.EQ.27)GO TO 59
      IF(KODE.EQ.28)GO TO 59
      IF(KODE.EQ.60)GO TO 59
      IF(KODE.EQ.61)GO TO 59
      IF(KODE.EQ.82)GO TO 59
      IF(KODE.EQ.84)GO TO 59
      IF(KODE.EQ.77)GO TO 59
      IF(KODE.EQ.78)GO TO 59
      IF(KODE.EQ.86)GO TO 59
      IF(KODE.EQ.87)GO TO 59
      IF(KODE.EQ.73)GO TO 59
      IF(KODE.NE.76)GO TO 60
   59 IFKNT=IFKNT+1
      JFKNT=JFKNT+1
   60 KNTWRD=KNTWRD+1
      GO TO 39
C
C     PROCESS PORTION OF STATEMENT NOT BEYOND UNFULFILLED IF
   61 ISKIP=ISKIP-1
      GO TO 39
C
C     CONVERT DIGITS FOLLOWED BY ASTERISK
   62 KODE=ITEN
      NEW=0
      NUMBER=0
      KIND=4
      GO TO 42
C
C     CONVERT ALL DIGIT SYMOBOLS (KIND= 2)
   63 KODE=1001
      NEW=0
      GO TO 43
C
C     CONVERT TYPE 3 SYMBOLS TO KNOWN VALUES
   64 I=0
   65 I=I+1
      IF(JKODE(I).EQ.0)GO TO 66
      IF(JKODE(I).NE.KODE)GO TO 65
      NEW=0
      NUMBER=ITEN
      KODE=KODE+1
      GO TO 70
   66 NEW=LSTNEW
   67 KODE=0
   68 KIND=4
   69 NUMBER=MASTER(NEW-1)
C
C     TEST FOR POSSIBLE CHARACTERS NOT READ
   70 IF(LOOP.NE.0)GO TO 72
      IF(IRIGHT.LE.(LMAX-5))GO TO 72
      IF(ILINE.EQ.JERR)GO TO 72
      JERR=ILINE
      JBLANK=1
      WRITE(ITTY,71)ILINE
   71 FORMAT(1X,4HLINE,1I6,
     132H PROBABLY EXCEEDS MAXIMUM LENGTH)
C
C     IDENTIFY OPERATION AND PERFORM IF POSSIBLE
   72 KNTWRD=KNTWRD+1
      IF(IERR.NE.0)GO TO 131
      IF(KNTWRD.GT.2)GO TO 75
      IF(KNTWRD.NE.2)GO TO 74
      IF(KODE.EQ.15)GO TO 75
      IF(KODE.EQ.37)GO TO 75
      IF(IKODE.EQ.1)GO TO 73
      IF(IKODE.NE.2)GO TO 75
   73 IRIGHT=ILEFT-1
      KODE=8
      NEW=IADDRS
      GO TO 80
   74 IADDRS=NEW
      IKODE=KODE
      IF(KODE.EQ.1)GO TO 39
      IF(KODE.EQ.2)GO TO 39
   75 IF(IOPRTR.NE.0)GO TO 76
C     SINGLE PERIOD TREATED AS IF IN RANGE OF LOC.
      IF(KODE.NE.16)GO TO 77
      IOPRTR=13
   76 CALL TBLOPR
      IF(KODE.GE.0)GO TO 77
      KODE=-KODE
      GO TO(31,39,40,88,80,80,123,80,80,131,132),KODE
C     TBLNOT WOULD NOT BE CALLED IF IERR.GT.0 SO THIS
C     CONDITION USED TO REGAIN CONTROL AFTER FORCING
C     CLOSURE OF PARENTHETICAL EXPRESSIONS WITHOUT
C     CLOSING RIGHT PARENTHESIS AFTER OPERATORS WHICH
C     COULD HAVE TAKEN INTEGER PREFIX BUT DID NOT.
C     ERROR CODES AFTER RETURN MUST STILL BE PROCESSED.
   77 CALL TBLNOT
      IF(IERR.GT.0)GO TO 78
      GO TO(31,39,40,88,80,80,123,80,80,131,132),KODE
   78 IF(KODE.NE.10)IERR=0
      IF(KODE.EQ.11)GO TO 132
      IOPRTR=0
      MLEFT=JRIGHT+1
      MRIGHT=MLEFT
      GO TO 123
   79 IF(KSIGN.EQ.0)GO TO 130
      KODE=4
   80 CALL TBLCEL
      GO TO (130,14,128,130,31,31,130,125,39,131,132),KODE
C
C     ****************************************
C     *  PERFORM OPERATION DEFERRED UNTIL    *
C     *  PREVIOUS STATEMENT HAS BEEN CLOSED  *
C     ****************************************
C
C     KODE=20, BLK OPERATOR
C     KODE=21, FIN OPERATOR
C     KODE=22, SAV OPERATOR
C     OUTPUT ASSEMBLED TABLE AND PREPARE FOR NEXT
   81 IF(IFILL.GE.LEAST)GO TO 132
      CALL TBLMRK
   82 IF(IFILL.LE.MOST)GO TO 83
      MOST=MOST+1
      MASTER(MOST)=0
      GO TO 82
   83 IF(ITEST.EQ.0)GO TO 84
      WRITE(ILPT,25)IBLANK,(ITITLE(I),I=1,KNTLTR)
      CALL DACOMP(I,ILPT,MASTER,1,MOST-ITEST,
     1MASTER,MOST-ITEST+1,MOST)
      IF(ILPT.EQ.ITTY)GO TO 86
      GO TO 87
   84 I=MAX-LEAST+1-LSIGN
      K=LEAST-MOST-1
      IF(MIN.GT.K)MIN=K
      WRITE(ITTY,85)MOST,I,LSIGN,K,MIN
   85 FORMAT(1H0,15HSTORAGE SUMMARY/1X,7HENTRIES,1I8/
     11X,9HOPERATORS,1I6/1X,6HLABELS,1I9/
     21X,6HEXCESS,1I9,10H (CURRENT)/1X,6X,1I9,10H (MINIMUM))
      IF(MOST.GT.0)CALL DATA(MASTER,MOST,ITITLE,KNTLTR,
     1IWIDE,KLM,10,IWRITE)
   86 JBLANK=1
   87 IF(JOPRTR.EQ.21)GO TO 139
      IF(IOPRTR.EQ.22)GO TO 79
      GO TO 2
C
C     KODE=25, TTY OPERATOR
C     KODE=37, == OPERATOR
C     TRANSFER CONTROL BETWEEN INPUT FILE AND TELETYPE
   88 IF(IOPRTR.EQ.15)GO TO 31
      GO TO 94
   89 IOPRTR=15
      GO TO 93
   90 IF(ITEST.NE.0)GO TO 93
      IF(IREAD.EQ.KREAD)GO TO 118
      JBLANK=1
      IF(IREAD.EQ.ITTY)WRITE(ITTY,91)
   91 FORMAT(22H CONTROL TO INPUT FILE)
      IF(KREAD.EQ.ITTY)WRITE(ITTY,92)
   92 FORMAT(20H CONTROL TO TELETYPE)
   93 IF(IERR.LE.0)GO TO 94
      IF(IERR.EQ.1)WRITE(ITTY,17)ILINE,(IBLANK,
     1 I=JLEFT,MLEFT),(ISTAR,I=MLEFT,MRIGHT)
      IF(JRIGHT.GE.JLEFT)WRITE(ITTY,25)IBLANK,
     1(LETTER(I),I=JLEFT,JRIGHT)
      JBLANK=1
      IERR=2
   94 K=IRIGHT
      J=JERR
      JERR=KERR
      KERR=J
      J=LOOP
      LOOP=JLOOP
      JLOOP=J
      IF(ITEST.NE.0)GO TO 95
      J=KREAD
      KREAD=IREAD
      IREAD=J
      LMAX=IMAX
      IF(IREAD.EQ.ITTY)LMAX=JMAX
      J=KLINE
      KLINE=ILINE
      ILINE=J
   95 IRIGHT=IRIGHT+1
      IF(IRIGHT.GT.ILTR)GO TO 96
      IF(LETTER(IRIGHT).EQ.IBLANK)GO TO 95
C     STORE FUNCTION
   96 IF(IARG.EQ.0)GO TO 97
      IF(IIARG.NE.0)GO TO 97
      IF(K.GT.LARG)GO TO 98
C     STORE FUNCTION/STORE NEW ONE IF NO OLD STORED
      IIARG=IARG
      JJARG=JARG
      KKARG=KARG
      LLARG=LARG-IRIGHT+1
      IARG=0
      GO TO 99
C     STORE FUNCTION/CANCEL NEW ONE IF OLD STORED
   97 IF(IIARG.EQ.0)GO TO 98
      IARG=IIARG
      JARG=JJARG
      KARG=KKARG
      LARG=LLARG
      IIARG=0
      GO TO 99
C     STORE FUNCTION/CONTINUE ARGUMENT LIST IF
C     IN ARGUMENT LIST AND NO OLD ONE STORED
   98 LARG=0
      IIARG=0
C     EXCHANGE BUFFERS
   99 J=MLTR-IRIGHT+1
      MLTR=JLTR
      NLTR=MLTR
      JLTR=J
      J=ILTR-IRIGHT+1
      ILTR=KLTR
      KLTR=J
      IF(J.LT.ILTR)J=ILTR
      I=0
      K=0
  100 I=I+1
      IF(I.LE.KLTR)L=LETTER(IRIGHT)
      IF(I.GT.ILTR)GO TO 101
      K=K+1
      LETTER(I)=LTTR(K)
  101 IF(I.GT.KLTR)GO TO 102
      LTTR(I)=L
      IRIGHT=IRIGHT+1
  102 IF(I.LT.J)GO TO 100
      ILEFT=0
      IRIGHT=0
      JLEFT=1
      IERR=0
      IF(IOPRTR.EQ.37)GO TO 31
      IF(IOPRTR.NE.15)GO TO 118
      IF(ITEST.NE.0)GO TO 130
      KODE=-IKODE
      IDBG=ITTY
      CALL TBLDBG
      GO TO 130
C
C     *********************************
C     *  END OF STATEMENT INDICATION  *
C     *********************************
C
C     KODE=7, ,,, (3 COMMAS) OPERATOR
  103 IF(MLTR.LT.ILTR)GO TO 107
      INLINE=-1
      GO TO 106
C
C     KODE=6, ... (3PERIODS) OPERATOR
  104 IF(MLTR.LT.ILTR)GO TO 107
      IF(INLINE.LE.0)GO TO 106
C
C     READ BEYOND END OF PRESENT LINE
  105 INLINE=IAC
  106 ILEFT=KMAX+1
      GO TO 16
C
C     READ BEYOND END OF TEXT INSERTED AT END OF LINE
  107 IRIGHT=MLTR+1
      I=LETTER(IRIGHT)
      IF(I.LT.0)GO TO 108
      MLTR=MLTR+I
      IF(MLTR.GT.ILTR)MLTR=ILTR
      GO TO 115
  108 MLTR=MLTR-I
      IF(MLTR.GT.ILTR)MLTR=ILTR
C
C     KODE=26, END OPERATOR
  109 INLINE=1
      IF(IOPRTR.NE.37)GO TO 110
      IF(MASTER(IADDRS).NE.8)GO TO 110
      IF(MASTER(IADDRS-1).NE.0)GO TO 110
      IF(IERR.EQ.0)GO TO 111
  110 IF(IARG.EQ.0)GO TO 111
      IF(IRIGHT.LE.LARG)GO TO 111
      IF(IFKNT.NE.0)GO TO 111
      IF(JARG.EQ.-1)GO TO 51
  111 IF(IOPRTR.EQ.0)GO TO 112
      IF(IOPRTR.EQ.27)GO TO 122
      IF(IOPRTR.EQ.28)GO TO 122
      IF(IOPRTR.EQ.60)GO TO 122
      IF(IOPRTR.EQ.61)GO TO 122
      IF(IOPRTR.EQ.73)GO TO 122
      IF(IOPRTR.EQ.76)GO TO 122
      IF(IOPRTR.EQ.77)GO TO 122
      IF(IOPRTR.EQ.78)GO TO 122
      IF(IOPRTR.EQ.82)GO TO 122
      IF(IOPRTR.EQ.84)GO TO 122
      IF(IOPRTR.EQ.86)GO TO 122
      IF(IOPRTR.EQ.87)GO TO 122
  112 JFKNT=JFKNT-1
      IF(JFKNT.GE.0)GO TO 114
      WRITE(ITTY,113)ILINE
  113 FORMAT(1X,31HUNBALANCED IF-END COUNT ON LINE,1I6)
      JBLANK=1
      JFKNT=0
  114 IF(IFKNT.EQ.0)GO TO 115
      IFKNT=IFKNT-1
      IF(IARG.EQ.0)GO TO 15
      IF(JARG.GT.0)IARG=0
      GO TO 15
C
C     KODE=5, , (COMMA) OPERATOR
  115 INLINE=1
      IF(IOPRTR.NE.37)GO TO 116
      IF(MASTER(IADDRS).NE.8)GO TO 116
      IF(MASTER(IADDRS-1).NE.0)GO TO 116
      IF(IERR.EQ.0)GO TO 20
  116 IF(IARG.EQ.0)GO TO 117
      IF(IRIGHT.LE.LARG)GO TO 117
      IF(IFKNT.NE.0)GO TO 117
      IF(JARG.EQ.-1)GO TO 52
      IF(JARG.LT.0)JARG=JARG+1
      IF(JARG.GT.0)IARG=0
  117 IF(IOPRTR.EQ.37)GO TO 129
C
C     END OF STATEMENT
  118 IF(IOPRTR.EQ.0)GO TO 123
      IF(IOPRTR.EQ.15)GO TO 129
      IF(IOPRTR.EQ.14)GO TO 79
      IF(IOPRTR.EQ.81)GO TO 79
      IF(IOPRTR.EQ.60)GO TO 120
      IF(IOPRTR.EQ.27)GO TO 120
      IF(IOPRTR.EQ.28)GO TO 120
      IF(IOPRTR.EQ.61)GO TO 120
      IF(IOPRTR.EQ.82)GO TO 120
      IF(IOPRTR.EQ.84)GO TO 120
      IF(IOPRTR.EQ.77)GO TO 121
      IF(IOPRTR.EQ.78)GO TO 121
      IF(IOPRTR.EQ.86)GO TO 121
      IF(IOPRTR.EQ.87)GO TO 121
      IF(IOPRTR.EQ.73)GO TO 121
      IF(IOPRTR.EQ.76)GO TO 121
      KODE=IOPRTR
      IOPRTR=0
      I=0
  119 I=I+1
      IF(JKODE(I).EQ.0)GO TO 123
      IF(JKODE(I).NE.KODE)GO TO 119
      IF(LSIGN.EQ.0)GO TO 123
      IF(IERR.GT.0)GO TO 123
      IERR=1
      KODE=KODE+1
      NUMBER=JVALUE
      GO TO 77
  120 IF(LSIGN.EQ.0)GO TO 121
      KODE=55
      GO TO 76
  121 IFKNT=1
      JFKNT=JFKNT+1
  122 IOPRTR=0
C
C     ADJUST TABLE ENTRY COUNT IF NONE ASSEMBLED
  123 IF(KNTWRD.NE.1)GO TO 126
      IF(IKODE.EQ.1)GO TO 124
      IF(IKODE.NE.2)GO TO 126
  124 KODE=8
      NEW=IADDRS
      GO TO 80
  125 IF(KNTWRD.NE.1)GO TO 31
      IF(IKODE.EQ.0)GO TO 31
  126 IF(INSERT.NE.0)GO TO 127
      MOST=MOST-MULT
      MULT=0
      GO TO 15
  127 IF(JSIGN.LT.0)GO TO 11
C
C     PROCESS FIRST LOC IN STATEMENT
      ISIGN=JSIGN
      JSIGN=-1
      MORE=JMORE
      I=IBASE
      IBASE=JBASE
      JBASE=I
      ISHIFT=JSHIFT
      NEW=IADDRS
      KODE=3
      GO TO 80
C
C     RESTORE BASE AFTER PROCESSING 1ST LOC IN STATEMENT
  128 IBASE=JBASE
      GO TO 11
C
C     RESTORE MASK AND BASE AFTER PROCESS = OR ==
  129 IMASK=JMASK
      LMASK=KMASK
      IPFX=JPFX
      IBASE=KBASE
      IADJST=KADJST
      JRADIX=LRADIX
      MASK=0
      KODE=7
      GO TO 80
  130 IF(IOPRTR.EQ.37)GO TO 89
      IF(IOPRTR.EQ.22)GO TO 9
      IOPRTR=0
      GO TO 15
C
C     ********************
C     *  ERROR SWITCHES  *
C     ********************
C
C     INDICATE ERROR ENCOUNTERED IN STATEMENT
  131 IF(IERR.GT.0)GO TO 39
      IERR=1
      MLEFT=ILEFT
      MRIGHT=IRIGHT
      GO TO 39
C
C     ******************
C     *  END ASSEMBLY  *
C     ******************
C
C     STORAGE FULL, FORCE END OF TABLE
  132 WRITE(ITTY,133)ILINE,(LETTER(I),I=JLEFT,ILTR)
  133 FORMAT(30H INSUFFICIENT  STORAGE AT LINE,1I6/
     11X,120A1)
      JOPRTR=21
      LSIGN=0
      GO TO 84
C
C     END-OF-FILE READ ON INPUT DEVICE
  134 IF(IREAD.NE.ITTY)WRITE(ITTY,135)IREAD
  135 FORMAT(1X,24HEND-OF-FILE READ ON UNIT,1I3)
      JBLANK=1
      GO TO 1
  136 IF(ILINE.EQ.0)GO TO 138
      IF(JOPRTR.NE.1)GO TO 137
      IF((MOST+INSERT).EQ.0)GO TO 139
  137 JOPRTR=21
      ILEFT=0
      IF(IOPRTR.EQ.37)GO TO 129
      GO TO 118
  138 IF(IREAD.NE.KREAD)GO TO 21
      KREAD=ITTY
      KLINE=0
      GO TO 21
C
C     TERMINATE EXECUTION
  139 END FILE IWRITE
      STOP
C
C     I, J, K, L, M, N, INDEX, LIMIT ARE LOCAL VARIABLES.
C     IAC    = 0, AUTOMATIC STATEMENT BREAK AT START OF NEW
C              LINE UNLESS ,, OR ,,, OPERATORS ARE USED.
C            = 1, NO AUTOMATIC STATEMENT  BREAK AT START OF
C              NEW LINE.
C     IADDRS = POINTER TO ID LOCATION OF  FIRST  SYMBOL  IN
C              STATEMENT.
C            = IN  STATEMENT WHICH DEFINES A TABLE ENTRY IS
C              POINTER  TO ID  LOCATION  OF  FIRST  UNKNOWN
C              ADDRESS.
C            = IN STATEMENT WHICH DEFINES SYMBOL IS POINTER
C              TO ID LOCATION OF NEW SYMBOL.   IKODE IS THE
C              POINTER TO THE OLD ID LOCATION.   THE SYMBOL
C              APPEARS TWICE IN SYMBOL DICTIONARY UNTIL THE
C              DEFINITION IS COMPLETED.
C     IADJST = NUMBER BY WHICH  SHIFTS  ARE  MULTILPIED  TO
C              OBTAIN EXPONENT OF REDUCED BYTE SIZE.
C     IARG   = POINTER  TO  BACKPOINTER  OF  DATA  CELL  OF
C              DEFERRED USER-DEFINED FUNCTION
C     IBASE  = REDUCED BYTE SIZE (2 TO 17 IF THE  SPECIFIED
C              BYTE  SIZE  IS A POWER OF THE NUMBERS WITHIN
C              THIS RANGE, OTHERWISE IT  IS  THE  SPECIFIED
C              BYTE SIZE DIRECTLY).
C     IBLANK = ALPHAMERIC BREAK CHARACTER (BLANK)
C     IBYTE  = REDUCED SIZE OF  BYTE INTO WHICH  A PROPERLY
C              SHIFTED ONE IS DEPOSITED  BY BIT OPERATOR.
C     IDBG   = UNIT ON WHICH TBLDBG PRINTS ITS OUTPUT.
C     IDGT   = ARRAY OF  ALPHAMERIC CHARACTERS  0 THROUGH 9
C              AND LETTERS A THROUGH F (USED IN HEXADECIMAL
C              INTEGERS).
C     IERR   = ERROR SWITCH
C            = -1, IT IS ERROR IF MORE SYMBOLS FOLLOW.
C            = 0, NO ERRORS DETECTED.
C            = 1, ERROR DETECTED.
C            = 2, FIRST LINE OF STATEMENT IN ERROR HAS BEEN
C              PRINTED.
C     IFILL  = MINIMUM NUMBER OF ENTRIES TO BE ASSEMBLED IN
C              PRESENT TABLE.   TABLE IS EXTENDED WITH ZERO
C              ENTRIES TO THIS LIMIT.  SET BY FIL OPERATOR.
C     IFKNT  = COUNT OF IFE OR  IFN  OPERATORS  VERSUS  END
C              OPERATORS  WHEN  WITHIN THE RANGE OF A FALSE
C              IFE OR IFN.
C     IIARG  = STORAGE OF IARG FOR DESELECTED INPUT BUFFER.
C     IKODE  = VALUE  OF  IDENTIFIER  OF  FIRST  SYMBOL  IN
C              STATEMENT. POINTER TO OLD ID LOCATION DURING
C              SYMBOL DEFINITION (SEE IADDRS ABOVE).
C     ILEFT  = POSITION IN LETTER ARRAY OF  LEFT  CHARACTER
C              OF PRESENT SYMBOL.
C            = LT.0, BYTE PATTERN SIGNALS ORIGIN INCREMENT.
C            = GT.KMAX, STATEMENT IS  CONTINUED ON THE NEXT
C              LINE.
C     ILINE  = NUMBER  OF  LINES  READ  IN   ON   PRESENTLY
C              SELECTED INPUT DEVICE.
C     ILOOP  = NUMBER OF TIMES  TEXT REPLACEMENT  PERMITTED
C              IN SINGLE LINE.   DEFAULT VALUE  OF 1000 CAN
C              BE CHANGED  BY LMT  OPERATOR.   IF NEGATIVE,
C              LIMIT IS ABSOLUTE  VALUE AND A TRACE OF TEXT
C              REPLACEMENTS IS PRINTED.
C     ILPT   = UNIT NUMBER FOR LISTINGS.
C     ILTR   = NUMBER OF RIGHTMOST NON-BLANK  CHARACTER  IN
C              LINE  OF  TEXT  READ FROM PRESENTLY SELECTED
C              INPUT DEVICE.
C     IMASK  = POINTER TO ID LOCATION OF BYTE POINTER  CELL
C              FOR  BYTE  PATTERN TURNED ON BY TON OPERATOR
C              (ZERO IF NO BYTE PATTERN TURNED ON BY TON).
C     IMAX   = NUMBER OF CHARACTERS  PER LINE FOR INPUT NOT
C              READ FROM TELETYPE.
C     IMOST  = VALUE OF MOST WHEN  LAST CONSTANT WAS PLACED
C              INTO A TABLE ENTRY.  USED TO RESTORE MOST TO
C              THIS VALUE WHEN A PACKING PATTERN SPECIFYING
C              ORIGIN INCREMENT IS REPLACED BY ANOTHER.
C     INLINE = 0, IT HAS NOT BEEN DETERMINED IF THE PRESENT
C              LINE IS A CONTINUATION OF THE PREVIOUS LINE.
C              IF FIRST SYMBOL IS NOT THE CONTINUATION SYM-
C              BOL ,, OR A COMMENT INDICATION, THE PREVIOUS
C              STATEMENT MUST BE  TERMINATED BEFORE THE NEW
C              LINE CAN BE PROCESSED.
C            = 1, TEST FOR CLOSURE OF PREVIOUS STATEMENT IS
C              NOT NECESSARY.
C     INSERT = NUMBER OF  ENTRIES ASSEMBLED  BY THE PRESENT
C              STATEMENT THROUGH  THE LAST ENTRY INTO WHICH
C              AN ITEM ACTUALLY WAS PLACED.  USED TO RETURN
C              ENTRY COUNT  TO FORMER VALUE  WHEN BYTE MASK
C              DIRECTS ZERO ENTRIES AFTER ITS LAST ARGUMENT
C              BUT NO MORE CONSTANTS APPEAR IN STATEMENT.
C     INSN   = ARRAY CONTAINING  PREFIX OF  SYMBOL BY WHICH
C              NST (NUMERIC SYMBOL TEXT)  OPERATOR REPLACES
C              ITSELF.  SET BY NSN OPERATOR.
C     IOCT   = SCRATCH ARRAY  USED TO PRINT  OCTAL NUMBERS.
C     IOPRTR = IDENTIFIER  OF  OPERATORS  WHICH  REMAIN  IN
C              EFFECT FOR FOLLOWING SYMBOL OR SYMBOLS.
C     IORDER = 0, SUBSEQUENT SYMBOLS DEFINED BY EITHER = OR
C              == ARE TO BE PLACED  IN UNORDERED PORTION OF
C              DICTIONARY.
C            = 1, SUBSEQUENT SYMBOLS DEFINED BY EITHER = OR
C              == ARE TO  BE PLACED  IN ORDERED  PORTION OF
C              DICTIONARY.
C     IOUT   = UNIT NUMBER OF DEVICE ONTO  WHICH  A  BACKUP
C              COPY IS WRITTEN OF A TABLE WHICH IS INPUT ON
C              THE TELETYPE.  NO BACKUP IF IOUT EQUAL ITTY.
C     IPAREN = VALUE OF  ISIGN AT  START OF  CONSTANT SHIFT
C              PHRASE.
C     IPFX   = PRECISION OF ENTRY FROM WHICH VALUE IS TO BE
C              TAKEN   WHEN  MULTIPLE   PRECISION  CONSTANT
C              FOLLOWS AN OPERATOR WHICH CAN TAKE A DECIMAL
C              INTEGER PREFIX.
C            = NEGATIVE, PRECISION OF  CONSTANT USED RATHER
C              THAN VALUE.
C            = 0, (DEFAULT)  VALUE OF CONSTANT  IS VALUE OF
C              HIGHEST PRECISION WORD IN CONSTANT.
C     IPNCTN = ORIGINAL  ARRAY  OF  ALPHAMERIC  PUNCTUATION
C              (SEPARATOR) CHARACTERS.
C     IPRCN  = NUMBER OF  BITS PER  WORD FOR  BIT OPERATOR.
C              NEGATIVE VALUE CAUSES BIT OPERATOR NUMBERING
C              TO BE FROM LEFT TO RIGHT.
C     IRADIX = RADIX UNDER WHICH INTEGERS ARE INTERPRETED.
C     IREAD  = UNIT  NUMBER  OF  PRESENTLY  SELECTED  INPUT
C              DEVICE.
C     IREPT  = NUMBER OF ENTRIES WHICH FOLLOWING  STATEMENT
C              IS TO GENERATE IN ASSEMBLED TABLE.
C     IRIGHT = POSITION IN LETTER ARRAY OF RIGHT  CHARACTER
C              OF PRESENT SYMBOL.
C     IRMV   = DURING RENAME  DEFINITION POINTS  TO POINTER
C              AT START OF THE OLD NAME.
C     ISHIFT = NUMBER  OF  IBASE  UNITS   WHICH   FOLLOWING
C              CONSTANT  IS TO BE SHIFTED BEFORE ENTRY INTO
C              SYMBOL DEFINITION OR TABLE ENTRY.
C     ISIGN  = OPERATION  TO  BE  PERFORMED  ON   FOLLOWING
C              CONSTANT  AFTER  IT  IS  SHIFTED  BUT BEFORE
C              ENTRY INTO SYMBOL DEFINITION OR TABLE ENTRY.
C            = -1,  NO SIGN YET SPECIFIED.
C            = 0, EXCLUSIVE OR
C            = 1, AND
C            = 2,  ADDITION  (DEFAULT  IF  CONSTANT  IS  AN
C              ADDRESS OR IF IBASE IS NOT 2)
C            = 3, SUBTRACTION.
C            = 4, INCLUSIVE OR GIVEN BY IOR OPERATOR.
C     ISKIP  = NUMBER OF SYMBOLS YET  TO BE SKIPPED IN PRE-
C              SENT STATEMENT  WITHIN RANGE  OF UNFULFILLED
C              DO-IF CLASS OPERATOR.
C     ISTAR  = ALPHAMERIC CHARACTER USED TO MARK SYMBOLS IN
C              ERROR (ASTERISK).
C     ISTORE = ARRAY  CONTAINING INITIALLY  DEFINED  SYMBOL
C              DICTIONARY.  FOR EACH SYMBOL CONTAINS NUMBER
C              OF  LETTERS,  VALUE OF  IDENTIFIER,  AND THE
C              LETTERS OF THE SYMBOL.   ARRAY IS TERMINATED
C              BY ZERO IN NUMBER OF LETTERS ENTRY.
C     ITEN   = VALUE OF INTEGER SYMBOL OR OF INTEGER PREFIX
C              WITH RADIX 10.
C     ITEST  = NUMBER OF ENTRIES TO BE FOUND IN TEST CASE.
C     ITITLE = ARRAY CONTAINING  ALPHAMERIC  CHARACTERS  OF
C              NAME TO BE USED IN DATA STATEMENTS GENERATED
C              AS OUTPUT.
C     ITTY   = UNIT NUMBER FOR TELETYPE.
C     IVALUE = VALUE  OF OPERATOR  WHICH HAS  AN ADDITIONAL
C              ARGUMENT.  FOR EXAMPLE, USED TO STORE NUMBER
C              OF SYMBOLS SPECIFIED BY DO-IF CLASS OPERATOR
C              UNTIL SYMBOL TO BE TESTED IS ENCOUNTERED.
C     IWIDE  = WIDTH OF  NUMBER FIELDS  IN DATA  STATEMENTS
C              GENERATED AS OUTPUT.
C     IWRITE = UNIT NUMBER OF DEVICE ONTO  WHICH  THE  DATA
C              STATEMENTS  GENERATED  AS  OUTPUT  ARE TO BE
C              WRITTEN.
C     JADJST = VALUE OF IADJST DURING SYMBOL DEFINITION.
C     JARG   = POSITIVE,  NUMBER OF SYMBOLS  WHICH DEFERRED
C              USER DEFINED  FUNCTION STILL  MUST ACCEPT AS
C              ARGUMENTS.
C     JBASE  = VALUE OF IBASE DURING SYMBOL DEFINITION.
C            = VALUE OF IBASE WHEN FIRST  LOC  OPERATOR  IS
C              ENCOUNTERED IN A TABLE ENTRY.
C     JBLANK = 0,  NO  OUTPUT  HAS  BEEN  WRITTEN  ON   THE
C              TELETYPE.
C            = 1, SOMETHING HAS BEEN WRITTEN ON  THE  TELE-
C              TYPE  SO  A  BLANK LINE SHOULD BE WRITTEN ON
C              TELETYPE   BEFORE   ACCEPTING   INPUT   FROM
C              TELETYPE.
C     JBYTE  = NUMBER IF IBYTE  UNITS WHICH ONE  IS SHIFTED
C              BEFORE DEPOSIT INTO  ADDRESS SPECIFED BY BIT
C              OPERATOR.
C     JERR   = NUMBER OF LAST LINE PROBABLY TOO LONG.
C     JFKNT  = COUNT OF IFE OR  IFN  OPERATORS  VERSUS  END
C              OPERATORS  WHEN  NOT  WITHIN  THE RANGE OF A
C              FALSE IFE OR IFN.
C     JJARG  = STORAGE OF JARG FOR DESELECTED INPUT BUFFER.
C     JKODE  = ARRAY OF IDENTIFIERS  OF OPERATORS WHICH CAN
C              HAVE DECIMAL INTEGER PREFIXES.
C     JLEFT  = POSITION IN LETTER ARRAY OF  LEFT  CHARACTER
C              OF PRESENT STATEMENT.
C     JLOOP  = VALUE OF LOOP FOR DESELECTED INPUT DEVICE.
C     JLTR   = VALUE OF MLTR IN TEXT  BUFFER FOR DESELECTED
C              INPUT  DEVICE.   STATEMENT  BREAK IS  FORCED
C              WHEN  PROCESS  TEXT  THROUGH THIS  NUMBER OF
C              CHARACTERS WHEN AGAIN READ FROM THIS BUFFER.
C     JMASK  = VALUE OF IMASK WHEN START SYMBOL DEFINITION.
C     JNSN   = NUMBER OF CHARACTERS IN INSN ARRAY.
C     JOPRTR = IDENTIFIER OF OPERATORS IN  RANGE OF = OR ==
C              AND WHICH CAN HAVE OWN ARGUMENT.
C            = 1 UNTIL A SYMBOL IS DEFINED.
C            = 21 WHEN FIN OPERATOR OR END-OF-FILE READ.
C     JMAX   = NUMBER OF CHARACTERS PER LINE FOR INPUT READ
C              FROM TELETYPE.
C     JMORE  = VALUE OF  MORE WHEN  FIRST  LOC OPERATOR  IS
C              ENCOUNTERED IN A TABLE ENTRY.
C     JPAREN = VALUE OF  MORE AT  START OF  CONSTANT  SHIFT
C              PHRASE.
C     JPFX   = LAST NON-NEGATIVE IPFX OUTSIDE = DEFINITION.
C     JPNCTN = ARRAY CONTAINING  ALPHAMERIC SEPARATOR CHAR-
C              ACTERS AS DEFINED INITIALLY  BY IPNCTN ARRAY
C              OR AS SET BY ACC OPERATOR.
C     JRADIX = RADIX FOR INTEGERS IN RANGE OF = OR ==.
C     JRIGHT = POSITION IN LETTER ARRAY OF RIGHT  CHARACTER
C              OF PRESENT STATEMENT.
C     JSHIFT = VALUE OF ISHIFT WHEN FIRST LOC  OPERATOR  IS
C              ENCOUNTERED IN A TABLE ENTRY.
C     JSIGN  = VALUE OF ISIGN WHEN FIRST  LOC  OPERATOR  IS
C              ENCOUNTERED IN A TABLE ENTRY.
C            = -1, NO FIRST LOC IN STATEMENT.
C     JSTFY  = CHARACTER  WIDTH  OF  FIELD  INTO  WHICH  IS
C              PLACED NUMERIC PORTION  OF TEXT BY WHICH NST
C              REPLACES ITSELF.   NUMBER IS LEFT  JUSTIFIED
C              IF JSTFY IS ZERO.
C     JVALUE = ACCUMULATED  VALUE WITHIN A  PARENTHETICICAL
C              EXPRESSION AFTER WORD WHICH COULD HAVE TAKEN
C              INTEGER PREFIX BUT DID NOT.
C     KADJST = VALUE OF  IADJST  WHEN  A  BYTE  PATTERN  IS
C              ENCOUNTERED.
C     KARG   = RELATIVE  DISTANCE FROM  IARG TO  SECTION OF
C              DATA CELL HOLDING NEXT INSERTION.
C     KBASE  = VALUE  OF  IBASE  WHEN  A  BYTE  PATTERN  IS
C              ENCOUNTERED.
C     KERR   = VALUE OF JERR FOR DESELECTED INPUT DEVICE.
C     KIND   = THE CHARACTER CLASS OF THE PRESENT SYMBOL.
C     KKARG  = STORAGE OF KARG FOR DESELECTED INPUT BUFFER.
C     KLINE  = NUMBER  OF  LINES  READ  IN   ON   PRESENTLY
C              DESELECTED  (BY  TTY OR ==  OPERATORS) INPUT
C              DEVICE.
C     KLM    = COLUMN WIDTH OF DATA STATEMENT OUTPUT.
C     KLTR   = NUMBER OF RIGHTMOST NON-BLANK  CHARACTER  IN
C              LINE   OF  TEXT  LAST  READ  FROM  PRESENTLY
C              DESELECTED INPUT DEVICE.
C     KMASK  = VALUE OF LMASK WHEN START SYMBOL DEFINITION.
C     KMAX   = DIMENSION OF LETTER  AND LTTR ARRAYS USED TO
C              STORE A  SINGLE LINE  OF TEXT.   LARGER THAN
C              IMAX OR JMAX TO ALLOW  FOR SOME EXPANSION BY
C              TEXT REPLACEMENT OPERATORS.
C     KNSN   = NUMERIC  SUFFIX OF  THE SYMBOL  BY WHICH THE
C              NST (NUMERIC SYMBOL TEXT)  OPERATOR REPLACES
C              ITSELF.  SET BY NSV OPERATOR.
C     KNT    = ZERO UNTIL PAST ADDRESS PART OF STATEMENT.
C     KNTLTR = NUMBER  OF  CHARACTERS  DEFINED  IN   ITITLE
C              ARRAY.
C     KNTWRD = NUMBER OF SYMBOLS ENCOUNTERED WITHIN PRESENT
C              STATEMENT WITHOUT ANY  ADJUSTMENT EXCEPT FOR
C              NULL OPERATORS.
C     KODE   = VALUE OF IDENTIFIER OF PRESENT SYMBOL.
C            = ALSO CONTROL SWITCH FOR TBLCEL AND TBLDBG.
C     KPAREN = -3, WITHIN PARENTHETICAL EXPRESSION IN WHICH
C              IS SPECIFIED VALUE OF  AN AUTOMATIC ARGUMENT
C              AFTER ARG OPERATOR IN  BYTE MASK DEFINITION.
C            = -2, WITHIN PARENTHETICAL EXPRESSION IN WHICH
C              HAS NOT YET  BEEN SPECIFIED  THE VALUE OF AN
C              AUTOMATIC  ARGUMENT  AFTER ARG  OPERATOR  IN
C              BYTE MASK DEFINITION.
C            = -1,  AFTER ARG OPERATOR IN MASK DEFINITION.
C            = 0, NOT WITHIN PARENTHETICAL EXPRESSION.
C            = 1, WITHIN PARENTHETICAL EXPRESSION ELSEWHERE
C     KPNCTN = ARRAY OF CHARACTER CLASS NUMBERS PARALLEL TO
C              JPNCTN ARRAY.   USED TO DETERMINE  SEPARATOR
C              CHARACTERS WHICH CAN APPEAR TOGETHER TO FORM
C              A SINGLE SYMBOL.
C     KRADIX = RADIX FOR INTEGERS IN TABLE ENTRIES.
C     KREAD  = UNIT NUMBER OF  PRESENTLY  DESELECTED  INPUT
C              DEVICE.
C     KSHIFT = NUMBER OF BYTES TO BE SHIFTED  AS  SPECIFIED
C              BEFORE  CORRECTION  FOR  AMOUNT  ACTUAL BYTE
C              SIZE DIFFERS FROM SPECIFIED BYTE SIZE.
C     KSIGN  = SIGN WITHIN A PARENTHETICAL EXPRESSION AFTER
C              OPERATOR THAT COULD HAVE HAD INTEGER PREFIX.
C              MARKS TOP CELL  TO BE REMOVED  BY XSY OR XAD
C              OR TOP  ADDRESS CELL  TO BE REMOVED  BY SAV.
C              IN RANGE OF TEL  DETERMINES IF LONG OR SHORT
C              DEBUG OUTPUT IS TO BE GENERATED.
C     LARG   = POINTER TO RIGHT LETTER BEYOND WHICH JARG IS
C              DECREMENTED.
C     LEAST  = POSITION IN MASTER ARRAY OF LOWEST  LOCATION
C              IN SYMBOL DICTIONARY.
C     LENGTH = ARRAY  CONTAINING  POINTERS  TO  PORTION  OF
C              SYMBOL DICTIONARY ORDERRED BY LENGTH.
C     LETTER = ARRAY CONTAINING TEXT  READ  FROM  PRESENTLY
C              SELECTED INPUT DEVICE.
C     LLARG  = STORAGE OF LARG FOR DESELECTED INPUT BUFFER.
C     LMASK  = POINTER TO BOTTOM OF BYTE POINTER  CELL  FOR
C              BYTE PATTERN CURRENTLY IN EFFECT.
C     LMAX   = NUMBER OF CHARACTERS PER LINE  ON  PRESENTLY
C              SELECTED INPUT DEVICE.
C     LNGMIN = POINTER TO THE NEXT  LOCATION BELOW ORDERRED
C              PORTION OF SYMBOL DICTIONARY.
C     LOCK   = SWITCH WHICH  RECORDS  WHETHER  ANYTING  HAS
C              BEEN  ENTERED  INTO A TABLE ENTRY.
C            = 0, NOTHING ENTERED INTO TABLE ENTRY.
C            = 1, ONLY A SINGLE UNKNOWN ADDRESS SPECIFIED.
C            = 2, TABLE ENTRY CONTAINS SOMETHING OTHER THAN
C              A SINGLE UNKNOWN ADDRESS.
C     LOOP   = NUMBER OF TEXT REPLACEMENTS IN PRESENT LINE.
C              INFINITE LOOP ASSUMED  IF THIS REACHES 1000.
C     LPNCTN = NUMBER OF CHARACTERS IN JPNCTN ARRAY.
C     LRADIX = JRADIX VALUE WHEN START SYMBOL DEFINITION.
C     LSIGN  = 1 PLUS SIGN AT THE START  OF A PARENTHETICAL
C              EXPRESSION AFTER WORD WHICH COULD HAVE TAKEN
C              INTEGER PREFIX BUT DID NOT.
C     LSTNEW = POINTER TO  IDENTIFIER  OF  LOWEST  CELL  IN
C              SYMBOL DICTIONARY.
C     LTTR   = ARRAY CONTAINING TEXT  READ  FROM  PRESENTLY
C              DESELECTED INPUT DEVICE.
C     MASK   = POINTER TO PRESENTLY USED  BYTE  INFORMATION
C              IN   BYTE  POINTER  CELL  FOR  BYTE  PATTERN
C              CURRENTLY IN EFFECT.
C     MASTER = LARGE ARRAY CONTAINING ASSEMBLED  TABLE  AND
C              SYMBOL DICTONARY.
C     MAX    = DIMENSION OF MASTER ARRAY.
C     MIN    = MINIMUM AMOUNT OF  MASTER ARRAY SPACE DURING
C              ASSEMBLY OF TABLE.
C     MLEFT  = POSITION IN LETTER ARRAY OF  LEFT  CHARACTER
C              OF SYMBOL IN ERROR.
C     MLTR   = RIGHT END OF THE TEXT INSERTED AT END OF THE
C              STATEMENT BY A TEXT STRING OPERATOR.  END OF
C              STATEMENT IS FORCED  WHEN THIS TEXT HAS BEEN
C              INTERPRETED.
C     MORE   = NUMBER OF  TABLE ENTRIES AHEAD  OF MOST INTO
C              WHICH NEXT CONSTANT IS TO BE DEPOSITED.
C     MOST   = NUMBER OF TABLE ENTRIES PRESENTLY ASSEMBLED.
C              NUMBER OF TABLE ENTRIES  BELOW CURRENT TABLE
C              ENTRY ORIGIN.
C     MRIGHT = POSITION IN LETTER ARRAY OF RIGHT  CHARACTER
C              OF SYMBOL IN ERROR.
C     MULT   = NUMBER  OF ENTRIES  ASSEMBLED  FROM  PRESENT
C              STATEMENT.
C     NEW    = POINTER TO IDENTIFIER OF PRESENT SYMBOL.
C     NEXT   = MAXIMUM VALUE OF MORE  IN PRESENT STATEMENT.
C              NUMBER OF INITIALIZED ENTRIES BEYOND MOST.
C     NLTR   = MINIMUM VALUE OF MLTR  DURING CURRENT LETTER
C              BUFFER LOADING.
C     NMORE  = LAST VALUE OF WORD COUNT SET BY WRD OPERATOR
C              NOT BY PACKING PATTERN. DETERMINES PRECISION
C              OF BIT OPERATOR.
C     NSIGN  = LAST VALUE OF SIGN SET BY +, - OR IOR OPERA-
C              TOR NOT BY PACKING PATTERN.
C     NTITLE = TEMPLATE TO RESTORE ITITLE ARRAY TO THE NAME
C              TBLTRN.
C     NUMBER = VALUE OF PRESENT SYMBOL  (IF  SYMBOL  IS  AN
C              INTEGER,  THE  VALUE  OF  THAT INTEGER UNDER
C              PRESENT RADIX).
C
      END
