      SUBROUTINE PLTBOX(KONTRL,IWIDE,IHIGH,IX,IY,JX,JY)
C
C     DONALD BARTH, CHEMISTRY DEPT., HARVARD UNIVERISTY
C
C     ROUTINE TO OUTLINE POINT OR LINE WITH BOX OR DIAMOND
C
C     KONTRL = 0, PLOT AS BOX (EDGES AT 0 AND 90 DEGREES)
C            = 1, PLOT AS DIAMOND (EDGES AT DIAGONAL)
C     IWIDE  = HALF-WIDTH OF BOX AROUND POINT OR LINE
C     IHIGH  = -1, BOX EXTENDS BEYOND ENDS OF LINE
C            = 0, BOX TOUCHES ENDS OF LINE
C            = POSITIVE, HALF-HEIGHT OF BOX AROUND
C              POINT (JX AND JY ARE NOT USED)
C     IX     = HORIZONTAL COORDINATE OF POINT OR
C              OF END 1 OF LINE
C     IY     = VERTICAL COORDINATE OF POINT OR
C              OF END 1 OF LINE
C     JX     = HORIZONTAL COORDINATE OF END 2 OF LINE
C     JY     = VERTICAL COORDINATE OF END 2 OF LINE
C
C     TEST IF LINE OR POINT IS TO BE PLOTTED
      IF(IHIGH)7,7,1
C
C     PLOT BOX OR DIAMOND AROUND POINT
C
    1 MOVEX=0
      MOVEY=IWIDE
      KX=IX
      KY=IY+IHIGH
      LX=IX
      LY=IY-IHIGH
      GO TO 29
C
C     PLOT BOX OR DIAMOND AROUND LINE
C
C     DETERMINE OCTANT CONTAINING LINE
    7 IDSTX=JX-IX
      IDSTY=JY-IY
      IF(IDSTX-IDSTY)8,9,10
    8 IF(IDSTX+IDSTY)14,11,11
    9 IF(IDSTX+IDSTY)13,32,12
   10 IF(IDSTX+IDSTY)13,12,12
   11 MOVEY=IWIDE
      MOVEX=(IDSTX*MOVEY)/IDSTY
      IF(IDSTX)15,16,16
   12 MOVEX=IWIDE
      MOVEY=(IDSTY*MOVEX)/IDSTX
      IF(IDSTY)17,18,18
   13 MOVEY=-IWIDE
      MOVEX=(IDSTX*MOVEY)/IDSTY
      IF(IDSTX)15,16,16
   14 MOVEX=-IWIDE
      MOVEY=(IDSTY*MOVEX)/IDSTX
      IF(IDSTY)17,18,18
C
C     CORRECT WIDTH OF STRIP FOR ANGLE OF LINE
   15 KX=IWIDE+(MOVEX/4)
      GO TO 19
   16 KX=IWIDE-(MOVEX/4)
      GO TO 19
   17 KX=IWIDE+(MOVEY/4)
      GO TO 19
   18 KX=IWIDE-(MOVEY/4)
   19 MOVEX=(KX*MOVEX)/IWIDE
      MOVEY=(KX*MOVEY)/IWIDE
   22 IF(IHIGH)23,24,24
C
C     DEFINE BORDERS EXTENDING BEYOND LINE ENDS
   23 KX=IX-MOVEX
      KY=IY-MOVEY
      LX=JX+MOVEX
      LY=JY+MOVEY
      GO TO 29
C
C     DEFINE BORDERS TOUCHING LINE ENDS
   24 KX=IX
      KY=IY
      LX=JX
      LY=JY
C
C     OUTLINE RECTANGLE
   29 IF(KONTRL.NE.0)GO TO 44
      CALL CRTOFF(KX+MOVEY,KY-MOVEX)
      CALL CRTON (LX+MOVEY,LY-MOVEX)
      CALL CRTON (LX-MOVEY,LY+MOVEX)
      CALL CRTON (KX-MOVEY,KY+MOVEX)
      CALL CRTON (KX+MOVEY,KY-MOVEX)
      GO TO 32
C
C     OUTLINE DIAMOND
   44 CALL CRTOFF(KX,KY)
      CALL CRTON ((((KX+LX)/2)+MOVEY),(((KY+LY)/2)-MOVEX))
      CALL CRTON (LX,LY)
      CALL CRTON ((((KX+LX)/2)-MOVEY),(((KY+LY)/2)+MOVEX))
      CALL CRTON (KX,KY)
C
C     RETURN TO CALLING PROGRAM
   32 RETURN
      END
