      FUNCTION IPLDST(IX,IY,JX,JY,IPENX,IPENY)
C
C     DONALD BARTH, CHEMISTRY DEPT., HARVARD UNIVERSITY
C
C     FUNCTION TO RETURN DISTANCE FROM LINE HAVING ENDPOINTS
C
C     IPLDST = RETURNED WITH DISTANCE
C
C     IX     = HORIZONTAL COORDINATE OF START OF LINE
C     IY     = VERTICAL COORDINATE OF START OF LINE
C     JX     = HORIZONTAL COORDINATE OF END OF LINE
C     JY     = VERTICAL COORDINATE OF END OF LINE
C     IPENX  = HORIZONTAL COORDINATE OF REFERENCE POINT
C     IPENY  = VERTICAL COORDINATE OF REFERENCE POINT
C
      IDSTX=JX-IX
      IDSTY=JY-IY
      IF((IDSTX*(IPENX-IX))+(IDSTY*(IPENY-IY)))26,26,27
   27 IF((IDSTX*(IPENX-JX))+(IDSTY*(IPENY-JY)))30,30,31
C
C     STYLUS CLOSEST TO AN END OF LINE
   26 IDSTX=IPENX-IX
      IDSTY=IPENY-IY
      GO TO 300
   31 IDSTX=IPENX-JX
      IDSTY=IPENY-JY
      GO TO 300
C
C     STYLUS BETWEEN ENDS OF LINE
   30 I=((IDSTX*(IPENX-IX))+(IDSTY*(IPENY-IY)))/1023
      J=((IDSTX*IDSTX)+(IDSTY*IDSTY))/1023
      IF(J.EQ.0)GO TO 26
      IDSTX=IPENX-IX-((I*IDSTX)/J)
      IDSTY=IPENY-IY-((I*IDSTY)/J)
C
C     CALCULATE DISTANCE
  300 IF(IDSTX.LT.0)IDSTX=-IDSTX
      IF(IDSTY.LT.0)IDSTY=-IDSTY
      IF(IDSTX.GT.IDSTY)GO TO 400
      IPLDST=IDSTY+(IDSTX/2)
      GO TO 500
  400 IPLDST=IDSTX+(IDSTY/2)
  500 RETURN
      END
