(* this program outputs a list of disk usage to the file output.
   it is intended for reviewing the whole system, in which case
   you would tell it <*>, though it can be used for any directory
   specification desired. *)

program space(output);
var
curdir,dirname:packed array[1:50]of char;
i,dirno,work,used,perm:integer;
ratio:real;
flags:set of 0..35;
wild:Boolean;
total:integer;

begin
1:
write(tty,'Directory to check: ');
readln(tty); read(tty,dirname:i); dirname[i+1] := chr(0);
jsys(553B%rcdir\;[16],dirname,0;flags,dirno,dirno); (* first directory*)
wild := 6 in flags;				    (* in wild group *)
if (3 in flags) or (4 in flags)
  then begin writeln(tty,'Illegal directory spec'); goto 1 end;
jsys(220B%odtim\;curdir,-1,-1);  (* get current day-time *)
for i := 1 to 50 do
  if curdir[i] = chr(0) 
    then goto 2;
2:
writeln;
writeln('Disk space usage for ',curdir:i-1);
writeln;
writeln('Directory',' ':42,' Quota  ','  Used  ',' Ratio');
writeln;
total := 0;
repeat
  jsys(305B%gtdal\;dirno;work,used,perm);  (* get quotas and amt. used*)
  curdir := '                                                  ';
  jsys(41B%dirst\,2;curdir,dirno);	   (* get current directory *)
  if perm = 377777000000B	(* this is code for infinity *)
    then perm := 0;
  if perm = 0
    then ratio := 0
    else ratio := used/perm;
  if used > 0  (* can be negative due to some odd bug *)
    then total := total+used;
  writeln(curdir,perm:8,used:8,ratio:8:2);
  if wild
    then jsys(553B%rcdir\;[15,16],dirname,dirno;flags,dirno,dirno)
				(* advance to next if wildcard *)
 until (5 in flags) or not wild;
jsys(120B%stdev\,2;curdir;dirno,dirno);  (* get code for structure *)
jsys(214B%gdskc\;dirno;used,work);	(* get totals for structure  *)
writeln;
writeln('Total in use in group listed: ',total);
writeln('Total in use on structure:    ', used);
writeln('Total not in use on structure:',work)
end.

