


                    PPPP    L        OOO    TTTTT
                    P   P   L       O   O     T
                    PPPP    L       O   O     T
                    P       L       O   O     T
                    P       LLLLL    OOO      T

            M   M    AAA    N   N   U   U    AAA    L
            MM MM   A   A   NN  N   U   U   A   A   L
            M M M   AAAAA   N N N   U   U   AAAAA   L
            M   M   A   A   N   N   U   U   A   A   L
            M   M   A   A   N   N    UUU    A   A   LLLLL






                      CSM Plotting Manual

          ******** 1st draft for version 12A ********
         As of: March 10, 1983 *** NOT FINISHED YET ***
    **  This document has NOT been approved for printing **



          Colorado School of Mines - Computing Center
                      1600 Illinois Street
                        Golden, CO 80401
                         (303)273-3430



          This  manual  describes  the  hardware  and   software
     available for plotting at the Colorado School of Mines.

          The plotting package  is  a  set  of  FORTRAN-callable
     routines   written   in  MACRO-10  assembly  language.   In
     general, the plotting package is compatible  with  routines
     supplied  by  DEC  (Digital  Equipment Corporation) for use
     with  the  XY-10  CALCOMP  plotter,  but  with   additional
     features.













                               i



             Table of contents for Plotting Manual



Chapter 1       Policies
  1.1   Distribution
  1.2   Copies
  1.3   Graphic Terminals
  1.4   Window Size
  1.5   Standard Plotter Defaults

Chapter 2       Hardware
  2.1   General
  2.2   Houston Instruments DP-8 Plotter
  2.3   ARDS Graphics Terminal
  2.4   Tektronix Graphics Terminal
  2.5   GIGI Graphics Terminal
  2.6   ReGIS Plotter

Chapter 3       Software
  3.1   General
  3.2   Monitor PLOT Command
  3.3   Plot Window
  3.4   Coordinate System
  3.5   Symbol sets
  3.6   TEK Program

Chapter 4       Plotting Routines
  4.1   Core Plotting Routines
  4.1.1     Subroutine ERASE
  4.1.2     Subroutine FACTOR
  4.1.3     Subroutine NEWPEN
  4.1.4     Subroutine OPRTXT
  4.1.4     Subroutine ORIGIN
  4.1.6     Subroutine PAUSEP
  4.1.7     Subroutine PLOT
  4.1.8     Subroutine PLOTS
  4.1.9     Subroutine ROTATE
  4.1.10    Subroutine SETWIN
  4.1.11    Subroutine SUBWIN
  4.1.12    Subroutine TITLE
  4.1.13    Subroutine WHERE
  4.1.14    Subroutine XHAIRS
  4.2   Graphing Routines
  4.2.1     Subroutine AXES
  4.2.2     Subroutine AXIS
  4.2.3     Subroutine DASHLN
  4.2.4     Subroutine GRID
  4.2.5     Subroutine LINE
  4.2.6     Subroutine LOGAX
  4.2.7     Subroutine LOGAXS
  4.2.8     Subroutine SCALE



                               ii



  4.3   Labeling Routines
  4.3.1     Subroutine NUMBER
  4.3.2     Subroutine SETSYM
  4.3.3     Subroutine SYMBOL
  4.4   Obsolete Routines
  4.4.1     Function IPLOT
  4.4.2     Function ISETAB
  4.4.3     Function MSETAB

Chapter 5       3-D and Contouring Routines
  5.1   Contouring Routines
  5.1.1     Subroutine CALCNT
  5.1.2     Subroutine CALSIZ
  5.1.3     Subroutine GRIDER
  5.2   3-D Routines

Chapter 6       Programming Techniques
  6.1   Starting and Stopping Plotting
  6.2   Debugging Techniques
  6.3   Warning and Error Messages

Appendix A      Sample Programs
  A.1   LINPLT
  A.2   SYMBOL Tables

Appendix B      Library Programs
  B.1   LBY:EZPLOT
  B.2   LBY:GRAPH
  B.3   LBY:SIMPLT
  B.4   SYS:DRAW

Appendix C      Further Documentation
  C.1   HELP files
  C.2   DOC:PLOT.DOC

Appendix D      SYMBOL Tables
  D.1   CSM Standard
  D.2   CSM Secondary
  D.3   Olde English
  D.4   Old German
  D.5   Old Italian
  D.6   Script
  D.7   Simplex Roman
  D.8   Simplex Italics
  D.9   Triplex Roman
  D.10  Triplex Italics
  D.11  Hershey's letters
  D.12  Simplex Greek
  D.13  Duplex Greek

Index



                              iii












                           CHAPTER 1

                            POLICIES



     1.1  DISTRIBUTION.

          Plots sent to the  Houston  Instruments  DP-8  plotter
     will be removed from the plotter three times each day.  The
     plots will then be available for pick-up  at  the  Dispatch
     counter  in  room  287  of the Green Center.  The same plot
     removal schedule  will  be  observed  for  hours  that  the
     Computing Center is open on weekends.

           Plots will be removed from the plotter at:

                            11:30 AM

                             4:30 PM

                            11:30 PM



     1.2  COPIES.

          The preferred method of making multiple copies  is  to
     duplicate  a  single  copy  of a plot on a copying machine.
     This method is much less expensive than plotting each  copy
     that  is  needed.   If  multiple  copies  are  needed,  and
     duplicating is not possible (eg.  a 36 by 36 inch plot with
     multiple  colors), the use of the /COPIES:n switch with the
     plot command will cause multiple copies of the plot without
     the  expense  of  running  the plotting program repeatedly.
     Misuse of the copies specification may result  in  loss  of
     plotting privileges.








                              1-1
Policies


     1.3  GRAPHIC TERMINALS.

          There  are   five   TEKTRONIX   4000-series   graphics
     terminals  located  in the graphics room off of the Student
     Workroom  (Room  285,  Green  Center).   The  4025   Raster
     terminal  and the 4012 Interactive terminal may be used for
     creating plots.  The three 4006 terminals are restricted to
     viewing  plots  only.   There  is  30  minute  limit on the
     terminals when others are waiting.

          Use of the graphics terminal for non-graphics work  is
     prohibited;   such  use  may result in loss of all computer
     use privileges.  This restriction is made  to  help  extend
     the limited lifetime of the storage tube in the terminals.



     1.4  WINDOW SIZE.

          The plotting software by default limits a  plot  to  a
     size  of  11  by 11 inches.  Attempts to exceed this window
     are considered to be errors unless the window size has been
     increased.  With evidence of plotting ability, the user can
     have his allowed maximum window size  expanded  beyond  the
     standard  11 by 11 inches.  Permission to expand the window
     can be requested by submitting  the  Request  for  Plotting
     Window  Increase  form  which  is available at the Dispatch
     counter.  The overall maximum window size possible  on  the
     DP-8 plotter is 35 by 240 inches.



     1.5  STANDARD PLOTTER DEFAULTS.


     PAPER - Standard = 12 inches wide, /FORMS:NORMAL
           Extra Wide = 36 inches wide, /FORMS:P311

          The plotter uses a standard  form  of  12  inch  white
     tractor  driven  plotter  paper  (11 inches of useable plot
     area).  The default window size allows up to 11  inches  of
     this  continuous  form  to  be  used  in  a  plot.   Window
     expansion (if expansion privileges have been granted)  will
     allow  up to 240 inches of horizontal length (X-axis) for a
     single plot.  Vertical expansion (Y-axis) up to  35  inches
     is  possible  with window privileges and the use of Special
     Forms.  36 inch paper has a forms name of "P311".


     PENS - Standard = Blue,  NEWPEN(1) (default)
                     = Black, NEWPEN(2) (better for photocopies)
                     = Red,   NEWPEN(3)


                              1-2
                                                        Policies


          The standard (default) pen set up has three ball-point
     pens;   pen  1 has blue ink, pen 2 has black ink, and pen 3
     has red ink.  Other pen sets  can  be  requested  by  prior
     arrangement and use of the OPRTXT subroutine to communicate
     the desired change to the operator at plot time.

















































                              1-3
Policies


                               *






























                               *






















                              1-4












                           CHAPTER 2

                            HARDWARE



     2.1  GENERAL.

          The  hardware  that  the  CSM  Computing  Center   has
     available for use as graphics devices include:

     1.  The  Houston  Instruments  DP-8   digital   incremental
         plotter.

     2.  TEKTRONIX 4012 Storage  Tube  type  graphics  terminal.
         (The  TEK  software  will also drive Models 4006, 4014,
         4016, 4019, and 4025.)

     3.  Digital Equipment Corporation GIGI  graphics  terminal.
         (The GIGI software also works on VT125 terminal.)

     4.  Houston Instruments DMP-4R table-top ReGIS plotter.




     2.2  HOUSTON INSTRUMENTS DP-8 PLOTTER.

          The Houston Instruments  DP-8  Digital  Plotter  is  a
     three  pen  electromechanical drum plotter operating on the
     digital  incremental  principle.   The   plotter   has   an
     incremental  step  size  of  0.0025  inches  (400 steps per
     inch).  It produces a plot by movement of the pen  relative
     to the surface of the recording paper.  The plotter accepts
     up to 36 inch wide continuous roll paper (including tractor
     drive  holes).   For  plotting the paper is pulled around a
     drum for X-axis (horizontal) motion,  and  the  three  pens
     move  along a rail parallel to the drum axis to give Y-axis
     (vertical) motion.  Subroutine PLOT  generates  information
     to  produce  incremental steps of plotter movement with pen
     up or down, in either the plus (+) or minus (-)  direction,
     along  either  axis.   At  full plotting speed, the plotter
     makes 1800 incremental steps per second (4.5 inches of line
     per second).

                              2-1
Hardware


          Plots do not go directly to  the  Houston  Instruments
     DP-8  plotter,  but are spooled.  This means that the plots
     are accumulated on disk, and sent to the  plot  queue  when
     the  PLOT  monitor  command  is  given.   A  special system
     program called SPROUT is run by the  Operator  to  actually
     send the plots to the plotter.






     T   --------------------------------------------------
     A  (                                                  )  S
     K  (  +Y   11 or 35 inches max                        )  U
     E  (  ^                                               )  P
        (  !                                               )  P
     U  (  !                                               )  L
     P  (  !                                               )  Y
        (  !                                               )
     S  (  !                                               )  S
     P  ( -+--------------------->  +X   240 inches max    )  P
     O  ( 0!                                               )  O
     O  (                                                  )  O
     L   --------------------------------------------------   L





                     Drum plotter operation

          There are two ways to use the SPOOLER package:

     1.  Use 'SPOOL' for IPLT in CALL PLOTS(IERR,'SPOOL').

     2.  Use zero for IPLT in CALL PLOTS(IERR,0).   This  second
         method  makes  it  easy  to  change  to the TEK or GIGI
         package by including SYS:TEKPLT.REL  or  SYS:RGSPLT.REL
         in the LOAD/EXECUTE command.




     2.3  ARDS GRAPHICS TERMINAL.

          The  ARDS  (Advanced  Remote  Display  Station)  is  a
     storage  tube  terminal similar to the TEKTRONIX terminals.
     CSM no  longer  has  an  ARDS  terminal,  but  software  is
     available for it.




                              2-2
                                                        Hardware


     2.4  TEKTRONIX GRAPHICS TERMINAL.

          The TEKTRONIX 4012 Graphic terminal is  a  TTY  device
     which   contains  a  storage  mode  cathode  ray  tube  for
     displaying graphics.  Any material that has been written on
     the  screen of the storage tube will be displayed until the
     entire screen is erased.  The screen can be manually erased
     by  pressing  the  'RESET  PAGE'  key  on  the terminal.  A
     program may erase the  screen  by  calling  the  subroutine
     ERASE.

          The TEKTRONIX terminal has a screen resolution of  100
     points  per inch, and a screen size of 7.8 by 10.24 inches.
     The software for the  TEKTRONIX  plotting  package  ignores
     references  to points that are within the universal window,
     but are off-screen.  To place the full 11 by 11 inch  image
     on  the  screen,  software  such  as  the TEK program use a
     scaling factor of 0.7 to reduce the entire plot.  The  4006
     and 4025 terminals have similar characteristics.

          Previewing plots with the TEKTRONIX graphics  terminal
     before  sending  them  to  the plotter is encouraged, since
     this helps reduce the production of unwanted plots.

          There are two ways to use the TEKTRONIX package:

     1.  Use 'TEK' for IPLT in CALL PLOTS(IERR,'TEK').

     2.  Include SYS:TEKPLT.REL in the LOAD/EXECUTE  command  if
         you are using CALL PLOTS(IERR,0).
         Example:  .EXECUTE MYPROG.FOR,SYS:TEKPLT.REL


          The TEK program can be used to preview plots  destined
     for  the DP-8 plotter.  (The TEK program understands how to
     talk to both TEKTRONIX and GIGI terminals.)


















                              2-3
Hardware


     2.5  GIGI GRAPHICS TERMINAL.

          The  GIGI  Graphic  terminal  from  Digital  Equipment
     Corporation  is  a TTY device which drives a TV monitor for
     displaying graphics.  Although the GIGI has the  capability
     of  shading and selectively erasing portions of the screen,
     the PLOT package treats the GIGI like a  TEKTRONIX  storage
     tube.   Subroutine  ERASE  may  be used to clear the entire
     screen.

          The GIGI terminal  has  a  screen  resolution  of  768
     horizontal by 480 vertical points (pixels).  With a 12 inch
     monitor, this is approximately 75 dots per  inch,  measured
     on the TV screen.  The data sent to the GIGI is scaled such
     that a plot requiring 11 by 11 inches on the  DP-8  plotter
     will fit on the GIGI screen.

          To be compatible with the DP-8 pen  plotter,  function
     NEWPEN  will  change  the  color  of the lines drawn on the
     screen.  (For black and white monitors, colors show  up  as
     different shades of gray.)

     NEWPEN(1) = Cyan (light blue) = light gray
     NEWPEN(2) = White (not black) = white
     NEWPEN(3) = Magenta (reddish) = dim gray

          There are two ways to use the GIGI package:

     1.  Use 'GIGI' for IPLT in CALL PLOTS(IERR,'GIGI').

     2.  Include SYS:RGSPLT.REL in the LOAD/EXECUTE  command  if
         you are using CALL PLOTS(IERR,0).
         Example:  .EXECUTE MYPROG.FOR,SYS:RGSPLT.REL


          The TEK program can be used to preview plots  destined
     for  the DP-8 plotter.  (The TEK program understands how to
     talk to both TEKTRONIX and GIGI terminals.)
















                              2-4
                                                        Hardware


     2.6  REGIS PLOTTER.

          The Houston Instruments DMP-4R is  table  top  plotter
     that speaks ReGIS just like the GIGI terminal.  It produces
     plots of up to 6 colors on an 8.5 by 11 inch paper.

          The ReGIS plotter uses  the  same  resolution  as  the
     GIGI;   768  horizontal  by  480 vertical points.  The data
     sent to the DMP-4R is scaled such that a plot requiring  11
     by 11 inches on the DP-8 plotter will fit on the paper.

          Subroutine NEWPEN can be used to change the pen color.

     NEWPEN(1) = Blue   NEWPEN(4) = Purple (set up by user)
     NEWPEN(2) = Black  NEWPEN(5) = Green (set up by user)
     NEWPEN(3) = Red    NEWPEN(6) = Orange (set up by user)

          There are two ways to use the ReGIS package:

     1.  Use 'DMP4R' for IPLT in CALL PLOTS(IERR,'DMP4R').

     2.  Include SYS:RGSPLT.REL in the LOAD/EXECUTE  command  if
         you are using CALL PLOTS(IERR,0).
         Example:  .EXECUTE MYPROG.FOR,SYS:RGSPLT.REL






























                              2-5
Hardware


                               *






























                               *






















                              2-6












                           CHAPTER 3

                       GRAPHICS SOFTWARE



     3.1  GENERAL.

          The Colorado School  of  Mines  Computing  Center  has
     several  types  of  graphics software available.  The major
     package is a set of FORTRAN callable subprograms  that  are
     generally   consistent   with   CALCOMP   software.   These
     subprograms have been written in FORTRAN-10  and  MACRO-10,
     and are generally called from FORTRAN programs.


                                NOTE

         ** Plotting cannot be done from SITGO-FORTRAN.  **

                     ------



          There are several stand-alone programs  available  for
     convenient  generation  of  graphs.   These include EZPLOT,
     GRAPH, SIMPLT, and DRAW.

          The TEK program allows a user to preview any plot that
     has  been prepared for the Houston Instruments DP-8 plotter
     on the TEKTRONIX or GIGI graphics terminals.



     3.2  MONITOR 'PLOT' COMMAND.

          Plots do not go directly to the DP-8 plotter when they
     are  generated,  but  are  spooled  on  the disk.  Spooling
     allows many users to generate  plots  simultaneously,  even
     while  the  plotter  is  actively working on another user's
     plot.  The monitor command 'PLOT' will transfer the spooled
     plot  file  to  the  list  of  plots to be processed by the
     plotter.



                              3-1
Graphics Software


          The form of the 'PLOT' command is:

                          .PLOT *.PLT

                          -

                               or

              .PLOT JOBNAM=FILESPEC(s) /SWITCH(es)

              -


     JOBNAM  is the optional name given to  the  plot.   If  the
          parameter  is  missing, then the first file name given
          is used as the default.

     FILESPEC(s) is a series of file specifications separated by
          commas  which  identify the file names, and optionally
          the device the file resides on, the project-programmer
          number  of  the directory, and sub-file directory(ies)
          which specify  which  files  are  being  sent  to  the
          plotter.   The  default is files with ".PLT" extension
          in your directory area.

     /SWITCH(es) are optional switch parameters which define how
          the files are to be processed.




     Switch            Description

     ------            -----------


     /COPIES:n       Output the specified file(s)  repeatedly  n
               times.   The  use  of  a  photocopier is strongly
               suggested  instead  of  this  switch,  since  the
               duplication  costs  are less, and this also frees
               the plotter for use by other users.

     /DISPOSE:DELETE  Delete the named file(s) after output.

     /DISPOSE:PRESERVE  Save the file after output.

     /DISPOSE:RENAME  Remove  the  file  from   your   directory
               immediately,  and  plot  it  from the QUE:  area.
               This is the default action for ".PLT" files.

     /FORMS:name     Place the output on  a  non-standard  form.
               Standard  forms  are 12 inch (11 useable plotting
               inches) white plotter paper.  36 inch  paper  (35
               useable plotting inches) has a form name of P311.



                              3-2
                                               Graphics Software


     /KILL           Remove the specified job from  the  plotter
               output queue.

     /MODIFY         Modify  the  specified  plot  queue  entry.
               Must  be  used  to  alter  the  switches  used in
               previously requested jobs.

          All other switches available are documented in the CSM
     Users  Handbook  and  in  the DECsystem-10 Operating System
     Commands Manual (under the QUEUE command).



                            EXAMPLES

                            --------

     Example:  To plot the spooled plotter files you have
     generated;

                          .PLOT *.PLT

                          -

     Example:  To remove the request for EZPLOT from the
     queue (the equals sign is required);

                       .PLOT EZPLOT=/KILL

                       -

                               or

                      .CANCEL PLOT EZPLOT

                      -

     Example:  To check the status of the PLOT queue;

                             .PLOT

                             -

















                              3-3
Graphics Software


     3.3  PLOT WINDOW.

          The CSM graphics software observes a limitation on the
     useable plotting area, which is called the plotting window.
     The  main  reason  for  the  plot  window  is  to   prevent
     undebugged  programs  from  going  wild and wasting plotter
     paper.  The window starts as being 11  inches  wide  by  11
     inches high.  The user can move the pen anywhere inside the
     window, but any line that attempts to go outside the window
     will be truncated at the border.  The pen is not allowed to
     move outside the window,  but  its  theoretic  position  is
     still  calculated.  When the pen movement returns to inside
     the window, plotting resumes at the  correct  position.   A
     message  can be sent to the user each time the pen movement
     exceeds the plot window.  The number of  messages  actually
     sent depends on what is specified to subroutine PLOTS.

          The plot window starts out as being 11 by  11  inches,
     with  the  origin  of  X  =  0,  Y = 0 being the lower left
     corner.  The window can be made smaller by calling  SETWIN,
     such  as  to  limit  the  plot  to  an 8.5 by 11 inch area.
     Special privileges are required to extend the  window  past
     the 11 by 11 inch limit.

          The window as set by SETWIN is known as the  universal
     window.   It  is an absolute limit of pen travel.  There is
     also a second type of window, known as the subwindow.   The
     subwindow  can  be  turned  on  and off at will, and can be
     anywhere inside of the universal window.  The subwindow  is
     useful  for  limiting  a  section  of the plot to a smaller
     area.  For instance:  the user can call SETWIN to limit the
     entire plot to an 8.5 by 11 inch area.  Then call SUBWIN to
     limit a graph to a 5 by 4  inch  window.   The  user  calls
     SUBWIN  again to turn off the subwindow checking, to plot a
     title outside of the area, such as "Figure 1".  SUBWIN  may
     be  called again to define a limit for figure 2, and turned
     off again to plot the caption "Figure 2".

















                              3-4
                                               Graphics Software


     3.4  COORDINATE SYSTEM.

          The plotter software is based on a standard  Cartesian
     coordinate  system  that  uses  the inch as a basic unit of
     measure.  Angles used in the plotting package  are  assumed
     to be in degrees, and are measured relative to the positive
     X axis, in a counter-clockwise direction as in the standard
     trigonometric convention.


                               90

                               Y
                               ^
                               !
                               !
                               !     +angle
                               !
                  180  --------+--------> X  0
                               !
                               !     -angle
                               !
                               !

                              270

                 Coordinate system conventions.


          When the plot is first started, the origin is  set  to
     the  lower  left corner of the window.  This default allows
     only positive X and  Y  coordinates  until  the  origin  is
     shifted   by  CALL PLOT(XORG,YORG,-3).   Whenever  PLOT  is
     called with the function code of -3, the pen moves  to  the
     specified  coordinate  and the origin is set to that point.
     Note that multiple origin changes are cumulative.

          Subroutine ROTATE will rotate  the  coordinate  system
     and   subroutine  FACTOR  will  change  the  scaling.   The
     coordinate system will remain a Cartesian coordinate system
     measured  in  inches that will be suitably shifted, turned,
     and zoomed within the  universal  window  by  changing  the
     coordinate   system.    The   coordinate  changes  are  not
     retroactive;  the change is effective for only the plotting
     done after the call to the routine to make the change.









                              3-5
Graphics Software


     3.5  SYMBOL SETS

          There are two routines available for drawing  text  on
     the plot;  TITLE and SYMBOL.

          Subroutine TITLE is limited to a single character  set
     and  angles  that are multiples of 45 degrees.  It uses the
     hardware character generator if possible,  otherwise  TITLE
     calls  subroutine  SYMBOL.   (Currently,  only the GIGI and
     ReGIS plotter have this feature.)

          The SYMBOL  routine  allow  complete  freedom  in  the
     choice  of  position  and  angle of characters generated by
     labeling routines.  There are currently thirteen  different
     types of character sets and one set of centered symbols.

          The different character  sets  are  described  in  the
     "LABELING  ROUTINES"  section,  and  examples  are  in  the
     appendix.



     3.6  TEK PROGRAM

          The TEK program will display a spooled plot file on  a
     TEK  or  GIGI  graphics terminal.  It is strongly suggested
     that all plots be  viewed  before  they  are  sent  to  the
     Houston Instruments DP-8 plotter.

          To view the spooled plot stored in GRAPH.PLT, use  the
     command:

        .TEK GRAPH

     The TEK program will assume the extension  of  ".PLT",  and
     knows how to talk to both Tektronix and GIGI terminals.



     3.7  TEKVUE PROGRAM.

          Some of the 4006 terminals are limited to running  the
     TEKVUE  program.   TEKVUE  allows  the  user to preview and
     dispose of plot  files,  but  the  plots  must  be  created
     elsewhere.   This  limitation  is  imposed so that graphics
     terminals will be available for previewing plots.








                              3-6












                           CHAPTER 4

                      PLOTTING SUBROUTINES



     4.1  CORE PLOTTING ROUTINES

          The routines that follow are the core routines of  the
     plotting  package.   They  are written in MACRO-10 assembly
     language and handle the actual movement of the  pen,  in  a
     manner  suitable  for  the hardware selected.  The standard
     default plotting package outputs to the Houston Instruments
     DP-8  plotter,  but  this  can  be  changed  by appropriate
     arguments to subroutine PLOTS.

          The core routines are in FORLIB, the FORTRAN  library,
     and  are loaded automatically whenever any plotting routine
     is needed.




          The core routines are:

     1.  ERASE  - Clear the screen.

     2.  FACTOR - Change size of plotter movements.

     3.  NEWPEN - Change the pen color.

     4.  OPRTXT - Send a message to the OPR.

     5.  PAUSEP - Pause the plot for a few seconds.

     6.  PLOT   - Move the pen, (X,Y,999) to end plot.

     7.  PLOTS  - Starts plotting.







                              4-1
Plotting Subroutines


     8.  ROTATE - Performs translation and rotation.

     9.  SETWIN - Sets window size.

    10.  SUBWIN - Activates sub-windows.

    11.  TITLE  - Plots text.

    12.  WHERE  - Returns current coordinates.

    13.  XHAIRS - Triggers crosshairs on TEK 4012 or GIGI.




     4.1.1  Subroutine 'ERASE'

            ---------- -------

          ERASE allows the user  to  erase  the  screen  on  the
     TEKTRONIX or GIGI terminals.

             ********** calling sequence **********

                           CALL ERASE

             **************************************

          ERASE does not have an  argument.   Upon  return  from
     this  routine  the  cursor  will  be at the lower left hand
     corner of the screen and this point will be the origin.


                                NOTE

         This routine does nothing if subroutine  PLOTS  has
         selected the Houston Instruments plotter.


















                              4-2
                                            Plotting Subroutines


     4.1.2  Subroutine 'FACTOR'

            ---------- --------

          FACTOR enables the user to  change  the  size  of  the
     entire  plot  by  magnifying  the  plot  by  a given factor
     relative to the normal plot size.   The  factor  in  the  Y
     direction  may be changed indepenently of the factor in the
     X direction - this allows mirror-images to be plotted.

             ********** calling sequence **********

                      CALL FACTOR (FACTR)

                               or

                   CALL FACTOR (FACTX,FACTY)

             **************************************


     FACTR   (input parameter) is the ratio of the desired  plot
                    size to the normal plot size.

     FACTX   (input parameter) is the scaling factor  in  the  X
                    direction.

     FACTY   (optional input parameter) is the scaling factor in
                    the Y direction.

                            Example

                            -------

                       CALL FACTOR (0.5)


          This call will cause the entire plot which follows  to
     be reduced to half size.  The window size is unaffected, so
     a window of 11 by 11 inches can be used  for  a  plot  that
     would normally be 22 by 22 inches.


                                NOTE

         Subroutine FACTOR affects the  relative  origin  as
         set  by  CALL PLOT(X,Y,-3).   A  program that calls
         FACTOR first then calls PLOT(X,Y,-3)  will  produce
         the   same   effect   as   a   program  that  calls
         PLOT(X,Y,-3) before FACTOR.  See subroutine  ORIGIN
         for a description of these interactions.





                              4-3
Plotting Subroutines


     4.1.3  Subroutine 'NEWPEN'

            ---------- --------

          Subroutine NEWPEN allows the user to select which  pen
     will  be  used  for  the following references to subroutine
     PLOT or to obtain the value of the current pen in use.

             ********** calling sequence **********

                     CALL NEWPEN(IPEN,IERR)

             **************************************

     IPEN    (input parameter) allows for a mode of operation.
             (IPEN = 0) return the value of the current  pen  in
                      use.   IERR  gets set to the number of the
                      pen currently in use.
             (IPEN > 0) select a pen to use.  IERR  is  returned
                      as  zero  if  the  pen  number  is  legal,
                      otherwise as -1.
     IERR    (output parameter) The error flag or number of pen.


              DP-8     DMP4R     GIGI and VT125
              ----     -----    -----------------
     IPEN=1   Blue     Blue     Light blue (cyan)
     IPEN=2   Black    Black    White (not black)
     IPEN=3   Red      Red      Red-purple

          Values of IPEN  greater  than  3  work  only  for  the
     Houston  Instruments DMP4-R table-top plotter.  The pens on
     this plotter can be re-arranged by the user.

          Calling  NEWPEN  has  no  affect  on   the   Tektronix
     4000-series terminals.


                                NOTE

         NEWPEN can be called as an integer function, as  in
         IERR=NEWPEN(IPEN),  but  such use of the subroutine
         is discouraged.












                              4-4
                                            Plotting Subroutines


     4.1.4  Subroutine 'ORIGIN'

            ---------- --------


             ********** calling sequence **********

                     CALL ORIGIN (ARG,X,Y)

             **************************************


     CALL ORIGIN('ABS',XORIG,YORIG)
                    Set   absolute   origin   (in   inches)   to
                    (XORIG,YORIG).  This is the same as
      CALL ROTATE(0,XTEMP,YTEMP,ANGLE) !Get current angle
      CALL ROTATE(1,XORIG,YORIG,ANGLE) !Re-set angle     

     CALL ORIGIN('REL',XORIG,YORIG)
                    Set    relative    origin,     just     like
                    CALL PLOT(XORIG,YORIG,-3).

     CALL ORIGIN('WHERE',XINCH,YINCH)
                    Return current position on the paper.   This
                    returns  the  absolute position, in spite of
                    any   calls   to    FACTOR,    ROTATE,    or
                    PLOT(X,Y,-3).



                                NOTE

         Subroutine FACTOR affects the  relative  origin  as
         set  by  CALL PLOT(X,Y,-3).   A  program that calls
         FACTOR first then calls PLOT(X,Y,-3)  will  produce
         the   same   effect   as   a   program  that  calls
         PLOT(X,Y,-3) before FACTOR.


















                              4-5
Plotting Subroutines


     4.1.5  Subroutine 'OPRTXT'

            ---------- --------

          This routine allows the user to send a message to  the
     operator via his output plot file.  This subroutine is used
     to send messages at plot time to the  operator  to  request
     special pens, special forms, etc.

             ********** calling sequence **********

                   CALL OPRTXT (MESSAG,NCHR)

             **************************************


     MESSAG  (input parameter) is the message to be sent to  the
                    operator.    This  text  must  be  either  a
                    literal or an array that has five characters
                    per element.


     NCHR    (input parameter) is the number of characters to be
                    sent to the operator.



                                NOTE

         This routine  will  only  send  a  message  to  the
         operator;   it  will  NOT  pause  the output to the
         plotter.  If operator intervention is required, the
         output  must  be  paused  by a call to PLOT(X,Y,0),
         which must be the next call to PLOT.

         This routine  does  nothing  when  running  on  the
         graphic terminals.


                            Example

                            -------

           CALL OPRTXT ('Please put blue felt-tip in pen #1',34)
           CALL PLOT (X,Y,0)    !Pause the plotter











                              4-6
                                            Plotting Subroutines


     4.1.6  Subroutine 'PAUSEP'

            ---------- --------

          PAUSEP allows the user to pause the plot  going  to  a
     graphics  terminal.   Its  main use is to allow the user to
     view a plot before erasing the screen

             ********** calling sequence **********

                       CALL PAUSEP (ISEC)

                               or

                      CALL PAUSEP (0,IANS)

             **************************************

     ISEC    (input parameter) is the time in seconds  that  the
              plot should be paused.  Zero means to wait for the
              user to hit the RETURN key.

     IANS    (optional output parameter) is the user's response,
              such  as  'OK' or 'STOP'.  IANS is returned as all
              blanks if the user  simply  hit  the  RETURN  key,
              otherwise  up  to 5 characters of the response are
              returned, converted to upper case.

                            Example

                            -------

            CALL PAUSEP (5)     !Pause for 5 seconds
            CALL ERASE  ! Clear the screen
               ....
            CALL PAUSEP (0,IANS)
            IF(IANS.NE.'OK') CALL ERASE



















                              4-7
Plotting Subroutines


     4.1.7  Subroutine 'PLOT'

            ---------- ------

          PLOT is the  basic  routine  for  the  plotter.   This
     routine  moves  the  pen in a straight line to the position
     specified by (X,Y) with the pen up or down.  Also,  special
     services  such as plot termination and change of origin are
     performed  by  this  routine.   There  are  six  modes   of
     operation for this routine plus the pause command.




          MODE     MEANING OF X AND Y PARAMETERS

          ----     ------- -- - --- - ----------

            0      Cause the spooler to pause.  ( IC = 0 ).

            1      Coordinate of point in inches to move pen to.
                   ( 0 <= IC <= 5 ).

            2      Delta values in inches to move the  pen  from
                   this coordinate.  ( 5 <= IC <= 7 ).

            3      Polar coordinate values in inches to move the
                   pen  to.  X is the radius in inches, and Y is
                   the angle in degrees.  ( 8 <= IC <= 10 ).

            4      Polar coordinate values to move  the  pen  to
                   with  X  the radius value in inches and Y the
                   angle in radians.  ( 11 <= IC <= 13 ).

            5      Terminate the plot.  ( IC = 999 ).





















                              4-8
                                            Plotting Subroutines


             ********** calling sequence **********

                       CALL PLOT (X,Y,IC)

             **************************************




     Mode 0     Pause Spooler

     ---- -

     (X,Y)  (input parameter)  are   ignored   for   the   pause
                    function.

     IC = 0 (input parameter)  is  the  pause  command  for  the
                    spooler,  X  and  Y  are  ignored.   For the
                    Houston Instruments DP-8 plotter, this  call
                    is    illegal   unless   you   call   OPRTXT
                    immediately before calling PLOT(X,Y,0).   It
                    causes  the  SPROUT spooling program to stop
                    and request Operator intervention.  See  the
                    OPRTXT description for more information.

     Use  subroutine  PAUSEP  to  pause   output   to   graphics
                    terminals.


     Mode 1     Absolute Coordinates

     ---- -

     (X,Y)  (input parameter) is the coordinate to move  to,  in
                    inches.

     IC     (input parameter) is the function code:
           (IC =  1) move to X,Y without  modifying  pen  up  or
                    down.
           (IC = -1) move to X,Y without  modifying  pen  up  or
                    down, and make this the new origin.
           (IC =  2) drop the pen and move to X,Y.
           (IC = -2) drop the pen, move to X,Y and make this the
                    origin.
           (IC =  3) raise the pen and move to X,Y.
           (IC = -3) raise the pen and move to X,Y and make this
                    the origin.
           (IC =  4) make the current pen position X,Y.
           (IC = -4) make the current pen  position  the  origin
                    (X,Y are ignored).






                              4-9
Plotting Subroutines


     Mode 2     Relative Coordinates

     ---- -

     (X,Y)  (input parameter) is the delta distance to move,  in
                    inches.

     IC     (input parameter) is the function code:
           (IC =  5) move the delta distance  without  modifying
                    pen up or down.
           (IC = -5) move the delta distance  without  modifying
                    pen up or down and make this the origin.
           (IC =  6) drop the pen and move the delta distance.
           (IC = -6) drop the pen, move the delta  distance  and
                    make this the origin.
           (IC =  7) raise the pen and move the delta distance.
           (IC = -7) raise the pen, move the delta distance  and
                    make this the origin.


     Mode 3     Polar Degrees

     ---- -

     (X,Y)  (input parameter) is the polar  coordinates  of  the
                    point  to  move  to  (X  is  the  radius, in
                    inches, and Y is the angle, in degrees).

     IC     (input parameter) is the function code:
           (IC =  8) move to X,Y  without  changing  pen  up  or
                    down.
           (IC = -8) move to X,Y without  modifying  pen  up  or
                    down and make this the origin.
           (IC =  9) drop the pen and move to X,Y.
           (IC = -9) drop the pen, move to X,Y,  and  make  this
                    the origin.
           (IC = 10) raise the pen and move to X,Y.
           (IC =-10) raise the pen, move to X,Y, and  make  this
                    the origin.

















                              4-10
                                            Plotting Subroutines


     Mode 4     Polar Radians

     ---- -

     (X,Y)  (input parameter) is the polar  coordinates  of  the
                    point  to  move  to  (X  is  the  radius, in
                    inches, and Y is the angle, in radians).

     IC     (input parameter) is the function code:
           (IC = 11) move to X,Y  without  changing  pen  up  or
                    down.
           (IC =-11) move to X,Y without  modifying  pen  up  or
                    down and make this the origin.
           (IC = 12) drop the pen and move to X,Y.
           (IC =-12) drop the pen, move to X,Y and make this the
                    origin.
           (IC = 13) raise the pen and move to X,Y.
           (IC =-13) raise the pen, move to X,Y  and  make  this
                    the origin.


     Mode 5     Finish Plot

     ---- -

     (X,Y)  (input parameter) X,Y are ignored.

     IC     (input parameter) is the function code:
           (IC = 999) terminate the plot.
           (IC  > 13  or  IC   -13)   Unimplemented   operation.
                    Currently,  if  the  absolute value of IC is
                    greater than 13, it is the same as if IC was
                    999,  and terminates the plot.  The value of
                    999 should be used to terminate the plot, as
                    more modes may be implemented in the future.

           CALL PLOT(X,Y,-999) will abort the  plot,  and  avoid
                    creating a plot file.


















                              4-11
Plotting Subroutines


     4.1.8  Subroutine 'PLOTS'

            ---------- -------

          The PLOTS routine activates the plotter.  It also sets
     a counter for listing "Plot Window Exceeded" messages.


                                NOTE

         PLOTS must be called before  ANY  call  to  a  plot

                                      ---
         routine to initialize the output plot file.



             ********** calling sequence **********

               IERR = some number                
               CALL PLOTS (IERR,IPLT)            
               IF(IERR.NE.0) STOP 'PLOTS failure'

                               or

                  CALL PLOTS (IERR,IPLT,DFILE)

             **************************************


     IERR  (input parameter) is a  flag  to  set  error  message
                    type-out:
           (IERR = 0) don't type warnings.
           (IERR > 0) type only the warning message.
           (IERR < 0) type the warning  message  and  trace  the
                    call to subroutine PLOT.  The absolute value
                    of IWARN  will  be  the  maximum  number  of
                    warnings to be typed.
           (IERR = 999) do not erase the screen if running on  a
                    graphics  terminal.   Usually  the screen is
                    erased when PLOTS is called.


     IERR  (output parameter) is a flag signifying  the  success
                    or failure of PLOTS.
           (IERR =  0) means no errors.
           (IERR = -1) means no such plotter.
           (IERR > 0) means plot file creation error.








                              4-12
                                            Plotting Subroutines


     IPLT  (input parameter) specifies the type of plotter.
              0    Use the default plotter ('SPOOL')
           'PLOT'  Same as 0
           'SPOOL' Spooled output to the Houston Instruments
                   DP-8 plotter
           'DP-8'  Same as 'SPOOL'
            'TEK'  Output to TEKTRONIX 4000-series terminal
            4006   Same as 'TEK'
            4012   Same as 'TEK'
            4025   Same as 'TEK'
           'REGIS' Output to ReGIS type terminal
           'GIGI'  Same as 'REGIS'
           'DMP4R' Houston Instruments DMP-4R ReGIS plotter
            'TTY'  Same as 'TEK' or 'GIGI' depending on terminal


     DFILE (optional input parameter)   specifies   the   device
                    and/or  file  name  for the plot file.  This
                    must be less than 10 characters enclosed  by
                    single   quotes,   or   a   double-precision
                    variable.


                            EXAMPLE

                            -------
        IERR = -2
        CALL PLOTS(IERR,0)
        IF (IERR.NE.0) STOP '?PLOTS failure'

          Specifying IPLT as the integer zero means to  use  the
     default   plotter   (normally   'SPOOL',   but   'TEK'   if
     SYS:TEKPLT.REL is loaded).  The value of IERR = -2 on input
     will  cause  a maximum of two error messages and a trace of
     the erroneous calls to be typed.  If IERR is  not  returned
     as zero, the program will stop and type "?PLOTS failure".



















                              4-13
Plotting Subroutines


     4.1.9  Subroutine 'ROTATE'

            ---------- --------

          ROTATE allows the coordinate  system  to  be  rotated.
     All plotting references after this call will be offset from
     the axis of rotation (which is now the origin) and rotated.


                                NOTE


              Window clipping is done AFTER rotation.   That
         is,  the limits imposed by subroutine SETWIN always
         form a box whose sides are horizontal and vertical.



             ********** calling sequence **********

              CALL ROTATE (IFUNC,XPOS,YPOS,ANGLE)

             **************************************


     IFUNC   (input parameter) determines the mode of rotation:
           (IFUNC = 0) clear all rotation, setting the origin to
                    the  lower  left  corner  of  the  universal
                    window.  XPOS, YPOS and ANGLE are set to the
                    former  absolute origin and the former angle
                    of rotation.
           (IFUNC > 0) add ANGLE to the current rotation angle.
           (IFUNC < 0) set the angle of rotation to ANGLE.


     (XPOS,YPOS)  is the position in inches for  the  center  of
                    rotation.    NOTE:    This  is  an  absolute
                    position on the paper, and is  not  affected
                    by   CALL   FACTOR.   This  absolute  origin
                    cancels any previous  relative  origin  that
                    may have been set by CALL PLOT(X,Y,-3).

     ANGLE   (input parameter) is the angle of rotation.  It  is
                    specified in degrees, not in radians.


                            Example

                            -------







                              4-14
                                            Plotting Subroutines


          The user is charged by the width of the  plot.   If  a
     plotting  program  is set up to use an area 8.5 inches high
     by 11.0 inches wide, plot paper will be  conserved  if  the
     plot  is  rotated  so  that  it  is 8.5 inches wide by 11.0
     inches high.   This  can  be  accomplished  by  adding  two
     statements after the call to PLOTS.

        CALL SETWIN (8.5, 11.0)
        CALL ROTATE (1, 8.5, 0.0, 90.0)


          The first  statement  makes  sure  that  the  plot  is
     limited to 8.5 inches wide by 11.0 inches high.  The second
     one moves 8.5 inches to the right along the X axis, rotates
     the  plot 90 degrees counterclockwise, and makes this point
     the new origin.  The positive X axis now points up, and the
     positive Y axis points to the left.

                            Example

                            -------
        CALL FACTOR(0.5)                !Reduce size of plot
        CALL PLOT(1.0,2.0,-3)           !Origin is (0.5,1.0)
        CALL ROTATE(-1,4.0,5.0,90.0)    !Origin is (3.0,5.0)

          Before  the  call  to  ROTATE,  the  origin   was   at
     (0.5*1.0,0.5*2.0)  or  (0.5,1.0) because FACTOR affects the
     origin set by PLOT(X,Y,-3).  Then ROTATE used (4.0,5.0)  as
     the center of rotation because it uses absolute coordinates
     in inches along the paper, and is unaffected by  FACTOR  or
     PLOT(X,Y,-3).   After  this rotation, the 0.5 inch X-origin
     offset and the 1.0 inch Y-origin offset have been canceled.

          If your program uses subroutine  ROTATE,  then  better
     results will be obtained by using
                 CALL ORIGIN('ABS',XORIG,YORIG)
                               or
                CALL ROTATE(-1,XORIG,YORIG,0.0)
     instead of
                 CALL ORIGIN('REL',XORIG,YORIG)
                               or
                   CALL PLOT(XORIG,YORIG,-3)
     to change the origin.












                              4-15
Plotting Subroutines


     4.1.10  Subroutine 'SETWIN'

             ---------- --------

          Subroutine SETWIN allows the user to set up  a  window
     size other than using the default window size (11 inches by
     11 inches).

             ********** calling sequence **********

                      CALL SETWIN (WX,WY)

                               or

                CALL SETWIN (WX,WY,WXMAX,WYMAX)

             **************************************

     WX      (input parameter) is the width  of  the  window  in
              inches.  The maximum value of WX is 240 inches.

     WY      (input parameter) is the height of  the  window  in
              inches.  The maximum value of WY is 35 inches.

     WXMAX   (optional output parameter) is the maximum X  value
              that PRIV.SYS allows.

     WYMAX   (optional  output  parameter)  is  the  maximum   Y
              allowed.


                                NOTE

         Privileges for window sizes larger than  11  by  11
         inches are granted by the Chief Consultant.  If the
         user wants to set up a window size, he or she  must
         do  so  after  a  reference  to  PLOTS but before a
         reference to subroutine PLOT or any other  plotting
         routine.   The  values  of  WX or WY cannot be less
         than or equal to zero.  See the  page  on  "Warning
         and Error Messages".














                              4-16
                                            Plotting Subroutines


     4.1.11  Subroutine 'SUBWIN'

             ---------- --------

          SUBWIN allows the user to have  a  sub-window  in  the
     plotting  program.  A sub-window is a smaller window within
     the main or universal window and is  treated  exactly  like
     the  universal  window.   For  example if the sub-window is
     setup no plotting will be done outside of that  sub-window.
     The  sub-window  can  be  turned  on and off at will and no
     special privileges are needed.

             ********** calling sequence **********

         CALL SUBWIN (IFUNC,IVALUE,X0,Y0,WIDTH,HEIGHT)

             **************************************

     IFUNC   (input parameter) selects mode of operation.
             (IFUNC = 0) sets up the sub-window
             (IFUNC = 1) reads the sub-window size to see if the
                      sub-window   feature  is  currently  being
                      used.
             (IFUNC = 2) disables the sub-window for now.
             (IFUNC = 3) reenables the sub-window feature,  i.e.
                      uses  the  last  values  of a reference to
                      subroutine  SUBWIN  with  IFUNC  equal  to
                      zero.

     IVALUE  (output parameter) a mode (IFUNC) dependent  value.
              If  IFUNC  is  less than 0 or greater than 3, then
              IVALUE will be set equal to -1.
             (IFUNC = 0)
                  (IVALUE = -1) the width  or  height  was  less
                      than or equal to zero.
                  (IVALUE = 0) the sub-window was set up.
             (IFUNC = 1)
                  (IVALUE = -1) a sub-window was not set up.
                  (IVALUE = 0) the sub-window was set up and  no
                      checking is being done.
                  (IVALUE = 1) the sub-window  was  set  up  and
                      checking is being done.
             (IFUNC = 2 or 3)
                  (IVALUE = -1) a sub-window was not set up.
                  (IVALUE = 0) a sub-window was set up.

     (X0,Y0) (input  or  output  parameter)   a   mode   (IFUNC)
              dependent value.
             (IFUNC = 0) (input) the  coordinate  of  the  lower
                      left  hand  corner  of  the sub-window, in
                      inches.
             (IFUNC = 1) (output) the coordinates of  the  lower
                      left  hand  corner  of  the sub-window, in
                      inches.

                              4-17
Plotting Subroutines


             (IFUNC = 2) is unused.  (IFUNC = 3) is unused.

     WIDTH   (input  or  output  parameter)   a   mode   (IFUNC)
              dependent value.
             (IFUNC = 0) (input) the width of the sub-window, in
                      inches.
             (IFUNC = 1) (output) the width of  the  sub-window,
                      in inches.
             (IFUNC = 2) is unused.
             (IFUNC = 3) is unused.


     HEIGHT  (input  or  output  parameter)   a   mode   (IFUNC)
              dependent value.
             (IFUNC = 0) (input) the height of  the  sub-window,
                      in inches.
             (IFUNC = 1) (output) the height of the  sub-window,
                      in inches.
             (IFUNC = 2) is unused.
             (IFUNC = 3) is unused.


                                NOTE

         X0, X0,  WIDTH  and  HEIGHT  are  relative  to  the
         current  origin and factor values.  This subroutine
         is not effected by subroutine ROTATE.





     4.1.12  Subroutine 'TITLE'

             ---------- -------

          The TITLE subroutine draws text on the plotter,  using
     the  hardware  character  generator  if  possible.   If the
     plotter does not have a  character  generator,  TITLE  will
     then call subroutine SYMBOL using SETSYM table 1.

             ********** calling sequence **********

          CALL TITLE (X0,Y0,HEIGHT,ICHARS,ANGLE,NCHR)

             **************************************


     (X0,Y0) (input parameter) is the coordinate, in inches,  of
                    the  lower  left  hand  corner  of the first
                    character to be drawn,  before  rotation  by
                    ANGLE.   The  pen is up while moving to this
                    point.


                              4-18
                                            Plotting Subroutines


     HEIGHT  (input parameter) is the height, in inches, of  the
                    character(s) to be drawn.

     ICHARS  (input parameter) is the text to be drawn.   ICHARS
                    is either a literal enclosed by apostrophes,
                    or an array containing  five  left-justified
                    characters per element.

     ANGLE   (input parameter) is the angle in degrees at  which
                    the  text  is to be plotted.  The angle will
                    be rounded to be a multiple of 45 degrees.

     NCHR    (input parameter) number of characters to plot.
           (NCHR = 0) plot a single character whose  ASCII  code
                    is in ICHARS.


                                NOTE

         Currently,  the   only   plotters   with   hardware
         character   generators  are  the  ReGIS  terminals;
         VT125, GIGI, and DMP4R.




          See also the description of subroutine SYMBOL.



























                              4-19
Plotting Subroutines


     4.1.13  Subroutine 'WHERE'

             ---------- -------

          This routine allows the user to check on the status of
     the plotter, the current pen position, current FACTOR value
     and the type of  plotting  package  that  was  selected  by
     subroutine  PLOTS.   This  routine will normally be used to
     optimize plotter movement.

             ********** calling sequence **********

                        CALL WHERE (X,Y)

                               or

               CALL WHERE (X,Y,FACTX,IPLT,FACTY)

             **************************************


     X      (output parameter)  is  the  X  coordinate  of   the
                    current pen position, in inches.

     Y      (output parameter)  is  the  Y  coordinate  of   the
                    current pen position, in inches.

     IPLT    (optional output parameter) is the type of  plotter
                    in use.
           (IPLT = 1) using the DP-8 spooler.
           (IPLT = 2) using the ARDS package.
           (IPLT = 3) using the TEKTRONIX package.
           (IPLT = 4) using the ReGIS  package.   (GIGI,  DMP4R,
                    VT125)


     FACTX   (optional output parameter) is the factor value for
                    the X direction.

     FACTY   (optional output parameter) is the factor value for
                    the Y direction.


          The values returned for X and Y take into account  any
     rotation,  scaling  factors,  and  the  current origin.  If
     these values were to be used in the next call to PLOT,  the
     pen will not move.








                              4-20
                                            Plotting Subroutines


                            Example

                            -------

        CALL WHERE(X,Y,FACTR,IPLT)                      
        IF (IPLT .EQ. 3) CALL FACTOR (0.7*FACTR)   !TEK 
        IF (IPLT .EQ. 4) CALL FACTOR (FACTR*2./3.) !GIGI


          This determines which  type  of  plotter  is  in  use.
     Since  the  TEKTRONIX  screen  is only 7.8 inches tall, the
     scale factor of 0.7 ensures that all 11 inches of the  plot
     will  be  visible.  For a GIGI or VT125 terminal, a scaling
     factor of 0.666667 is needed.

          Since moving long distances with  the  pen  up  wastes
     plotter  time,  subroutine  WHERE  can  be  used to improve
     efficiency.  If possible, draw long lines by moving to  the
     endpoint  closest  to  the  current position first and then
     plot the line.



































                              4-21
Plotting Subroutines


     4.1.14  Subroutine 'XHAIRS'

             ---------- --------

          XHAIRS allows the user to turn on the crosshairs on  a
     TEKTRONIX   or  GIGI  terminal.   The  user  positions  the
     crosshairs and types a single character.  The position  and
     the  character  are  transmitted  to  the  program.  If the
     character is a Control-Z, the screen will be cleared, zeros
     will be returned for all parameters, and the origin will be
     set to the lower left hand corner of the screen.

             ********** calling sequence **********

                 CALL XHAIRS (XPOX,YPOS,LETTER)

             **************************************

     XPOS    (output parameter) is the X coordinate, in  inches,
              of the crosshair.

     YPOS    (output parameter) is the Y coordinate, in  inches,
              of the crosshair.

     LETTER  (output parameter) is the character typed.   Normal
              characters are returned in an 'A1' format, control
              characters are returned as a number between 1  and
              31, in an 'R1' format.


                                NOTE

         XPOS and YPOS are relative to  the  current  origin
         and  factor  value.  This routine is only available
         in the TEKTRONIX and GIGI plotting package.



                            Example

                            -------

            CALL XHAIRS (XPOS, YPOS, LETTER)
            IF (LETTER .EQ. 'U') CALL PLOT (XPOS, YPOS, 3) !Up
            IF (LETTER .EQ. 'D') CALL PLOT (XPOS, YPOS, 2) !Down











                              4-22
                                               Graphing Routines


     4.2  GRAPHING ROUTINES

          The routines that follow in this section are  designed
     to  aid  in  the  generation of graphs by drawing the axes,
     scaling the data, and drawing the data points on the graph.
     Care  should  be  taken  in  choosing the best axis drawing
     routine to fit the data involved.

          These routines are the included in FORLIB, the FORTRAN
     library.   Unlike  the  CALCNT  and PLOT3D routines, FORLIB
     routines get loaded automatically whenever they are needed.




          The Graphing Routines are:

     1.  AXES   - Draw a fancy X or Y axis.

     2.  AXIS   - Draw a simple X or Y axis.

     3.  DASHLN - Draw a dashed line between 2 points.

     4.  GRID   - Draw a rectilinear grid.

     5.  LINE   - Draw a line from an array of X and Y.

     6.  LOGAX  - Draw a simple logarithmic axis.

     7.  LOGAXS - Draw a fancy logarithmic axis.

     8.  SCALE  - Do scaling for subroutine LINE.






















                              4-23
Graphing Routines


     4.2.1  Subroutine 'AXES'

            ---------- ------

          AXES  provides  the  user  with  the   capability   of
     generating  and  labeling  an  axis  by  drawing  a line of
     arbitrary length divided into variable length  segments  by
     'tick'  marks.   The  variable  value  can be written as an
     annotation beside each mark.  The axis can also be  labeled
     if  the  user  desires with special parameters for labeling
     and segment lengths.

             ********** calling sequence **********

       CALL AXES (X0,Y0,ITITLE,NCHR,AXSLEN,ANGLE,FIRSTV,
              DELTAV,TICSPC,IPOWER,NUMDIG,LABTIC)

             **************************************


     (X0,Y0) (input parameter) is the  coordinate  position,  in
                    inches,  of the starting point for the axis.
                    The axes ends should be at least 0.5  inches
                    from  the  current  window  limits  to allow
                    space  for  the  scale  annotation  and  the
                    title.   When the coordinate system is being
                    generated to coincide with a  plot  produced
                    by  subroutine  LINE  the X0 value for the X
                    axis must be 0.0 and the Y0 value for the  Y
                    axis must be 0.0.

     ITITLE  (input parameter) is the title for the axis.   This
                    title is centered and placed parallel to the
                    axis line.  ITITLE may be either a Hollerith
                    literal,    or    an    array    with   five
                    left-justified  characters  per  word.   The
                    output  title  has  a  fixed  height of 0.15
                    inch.

     NCHR    (input   parameter)   specifies   the   number   of
                    characters in the title and on which side of
                    the axis the labeling  information  will  be
                    written.
           (NCHR > 0) make  the  'tick'  mark,  annotation,  and
                    title placement on the counterclockwise side
                    of the axis relative to the  line  projected
                    from  the  origin  along  the  desired axis.
                    This condition is normally desired  for  the
                    Y-axis.






                              4-24
                                               Graphing Routines


           (NCHR =  0)  make  the  'tick'  mark  and  annotation
                    placement  on  the counter-clockwise side of
                    the axis relative to the line projected from
                    the origin along the desired axis.  There is
                    no title on this axis.
           (NCHR < 0) make  the  'tick'  mark,  annotation,  and
                    title placement on the clockwise side of the
                    axis relative to the line projected from the
                    origin   along   the   desired  axis.   This
                    condition  is  normally  desired   for   the
                    X-axis.


     AXSLEN  (input parameter) is the length, in inches, of  the
                    axis line.

     ANGLE   (input parameter) is  the  angle,  in  degrees,  at
                    which  the  axis  is  to be drawn.  Normally
                    this value is 0.0 for the  X-axis  and  90.0
                    for the Y-axis.

     FIRSTV  (input parameter) is the starting value which  will
                    appear on the first 'tick' mark of the axis.
                    This value, if computed  by  SCALE  will  be
                    stored at location ARRAY(NPT+1).

     DELTAV  (input parameter) is the number of data  units  per
                    inch  of  axis.   This value, if computed by
                    SCALE, will be stored at ARRAY(NPT+2).

     TICSPC  (input parameter) is the  distance  between  'tick'
                    marks, in inches.

     IPOWER  (input  parameter)  is  the  exponent   times   10,
                    (*10**IPOWER), used in the title.

     NUMDIG  (input parameter) is the number of  decimal  places
                    wanted  in  the  annotation  on each labeled
                    'tick' mark.  If integers are wanted  NUMDIG
                    should  be  set  equal to -1.  If no numbers
                    are wanted NUMDIG should  be  set  equal  to
                    999.

     LABTIC  (input parameter) is the delta value  for  labeling
                    the  'tick' marks.  For example, if LABTIC =
                    3 every third 'tick' mark will  be  labeled.
                    If LABTIC is less than 1 no labeling will be
                    done.






                              4-25
Graphing Routines


                                NOTE

         Each call to AXES will  draw  a  single  axis  with
         labels.  It requires two calls to AXES to create an
         (X,Y) coordinate system.





     4.2.2  Subroutine 'AXIS'

            ---------- ------

          AXIS  provides  the  user  with  the   capability   of
     generating  and  labeling  an  axis  by  drawing  a line of
     arbitrary length divided into one inch segments  by  'tick'
     marks.   The  variable  value  is  written as an annotation
     beside each mark.  The axis can also be labeled if the user
     desires.

             ********** calling sequence **********

              CALL AXIS (X0,Y0,ITITLE,NCHR,AXSLEN,
                      ANGLE,FIRSTV,DELTAV)

             **************************************


     (X0,Y0) (input parameter) is the  coordinate  position,  in
                    inches,  of the starting point for the axis.
                    The axes ends should be at least  0.5  inchs
                    from  the  current  window  limits  to allow
                    space  for  the  scale  annotation  and  the
                    title.   When the coordinate system is being
                    generated to coincide with a  plot  produced
                    by  subroutine  LINE  the X0 value for the X
                    axis must be 0.0 and the Y0 value for the  Y
                    axis must be 0.0.

     ITITLE  (input parameter) is the title for the axis.   This
                    title is centered and placed parallel to the
                    axis line.  ITITLE may be either a Hollerith
                    literal,   or   an   array  containing  five
                    left-justified  characters  per  word.   The
                    title has a fixed height of 0.15 inch.

     NCHR    (input   parameter)   specifies   the   number   of
                    characters in the title and on which side of
                    the axis the labeling  information  will  be
                    written.




                              4-26
                                               Graphing Routines


           (NCHR > 0) make  the  'tick'  mark,  annotation,  and
                    title placement on the counterclockwise side
                    of the axis relative to the  line  projected
                    from  the  origin  along  the  desired axis.
                    This condition is normally desired  for  the
                    Y-axis.
           (NCHR =  0)  make  the  'tick'  mark  and  annotation
                    placement  on  the counter-clockwise side of
                    the axis relative to the line projected from
                    the origin along the desired axis.  There is
                    no title on this axis.
           (NCHR < 0) make  the  'tick'  mark,  annotation,  and
                    title placement on the clockwise side of the
                    axis relative to the line projected from the
                    origin   along   the   desired  axis.   This
                    condition  is  normally  desired   for   the
                    X-axis.


     AXSLEN  (input parameter) is the length, in inches, of  the
                    axis line.

     ANGLE   (input parameter) is  the  angle,  in  degrees,  at
                    which  the  axis  is  to be drawn.  Normally
                    this value is 0.0 for the  X-axis  and  90.0
                    for the Y-axis.

     FIRSTV  (input parameter) is the starting value which  will
                    appear on the first 'tick' mark of the axis.
                    This value, if computed  by  SCALE  will  be
                    stored  at  location ARRAY(NPT+1).  Only two
                    decimal places will be on the annotations.

     DELTAV  (input parameter) is the number of data  units  per
                    inch  of axis.  This value which is added to
                    FIRSTV for each succeeding 1  inch  division
                    along  the  axis, if computed by SCALE, will
                    be stored at ARRAY(NPT+2).



                                NOTE

         Each call to AXIS will draw a single axis line  and
         label  it.   The  creation  of  an (X,Y) coordinate
         system is accomplished by  two  references  to  the
         subroutine AXIS.







                              4-27
Graphing Routines


     4.2.3  Subroutine 'DASHLN'

            ---------- --------

          DASHLN is used to draw either a solid or  dashed  line
     between two points.

             ********** calling sequence **********

                 CALL DASHLN (X0,Y0,XN,YN,DASH)

             **************************************


     (X0,Y0) (input parameter) is the coordinate, in inches,  of
                    the starting end of the line segment.

     (XN,YN) (input parameter) is the coordinate, in inches,  of
                    the terminating end of the line segment.

     DASH    (input parameter) is a flag to tell whether a solid
                    or dashed line segment is desired.
           (DASH <= 0) makes the line segment solid.
           (DASH > 0) makes the line segment  dashed.   DASH  is
                    the length, in inches.



                                NOTE

         The first and last segments of the line are  always
         drawn  with the pen down - this is so that the ends
         of the line are clearly marked.  The length of DASH
         should  be  much  smaller than the distance between
         (X0,Y0) and (XN,YN).




















                              4-28
                                               Graphing Routines


     4.2.4  Subroutine 'GRID'

            ---------- ------

          GRID draws a linear grid.

             ********** calling sequence **********

             CALL GRID (X0,Y0,DELX,DELY,NXSP,NYSP)

             **************************************


     (X0,Y0) (input parameter) is the coordinate, in inches,  of
                    the lower left hand corner of the grid.

     DELX    (input  parameter)  is  the  distance,  in  inches,
                    between the grid lines in the X direction.

     DELY    (input  parameter)  is  the  distance,  in  inches,
                    between the grid lines in the Y direction.

     NXSP    (input parameter) is the number of grids in  the  X
                    direction.

     NYSP    (input parameter) is the number of grids in  the  Y
                    direction.



                                NOTE

         GRID will generate a linear grid of any size.   The
         number  of  lines  drawn  is  NXSP  +  1  in  the X
         direction (vertical lines) and NYSP + 1  in  the  Y
         direction (horizontal lines).



















                              4-29
Graphing Routines


     4.2.5  Subroutine 'LINE'

            ---------- ------

          LINE enables a user to plot (X,Y) pairs of data values
     from  an X array and a Y array.  LINE computes the position
     on the page of each plotted point from the data values  and
     scaling  parameters in the two arrays.  The data points may
     be  represented  by  centered  symbols  with   or   without
     connecting  lines.   The  connecting  lines may be solid or
     dashed.  The scaling  parameters,  FIRSTV  and  DELTAV,  as
     detailed in subroutine SCALE, must be found in the last two
     locations of each array.  These values, if not computed  by
     subroutine SCALE, must be supplied by the user.

             ********** calling sequence **********

        CALL LINE (XARRAY,YARRAY,NPNTS,ILINE,ISYSB,DASH)

             **************************************


     XARRAY  (input  parameter)  is  the   name   of   the   one
                    dimensional    array    containing   the   X
                    (abscissa) values  along  with  the  scaling
                    values for this array.

     YARRAY  (input  parameter)  is  the   name   of   the   one
                    dimensional    array    containing   the   Y
                    (ordinate) values  along  with  the  scaling
                    values for this array.

     NPNTS   (input parameter) is the number of data  points  in
                    the XARRAY and YARRAY.  Note:  The number of
                    points in both  arrays  must  be  the  same.
                    This  number  does not include the two extra
                    locations required for scaling parameters.

     ILINE   (input parameter) is a flag used  to  describe  the
                    type  of  line  to be drawn through the data
                    points.
           (ILINE = 0) points are connected by  straight  lines,
                    no centered symbols are plotted.
           (ILINE > 0) points are connected  by  straight  lines
                    and  a  centered  symbol  is  drawn  at each
                    point.
           (ILINE < 0) centered  symbols  are  plotted  at  each
                    point without connecting lines.







                              4-30
                                               Graphing Routines


     ISYMB   (input parameter) is the integer equivalent of  the
                    desired centered symbol.

     DASH    (input parameter) is a flag  to  tell  whether  the
                    connecting lines are solid or dashed.
           (DASH = 0) make the connecting lines solid.
           (DASH > 0) make the connecting lines dashed.  DASH is
                    the length, in inches.



                                NOTE

         For the dashes to show up, the length of the dashes
         must  be  much  smaller  than  the distance between
         consecutive points.  Subroutine LINE should not  be
         used  to  plot  a  large  number  of  points  close
         together.





     4.2.6  Subroutine 'LOGAX'

            ---------- -------

          LOGAX is used to draw  a  logarithmic  axis  with  any
     number of cycles.  Each cycle is labelled.

             ********** calling sequence **********

     CALL LOGAX (X0,Y0,NCHR,ITITLE,ANGLE,AXSLEN,NCYC,IEXP)

             **************************************


     (X0,Y0) (input parameter) is the  coordinate  position,  in
                    inches, of the starting point for the axis.

     NCHR    (input   parameter)   specifies   the   number   of
                    characters in the title and on which side of
                    the axis the labeling  information  will  be
                    written.
           (NCHR > 0) make  the  'tick'  mark,  annotation,  and
                    header  placement  on  the  counterclockwise
                    side  of  the  axis.   This   condition   is
                    normally desired for the Y-axis.
           (NCHR =  0)  make  the  'tick'  mark  and  annotation
                    placement  on  the counter-clockwise side of
                    the axis.  There is no header on this axis.




                              4-31
Graphing Routines


           (NCHR < 0) make  the  'tick'  mark,  annotation,  and
                    header  placement  on  the clockwise side of
                    the  axis.   This  condition   is   normally
                    desired for the X-axis.


     ITITLE  (input parameter) is the title for the axis.   This
                    title is centered and placed parallel to the
                    axis line.  ITITLE  is  either  a  Hollerith
                    literal,  or  an  array containing five left
                    justified characters per  word.   The  title
                    has a fixed height of 0.15 inch.

     ANGLE   (input parameter) is  the  angle,  in  degrees,  at
                    which  the  axis  is  to be drawn.  Normally
                    this value is 0.0 for the  X-axis  and  90.0
                    for the Y-axis.

     AXSLEN  (input parameter) is the length, in inches, of  the
                    axis line.

     NCYC    (input parameter)  is  the  number  of  logarithmic
                    cycles wanted.

     IEXP    (input parameter) is the lower exponent  limit  for
                    the  axis.   The  base of the first cycle is
                    labeled with 10**IEXP.



                                NOTE

         The creation  of  an  (X,Y)  coordinate  system  is
         accomplished by two references to subroutine LOGAX.




















                              4-32
                                               Graphing Routines


     4.2.7  Subroutine 'LOGAXS'

            ---------- --------

          LOGAXS is used to draw a  logarithmic  axis  with  any
     number of cycles, with only some of the cycles labelled.

             ********** calling sequence **********

          CALL LOGAXS (X0,Y0,NCHR,ITITLE,ANGLE,AXSLEN,
                       NCYC,IEXP,LABTIC)

             **************************************


     (X0,Y0) (input parameters) is the coordinate  position,  in
                    inches, of the starting point for the axis.

     NCHR    (input   parameter)   specifies   the   number   of
                    characters in the title and on which side of
                    the axis the labeling  information  will  be
                    written.
           (NCHR > 0) make  the  'tick'  mark,  annotation,  and
                    title placement on the counterclockwise side
                    of the axis.   This  condition  is  normally
                    desired for the Y-axis.
           (NCHR =  0)  make  the  'tick'  mark  and  annotation
                    placement  on  the counter-clockwise side of
                    the axis.  There is no title on this axis.
           (NCHR < 0) make  the  'tick'  mark,  annotation,  and
                    title placement on the clockwise side of the
                    axis.  This condition  is  normally  desired
                    for the X-axis.


     ITITLE  (input parameter) is the title for the axis.   This
                    title is centered and placed parallel to the
                    axis line.  ITITLE  is  either  a  Hollerith
                    literal,   or   an   array  containing  five
                    left-justified  characters  per  word.   The
                    title has a fixed height of 0.15 inch.

     ANGLE   (input parameter) is  the  angle,  in  degrees,  at
                    which  the  axis  is  to be drawn.  Normally
                    this value is 0.0 for the  X-axis  and  90.0
                    for the Y-axis.

     AXSLEN  (input parameter) is the length, in inches, of  the
                    axis line.






                              4-33
Graphing Routines


     NCYC    (input parameter)  is  the  number  of  logarithmic
                    cycles wanted.

     IEXP    (input parameter) is the lower exponent  limit  for
                    the  axis.   The  base of the first cycle is
                    labeled with 10**IEXP.

     LABTIC  (input parameter) is the labeling interval for  the
                    'tick'  marks.   For example, if LABTIC = 3,
                    every third  'tick'  mark  is  labeled.   If
                    (LABTIC = 0) no labeling will be done.



                                NOTE

         The creation  of  an  (X,Y)  coordinate  system  is
         accomplished   by   two  references  to  subroutine
         LOGAXS.





     4.2.8  Subroutine 'SCALE'

            ---------- -------

          Subroutine SCALE is used to examine  the  data  values
     contained in an array to determine:


      1)  A  starting  value,  (FIRSTV)  which  is  an  adjusted
          minimum, or maximum value for the array (see NPT).

      2)  A  scaling  factor,  (DELTAV)  which  is  positive  or
          negative such that:

           A)  The  scale  annotation  drawn  by  AXIS  on  each
               division  'tick' mark will properly represent the
               range of real data values in the array.

           B) The data points, when plotted  by  LINE  will  fit
               within the given plotting area.


          These two values (FIRSTV and DELTAV) are  computed  by
     SCALE  and  stored  in  the two locations at the end of the
     data array used.   The  scaling  factor  (DELTAV)  that  is
     computed  represents  the  number of data units per inch of
     axis, but is adjusted so that it is always an  interval  of
     1,  2, 4, 5, or 8 * 10**N (N is an exponent consistent with
     the original unadjusted scaling factor).   This  adjustment
     insures that the axes can be labeled with integer numbers.

                              4-34
                                               Graphing Routines


          The starting value (FIRSTV) which would appear as  the
     first  annotation on the axis, is computed as some multiple
     of DELTAV that is equal to or outside  the  limits  of  the
     data in the array.

          For example, consider  an  array  having  a  range  of
     values  from  301  to  912 to be plotted over an axis of 10
     inches.  The unadjusted scaling factor is:

          (912 -  301.0)  /  10.0  = 61.1 units/inch.

     The adjusted DELTAV would be  80.0  (8 * 10**1).   In  this
     example,  a  FIRSTV  of  240.0  would be chosen as the best
     value if a minimum is returned;  1040.0 would be chosen  as
     the best value for the maximum.

          In another example, values from -1.0 to +1.0 are to be
     plotted over a 5 inch axis.

             (+1.0 - (-1.0)) / 5.0 = 0.4 units/inch

     DELTAV = 4 * 10**-1, FIRSTV = -1.2 for a minimum,  or  +1.2
     for  a  maximum.   Note  that  5  inches from -1.2 is +0.8,
     although the data goes to +1.0, which is past  the  top  of
     the axis.

             ********** calling sequence **********

                 CALL SCALE (ARRAY,AXSLEN,NPT)

             **************************************


     ARRAY   (input parameter) is the array of data points to be
                    examined.


                                        NOTE

                        This array must be  dimensioned  for
                        at  least two more elements than the
                        number of values  being  scanned  to
                        allow  SCALE  to  store the computed
                        starting  value  and   the   scaling
                        factor at the end of the array.









                              4-35
Graphing Routines


     AXSLEN  (input parameter) is the length  of  the  axis,  in
                    inches,  to  which the data is to be scaled.
                    It's value must be greater than 1.   If  the
                    value given is not a whole number, the value
                    given will be rounded  to  the  next  lowest
                    whole number and this value will be used for
                    calculations.

     NPT     (input parameter) is the number of data  values  to
                    be scanned within the array.
           (NPT > 0) return FIRSTV as the minimum value.
           (NPT < 0) return FIRSTV as the maximum value, and use
                    the  absolute  value of NPT as the number of
                    data points.

     FIRSTV is returned to the user in ARRAY(NPT+1)

                    DELTAV  is   returned   to   the   user   in
                    ARRAY(NPT+2).


          Generally, subroutine SCALE is referenced  to  examine
     each  array  to be plotted.  if the user knows the range of
     his data values, he doesn't have to reference SCALE for the
     array  as  long  as  he  supplies an appropriate FIRSTV and
     DELTAV when the axes subroutines and  subroutine  LINE  are
     called.


                                NOTE

         Unlike the other  routines  in  described  in  this
         chapter, subroutine SCALE does not do any plotting.





















                              4-36
                                               Labeling Routines


     4.3  LABELING ROUTINES

          -------- --------

          The routines used to label plots allow the  user  full
     freedom   of   choice   on   symbol   placement,  size  and
     orientation, as well as a fairly full selection of alphabet
     styles  for  the  characters.  The symbol sets available to
     the user can be changed with the SETSYM routine.

          See the description of SETSYM for a list of  character
     tables.   Examples  of the character sets is plotted in the
     appendix.

          The basic routine for  symbol  generation  is  SYMBOL,
     which  actually makes the calls to PLOT that define the pen
     strokes for the desired character.  The routine NUMBER is a
     routine  that is designed to make the generation of numeric
     labels convenient.  Careful use of  the  labeling  routines
     will  enhance the plot by attractively calling attention to
     the labeled features for easy identification.

          These routines are the included in FORLIB, the FORTRAN
     library.   Unlike  the  CALCNT  and PLOT3D routines, FORLIB
     routines get loaded automatically whenever they are needed.




          The Labelling Routines are:

     1.  NUMBER - Draw a floating-point number.

     2.  SETSYM - Select a symbol set.

     3.  SYMBOL - Draw text on the plot.



















                              4-37
Labeling Routines


     4.3.1  Subroutine 'NUMBER'

            ---------- --------

          Subroutine NUMBER will draw a floating-point number on
     the  plotter.  This routine converts the number to a string
     of digits and then calls subroutine SYMBOL.

             ********** calling sequence **********

        CALL NUMBER (X0,X0,HEIGHT,FNUM,ANGLE,NDIG,IRAD)

             **************************************


     (X0,Y0) (input parameters) is the coordinate, in inches, of
                    the  lower  left  hand  corner  of the first
                    character to  be  drawn  (before  rotation).
                    The value of 999.0 for X0 or Y0 means to not
                    change the appropriate pen coordinate.

     HEIGHT  (input parameter) is the height, in inches, of  the
                    digits to be drawn.

     FNUM    (input parameter) is the floating-point number that
                    is to be converted and plotted.

     ANGLE   (input parameter) is  the  angle,  in  degrees,  at
                    which the number is to be plotted.

     NDIG    (input parameter) controls  the  number  of  digits
                    plotted.
           (NDIG > 0) the number of digits to the right  of  the
                    decimal  point  that  are to be plotted.  If
                    NDIG  is  greater  than  eight,  only  eight
                    digits will be plotted.
           (NDIG = 0) only the integer portion of the number and
                    the decimal point will be plotted.
           (NDIG = -1) only the integer portion  of  the  number
                    will be plotted.
           (NDIG -1) the absolute value of NDIG - 1 digits  will
                    be truncated from the integer portion before
                    plotting.


     IRAD    (input parameter) is an  optional  argument.   This
                    argument  allows  the  user  to  specify the
                    output radix of the number.  If IRAD  equals
                    eight  the  number will be plotted in octal,
                    etc.





                              4-38
                                               Labeling Routines


                            Example

                            -------

           PI = 3.14159
           CALL NUMBER (999.0, 999.0, 0.1, PI, 90.0, 2)
     CC That drew '3.14' at 90 degrees, at the last
     CC  pen position



     4.3.2  Subroutine 'SETSYM'

            ---------- --------

          The SETSYM routine changes the character set  used  by
     the  SYMBOL  routine.  The system character sets are stored
     in SYS:SYMBOL.DAT[1,4], users may use a private set if they
     define the logical device name SYMBOL:.

             ********** calling sequence **********

                  CALL SETSYM(IFUNC,IARG,IANS)

                               or

               CALL SETSYM('WIDTH',LETTER,WIDTH)

             **************************************


     IFUNC   (input parameter) is the function to perform.

     IARG    (input parameter) is the argument for the function.

     IANS    (output parameter) is the returned value.


     (IFUNC = 'TABLE') change the character set table.  If  IARG
                    is    positive,   read   that   table   from
                    SYS:SYMBOL.DAT[1,4]  (like  the  old  ISETAB
                    function).   If  IARG is negative, read that
                    table from  SYMBOL:SYMBOL.DAT[-]  (like  the
                    old MSETAB function).
          IARG = (input parameter) The table to read.
          IANS = (output parameter) The  error  flag.   0  means
                    table   set   up,  -1  means  an  error  was
                    encountered.

     (IFUNC = 'QUERY') read the number of the current table  and
                    return it in IANS.





                              4-39
Labeling Routines


          IARG = (ignored)
          IANS = (output parameter) The current table number.

     (IFUNE = 'WIDTH')  read  the  width  of  the  character  as
                    compared to the height.
          IARG = (input parameter)  Either  a  single  character
                    between quotes, or an integer with the ASCII
                    code of the character.
          WIDTH = (output  parameter)  The  ratio  of  width  to
                    height, usually in the neighborhood of 0.67,
                    and returned as 0.0 if no such character.





                         Symbol Tables

                         ------ ------

         Table                  Upper   Lower   Numbers Punctu-
                                Case    Case            ation

         1  CSM Standard        yes     yes     yes     yes
         2  CSM secondary       yes     no      yes     yes
         3  Olde English        yes     yes     yes     yes
         4  Old German          yes     yes     no      no
         5  Old Italian         yes     yes     no      no
         6  Script              yes     yes     no      no
         7  Simplex Roman       yes     yes     yes     yes
         8  Simplex Italics     yes     yes     yes     yes
         9  Triplex Roman       yes     yes     yes     yes
         10 Triplex Italics     yes     yes     yes     yes
         11 Hershey's letters   yes     yes     yes     yes
         12 Simplex Greek       yes     yes     no      no
         13 Duplex Greek        yes     yes     no      no


          The CSM software retains only one symbol table at  any
     given  time;  it contains the description of alphabetic and
     numeric symbols, and SETSYM table  #1  contains  a  set  of
     centered symbols for marking points.













                              4-40
                                               Labeling Routines


          There are 26 centered  symbols  in  the  CSM  standard
     symbol  table  (SETSYM  table  number  1).   The exact same
     centered symbols appear in the CSM secondary table  (SETSYM
     table number 2).  These symbols are:

                        Centered Symbols

                        -------- -------

          0     Square box            13     Vertical bar
          1     Circle                14     Five pointed star
          2     Triangle              15     Horizontal bar
          3     Plus sign             16     Digit '0'
          4     X                     17     Digit '1'
          5     Diamond               18     Digit '2'
          6     Up arrow              19     Digit '3'
          7     X with top bar        20     Digit '4'
          8     Z                     21     Digit '5'
          9     Y                     22     Digit '6'
          10    Square Star           23     Digit '7'
          11    Asterisk              24     Digit '8'
          12    Hourglass             25     Digit '9'



     4.3.3  Subroutine 'SYMBOL'

            ---------- --------

          The SYMBOL subroutine draws alpha-numeric  strings  or
     centered  symbols  of any height (minimum = 0.02 inches) at
     any angle.   There  are  3  modes  of  operation  for  this
     routine:

          Mode 1:  Draw text for titles and captions (NCHR > 0).

          Mode 2:  Draw a single character or symbol (NCHR = 0).

          Mode 3:  Draw a single centered symbol (NCHR < 0).

             ********** calling sequence **********

          CALL SYMBOL (X0,Y0,HEIGHT,ICHARS,ANGLE,NCHR)

             **************************************











                              4-41
Labeling Routines


     Modes 1 and 2:

     ----- - --- --


     (X0,Y0) (input parameter) is the coordinate, in inches,  of
                    the  lower  left  hand  corner  of the first
                    character to be drawn,  before  rotation  by
                    ANGLE.   The  pen is up while moving to this
                    point.  If X0 and/or Y0 are  set  to  999.0,
                    the   next   symbol   will  be  drawn  as  a
                    continuation of the  text  previously  drawn
                    (the  pen  will not be repositioned from its
                    current position at the end of the text).

     HEIGHT  (input parameter) is the height, in inches, of  the
                    character(s)   to   be  drawn.   For  symbol
                    library character set 1 the width/height  is
                    8/8,   this   includes   the  spacing.   For
                    example, a  string  of  16  characters  0.15
                    inches  high will be 2.40 inches wide.  This
                    is not true for other symbol sets.

     ICHARS  (input parameter) is the text to be drawn.
           (for mode 1) ICHARS is either a literal  enclosed  by
                    apostrophes,  or  an  array  containing five
                    left-justified characters per element.
           (for mode 2) ICHARS(1) is the number of  the  desired
                    character.   ICHARS  may  be  an array or an
                    undimensioned variable.


     ANGLE   (input parameter) is the angle in degrees at  which
                    the text is to be plotted.

     NCHR    (input parameter) the mode of operation.
           (NCHR > 0) is the number of characters to be  plotted
                    from the ICHARS array (Mode 1).
           (NCHR = 0) indicates that 1 character,  as  shown  in
                    ICHARS, is to be plotted (Mode 2).















                              4-42
                                               Labeling Routines


     Mode 3:

     ---- --

     (X0,Y0) (input parameter) is the coordinate, in inches,  of
                    the  center of the centered symbol.  The pen
                    is returned to this point after the  special
                    character is drawn.

     HEIGHT  (input parameter) is the height and  width  of  the
                    desired symbol.

     ICHARS  (input parameter) is the integer equivalent of  the
                    desired  symbol,  ICHARS(1) equals the value
                    of the integer equivalent.  ICHARS may be an
                    array or an undimensioned variable.

     ANGLE   (input parameter) is the angle in degrees at  which
                    the symbol is to be plotted.

     NCHR    (input  parameter)  is  negative   and   determines
                    whether  the  pen  is  up or down during the
                    move to (X0,Y0).
           (NCHR = -1) the pen is up during the move to (X0,Y0).
           (NCHR = -2) the  pen  is  down  during  the  move  to
                    (X0,Y0).



                                NOTE

         The text symbols (in CSM library  symbol  table  1)
         are  generated  on  an 8 by 8 point (X,Y) grid with
         the starting point at the lower  left  corner,  and
         finish  point  at  the  lower  right  corner.   The
         special characters are generated on a 5 by 5  point
         grid  with the starting and finishing points at the
         center.  The coordinates (Xn,Yn) of the lower  left
         hand  corner of the Nth character to be plotted are
         given by:

             Xn = X0 + (N-1) * HEIGHT * COS(ANGLE)
             Yn = Y0 + (N-1) * HEIGHT * SIN(ANGLE)












                              4-43
Obsolete Functions


     4.4  OBSOLETE FUNCTIONS

          The following FUNCTION subprograms are obsolete:

     1.  IPLOT  - Replaced by subroutine PLOTS.

     2.  ISETAB - Replaced by subroutine SETSYM.

     3.  MSETAB - Replaced by subroutine SETSYM.




     4.4.1  Function 'IPLOT'

            -------- -------

          This routine is obsolete.  Subroutine PLOTS should  be
     used  to  initiate  the  plot.   The  change was made to be
     compatible with  DEC-supplied  plotting  routines,  and  to
     allow the plotter type to be explicitly specified.

          As an  interim  measure,  a  dummy  IPLOT  routine  is
     provided.  It does the following:

        FUNCTION IPLOT(IWARN)
        IPLT = 0                !Zero means default plotter
        IERR = IWARN            !Number of messages to trace
        CALL PLOTS(IPLT,IERR)   !Call the right routine
        IPLOT = IERR            !Zero means OK
        RETURN
        END



                                NOTE

         Subroutine IPLOT  will  eventually  go  away.   All
         programs  that  use IPLOT should be modified to use
         PLOTS instead.















                              4-44
                                              Obsolete Functions


     4.4.2  Function 'ISETAB'

            -------- --------

          This routine has  been  replaced.   Subroutine  SETSYM
     should  be  used  to  change  the data table for subroutine
     SYMBOL.

          As an interim  measure,  a  dummy  ISETAB  routine  is
     provided.  It does the following:

        FUNCTION ISETAB(ITABLE)
        CALL SETSYM('TABLE',ITABLE,IERR) !Call the right routine
        ISETAB = IERR                    !Zero means OK
        RETURN
        END



                                NOTE

         Subroutine ISETAB will  eventually  go  away.   All
         programs  that use ISETAB should be modified to use
         SETSYM instead.





     4.4.3  Function 'MSETAB'

            -------- --------

          This routine has  been  replaced.   Subroutine  SETSYM
     should  be  used  to  change  the data table for subroutine
     SYMBOL.

          As an interim  measure,  a  dummy  MSETAB  routine  is
     provided.  It does the following:

        FUNCTION MSETAB(ITABLE)
        CALL SETSYM('TABLE',-ITABLE,IERR) !Call right routine
        MSETAB = IERR                    !Zero means OK
        RETURN
        END



                                NOTE

         Subroutine MSETAB will  eventually  go  away.   Any
         programs  that use MSETAB should be modified to use
         SETSYM instead.



                              4-45












                           CHAPTER 5

                  CONTOURING AND 3-D ROUTINES



     5.1  CONTOURING ROUTINES

          ---------- --------

          The routines CALCNT, GRIDER, and CALSIZ allow the user
     to  take  data  that is (X,Y,Z) triples, reduce the data to
     equally spaced 'grided' data, and plot the information as a
     contour  map  of a specified size.  The user should be very
     aware of the fact that the basic (X,Y,Z) data  provided  to
     subroutine   GRIDER   is   changed  according  to  internal
     algorithms to make equally spaced data.  It is the  gridded
     data  that is plotted, NOT the users original data, and the
     gridded data may contain 'artifacts'.   The  artifacts  are
     artificial  highs  or  lows at a points in the gridded data
     array caused by the algorithm used to make  equally  spaced
     data.

          To use these routines you must include  LBY:CALCNT.REL
     as part of your LOAD or EXECUTE command.  For example:

               .EXECUTE MYPROG.FOR,LBY:CALCNT.REL

               -




     The CALCNT contouring routines consist of:

     1.  CALCNT - Draws the contour from equally spaced data

     2.  CALSIZ - Changes the size of the contour map

     3.  GRIDER - Transforms (X,Y,Z) to equally spaced data







                              5-1
Contour Map Routines


     5.1.1  Subroutine 'CALCNT'

            ---------- --------

          This program will draw contours on a rectangular  area
     which  has  been  defined  by  equally  spaced  data,  i.e.
     gridded data.  The size of this area is normally  8  inches
     by 8 inches, if the X and Y lengths are equal.  If they are
     not equal, the longer side  of  the  rectangle  will  be  8
     inches.   The size may be altered by referencing subroutine
     FACTOR or CALSIZ.  Subroutine FACTOR will scale the  entire
     plot up or down and subroutine CALSIZ will only increase or
     decrease the map size, the characters in the legend and the
     contour elevations will stay the same size.

             ********** calling sequence **********

       CALL CALCNT (X,Y,GRID,IX,IY,MAXX,MAXY,CLOW,CHIGH,
                       CINT,NELEV,LOWHI)

             **************************************


     (X,Y)   (input parameter) is the coordinate, in inches,  of
              the  lower  left  hand  corner of the contour map.
              Allow about .26 inches at the bottom of the map if
              the legend is wanted.  Allow about one (1) inch on
              each side of the map if the elevations are  to  be
              labeled.

     GRID    (input parameter)  is  the  two  dimensional  array
              containing   the  values  to  be  contoured.   The
              location of a point on the map is defined  by  the
              position of a point in the matrix.

     IX      (input parameter) is the number of contoured  grids
              in the X direction.

     IY      (input parameter) is the number of contoured  grids
              in the Y direction.

     MAXX    (input parameter) is the GRID array X dimension.

     MAXY    (input parameter) is the GRID array Y dimension.

     CLOW    (input parameter) is the lowest contour value.

     CHIGH   (input parameter) is the highest contour value.  If
              both  CLOW and CHIGH are zero, they will be set to
              the minimum and maximum of GRID array.

     CINT    (input parameter) is the contour interval.
             (CINT > 0) CINT is the contour interval.
             (CINT = 0) the contour interval  is  set  equal  to

                              5-2
                                            Contour Map Routines


                      (CHIGH - CLOW) / 16.
             (CINT 0) the  contour  interval  is  set  equal  to
                      (CHIGH - CLOW) / (-CINT).


     NELEV   (input  parameter)  indicates  contour   elevations
              along the right and left hand sides of the map.
             (NELEV > 0) the contour level label interval,  i.e.
                      if NELEV = 3 label every third contour.
             (NELEV = 0) do not label any contours.
             (NELEV  0)  do  not  label  contours  or   draw   a
                      perimeter.


     LOWHI   (input parameter) indicates lows and highs.
             (LOWHI = 0) do not mark the lows and highs.
             (LOWHI > 0) mark the lows and highs.  The lows  are
                      marked  with  an  'L'  and  the  highs are
                      marked with an 'H'.


                                NOTE

         The legend and the perimeter  around  the  map  are
         drawn using the blue pen, every fifth (5th) contour
         is drawn in black, and the lows and highs are drawn
         in red.



























                              5-3
Contour Map Routines


     5.1.2  Subroutine 'CALSIZ'

            ---------- --------

          CALSIZ allows the user  to  change  the  size  of  the
     contour  map to be plotted.  CALSIZ is used with subroutine
     CALCNT.

              ******** calling sequence **********

                       CALL CALSIZ (X,Y)

              ************************************

     X       (input parameter) is the maximum X  direction  size
              allowed for the map, in inches.

     Y       (input parameter) is the maximum Y  direction  size
              allowed for the map, in inches.


                                NOTE

         This routine will NOT cause the contour map  to  be
         expanded  in  one  direction  only.   The grid will
         remain  square,  and  the  map  will  be  uniformly
         reduced  to fit the most demanding dimension.  When
         using this routine allow  about  an  inch  on  both
         sides of the map in the X direction for the contour
         elevation label.

























                              5-4
                                            Contour Map Routines


     5.1.3  Subroutine 'GRIDER'

            ---------- --------

          GRIDER allows the  user  to  grid  irregularly  spaced
     three-dimensional data into equally spaced gridded data.  A
     weighted moving average technique is used to grid the data.

             ********** calling sequence **********

          CALL GRIDER (N,X,Y,Z,GRDSIZ,IX,IY,ZZ,NX,NY,
              MXMN,XMAX,XMIN,YMAX,YMIN,ZMAX,ZMIN)

             **************************************

     N       (input  parameter)  is  the   number   of   (X,Y,Z)
              three-dimensional data sets to be gridded.

     (X,Y,Z) (input  parameters)  are  the  coordinates  of  the
              irregularly  spaced  three-dimensional  data to be
              gridded.
             (X) is an array that contains the X values.
             (Y) is an array that contains the Y values.
             (Z) is an array that contains the Z values.

     GRDSIZ  (input parameter) is the  desired  length  of  each
              square  in  the  grid.   If GRDSIZ is less that or
              equal to zero GRIDER will calculate the best  grid
              size from the input data.
             (output parameter) is the length of the each square
              in  the  grid.  Warning - GRDSIZ may be changed by
              subroutine GRIDER.

     IX      (input parameter)  is  the  number  of  grid  lines
              wanted in the X direction.  If IX is less than two
              (2) GRIDER will calculate the  best  IX  from  the
              input data.
             (output parameter) is the number of grid lines used
              in  the  X direction.  Warning - IX may be changed
              by subroutine GRIDER.

     IY      (input parameter)  is  the  number  of  grid  lines
              wanted in the Y direction.  If IY is less than two
              (2) GRIDER will calculate the  best  IY  from  the
              input data.
             (output parameter) is the number of grid lines used
              in  the  Y direction.  Warning - IY may be changed
              by subroutine GRIDER.

     ZZ      (output parameter)  is  the  two-dimensional  array
              that contains the gridded data.

     NX      (input parameter) is the  X  dimension  of  the  ZZ
              array.  NX is the maximum value allowed for IX.

                              5-5
Contour Map Routines


     NY      (input parameter) is the  Y  dimension  of  the  ZZ
              array.  NY is the maximum value allowed for IY.

     MXMN    (input parameter) is a flag on whether  or  not  to
              calculate the X and Y maximums and minimums.
             (MXMN = 0) calculate XMAX, XMIN, YMAX, and YMIN.
             (MXMN > 0) do not calculate XMAX, XMIN,  YMAX,  and
                      YMIN, use what the user sends.

     XMAX    (input parameter) is the maximum X value.
             (output parameter) is the maximum X value  used  by
              subroutine  GRIDER.  Warning - XMAX may be changed
              by subroutine GRIDER.

     XMIN    (input parameter) is the minimum X value.
             (output parameter) is the minimum X value  used  by
              subroutine  GRIDER.  Warning - XMIN may be changed
              by subroutine GRIDER.

     YMAX    (input parameter) is the maximum Y value.
             (output parameter) is the maximum Y value  used  by
              subroutine  GRIDER.  Warning - YMAX may be changed
              by subroutine GRIDER.

     YMIN    (input parameter) is the minimum Y value.
             (output parameter) is the minimum Y value  used  by
              subroutine  GRIDER.  Warning - YMIN may be changed
              by subroutine GRIDER.

     ZMAX    (output parameter) the maximum Z value.

     ZMIN    (output parameter) the minimum Z value.




                                     NOTE

                  This routine does not do any plotting.





     5.2  3-D ROUTINES

          --- --------

          Documentation on SLIC3D,  GRID3D,  and  LOOK3D  to  be
     supplied at a later date.





                              5-6












                           CHAPTER 6

                     PROGRAMMING TECHNIQUES



     6.1  STARTING AND STOPPING PLOTTING

          -------- --- -------- --------

     The graphics software  for  plotting  routines  requires  a
     specific  sequence  of  calls to routines in the package in
     order to properly initialize the plotting package, and also
     to finish the plot correctly.  The subroutine PLOTS is used
     to  set  up  the  plotting  package  by   checking   window
     privileges,   getting   the   initial  character  set,  and
     gathering  identification  information  for  labeling   the
     spooled output.  Subroutine PLOTS must be called BEFORE any
     reference to a routine that tries to plot.

          Correct termination of a plotting sequence is made  by
     calling PLOT with a third argument of 999.  That is:


                      CALL PLOT (X,Y,999)

     Failure to properly terminate a plot may cause loss of  the
     plot  in handling because the spooling identification label
     will  be  missing.   Although  a  plot  may   be   properly
     initialized,   and  terminated,  it  is  possible  to  lose
     information on a plot due to the window limitations.   When
     the  plotting  routines  are initialized, the origin of the
     universal plotting window is set to the lower  left  corner
     of  a  default  11  by 11 inch window.  This default allows
     only  positive  X  and  Y  values  to  be  plotted  on  the
     unadjusted  window.  It is common practice to move the plot
     origin away from the corner of the plot window to  allow  a
     margin to contain title information, axis labels, and other
     identification.







                              6-1
Programming Techniques


                            Example

                            -------

          This example properly initializes a plot,  resets  the
     origin to allow a margin for notations, changes the default
     character set (with proper error recovery),  and  correctly
     terminates the plot.
           .
           .
           .
     C
     C  *** START PLOT OUTPUT ***
     C
        IERR = 2                !Ask for 2 warnings
        CALL PLOTS(IERR,0)      !Start the plot
        IF (IERR.NE.0) STOP '?CANNOT OPEN PLOT'
     C
     C  *** SET ORIGIN TO ALLOW 1 INCH LEFT AND
     C  *** BOTTOM MARGINS WHILE PLOTTING  ***
     C
        CALL PLOT (1.0, 1.0, -3)
           .
           .
           .
     C
     C  *** CHANGE TO SYMBOL SET #9 ***
     C  *** CLOSE PLOT AND STOP  ***
     C  *** IF ANY PROBLEMS OCCUR  ***
     C
        CALL SETSYM('TABLE',9,IERR)
        IF (IERR.EQ.0) GOTO 400
        CALL PLOT (X,Y,999) ! Must close plot first !!!
        STOP '?FAILURE TO GET SYMBOL SET 9'
     400     CONTINUE
           .
           .
           .
     C
     C  *** CLOSE PLOTTING OUTPUT ***
     C
        CALL PLOT (X,Y,999)
        STOP
        END











                              6-2
                                          Programming Techniques


     6.2  DEBUGGING TECHNIQUE

          --------- ---------

          Debugging should be done sequentially.

          First, be sure that your program is producing the data
     you  wish  to  plot  by  using  printouts before adding the
     plotter routines.

          Second, be  sure  that  you  are  plotting  the  curve
     correctly  before  adding  lots  of  'ginger  bread' (axis,
     title, grid, etc.).

          Third, add the trimmings that  produce  an  impressive
     plot.

                         Common Errors

          There are two  common  errors  that  give  programmers
     doing plotting the most trouble.

     1.  Not knowing what data values  are  being  sent  to  the
         plotting  routines.   Many apparent plotting errors are
         in  fact  incorrect  data  values  being  sent  to  the
         plotting  routines.   Please be sure to print a listing
         of the data and check it for correctness before sending
         it to the plotter.

     2.  Incorrect  calling  sequence  for  a   given   plotting
         routine.   The error may be due to a lack of sufficient
         arguments  for  a  routine   (missing   arguments)   or
         arguments of an incorrect type (e.g.  the routine needs
         an  integer  value,  and  you  have  supplied  a   real
         variable, or visa-versa).




















                              6-3
Warning and Error Messages


     6.3  WARNING AND ERROR MESSAGES

          ------- --- ----- --------

          The plotting package  will  issue  warning  and  error
     messages for any actions which cause detectable failures of
     attempts to plot.  The  warning  messages  begin  with  the
     percent  sign  (%)  to  indicate a non-fatal error, and the
     program will continue.  The error messages will begin  with
     a question mark (?), and will be fatal errors, that is, the
     program execution will be halted.


                        Warning Messages

                        ------- --------

     %PLTWWE The window was exceeded

              A  reference  to  subroutine  PLOT  exceeded   the
              current window.

                     Error Messages (Fatal)

                     ----- -------- -------

     ?PLTCSP Please contact the systems programmer.

              This message  means  there  is  an  error  in  the
              plotting package that can not be self corrected.



























                              6-4












                           APPENDIX A

                        SAMPLE PROGRAMS



          This chapter contains an example of  a  program  which
     plots   a  function  generated  in  a  main  program.   The
     subroutine LINPLT is then used to plot this function  on  a
     linear-linear plot.

          The second  program  is  the  one  used  to  plot  the
     character sets one through thirteen found at the end of the
     manual.



     A.1  EXAMPLE PROGRAM #1   LINPLT

          ------- ------- --

          This program calls a  user  defined  plotting  routine
     called  LINPLT.   X  is the arrary of X-values and Y is the
     array of sinc(X).

            DIMENSION X(10000),Y(10000)
            I=0
            DO 100 A=-360,360,.1
            I=I+1
            Y(I)=SIND(360*A/60)/A/ACOS(-1.)*180/(.5)
            X(I)=A  !generate the (X,Y) pair for SINC function
     100    CONTINUE
            CALL LINPLT(X,Y,I)   !calling plotting subroutine
            STOP
            END











                              A-1
Sample Programs


            SUBROUTINE LINPLT(X,Y,N)
            DIMENSION X(N),Y(N),ITITLE(5)
            DATA ITITLE/'PLOT OF A SINC FUNCTION'/
            IERR=-9
      C     CALL PLOTS(IERR,'TEK')   !direct plotting on TEK
            CALL PLOTS(IERR,'SPOOL') !spooled output for DP-8
            CALL ERASE               !erase the screen if on TEK
            IF(IERR.NE.0)STOP 'PLOT PROBLEM'
            CALL PLOT(1.0,1.0,-3)
            IP=NEWPEN(2)
            CALL FACTOR(0.5)         !scale everything down
            CALL SYMBOL(1.5,4.25,.15,ITITLE,0.0,23)
            XLEN=9.0
            YLEN=4.0
            NPT=N-2
            CALL SCALE(X,XLEN,NPT)   !scaling routine for LINE
            CALL SCALE(Y,YLEN,NPT)
            CALL LINE(X,Y,NPT,0,5,0) !connect (X,Y) pairs
            CALL GRID(0,0,1.,1.,8,4) !put a grid on the plot
            CALL PAUSEP(45)          !pause for 45 sec if on TEK
            CALL ERASE
            CALL PLOT(W,V,999)
            RETURN
            END






























                              A-2
                                                 Sample Programs


     A.2  EXAMPLE PROGRAM #2   SYMBOL TABLES

          ------- ------- --

          This is the program used to plot the  thirteen  symbol
     tables  found  at  the end of this manual.  It makes use of
     the SYMBOL and SETSYM subroutines.


        PROGRAM TABLES  !Draws the SYMBOL sets for Appendix D
        DIMENSION TTL1(9),TTL2(7),DATE(3)
        DATA TTL1/'CHARACTERS AVAILABLE IN SUBROUTINE "SYMBOL"'/
        DATA TTL2/'CHARACTER SET IN SETSYM TABLE # '/
        DATA DATE  /'OCTOBER 1982'/

     C Loop through all 13 tables
        DO 40 ITABLE = 1,13
        TYPE 10, ITABLE
     10 FORMAT(' Starting SETSYM table #',I2)
        IERR = 2                    !2 error messages
        CALL PLOTS(IERR,'SPOOL')    !Start the plot
        IF(IERR.NE.0)STOP 'PLOT FAIL'
        CALL PLOT(0.0,1.0,-3)       !Leave room for page numbers
        CALL FACTOR(0.80)           !Reduce size to 5.6 by 8.8

     C Draw a box around the plot in blue
        CALL NEWPEN(1,IERR)         !Reset to blue pen
        CALL PLOT(0.0, 0.0,3)       !Lower left corner, pen up
        CALL PLOT(0.0,11.0,2)       !Left edge
        CALL PLOT(8.5,11.0,2)       !Top edge
        CALL PLOT(8.5, 0.0,2)       !Right edge
        CALL PLOT(0.0, 0.0,2)       !Bottom edge

     C Draw the title using SETSYM table #1
        CALL SETSYM('TABLE',1,IERR) !Reset to standard table
        CALL NEWPEN(2,IERR)         !Change to blue pen
        ATYPE = FLOAT(ITABLE)       !NUMBER needs a REAL arg
        CALL SYMBOL(0.8,10.0,0.15,TTL1,0.0,43)  !Plot titles
        CALL SYMBOL(1.5,9.6,0.15,TTL2,0.0,32)
        CALL NUMBER(999.0,999.0,0.25,ATYPE,0.0,-1,10)

        X0 = 1.4 ; Y0 = 8.6         !Origin
     C Change to new character set
        ITEMP = ITABLE              !Avoid warning from FORTRAN
        CALL SETSYM('TABLE',ITEMP,IERR)
        X = 1.5 ; Y = 9.2 ; H = 0.15
        CALL SYMBOL(X,Y,H,'ABCDEFGHIJKLMNOPQRSTUVWXYZ',0.0,26)
        Y = 9.0
        CALL SYMBOL(X,Y,H,'abcdefghijklmnopqrstuvwxyz',0.0,26)






                              A-3
Sample Programs


     C Create 6 columns, octal 40 thru 160
        DO 20 ICOL = 2,7
        X = X0 + FLOAT(ICOL-2)*1.0 + 0.50
     C Do 16 rows in each column
        DO 20 IROW = 0,15
        Y = Y0 - FLOAT(IROW)*0.5 - 0.5
        ICHAR = ICOL*16 + IROW
        CALL SYMBOL(X,Y,0.30,ICHAR,0.0,0)
     20 CONTINUE        !End of DO IROW and DO ICOL

     C Go back to standard characters and label each symbol
        CALL SETSYM('TABLE',1,IERR)
        IF(IERR.NE.0) STOP 'CANNOT CHANGE BACK TO #1'
        CALL SYMBOL(3.25,0.2,0.15,DATE,0.0,12)
        DO 30 ICOL = 2,7
        X = X0 + FLOAT(ICOL-2)*1.0
     C Label the top of each column
        CALL SYMBOL(X,Y0,0.06,'DEC OCT SYM',0.0,11)
        DO 30 IROW = 0,15
        Y = Y0 - FLOAT(IROW)*0.5 - 0.5
        ICHAR = ICOL*16 + IROW
        AI = FLOAT(ICHAR)
        CALL NUMBER(X,Y,0.06,AI,0.0,-1,10)  !Decimal
        X3 = X + 0.24
        CALL NUMBER(X3,Y,0.06,AI,0.0,-1,8)  !Octal
     30 CONTINUE        !End of DO IROW and DO ICOL

     C Finish this plot correctly
     40 CALL PLOT(X,Y,999)      !End of DO ITABLE=1,13
        END
























                              A-4












                           APPENDIX B

                        LIBRARY PROGRAMS



          This appendix shows sample runs of  plotting  programs
     from the System Library.

     1.  EZPLOT - Draws simple graphs

     2.  GRAPH  - Does curve approximation (spline fit)

     3.  SIMPLT - Rewrite of EZPLOT

     4.  DRAW   - Interactive drawing for TEK 4012 or GIGI




     B.1  EZPLOT

          EZPLOT is the old work horse plotting routine  of  the
     CSM  library  and  has  been  in  use for many years.  This
     routine allows the user to view his data  in  a  quick  and
     dirty  fashion.   The program is quick to use but does lack
     some of the frills of GRAPH or SIMPLT

        .RUN LBY:EZPLOT
        [11:59:05]
        

        DO YOU WANT GENERAL INSTRUCTIONS ? *YES

        DATA INPUT MUST BE REAL AND IN X,Y PAIRS.
        DATA MAY BE ENTERED FROM A TERMINAL
        OR READ FROM AN INPUT DATA FILE.
        
        YOU WILL BE ASKED TO SPECIFY LABELS FOR THE
        X AND Y AXES, TO DETERMINE THEIR LENGTHS,
        AND TO GIVE A TITLE FOR THE PLOT.
        
        YOU MUST SPECIFY WHETHER YOU WANT SYMBOLS PLOTTED
        AT EACH POINT, A CONNECTING LINE DRAWN, OR BOTH.

                              B-1
Library Programs


        NOTE: THE LINE MAY BE DASHED OR SOLID.
        
        YOU WILL BE GIVEN THE OPTION OF A LINEAR-LINEAR,
        LINEAR-LOG, LOG-LINEAR OR LOG-LOG PLOT.
        
        YOU MAY SELECT AUTO SCALING, IN WHICH CASE THE
        MAX AND MIN VALUES OF THE ARRAY ARE USED FOR SCALING,
        OR YOU MAY SPECIFY THE UPPER AND LOWER
        BOUNDS TO BE USED FOR SCALING.
        
        IF MORE THAN ONE SET OF DATA WILL BE PLOTTED
        ON THE SAME AXES, SPECIFY AN UPPER BOUND AND A
        LOWER BOUND FOR THE FIRST SET OF DATA WHICH WILL
        ACCOMMODATE THE SUBSEQUENT SETS OF DATA.
        
        THE PEN WILL BE BLACK FOR THE FIRST SET OF DATA
        PLOTTED. YOU HAVE THE OPTION OF CHANGING THE COLOR
        FOR SUBSEQUENT SETS OF DATA ON THE SAME AXES.
        
        TYPE T IF YOU WISH TO TYPE IN DATA
        TYPE F IF YOU WISH DATA READ FROM A FILE
        *F

        WHAT IS THE NAME OF YOUR INPUT FILE ? *FOR10.DAT

        ENTER FORMAT OF DATA INCLUDING PARENS
        CANNOT EXCEED 30 CHARACTERS INCLUDING THE PARENS.
        *(2G)

           4 DATA VALUES READ
        
        DO YOU WANT THE DATA TYPED ON YOUR TERMINAL ? *NO

        TYPE THE X-AXIS LABEL,20 CHARACTERS OR LESS
        *Title of x-axis

        TYPE THE Y-AXIS LABEL, 20 CHARACTERS OR LESS
        *Title of y-axis

        TYPE A TITLE FOR THE GRAPH,20 CHAR OR LESS
        *Title of plot

        IF YOU WANT A SYMBOL PLOTTED AT EACH POINT, TYPE -1
        IF YOU WANT A LINE DRAWN CONNECTING PTS, TYPE 0
        IF YOU WANT BOTH SYMBOLS AND A LINE, TYPE 1
        *0

        FOR A DASHED LINE, TYPE 1
        FOR A SOLID LINE, TYPE 0
        *1

        FOR LINEAR-LINEAR PLOT, TYPE 1
        FOR LINEAR-LOG PLOT, TYPE 2

                              B-2
                                                Library Programs


        FOR LOG-LINEAR PLOT, TYPE 3
        FOR LOG-LOG PLOT, TYPE 4
        *1

        THE X AND Y AXES HAVE A MAX OF 9.0 INCHES
        TYPE THE LENGTH OF THE X AXIS
        *8

        TYPE THE LENGTH OF THE Y AXIS
        *8

        DO YOU WANT AUTOMATIC SCALING, Y OR N ? *Y

        ARE GRAPH SPECIFICATIONS CORRECT ?
        IF NOT, PROGRAM ASKS ALL GRAPH SPECS AGAIN.
        *Y

        DO YOU WANT ANOTHER SET OF DATA
        PLOTTED ON THE SAME SET OF AXES ? *N

        STOP
        
        End of Execution


                                NOTE

         The value or characters preceded by * are typed  in
         by the user

























                              B-3
Library Programs


     B.2  GRAPH

          GRAPH is another library program.

     .RUN LBY:GRAPH
     [13:08:02]

         THIS A FINAL PLOTTING PROGRAM IN WHICH
         THE USER CAN PRODUCE A FINAL, POLISHED PLOT.
         THE USER SHOULD THOROUGHLY KNOW HIS DATA
         BEFORE RUNNING THIS PROGRAM.

         ENTER PLOT TITLE (--2-- LINES OF 50 CHAR. MAX.)
         (HIT THE <RETURN> AFTER EACH LINE.)
     This is the title of the plot,
     it is 2 lines long.

         FOR PLOT TITLE TO APPEAR AT TOP    --ENTER "T"
         FOR PLOT TITLE TO APPEAR AT BOTTOM --ENTER "B"
     T

         CHOOSE THE TYPE OF GRAPH TO BE PLOTTED.
         LINEAR-LINEAR GRAPH --ENTER "1"
         LINEAR-LOG GRAPH    --ENTER "2"
         LOG-LINEAR GRAPH    --ENTER "3"
         LOG-LOG GRAPH       --ENTER "4"
     1

         DO YOU WANT THE X-AXIS TO INTERSECT
         THE Y-AXIS AT SOME POINT OTHER THAN THE
         LOWER-LEFT CORNER OF THE GRAPH ?
     NO

         THE X-AXIS WILL BE DEALT WITH FIRST.
         ENTER THE TITLE FOR THE AXIS (50 CHAR. MAX.)
     This is the X-AXIS

         ENTER THE LENGTH FOR THE X-AXIS LINE(1" to 10").
     10

         ENTER THE START AND END VALUES FOR X-AXIS.
         (LEFT VALUE , RIGHT VALUE)
     0,10

         ENTER THE INCREMENT (IN DATA UNITS) BETWEEN
         LABELED TIC MARKS ALONG THE AXIS.
         (THESE TICS WILL BE LABELED)
     1

         HOW MANY INTERMEDIATE DIVISIONS
         DO YOU WANT BETWEEN THE LABELED TICS?
         (THESE DIVISIONAL TICS WILL NOT BE LABELED.)
     5

                              B-4
                                                Library Programs


         IN LABELING THE AXIS, HOW MANY SIG FIGS
         DO YOU WANT PRINTED PAST THE DECIMAL?
         (IF DECIMAL POINTS ARE NOT DESIRED--ENTER "-1" )
     1

         WAS ALL THE X-AXIS INFORMATION PUT IN CORRECTLY ?
     Y

         THE Y-AXIS WILL NOW BE DEALT WITH.
         ENTER THE TITLE FOR THE AXIS (50 CHAR. MAX.)
     This is the Y-AXIS

         ENTER THE LENGTH FOR THE Y-AXIS LINE(1" to 9").
     7

         ENTER THE START AND END VALUES FOR Y-AXIS.
         (BOTTOM VALUE , TOP VALUE)
     0,100

         ENTER THE INCREMENT (IN DATA UNITS) BETWEEN
         LABELED TIC MARKS ALONG THE AXIS.
         (THESE TICS WILL BE LABELED)
     10

         HOW MANY INTERMEDIATE DIVISIONS
         DO YOU WANT BETWEEN THE LABELED TICS?
         (THESE DIVISIONAL TICS WILL NOT BE LABELED.)
     5
         IN LABELING THE AXIS, HOW MANY SIG FIGS
         DO YOU WANT PRINTED PAST THE DECIMAL?
         (IF DECIMAL POINTS ARE NOT DESIRED--ENTER "-1" )
     -1

         WAS ALL THE Y-AXIS INFORMATION PUT IN CORRECTLY ?
     Y

         WHAT PEN COLOR DO YOU WANT FOR BOTH AXES?
         (BLUE, BLACK, OR RED)
     BLUE

         WOULD YOU LIKE A GRID TO BE DRAWN ?
     NO

         THE DATA WILL NOW BE DEALT WITH.
         TO ENTER THE DATA POINTS FROM YOUR TERMINAL--ENTER "T"
         TO ENTER THE DATA POINTS FROM A DATA FILE  --ENTER "F"
     F

         WHAT IS THE NAME OF YOUR DATA FILE ?
     TEST.DAT

         ENTER THE FORMAT OF YOUR DATA.
         (INCLUDE PARENTHESIS)

                              B-5
Library Programs


     (2G)

         TO PLOT SYMBOLS AT THE DATA POINTS        --ENTER "-1"
         TO PLOT A LINE THROUGH THE DATA POINTS    --ENTER "0"
         TO PLOT BOTH LINE AND SYMBOLS             --ENTER "1"
         TO PLOT A DASHED-LINE                     --ENTER "2"
         TO PLOT BOTH DASHED-LINE AND SYMBOLS      --ENTER "3"
         TO PLOT A BEST-FIT-LINE OF THE DATA POINTS--ENTER "4"
              (POLYNOMIAL REGRESSION)
         TO PLOT BOTH BEST-FIT-LINE AND SYMBOLS    --ENTER "5"
     5

         CHOOSE THE SYMBOL TO BE PLOTTED:
         SQUARE  --ENTER "0"
         CIRCLE  --ENTER "1"
         TRIANGLE--ENTER "2"
            +    --ENTER "3"
            X    --ENTER "4"
         DIAMOND --ENTER "5"
            *    --ENTER "6"
         LOZENGE --ENTER "10"
         STAR    --ENTER "14"
     2

         WHAT PEN COLOR DO YOU WANT FOR THE PLOT?
     BLACK

         WHAT DEGREE OF POLYNOMIAL WOULD YOU LIKE
         THE DATA POINTS TO BE FIT TO ?
     2

         DO YOU WANT THE CURVE-FIT-LINE TO EXTEND
         TO THE EDGES OF THE GRAPH ?
     Y

         THE COEFFICIENTS FOR THE BEST-CURVE-FIT
         LINE (IN ASCENDING ORDER) ARE:
          0.0000000
          0.0000001
          1.0000000
         DO YOU WANT TO PLOT MORE DATA ON THIS GRAPH ?
     NO

         A PLOT FILE HAS BEEN CREATED, AND EXISTS
         NOW ON YOUR AREA.  IF YOU ARE LOGGED-IN AT
         A TEKTRONIX, THE PLOT CAN BE VIEWED BY THE
         COMMAND:  R TEK
     STOP

     End of Execution
     CPU Time: 1.01     Elapsed time: 3:10.63
     EXIT


                              B-6
                                                Library Programs


     .DIRECT *.PLT
     [13:12:01]

     QA63NZ PLT  23  <077> 1-Nov-82  DSKA:[11,10] GRAPH

     .TEK QA63NZ.PLT
     [13:12:26
       (The TEK program shows the plot on the screen)

     .PLOT *.PLT
     [13:13:26]
     [Plotter job GRAPH queued, request #2067, limit 4]


                                NOTE

         Everything that starts on column 1 was typed by the
         user.





     B.3  SIMPLT

          SIMPLT is a newer version of a quick plotting program.
     The  main benifit of this program is that it can be used to
     make very simple plots or fancy plots.  This  program  also
     has  the advantage of having a cubic spline curve smoothing
     for the lines connecting the data points.


        .R LBY:SIMPLT
        [11:07:59]
        

        Welcome to SIMPLT, version 1.17
        Do you need instructions? *Y
        
        SIMPLT.HLP                              13-Dec-80
        
        Some of the features of SIMPLT are:
                Logarithmic plotting
                Centered symbols
                Dashed or solid lines
                Up to ten sets of data on a single plot
                Automatic scaling
                Cubic spline curve smoothing
                Polynomial regression curve fitting
                Extensive error checking
        
        To use SIMPLT, type:
                .RUN LBY:SIMPLT

                              B-7
Library Programs


        Then just answer the questions. Good luck!!!
        
        [End of SIMPLT.HLP]
        

        For input files, you may type any valid file spec.
        Default format is (2G).
        
        To type data, enter file spec as
        either 'TTY:' or 'TYPE'.
        
        Input file: *{Input the file name}
        Enter format (include parens): *(2G)

        EOF reached. read terminates with   4 points read.
        Would you like to see the data? *N

        Another set of data? *N
        [ 1 sets entered]
        
        Title of graph: *The desired title for the plot

        X axis title: *The title of the x-axis
        X axis length (inches): *8
        Is the x axis logarithmic? *N

        Y axis title: *The title of the y-axis
        Y axis length (inches): *8
        Is the y axis logarithmic? *N

        Would you like a grid? *Y

        Line # 1 - What color (blue, black, or red)? *BLACK
                   Centered symbols? *Y
                   Connecting lines? *Y
                   Dashed lines? *Y

        Plot is finished. Thank you.
        
        End of Execution
        --------------------------------------------------------
                             OR


        
                   Centered symbols? *Y
                   Connecting lines? *N
                   Smoothed lines? *N
                   Polynomial regression line? *Y
                     Degree of curve (5 or less, please)? *4
                     Do you want the regression line to be
                     drawn to the edges of the graph? *Y


                              B-8
                                                Library Programs


        Plot is finished. Thank you.
        
        End of Execution
        --------------------------------------------------------
                             OR


                   Centered symbols? *Y
                   Connecting lines? *N
                   Smoothed lines? *Y
                   Dashed lines? *Y

        Plot is finished. Thank you.
        
        End of Execution


                                NOTE

         The responses preceded by an asterisk are typed  by
         the user





     B.4  DRAW

          The DRAW package consists of a series of programs that
     run   interactively  on  the  TEK  4012  or  GIGI  graphics
     terminals.  The program  triggers  the  crosshairs  on  the
     terminal,  so that the user can position the crosshairs and
     type single-letter commands.

          The manual for the DRAW package is available by

        .PRINT MAN:DRAW.MAN


                                NOTE


              The  DRAW  package   is   suitable   for   the
         generation  one-shot  special  plots,  and  is  not
         recommended for graphing data.









                              B-9












                           APPENDIX C

             HELP AND DOCUMENTARY FILES ON PLOTTING



     C.1  HELP FILES ON PLOTTING

          On the computer in the help files (HLP:)  and  in  the
     documentary  files (DOC:), there is a series of files which
     can aid a user in writting plotting programs.

     1.  The command ".HELP PLOTS" will  type  out  the  general
         PLOT help file.

     2.  The  command  ".HELP  PLOTROUTINES"   will   type   out
         HLP:PLOTRO.HLP.   This  help file consists of a list of
         plot subroutines and their arguments.

     3.  The file DOC:PLOT.DOC documents the differences between
         the  old version 11 routines and the current version 12
         routines.

     4.  A copy of this manual is stored  on  MAN:PLOT.MAN,  but
         that  copy does not have any of the plots from Appendix
         D, and is bulky.  A  better  copy  of  this  manual  is
         available  from  the  Dispatcher  at  the CSM Computing
         Center, on the Colorado School of Mines campus.

















                              C-1












                           APPENDIX D

                    EXAMPLES OF SYMBOL SETS



          The following is examples of  the  thirteen  character
     sets  available on the system.  These sets may be retrieved
     by using the SETSYM subroutine.

          The thirteen character sets are:

     1.  CSM Standard
     2.  CSM Secondary
     3.  Olde English
     4.  Old German
     5.  Old Italian
     6.  Script
     7.  Simplex Roman
     8.  Simplex Italics
     9.  Triplex Roman
    10.  Triplex Italics
    11.  Hershey's letters
    12.  Simplex Greek
    13.  Duplex Greek




















                              D-1
Examples of SYMBOL sets


     D.1  SETSYM TABLE 1   CSM STANDARD

          ------ ----- -




















































                              D-2
                                         Examples of SYMBOL sets


     D.2  SETSYM TABLE 2   CSM SECONDARY

          ------ ----- -




















































                              D-3
Examples of SYMBOL sets


     D.3  SETSYM TABLE 3   OLDE ENGLISH

          ------ ----- -




















































                              D-4
                                         Examples of SYMBOL sets


     D.4  SETSYM TABLE 4   OLD GERMAN

          ------ ----- -




















































                              D-5
Examples of SYMBOL sets


     D.5  SETSYM TABLE 5   OLD ITALIAN

          ------ ----- -




















































                              D-6
                                         Examples of SYMBOL sets


     D.6  SETSYM TABLE 6   SCRIPT

          ------ ----- -




















































                              D-7
Examples of SYMBOL sets


     D.7  SETSYM TABLE 7   SIMPLEX ROMAN

          ------ ----- -




















































                              D-8
                                         Examples of SYMBOL sets


     D.8  SETSYM TABLE 8   SIMPLEX ITALICS

          ------ ----- -




















































                              D-9
Examples of SYMBOL sets


     D.9  SETSYM TABLE 9   TRIPLEX ROMAN

          ------ ----- -




















































                              D-10
                                         Examples of SYMBOL sets


     D.10  SETSYM TABLE 10   TRIPLEX ITALICS

           ------ ----- --




















































                              D-11
Examples of SYMBOL sets


     D.11  SETSYM TABLE 11   HERSHEY'S LETTERS

           ------ ----- --




















































                              D-12
                                         Examples of SYMBOL sets


     D.12  SETSYM TABLE 12   SIMPLEX GREEK

           ------ ----- --




















































                              D-13
Examples of SYMBOL sets


     D.13  SETSYM TABLE 13   DUPLEX GREEK

           ------ ----- --




















































                              D-14



                           GRAPHICS MANUAL




     4006 . . . . . . . . . . . .  2-3
     4012 . . . . . . . . . . . .  2-1
     4025 . . . . . . . . . . . .  2-3
     999
       AXES . . . . . . . . . . .  4-25
       NUMBER . . . . . . . . . .  4-38
       PLOT . . . . . . . . . . .  4-11, 6-1
       PLOTS  . . . . . . . . . .  4-12
       SYMBOL . . . . . . . . . .  4-42

     ARDS . . . . . . . . . . . .  2-2, 4-20
     AXES . . . . . . . . . . . .  4-24
     AXIS . . . . . . . . . . . .  4-26

     CALCNT . . . . . . . . . . .  5-2
     CALCOMP  . . . . . . . . . .  3-1
     CALSIZ . . . . . . . . . . .  5-4
     Centered symbols . . . . . .  4-41
     Common errors  . . . . . . .  6-3
     Coordinate system  . . . . .  3-5

     DASHLN . . . . . . . . . . .  4-28
     Debugging  . . . . . . . . .  6-3
     DMP-4R . . . . . . . . . . .  2-1, 4-4, 4-19 to 4-20
     DP-8 . . . . . . . . . . . .  2-1

     ERASE  . . . . . . . . . . .  2-4, 4-2
     Error messages . . . . . . .  6-4
     Example programs . . . . . .  A-1
       LINPLT . . . . . . . . . .  A-1
       symbol table routines  . .  A-3

     FACTOR . . . . . . . . . . .  3-5, 4-3, 4-5, 4-14, 4-20

     GIGI . . . . . . . . . . . .  2-1, 3-1, 4-19 to 4-20
     Graphics terminal  . . . . .  4-6, 4-9, 4-12
       hardware . . . . . . . . .  2-3 to 2-4
       policies . . . . . . . . .  1-2
     Graphing routines  . . . . .  4-23
     GRID . . . . . . . . . . . .  4-29
     Grider . . . . . . . . . . .  5-5

     Hardware . . . . . . . . . .  2-1
       ARDS . . . . . . . . . . .  2-2
       GIGI . . . . . . . . . . .  2-4
       graphics terminal  . . . .  2-3 to 2-4
       Houston Instruments DP-8 .  2-1
       ReGIS plotter  . . . . . .  2-5

                            Index-i



       TEKTRONIX  . . . . . . . .  2-3
     Help . . . . . . . . . . . .  C-1
       HELP PLOTROUTINES  . . . .  C-1
       HELP PLOTS . . . . . . . .  C-1
       PLOT.DOC . . . . . . . . .  C-1
     Houston Instruments DP-8 . .  1-1, 2-1, 3-1, 3-6, 4-1, 4-9, 
                                   4-20
       window size  . . . . . . .  1-2

     Ink colors . . . . . . . . .  1-3
     IPLOT  . . . . . . . . . . .  4-44
     ISETAB . . . . . . . . . . .  4-45

     Library programs
       DRAW . . . . . . . . . . .  B-9
       EZPLOT . . . . . . . . . .  B-1
       GRAPH  . . . . . . . . . .  B-4
       SIMPLT . . . . . . . . . .  B-7
     LINE . . . . . . . . . . . .  4-30
     LINPLT . . . . . . . . . . .  A-1
     LOGAX  . . . . . . . . . . .  4-31
     LOGAXS . . . . . . . . . . .  4-33

     Monitor PLOT command . . . .  3-1
       examples . . . . . . . . .  3-3
       switches . . . . . . . . .  3-2
     MSETAB . . . . . . . . . . .  4-45

     NEWPEN . . . . . . . . . . .  4-4
     NUMBER . . . . . . . . . . .  4-38, A-3

     Obsolete functions . . . . .  4-44
     Operator . . . . . . . . . .  2-2, 4-9
     OPRTXT . . . . . . . . . . .  1-3, 4-6, 4-9
     ORIGIN . . . . . . . . . . .  4-3, 4-5, 4-15
     Origin . . . . . . . . . . .  3-5

     Paper
       NORMAL . . . . . . . . . .  1-2
       P311 . . . . . . . . . . .  1-2
     PAUSEP . . . . . . . . . . .  4-7, 4-9
     Pen colors . . . . . . . . .  1-3
     Pixel  . . . . . . . . . . .  2-4
     PLOT . . . . . . . . . . . .  3-5, 6-2
       close  . . . . . . . . . .  4-11
       initiate . . . . . . . . .  4-12
       monitor command  . . . . .  2-2, 3-1
         examples . . . . . . . .  3-3
         switches . . . . . . . .  3-2
       open . . . . . . . . . . .  4-12
       subroutine . . . . . . . .  4-8
       terminate  . . . . . . . .  4-11
     PLOT(X,Y,-3) . . . . . . . .  4-9, 4-14

                            Index-ii



     PLOT(X,Y,999)  . . . . . . .  4-11, 6-1
     PLOTS  . . . . . . . . . . .  4-12, 4-20, 6-2
       'DMP4R'  . . . . . . . . .  2-5
       'GIGI' . . . . . . . . . .  2-4
       'SPOOL'  . . . . . . . . .  2-2
       'TEK'  . . . . . . . . . .  2-3
       IPLT=0 . . . . . . . . . .  2-2 to 2-5
     Plotter
       defaults . . . . . . . . .  1-2
       hardware . . . . . . . . .  2-1
     Plotting
       error messages . . . . . .  6-4
       starting . . . . . . . . .  6-1
       stopping . . . . . . . . .  6-1
       warnings . . . . . . . . .  6-4
     Policies . . . . . . . . . .  1-1
       copies . . . . . . . . . .  1-1
       distribution . . . . . . .  1-1
       graphics terminal  . . . .  1-2
       standard plotter defaults   1-2
       window size  . . . . . . .  1-2
     Programming techniques . . .  6-1
       debugging  . . . . . . . .  6-3
       starting plotting  . . . .  6-1
       stopping plotting  . . . .  6-1

     ReGIS  . . . . . . . . . . .  2-1, 4-19 to 4-20
     Resolution
       DMP-4R . . . . . . . . . .  2-5
       GIGI . . . . . . . . . . .  2-4
       Houston Instruments DP-8 .  2-1
       TEKTRONIX  . . . . . . . .  2-3
     RGSPLT . . . . . . . . . . .  2-2, 2-4 to 2-5
     ROTATE . . . . . . . . . . .  3-5, 4-14

     Sample programs  . . . . . .  A-1
     SCALE  . . . . . . . . . . .  4-34
       DELTAV . . . . . . . . . .  4-30, 4-34
       FIRSTV . . . . . . . . . .  4-30, 4-34
     SETSYM . . . . . . . . . . .  4-18, 4-37, 4-39, 6-2, A-3
     Setsym . . . . . . . . . . .  D-1
     SETWIN . . . . . . . . . . .  3-4, 4-14, 4-16
     SITGO  . . . . . . . . . . .  3-1
     Software . . . . . . . . . .  3-1
       3-D routines . . . . . . .  5-6
       contouring routines  . . .  5-1
       coordinate system  . . . .  3-5
       debugging  . . . . . . . .  6-3
       error messages . . . . . .  6-4
       labeling routines  . . . .  4-37
       plotting subroutines . . .  4-1
       symbol sets  . . . . . . .  3-6
       warnings . . . . . . . . .  6-4

                           Index-iii



     Spooling . . . . . . . . . .  2-2
     SPROUT . . . . . . . . . . .  2-2, 4-9
     Standard symbol library  . .  3-6
     Starting plots . . . . . . .  6-1
     Stopping plots . . . . . . .  6-1
     Subroutine
       AXES . . . . . . . . . . .  4-24
       AXIS . . . . . . . . . . .  4-26
       CALCNT . . . . . . . . . .  5-2
       CALSIZ . . . . . . . . . .  5-4
       DASHLN . . . . . . . . . .  4-28
       ERASE  . . . . . . . . . .  4-2
       FACTOR . . . . . . . . . .  4-3
       GRID . . . . . . . . . . .  4-29
       GRIDER . . . . . . . . . .  5-5
       IPLOT  . . . . . . . . . .  4-44
       ISETAB . . . . . . . . . .  4-45
       LINE . . . . . . . . . . .  4-30
       LOGAX  . . . . . . . . . .  4-31
       LOGAXS . . . . . . . . . .  4-33
       MSETAB . . . . . . . . . .  4-45
       NEWPEN . . . . . . . . . .  4-4
       NUMBER . . . . . . . . . .  4-38
       OPRTXT . . . . . . . . . .  4-6
       ORIGIN . . . . . . . . . .  4-5
       PAUSEP . . . . . . . . . .  4-7
       PLOT . . . . . . . . . . .  4-8
       PLOTS  . . . . . . . . . .  4-12
       ROTATE . . . . . . . . . .  4-14
       SCALE  . . . . . . . . . .  4-34
       SETSYM . . . . . . . . . .  4-39
       SETWIN . . . . . . . . . .  4-16
       SUBWIN . . . . . . . . . .  4-17
       SYMBOL . . . . . . . . . .  4-41
       TITLE  . . . . . . . . . .  4-18
       WHERE  . . . . . . . . . .  4-20
       XHAIRS . . . . . . . . . .  4-22
     SUBWIN . . . . . . . . . . .  3-4, 4-17
     SYMBOL . . . . . . . . . . .  4-18, 4-38, 4-41, 6-2, A-3
     Symbol sets  . . . . . . . .  3-6
       available  . . . . . . . .  4-40
       centered symbols . . . . .  4-41
       standard symbol library  .  3-6
     Symbol table routines
       NUMBER . . . . . . . . . .  A-4
       SETSYM . . . . . . . . . .  A-4
       SYMBOL . . . . . . . . . .  A-4
     Symbol tables  . . . . . . .  D-1

     Table-top plotter  . . . . .  2-1
     TEK program  . . . . . . . .  2-3 to 2-4, 3-1, 3-6
     TEKPLT . . . . . . . . . . .  2-2 to 2-3
     TEKTRONIX  . . . . . . . . .  1-2, 2-1, 3-1, 4-4, 4-20

                            Index-iv



     TEKVUE program . . . . . . .  3-6
     TITLE  . . . . . . . . . . .  4-18

     VT125  . . . . . . . . . . .  2-1, 4-19 to 4-20

     Warning messages . . . . . .  6-4
     WHERE  . . . . . . . . . . .  4-20
     Window . . . . . . . . . . .  3-4
       subwindow  . . . . . . . .  3-4
       universal  . . . . . . . .  3-4
     Window size  . . . . . . . .  1-2

     XHAIRS . . . . . . . . . . .  4-22









































                            Index-v
    
