File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

1)1	;
****
2)1		CSM01$==^D400	;Plotter has 3 pens, ON-LINE indicator, 400 SPI
2)		CSM02$==-1	;Compressed plot files
2)		CSM03$==-1	;Red and Black in banner
2)		CSM04$==-1	;Do CSM accounting (minutes and inches used)
2)		CSM05$==-1	;Add SLEEP time to $DSCHD macro for TTY response wait
2)		CSM06$==^D1200	;Support the TAB Products Card Terminal at 1200 baud
2)		CSM07$==-1	;Change some QUEUE defaults
2)		CSM08$==^D2400	;PTC-6 Plotter Terminal Controller at 2400 baud
2)	IF2,<IFN CSM02$,<PRINTX	[CSM02$ uses TOLP.REL]>>
2)	IF2,<IFN CSM06$,<PRINTX	[CSM06$ uses TABCDP.REL]>>
2)	IF2,<IFN CSM08$,<PRINTX	[CSM08$ uses PTC6.REL]>>
2)	REPEAT	0,<	;To completely remove the CSM changes, make this a REPEAT 1
2)		CSM01$==0	;Normal XY-10 plotter
2)		CSM02$==0	;Plot files are 1 byte per increment (very big)
2)		CSM03$==0	;Do not exercise the black and red pens
2)		CSM04$==0	;Account disk reads instead of forms type
2)		CSM05$==0	;No TTY I/O, therefore no sleep requests
2)		CSM06$==0	;Card punch is on I/O bus or front-end 11
2)		CSM07$==0	;Use whatever QUEUE says
2)		CSM08$==0	;Plotter is not connected to a TTY line
2)		DEFINE	CSMEDT($EDIT,$PART),<>	;Dummy macro
2)		CSMED$==0	;No additional edits
2)	>  ;End of REPEAT 0
2)	;
**************
1)1		SEARCH	GLXMAC			;SEARCH GLXLIB SYMBOLS
1)		SEARCH	QSRMAC			;GET QUASAR SYMBOLS
1)		SEARCH	ORNMAC			;GET OPERATOR SYMBOLS
1)		PROLOGUE(SPROUT)		;DO STANDARD PROLOG
1)	;VERSION INFORMATION
1)		SPOVER==4			;MAJOR VERSION NUMBER
1)		SPOMIN==0			;MINOR VERSION NUMBER
1)		SPOEDT==2533			;EDIT LEVEL
1)		SPOWHO==0			;WHO LAST PATCHED
1)		%SPO==<BYTE (3)SPOWHO(9)SPOVER(6)SPOMIN(18)SPOEDT>
1)	;STORE VERSION NUMBER IN JOBVER
1)		LOC	137
1)	.JBVER:: EXP	%SPO			;SPROUT VERSION
1)		RELOC	0
1)	COPYRIGHT (C) DIGITAL EQUIPMENT CORPORATION 1971,1984.
1)2	SUBTTL	Table of contents
1)	;               TABLE OF CONTENTS FOR SPROUT
****
2)1			PAGE
2)		SALL		;Also searches UUOSYM and ACTSYM.UNV
2)		SEARCH	GLXMAC			;SEARCH GLXLIB SYMBOLS
2)		SEARCH	QSRMAC			;GET QUASAR SYMBOLS
2)		SEARCH	ORNMAC			;GET OPERATOR SYMBOLS
2)		PROLOGUE(SPROUT)		;DO STANDARD PROLOG
2)	IFNDEF CSMEDT,<	SEARCH	CSMEDT	>	;CSM edit macro
2)		.XCREF	S1,S2,T1,T2,T3,T4,C,J,P	;[CSM] Save some trees
2)	;VERSION INFORMATION
2)		SPOVER==4			;MAJOR VERSION NUMBER
2)		SPOMIN==0			;MINOR VERSION NUMBER
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-8 3
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)		SPOEDT==2533			;EDIT LEVEL
2)		SPOWHO==2			;Who last patched (JMS @ CSM)
2)		%SPO==<BYTE (3)SPOWHO(9)SPOVER(6)SPOMIN(18)SPOEDT>+CSMED$
2)	;STORE VERSION NUMBER IN JOBVER
2)		LOC	137
2)	.JBVER:: EXP	%SPO			;SPROUT VERSION
2)		RELOC	0
2)	COPYRIGHT (C) DIGITAL EQUIPMENT CORPORATION 1971,1984.
2)2	SUBTTL	Table of Contents
2)	;                  Table of Contents for SPROUT
**************
1)3	SUBTTL	Revision History
****
2)2	;        59.5   File headers . . . . . . . . . . . . . . . . . 114
2)	;        59.6   File trailers  . . . . . . . . . . . . . . . . 115
2)	;        59.7   Trailers . . . . . . . . . . . . . . . . . . . 116
2)	;        59.8   Blank folds  . . . . . . . . . . . . . . . . . 117
2)	;        59.9   Letters  . . . . . . . . . . . . . . . . . . . 118
2)	;        59.10  Byte output  . . . . . . . . . . . . . . . . . 119
2)	;   60. Character Bit Array for 5 X 7 Character Matrix . . . . 120
2)	;   61. Common Utilities . . . . . . . . . . . . . . . . . . . 122
2)	;   62. Interrupt Module . . . . . . . . . . . . . . . . . . . 124
2)	;   63. IPCF and DEVICE Interrupt service for TOPS10 . . . . . 128
2)	;   64. IPCF and DEVICE interrupt service for TOPS20 . . . . . 129
2)3	SUBTTL	Revision History
**************
1)4	SUBTTL	Constants  (Conditional and Unconditional)
****
2)3	PAGE
2)	SUBTTL	CSM Revision History
2)					;
2)	; Edit	  Date	   Who	Description
2)	;======	=========  ===	===========
2)					;
2)	;CSM01$	14-Nov-80  JMS	Plotter has 3 pens and an ON-LINE indicator.  Add
2)	;			routines to change pens and proper positioning after
2)	;			the plot.  Make sure the plotter is on-line at OUTOUT.
2)		CSMEDT	01	;Show value of CSM01$
2)		INCS=<CSM01$>	;400 increments per inch = 620 octal
2)	IFN CSM01$,<ND	CKPTIM,^D60>	;Checkpoint every minute.
2)					;
2)	;CSM02$	14-Nov-80  JMS	Use the compressed plot file format as defined
2)	;			in PLOT.REL (from CSM's FORLIB).  Instead of one
2)	;			byte per increment, most halfwords in the file
2)	;			contains 9-bits of delta-X and 9 of delta-Y.
2)	;			Use TOLP.REL to translate the disk file back
2)	;			into calls to subroutine PLOT.
2)		CSMEDT	02	;Show value of CSM02$
2)	IFN CSM02$,<IFE CSM01$,<PRINTX ?Must have CSM01$ on for CSM02$>>
2)					;
2)	;CSM03$	14-Nov-80  JMS	Change the plot banner to exercise the red and
2)	;			black pens.  Plot error message even if no
2)	;			/TRAILER and set blue pen at P$EOF.
2)		CSMEDT	03	;Show value of CSM03$
2)					;
2)	;CSM04$	25-Mar-81  JMS	Put the forms name in place of DISK-WRITES,
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)	;			amount of paper in PAGES-PRINTED, cards, feet,
2)	;			or plot time in DISK-READS.
2)		CSMEDT	04	;Show value of CSM04$
2)					;
2)	;CSM05$	 8-Jan-81  JMS	Add a sleep request to $DSCHD.  RH of flags is
2)	;			number of seconds to wait.  This is needed for
2)	;			non-blocking TTY I/O routines.
2)		CSMEDT	05	;Show value of CSM05$
2)					;
2)	;CSM06$	 8-Jan-81  JMS	Add support for the TAB Products Card Terminal.
2)	;			It is a Reader/Punch that acts like a TTY.
2)		CSMEDT	06	;Show baud rate (^D1200=^O2260)
2)	IFN CSM06$,<IFE CSM05$,<PRINTX ?Must have CSM05$ on for CSM06$>>
2)					;
2)	;CSM07$	 8-Mar-83  JMS	Remove DSPMOD so that cards are punched in ASCII,
2)	;			paper tape is punched in ASCII, and plots are
2)	;			done in 18-bit BINARY mode unless explicitly
2)	;			requested otherwise.  This is so that output
2)	;			from SOS or SED is not punched in image-binary.
2)	;			Remove "BEGIN:", "JOB", "jobnam", "USER:" from
2)	;			card punch banner, ignore QUEUE's default of
2)	;			/NOHEADER and always punch file header on cards.
2)		CSMEDT	07	;Show value of CSM07$
2)					;
2)	;CSM08$	28-Jun-83  JMS	Add support for the Houston Instruments PTC-6
2)	;			Plotter Terminal Controller on a TTY line.
2)		CSMEDT	08	;Show value of CSM08$
2)	IFN CSM08$,<	EXTERN	PTCINI,PTCMOV,PTCOUT,PTCFIN
2)	IFE CSM05$,<PRINTX ?Must have CSM05$ on for CSM08$>>
2)					;
2)	CSMED$==10	;Increment this to change .JBVER
2)	;End of CSM Revision History
2)4	SUBTTL	Constants  (Conditional and Unconditional)
**************
1)4		XP	PNUP,40			;RAISE PEN
****
2)4	COMMENT ~
2)	  From the OPERATOR's point of view, the supply spool on the plotter is
2)	above the pen holder, and the takeup spool is below the pen holder.
2)	Therefore, to move the pen in the +Y direction, the pen holder moves to
2)	the left.  To move the pen in the +X direction, the pen stays still and
2)	the paper is moved down (towards the takeup spool).  The following
2)	definitions are based on this point of view.
2)	;End of COMMENT ~
2)		XP	PNUP,40			;RAISE PEN
**************
1)4		XP	XYUL,XYL!XYU		;-X+Y MOVE UP+LEFT
1)		XP	XYDL,XYL!XYD		;+X+Y MOVE DOWN+LEFT
1)		XP	XYUR,XYR!XYU		;-X-Y MOVE UP+RIGHT
1)		XP	XYDR,XYR!XYD		;+X-Y MOVE DOWN+RIGHT
1)		XP	PLTPEN,^D9		;# TICS FOR PLOT PEN UP/DOWN
1)		XP	PLTMOV,1		;# TICS FOR PEN MOVEMENT
****
2)4		PLUSX== XYD		;[CSM]	;Move in positive X direction   0
2)		PLUSY== XYL		;[CSM]	;Move in positive Y direction  90
2)		MINUSX==XYU		;[CSM]	;Move in negative X direction 180
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)		MINUSY==XYR		;[CSM]	;Move in negative Y direction 270
2)		XP	XYUL,XYL!XYU		;-X+Y MOVE UP+LEFT
2)		XP	XYDL,XYL!XYD		;+X+Y MOVE DOWN+LEFT
2)		XP	XYUR,XYR!XYU		;-X-Y MOVE UP+RIGHT
2)		XP	XYDR,XYR!XYD		;+X-Y MOVE DOWN+RIGHT
2)		CSMEDT	01,0	;3-pen plotter, definitions
2)	IFE CSM01$,<XP	PLTPEN,^D9>		;# TICS FOR PLOT PEN UP/DOWN
2)	IFN CSM01$,<XP	PLTPEN,^D<1800*30/1000>	;30 millisec compared to 1800 per second
2)		XP	PLTMOV,1		;# TICS FOR PEN MOVEMENT
**************
1)5		SYM==J...X
1)		>  ;END IF2
1)	>  ;END DEFINE LP
1)	DEFINE LPZ(A,B),<
****
2)5		SYM==J...X>;;END IF2>;;END DEFINE LP
2)	;[CSM] Removed 2 CRLFs so that MACRO will show value in listing
2)	DEFINE LPZ(A,B),<
**************
1)7	DEFINE SWITCHES,<
****
2)6	;	PTP NORMAL/BANNER/HEADER/TRAILER
2)	;	PTP BLACK /BANNER/HEADER/TRAILER/NOTE:Black oiled paper tape
2)	PAGE
2)	COMMENT |	CSM interpretation of plotter parameters
2)							;
2)	Example for a drum plotter:
2)							;
2)	PLT NORMAL /SPS:1800/SPU:4/MINIMUM:0:0/MAXIMUM:0:1100 -
2)		   /BANNER/HEADER/TRAILER
2)							;
2)	PLT		= This line applies to the plotter (not CDP or PTP).
2)	NORMAL		= The forms name.
2)	/SPS:1800	= Do accounting based on speed of 1800 steps per second.
2)	/SPU:4		= This plotter uses 400 steps per inch, the following
2)	                  numbers are in 1/100ths of an inch.
2)	/MINIMUM:0:0	= Pen cannot go to left or below the starting point.
2)	/MAXIMUM::1100	= There is no maximum limit in the +X direction, +Y movement
2)			  is limited to 11.00 inches.  The height of characters used
2)			  in the /BANNER/HEADER/TRAILER is 11.00/90 = 0.12 inches.
2)	-		= Hypen indicates a continued line.
2)	/BANNER		= Plot "* Start job XXX" 0.12 inches high, plot user's name
2)			  and PPN 0.36 inches high, and a line across the paper.
2)	/HEADER		= Plot file name 0.12 inches high and a dashed line.
2)	/TRAILER	= Plot a dashed line and the summary 0.12 inches high.
2)	/NOTE		= No note is specified, so that "OPR>START PLOT 0" will
2)			  not require a "RESPOND 'PROCEED' WHEN READY".
2)							;
2)	End of COMMENT |
2)	DEFINE SWITCHES,<
**************
1)7	DEFINE FF(A),<
1)		XLIST
1)		<<SIXBIT /A/>&777777B17>+S$'A
1)		LIST
1)		SALL
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

1)	>
1)	FFNAMS:	SWITCHES
1)		F$NSW==.-FFNAMS			;NUMBER OF SWITCHES
1)8	SUBTTL	Flag Definitions
****
2)6	DEFINE FF(A),<	<<SIXBIT /A/>&777777B17>+S$'A	>;;All on 1 line to look nice
2)		XALL		;[CSM] Show definition in the listing
2)	FFNAMS:	SWITCHES
2)		F$NSW==.-FFNAMS			;NUMBER OF SWITCHES
2)		SALL		;[CSM] Normal macro expansions
2)7	SUBTTL	Flag Definitions
**************
1)10	;PLOTTER VARIABLES
1)		LP	J$PAUS,1		;PAUSE FOR EVERY FORM
1)		LP	J$XPOS,1		;CURRENT PLOTTER X COORDINATE
****
2)8		CSMEDT	05,1	;TTY I/O and SLEEP, part 1 just before PLOTTER VARIABLES
2)	IFN CSM05$,<	;Flags and variables
2)		LP	J$TTY,1			;'CDP' in LH, UDX in RH
2)		LP	J$WUDT,1		;UDT when to wakeup
2)		LP	J$NACK,1		;Count of Negative ACKs
2)	>  ;End of IFN CSM05$
2)9	;PLOTTER VARIABLES
2)	;[CSM]	LP	J$PAUS,1		;PAUSE FOR EVERY FORM
2)		LP	J$XPOS,1		;CURRENT PLOTTER X COORDINATE
**************
1)10	; Paper tape punch variables
****
2)9		CSMEDT	01,1	;3-Pen plotter, part 1 in "PLOTTER VARIABLES"
2)	IFN CSM01$,<	;Flags and variables for plotter
2)		LP	J$PENN,1		;Pen number, from 1 to 3
2)		LP	J$XLOW,1		;Lowest XSTEP seen while pen was down
2)	>  ;End of IFN CSM01$
2)	; Paper tape punch variables
**************
1)11	;NOW GENERATE A BIT TABLE OF WHICH WORDS IN THE JOB DATA PAGE TO ZERO
****
2)10		INTERN	J$$END		;[CSM]	;For .ASSIGNing data areas
2)	;NOW GENERATE A BIT TABLE OF WHICH WORDS IN THE JOB DATA PAGE TO ZERO
**************
1)13		LOWEND==.-1
****
2)12		CSMEDT	05,2	;TTY I/O and SLEEP, part 2 before "LOWEND=="
2)	IFN CSM05$,<
2)	SLEEPT:	BLOCK	1			;Time to sleep
2)	>  ;End of IFN CSM05$
2)		LOWEND==.-1
**************
1)16		MOVE	P,[IOWD PDSIZE,PDL]
****
2)15	IFN CSM02$,<	;Check to see where LINK .ASSIGNed the buffers
2)		SKIPLE	[TOLP..##-1777]		;Make sure data area is only one page
2)		 OUTSTR	[ASCIZ	/?Data area for TOLP extends past 1777/]
2)	>  ;End of IFN CSM02$
2)	IFN CSM06$,<
2)		SKIPLE	[TABC..##-1777]		;Make sure data area is only one page
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)		 OUTSTR	[ASCIZ	/?Data area for TABCDP extends past 1777/]
2)	>  ;End of IFN CSM06$
2)	IFN CSM08$,<
2)		SKIPLE	[PTC6..##-1777]		;Make sure data area is only one page
2)		 OUTSTR	[ASCIZ	/?Data area for PTC6 extends past 1777/]
2)	>  ;End of IFN CSM08$
2)		MOVE	P,[IOWD PDSIZE,PDL]
**************
1)17		SKIPN	JOBSTW(P1)		;IS THE STREAM BLOCKED ???
1)		JRST	MAIN.4			;NO -- SETUP STREAM CONTEXT
1)	MAIN.3:	ANDCAM	P2,JOBSTW(P1)		;CLEAR NEXT PASS BIT
1)		AOBJN	P1,MAIN.2		;TRY NEXT STREAM
1)		TXZE	P2,PSF%NP		;ON SECOND PASS?
1)		 JRST	MAIN.1			;NOT YET..TRY AGAIN
1)	;HERE IF NO STREAM IS RUNNABLE
1)		MOVEI	S1,0			;SNOOZE FOR INTERRUPT
1)		$CALL	I%SLP			;GO WAIT
1)		$CALL	CHKQUE			;PROCESS MESSAGES
1)		JRST	MAIN.1			;AND TRY AGAIN
****
2)16		CSMEDT	05,2	;TTY I/O and SLEEP, part 2 at MAIN.2:+5
2)	IFN CSM05$,<	;Watch for sleep time
2)		PUSHJ	P,CHKTIM		;Time to run this stream?
2)		JUMPF	MAIN.3			;Not yet
2)	>  ;End of IFN CSM05$
2)		SKIPN	JOBSTW(P1)		;IS THE STREAM BLOCKED?
2)		JRST	MAIN.4			;NO -- SETUP STREAM CONTEXT
2)	MAIN.3:	ANDCAM	P2,JOBSTW(P1)		;CLEAR NEXT PASS BIT
2)		AOBJN	P1,MAIN.2		;TRY NEXT STREAM
2)		TXZE	P2,PSF%NP		;ON SECOND PASS?
2)		 JRST	MAIN.1			;NOT YET..TRY AGAIN
2)	;HERE IF NO STREAM IS RUNNABLE
2)	IFE CSM05$,< MOVEI  S1,0	>	;SNOOZE FOR INTERRUPT
2)	IFN CSM05$,< MOVE  S1,SLEEPT	>	;Get sleep time in seconds
2)		$CALL	I%SLP			;GO WAIT
2)		$CALL	CHKQUE			;PROCESS MESSAGES
2)	IFN CSM05$,< SETZM  SLEEPT	>	;Clear timer request
2)		JRST	MAIN.1			;AND TRY AGAIN
**************
1)18		MOVE	S1,@0(S1)		;GET THE FLAGS
1)		HRRZ	S2,STREAM		;GET STREAM NUMBER
1)		IORM	S1,JOBSTW(S2)		;SET THE FLAGS
1)		JRST	MAIN			;AND GO LOOP
1)19	SUBTTL	Do the Job
****
2)17		CSMEDT	05,2	;TTY I/O and SLEEP, part 2 at DSCHD:+6
2)	IFE CSM05$,< MOVE  S1,@0(S1) >		;GET THE FLAGS
2)	IFN CSM05$,<
2)		HRRZ	T1,@0(S1)		;Get the seconds to sleep
2)		HLLZ	S1,@0(S1)		;Get the flags
2)	>  ;End of IFN CSM05$
2)		HRRZ	S2,STREAM		;GET STREAM NUMBER
2)		IORM	S1,JOBSTW(S2)		;SET THE FLAGS
2)	IFE CSM05$,< JRST  MAIN >		;AND GO LOOP
2)	IFN CSM05$,<	;This code taken from LPTSPL
2)		JUMPE	T1,MAIN			;Loop if no sleep time
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)	CONT. (SCHEDULER)
2)		SKIPE	SLEEPT			;Is a sleep time set?
2)		CAMG	T1,SLEEPT		;And current amount smaller?
2)		 MOVEM	T1,SLEEPT		;Yes, save shorter interval
2)		$CALL	I%NOW			;Get the current time
2)		IMULI	T1,3			;Seconds to UDT ticks
2)		ADD	T1,S1			;Build wake-up time
2)		MOVEM	T1,J$WUDT(J)		;Save for CHKTIM
2)		JRST	MAIN			;Loop
2)	SUBTTL	CHKTIM - Routine to see if it's time to schedule a stream
2)	;CALL:	J/  Pointer to job page
2)	;
2)	;REG:	TRUE if stream can be scheduled now (timewise)
2)	;	FALSE if stream needs to wait
2)	CHKTIM:	$CALL	I%NOW			;Get the current time
2)		MOVE	S2,S1			;Get the UDT in S2
2)		MOVE	S1,J$WUDT(J)		;Get the stream wakeup time
2)		SUB	S1,S2			;Get time left in UDT ticks
2)		IDIVI	S1,3			;Convert to seconds
2)		SKIPG	S1			;Any seconds left?
2)		 JRST	[SETZM	SLEEPT		  ;No, clear old sleep time
2)			 $RETT		]	  ;Return TRUE
2)		SKIPE	SLEEPT			;Is a sleep time set?
2)		CAMG	S1,SLEEPT		;And current amount smaller?
2)		 MOVEM	S1,SLEEPT		;Yes, save the shorter interval
2)		$RETF				;Return FALSE
2)	;End of code taken from LPTSPL>  ;End of IFN CSM05$
2)18	SUBTTL	Do the Job
**************
1)21	TOPS10 <
1)		$CALL	OUTWAT			;OUTPUT AND WAIT UNTIL DONE
1)	> ;;END TOPS10
1)	TOPS20 <
1)		$CALL	OUTOUT			;FORCE EVERYTHING OUT
1)	> ;;END TOPS20
1)		HRRZ	S1,STREAM		;POINT TO CURRENT STREAM
1)		$WTOJ	(End,^R/.EQJBB(J)/,@JOBOBA(S1))
1)		$CALL	QRELEASE		;RELEASE THE JOB
1)		$CALL	ACTEND			;DO FINAL ACCOUNTING
1)		HRRZ	S1,STREAM		;GET STREAM NUMBER
1)		SETZM	JOBACT(S1)		;NOT BUSY
1)	TOPS20 <
1)		PUSHJ	P,OUTOUT		;FORCE OUTPUT
1)	> ;;END TOPS20
1)		JRST	MAIN			;AND LOOP TO THE BEGINNING
****
2)20	TOPS10<	$CALL	OUTWAT	>		;OUTPUT AND WAIT UNTIL DONE
2)	TOPS20<	$CALL	OUTOUT	>		;FORCE EVERYTHING OUT
2)		HRRZ	S1,STREAM		;POINT TO CURRENT STREAM
2)		$WTOJ	(End,^R/.EQJBB(J)/,@JOBOBA(S1))
2)		$CALL	QRELEASE		;RELEASE THE JOB
2)		$CALL	ACTEND			;DO FINAL ACCOUNTING
2)		HRRZ	S1,STREAM		;GET STREAM NUMBER
2)		SETZM	JOBACT(S1)		;NOT BUSY
2)	TOPS20<	$CALL	OUTOUT	>		;FORCE OUTPUT
2)		JRST	MAIN			;AND LOOP TO THE BEGINNING
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

**************
1)30	SETU.2:	HRRZM	T2,STREAM		;SAVE THE STREAM NUMBER
1)		$CALL	I%NOW			;USE SETUP TIME AS ACK STAMP
1)		MOVEM	S1,JOBWAC(T2)		;SAVE CODE FOR $WTOR
****
2)30	;[CSM] There is a problem if two streams start with 1/3 of a second
2)	SETU.2:	HRRZM	T2,STREAM		;SAVE THE STREAM NUMBER
2)		$CALL	I%NOW			;USE SETUP TIME AS ACK STAMP
2)		LSH	S1,3		;[CSM]	;Free up 3 bits
2)		IOR	S1,T2		;[CSM]	;Make it be unique
2)		MOVEM	S1,JOBWAC(T2)		;SAVE CODE FOR $WTOR
**************
1)36	FRMLEX:	GETLIM	S1,.EQLIM(J),FLEA	;GET FORMS-LIMIT-EXCEED ACTION
****
2)36	SUBTTL	FRMLEX - Forms limit exceeded routine
2)	FRMLEX:	GETLIM	S1,.EQLIM(J),FLEA	;GET FORMS-LIMIT-EXCEED ACTION
**************
1)38	FACT<	HRLZM	T1,FACTBL+3 >		;STORE NODE NUMBER NOW
****
2)38	CONT. (ACTEND)
2)	FACT<	HRLZM	T1,FACTBL+3 >		;STORE NODE NUMBER NOW
**************
1)38		SETZM	FACTBL+7		;NO DISK WRITES
1)		MOVE	S1,J$LDEV(J)		;DEVICE NAME
****
2)38		CSMEDT	04,1	;CSM accounting, part 1 after QUEUE. uuo
2)	IFE CSM04$,< SETZM FACTBL+7 >		;No disk writes
2)	IFN CSM04$,<
2)		MOVE	S1,J$FORM(J)		;Get the forms type
2)		MOVEM	S1,FACTBL+7		;Instead of disk writes
2)	>  ;End of CSM04$
2)	CONT. (ACTEND)
2)		MOVE	S1,J$LDEV(J)		;DEVICE NAME
**************
1)40		$TEXT	(DEPBP,<Type 'RESPOND ^7/[.CHLAB]/number^7/[.CHRAB]/ PROCEED' when ready^0>)
****
2)40	IFN CSM02$,< FORM.3:	>	;PUSHJ to here to wait for 'PROCEED' in OPRTXT
2)		$TEXT	(DEPBP,<Type 'RESPOND ^7/[.CHLAB]/number^7/[.CHRAB]/ PROCEED' when ready^0>)
**************
1)45		MOVEM	T1,J$XMAX(J)		;STORE X MAXIMUM
1)		CAIE	C,":"			;IS Y ARGUMENT SPECIFIED?
1)		$RETT				;NO -- RETURN
1)		$CALL	FH$DEC			;GET DECIMAL INTEGER
1)		MOVEM	T1,J$YMAX(J)		;STORE Y MAXIMUM
****
2)45		SKIPE	T1		;[CSM]	;If not zero,
2)		MOVEM	T1,J$XMAX(J)		;STORE X MAXIMUM
2)		CAIE	C,":"			;IS Y ARGUMENT SPECIFIED?
2)		$RETT				;NO -- RETURN
2)		$CALL	FH$DEC			;GET DECIMAL INTEGER
2)		SKIPE	T1		;[CSM]	;If not zero,
2)		MOVEM	T1,J$YMAX(J)		;STORE Y MAXIMUM
**************
1)47		IMULI	T1,12			;SHIFT A PLACE
1)		ADDI	T1,-"0"(C)		;ADD IN A DIGIT
****
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)47		IMULI	T1,^D10		;[CSM]	;Shift one decimal place
2)		ADDI	T1,-"0"(C)		;ADD IN A DIGIT
**************
1)50						;IMAGE+PHONLY+NBIO
1)		MOVE	T2,J$LDEV(J)		;OUTPUT DEVICE NAME
****
2)50		CSMEDT	05,3	;TTY I/O and SLEEP, part 3 after DEVNAM in OUTGET
2)	IFN CSM05$,<	;Check for devices connected to TTY lines
2)		HLRZ	T2,J$LDEV(J)		;Get first part of physical name
2)		CAIE	T2,'TTY'		;Is it a terminal?
2)		 JRST	CSM05Z			;No
2)		MOVE	S2,J$LSER(J)		;Get service routine
2)		MOVE	S1,DNAME(S2)		;Get 'PLT' or 'CDP'
2)		MOVEM	S1,J$TTY(J)		;Put in LH
2)		MOVE	T2,J$LDEV(J)		;Get device again
2)		IONDX.	T2,			;Get UDX
2)		  SETZB	T2,J$TTY(J)		;Should never happen
2)		HRRM	T2,J$TTY(J)		;Store TTY UDX in RH
2)	CONT.	(OUTGET)		;FORCE NEW LISTING PAGE
2)	;Disable free CRLFs every 80 characters and SET TTY NO GAG
2)		MOVX	T1,.TONFC+.TOSET	;Change setting to
2)		MOVEI	T3,1			; no free CRLFs
2)		MOVE	S1,[3,,T1]
2)		TRMOP.	S1,			;SET TTY NO CRLF
2)		  JFCL
2)	;*BUG*;	MOVX	T1,.IOPIM+UU.PHS	;Packed image mode (no echo)
2)		MOVX	T1,.IOIMG+UU.PHS+IO.SUP	;Image mode, no echo
2)		HLRZ	S1,J$TTY(J)		;Get device type
2)		CAIN	S1,'PLT'		;Output to plotter?
2)		 MOVX	T1,.IOASC+UU.PHS+IO.SUP	;ASCII mode, no echo
2)	CSM05Z:	>  ;End of IFN CSM05$
2)		MOVE	T2,J$LDEV(J)		;OUTPUT DEVICE NAME
**************
1)50		CONT.	(OUTGET)		;FORCE NEW LISTING PAGE
1)		MOVE	S1,J$LSER(J)		;GET DEVICE DISPATCH ADDRESS
1)		MOVE	S1,DBYTE(S1)		;GET OUTPUT BYTE SIZE
1)		STORE	S1,J$LBRH+1(J),BP.SIZ	;STORE IT
****
2)50		MOVE	S1,J$LSER(J)		;GET DEVICE DISPATCH ADDRESS
2)		MOVE	S1,DBYTE(S1)		;GET OUTPUT BYTE SIZE
2)	IFN CSM05$,<	;Cannot use 6 bits to PTC-6
2)		HLRZ	S2,J$TTY(J)		;Nonzero if TTY as output device
2)		CAIN	S2,'PLT'		;Going to the plotter?
2)		 MOVEI	S1,7			;Yes, use normal ASCII mode
2)	;SET TTY NO GAG after it has been inited
2)		MOVX	T1,.TOSND+.TOSET	;Change setting to
2)		HRRZ	T2,J$TTY(J)
2)		MOVEI	T3,0			; no SENDs allowed
2)		MOVE	S2,[3,,T1]
2)		SKIPE	T2			;Don't TRMOP. if not a TTY
2)		 TRMOP.	S2,			;SET TTY GAG
2)		  JFCL
2)	>  ;End of IFN CSM05$
2)		STORE	S1,J$LBRH+1(J),BP.SIZ	;STORE IT
**************
1)54	OUTO.1:	MOVE	S1,STREAM		;Get our stream number
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

****
2)54		CSMEDT	01,2	;3-Pen plotter, part 2 at OUTOUT:+1 <TOPS10>
2)	IFN CSM01$,<	;The plotter does not interrupt for off-line or on-line
2)		SKIPE	J$FPLT(J)		;Is this going to the plotter?
2)		 PUSHJ	P,PLTCHK		;Yes, check if it is on-line
2)	>  ;End of CSM01$
2)	OUTO.1:	MOVE	S1,STREAM		;Get our stream number
**************
1)54	>  ;END TOPS10 CONDITIONAL
1)	TOPS20 <
****
2)54	CONT. (OUTOUT)
2)	IFN CSM01$,<	;After OUTWAT: inside TOPS10<>
2)	;Ask the monitor to do a CONI to check if PLT is on-line
2)		OPDEF	STSPL.	[CALLI	-4]	;CSM UUO to do <CONI PLT,T1>
2)		PLT.ON==1B30			;The plotter power is on
2)	PLTCHK:	CSMEDT	08,1	;PTC-6 Plotter Controller, part 1 inside CSM01$
2)	IFN CSM08$,<
2)		SKIPE	J$TTY(J)		;Output going to a TTY?
2)		 POPJ	P,			;Yes, cannot determine on-line status
2)	>  ;End of IFN CSM08$
2)		STSPL.	S1,			;Get current status of plotter
2)		TXNE	S1,PLT.ON		;Is the POWER-ON bit set?
2)		 JRST	PLTONL			;Yes, plotter is on-line now
2)		AOS	S1,J$NACK(J)		;Increment NACK count
2)		IDIVI	S1,^D30			;Set S2 modulo 30
2)		JUMPN	S2,PLTCH1		;Complain every 30 seconds
2)		HRRZ	S1,STREAM		;Get stream number
2)		SETOM	JOBCHK(S1)		;Request checkpoint
2)		$WTO	(Off-line,,@JOBOBA(S1))
2)	PLTCH1:	CSMEDT	05,4	;TTY I/O and SLEEP, part 4 after PLTCHK:
2)	IFN CSM05$,< $DSCHD  (1) >		;De-schedule for 1 second
2)	IFE CSM05$,< MOVEI   S1,1		;Wait 1 second
2)		     SLEEP   S1, >		; before continuing
2)		JRST	PLTCHK			;Check if it is on-line now
2)	PLTONL:	SETOM	J$NACK(J)		;Plotter is on-line now
2)		$RETT				;OK to do the OUT UUO
2)	>  ;End of IFN CSM01$
2)	>  ;END TOPS10 CONDITIONAL
2)		CONT.	(OUTOUT)
2)	TOPS20 <
**************
1)59	SUBTTL	Card punch service -- Dispatch table
****
2)59	SUBTTL	TTY I/O -- Input character from TTY, no wait
2)		CSMEDT	05,5	;TTY I/O and SLEEP, part 5 between OUTFLS and C$DISP
2)	IFN CSM05$,<	INTERN	TIWAIT,TTYIN,TRMERR	;Entry points for TABCDP.MAC
2)	;Routine to input a single character from terminal into S1.
2)	;Uses T1 and T2.
2)	TTYIN::	MOVX	T1,.TOSIP		;Skip if input in progress
2)		HRRZ	T2,J$TTY(J)		;Get UDX
2)		MOVE	S1,[2,,T1]		;Point to args
2)		TRMOP.	S1,			;Check if input
2)		  JRST	TTYIN1			;Nothing there
2)		MOVX	T1,.TOISC		;Input single character
2)		MOVE	S1,[2,,T1]		;Point to args
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)		TRMOP.	S1,			;Get the char
2)		  PUSHJ	P,TRMERR		;Should never happen
2)		$RETT				;Got char in S1
2)	TTYIN1:	MOVEI	S1,0			;Signify failure
2)		$RETF
2)	TRMERR::$STOP	(TUF,TRMOP. UUO Failure)
2)60	SUBTTL	TTY I/O -- Input character, wait up to 30 seconds
2)	;Routine to wait up to 30 seconds for a character to come in.
2)	;Returns TRUE if char in S1, FALSE and zero in S1 if timed out
2)	TIWAIT::PUSHJ	P,TTYIN			;Check for input
2)		JUMPT	TIWAI2			;Clear NACK counter if got input
2)	;There is a good possibility that the response will come in within 1 second
2)		MOVX	S1,HB.RTC+^D1000	;Wait 1 second, wake on char ready
2)		HIBER	S1,
2)		  JFCL
2)		PUSHJ	P,TTYIN			;Anything now?
2)		JUMPT	TIWAI2			;Return if so
2)		AOS	J$NACK(J)		;No, waited 1 second already
2)	TIWAT1:	$DSCHD	(1)			;De-schedule this stream for 1 second
2)		PUSHJ	P,TTYIN			;Input now?
2)		JUMPT	TIWAI2			;Yes, continue
2)		AOSG	S1,J$NACK(J)		;No, count failure
2)		 JRST	TIWAT1			;Keep waiting if negative or zero
2)		IDIVI	S1,^D30			;Set S2 modulo 30
2)		JUMPN	S2,TIWAT1		;If less than 30 seconds, wait again
2)		HRRZ	S1,STREAM		;Get stream number
2)		$WTO	(<No response from ^W/J$LDEV(J)/ after ^D/J$NACK(J)/ seconds>,,@JOBOBA(S1))
2)		MOVEI	S1,0			;Signify no response
2)		$RETF
2)	TIWAI2:	SETZM	J$NACK(J)		;Terminal is responding
2)		POPJ	P,			;TF has been set to TRUE already
2)	>  ;End of IFN CSM05$
2)61	SUBTTL	Card punch service -- Dispatch table
**************
1)59		JRST	.RETT			;(11) ACCOUNTING
1)		JRST	C$CHKP			;(12) CHECKPOINT TEXT GENERATION
1)60	SUBTTL	Card punch service -- Checkpoint text generation
****
2)61		CSMEDT	04,2	;CSM accounting, part 2 at C$DISP:+11
2)	IFE CSM04$,< JRST  .RETT >		;(11) ACCOUNTING
2)	IFN CSM04$,< JRST  CSMACT >		;(11) Accounting
2)		JRST	C$CHKP			;(12) CHECKPOINT TEXT GENERATION
2)	IFN CSM04$,<
2)	CSMACT:	MOVE	S1,J$APRT(J)		;Get cards punched or feet punched
2)		MOVEM	S1,J$ADRD(J)		;Save instead of disk reads
2)		$RETT
2)	>  ;End of IFN CSM04$
2)62	SUBTTL	Card punch service -- Checkpoint text generation
**************
1)61		MOVEI	S1,C$MTAB		;GET ADDRESS OF MODE TABLE
1)		MOVEI	S2,C$ROUT		;GET ADDRESS OF ROUTINE TABLE
1)		PJRST	DSPMOD			;AND DISPATCH BASED ON MODE
1)	;TABLE OF processing ROUTINES
****
2)63		CSMEDT	07,1	;QUEUE defaults, part 1 at C$PROC:+4
2)	IFE CSM07$,<
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)		MOVEI	S1,C$MTAB		;GET ADDRESS OF MODE TABLE
2)		MOVEI	S2,C$ROUT		;GET ADDRESS OF ROUTINE TABLE
2)		PJRST	DSPMOD			;AND DISPATCH BASED ON MODE
2)	>  ;End of CSM07$
2)	IFN CSM07$,<JRST CDASC>			;Default to ASCII mode
2)	;TABLE OF processing ROUTINES
**************
1)67		LOAD	S1,.FPINF(E),FP.NFH	;GET NO FILE HEADER BIT
1)		JUMPN	S1,.RETT		;RETURN IF NOT WANTED
1)		MOVEI	C,4001			;SPECIAL MASK FOR FILE CARDS
****
2)69		CSMEDT	07,2	;QUEUE defaults, part 2 at C$HEAD:+2
2)	IFE CSM07$,<	;Ignore QUEUE's default of /NOHEADER, always punch it
2)		LOAD	S1,.FPINF(E),FP.NFH	;GET NO FILE HEADER BIT
2)		JUMPN	S1,.RETT		;RETURN IF NOT WANTED
2)	>  ;End of IFN CSM07$
2)		MOVEI	C,4001			;SPECIAL MASK FOR FILE CARDS
**************
1)68		PJRST	OUTOUT			;FORCE OUTPUT
1)69	SUBTTL	Card punch service -- Banners
1)	C$BANN:	SKIPN	J$FBAN(J)		;GET COUNT OF BANNER CARDS
1)		$RETT				;RETURN IF ZERO
1)		MOVEI	C,4003			;MASK FOR JOB CARDS
1)		MOVEM	C,J$CMSK(J)		;SAVE FOR C$LETR
1)		MOVEI	S1,[ITEXT<BEGIN:>]
1)		PJRST	CTRA.1			;FALL INTO COMMON CODE
1)	C$TRAI:	SKIPN	J$FTRA(J)		;GET TRAILER COUNT
1)		$RETT				;RETURN IF ZERO
1)		MOVEI	C,4003			;MASK FOR JOB CARDS
****
2)70	;[CSM]	PJRST	OUTOUT			;FORCE OUTPUT
2)		PJRST	OUTCD1		;[CSM]	;FORCE OUTPUT
2)71	SUBTTL	Card punch service -- Banners
2)	C$BANN:	CSMEDT	06,1	;TTY CDP, part 1 at C$BANN:
2)	IFN CSM06$,<	;Set terminal to PUNCH+PRINT mode if /FORMS:NORMAL
2)		MOVEI	S1,J$FORM(J)		;Get forms name
2)		CAMN	S1,['NORMAL']		;Normal forms?
2)		 MOVEI	S1,0			;Yes, turn on print mode
2)		SKIPE	S2,J$TTY(J)		;Punch really a terminal?
2)		 PUSHJ	P,TABINI##		;Yes, set it up
2)	>  ;End of IFN CSM06$
2)		SKIPN	J$FBAN(J)		;BANNER cards wanted?
2)		$RETT				;RETURN IF ZERO
2)		MOVEI	C,4003			;MASK FOR JOB CARDS
2)		MOVEM	C,J$CMSK(J)		;SAVE FOR C$LETR
2)		CSMEDT	07,3	;QUEUE defaults, part 3 at C$BANN:+4
2)	IFE CSM07$,<	;"BEGIN: JOB jobnam USER:" wastes 4 cards.
2)		MOVEI	S1,[ITEXT<BEGIN:>]
2)		PJRST	CTRA.1			;FALL INTO COMMON CODE
2)	>  ;End of IFE CSM07$
2)	IFN CSM07$,<	;Punch just NAME, PPN, and NOTE (if any)
2)		PJRST	CTRA.2			;Punch user name
2)	>  ;End of IFN CSM07$
2)	IFE CSM06$,<
2)	C$TRAI:	SKIPN	J$FTRA(J)		;Check TRAILER wanted flag
2)		$RETT				;RETURN IF ZERO
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)	>  ;End of IFE CSM06$
2)	IFN CSM06$,<	;Call TABFIN after all is done
2)	C$TRAI:	SKIPE	J$FTRA(J)		;Trailer cards wanted?
2)		 $CALL	CTRA.0			;Yes
2)		SKIPE	J$TTY(J)		;Output to a TTY?
2)		 PUSHJ	P,TABFIN##		;Yes, finish up
2)		$RETT
2)	CTRA.0:	>  ;End of IFN CSM06$
2)		MOVEI	C,4003			;MASK FOR JOB CARDS
**************
1)69	TOPS10	<				;TOPS-10 ONLY
****
2)71		CONT.	(C$BANN)
2)	IFN CSM07$,< CTRA.2: >			;Here to skip over garbage
2)	TOPS10	<				;TOPS-10 ONLY
**************
1)70		PJRST	OUTOUT			;PUNCH CARD AND RETURN
1)71	SUBTTL	Card punch service -- Letters
****
2)72	;[CSM]	PJRST	OUTOUT			;PUNCH CARD AND RETURN
2)		PJRST	OUTCD1		;[CSM]	;PUNCH CARD AND RETURN
2)73	SUBTTL	Card punch service -- Letters
**************
1)72	CDPBYT:	PJRST	OUTBYT			;OUTPUT THE BYTE
1)	; Force card out
1)	;
1)	OUTCDP:	PUSHJ	P,OUTOUT		;FORCE CARD OUT
1)		AOS	S1,J$APRT(J)		;COUNT ANOTHER ONE
1)		CAMLE	S1,J$RLIM(J)		;OVER LIMIT?
1)		PUSHJ	P,FRMLEX		;HANDLE LIMIT EXCEEDED
1)		POPJ	P,			;RETURN
1)	; Repeat the byte in AC 'C'
1)	; Call:	MOVE	S1,repeat count
1)	;	MOVE	C,byte to output
1)	;	PUSHJ	P,CDPREP
1)	;
1)	CDPREP:	PUSH	P,P1			;SAVE P1
1)		MOVE	P1,S1			;GET COUNT
1)		PUSHJ	P,PTPBYT		;OUTPUT A BYTE
1)		SOJG	P1,.-1			;AND LOOP
****
2)74	CDPBYT:	CSMEDT	06,2	;TTY CDP, part 2 at CDPBYT
2)	IFE CSM06$,< PJRST  OUTBYT >
2)	IFN CSM06$,<	;Special output for TAB Products Cardpunch Terminal
2)		SKIPN	J$TTY(J)		;Output to a TTY?
2)		 PJRST	OUTBYT			;No
2)		$SAVE	<S1,S2>			;Yes, preserve ACs used
2)		MOVE	S1,C			;Copy to expected AC
2)		PJRST	TABBYT##		;Store byte in other buffer
2)	>  ;End of IFN CSM06$
2)	; Force card out
2)	;
2)	OUTCDP:	AOS	S1,J$APRT(J)		;COUNT ANOTHER ONE
2)		CAMLE	S1,J$RLIM(J)		;OVER LIMIT?
2)		PUSHJ	P,FRMLEX		;HANDLE LIMIT EXCEEDED
2)	OUTCD1:					;Output without counting
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)	IFN CSM06$,<	;Special output for TAB Products Cardpunch Terminal
2)		SKIPE	J$TTY(J)		;Output to a TTY?
2)		 PJRST	TABPUN##		;Yes, output the card
2)	>  ;End of IFN CSM06$
2)		PJRST	OUTOUT			;FORCE CARD OUT
2)	; Repeat the byte in AC 'C'
2)	; Call:	MOVE	S1,repeat count
2)	;	MOVE	C,byte to output
2)	;	PUSHJ	P,CDPREP
2)	;
2)	CDPREP:	PUSH	P,P1			;SAVE P1
2)		MOVE	P1,S1			;GET COUNT
2)	;[CSM]	PUSHJ	P,PTPBYT		;OUTPUT A BYTE
2)		PUSHJ	P,CDPBYT	;[CSM]	;Use the right output routine
2)		SOJG	P1,.-1			;AND LOOP
**************
1)73		JRST	.RETT			;(11) ACCOUNTING
1)		JRST	P$CHKP			;(12) CHECKPOINT TEXT GENERATION
1)74	SUBTTL	Plotter service -- Checkpoint text generation
1)	P$CHKP:	$SAVE	<P1,P2,P3>		;SAVE SOME ACS
1)		MOVE	P1,J$PTIC(J)		;GET # TICS FOR JOB
1)		IDIV	P1,J$PTPM(J)		;T1:= MINUTES, T2:= FRACTION
1)		IMULI	P2,^D1000		;MAKE IT DECIMAL
1)		IDIV	P2,J$PTPM(J)		;T2:= DECIMAL FRACTION OF A MINUTE
1)		MOVE	P3,J$RLIM(J)		;GET LIMIT
1)		CAMN	P3,[.INFIN]		;+INFINITY ?
1)		JRST	P$CHK1			;YES
1)		CAMG	P1,J$RLIM(J)		;OPERATOR ALLOW LIMIT TO EXCEED ?
1)		$TEXT	(DEPBP,<plotted ^D/P1/.^D3L0/P2/ of ^D/J$RLIM(J)/ minutes^0>)
1)		CAMLE	P1,J$RLIM(J)		;OPERATOR ALLOW LIMIT TO EXCEED ?
1)	P$CHK1:	$TEXT	(DEPBP,<plotted ^D/P1/.^D3L0/P2/ minutes (limit exceeded)^0>)
1)		POPJ	P,			;RETURN
1)75	SUBTTL	Plotter service -- File processing
1)	P$PROC:	LOAD	S1,.FPINF(E),FP.FPF	;GET PAPER FORMAT
1)		CAILE	S1,PLROUL		;WITHIN RANGE?
1)		JRST	BADMOD			;NO, LOSE
1)		JUMPN	S1,@P$ROUT-1(S1)	;YES, DISPATCH IF NON-ZERO
1)		MOVEI	S1,P$MTAB		;GET ADDRESS OF MODE TABLE
1)		MOVEI	S2,P$ROUT		;GET ADDRESS OF ROUTINE TABLE
1)		PJRST	DSPMOD			;AND DISPATCH BASED ON MODE
1)	P$ROUT:	EXP	PLTSIX			;/PLOT:IMAGE	(6 BIT)
1)		EXP	PLTSVN			;/PLOT:ASCII	(7 BIT)
1)		EXP	PLTSIX			;/PLOT:BINARY	(6 BIT)
1)		PLROUL==.-P$ROUT		;LENGTH OF ROUTINE TABLE
****
2)75		CSMEDT	04,3	;CSM accounting, part 3 at P$DISP:+11
2)	IFE CSM04$,<JRST .RETT>			;(11) ACCOUNTING
2)	IFN CSM04$,<JRST PLTACT>		;(11) Plotter accounting
2)		JRST	P$CHKP			;(12) CHECKPOINT TEXT GENERATION
2)	IFN CSM04$,<	;Account for both elapsed time and paper used
2)	PLTACT:	MOVE	S1,J$XLIM(J)		;Get total X increments
2)		ADDI	S1,INCS/2		;Round up
2)		IDIVI	S1,INCS			;Convert to inches
2)		EXCH	S1,J$APRT(J)		;Store amount of paper used
2)		MOVEM	S1,J$ADRD(J)		;Store minutes in place of disk reads
2)		$RETT
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)	>  ;End of IFN CSM04$
2)76	SUBTTL	Plotter service -- Checkpoint text generation
2)	P$CHKP:	$SAVE	<P1,P2,P3>		;SAVE SOME ACS
2)		MOVE	P1,J$PTIC(J)		;GET # TICS FOR JOB
2)		IDIV	P1,J$PTPM(J)		;P1:= MINUTES, P2:= FRACTION
2)		IMULI	P2,^D10			;[CSM] One decimal place
2)		IDIV	P2,J$PTPM(J)		;P2:= DECIMAL FRACTION OF A MINUTE
2)		MOVE	P3,J$RLIM(J)		;GET LIMIT
2)		CAMN	P3,[.INFIN]		;+INFINITY?
2)		JRST	P$CHK1			;YES
2)		CAMG	P1,J$RLIM(J)		;OPERATOR ALLOW LIMIT TO EXCEED?
2)		$TEXT	(DEPBP,<plotted ^D/P1/.^D/P2/ of ^D/J$RLIM(J)/ minutes^0>)
2)		CAMLE	P1,J$RLIM(J)		;OPERATOR ALLOW LIMIT TO EXCEED?
2)	P$CHK1:	$TEXT	(DEPBP,<plotted ^D/P1/.^D/P2/ minutes (limit exceeded)^0>)
2)		POPJ	P,			;RETURN
2)77	SUBTTL	Plotter service -- File processing
2)	P$PROC:	LOAD	S1,.FPINF(E),FP.FPF	;GET PAPER FORMAT
2)		CAILE	S1,PLROUL		;WITHIN RANGE?
2)		JRST	BADMOD			;NO, LOSE
2)		JUMPN	S1,@P$ROUT-1(S1)	;YES, DISPATCH IF NON-ZERO
2)		CSMEDT	07,4	;QUEUE defaults, part 4 at P$PROC:+4
2)	IFE CSM07$,<	;This code removed because all plots must be BINARY halfwords
2)		MOVEI	S1,P$MTAB		;GET ADDRESS OF MODE TABLE
2)		MOVEI	S2,P$ROUT		;GET ADDRESS OF ROUTINE TABLE
2)		PJRST	DSPMOD			;AND DISPATCH BASED ON MODE
2)	>  ;End of IFE CSM07$
2)	IFN CSM07$,< JRST  PLTHLF >		;Default always to halfword format
2)	P$ROUT:	EXP	PLTSIX			;/PLOT:IMAGE	(6 BIT)
2)		EXP	PLTSVN			;/PLOT:ASCII	(7 BIT)
2)		CSMEDT	02,1	;Halfword format, part 1 at P$ROUT:+3
2)	IFE CSM02$,<EXP	PLTSIX>			;/PLOT:BINARY	(6 BIT)
2)	IFN CSM02$,<EXP	PLTHLF>			;/PLOT:BINARY	(18 bit)
2)		PLROUL==.-P$ROUT		;LENGTH OF ROUTINE TABLE
**************
1)76	PLTLP0:	MOVE	T1,J$PTIC(J)		;GET TICS PLOTTED
****
2)78	;Here at end of plot file
2)	PLTLP0:	MOVE	T1,J$PTIC(J)		;GET TICS PLOTTED
**************
1)77	SUBTTL	Plotter service -- Devout output errors
1)	; *** Note ***
****
2)79	SUBTTL	Plotter service -- Expand CSM's compressed plot format
2)		CSMEDT	02,2	;Halfword format, part 2 after PLTLP0:
2)	IFN CSM02$,<				;Read halfwords from disk
2)	COMMENT ~ Do not use many semicolons, it confuses FILCOM's /C switch
2)		!=======================================================!
2)		!                                                       !
2)		!                PLOTTER MODE  --  18 BIT               !
2)		!                                                       !
2)		! In 18 bit mode, each word read from disk is divided   !
2)		! into halfwords, which are interpreted by subroutine   !
2)		! TOLP.  Most halfwords have 9 bits of delta-X and      !
2)		! 9 bits of delta-Y, special opcodes raise and lower    !
2)		! the pen.  See TOLP.MAC for a full description.        !
2)		!                                                       !
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)		!=======================================================!
2)		!   Delta Y   !   Delta X   !   Delta Y   !   Delta X   !
2)		!=======================================================!
2)	Call TOLP. with
2)	 S1/ Addr of input routine, which returns data in S1, -1 on EOF
2)	 S2/ 0 to suppress header/trailer, 1 for header, 2 for trailer, 3 for both
2)	 T1/ Current X position (should be same as J$XMIN)
2)	 T2/ Current Y position (should be same as J$YMIN)
2)	On return, ACs 7-16 have been preserved
2)	 TF/ Garbage
2)	 S1/ Garbage
2)	 S2/ Addr of error message, or 0 if no error
2)	 T1-T4/ Garbage
2)	~ ;End of COMMENT
2)		EXTERN	TOLP.			;Routine to reverse PLOT
2)		INTERN	PLOT			;Routine to move the pen
2)		INTERN	NEWPEN,OPRTXT,PAUSEP,TITLE ;Other routines called by TOLP
2)		ND	INCS,^D400		;Steps per inch (620 octal)
2)80	;Process 18-bit format
2)	PLTHLF:	MOVEI	T1,^D36			;Read full words from disk
2)		MOVEM	T1,J$DBSZ(J)		;(let TOLP split them into halfwords)
2)		MOVE	T1,J$XPOS(J)		;Raise the pen, but
2)		MOVE	T2,J$YPOS(J)		; stay at current position
2)		MOVE	T3,PN.UP
2)		PUSHJ	P,PLOT
2)		MOVEI	S2,3			;Assume both header and trailer
2)		LOAD	S1,.FPINF(E),FP.NFH	;Get No File Header bit
2)		SKIPE	S1			;Bit set?
2)		 MOVEI	S2,0			;Yes, suppress internal header and trailer
2)		MOVEI	S1,READ36		;Input routine (S2 has flags)
2)		MOVE	T1,J$XPOS(J)		;TOLP needs to know current position
2)		MOVE	T2,J$YPOS(J)
2)		PUSHJ	P,TOLP.##		;TOLP is PLOT spelled backwards
2)		MOVEI	S1,[ITEXT (<^T/0(S2)/ ^F/@J$DFDA(J)/>)]	;S2 points to ASCIZ
2)		SKIPE	S2			;If errors were detected, copy string
2)		 PUSHJ	P,PUTERR		; and file name to error buffer
2)		JRST	PLTLP0			;File is at EOF, finish up
2)81	SUBTTL	Plotter service -- READ36, OPRTXT, PAUSEP, TITLE for TOLP
2)	;Routine to read a word from the input file, returns -1 for EOF, -2 if ABORT
2)	READ36:	MOVE	S1,J$PTIC(J)		;Get tics plotted
2)		IDIV	S1,J$PTPM(J)		;Convert to minutes
2)		CAMLE	S1,J$RLIM(J)		;Still in range?
2)		 PUSHJ	P,FRMLEX		;No, complain
2)		PUSHJ	P,INPBYT		;Get a word
2)		MOVE	T1,C			;Copy to expected AC
2)		JUMPT	.POPJ			;Use it if OK
2)		MOVNI	T1,1			;-1 for EOF
2)		TXNE	S,RQB+ABORT		;Unless OPR caused EOF
2)		 MOVNI	T1,2			;-2 for ABORT
2)		POPJ	P,			;Continue back in TOLP
2)	;Routine to send a message to the OPR.
2)	;Called with byte count in S1, addr of ASCIZ message in S2.
2)	OPRTXT:	PUSHJ	P,PLTOUT		;Dump buffers
2)		HRRZ	S1,STREAM		;Get the stream number
2)		$WTO	(OPRTXT message,<^T/0(S2)/>,@JOBOBA(S1)) ;Tell OPR
2)		POPJ	P,
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)	;Routine to pause the plotter.
2)	;Zero in S1 means to wait for human intervention, nonzero causes graphic
2)	;terminals to pause that many seconds before automatically resuming.
2)	PAUSEP:	PUSHJ	P,PLTOUT		;Dump the buffers
2)		JUMPN	S1,.POPJ		;Nonzero valid for graphics terminals
2)		PUSHJ	P,SETTBF		;Set up WTO buffer
2)		PJRST	FORM.3			;Wait for a "PROCEED" response
2)	;Routine to plot text.
2)	;  T1/ Height in increments
2)	;  T2/ Addr of text
2)	;  T3/ Angle in degrees, 0 to 359
2)	;  T4/ Byte count for text
2)	TITLE:	POPJ	P,			;Not implemented
2)	PLTOUT:
2)	IFE CSM08$,< PJRST  OUTOUT >
2)	IFN CSM08$,<
2)		SKIPE	J$TTY(J)		;Output to a TTY?
2)		 PJRST	OUTOUT			;No
2)		PUSHJ	P,PTCOUT##		;Yes, get ready to output last buffer
2)		SETZM	J$PPOS(J)		;PTCOUT always raises the pen
2)		PJRST	OUTRSP			;Output string and wait for response
2)	>  ;End of IFN CSM08$
2)	>  ;End of IFN CSM02$
2)82	SUBTTL	Plotter service -- NEWPEN for 3-pen plotter
2)		CSMEDT	01,3	;3-Pen plotter, part 3 before P$DERR
2)	IFN CSM01$,<
2)	PEN.1:	MOVEI	S1,1			;Set to blue pen
2)		JRST	NEWPEN
2)	PEN.2:	MOVEI	S1,2			;Set to black pen
2)		JRST	NEWPEN
2)	PEN.3:	MOVEI	S1,3			;Set to red pen and fall into NEWPEN
2)		JRST	NEWPEN
2)		ND PENSEP,INCS*4/4		;Pen separation is 1 inch or 3/4 inch
2)	CHGPEN:	BYTE (6) CNGP,PNDN,0		;Codes to change to pen #1
2)		BYTE (6) CNGP,PEN2,PNDN,0	;			#2
2)		BYTE (6) CNGP,PEN3,PNDN,0	;			#3
2)	;Routine to change pens.  Called with pen number in S1, trashes it and S2.
2)	NEWPEN:	$SAVE	<P1,P2>			;Save preserved ACs
2)	;Make sure pen number in S1 is between 1 and 3 inclusive
2)		SUBI	S1,1			;Change to number from 0 to 2
2)		IDIVI	S1,3			;Set S2 modulo 3
2)		AOS	P2,S2			;Copy new pen number (from 1 to 3)
2)		CSMEDT	08,2	;PTC-6 Plotter Controller, part 2 in NEWPEN
2)	IFN CSM08$,<	;Special codes for PTC-6
2)		SKIPE	J$TTY(J)		;Using a terminal line?
2)		 JRST	[PUSHJ	P,PTCPEN##	  ;Yes, tell it (pen number in S2)
2)			 JRST	NEWPN2	]	  ;Then move the pen holder
2)	>  ;End of IFN CSM08$
2)		MOVEI	P1,CHGPEN-1(S2)		;Get addr of data
2)		HRLI	P1,(POINT 6,)		;Make into byte pointer
2)		PUSHJ	P,PENUP			;Raise any and all pens
2)	;Output the codes to select new pen (even if it was previously selected)
2)	NEWPN1:	ILDB	C,P1			;Get a byte
2)		PUSHJ	P,PLTBTX		;Send to plotter (even if no-op)
2)		JUMPN	C,NEWPN1		;Loop till no-op is sent
2)	;When pen #1 is positioned at Y=5.0, then pen #2 is at Y=4.0 and pen #3
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)	;is at Y=3.0.  Therefore, when changing from pen #1 to pen #2 (or 2 to 3),
2)	;the pen holder must be moved 1.0 inches in the +Y direction, without
2)	;affecting J$YPOS and in spite of J$YMAX and J$YMIN.
2)	NEWPN2:	MOVE	P1,P2			;Copy new pen number
2)		SUB	P1,J$PENN(J)		;Find change (+1 if from pen 1 to pen 2)
2)		JUMPE	P1,.POPJ		;All done if same as previous pen
2)		EXCH	P2,J$PENN(J)		;Set new, get old
2)		JUMPE	P2,.POPJ		;All done if called from P$CPEN
2)		IMULI	P1,PENSEP		;Distance between pens
2)		SKIPL	P1			;If going plus,
2)		 ADDM	P1,J$YMAX(J)		; allow blue pen to move off the paper
2)		SKIPG	P1			;If going minus,
2)		 ADDM	P1,J$YMIN(J)		; allow red pen to move off the paper
2)		MOVE	T1,J$XPOS(J)		;No change in X
2)		MOVE	T2,P1			;Delta Y
2)		ADD	T2,J$YPOS(J)		;New Y position
2)		MOVEI	T3,PN.UP		;Raise the pen
2)		PUSHJ	P,PLOT			;Move the pen holder into position
2)		MOVNS	P1			;Cancel the offset
2)		SKIPG	P1			;If used to be positive,
2)		 ADDM	P1,J$YMAX(J)		; reset max limit
2)		SKIPL	P1			;If used to be negative,
2)		 ADDM	P1,J$YMIN(J)		; reset min limit
2)		ADDM	P1,J$YPOS(J)		;New pen is where previous one was
2)		POPJ	P,
2)	;Routine to output bytes to plotter, passing nulls and CNGP codes correctly.
2)	;Note: When changing pens, the first PNDN code does NOT lower the pen.
2)	PLTBTX:	MOVEI	S1,PLTMOV		;Load # tics for movement
2)		CAIN	C,PNDN			;Pen down code?
2)		 MOVEI	S1,PLTPEN		;Load # tics for pen up/down
2)		ADDM	S1,J$PTIC(J)		;Add in for accounting
2)		PJRST	OUTBYT			;Bypass J$ROTA check
2)	>  ;End of IFN CSM01$
2)83	SUBTTL	Plotter service -- DEVOUT output errors
2)	; *** Note ***
**************
1)78	P$BANN:	PUSHJ	P,P$CPEN		;RE-CALIBRATE THE PEN
1)		SKIPN	J$FBANN(J)		;BANNER WANTED?
1)		POPJ	P,			;NO - JUST RETURN
1)		PUSH	P,J$PTIC(J)		;DON'T CHARGE FOR PLOTTER OVERHEAD
1)		MOVEI	S1,[ASCIZ |Start|]	;GET LINE IDENTIFIER
1)		PUSHJ	P,PLTJOB		;PLOT JOB INFORMATION
1)	BANN.1:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
1)		ADD	T1,J$XPOS(J)		;POINT TO NEXT LINE
1)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
1)		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;MOVE THE PEN
****
2)84		CSMEDT	03,1	;Banner changes, part 1 at P$BANN:
2)	;*; IFN CSM03$,<ND NAMSIZ,1>
2)		ND NAMSIZ,3	;User's name will be 3 times larger than other text
2)	P$BANN:	CSMEDT	08,3	;PTC-6 Plotter Controller, part 3 at P$BANN
2)	IFN CSM08$,<
2)		SKIPE	J$TTY(J)		;PTC-6 controller?
2)		 PUSHJ	P,[MOVEI T1,PLTPEN	  ;Yes, positive to use CR handshake
2)			   PUSHJ P,PTCINI##	  ;Initialize terminal
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)			   PJRST OUTRSP	]	  ;Output string to TTY
2)	>  ;End of IFN CSM08$
2)		PUSHJ	P,P$CPEN		;RE-CALIBRATE THE PEN
2)		SKIPN	J$FBANN(J)		;BANNER WANTED?
2)		POPJ	P,			;NO - JUST RETURN
2)		PUSH	P,J$PTIC(J)		;DON'T CHARGE FOR PLOTTER OVERHEAD
2)		MOVEI	S1,[ASCIZ |Start|]	;GET LINE IDENTIFIER
2)		PUSHJ	P,PLTJOB		;PLOT JOB INFORMATION
2)	BANN.1:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
2)	IFN NAMSIZ-1,<	;Start a separate line
2)		ADD	T1,J$XPOS(J)		;POINT TO NEXT LINE
2)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
2)	>  ;End of IFN NAMSIZ-1
2)	IFE NAMSIZ-1,<	;Put LIMIT on same line as user name
2)		MOVE	T2,T1			;Copy character size
2)		ADD	T2,J$YPOS(J)		;Space over a bit in plus-Y direction
2)		MOVE	T1,J$XPOS(J)		;Current X position
2)	>  ;End of IFN NAMSIZ-1
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;MOVE THE PEN
**************
1)79		$TEXT	(DEPBP,<* File: ^F/@J$DFDA(J)/^I/(S2)/ created:^H/S1/ *^0>)
1)		PUSHJ	P,STRING		;PLOT TEXT
1)	P$HEA1:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
1)		IMULI	T1,4			;LEAVE THIS MUCH SPACE
1)		ADD	T1,J$XPOS(J)		;OFFSET BY CURRENT POSITION
1)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
1)		MOVEI	T3,3			;PEN GOES UP
1)		PUSHJ	P,PLOT			;POSITION PEN
1)		MOVE	T1,J$XPOS(J)		;GET CURRENT X POSITION
1)		MOVEM	T1,J$XMIN(J)		;UPDATE NEW MINIMUM
1)		POP	P,J$PTIC(J)		;RESTORE # PLOTTER TICS
1)		POPJ	P,			;RETURN
1)80	SUBTTL	Plotter service -- File trailers
1)	P$EOF:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
1)		ADD	T1,J$XLIM(J)		;POSITION BEYOND THE HIGHEST X STEP
1)		MOVE	T2,J$YMIN(J)		;GO BACK TO THE MARGIN
1)		MOVEI	T3,3			;WITH PEN UP
1)		PUSHJ	P,PLOT			;POSITION PEN
1)		PJRST	OUTOUT			;DUMP WHAT WE HAVE
1)81	SUBTTL	Plotter service -- Job trailers
1)	P$TRAI:	PUSHJ	P,P$DASH		;SEPARATE FROM LAST FILE
1)		PUSH	P,J$PTIC(J)		;DON'T CHARGE FOR PLOTTER OVERHEAD
1)		SKIPN	J$FTRA(J)		;TRAILER ALLOWED?
1)		  JRST	P$TRA3			;NO
1)		SKIPN	J$XERR(J)		;ANY ERROR TEXT ?
1)		JRST	P$TRA0			;NO - ONWARD
1)		PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
1)		ADD	T1,J$XPOS(J)		;POINT TO NEXT LINE
1)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
1)		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;POSITION PEN
1)		PUSHJ	P,SETTBF		;SET UP TEXT BUFFER
1)		$TEXT	(DEPBP,<^T/J$XERR(J)/^0>) ;INCLUDE ERROR TEXT
1)		PUSHJ	P,STRING		;PLOT ERROR TEXT
1)	P$TRA0:	MOVEI	S1,[ASCIZ |End|]	;GET LINE IDENTIFIER
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

1)		PUSHJ	P,PLTJOB		;PLOT JOB LINE
1)	P$TRA1:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
1)		ADD	T1,J$XPOS(J)		;POINT TO NEXT LINE
1)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
1)		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;POSITION PEN
****
2)85		CSMEDT	02,3	;Halfword format, part 3 at P$HEA1:-2
2)	IFE CSM02$,< $TEXT (DEPBP,<* File: ^F/@J$DFDA(J)/^I/(S2)/ created:^H/S1/ *^0>) >
2)	IFN CSM02$,< $TEXT (DEPBP,<* File: ^F/@J$DFDA(J)/^I/(S2)/ *^0>) >
2)				;CSM internal headers have creation date/time
2)		PUSHJ	P,STRING		;PLOT TEXT
2)	P$HEA1:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
2)		ADD	T1,J$XPOS(J)		;OFFSET BY CURRENT POSITION
2)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;POSITION PEN
2)		MOVE	T1,J$XPOS(J)		;GET CURRENT X POSITION
2)		MOVEM	T1,J$XMIN(J)		;UPDATE NEW MINIMUM
2)	IFN CSM01$,<	;Allow plots to butt up against each other
2)		ADDI	T1,INCS/2		;Set lowest seen to 1/2 inch margins
2)		MOVEM	T1,J$XLOW(J)		;(not fully implemented yet)
2)	>  ;End of IFN CSM01$
2)		POP	P,J$PTIC(J)		;RESTORE # PLOTTER TICS
2)		POPJ	P,			;RETURN
2)86	SUBTTL	Plotter service -- File trailers
2)	P$EOF:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
2)		ADD	T1,J$XLIM(J)		;POSITION BEYOND THE HIGHEST X STEP
2)		MOVE	T2,J$YMIN(J)		;GO BACK TO THE MARGIN
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;POSITION PEN
2)		CSMEDT	08,4	;PTC-6 Plotter Controller, part 4 at end of P$EOF
2)	IFN CSM08$,<	;Call PTCOUT instead of OUTOUT
2)		SKIPE	J$TTY(J)		;PTC-6 controller?
2)		 JRST	[PUSHJ P,PTCOUT##	  ;Yes, raise pen
2)			 PJRST OUTRSP	]	  ;Wait for response
2)	>  ;End of IFN CSM08$
2)		PJRST	OUTOUT			;DUMP WHAT WE HAVE
2)87	SUBTTL	Plotter service -- Job trailers
2)	P$TRAI:	CSMEDT	03,3	;Banner changes, part 3 at P$TRAI:
2)	IFE CSM03$,<	;This test prevents error messages from coming out
2)		PUSHJ	P,P$DASH		;SEPARATE FROM LAST FILE
2)		PUSH	P,J$PTIC(J)		;DON'T CHARGE FOR PLOTTER OVERHEAD
2)		SKIPN	J$FTRA(J)		;TRAILER ALLOWED?
2)		  JRST	P$TRA3			;NO
2)	>  ;End of IFE CSM03$
2)	IFN CSM03$,<	;Output dashed line only if text will be plotted
2)		PUSH	P,J$PTIC(J)		;Don't charge for plotter overhead
2)		SKIPN	J$FTRA(J)		;Plot the trailer?
2)		SKIPE	J$XERR(J)		; or an error message?
2)		 PUSHJ	P,P$DASH		;Yes, separate text from plot
2)	>  ;End of IFN CSM03$
2)		SKIPN	J$XERR(J)		;ANY ERROR TEXT?
2)		JRST	P$TRA0			;NO - ONWARD
2)		PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
2)		IMULI	T1,2		;[CSM]	;Make room for characters
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)		ADD	T1,J$XPOS(J)		;POINT TO NEXT LINE
2)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;POSITION PEN
2)		PUSHJ	P,SETTBF		;SET UP TEXT BUFFER
2)		$TEXT	(DEPBP,<^T/J$XERR(J)/^0>) ;INCLUDE ERROR TEXT
2)		PUSHJ	P,STRING		;PLOT ERROR TEXT
2)	P$TRA0:
2)	IFN CSM03$,<	;Check for /TRAILER after plotting error message
2)		SKIPN	J$FTRA(J)		;Trailer wanted?
2)		 JRST	P$TRA3			;No, skip job line and summary
2)	>  ;End of IFN CSM03$
2)		MOVEI	S1,[ASCIZ |End|]	;GET LINE IDENTIFIER
2)		PUSHJ	P,PLTJOB		;PLOT JOB LINE
2)	CONT.	(P$TRAI)
2)	P$TRA1:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
2)	IFN NAMSIZ-1,<	;Start a separate line
2)		ADD	T1,J$XPOS(J)		;POINT TO NEXT LINE
2)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
2)	>  ;End of IFN NAMSIZ-1
2)	IFE NAMSIZ-1,<	;Put SUMMARY on same line as user name
2)		MOVE	T2,T1			;Copy character size
2)		ADD	T2,J$YPOS(J)		;Space over a bit in plus-Y direction
2)		MOVE	T1,J$XPOS(J)		;Current X position
2)	>  ;End of IFN NAMSIZ-1
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;POSITION PEN
**************
1)81		IMULI	T2,^D1000		;MAKE IT DECIMAL
1)		IDIV	T2,J$PTPM(J)		;T2:= DECIMAL FRACTION OF A MINUTE
1)		$TEXT	(DEPBP,< plotted in ^D/T1/.^D3L0/T2/ minutes^0>)
1)		PUSHJ	P,STRING		;PLOT TEXT
****
2)87		IMULI	T2,^D10			;[CSM] 1 decimal place (=6 seconds)
2)		IDIV	T2,J$PTPM(J)		;T2:= DECIMAL FRACTION OF A MINUTE
2)		$TEXT	(DEPBP,< plotted in ^D/T1/.^D/T2/ minutes^0>)
2)		PUSHJ	P,STRING		;PLOT TEXT
**************
1)81		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;POSITION PEN
1)		POP	P,J$PTIC(J)		;RESTORE # PLOTTER TICS
1)		MOVE	T1,J$PTIC(J)		;GET # TICS
1)		IDIV	T1,J$PTPM(J)		;GET MINUTES OF PLOTTER TIME
1)		MOVEM	T1,J$APRT(J)		;STORE IT
1)		POPJ	P,			;RETURN
****
2)87		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;POSITION PEN
2)		POP	P,J$PTIC(J)		;RESTORE # PLOTTER TICS
2)		MOVE	T1,J$PTIC(J)		;GET # TICS
2)		IDIV	T1,J$PTPM(J)		;GET MINUTES OF PLOTTER TIME
2)		MOVEM	T1,J$APRT(J)		;STORE IT
2)		CSMEDT	08,5	;PTC-6 Plotter Controller, part 5 at end of P$TRAI
2)	IFN CSM08$,<
2)		SKIPE	J$TTY(J)		;PTC-6 controller?
2)		 PUSHJ	P,[PUSHJ P,PTCOUT##	  ;Yes, raise pen
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)			   PUSHJ P,OUTRSP	  ;Wait for response
2)			   PUSHJ P,PTCFIN##	  ;Finish up and deselect
2)			   PJRST OUTSTG	]	  ;Output string to TTY
2)	>  ;End of IFN CSM08$
2)		POPJ	P,			;RETURN
**************
1)82		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
1)		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;POSITION PEN
1)		MOVE	T1,J$XPOS(J)		;DON'T TOUCH X POSITION
1)		MOVE	T2,J$YMAX(J)		;GET MAXIMUM Y VALUE
1)		MOVEI	T3,2			;PEN DOWN
1)		PUSHJ	P,PLOT			;PLOT A LINE
1)	LINE.1:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
1)		IMULI	T1,2			;LEAVE SOME SPACE
1)		ADD	T1,J$XPOS(J)		;POSITION TO NEXT LINE
1)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y VALUE
1)		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;POSITION PEN AT START OF NEXT LINE
****
2)88		CSMEDT	03,4	;Banner changes, part 4 at P$LINE:+2
2)	IFE CSM03$,<	;Going from MIN to MAX when pen is near MAX wastes time
2)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;POSITION PEN
2)		MOVE	T1,J$XPOS(J)		;Use current X position
2)		MOVE	T2,J$YMAX(J)		;GET MAXIMUM Y VALUE
2)	>  ;End of IFE CSM03$
2)	IFN CSM03$,<	;Go to MAX, then to MIN and end there
2)		MOVE	T2,J$YMAX(J)		;Go to closer end point
2)		CAIL	T2,INCS*6		;More than 6 inches?
2)		 MOVEI	T2,INCS*6		;Yes, don't waste inc
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;Position pen
2)		MOVE	T1,J$XPOS(J)		;Use current X position
2)		MOVE	T2,J$YMIN(J)		;Go to "HOME" position
2)	>  ;End of IFE CSM03$
2)		MOVEI	T3,PN.DWN		;Pen down
2)		PUSHJ	P,PLOT			;PLOT A LINE
2)	LINE.1:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
2)		IMULI	T1,2			;LEAVE SOME SPACE
2)		ADD	T1,J$XPOS(J)		;POSITION TO NEXT LINE
2)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y VALUE
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;POSITION PEN AT START OF NEXT LINE
**************
1)83		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
1)		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;POSITION PEN
1)	DASH.1:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
1)		ADD	T1,J$YPOS(J)		;ADD TO Y POSITION
1)		CAML	T1,J$YMAX(J)		;GONE TOO FAR ?
1)		JRST	LINE.1			;YES - FINISH UP
1)		MOVE	T2,T1			;PUT IN PROPER PLACE
1)		MOVE	T1,J$XPOS(J)		;GET X POSITION
1)		MOVEI	T3,2			;PEN DOWN
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

1)		PUSHJ	P,PLOT			;PLOT A LINE
1)	DASH.2:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
1)		ADD	T1,J$YPOS(J)		;ADD TO Y POSITION
1)		CAML	T1,J$YMAX(J)		;GONE TOO FAR ?
1)		JRST	LINE.1			;YES - FINISH UP
1)		MOVE	T2,T1			;PUT IN PROPER PLACE
1)		MOVE	T1,J$XPOS(J)		;GET X POSITION
1)		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;PLOT A LINE
****
2)89		CSMEDT	03,5	;Banner changes, part 5 at P$DASH:+3
2)	IFE CSM03$,< MOVE  T2,J$YMIN(J) >	;GET MINIMUM Y POSITION
2)	IFN CSM03$,<
2)		MOVE	T2,J$YMAX(J)		;Get maximum Y position
2)		CAIL	T2,INCS*6		;More than 6 inches?
2)		 MOVEI	T2,INCS*6		;Yes, don't waste time and ink
2)	>  ;End of IFN CSM03$
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;POSITION PEN
2)	DASH.1:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
2)	IFE CSM03$,<
2)		ADD	T1,J$YPOS(J)		;ADD TO Y POSITION
2)		CAML	T1,J$YMAX(J)		;GONE TOO FAR?
2)	>  ;End of IFE CSM03$
2)	IFN CSM03$,<
2)		MOVNS	T1			;Make negative
2)		ADD	T1,J$YPOS(J)		;Decrement Y position
2)		CAMG	T1,J$YMIN(J)		;Gone too far?
2)	>  ;End of IFN CSM03$
2)		JRST	LINE.1			;YES - FINISH UP
2)		MOVE	T2,T1			;PUT IN PROPER PLACE
2)		MOVE	T1,J$XPOS(J)		;GET X POSITION
2)		MOVEI	T3,PN.DWN		;Pen down
2)		PUSHJ	P,PLOT			;PLOT A LINE
2)	DASH.2:	PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
2)	IFE CSM03$,<
2)		ADD	T1,J$YPOS(J)		;ADD TO Y POSITION
2)		CAML	T1,J$YMAX(J)		;GONE TOO FAR?
2)	>  ;End of IFE CSM03$
2)	IFN CSM03$,<
2)		MOVNS	T1			;Make negative
2)		ADD	T1,J$YPOS(J)		;Decrement Y position
2)		CAMG	T1,J$YMIN(J)		;Gone too far?
2)	>  ;End of IFN CSM03$
2)		JRST	LINE.1			;YES - FINISH UP
2)		MOVE	T2,T1			;PUT IN PROPER PLACE
2)		MOVE	T1,J$XPOS(J)		;GET X POSITION
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;PLOT A LINE
**************
1)84		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;POSITION PEN
1)		PUSHJ	P,SETTBF		;SET UP TEXT BUFFER
1)		MOVE	T1,.EQJBB+JIB.JN(J)	;GET JOB NAME
1)		MOVE	T2,.EQJBB+JIB.ID(J)	;GET REQUEST ID
1)		POP	P,T3			;RESTORE TEXT POINTER
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

1)		$TEXT	(DEPBP,<* ^T/(T3)/ Job ^W/T1/ req #^D/T2/ ^H/[-1]/ ^T/(T3)/ *^0>)
1)		PUSHJ	P,STRING		;PLOT STRING
1)		PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
1)		IMULI	T1,^D4			;GET STARTING POSITION
1)		ADD	T1,J$XPOS(J)		;OFFSET BY CURRENT POSITION
1)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
1)		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;MOVE THE PEN
1)		PUSHJ	P,SETTBF		;SET UP POINTERS TO THE BUFFER
1)		PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
1)		IMULI	T1,3			;COMPUTE NEW CHARACTER SIZE
1)		MOVEM	T1,J$CSIZ(J)		;STORE IT
1)		;PLOT THE USERS NAME
****
2)90		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;POSITION PEN
2)		PUSHJ	P,SETTBF		;SET UP TEXT BUFFER
2)		CSMEDT	03,6	;Banner changes, part 6 at PLTJOB:+8
2)	IFN CSM03$,< PUSHJ P,PEN.3 >		;Do "*START*" in red
2)		MOVE	T1,.EQJBB+JIB.JN(J)	;GET JOB NAME
2)		MOVE	T2,.EQJBB+JIB.ID(J)	;GET REQUEST ID
2)		POP	P,T3			;RESTORE TEXT POINTER
2)		$TEXT	(DEPBP,<* ^T/(T3)/ Job ^W/T1/ req #^D/T2/ ^H/[-1]/ ^T/(T3)/ *^0>)
2)		PUSHJ	P,STRING		;PLOT STRING
2)		PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
2)		IMULI	T1,NAMSIZ+1	;[CSM]	;Size of name plus blank space
2)		ADD	T1,J$XPOS(J)		;OFFSET BY CURRENT POSITION
2)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;MOVE THE PEN
2)		PUSHJ	P,SETTBF		;SET UP POINTERS TO THE BUFFER
2)		PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
2)		IMULI	T1,NAMSIZ	;[CSM]	;The name is bigger than other text
2)		MOVEM	T1,J$CSIZ(J)		;STORE IT
2)	IFN CSM03$,< PUSHJ P,PEN.2 >		;Do user's name in black
2)	CONT.	(PLTJOB)
2)		;PLOT THE USERS NAME
**************
1)84		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;POSITION PEN
1)		POPJ	P,			;RETURN
****
2)90		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;POSITION PEN
2)	IFN CSM03$,< PUSHJ P,PEN.1 >		;Next dividing line will be blue
2)		POPJ	P,			;RETURN
**************
1)85		PUSHJ	P,STRING		;OUTPUT TEXT
1)		PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
1)		IMULI	T1,2			;WANT DOUBLE HEIGHT CHARACTERS
1)		MOVEM	T1,J$CSIZ(J)		;REMEMBER IT
1)		ADD	T1,J$XPOS(J)		;OFFSET BY CURRENT POSITION
1)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
1)		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;POSITION PEN
****
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)91		MOVEI	S1,.CHNUL	;[CSM]	;Terminate previous string
2)		PUSHJ	P,DEPBP		;[CSM]	; (in case of /NOTE: in SPFORM.INI)
2)		PUSHJ	P,STRING		;OUTPUT TEXT
2)		PUSHJ	P,P$CHKS		;COMPUTE CHARACTER SIZE
2)		IMULI	T1,2			;WANT DOUBLE HEIGHT CHARACTERS
2)		MOVEM	T1,J$CSIZ(J)		;REMEMBER IT
2)		ADD	T1,J$XPOS(J)		;OFFSET BY CURRENT POSITION
2)		MOVE	T2,J$YMIN(J)		;GET MINIMUM Y POSITION
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;POSITION PEN
**************
1)86	P$CPEN:	MOVE	T1,J$YMAX(J)		;GET THE MAXIMUM Y VALUE WE KNOW ABOUT
1)		MOVEM	T1,J$YPOS(J)		;FAKE OUT THE LOW LEVEL OUTPUT ROUTINE
1)		PUSH	P,J$YMIN(J)		;SAVE MINIMUM Y POSITION
1)		SETZM	J$YMIN(J)		;CLEAR SO WE CAN GO BELOW IT
1)		MOVE	T1,J$XPOS(J)		;DON'T TOUCH THE X POSITION
1)		MOVEI	T2,0			;RAM THE PEN INTO THE AXIS
1)		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;POSITION PEN
1)		SETZM	J$XMIN(J)		;ZERO X MINIMUM
1)		SETZM	J$YMIN(J)		;ZERO Y MINIMUM
1)		SETZM	J$XPOS(J)		;ZERO X POSITION
1)		SETZM	J$YPOS(J)		;ZERO Y POSITION
1)		MOVE	T1,J$XORG(J)		;GET ORIGINAL X MINIMUM
1)		MOVE	T2,(P)			;GET MINIMUM Y VALUE
1)		MOVEI	T3,3			;PEN UP
1)		PUSHJ	P,PLOT			;PUT PEN THERE
1)		MOVE	T1,J$XORG(J)		;GET ORIGINAL X MINIMUM
1)		MOVEM	T1,J$XMIN(J)		;STORE IT
1)		POP	P,J$YMIN(J)		;RESTORE MINIMUM Y POSITION
1)		POPJ	P,			;RETURN
1)87	SUBTTL	Plotter service -- Compute chracter size
1)	P$CHKS:	MOVE	T1,J$YMAX(J)		;CALCULATE SIZE
1)		SUB	T1,J$YMIN(J)		; OF PLOTTING AREA
1)		IDIVI	T1,CHRPLN		;MAXIMUM NUMBER OF CHARACTERS PER LINE
1)		MOVEM	T1,J$CSIZ(J)		;STORE CHARACTER SIZE
****
2)92	;This is the only place that J$XPOS is reset.  It is called from P$BANN.
2)	P$CPEN:	MOVE	T1,J$YMAX(J)		;GET THE MAXIMUM Y VALUE WE KNOW ABOUT
2)		CSMEDT	01,4	;3-pen plotter, part 4 at end of P$CPEN
2)	IFN CSM01$,<	;Assume pen is positioned close to the origin
2)		CAIL	T1,INCS*4		;More than 4 inches?
2)		 MOVEI	T1,INCS*4		;Yes, don't waste time ramming the pen
2)	>  ;End of IFN CSM01$
2)		MOVEM	T1,J$YPOS(J)		;FAKE OUT THE LOW LEVEL OUTPUT ROUTINE
2)		PUSH	P,J$YMIN(J)		;SAVE MINIMUM Y POSITION
2)		SETZM	J$YMIN(J)		;CLEAR SO WE CAN GO BELOW IT
2)		MOVE	T1,J$XPOS(J)		;Use current X position
2)		MOVEI	T2,0			;RAM THE PEN INTO THE AXIS
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;POSITION PEN
2)		SETZM	J$XMIN(J)		;ZERO X MINIMUM
2)		SETZM	J$YMIN(J)		;ZERO Y MINIMUM
2)		SETZM	J$XPOS(J)		;ZERO X POSITION
2)		SETZM	J$YPOS(J)		;ZERO Y POSITION
2)		MOVE	T1,J$XORG(J)		;GET ORIGINAL X MINIMUM
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)		MOVE	T2,(P)			;GET MINIMUM Y VALUE
2)		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;PUT PEN THERE
2)		MOVE	T1,J$XORG(J)		;GET ORIGINAL X MINIMUM
2)		MOVEM	T1,J$XMIN(J)		;STORE IT
2)		POP	P,J$YMIN(J)		;RESTORE MINIMUM Y POSITION
2)	IFN CSM01$,<	;RECAL has positioned pen #1 at YMIN
2)		SETZM	J$PENN(J)		;Flag that pen holder was reset
2)		MOVEI	S1,1			;Select pen number 1
2)		PUSHJ	P,NEWPEN		;Tell the plotter which pen to use
2)	>  ;End of IFN CSM01$
2)		POPJ	P,			;RETURN
2)93	SUBTTL	Plotter service -- Compute character size
2)	P$CHKS:	MOVE	T1,J$YMAX(J)		;CALCULATE SIZE
2)		SUB	T1,J$YMIN(J)		; OF PLOTTING AREA
2)		IDIVI	T1,CHRPLN		;MAXIMUM NUMBER OF CHARACTERS PER LINE
2)		CSMEDT	01,5	;3-Pen plotter, part 5 at P$CHKS:+3
2)	IFN CSM01$,<	;Don't plot giant letters on 36 inch wide paper
2)		CAIL	T1,INCS/6		;Bigger than 1/6 inch?
2)		 MOVEI	T1,INCS/6		;Yes, reduce size
2)	>  ;End of IFN CSM01$
2)		MOVEM	T1,J$CSIZ(J)		;STORE CHARACTER SIZE
**************
1)88		MOVEI	T3,3			;PEN UP BEFOR PLOTTING
1)		PUSHJ	P,PLOT			;POSITION PEN
1)		POPJ	P,			;RETURN
1)89	SUBTTL	Plotter service -- Line segments
1)	;Call	T1/ X Coordinate to move to
1)	;	T2/ Y Coordinate to move to
1)	;	T3/ Pen code as follows
1)	;		1	No Change in Pen
1)	;		2	Pen Down before Plotting
1)	;		3	Pen Up before moving
1)	;
1)	PLOT:	$SAVE	<T1,T2,T3,T4>		;PRESERVE TEMPORARIES
1)		CAIG	T3,1			;CHANGE REQUESTED?
1)		JRST	PLT.1			;NO..PROCEED
1)		SUBI	T3,3			;YES..GET -1  OR 0
1)		CAMN	T3,J$PPOS(J)		;PEN IN POSITION?
1)		JRST	PLT.1			;YES -- PROCEED
1)		MOVEI	C,PNUP			;GET PEN UP CODE
1)		SKIPGE	T3			;WANT IT LOWERED?
1)		MOVEI	C,PNDN			;YES..GET THE CODE
1)		$CALL	PLTBYT			;MOVE THE PEN
1)	PLT.1:	SUB	T1,J$XPOS(J)		;COMPUTE DELTA X
1)		MOVEI	T3,XYD			;ASSUME DOWN MOVEMENT
1)		SKIPG	T1			;IS THAT CORRECT?
1)		MOVEI	T3,XYU			;NO..ASSUME UP
1)		SUB	T2,J$YPOS(J)		;COMPUTE DELTA Y
1)		MOVEI	T4,XYL			;ASSUME LEFTWARD MOVEMENT
****
2)94		MOVEI	T3,PN.UP		;Pen up
2)		PUSHJ	P,PLOT			;POSITION PEN
2)		POPJ	P,			;RETURN
2)95	SUBTTL	Plotter service -- Line segments
2)	;Call	T1/ X Coordinate to move to
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)	;	T2/ Y Coordinate to move to
2)	;	T3/ Pen code as follows
2)		PN.SAM==1	;No Change in Pen
2)		PN.DWN==2	;Pen Down before Plotting
2)		PN.UP== 3	;Pen Up before moving
2)	;
2)	PLOT:	$SAVE	<T1,T2,T3,T4>		;PRESERVE TEMPORARIES
2)		CSMEDT	08,6	;PTC-6 Plotter Controller, part 6 at PLOT:+1
2)	IFN CSM08$,<	;Delay testing of T3 if output to a terminal
2)		SKIPN	J$TTY(J)		;Is the plotter really a TTY?
2)	>  ;End of IFN CSM08$
2)		CAIG	T3,PN.SAM		;CHANGE REQUESTED?
2)		JRST	PLT.1			;NO..PROCEED
2)		SUBI	T3,PN.UP		;Yes, get -1  or 0
2)		CAMN	T3,J$PPOS(J)		;PEN IN POSITION?
2)		JRST	PLT.1			;YES -- PROCEED
2)		MOVEI	C,PNUP			;GET PEN UP CODE
2)		SKIPGE	T3			;WANT IT LOWERED?
2)		MOVEI	C,PNDN			;YES..GET THE CODE
2)		$CALL	PLTBYT			;MOVE THE PEN
2)	PLT.1:	SUB	T1,J$XPOS(J)		;COMPUTE DELTA X
2)		SUB	T2,J$YPOS(J)		;COMPUTE DELTA Y
2)	IFN CSM08$,<	;Call external routine if PTC-6
2)		SKIPE	J$TTY(J)		;TTY?       (T1, T2, and T3 set up)
2)		 JRST	PTCMV			;Yes, calculate character string
2)	>  ;End of IFN CSM08$
2)		MOVEI	T3,XYD			;ASSUME DOWN MOVEMENT
2)		SKIPG	T1			;IS THAT CORRECT?
2)		MOVEI	T3,XYU			;NO..ASSUME UP
2)		MOVEI	T4,XYL			;ASSUME LEFTWARD MOVEMENT
**************
1)91	SUBTTL	Plotter service -- Rotation and XY20 translation
****
2)97	SUBTTL	Plotter service -- PTC-6 interface
2)	IFN CSM08$,<	;T1 & T2 have delta movement, T3 has 2 or 3
2)	PTCMV:	ADDM	T1,J$XPOS(J)		;Update position
2)		ADDM	T2,J$YPOS(J)
2)		MOVE	S1,J$XPOS(J)		;Get new X position
2)		CAIL	T3,3			;Pen up?
2)		 JRST	PTCMV1			;No, skip next tests
2)		CAMLE	S1,J$XLIM(J)		;Highest seen so far?
2)		 MOVEM	S1,J$XLIM(J)		;Yes
2)		CAMGE	S1,J$XLOW(J)		;Closest to the origin?
2)		 MOVEM	S1,J$XLOW(J)		;Yes
2)	;T1, T2, and T3 are set up with delta-X, delta-Y, and pen up/down code
2)	PTCMV1:	PUSHJ	P,PTCMOV##		;Translate move, fall into OUTRSP
2)				PAGE
2)	;Routine to output the string pointed to by T1 and wait for response.
2)	;S1 has accumulated increments for the last 4 buffers, to be used to
2)	;predict how long it will take for the PTC-6 to respond.
2)	OUTRSP:	JUMPE	T1,.POPJ		;Don't wait if no string
2)		IMULI	S1,PLTMOV		;Number of ticks to move
2)		LSH	S1,-2			;S1 has count for 4 buffers
2)		ADDM	S1,J$PTIC(J)		;Predict elapsed time
2)		IMULI	S1,^D60*4		;Cancel LSH, use seconds not minutes
2)		IDIV	S1,J$PTPM(J)		;Number of seconds required
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)		ADDI	S1,^D<512*10/CSM08$>	;512 chars take 2 seconds at 2400 baud
2)		MOVNM	S1,J$NACK(J)		;Negative to delay the complaints
2)	OUTRS1:	PUSHJ	P,OUTSTG		;Send the string
2)	OUTRS2:	PUSHJ	P,TIWAIT		;Get response, waiting up to 30 seconds
2)		JUMPT	OUTRS3			;Got it
2)		TXNE	S,RQB+ABORT		;REQUEUE or ABORT?
2)		 $RETF				;Yes, give up
2)		PUSHJ	P,PTCOUT##		;Send string to raise pen
2)		SETZM	J$PPOS(J)		;(just to get controller to respond)
2)		JRST	OUTRS1			;Loop until response or REQUEUE
2)	OUTRS3:	CAIE	S1,.CHCRT		;CR at end?
2)		 JRST	OUTRS2			;No, skip over "0", "C"
2)		PJRST	TTYIN			;Yes, snarf up the LF (if it's there)
2)	;Routine to output the string pointed to by T1.
2)	;The Monitor will put the job in "TO" Terminal Output wait if there are more
2)	;than 400 characters in the TTY chunks.
2)		TOMAX=^D248			;Avoid output wait for TTY
2)	OUTSTG:	JUMPE	T1,.POPJ		;Return if nothing to do
2)		HRLI	T1,(POINT 7,)		;Make into ASCII byte pointer
2)	OUTST1:	MOVEI	S1,0			;Clear byte count
2)	OUTST2:	ILDB	C,T1			;Get a character
2)		JUMPE	C,OUTOUT		;Stop on null, output buffer, return
2)		PUSHJ	P,OUTBYT		;Send it
2)		CAIG	S1,TOMAX		;Almost enough to cause 'TO' wait?
2)		 AOJA	S1,OUTST2		;Loop till end of ASCIZ
2)		PUSHJ	P,OUTOUT		;Dump partial buffer
2)		$DSCHD	(TOMAX*^D10/CSM08$)	;Wait 1 second at 2400 baud
2)		JRST	OUTST1			;(gives checkpoint routine a chance)
2)	>  ;End of IFN CSM08$
2)98	SUBTTL	Plotter service -- Rotation and XY20 translation
**************
1)91		BYTE (18) 103 (2) 0 (4) XYDR,XYDL,XYUL,XYUR	;MOVE UP+RIGHT
1)		EXP -1						;ILLEGAL
1)		BYTE (18) 100 (2) 0 (4) XYL ,XYD ,XYR ,XYU 	;MOVE LEFT
1)		BYTE (18) 107 (2) 0 (4) XYUL,XYUR,XYDR,XYDL	;MOVE DOWN+LEFT
1)		BYTE (18) 101 (2) 0 (4) XYUR,XYDR,XYDL,XYUL	;MOVE UP+LEFT
****
2)98	;[CSM]	BYTE (18) 103 (2) 0 (4) XYDR,XYDL,XYUL,XYUR	;MOVE UP+RIGHT
2)		BYTE (18) 103 (2) 0 (4) XYDR,XYUR,XYUL,XYDL;[CSM] 6 Plus Y & Plus X
2)		EXP -1						; 7 ILLEGAL
2)		BYTE (18) 100 (2) 0 (4) XYL ,XYD ,XYR ,XYU 	;10 Minus Y
2)	;[CSM]	BYTE (18) 107 (2) 0 (4) XYUL,XYUR,XYDR,XYDL	;MOVE DOWN+LEFT
2)		BYTE (18) 107 (2) 0 (4) XYUL,XYDL,XYDR,XYUR;[CSM]11 Minus Y & Minus X
2)		BYTE (18) 101 (2) 0 (4) XYUR,XYDR,XYDL,XYUL	;12 Minus Y & Plus X
**************
1)92	PLTBYT:	TRZE	C,PNUP			;TEST AND CLEAR PEN UP CODE
1)		$CALL	PENUP			;RAISE PEN
1)		TRZE	C,PNDN			;TEST AND CLEAR PEN DOWN CODE
1)		$CALL	PENDN			;LOWER PEN
1)	PLTXYD:	TRNN	C,XYD			;GOING DOWN ?
1)		JRST	PLTXYU			;NO
1)		AOS	S1,J$XPOS(J)		;+1
****
2)99	PLTBYT:	$SAVE	<S1,S2>		;[CSM]	;Preserve ACs
2)		TRZE	C,PNUP			;TEST AND CLEAR PEN UP CODE
2)		$CALL	PENUP			;RAISE PEN
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)		TRZE	C,PNDN			;TEST AND CLEAR PEN DOWN CODE
2)		$CALL	PENDN			;LOWER PEN
2)	PLTXYD:	TRNN	C,XYD			;GOING DOWN?
2)		JRST	PLTXYU			;NO
2)		TRNE	C,XYU		;[CSM]	;Going +X and -X at the same time?
2)		 JRST	PLTB.8		;[CSM]	;Yes, this is a change-pen code
2)		AOS	S1,J$XPOS(J)		;+1
**************
1)92		AOS	S2,J$YPOS(J)		;+1
****
2)99		TRNE	C,XYR		;[CSM]	;Going +Y and -Y at the same time?
2)		 JRST	PLTB.8		;[CSM]	;Yes, this is a change-pen code
2)		AOS	S2,J$YPOS(J)		;+1
**************
1)92	PLTB.6:	SKIPN	J$PPOS(J)		;IS PEN DOWN?
1)		PJRST	PLTB.8			;NO..DON'T RECORD MAX POSITIONS
1)		CAMLE	S1,J$XMAX(J)		;CLIPPED?
1)		JRST	PLTB.7			;YES -- DON'T ADJUST LIMIT
1)		CAMLE	S1,J$XLIM(J)		;HIGHEST POINT SO FAR?
1)		MOVEM	S1,J$XLIM(J)		;YES -- SAVE IT
1)	PLTB.7:	CAMLE	S2,J$YMAX(J)		;CLIPPED?
****
2)99		CONT.	(PLTBYT)
2)	PLTB.6:	SKIPN	J$PPOS(J)		;IS PEN DOWN?
2)		PJRST	PLTB.8			;NO..DON'T RECORD MAX POSITIONS
2)		MOVE	S1,J$XPOS(J)	;[CSM]	;In case of no AOS or SOS was done
2)		CAMLE	S1,J$XMAX(J)		;CLIPPED?
2)		JRST	PLTB.7			;YES -- DON'T ADJUST LIMIT
2)		CAMLE	S1,J$XLIM(J)		;HIGHEST POINT SO FAR?
2)		MOVEM	S1,J$XLIM(J)		;YES -- SAVE IT
2)		CSMEDT	01,6	;3-pen plotter, part 6 at PLTB.6:+5
2)	IFN CSM01$,<	;Remember X minimum for positioning trailer after X maximum
2)		CAMGE	S1,J$XLOW(J)		;Smaller than the previous XLOW?
2)		 MOVEM	S1,J$XLOW(J)		;Yes, user went near -X boundry
2)						;therefore put dashed line close to plot
2)	>  ;End of IFN CSM01$
2)	PLTB.7:	CAMLE	S2,J$YMAX(J)		;CLIPPED?
**************
1)95	C%002:	XX <144,563,603,622,621,600,560,541,542,563,603,624,FIN>
****
2)102		.XCREF				;[CSM] Don't CREF the rest
2)	C%002:	XX <144,563,603,622,621,600,560,541,542,563,603,624,FIN> ;Alpha
**************
1)95	C%032:	XX <160,601,543,564,FIN>
1)	C%033:	XX <602,642,704,244,640,200,604,FIN>
****
2)102	C%032:	XX <142,600,642,604,542,FIN>	;Formerly C%175	;Diamond box [CSM]
2)	C%033:	XX <602,642,704,244,640,200,604,FIN>		;Not equal
**************
1)98	C%175:	XX <142,600,642,604,542,FIN>
1)	C%176:	XX <541,562,602,623,624,623,642,662,701,700,FIN>
1)	C%177:	XX <260,564,FIN>
****
2)105	  ;[CSM] Put close brace and tilde where they belong in the ASCII code
2)	C%175:	XX <541,562,602,623,624,623,642,662,701,700,FIN> ;} 175, not C%176
2)	C%176:	XX <160,601,543,564,FIN>	;~ Tilde, formerly C%032
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)		.CREF			;[CSM]	;OK to CREF now
2)	C%177:	XX <260,564,FIN>		;\ Backslash, duplicate of C%134
**************
1)99		JRST	.RETT			;(11) ACCOUNTING
1)		JRST	T$CHKP			;(12) CHECKPOINT TEXT GENERATION
****
2)106		CSMEDT	04,4	;CSM accounting, part 4 at T$DISP:+11
2)	IFE CSM04$,< JRST   .RETT >		;(11) ACCOUNTING
2)	IFN CSM04$,< JRST   CSMACT >		;(11) ACCOUNTING
2)		JRST	T$CHKP			;(12) CHECKPOINT TEXT GENERATION
**************
1)101		MOVEI	S1,T$MTAB		;GET ADDRESS OF MODE TABLE
1)		MOVEI	S2,T$ROUT		;GET ADDRESS OF ROUTINE TABLE
1)		PJRST	DSPMOD			;AND DISPATCH BASED ON MODE
1)	T$ROUT:	EXP	PTASC			;ASCII
****
2)108		CSMEDT	07,5	;QUEUE defaults, part 5 at T$PROC:+6
2)	IFE CSM07$,<	;This code will punch SOS files in BINARY mode
2)		MOVEI	S1,T$MTAB		;GET ADDRESS OF MODE TABLE
2)		MOVEI	S2,T$ROUT		;GET ADDRESS OF ROUTINE TABLE
2)		PJRST	DSPMOD			;AND DISPATCH BASED ON MODE
2)	>  ;End of IFE CSM07$
2)	IFN CSM07$,< JRST  PTASC >		;Default always to ASCII
2)	T$ROUT:	EXP	PTASC			;ASCII
**************
1)112	PTPBYT:	PUSH	P,S1			;SAVE FROM
1)		PUSH	P,S2			; DESTRUCTION
1)		PUSHJ	P,OUTBYT		;OUTPUT THE BYTE
1)		AOS	S1,J$TFRM(J)		;COUNT THE FRAME
1)		IDIVI	S1,FRMPFT		;COMPUTE FEET OF TAPE USED
1)		MOVEM	S1,J$APRT(J)		;STORE FOR ACCOUNTING PURPOSES
1)		CAMLE	S1,J$RLIM(J)		;EXCEEDED LIMIT ?
1)		PUSHJ	P,FRMLEX		;YES - ASK THE OPERATOR'S ADVICE
1)		POP	P,S2			;RESTORE
1)		POP	P,S1			; S1 & S2
1)		POPJ	P,			;RETURN
1)	; Repeat the byte in AC 'C'
1)	; Call:	MOVE	S1,repeat count
1)	;	MOVE	C,byte to output
1)	;	PUSHJ	P,PTPREP
1)	;
1)	PTPREP:	PUSH	P,P1			;SAVE P1
1)		MOVE	P1,S1			;GET COUNT
1)		PUSHJ	P,PTPBYT		;OUTPUT A BYTE
1)		SOJG	P1,.-1			;AND LOOP
1)		POP	P,P1			;RESTORE P1
1)		POPJ	P,			;RETURN
****
2)119	PTPBYT:	$SAVE	<S1,S2>		;[CSM]	;Preserve ACs
2)		PUSHJ	P,OUTBYT		;OUTPUT THE BYTE
2)		AOS	S1,J$TFRM(J)		;COUNT THE FRAME
2)		IDIVI	S1,FRMPFT		;COMPUTE FEET OF TAPE USED
2)		MOVEM	S1,J$APRT(J)		;STORE FOR ACCOUNTING PURPOSES
2)		CAMLE	S1,J$RLIM(J)		;EXCEEDED LIMIT?
2)		PUSHJ	P,FRMLEX		;YES - ASK THE OPERATOR'S ADVICE
2)		POPJ	P,		;[CSM]	;ACs automatically retored on return
File 1)	DSK:SPROUT.MAC[10,7,GALAXY]        	created: 1447 14-Nov-83
File 2)	DSK:SPROUT.MAC[10,10,CCUSPS,SPROUT]	created: 1905 19-Mar-84

2)	; Repeat the byte in AC 'C'
2)	; Call:	MOVE	S1,repeat count
2)	;	MOVE	C,byte to output
2)	;	PUSHJ	P,PTPREP
2)	;
2)	PTPREP:	$SAVE	<P1>		;[CSM]	;Save P1
2)		MOVE	P1,S1			;GET COUNT
2)		PUSHJ	P,PTPBYT		;OUTPUT A BYTE
2)		SOJG	P1,.-1			;AND LOOP
2)		POPJ	P,			;RETURN
**************
1)115	;HERE TO DISPATCH TO A processing ROUTINE BASED ON FILE MODE.
****
2)122			PAGE
2)		CSMEDT	07,6	;QUEUE defaults, part 6 before DSPMOD:
2)	IFE CSM07$,<
2)	;HERE TO DISPATCH TO A processing ROUTINE BASED ON FILE MODE.
**************
1)115	BADMOD:	MOVEI	S1,[ITEXT (<Illegal file mode ^O/T2/>)]
****
2)122	>  ;End of IFE CSM07$
2)	BADMOD:	MOVEI	S1,[ITEXT (<Illegal file mode ^O/T2/>)]
**************
1)123	SPOEND::END	SPROUT
****
2)130	LITS:	XLIST	;[CSM] Literals
2)		LIT	;[CSM]
2)		LIST	;[CSM]
2)	SPOEND::END	SPROUT
**************
   
