IDENTIFICATION DIVISION.
PROGRAM-ID. EXETER.
AUTHOR. KAY R. FISHER ... DEC
DATE-COMPILED. 
ENVIRONMENT DIVISION.
CONFIGURATION SECTION.
SOURCE-COMPUTER. DECSYSTEM-10.
OBJECT-COMPUTER. DECSYSTEM-10.
DATA DIVISION.
WORKING-STORAGE SECTION.
77 YES-OR-NO-ANSWER PICTURE AAA.
*USED FOR BASE OF RANDOM NUMBER GENERATOR
77	MULTIPLIER PICTURE 9(6) VALUE 262147.
*VALUE RETURNED BY RANDOM NUMBER GENERATOR
77	RAN PICTURE 99.
*BEGINNING OF RANDON NUMBER GENERATOR SEQUENCE IS BASED ON THIS NUMBER
77	SEED PICTURE 9(6) VALUE ZEROS.
77	TEMP1 PICTURE 9(6).
77	TEMP2 PICTURE 9(6).
77	CONDITION PICTURE A(6) JUSTIFIED RIGHT.
77	TORPEDO-COUNTER PICTURE 99.
77	DISPLAY-TORPEDO-COUNTER		PICTURE	Z9.
77	SHIELD-ENERGY			PICTURE	S9999.
77	DISPLAY-SHIELD-ENERGY		PICTURE	ZZZ9.
77	DAMAGE-WARP-DRIVE		PICTURE S99V999.
77	DAMAGE-SHORT-RANGE-SENSORS	PICTURE S99V999.
77	DAMAGE-LONG-RANGE-SENSORS	PICTURE S99V999.
77	DAMAGE-PHASERS			PICTURE S99V999.
77	DAMAGE-PHOTON-TUBES		PICTURE S99V999.
77	DAMAGE-DAMAGE-CONTROL		PICTURE S99V999.
77	DAMAGE-SHIELDS			PICTURE S99V999.
77	DAMAGE-COMPUTER			PICTURE S99V999.
77	STARDATE			PICTURE S9999V9.
77	DISPLAY-STARDATE		PICTURE	ZZZ9.9.
77	STARDATES-LEFT			PICTURE S9999V9.
77	TOTAL-ENERGY			PICTURE S9999.
77	DISPLAY-TOTAL-ENERGY		PICTURE	----9.
77	NCC-1706-QUADRANT-X		PICTURE	S999.
77	NCC-1706-QUADRANT-Y		PICTURE	S999.
77	NCC-1706-SECTOR-X		PICTURE	9.
77	NCC-1706-SECTOR-Y		PICTURE	9.
77	TOTAL-KLINGONS			PICTURE 999.
77	KLINGONS-LEFT			PICTURE 999.
77	TOTAL-STARBASES			PICTURE 99.
77	STARBASES-LEFT			PICTURE 99.
77	DOCK-TEST-X			PICTURE	S9.
77	DOCK-TEST-Y			PICTURE	S9.
77	COMMAND				PICTURE 99.
77	COURSE				PICTURE S9999V999999.
77	VECTOR				PICTURE	S9999V999999.
77	WARP-FACTOR			PICTURE	S99V999999.
77	WARP				PICTURE	S99V999999.
77	HIT				PICTURE	999V999999.
77	DISPLAY-HIT			PICTURE Z99.
77	DISTANCE			PICTURE	999V999999.
77	WARP-ENERGY			PICTURE	S9999.
77	MOVE-DISTANCE			PICTURE	S99.
77	WHO-GOT-HIT			PICTURE	9.
77	DAMAGE				PICTURE	9V999.
77	REPAIR				PICTURE	9V999.
77	X1				PICTURE	S9V999.
77	X2				PICTURE	S9V999.
77	INT-VECTOR			PICTURE	9.
77	INT1-VECTOR			PICTURE	S99.
77	I	PICTURE		9.
77	J	PICTURE		9.
77	X				PICTURE		S999.
77	Y				PICTURE		S999.
77	REAL-X				PICTURE		S999V999999.
77	REAL-Y				PICTURE		S999V999999.
77	STARS-IN-PRESENT-SECTOR		PICTURE		9.
77	KLINGONS-IN-PRESENT-SECTOR	PICTURE		9.
77	STARBASE-IN-PRESENT-SECTOR	PICTURE		9.
77	TEMP-1				PICTURE		9.
77	TEMP-2				PICTURE		99.
77	TEMP-3				PICTURE		999.
77	TEMP-4				PICTURE		S9999V999999.
77	FIRE-POWER			PICTURE		S9999V999999.
77	EFFICIENCY-RATING		PICTURE		S9999V99.
77	TIME-OF-MISSION			PICTURE		S9999V9.
77	STARBASES-DESTROYED		PICTURE		99.
77	DAMAGE-SEVERITY-FACTOR		PICTURE		S9999V99.
77	SUM-OF-PHASER-HITS		PICTURE		9999999.
77	STARBASE-VISITS			PICTURE		999.
77	NAVIGATION-ERRORS		PICTURE		999.
77	TORPEDO-MISSES			PICTURE		999.
77	MISS-FACTOR1			PICTURE		S999.
77	MISS-FACTOR2			PICTURE		S999.
77	PICTURE-GALACTIC-RECORD		PICTURE		XXX.
77	SOURCE-X			PICTURE		S999V999999.
77	SOURCE-Y			PICTURE		S999V999999.
77	DESTINATION-X			PICTURE		S999V999999.
77	DESTINATION-Y			PICTURE		S999V999999.
*THIS IS THE MEAT OF RAYMOND FUSCI'S FAMOUS
*FLOATING COMMA ROUTINE.
01	DISPLAY-QUADRANT.
	03 DISPLAY-Y		PICTURE	-(8)9.
	03 DUMMY-1 REDEFINES DISPLAY-Y.
	   05 DISPLAY-X-1	PICTURE	-(6)9,.
	   05 FILLER		PICTURE	X.
	03 DUMMY-2 REDEFINES DISPLAY-Y.
	   05 DISPLAY-X-2	PICTURE	-(5)9,.
	   05 FILLER		PICTURE	XX.
	03 DUMMY-3 REDEFINES DISPLAY-Y.
	   05 DISPLAY-X-3	PICTURE	-(4)9,.
	   05 FILLER		PICTURE	XXX.
	03 DUMMY-4 REDEFINES DISPLAY-Y.
	   05 DISPLAY-X-4	PICTURE	---9,.
	   05 FILLER		PICTURE	XXXX.
01	KLINGON-ONE.
	02	ENERGY		PICTURE		S999V9.
	02	X-COORD		PICTURE		9.
	02	Y-COORD		PICTURE		9.
01	KLINGON-TWO.
	02	ENERGY		PICTURE		S999V9.
	02	X-COORD		PICTURE		9.
	02	Y-COORD		PICTURE		9.
01	KLINGON-THREE.
	02	ENERGY		PICTURE		S999V9.
	02	X-COORD		PICTURE		9.
	02	Y-COORD		PICTURE		9.
01	MASTER-GALAXY-LAYOUT.
	02 FILLER OCCURS 8 TIMES.
	03 MASTER-GALAXY OCCURS 8 TIMES
				PICTURE		999.
77	DISPLAY-MASTER-GALAXY 		PICTURE		XXX.
01	COMPUTER-GALACTIC-RECORD.
	02 FILLER OCCURS 8 TIMES.
	03 GALACTIC-RECORD OCCURS 8 TIMES
				PICTURE		999.
77	DISPLAY-GALACTIC-RECORD		PICTURE		XXX.
01	PRESENT-SECTOR-LAYOUT.
	02 FILLER OCCURS 8 TIMES.
	03 PRESENT-SECTOR OCCURS 8 TIMES
				PICTURE		AAA.
01	COURSE-ARRAY.
	02 FILLER OCCURS 9 TIMES.
	03 CHART OCCURS 2 TIMES
					PICTURE		S9.
PROCEDURE DIVISION.
MAIN SECTION.
SEE-IF-HE-WANTS-INSTRUCTIONS.
	DISPLAY '		***********************************'.
	DISPLAY '		* UNITED FEDERATION OF PLANETS    *'.
	DISPLAY '		* STARFLEET COMMAND		  *'.
	DISPLAY '		* FLEET OFFICER TRAINING ACADEMY  *'.
	DISPLAY '		* TRAINING PROGRAM 16G.4	  *'.
	DISPLAY '		* COBOL VERSION BY KAY R. FISHER  *'.
	DISPLAY '		***********************************'.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY 'DO YOU WANT INSTRUCTIONS (THEY ARE LONG)? ' WITH NO ADVANCING.
WAITING-FOR-ANSWER.
	ACCEPT YES-OR-NO-ANSWER.
	IF YES-OR-NO-ANSWER EQUALS 'YES' OR 'Y'
	 GO TO INSTRUCTION-SECTION.
	IF YES-OR-NO-ANSWER EQUALS 'NO' OR 'N'
	 GO TO BEGIN-NEW-CONTEST.
	DISPLAY 'PLEASE ANSWER YES OR NO!'.
	DISPLAY 'DO YOU WANT INSTRUCTIONS (THEY ARE LONG)? ' WITH NO ADVANCING.
	GO TO WAITING-FOR-ANSWER.
INSTRUCTION-SECTION.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY '      INSTRUCTIONS'.
	DISPLAY ' '.
	DISPLAY 'THIS IS A SIMULATION PROGRAM DESIGNED TO MEASURE'.
	DISPLAY 'YOUR ABILITY TO (1) UTILIZE AVAILABLE RESOURCES.'.
	DISPLAY '(2) NAVIGATE A STARSHIP.  (3) ENGAGE IN THEORETICAL'.
	DISPLAY 'COMBAT.  AND (4) CORRECTLY AND EFFICIENTLY'.
	DISPLAY 'RESPOND TO THE UNKNOWN.'.
	DISPLAY ' '.
	DISPLAY 'YOUR EFFICIENCY RATING ON THIS EXAM WILL BECOME A'.
	DISPLAY 'PERMINENT PART OF YOUR SERVICE RECORD AND'.
	DISPLAY 'WILL BE CONSIDERED DURING BOARDS CONVENING'.
	DISPLAY 'FOR PROMOTION AND ASSIGNMENT.'.
	DISPLAY ' '.
	DISPLAY 'SHOULD YOU SUCCEED IN YOUR MISSION AND YOUR EFFICIENCY'.
	DISPLAY 'RATING IS WITHIN THE TOP 5 EVER RECORDED - YOU WILL'.
	DISPLAY 'RECEIVE A SPECIAL COMMENDATION AND YOUR NAME'.
	DISPLAY 'WILL BECOME A PERMINENT PART OF THIS PROGRAM.'
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY '	PROGRAM 16G.4 HONOR RECORD'.
	DISPLAY '	******************************************'.
	DISPLAY '	NAME			ASSIGNMENT'.
	DISPLAY '	CHRISTOPHER PIKE	STARFLEET ADMIRAL (RETIRED)'.
	DISPLAY '	JAMES T. KIRK		COMMANDING USS ENTERPRISE'.
	DISPLAY '	TOM SPEAKE		INSTRUCTOR - DEC'.
	DISPLAY '	KAY R. FISHER		PROGRAMMER - DEC'.
	DISPLAY '	BILL WALKER		COURSE DEVELOPER - DEC'.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY 'I.	YOU ARE THEREFORE POSTED, EFFECTIVE IMMEDIATELY,'.
	DISPLAY '	TO COMMAND THE FOLLOWING:'.
	DISPLAY '		THE U.S.S. EXETER'.
	DISPLAY '		STARSHIP CLASS - GROSS 190,000 TONS'.
	DISPLAY '		CREW COMPLEMENT - 430 PERSONS'.
	DISPLAY '		DRIVE - SPACE-WARP'.
	DISPLAY '		RANGE - 18 YEARS AT LIGHT-YEAR VELOCITY'.
	DISPLAY '		REGISTRY - EARTH, UNITED SPACESHIP'.
	DISPLAY ' '.
	DISPLAY 'II.	NATURE AND DURATION OF MISSION:'.
	DISPLAY "	SEEK OUT AND DESTROY ALL ENEMY KLINGON VESSEL'S,".
	DISPLAY '	WITHIN 30 STARDATES.'.
	DISPLAY ' '.
	DISPLAY 'III.	YOU WILL PATROL THE NINTH FEDERAL GALAXY, BEGINNING'.
	DISPLAY '	WITH ALPHA CENTAURI AND EXTENDING TO THE OUTER'.
	DISPLAY '	PINIAL GALAXY LIMIT.'.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY 'THE GALAXY IS DIVIDED INTO AN 8,8 QUADRANT GRID'.
	DISPLAY 'THE CAST OF CHARACTERS IS AS FOLLOWS:'.
	DISPLAY '<*> = EXETER'.
	DISPLAY '+++ = KLINGON'.
	DISPLAY '>!< = STARBASE'.
	DISPLAY ' *  = STAR'.
	DISPLAY ' '.
	DISPLAY 'COMMAND 0 = WARP ENGINE CONTROL:'.
	DISPLAY '  COURSE IS IN A CIRCULAR NUMERICAL        360'.    
	DISPLAY '  VECTOR ARRANGEMENT AS SHOWN.              !'.
	DISPLAY '  INTEGER AND REAL VALUES MAY BE            !'.
	DISPLAY '  USED.  THEREFORE COURSE 90.5 IS     270 ----- 90'.
	DISPLAY '  HALF WAY BETWEEN 90 AND 91.               !'.
	DISPLAY '  A VECTOR OF 360 IS THE SAME AS 0.         !'.
	DISPLAY '  ONE WARP FACTOR IS THE SPEED OF          180'.
	DISPLAY '  LIGHT. HOWEVER WARP 3 = 27 TIMES THE'.
	DISPLAY '  SPEED OF LIGHT & MAX SPEED (WARP 8) IS EQUAL TO'.
	DISPLAY '  512 TIMES THE SPEED OF LIGHT.  WARP TO THE 3RD'.
	DISPLAY '  POWER GIVES SPEED RELATIVE TO LIGHT.  A ONE QUADRANT'.
	DISPLAY '  MOVE REQUIRES A WARP FACTOR OF 4.  THEREFORE TO GET'.
	DISPLAY '  FROM QUADRANT 6,5 TO 5,5 YOU WOULD'.
	DISPLAY '  USE COURSE 0. WARP FACTOR 4.'.
	DISPLAY ' '.
	DISPLAY 'COMMAND 1 = SHORT RANGE SENSOR SCAN'.
	DISPLAY '  PRINTS THE QUADRANT YOU ARE CORRENTLY IN.  INCLUDING'.
	DISPLAY '  STARS, KLINGONS, STARBASES, AND THE EXETER.'.
	DISPLAY '  ALONG WITH OTHER PERTINATE INFORMATION.'.
	DISPLAY ' '.
	DISPLAY 'COMMAND 2 = LONG RANGE SENSOR SCAN'.
	DISPLAY '  SHOWS CONDITIONS IN SPACE FOR ONE QUADRANT ON EACH SIDE'.
	DISPLAY '  OF THE EXETER IN THE MIDDLE OF THE SCAN.  THE SCAN'.
	DISPLAY '  IS CODED IN THE FORM "KBS", WHERE K IS THE NUMBER'.
	DISPLAY '  OF KLINGONS, B IS THE NUMBER OF STARBASES, AND S IS'.
	DISPLAY '  THE NUMBER OF STARS.'.
	DISPLAY ' '.
	DISPLAY 'COMMAND 3 = PHASER CONTROL'.
	DISPLAY '  ALLOWS YOU TO DESTROY THE KLINGONS BY HITTING THEM WITH'.
	DISPLAY '  SUITABLY LARGE NUMBERS OF ENERGY UNITS TO DEPLETE THEIR'.
	DISPLAY '  SHIELD POWER.  KEEP IN MIND THAT WHEN YOU SHOOT AT THEM.'.
	DISPLAY '  THEY GONNA SHOOT AT YOU, TOO!'.
	DISPLAY ' '.
	DISPLAY 'COMMAND 4 = PHOTON TORPEDO CONTROL'
	DISPLAY '  COURSE IS THE SAME AS USED IN WARP ENGINE CONTROL.'
	DISPLAY '  IF YOU HIT THE KLINGON, HE IS DESTROYED AND CANNOT FIRE'
	DISPLAY '  BACK AT YOU.  IF YOU MISS, YOU ARE SUBJECT TO HIS'
	DISPLAY '  PHASER FIRE.'
	DISPLAY '  NOTE:  THE LIBRARY COMPUTER (COMMAND 7) HAS AN OPTION'
	DISPLAY '  TO COMPUTE TORPEDO TRAJECTORY FOR YOU (OPTION 2).'
	DISPLAY ' '.
	DISPLAY 'COMMAND 5 = SHIELD CONTROL'
	DISPLAY '  DEFINES NUMBER OF ENERGY UNITS TO BE ASSIGNED TO SHIELDS.'
	DISPLAY "  ENERGY IS TAKEN FORM TOTAL SHIP'S ENERGY."
	DISPLAY '  NOTE:  TOTAL ENERGY INCLUDES SHIELD ENERGY.'
	DISPLAY ' '.
	DISPLAY 'COMMAND 6 = DAMAGE CONTROL REPORT'
	DISPLAY '  GIVES THE STATE OF REPAIRS OF ALL DEVICES.  A STATE OF REPAIR'
	DISPLAY '  LESS THAN ZERO SHOWS THAT THE DEVICE IS TEMPORALLY'
	DISPLAY '  DAMAGED.'
	DISPLAY ' '.
	DISPLAY 'COMMAND 7 = LIBRARY COMPUTER'
	DISPLAY '  THE LIBRARY COMPUTER CONTAINS THREE OPTIONS:'
	DISPLAY '    OPTION 0 = CUMULATIVE GALACTIC RECORD'
	DISPLAY '      WHICH SHOWS COMPUTER MEMORY OF THE RESULTS'
	DISPLAY '      OF ALL PREVIOUS LONG RANGE SENSOR SCANS.'
	DISPLAY '    OPTION 1 = STATUS REPORT'
	DISPLAY '      WHICH SHOWS IMPORTANT INFORMATION REGARDING THE'
	DISPLAY '      STATUS OF YOUR MISSION (EFFICIENCY RATING).'.
	DISPLAY '    OPTION 2 = PHOTON TORPEDO DATA'
	DISPLAY '      GIVES TRAJECTORY AND DISTANCE BETWEEN THE'
	DISPLAY '      EXETER AND ALL KLINGONS IN YOUR QUADRANT'
	DISPLAY '    OPTION 3 = CALCULATOR'
	DISPLAY '      CAN BE USED TO AID NAVIGATION OR DOCKING.'
	DISPLAY '      ENTER COORDINATES (QUADRANT OR SECTOR)'
	DISPLAY '      OF THE SHIP AND TARGET - IN SOURCE, DESTINATION'
	DISPLAY '      FORMAT - EG...S,S,T,T'
	DISPLAY ' '.
	DISPLAY 'COMMAND 8 = BEGIN NEW CONTEST'
	DISPLAY '  STARTS PROGRAM OVER AGAIN WITH ALL NEW DATA.'
	DISPLAY '  USED TO CREATE MORE CHALLENGING SETUP - IE: MORE'
	DISPLAY '  KLINGONS AND FEWER STARBASES!'
	DISPLAY ' '.
	DISPLAY ' '.
BEGIN-NEW-CONTEST.
*SET UP THE RANDOM NUMBER GENERATOR
	MOVE TODAY TO SEED.
	PERFORM RANDOMIZE.
	MOVE 10 TO TORPEDO-COUNTER.
	MOVE 30 TO STARDATES-LEFT.
	MOVE 3000 TO TOTAL-ENERGY
		     WARP-ENERGY.
	MOVE ZEROS TO 
		SHIELD-ENERGY
		DAMAGE-WARP-DRIVE
		DAMAGE-SHORT-RANGE-SENSORS
		DAMAGE-LONG-RANGE-SENSORS
		DAMAGE-PHASERS
		DAMAGE-PHOTON-TUBES
		DAMAGE-DAMAGE-CONTROL
		DAMAGE-SHIELDS
		DAMAGE-COMPUTER
		DAMAGE-SEVERITY-FACTOR
		KLINGON-ONE
		KLINGON-TWO
		KLINGON-THREE
		SUM-OF-PHASER-HITS
		MASTER-GALAXY-LAYOUT
		NAVIGATION-ERRORS
		TORPEDO-MISSES
		TOTAL-KLINGONS
		KLINGONS-LEFT
		TOTAL-STARBASES
		COMPUTER-GALACTIC-RECORD
		STARBASES-LEFT
		STARBASE-VISITS.
	MOVE SPACES TO
		PRESENT-SECTOR-LAYOUT.
*SET UP THE NAVIGATION CHART.
	MOVE -1 TO	CHART (2,1)
			CHART (3,1)
			CHART (4,1)
			CHART (4,2)
			CHART (5,2)
			CHART (6,2).
	MOVE 0 TO	CHART (1,1)
			CHART (3,2)
			CHART (5,1)
			CHART (7,2)
			CHART (9,1).
	MOVE 1 TO	CHART (1,2)
			CHART (2,2)
			CHART (6,1)
			CHART (7,1)
			CHART (8,1)
			CHART (8,2)
			CHART (9,2).
*PUT THE USS EXETER SOMEWHERE.
	PERFORM RANDOMIZE.
	COMPUTE NCC-1706-QUADRANT-X = (RAN + 12.4) / 12.4.
	PERFORM RANDOMIZE.
	COMPUTE NCC-1706-QUADRANT-Y = (RAN + 12.4) / 12.4.
	PERFORM RANDOMIZE.
	COMPUTE NCC-1706-SECTOR-X   = (RAN + 12.4) / 12.4.
	PERFORM RANDOMIZE.
	COMPUTE NCC-1706-SECTOR-Y   = (RAN + 12.4) / 12.4.
*SET UP GALAXY.
	MOVE 1 TO I, J.
KLINGON-GENERATOR.
	PERFORM RANDOMIZE.
	IF RAN > 97
		MOVE 300 TO MASTER-GALAXY (I,J)
		ADD 3 TO TOTAL-KLINGONS
		GO TO STARBASE-GENERATOR.
	IF RAN > 94
		MOVE 200 TO MASTER-GALAXY (I,J)
		ADD 2 TO TOTAL-KLINGONS
		GO TO STARBASE-GENERATOR.
	IF RAN > 79
		MOVE 100 TO MASTER-GALAXY (I,J)
		ADD 1 TO TOTAL-KLINGONS.
STARBASE-GENERATOR.
	PERFORM RANDOMIZE.
	IF RAN > 95
		ADD 10 TO MASTER-GALAXY (I,J)
		ADD 1 TO TOTAL-STARBASES
			 STARBASES-LEFT.
	PERFORM RANDOMIZE.
	COMPUTE X = (RAN + 12.4) / 12.4.
	ADD X TO MASTER-GALAXY (I,J).
	ADD 1 TO J.
	IF J < 9 GO TO KLINGON-GENERATOR.
	MOVE 1 TO J.
	ADD 1 TO I.
	IF I < 9 GO TO KLINGON-GENERATOR.
	MOVE TOTAL-KLINGONS TO KLINGONS-LEFT.
	IF TOTAL-STARBASES = ZERO
		PERFORM RANDOMIZE
		COMPUTE I = (RAN + 12.4) / 12.4
		PERFORM RANDOMIZE
		COMPUTE J = (RAN + 12.4) / 12.4
		ADD 10 TO MASTER-GALAXY (I,J)
		MOVE 1 TO TOTAL-STARBASES
			  STARBASES-LEFT.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY 'YOU MUST DESTROY ' TOTAL-KLINGONS 
		' KLINGONS IN 30 STARDATES WITH ' TOTAL-STARBASES 
		' STARBASES!!!!'.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY ' '.
	PERFORM RANDOMIZE.
	COMPUTE STARDATE = ((RAN / 5) + 20) * 100
STARSHIP-PLACEMENT.
*THIS CHECKS TO MAKE SURE WE ARE IN OUR ASSIGNED
*REGION OF THE GALAXY.
	IF NCC-1706-QUADRANT-X < 1 OR > 8
		MOVE ZEROS TO	STARS-IN-PRESENT-SECTOR
				STARBASE-IN-PRESENT-SECTOR
				KLINGONS-IN-PRESENT-SECTOR
		GO TO EMPTY-SPACE.
	IF NCC-1706-QUADRANT-Y < 1 OR > 8
		MOVE ZEROS TO	STARS-IN-PRESENT-SECTOR
				STARBASE-IN-PRESENT-SECTOR
				KLINGONS-IN-PRESENT-SECTOR
		GO TO EMPTY-SPACE.
	MOVE MASTER-GALAXY (NCC-1706-QUADRANT-X,NCC-1706-QUADRANT-Y)
		TO STARS-IN-PRESENT-SECTOR, TEMP-3, TEMP-2.
	DIVIDE TEMP-2 BY 10 GIVING STARBASE-IN-PRESENT-SECTOR.
	DIVIDE TEMP-3 BY 100 GIVING KLINGONS-IN-PRESENT-SECTOR.
	IF KLINGONS-IN-PRESENT-SECTOR = ZERO GO TO EMPTY-SPACE.
	IF SHIELD-ENERGY < 201
		DISPLAY ' '
		DISPLAY ' '
		DISPLAY '   SHIELDS DANGEROUSLY LOW'.
	DISPLAY ' '.
	DISPLAY 'COMBAT AREA      CONDITION RED'.
EMPTY-SPACE.
	MOVE ZEROS TO
		KLINGON-ONE
		KLINGON-TWO
		KLINGON-THREE.
*PUT THE EXETER SOMEWHERE.
	MOVE SPACES TO PRESENT-SECTOR-LAYOUT.
	MOVE '<*>' TO PRESENT-SECTOR (NCC-1706-SECTOR-X,NCC-1706-SECTOR-Y).
	MOVE 1 TO I.
	IF KLINGONS-IN-PRESENT-SECTOR = ZERO GO TO STARBASE-INSERTION.
KLINGON-INSERTION.
	PERFORM RANDOMIZE.
	COMPUTE X = (RAN + 12.4) / 12.4.
	PERFORM RANDOMIZE.
	COMPUTE Y = (RAN + 12.4) / 12.4.
	IF PRESENT-SECTOR (X,Y) IS NOT = SPACES GO TO KLINGON-INSERTION.
	MOVE '+++' TO PRESENT-SECTOR (X,Y).
	IF I = 1
		MOVE 200 TO ENERGY OF KLINGON-ONE
		MOVE X TO X-COORD OF KLINGON-ONE
		MOVE Y TO Y-COORD OF KLINGON-ONE.
	IF I = 2
		MOVE 200 TO ENERGY OF KLINGON-TWO
		MOVE X TO X-COORD OF KLINGON-TWO
		MOVE Y TO Y-COORD OF KLINGON-TWO.
	IF I = 3
		MOVE 200 TO ENERGY OF KLINGON-THREE
		MOVE X TO X-COORD OF KLINGON-THREE
		MOVE Y TO Y-COORD OF KLINGON-THREE.
	ADD 1 TO I
	IF I IS NOT > KLINGONS-IN-PRESENT-SECTOR GO TO KLINGON-INSERTION.
	MOVE 1 TO I.
STARBASE-INSERTION.
	IF STARBASE-IN-PRESENT-SECTOR = ZERO GO TO STAR-INSERTION.
	PERFORM RANDOMIZE.
	COMPUTE X = (RAN + 12.4) / 12.4.
	PERFORM RANDOMIZE.
	COMPUTE Y = (RAN + 12.4) / 12.4.
	IF PRESENT-SECTOR (X,Y) IS NOT = SPACES GO TO STARBASE-INSERTION.
	MOVE '>!<' TO PRESENT-SECTOR (X,Y).
STAR-INSERTION.
	IF STARS-IN-PRESENT-SECTOR = ZERO GO TO DOCK-SCAN.
	PERFORM RANDOMIZE.
	COMPUTE X = (RAN + 12.4) / 12.4.
	PERFORM RANDOMIZE.
	COMPUTE Y = (RAN + 12.4) / 12.4.
	IF PRESENT-SECTOR (X,Y) IS NOT = SPACES GO TO STAR-INSERTION.
	MOVE ' * ' TO PRESENT-SECTOR (X,Y).
	ADD 1 TO I
	IF I IS NOT > STARS-IN-PRESENT-SECTOR GO TO STAR-INSERTION.
DOCK-SCAN.
	MOVE -1 TO X, Y.
	MOVE NCC-1706-SECTOR-X TO DOCK-TEST-X.
	MOVE NCC-1706-SECTOR-Y TO DOCK-TEST-Y.
	SUBTRACT 1 FROM DOCK-TEST-X
			DOCK-TEST-Y.
CHECK-FOR-DOCKING.
	IF DOCK-TEST-X < 1 OR > 8 GO TO DOCKING-LOOP.
	IF DOCK-TEST-Y < 1 OR > 8 GO TO DOCKING-LOOP.
	IF PRESENT-SECTOR (DOCK-TEST-X,DOCK-TEST-Y)
		IS NOT EQUAL '>!<' GO TO DOCKING-LOOP.
DOCKING-PROCEDURE.
	ADD 1 TO STARBASE-VISITS.
	MOVE 'DOCKED' TO CONDITION.
	MOVE 3000 TO TOTAL-ENERGY
		     WARP-ENERGY.
	MOVE ZERO TO SHIELD-ENERGY.
	MOVE 10 TO TORPEDO-COUNTER.
	IF DAMAGE-WARP-DRIVE IS NEGATIVE
		MOVE ZERO TO DAMAGE-WARP-DRIVE.
	IF DAMAGE-SHORT-RANGE-SENSORS IS NEGATIVE
		MOVE ZERO TO DAMAGE-SHORT-RANGE-SENSORS.
	IF DAMAGE-LONG-RANGE-SENSORS IS NEGATIVE
		MOVE ZERO TO DAMAGE-LONG-RANGE-SENSORS.
	IF DAMAGE-PHASERS IS NEGATIVE
		MOVE ZERO TO DAMAGE-PHASERS.
	IF DAMAGE-PHOTON-TUBES IS NEGATIVE
		MOVE ZERO TO DAMAGE-PHOTON-TUBES.
	IF DAMAGE-DAMAGE-CONTROL IS NEGATIVE
		MOVE ZERO TO DAMAGE-DAMAGE-CONTROL.
	IF DAMAGE-SHIELDS IS NEGATIVE
		MOVE ZERO TO DAMAGE-SHIELDS.
	IF DAMAGE-COMPUTER IS NEGATIVE
		MOVE ZERO TO DAMAGE-COMPUTER.
	DISPLAY ' '.
	DISPLAY 'SHIELDS DROPPED FOR DOCKING PURPOSES'.
	GO TO SHORT-RANGE-SENSOR-SCAN.
DOCKING-LOOP.
	ADD 1 TO Y
		DOCK-TEST-Y.
	IF Y > 1
		MOVE -1 TO Y
		SUBTRACT 1 FROM NCC-1706-SECTOR-Y GIVING DOCK-TEST-Y
		ADD 1 TO X
			DOCK-TEST-X.
	IF X < 2 GO TO CHECK-FOR-DOCKING.
	IF KLINGONS-IN-PRESENT-SECTOR > 0
		MOVE 'RED' TO CONDITION
		GO TO SHORT-RANGE-SENSOR-SCAN.
	IF TOTAL-ENERGY < 300
		MOVE 'YELLOW' TO CONDITION
		ELSE MOVE 'GREEN' TO CONDITION.
SHORT-RANGE-SENSOR-SCAN.
	IF DAMAGE-SHORT-RANGE-SENSORS < 0
		DISPLAY ' '
		DISPLAY '*** SHORT RANGE SENSORS ARE OUT ***'
		DISPLAY ' '
		GO TO HELL.
	DISPLAY ' '.
	DISPLAY 'SHORT RANGE SENSOR SCAN'.
	DISPLAY '------------------------'.
	MOVE STARDATE TO DISPLAY-STARDATE.
	DISPLAY PRESENT-SECTOR (1,1)
		PRESENT-SECTOR (1,2)
		PRESENT-SECTOR (1,3)
		PRESENT-SECTOR (1,4)
		PRESENT-SECTOR (1,5)
		PRESENT-SECTOR (1,6)
		PRESENT-SECTOR (1,7)
		PRESENT-SECTOR (1,8)
		'      STARDATE     '
		DISPLAY-STARDATE.
	DISPLAY PRESENT-SECTOR (2,1)
		PRESENT-SECTOR (2,2)
		PRESENT-SECTOR (2,3)
		PRESENT-SECTOR (2,4)
		PRESENT-SECTOR (2,5)
		PRESENT-SECTOR (2,6)
		PRESENT-SECTOR (2,7)
		PRESENT-SECTOR (2,8)
		'      CONDITION    '
		CONDITION.
*RAYMOND FUSCI'S FAMOUS FLOATING COMMA ROUTINE.
	MOVE NCC-1706-QUADRANT-Y TO DISPLAY-Y.
		IF DISPLAY-X-1 EQUALS SPACES
			MOVE NCC-1706-QUADRANT-X TO DISPLAY-X-1
			GO TO RAYS-FLOATING-COMMA-BYPASS.
		IF DISPLAY-X-2 EQUALS SPACES
			MOVE NCC-1706-QUADRANT-X TO DISPLAY-X-2
			GO TO RAYS-FLOATING-COMMA-BYPASS.
		IF DISPLAY-X-3 EQUALS SPACES
			MOVE NCC-1706-QUADRANT-X TO DISPLAY-X-3
			GO TO RAYS-FLOATING-COMMA-BYPASS.
		MOVE NCC-1706-QUADRANT-X TO DISPLAY-X-4.
RAYS-FLOATING-COMMA-BYPASS.
	DISPLAY PRESENT-SECTOR (3,1)
		PRESENT-SECTOR (3,2)
		PRESENT-SECTOR (3,3)
		PRESENT-SECTOR (3,4)
		PRESENT-SECTOR (3,5)
		PRESENT-SECTOR (3,6)
		PRESENT-SECTOR (3,7)
		PRESENT-SECTOR (3,8)
		'      QUADRANT  '
		DISPLAY-QUADRANT.
	DISPLAY PRESENT-SECTOR (4,1)
		PRESENT-SECTOR (4,2)
		PRESENT-SECTOR (4,3)
		PRESENT-SECTOR (4,4)
		PRESENT-SECTOR (4,5)
		PRESENT-SECTOR (4,6)
		PRESENT-SECTOR (4,7)
		PRESENT-SECTOR (4,8)
		'      SECTOR          '
		NCC-1706-SECTOR-X
		','
		NCC-1706-SECTOR-Y.
	MOVE TOTAL-ENERGY TO DISPLAY-TOTAL-ENERGY.
	DISPLAY PRESENT-SECTOR (5,1)
		PRESENT-SECTOR (5,2)
		PRESENT-SECTOR (5,3)
		PRESENT-SECTOR (5,4)
		PRESENT-SECTOR (5,5)
		PRESENT-SECTOR (5,6)
		PRESENT-SECTOR (5,7)
		PRESENT-SECTOR (5,8)
		'      TOTAL ENERGY  '
		DISPLAY-TOTAL-ENERGY.
	MOVE TORPEDO-COUNTER TO DISPLAY-TORPEDO-COUNTER.
	DISPLAY PRESENT-SECTOR (6,1)
		PRESENT-SECTOR (6,2)
		PRESENT-SECTOR (6,3)
		PRESENT-SECTOR (6,4)
		PRESENT-SECTOR (6,5)
		PRESENT-SECTOR (6,6)
		PRESENT-SECTOR (6,7)
		PRESENT-SECTOR (6,8)
		'      PHOTON TORPEDOS  '
		DISPLAY-TORPEDO-COUNTER.
	MOVE SHIELD-ENERGY TO DISPLAY-SHIELD-ENERGY.
	DISPLAY PRESENT-SECTOR (7,1)
		PRESENT-SECTOR (7,2)
		PRESENT-SECTOR (7,3)
		PRESENT-SECTOR (7,4)
		PRESENT-SECTOR (7,5)
		PRESENT-SECTOR (7,6)
		PRESENT-SECTOR (7,7)
		PRESENT-SECTOR (7,8)
		'      SHIELDS        '
		DISPLAY-SHIELD-ENERGY.
	DISPLAY PRESENT-SECTOR (8,1)
		PRESENT-SECTOR (8,2)
		PRESENT-SECTOR (8,3)
		PRESENT-SECTOR (8,4)
		PRESENT-SECTOR (8,5)
		PRESENT-SECTOR (8,6)
		PRESENT-SECTOR (8,7)
		PRESENT-SECTOR (8,8).
	DISPLAY '------------------------'.
HELL.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY 'COMMAND:' WITH NO ADVANCING.
	ACCEPT COMMAND.
	IF COMMAND EQUALS ZERO GO TO WARP-ENGINE-CONTROL.
	GO TO	SHORT-RANGE-SENSOR-SCAN
		LONG-RANGE-SENSOR-SCAN
		PHASER-CONTROL
		PHOTON-TORPEDO-CONTROL
		SHIELD-CONTROL
		DAMAGE-CONTROL-REPORT
		LIBRARY-COMPUTER
		BEGIN-NEW-CONTEST
			DEPENDING ON COMMAND.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY '0 = WARP ENGINE CONTROL'.
	DISPLAY '1 = SHORT RANGE SENSOR SCAN'.
	DISPLAY '2 = LONG RANGE SENSOR SCAN'.
	DISPLAY '3 = PHASER CONTROL'.
	DISPLAY '4 = PHOTON TORPEDO CONTROL'.
	DISPLAY '5 = SHIELD CONTROL'.
	DISPLAY '6 = DAMAGE CONTROL REPORT'.
	DISPLAY '7 = LIBRARY COMPUTER'.
	DISPLAY '8 = BEGIN NEW CONTEST'.
	GO TO HELL.
WARP-ENGINE-CONTROL.
	DISPLAY 'COURSE (0-360)? ' WITH NO ADVANCING.
	ACCEPT COURSE.
	IF COURSE < ZERO OR > 360 GO TO WARP-ENGINE-CONTROL.
*COMVERTIING THE COURSE TO INTERNAL FORMAT (1-9).
	COMPUTE VECTOR = 90 - COURSE.
	IF VECTOR IS NEGATIVE
		ADD 360 TO VECTOR.
	COMPUTE VECTOR = VECTOR / 45 + 1.
	DISPLAY 'WARP FACTOR (0-8)? ' WITH NO ADVANCING.
	ACCEPT WARP-FACTOR.
	IF WARP-FACTOR < ZERO OR > 8 GO TO HELL.
	IF DAMAGE-WARP-DRIVE IS NEGATIVE
		IF WARP-FACTOR > 1
			DISPLAY 'WARP DRIVE IS DISABLED!'
			DISPLAY 'IMPULSE ENGINES ACTIVATED'
			DISPLAY 'MAXIMUM SPEED = WARP 1'
			GO TO HELL.
*CONVERTING THE WARP FACTOR TO A CUBE CURVE FROM (0-8).
	COMPUTE WARP = WARP-FACTOR ** 3 / 64.
*THIS MAKES SURE THAT AT WARP 1 SOME MOVEMENT IS NOTICED.
	IF WARP < .1 AND > .0019
		MOVE .1 TO WARP.
	IF WARP < .2 AND > .1
		MOVE .2 TO WARP.
	IF KLINGONS-IN-PRESENT-SECTOR > ZERO
		PERFORM THE-ENEMY-SHOOTS-BACK.
	IF SHIELD-ENERGY IS NEGATIVE GO TO THE-EXETER-IS-DEAD.
	SUBTRACT SHIELD-ENERGY FROM TOTAL-ENERGY GIVING WARP-ENERGY.
	COMPUTE MOVE-DISTANCE = (WARP + .0625) * 8.
*DYLITHIUM CRYSTALS ARE RECHARGING
	ADD 5 TO WARP-ENERGY
		 TOTAL-ENERGY.
	SUBTRACT MOVE-DISTANCE FROM TOTAL-ENERGY
				    WARP-ENERGY.
	IF WARP-ENERGY > ZERO GO TO MR-SCOTT-DO-YOUR-THING.
	IF KLINGONS-IN-PRESENT-SECTOR EQUAL ZERO
		DISPLAY 'INSUFFICIENT ENERGY AVAILABLE FOR WARP FACTOR' 
			WARP-FACTOR
		ADD MOVE-DISTANCE TO WARP-ENERGY
				     TOTAL-ENERGY.
		GO TO HELL.
	DISPLAY 'THE EXETER IS DEAD IN SPACE.  IF YOU SURVIVE ALL IMPENDING'.
	DISPLAY 'ATTACKS YOU WILL BE DEMOTED TO THE RANK OF PRIVATE.'.
CERTAIN-DEATH-LOOP.
	PERFORM THE-ENEMY-SHOOTS-BACK.
	IF SHIELD-ENERGY IS NEGATIVE GO TO THE-EXETER-IS-DEAD.
	GO TO CERTAIN-DEATH-LOOP.
MR-SCOTT-DO-YOUR-THING.
	IF DAMAGE-WARP-DRIVE IS NEGATIVE
		ADD 1 TO DAMAGE-WARP-DRIVE.
	IF DAMAGE-SHORT-RANGE-SENSORS IS NEGATIVE
		ADD 1 TO DAMAGE-SHORT-RANGE-SENSORS.
	IF DAMAGE-LONG-RANGE-SENSORS IS NEGATIVE
		ADD 1 TO DAMAGE-LONG-RANGE-SENSORS.
	IF DAMAGE-PHASERS IS NEGATIVE
		ADD 1 TO DAMAGE-PHASERS.
	IF DAMAGE-PHOTON-TUBES IS NEGATIVE
		ADD 1 TO DAMAGE-PHOTON-TUBES.
	IF DAMAGE-DAMAGE-CONTROL IS NEGATIVE
		ADD 1 TO DAMAGE-DAMAGE-CONTROL.
	IF DAMAGE-SHIELDS IS NEGATIVE
		ADD 1 TO DAMAGE-SHIELDS.
	IF DAMAGE-COMPUTER IS NEGATIVE
		ADD 1 TO DAMAGE-COMPUTER.
	PERFORM RANDOMIZE.
	IF RAN > 19 GO TO ZERO-THE-SECTOR-WE-LEAVE.
	DISPLAY 'DAMAGE CONTROL REPORTS ' WITH NO ADVANCING.
	PERFORM RANDOMIZE.
	IF RAN > 49 GO TO GOOD-NEWS.
BAD-NEWS.
	DISPLAY 'DAMAGE TO ' WITH NO ADVANCING.
	PERFORM RANDOMIZE.
	COMPUTE WHO-GOT-HIT = (RAN + 12.4) / 12.4.
	PERFORM RANDOMIZE.
	COMPUTE DAMAGE = (RAN + 1) / 20.
	ADD DAMAGE TO DAMAGE-SEVERITY-FACTOR.
	GO TO BAD-NEWS-WARP-DRIVE
	      BAD-NEWS-SHORT-RANGE-SENSORS
	      BAD-NEWS-LONG-RANGE-SENSORS
	      BAD-NEWS-PHASERS
	      BAD-NEWS-PHOTON-TUBES
	      BAD-NEWS-DAMAGE-CONTROL
	      BAD-NEWS-SHIELDS
	      BAD-NEWS-COMPUTER
			DEPENDING ON WHO-GOT-HIT.
BAD-NEWS-WARP-DRIVE.
	DISPLAY 'WARP DRIVE.'.
	SUBTRACT DAMAGE FROM DAMAGE-WARP-DRIVE.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
BAD-NEWS-SHORT-RANGE-SENSORS.
	DISPLAY 'SHORT RANGE SENSORS.'.
	SUBTRACT DAMAGE FROM DAMAGE-SHORT-RANGE-SENSORS.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
BAD-NEWS-LONG-RANGE-SENSORS.
	DISPLAY 'LONG RANGE SENSORS.'.
	SUBTRACT DAMAGE FROM DAMAGE-LONG-RANGE-SENSORS.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
BAD-NEWS-PHASERS.
	DISPLAY 'PHASERS.'.
	SUBTRACT DAMAGE FROM DAMAGE-PHASERS.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
BAD-NEWS-PHOTON-TUBES.
	DISPLAY 'PHOTON TUBES.'.
	SUBTRACT DAMAGE FROM DAMAGE-PHOTON-TUBES.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
BAD-NEWS-DAMAGE-CONTROL.
	DISPLAY 'DAMAGE CONTROL.'.
	SUBTRACT DAMAGE FROM DAMAGE-DAMAGE-CONTROL.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
BAD-NEWS-SHIELDS.
	DISPLAY 'SHIELD CONTROL.'.
	SUBTRACT DAMAGE FROM DAMAGE-SHIELDS.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
BAD-NEWS-COMPUTER.
	DISPLAY 'COMPUTER.'.
	SUBTRACT DAMAGE FROM DAMAGE-COMPUTER.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
GOOD-NEWS.
	DISPLAY 'CONDITION IMPROVED ON ' WITH NO ADVANCING.
	PERFORM RANDOMIZE.
	COMPUTE WHO-GOT-HIT = (RAN + 12.4) / 12.4.
	PERFORM RANDOMIZE.
	COMPUTE REPAIR = (RAN + 1) / 20.
	ADD REPAIR TO DAMAGE-SEVERITY-FACTOR.
	GO TO	GOOD-NEWS-WARP-DRIVE
		GOOD-NEWS-SHORT-RANGE-SENSORS
		GOOD-NEWS-LONG-RANGE-SENSORS
		GOOD-NEWS-PHASERS
		GOOD-NEWS-PHOTON-TUBES
		GOOD-NEWS-DAMAGE-CONTROL
		GOOD-NEWS-SHIELDS
		GOOD-NEWS-COMPUTER
			DEPENDING ON WHO-GOT-HIT.
GOOD-NEWS-WARP-DRIVE.
	DISPLAY 'WARP DRIVE.'.
	ADD REPAIR TO DAMAGE-WARP-DRIVE.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
GOOD-NEWS-SHORT-RANGE-SENSORS.
	DISPLAY 'SHORT RANGE SENSORS.'.
	ADD REPAIR TO DAMAGE-SHORT-RANGE-SENSORS.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
GOOD-NEWS-LONG-RANGE-SENSORS.
	DISPLAY 'LONG RANGE SENSORS.'.
	ADD REPAIR TO DAMAGE-LONG-RANGE-SENSORS.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
GOOD-NEWS-PHASERS.
	DISPLAY 'PHASERS.'.
	ADD REPAIR TO DAMAGE-PHASERS.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
GOOD-NEWS-PHOTON-TUBES.
	DISPLAY 'PHOTON TUBES.'.
	ADD REPAIR TO DAMAGE-PHOTON-TUBES.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
GOOD-NEWS-DAMAGE-CONTROL.
	DISPLAY 'DAMAGE CONTROL.'.
	ADD REPAIR TO DAMAGE-DAMAGE-CONTROL
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
GOOD-NEWS-SHIELDS.
	DISPLAY 'SHIELDS.'.
	ADD REPAIR TO DAMAGE-SHIELDS.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
GOOD-NEWS-COMPUTER.
	DISPLAY 'COMPUTER.'.
	ADD REPAIR TO DAMAGE-COMPUTER.
	GO TO ZERO-THE-SECTOR-WE-LEAVE.
ZERO-THE-SECTOR-WE-LEAVE.
	IF WARP < .0019 GO TO PARK-THE-EXETER.
	MOVE SPACES TO PRESENT-SECTOR 
		(NCC-1706-SECTOR-X,NCC-1706-SECTOR-Y).
	MOVE NCC-1706-SECTOR-X TO REAL-X.
	MOVE NCC-1706-SECTOR-Y TO REAL-Y.
	MOVE VECTOR TO INT-VECTOR.
	MOVE 1 TO I.
	COMPUTE INT1-VECTOR = VECTOR + 1.
	COMPUTE X1 = CHART (INT-VECTOR,1) + 
		(CHART (INT1-VECTOR,1) - CHART (INT-VECTOR,1))
		 * (VECTOR - INT-VECTOR).
	COMPUTE X2 = CHART (INT-VECTOR,2) + 
		(CHART (INT1-VECTOR,2) - CHART (INT-VECTOR,2))
		 * (VECTOR - INT-VECTOR).
NAVIGATION-LOOP.
	ADD X1 TO REAL-X.
	ADD X2 TO REAL-Y.
	COMPUTE X = REAL-X + .5.
	COMPUTE Y = REAL-Y + .5.
*DID WE FLY OUT OF OUR QUADRANT?
	IF X < 1 OR > 8 OR Y < 1 OR > 8 GO TO CHANGE-QUADRANTS.
*DID WE HIT ANYTHING?
	IF PRESENT-SECTOR (X,Y) IS NOT EQUAL TO SPACES GO TO COLLISION.
	IF I < MOVE-DISTANCE
		ADD 1 TO I
		GO TO NAVIGATION-LOOP.
	MOVE X TO NCC-1706-SECTOR-X.
	MOVE Y TO NCC-1706-SECTOR-Y.
	GO TO PARK-THE-EXETER.
COLLISION.
	ADD 1 TO NAVIGATION-ERRORS.
*BACK UP ONE SECTOR
	COMPUTE NCC-1706-SECTOR-X = X - X1.
	COMPUTE NCC-1706-SECTOR-Y = Y - X2.
	DISPLAY 'WARP ENGINES SHUTDOWN AT SECTOR ' NCC-1706-SECTOR-X 
		',' NCC-1706-SECTOR-Y ' DUE TO BAD NAVIGATION'.
PARK-THE-EXETER.
	MOVE '<*>' TO PRESENT-SECTOR (NCC-1706-SECTOR-X,
					      NCC-1706-SECTOR-Y).
	IF WARP < .11
		ADD .1 TO STARDATE
		SUBTRACT .1 FROM STARDATES-LEFT
	ELSE ADD 1 TO STARDATE
	     SUBTRACT 1 FROM STARDATES-LEFT.
	GO TO DOCK-SCAN.
TIME-IS-UP.
	IF STARDATES-LEFT IS NOT POSITIVE
		DISPLAY ' '
		DISPLAY 'IT IS STARDATE ' STARDATE
		DISPLAY 'YOU RAN OUT OF TIME.'
		DISPLAY 'THERE ARE STILL ' KLINGONS-LEFT 
			' KLINGON BATTLE CRUISERS.'
		DISPLAY ' '
		DISPLAY 'YOU CAN HAVE ANOTHER CHANCE....TURKEY!'
		GO TO BEGIN-NEW-CONTEST.
CHANGE-QUADRANTS.
	COMPUTE REAL-X = NCC-1706-QUADRANT-X * 8 + NCC-1706-SECTOR-X 
			+ X1 * MOVE-DISTANCE.
	COMPUTE REAL-Y = NCC-1706-QUADRANT-Y * 8 + NCC-1706-SECTOR-Y 
			+ X2 * MOVE-DISTANCE.
	MOVE REAL-X TO X ROUNDED.
	MOVE REAL-Y TO Y ROUNDED.
	COMPUTE NCC-1706-QUADRANT-X = X / 8.
	COMPUTE NCC-1706-QUADRANT-Y = Y / 8.
	COMPUTE NCC-1706-SECTOR-X   = X - NCC-1706-QUADRANT-X * 8.
	COMPUTE NCC-1706-SECTOR-Y   = Y - NCC-1706-QUADRANT-Y * 8.
*IN THIS CRAZY MATH IT IS POSSIBLE TO ARRIVE AT SECTOR X,0 OR
*0,X IN WHICH CASE WE MUST FALL BACKWARDS INTO ANOTHER QUADRANT AT
*SECTOR X,8 OR 8,X.
	IF NCC-1706-SECTOR-X EQUALS ZERO
		SUBTRACT 1 FROM NCC-1706-QUADRANT-X
		MOVE 8 TO NCC-1706-SECTOR-X.
	IF NCC-1706-SECTOR-Y EQUALS ZERO
		SUBTRACT 1 FROM NCC-1706-QUADRANT-Y
		MOVE 8 TO NCC-1706-SECTOR-Y.
	ADD 1 TO STARDATE.
	SUBTRACT 1 FROM STARDATES-LEFT.
	IF STARDATES-LEFT IS NOT POSITIVE GO TO TIME-IS-UP.
	GO TO STARSHIP-PLACEMENT.
LONG-RANGE-SENSOR-SCAN.
	IF DAMAGE-LONG-RANGE-SENSORS IS NEGATIVE
		DISPLAY 'LONG RANGE SENSORS ARE INOPERABLE'
		GO TO HELL.
*RAYMOND FUSCI'S FAMOUS FLOATING COMMA ROUTINE.
	MOVE NCC-1706-QUADRANT-Y TO DISPLAY-Y.
		IF DISPLAY-X-1 EQUALS SPACES
			MOVE NCC-1706-QUADRANT-X TO DISPLAY-X-1
			GO TO RAYS-FLOATING-COMMA-BYPASS2.
		IF DISPLAY-X-2 EQUALS SPACES
			MOVE NCC-1706-QUADRANT-X TO DISPLAY-X-2
			GO TO RAYS-FLOATING-COMMA-BYPASS2.
		IF DISPLAY-X-3 EQUALS SPACES
			MOVE NCC-1706-QUADRANT-X TO DISPLAY-X-3
			GO TO RAYS-FLOATING-COMMA-BYPASS2.
		MOVE NCC-1706-QUADRANT-X TO DISPLAY-X-4.
RAYS-FLOATING-COMMA-BYPASS2.
	DISPLAY 'LONG RANGE SENSOR SCAN FOR QUADRANT ' DISPLAY-QUADRANT.
	DISPLAY '-------------------'.
	MOVE NCC-1706-QUADRANT-X TO X.
	MOVE NCC-1706-QUADRANT-Y TO Y.
	SUBTRACT 1 FROM X, Y.
	DISPLAY ': ' WITH NO ADVANCING.
	IF X < 1 OR > 8 OR Y < 1 OR > 8 
		DISPLAY '000 ' WITH NO ADVANCING
	ELSE MOVE MASTER-GALAXY (X,Y) TO DISPLAY-MASTER-GALAXY
		DISPLAY DISPLAY-MASTER-GALAXY ' ' WITH NO ADVANCING
		IF DAMAGE-COMPUTER IS NOT NEGATIVE
		 MOVE MASTER-GALAXY (X,Y) TO GALACTIC-RECORD (X,Y).
	ADD 1 TO Y.
	DISPLAY ': ' WITH NO ADVANCING.
	IF X < 1 OR > 8 OR Y < 1 OR > 8 
		DISPLAY '000 ' WITH NO ADVANCING
	ELSE MOVE MASTER-GALAXY (X,Y) TO DISPLAY-MASTER-GALAXY
		DISPLAY DISPLAY-MASTER-GALAXY ' ' WITH NO ADVANCING
		IF DAMAGE-COMPUTER IS NOT NEGATIVE
		 MOVE MASTER-GALAXY (X,Y) TO GALACTIC-RECORD (X,Y).
	ADD 1 TO Y.
	DISPLAY ': ' WITH NO ADVANCING.
	IF X < 1 OR > 8 OR Y < 1 OR > 8 
		DISPLAY '000 :' 
	ELSE MOVE MASTER-GALAXY (X,Y) TO DISPLAY-MASTER-GALAXY
		DISPLAY DISPLAY-MASTER-GALAXY ' :'
		IF DAMAGE-COMPUTER IS NOT NEGATIVE
		 MOVE MASTER-GALAXY (X,Y) TO GALACTIC-RECORD (X,Y).
	ADD 1 TO X.
	SUBTRACT 2 FROM Y.
	DISPLAY ': ' WITH NO ADVANCING.
	IF X < 1 OR > 8 OR Y < 1 OR > 8 
		DISPLAY '000 ' WITH NO ADVANCING
	ELSE MOVE MASTER-GALAXY (X,Y) TO DISPLAY-MASTER-GALAXY
		DISPLAY DISPLAY-MASTER-GALAXY ' ' WITH NO ADVANCING
		IF DAMAGE-COMPUTER IS NOT NEGATIVE
		 MOVE MASTER-GALAXY (X,Y) TO GALACTIC-RECORD (X,Y).
	ADD 1 TO Y.
	DISPLAY ': ' WITH NO ADVANCING.
	IF X < 1 OR > 8 OR Y < 1 OR > 8 
		DISPLAY '000 ' WITH NO ADVANCING
	ELSE MOVE MASTER-GALAXY (X,Y) TO DISPLAY-MASTER-GALAXY
		DISPLAY DISPLAY-MASTER-GALAXY ' ' WITH NO ADVANCING
		IF DAMAGE-COMPUTER IS NOT NEGATIVE
		 MOVE MASTER-GALAXY (X,Y) TO GALACTIC-RECORD (X,Y).
	ADD 1 TO Y.
	DISPLAY ': ' WITH NO ADVANCING.
	IF X < 1 OR > 8 OR Y < 1 OR > 8 
		DISPLAY '000 :' 
	ELSE MOVE MASTER-GALAXY (X,Y) TO DISPLAY-MASTER-GALAXY
		DISPLAY DISPLAY-MASTER-GALAXY ' :'
		IF DAMAGE-COMPUTER IS NOT NEGATIVE
		 MOVE MASTER-GALAXY (X,Y) TO GALACTIC-RECORD (X,Y).
	ADD 1 TO X.
	SUBTRACT 2 FROM Y.
	DISPLAY ': ' WITH NO ADVANCING.
	IF X < 1 OR > 8 OR Y < 1 OR > 8 
		DISPLAY '000 ' WITH NO ADVANCING
	ELSE MOVE MASTER-GALAXY (X,Y) TO DISPLAY-MASTER-GALAXY
		DISPLAY DISPLAY-MASTER-GALAXY ' ' WITH NO ADVANCING
		IF DAMAGE-COMPUTER IS NOT NEGATIVE
		 MOVE MASTER-GALAXY (X,Y) TO GALACTIC-RECORD (X,Y).
	ADD 1 TO Y.
	DISPLAY ': ' WITH NO ADVANCING.
	IF X < 1 OR > 8 OR Y < 1 OR > 8 
		DISPLAY '000 ' WITH NO ADVANCING
	ELSE MOVE MASTER-GALAXY (X,Y) TO DISPLAY-MASTER-GALAXY
		DISPLAY DISPLAY-MASTER-GALAXY ' ' WITH NO ADVANCING
		IF DAMAGE-COMPUTER IS NOT NEGATIVE
		 MOVE MASTER-GALAXY (X,Y) TO GALACTIC-RECORD (X,Y).
	ADD 1 TO Y.
	DISPLAY ': ' WITH NO ADVANCING.
	IF X < 1 OR > 8 OR Y < 1 OR > 8 
		DISPLAY '000 :' 
	ELSE MOVE MASTER-GALAXY (X,Y) TO DISPLAY-MASTER-GALAXY
		DISPLAY DISPLAY-MASTER-GALAXY ' :'
		IF DAMAGE-COMPUTER IS NOT NEGATIVE
		 MOVE MASTER-GALAXY (X,Y) TO GALACTIC-RECORD (X,Y).
	DISPLAY '-------------------'.
	DISPLAY ' '.
	GO TO HELL.
PHASER-CONTROL.
	IF KLINGONS-IN-PRESENT-SECTOR IS NOT > ZERO
		DISPLAY 'SHORT RANGE SENSORS REPORT NO KLINGONS IN THIS QUADRANT'
		GO TO HELL.
	IF DAMAGE-PHASERS IS NEGATIVE
		DISPLAY 'PHASERS NOT OPERATIONAL'
		GO TO HELL.
	IF DAMAGE-COMPUTER IS NEGATIVE
		DISPLAY 'COMPUTER FAILURE HAMPERS ACCURACY'.
ENERGY-INFO-LOOP.
	DISPLAY 'PHASERS LOCKED ON TARGET.  ENERGY AVAILABLE = ' 
		WARP-ENERGY.
	DISPLAY 'NUMBER OF UNITS TO FIRE? ' WITH NO ADVANCING.
	ACCEPT FIRE-POWER.
	IF FIRE-POWER IS NEGATIVE GO TO HELL.
	IF FIRE-POWER > WARP-ENERGY GO TO ENERGY-INFO-LOOP.
	SUBTRACT FIRE-POWER FROM WARP-ENERGY
				   TOTAL-ENERGY.
	PERFORM THE-ENEMY-SHOOTS-BACK.
	IF SHIELD-ENERGY IS NEGATIVE GO TO THE-EXETER-IS-DEAD.
	IF DAMAGE-COMPUTER IS NEGATIVE
		PERFORM RANDOMIZE
		COMPUTE FIRE-POWER = FIRE-POWER * ((RAN + 1) / 100).
	IF ENERGY OF KLINGON-ONE > ZERO
	 COMPUTE DISTANCE = ((X-COORD OF KLINGON-ONE - 
	  NCC-1706-SECTOR-X) ** 2 + (Y-COORD OF KLINGON-ONE - 
	  NCC-1706-SECTOR-Y) ** 2) ** .5
	 PERFORM RANDOMIZE
	 COMPUTE HIT = (FIRE-POWER / KLINGONS-IN-PRESENT-SECTOR / 
	  DISTANCE) * (RAN / 50)
	 MOVE HIT TO DISPLAY-HIT
	 SUBTRACT HIT FROM ENERGY OF KLINGON-ONE
	 DISPLAY DISPLAY-HIT ' UNIT HIT ON KLINGON AT SECTOR ' 
	  X-COORD OF KLINGON-ONE ',' 
	  Y-COORD OF KLINGON-ONE '  (' 
	  ENERGY OF KLINGON-ONE ' LEFT)'
	 IF ENERGY OF KLINGON-ONE IS NOT POSITIVE
	  DISPLAY '*** KLINGON DESTROYED ***'
	  SUBTRACT 1 FROM KLINGONS-IN-PRESENT-SECTOR
			  KLINGONS-LEFT
	  MOVE '   ' TO PRESENT-SECTOR (X-COORD OF KLINGON-ONE, 
	   Y-COORD OF KLINGON-ONE)
	  SUBTRACT 100 FROM MASTER-GALAXY (NCC-1706-QUADRANT-X, 
	   NCC-1706-QUADRANT-Y)
	  IF GALACTIC-RECORD (NCC-1706-QUADRANT-X,NCC-1706-QUADRANT-Y)
	   IS NOT ZERO 
	    SUBTRACT 100 FROM GALACTIC-RECORD (NCC-1706-QUADRANT-X, 
	     NCC-1706-QUADRANT-Y).
	IF ENERGY OF KLINGON-TWO > ZERO
	 COMPUTE DISTANCE = ((X-COORD OF KLINGON-TWO - 
	  NCC-1706-SECTOR-X) ** 2 + (Y-COORD OF KLINGON-TWO - 
	  NCC-1706-SECTOR-Y) ** 2) ** .5
	 PERFORM RANDOMIZE
	 COMPUTE HIT = (FIRE-POWER / KLINGONS-IN-PRESENT-SECTOR / 
	  DISTANCE) * (RAN / 50)
	 MOVE HIT TO DISPLAY-HIT
	 SUBTRACT HIT FROM ENERGY OF KLINGON-TWO
	 DISPLAY DISPLAY-HIT ' UNIT HIT ON KLINGON AT SECTOR ' 
	  X-COORD OF KLINGON-TWO ',' 
	  Y-COORD OF KLINGON-TWO '  (' 
	  ENERGY OF KLINGON-TWO ' LEFT)'
	 IF ENERGY OF KLINGON-TWO IS NOT POSITIVE
	  DISPLAY '*** KLINGON DESTROYED ***'
	  SUBTRACT 1 FROM KLINGONS-IN-PRESENT-SECTOR
			  KLINGONS-LEFT
	  MOVE '   ' TO PRESENT-SECTOR (X-COORD OF KLINGON-TWO, 
	   Y-COORD OF KLINGON-TWO)
	  SUBTRACT 100 FROM MASTER-GALAXY (NCC-1706-QUADRANT-X, 
	   NCC-1706-QUADRANT-Y)
	  IF GALACTIC-RECORD (NCC-1706-QUADRANT-X,NCC-1706-QUADRANT-Y)
	   IS NOT ZERO 
	    SUBTRACT 100 FROM GALACTIC-RECORD (NCC-1706-QUADRANT-X, 
	     NCC-1706-QUADRANT-Y).
	IF ENERGY OF KLINGON-THREE > ZERO
	 COMPUTE DISTANCE = ((X-COORD OF KLINGON-THREE - 
	  NCC-1706-SECTOR-X) ** 2 + (Y-COORD OF KLINGON-THREE - 
	  NCC-1706-SECTOR-Y) ** 2) ** .5
	 PERFORM RANDOMIZE
	 COMPUTE HIT = (FIRE-POWER / KLINGONS-IN-PRESENT-SECTOR / 
	  DISTANCE) * (RAN / 50)
	 MOVE HIT TO DISPLAY-HIT
	 SUBTRACT HIT FROM ENERGY OF KLINGON-THREE
	 DISPLAY DISPLAY-HIT ' UNIT HIT ON KLINGON AT SECTOR ' 
	  X-COORD OF KLINGON-THREE ',' 
	  Y-COORD OF KLINGON-THREE '  (' 
	  ENERGY OF KLINGON-THREE ' LEFT)'
	 IF ENERGY OF KLINGON-THREE IS NOT POSITIVE
	  DISPLAY '*** KLINGON DESTROYED ***'
	  SUBTRACT 1 FROM KLINGONS-IN-PRESENT-SECTOR
			  KLINGONS-LEFT
	  MOVE '   ' TO PRESENT-SECTOR (X-COORD OF KLINGON-THREE, 
	   Y-COORD OF KLINGON-THREE)
	  SUBTRACT 100 FROM MASTER-GALAXY (NCC-1706-QUADRANT-X, 
	   NCC-1706-QUADRANT-Y)
	  IF GALACTIC-RECORD (NCC-1706-QUADRANT-X,NCC-1706-QUADRANT-Y)
	   IS NOT ZERO 
	    SUBTRACT 100 FROM GALACTIC-RECORD (NCC-1706-QUADRANT-X, 
	     NCC-1706-QUADRANT-Y).
	IF KLINGONS-LEFT IS POSITIVE GO TO HELL.
LAST-KLINGON-IS-DEAD.
	DISPLAY 'THE LAST KLINGON BATTLE CRUISER HAS BEEN DESTROYED'.
	DISPLAY 'THE FEDERATION HAS BEEN SAVED!'
	COMPUTE STARBASES-DESTROYED = TOTAL-STARBASES - STARBASES-LEFT.
	COMPUTE TIME-OF-MISSION = 30 - STARDATES-LEFT.
	COMPUTE EFFICIENCY-RATING = (1000 * TOTAL-KLINGONS / TIME-OF-MISSION) 
		- (10 * (NAVIGATION-ERRORS - 5)) 
		- (30 * TORPEDO-MISSES) 
		- (50 * (STARBASE-VISITS - (TOTAL-KLINGONS / 10))) 
		- ((SUM-OF-PHASER-HITS / 10) - TOTAL-KLINGONS / 3 * 100) 
		- (5 * DAMAGE-SEVERITY-FACTOR) 
		- (250 * STARBASES-DESTROYED).
	DISPLAY 'YOUR EFFICIENCY RATING = ' EFFICIENCY-RATING.
	DISPLAY 'YOUR ACTUAL TIME OF MISSION = ' TIME-OF-MISSION 
		' STARDATES'.
	DISPLAY 'YOU KILLED ' TOTAL-KLINGONS ' KLINGONS'.
	DISPLAY 'YOU MADE ' NAVIGATION-ERRORS ' NAVIGATION ERRORS'.
	DISPLAY 'YOU FIRED ' TORPEDO-MISSES ' PHOTON TORPEDOS THAT MISSED'.
	DISPLAY 'YOU DOCKED AT STARBASES ' STARBASE-VISITS ' TIMES'.
	DISPLAY 'YOUR STARSHIP ENDURED ' SUM-OF-PHASER-HITS ' UNITS OF ENEMY PHASER FIRE'.
	DISPLAY 'YOUR DAMAGE SEVERITY FACTOR WAS ' DAMAGE-SEVERITY-FACTOR.
	IF STARBASES-DESTROYED EQUALS ZERO GO TO TRY-AGAIN.
	DISPLAY 'ALSO YOU DESTROYED ' STARBASES-DESTROYED ' STARBASE' 
		WITH NO ADVANCING.
	IF STARBASES-DESTROYED > 1
		DISPLAY 'S YOU TURKEY!'
		ELSE DISPLAY ' TURKEY!'.
TRY-AGAIN.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY 'DO YOU WANT TO TRY AGAIN? ' WITH NO ADVANCING.
	ACCEPT YES-OR-NO-ANSWER.
	IF YES-OR-NO-ANSWER EQUALS 'YES' OR 'Y' GO TO BEGIN-NEW-CONTEST.
	IF YES-OR-NO-ANSWER EQUALS 'NO' OR 'N' GO TO QUIT.
	DISPLAY 'PLEASE ANSWER YES OR NO!'.
	GO TO TRY-AGAIN.
PHOTON-TORPEDO-CONTROL.
	IF DAMAGE-PHOTON-TUBES IS NEGATIVE
		DISPLAY 'PHOTON TORPEDO TUBES ARE NOT OPERATIONAL'
		GO TO HELL.
	IF TORPEDO-COUNTER EQUALS ZERO
		DISPLAY 'ALL PHOTON TORPEDOS EXPENDED'
		GO TO HELL.
	DISPLAY 'TORPEDO COURSE (0-360)? ' WITH NO ADVANCING.
	ACCEPT COURSE.
	IF COURSE < ZERO OR > 360 GO TO HELL.
	SUBTRACT 1 FROM TORPEDO-COUNTER.
*COMVERTIING THE COURSE TO INTERNAL FORMAT (1-9).
	COMPUTE VECTOR = 90 - COURSE.
	IF VECTOR IS NEGATIVE
		ADD 360 TO VECTOR.
	COMPUTE VECTOR = VECTOR / 45 + 1.
	MOVE NCC-1706-SECTOR-X TO REAL-X.
	MOVE NCC-1706-SECTOR-Y TO REAL-Y.
	MOVE VECTOR TO INT-VECTOR.
	COMPUTE INT1-VECTOR = VECTOR + 1.
	COMPUTE X1 = CHART (INT-VECTOR,1) + 
		(CHART (INT1-VECTOR,1) - CHART (INT-VECTOR,1))
		 * (VECTOR - INT-VECTOR).
	COMPUTE X2 = CHART (INT-VECTOR,2) + 
		(CHART (INT1-VECTOR,2) - CHART (INT-VECTOR,2))
		 * (VECTOR - INT-VECTOR).
	DISPLAY 'TORPEDO TRACK:'.
TORPEDO-LOOP.
	ADD X1 TO REAL-X.
	ADD X2 TO REAL-Y.
	COMPUTE X = REAL-X + .5.
	COMPUTE Y = REAL-Y + .5.
	IF X < 1 OR > 8 OR Y < 1 OR > 8 GO TO TORPEDO-MISSED.
	DISPLAY REAL-X, '   ' REAL-Y.
	COMPUTE MISS-FACTOR1 = REAL-X + .25.
	COMPUTE MISS-FACTOR2 = REAL-X + .75.
	IF MISS-FACTOR1 IS NOT EQUAL TO MISS-FACTOR2 GO TO TORPEDO-LOOP.
	COMPUTE MISS-FACTOR1 = REAL-Y + .25.
	COMPUTE MISS-FACTOR2 = REAL-Y + .75.
	IF MISS-FACTOR1 IS NOT EQUAL TO MISS-FACTOR2 GO TO TORPEDO-LOOP.
	IF PRESENT-SECTOR (X,Y) EQUALS '   ' GO TO TORPEDO-LOOP.
	IF PRESENT-SECTOR (X,Y) EQUALS ' * ' 
		DISPLAY "YOU CAN'T DESTROY STARS, TURKEY"
		GO TO TORPEDO-MISSED.
	IF PRESENT-SECTOR (X,Y) IS NOT EQUAL TO '>!<' GO TO KLINGON-DESTROYED.
	DISPLAY '*** STARBASE DESTROYED ***......CONGRATULATIONS'.
	SUBTRACT 1 FROM STARBASES-LEFT
			STARBASE-IN-PRESENT-SECTOR.
	MOVE '   ' TO PRESENT-SECTOR (X,Y).
	SUBTRACT 10 FROM MASTER-GALAXY (NCC-1706-QUADRANT-X,NCC-1706-QUADRANT-Y).
	IF DAMAGE-COMPUTER IS NOT NEGATIVE
		IF GALACTIC-RECORD (NCC-1706-QUADRANT-X,NCC-1706-QUADRANT-Y)
			IS > ZERO
			SUBTRACT 10 FROM GALACTIC-RECORD (NCC-1706-QUADRANT-X,
				NCC-1706-QUADRANT-Y).
	GO TO TORPEDO-MISSED.
KLINGON-DESTROYED.
	SUBTRACT 1 FROM KLINGONS-IN-PRESENT-SECTOR
			KLINGONS-LEFT.
	DISPLAY '*** KLINGON DESTROYED ***'.
	IF KLINGONS-LEFT EQUALS ZERO GO TO LAST-KLINGON-IS-DEAD.
	IF X-COORD OF KLINGON-ONE EQUALS X AND Y-COORD OF KLINGON-ONE
		EQUALS Y
		MOVE ZEROS TO KLINGON-ONE.
	IF X-COORD OF KLINGON-TWO EQUALS X AND Y-COORD OF KLINGON-TWO
		EQUALS Y
		MOVE ZEROS TO KLINGON-TWO.
	IF X-COORD OF KLINGON-THREE EQUALS X AND Y-COORD OF KLINGON-THREE
		EQUALS Y
		MOVE ZEROS TO KLINGON-THREE.
	MOVE '   ' TO PRESENT-SECTOR (X,Y).
	SUBTRACT 100 FROM MASTER-GALAXY (NCC-1706-QUADRANT-X,
					 NCC-1706-QUADRANT-Y).
	IF DAMAGE-COMPUTER IS NOT NEGATIVE
		IF GALACTIC-RECORD (NCC-1706-QUADRANT-X,
			NCC-1706-QUADRANT-Y) IS > ZERO
			SUBTRACT 100 FROM
			 GALACTIC-RECORD (NCC-1706-QUADRANT-X,
			 NCC-1706-QUADRANT-Y).
	IF KLINGONS-IN-PRESENT-SECTOR > ZERO
		PERFORM THE-ENEMY-SHOOTS-BACK.
	IF SHIELD-ENERGY IS NEGATIVE GO TO THE-EXETER-IS-DEAD.
	GO TO HELL.
TORPEDO-MISSED.
	DISPLAY 'TORPEDO MISSED'.
	ADD 1 TO TORPEDO-MISSES.
	IF KLINGONS-IN-PRESENT-SECTOR > ZERO
		PERFORM THE-ENEMY-SHOOTS-BACK.
	IF SHIELD-ENERGY IS NEGATIVE GO TO THE-EXETER-IS-DEAD.
	GO TO HELL.
SHIELD-CONTROL.
	IF DAMAGE-SHIELDS IS NEGATIVE
		DISPLAY 'SHIELD CONTROL IS NON-OPERATIONAL'
		GO TO HELL.
	DISPLAY 'ENERGY AVAILABLE = ' TOTAL-ENERGY.
	DISPLAY 'NUMBER OF UNITS TO SHIELDS? ' WITH NO ADVANCING.
	ACCEPT TEMP-4.
	IF TEMP-4 IS NEGATIVE GO TO HELL.
	IF TEMP-4 > TOTAL-ENERGY GO TO SHIELD-CONTROL.
	MOVE TEMP-4 TO SHIELD-ENERGY.
	SUBTRACT SHIELD-ENERGY FROM TOTAL-ENERGY GIVING WARP-ENERGY.
	GO TO HELL.
DAMAGE-CONTROL-REPORT.
	IF DAMAGE-DAMAGE-CONTROL IS NEGATIVE
		DISPLAY 'DAMAGE CONTROL REPORT IS NOT AVAILABLE'
		GO TO HELL.
	DISPLAY 'DAMAGE CONTROL REPORT:'.
	DISPLAY ' '.
	DISPLAY 'DEVICE			STATE OF REPAIR'.
	DISPLAY 'WARP DRIVE		' DAMAGE-WARP-DRIVE.
	DISPLAY 'SHORT RANGE SENSORS	' DAMAGE-SHORT-RANGE-SENSORS.
	DISPLAY 'LONG RANGE SENSORS	' DAMAGE-LONG-RANGE-SENSORS.
	DISPLAY 'PHASER CONTROL		' DAMAGE-PHASERS.
	DISPLAY 'PHOTON TORPEDO TUBES	' DAMAGE-PHOTON-TUBES.
	DISPLAY 'DAMAGE CONTROL		' DAMAGE-DAMAGE-CONTROL.
	DISPLAY 'SHIELD CONTROL		' DAMAGE-SHIELDS.
	DISPLAY 'LIBRARY COMPUTER	' DAMAGE-COMPUTER.
	GO TO HELL.
LIBRARY-COMPUTER.
	IF DAMAGE-COMPUTER IS NEGATIVE
		DISPLAY 'COMPUTER DISABLED'
		GO TO HELL.
	DISPLAY 'COMPUTER ACTIVE AND AWAITING COMMAND? ' WITH NO ADVANCING.
	ACCEPT COMMAND.
	IF COMMAND EQUALS ZERO GO TO CUMULATIVE-GALACTIC-RECORD.
	GO TO	STATUS-REPORT
		PHOTON-TORPEDO-DATA
		CALCULATOR
			DEPENDING ON COMMAND.
	DISPLAY 'FUNCTIONS AVAILABLE FROM COMPUTER'.
	DISPLAY '0 = CUMULATIVE GALACTIC RECORD'.
	DISPLAY '1 = STATUS REPORT'.
	DISPLAY '2 = PHOTON TORPEDO DATA'.
	DISPLAY '3 = CALCULATOR'.
	GO TO LIBRARY-COMPUTER.
CUMULATIVE-GALACTIC-RECORD.
	DISPLAY 'COMPUTER RECORD OF GALAXY FOR ALL LONG RANGE SENSOR SCANS'.
	DISPLAY '    1     2     3     4     5     6     7     8'.
	DISPLAY '   ----- ----- ----- ----- ----- ----- ----- -----' 
		WITH NO ADVANCING.

	MOVE 0 TO I, J.
GALACTIC-RECORD-I-LOOP.
	ADD 1 TO I, J.
	DISPLAY ' '.
	DISPLAY I WITH NO ADVANCING.
GALACTIC-RECORD-J-LOOP.
	MOVE GALACTIC-RECORD (I,J) TO DISPLAY-GALACTIC-RECORD.
	DISPLAY '   ' DISPLAY-GALACTIC-RECORD WITH NO ADVANCING.
	ADD 1 TO J.
	IF J < 9 GO TO GALACTIC-RECORD-J-LOOP.
	MOVE ZERO TO J.
	IF I IS NOT EQUAL TO 8 GO TO GALACTIC-RECORD-I-LOOP.
	DISPLAY ' '.
	DISPLAY '   ----- ----- ----- ----- ----- ----- ----- -----'.
	GO TO HELL.
STATUS-REPORT.
	DISPLAY 'NUMBER OF KLINGONS LEFT = ' KLINGONS-LEFT.
	DISPLAY 'NUMBER OF STARDATES LEFT = ' STARDATES-LEFT.
	DISPLAY 'NUMBER OF STARBASES LEFT = ' STARBASES-LEFT.
	DISPLAY 'NUMBER OF NAVIGATION ERRORS = ' NAVIGATION-ERRORS.
	DISPLAY 'NUMBER OF TORPEDO MISSES = ' TORPEDO-MISSES.
	DISPLAY 'NUMBER OF STARBASE VISITS = ' STARBASE-VISITS.
	DISPLAY 'SUM OF PHASER HITS = ' SUM-OF-PHASER-HITS.
	DISPLAY 'DAMAGE SEVERITY FACTOR = ' DAMAGE-SEVERITY-FACTOR.
	DISPLAY ' '.
	GO TO DAMAGE-CONTROL-REPORT.
PHOTON-TORPEDO-DATA.
	MOVE NCC-1706-SECTOR-X TO SOURCE-X.
	MOVE NCC-1706-SECTOR-Y TO SOURCE-Y.
	IF ENERGY OF KLINGON-ONE > ZERO
		MOVE X-COORD OF KLINGON-ONE TO DESTINATION-X
		MOVE Y-COORD OF KLINGON-ONE TO DESTINATION-Y
		PERFORM VECTOR-ANALYSIS.
	IF ENERGY OF KLINGON-TWO > ZERO
		MOVE X-COORD OF KLINGON-TWO TO DESTINATION-X
		MOVE Y-COORD OF KLINGON-TWO TO DESTINATION-Y
		PERFORM VECTOR-ANALYSIS.
	IF ENERGY OF KLINGON-THREE > ZERO
		MOVE X-COORD OF KLINGON-THREE TO DESTINATION-X
		MOVE Y-COORD OF KLINGON-THREE TO DESTINATION-Y
		PERFORM VECTOR-ANALYSIS.
	GO TO HELL.
CALCULATOR.
*RAYMOND FUSCI'S FAMOUS FLOATING COMMA ROUTINE.
	MOVE NCC-1706-QUADRANT-Y TO DISPLAY-Y.
		IF DISPLAY-X-1 EQUALS SPACES
			MOVE NCC-1706-QUADRANT-X TO DISPLAY-X-1
			GO TO RAYS-FLOATING-COMMA-BYPASS3.
		IF DISPLAY-X-2 EQUALS SPACES
			MOVE NCC-1706-QUADRANT-X TO DISPLAY-X-2
			GO TO RAYS-FLOATING-COMMA-BYPASS3.
		IF DISPLAY-X-3 EQUALS SPACES
			MOVE NCC-1706-QUADRANT-X TO DISPLAY-X-3
			GO TO RAYS-FLOATING-COMMA-BYPASS3.
		MOVE NCC-1706-QUADRANT-X TO DISPLAY-X-4.
RAYS-FLOATING-COMMA-BYPASS3.
	DISPLAY 'YOU ARE AT QUADRANT' DISPLAY-QUADRANT 
		'      SECTOR ' NCC-1706-SECTOR-X ',' NCC-1706-SECTOR-Y.
	DISPLAY 'SHIP AND TARGET COORDINATES ARE? ' WITH NO ADVANCING.
	ACCEPT SOURCE-X, SOURCE-Y, DESTINATION-X, DESTINATION-Y.
	PERFORM VECTOR-ANALYSIS.
	GO TO HELL.
VECTOR-ANALYSIS SECTION.
A.
	COMPUTE REAL-X = SOURCE-X - DESTINATION-X.
	COMPUTE REAL-Y = DESTINATION-Y - SOURCE-Y.
	MOVE REAL-X TO I.
	MOVE REAL-Y TO J.
	IF REAL-X EQUALS ZERO AND REAL-Y EQUALS ZERO
		DISPLAY 'GET SERIOUS'
		GO TO HELL.
	IF REAL-Y IS POSITIVE AND REAL-X IS NOT NEGATIVE
		GO TO QUADRANT-ONE.
	IF REAL-Y IS NOT POSITIVE AND REAL-X IS POSITIVE
		GO TO QUADRANT-TWO.
	IF REAL-Y IS NEGATIVE AND REAL-X IS NOT POSITIVE
		GO TO QUADRANT-THREE.
	IF REAL-Y IS NOT NEGATIVE AND REAL-X IS NEGATIVE
		GO TO QUADRANT-FOUR.
QUADRANT-ONE.
	MOVE 1 TO VECTOR.
ANALYSIS-COMPUTATION1.
	IF J > I OR = I GO TO ANALYSIS-COMPUTATION2.
	COMPUTE VECTOR = VECTOR + (((I - J) + I) / I).
	GO TO DISTANCE-COMPUTATION.
ANALYSIS-COMPUTATION2.
	COMPUTE VECTOR = VECTOR + (I / J).
	GO TO DISTANCE-COMPUTATION.
QUADRANT-TWO.
	MOVE 3 TO VECTOR.
ANALYSIS-COMPUTATION3.
	IF I > J OR = J GO TO ANALYSIS-COMPUTATION4.
	COMPUTE VECTOR = VECTOR + (((J - I) + J) / J).
	GO TO DISTANCE-COMPUTATION.
ANALYSIS-COMPUTATION4.
	COMPUTE VECTOR = VECTOR + (J / I).
	GO TO DISTANCE-COMPUTATION.
QUADRANT-THREE.
	MOVE 5 TO VECTOR.
	GO TO ANALYSIS-COMPUTATION1.
QUADRANT-FOUR.
	MOVE 7 TO VECTOR.
	GO TO ANALYSIS-COMPUTATION3.
DISTANCE-COMPUTATION.
	COMPUTE COURSE = 90 - (VECTOR - 1) * 45.
	IF COURSE IS NEGATIVE
		ADD 360 TO COURSE.
	DISPLAY 'DIRECTION = ' COURSE.
	COMPUTE DISTANCE = (REAL-Y ** 2 + REAL-X ** 2) ** .5.
	DISPLAY 'DISTANCE = ' DISTANCE.
THE-EXETER-IS-DEAD SECTION.
A.
	DISPLAY ' '.
	DISPLAY ' '.
	DISPLAY 'THE EXETER HAS BEEN DESTROYED.  THE'.
	DISPLAY 'FEDERATION WILL BE CONQUERED.'.
	DISPLAY 'THERE ARE STILL ' KLINGONS-LEFT 
		' KLINGON BATTLE CRUISERS LEFT.'.
	DISPLAY 'YOU GET ANOTHER CHANCE....TURKEY!'.
	GO TO BEGIN-NEW-CONTEST.
THE-ENEMY-SHOOTS-BACK SECTION.
A.
*THE CALLER OF THIS SUBROUTINE MUST HAVE THE FOLLOWING NEXT INSTRUCTION.
*IF SHIELD-ENERGY IS NEGATIVE GO TO THE-EXETER-IS-DEAD.
	IF CONDITION IS EQUAL TO 'DOCKED' GO TO SHOOTING-EXIT.
	 IF KLINGONS-IN-PRESENT-SECTOR EQUALS ZERO GO TO I-SHOOT-YOU-NOT.
	  IF ENERGY OF KLINGON-ONE > ZERO
	   COMPUTE DISTANCE = ((X-COORD OF KLINGON-ONE - 
	    NCC-1706-SECTOR-X) ** 2 + (Y-COORD OF KLINGON-ONE - 
	    NCC-1706-SECTOR-Y) ** 2) ** .5
	   PERFORM RANDOMIZE
	   COMPUTE HIT = (ENERGY OF KLINGON-ONE / DISTANCE) * 
	    (RAN / 100 + 2)
	   ADD HIT TO SUM-OF-PHASER-HITS
	   MOVE HIT TO DISPLAY-HIT
	   SUBTRACT HIT FROM SHIELD-ENERGY
			     TOTAL-ENERGY
	   DISPLAY 'KLINGON ATTACK'
	   DISPLAY DISPLAY-HIT ' UNIT HIT ON EXETER FROM SECTOR ' 
	    X-COORD OF KLINGON-ONE ',' Y-COORD OF KLINGON-ONE 
	    '     (' SHIELD-ENERGY ' LEFT)'.
	  IF ENERGY OF KLINGON-TWO > ZERO
	   COMPUTE DISTANCE = ((X-COORD OF KLINGON-TWO - 
	    NCC-1706-SECTOR-X) ** 2 + (Y-COORD OF KLINGON-TWO - 
	    NCC-1706-SECTOR-Y) ** 2) ** .5
	   PERFORM RANDOMIZE
	   COMPUTE HIT = (ENERGY OF KLINGON-TWO / DISTANCE) * 
	    (RAN / 100 + 2)
	   ADD HIT TO SUM-OF-PHASER-HITS
	   MOVE HIT TO DISPLAY-HIT
	   SUBTRACT HIT FROM SHIELD-ENERGY
			     TOTAL-ENERGY
	   DISPLAY 'KLINGON ATTACK'
	   DISPLAY DISPLAY-HIT ' UNIT HIT ON EXETER FROM SECTOR ' 
	    X-COORD OF KLINGON-TWO ',' Y-COORD OF KLINGON-TWO 
	    '     (' SHIELD-ENERGY ' LEFT)'.
	  IF ENERGY OF KLINGON-THREE > ZERO
	   COMPUTE DISTANCE = ((X-COORD OF KLINGON-THREE - 
	    NCC-1706-SECTOR-X) ** 2 + (Y-COORD OF KLINGON-THREE - 
	    NCC-1706-SECTOR-Y) ** 2) ** .5
	   PERFORM RANDOMIZE
	   COMPUTE HIT = (ENERGY OF KLINGON-THREE / DISTANCE) * 
	    (RAN / 100 + 2)
	   ADD HIT TO SUM-OF-PHASER-HITS
	   MOVE HIT TO DISPLAY-HIT
	   SUBTRACT HIT FROM SHIELD-ENERGY
			     TOTAL-ENERGY
	   DISPLAY 'KLINGON-ATTACK'
	   DISPLAY DISPLAY-HIT ' UNIT HIT ON EXETER FROM SECTOR ' 
	    X-COORD OF KLINGON-THREE ',' Y-COORD OF KLINGON-THREE 
	    '     (' SHIELD-ENERGY ' LEFT)'.
	 GO TO I-SHOOT-YOU-NOT.
SHOOTING-EXIT.
	DISPLAY 'STARBASE SHIELDS PROTECT THE EXETER'.
I-SHOOT-YOU-NOT.
RANDOMIZE SECTION.
A.
*POWER RESIDUE RANDOM NUMBER GENERATOR
*THE NEXT 3 LINES INSURE THAT THE SEED IS ODD
	COMPUTE TEMP1 = SEED / 2.
	COMPUTE TEMP2 = TEMP1 * 2.
	IF SEED IS NOT = TO TEMP2  ADD 1 TO SEED.
	MULTIPLY MULTIPLIER BY SEED.
	DIVIDE 9999 INTO SEED GIVING RAN.
*THIS SECTION IS USED FOR A BREAK POINT FOR COBDDT SO THAT THE
*HISTOGRAM WON'T FORGET TO CLOSE THE FILE.
QUIT SECTION.
A.
	STOP RUN.
  
