IDENTIFICATION DIVISION.
PROGRAM-ID. SCANIT.
AUTHOR. DAVE KIARSIS/FRED SMITH.
DATE-WRITTEN. APRIL 1973.
DATE-COMPILED.
SECURITY. COPYRIGHT 1973 -- DIGITAL EQUIPMENT CORPORATION.
REMARKS.
	SCANS A COMMAND STRING FOR FILENAMES, PROJECT/PROGRAMMER
	NUMBERS, AND SWITCHES. THESE ARE SEPERATED IN THE COMMAND
	STRING BY EITHER "_" OR "=".
	THE FORMAT IS AS FOLLOWS:
	FN.EXT[PPN]/S1/S2/S3_FN.EXT[PPN]/S4/S5/S6
	IN ALL CASES THE DEVICE IS DSK.
ENVIRONMENT DIVISION.
CONFIGURATION SECTION.
SOURCE-COMPUTER. DECSYSTEM-10.
OBJECT-COMPUTER. DECSYSTEM-10.
INPUT-OUTPUT SECTION.
FILE-CONTROL.
DATA DIVISION.
FILE SECTION.
WORKING-STORAGE SECTION.

01	SUPPRESS-STRING.
	02 SUPPRESS-CHARACTER OCCURS 80 TIMES PIC X.

01	COMMAND-STRING.
	02 COMMAND-CHARACTER OCCURS 80 TIMES INDEXED BY XX PIC X.

01	CODE-WORD.
	02 CODE-CHARACTER OCCURS 80 TIMES PIC X.

01	INDEXES COMPUTATIONAL.
	02 X		PIC 99.
	02 XX		PIC 99.
		88 MAX-CHARACTER VALUE 80.
	02 SIDE		PIC 9.
	02 ERROR-FLAG	PIC 9  VALUE 0.
	02 MAX-SWITCH	PIC 9  VALUE 6.
	02 COUNTT	PIC 99.
	02 COUNTTER	PIC 99.
	02 SAVED-INDEX	PIC 99.
	02 SWITCH-COUNTT	PIC 99.

01 R		PIC 9 OCCURS 10 COMP.

01 DELIMITERR	PIC X.
	88 ONES-WE-NOTICE	VALUE "." "[" "/" "_" "=".

01 DELIM-NUM REDEFINES DELIMITERR PIC 9.
01 USER-PPN		PIC 9(10)	COMP.

01 CURRENT-NUMBER	PIC 9(10)	COMP.

01 CURRENT-SWITCH.
	02 CURRENT-SWITCH-CHARACTER OCCURS 6 PIC X.

01 EXAM-WORD.
	02 EXAM-CHARACTER OCCURS  6 PIC X.

01 TABLE-OF-SWITCHES.
	02 FILLER	PIC X(6) VALUE "HELP".
	02 FILLER	PIC X(6) VALUE "NOLIST".
	02 FILLER	PIC X(6) VALUE "NOSOUR".
	02 FILLER	PIC X(6) VALUE "SEQUEN".
	02 FILLER	PIC X(6) VALUE "FIFTH".
	02 FILLER	PIC X(6) VALUE "SIXTH".

01 SWITCH-WORDS REDEFINES TABLE-OF-SWITCHES.
	02 SWITCH-WORD	PIC X(6)	OCCURS 6.

01 SWITCH-VALUES.
	02 FILLER	PIC X VALUE "1".
	02 FILLER	PIC X VALUE "2".
	02 FILLER	PIC X VALUE "3".
	02 FILLER	PIC X VALUE "4".
	02 FILLER	PIC X VALUE "5".
	02 FILLER	PIC X VALUE "6".

01 SWITCH-FLAGS REDEFINES SWITCH-VALUES.
	02 SWITCH-FLAG	PIC X	OCCURS 6.

LINKAGE SECTION.

01	OUTPUT-THINGS.
	02 OUTPUT-FILE.
		03 OUTPUT-NAME		PIC X(6).
		03 OUTPUT-EXTENSION	PIC X(3).
	02 OUTPUT-USER-NUMBER		PIC 9(10)	COMP.
	02 OUTPUT-SWITCHES.
		03 OUTPUT-SWITCH	PIC X	OCCURS 6.

01	INPUT-THINGS.
	02 INPUT-FILE.
		03 INPUT-NAME		PIC X(6).
		03 INPUT-EXTENSION	PIC X(3).
	02 INPUT-USER-NUMBER		PIC 9(10)	COMP.
	02 INPUT-SWITCHES.
		03 INPUT-SWITCH		PIC X	OCCURS 6.

PROCEDURE DIVISION USING OUTPUT-THINGS, INPUT-THINGS.
DO-IT.
	PERFORM FUN-AND-GAMES THRU FUN-AND-GAMES-EXIT.
	EXIT PROGRAM.
FUN-AND-GAMES.
	DISPLAY "> " WITH NO ADVANCING.
	ACCEPT COMMAND-STRING.
	IF COMMAND-STRING EQUALS SPACES GO TO FUN-AND-GAMES.
	IF COMMAND-STRING EQUALS
	"E" OR
	"EX" OR
	"EXI" OR
	"EXIT"
	STOP RUN.
	MOVE SPACES  TO OUTPUT-THINGS, INPUT-THINGS.
	MOVE 1 TO SIDE, XX.
SCAN-LINE.
	PERFORM GET-A-COMMAND-WORD THRU GET-A-COMMAND-WORD-EXIT.
	IF ERROR-FLAG EQUALS 1 GO TO ERROR-LINE.
	PERFORM SCAN-NAME THRU SCAN-NAME-EXIT.
	IF ERROR-FLAG EQUALS 1 GO TO ERROR-LINE.
	IF DELIMITERR NOT EQUAL "[" GO TO SCAN-DELIMITERR.
	PERFORM GET-USER-NUMBER THRU GET-USER-NUMBER-EXIT.
	IF ERROR-FLAG EQUALS 1
		GO TO ERROR-LINE.
SCAN-DELIMITERR.
	IF DELIMITERR EQUALS "=" OR "_" 
		IF SIDE IS EQUAL TO 2
		DISPLAY "? TWO INPUT SPECIFICATIONS ILLEGAL",
		GO TO FUN-AND-GAMES ELSE
		MOVE 2 TO SIDE GO TO SCAN-LINE.
	IF DELIMITERR EQUALS "/" PERFORM GET-SWITCH THRU GET-SWITCH-EXIT
		IF ERROR-FLAG EQUALS 1 GO TO ERROR-LINE ELSE
		GO TO SCAN-DELIMITERR.
	IF MAX-CHARACTER GO TO SET-DEFAULTS.
	IF DELIMITERR NOT EQUAL TO SPACE GO TO SAY-ILLEGAL.
	ADD 1 TO XX
	IF MAX-CHARACTER GO TO SET-DEFAULTS.
	MOVE COMMAND-CHARACTER (XX) TO DELIMITERR.
	GO TO SCAN-DELIMITERR.
SAY-ILLEGAL.
	DISPLAY "? SYNTAX CHARACTER ", QUOTE, DELIMITERR,
		WITH NO ADVANCING.
	IF CODE-WORD EQUALS SPACES GO TO DISPLAY-ILLEGAL.
	DISPLAY " FOLLOWING WORD ", QUOTE WITH NO ADVANCING.
		MOVE CODE-WORD TO SUPPRESS-STRING.
		PERFORM DISPLAY-WITH-TRUNCATION THRU DISPLAY-WITH-TRUNCATION-EXIT.
DISPLAY-ILLEGAL.
		DISPLAY QUOTE, " ILLEGAL.".
		DISPLAY SPACE.
		GO TO FUN-AND-GAMES.
SET-DEFAULTS.
	IF INPUT-FILE EQUALS SPACES
		MOVE OUTPUT-THINGS TO INPUT-THINGS
		MOVE "CBL" TO OUTPUT-EXTENSION
		MOVE ZEROS TO OUTPUT-USER-NUMBER
		MOVE SPACES TO OUTPUT-SWITCHES.
	IF OUTPUT-FILE EQUALS SPACES
		MOVE INPUT-NAME TO OUTPUT-NAME
		MOVE "CBL" TO OUTPUT-EXTENSION.
FUN-AND-GAMES-EXIT.
	EXIT.
ERROR-LINE.
	DISPLAY SPACE.
	GO TO FUN-AND-GAMES.

SCAN-NAME.
	IF SIDE EQUALS 2 MOVE CODE-WORD TO INPUT-NAME.
	IF SIDE EQUALS 1 MOVE CODE-WORD TO OUTPUT-NAME.
	IF DELIMITERR IS NOT EQUAL TO "." GO TO SCAN-NAME-EXIT.
	PERFORM GET-A-COMMAND-WORD THRU GET-A-COMMAND-WORD-EXIT.
	IF SIDE EQUALS 2 MOVE CODE-WORD TO INPUT-EXTENSION.
	IF SIDE EQUALS 1 MOVE CODE-WORD TO OUTPUT-EXTENSION.
SCAN-NAME-EXIT.
	EXIT.
GET-SWITCH.
	MOVE 0 TO SWITCH-COUNTT, ERROR-FLAG.
	PERFORM GET-A-COMMAND-WORD THRU GET-A-COMMAND-WORD-EXIT.
	IF ERROR-FLAG EQUALS 1 GO TO GET-SWITCH-EXIT.
	IF CODE-WORD EQUALS SPACES
	DISPLAY "? NULL SWITCH ILLEGAL"
	MOVE 1 TO ERROR-FLAG
	GO TO GET-SWITCH-EXIT.
	MOVE 1 TO COUNTTER.
	MOVE CODE-WORD TO CURRENT-SWITCH.
GET-ONE-SWITCH.
	MOVE SWITCH-WORD (COUNTTER) TO EXAM-WORD.
	IF CURRENT-SWITCH EQUALS EXAM-WORD
		GO TO EXACT-MATCH.
	MOVE 1 TO X.
GET-A-MATCH-LOOP.
	IF CURRENT-SWITCH-CHARACTER (X) EQUALS SPACE
		GO TO PARTIAL-MATCH.
	IF CURRENT-SWITCH-CHARACTER (X) NOT EQUAL EXAM-CHARACTER (X)
		GO TO GET-NEXT-SWITCH.
	ADD 1 TO X.
	IF X NOT EQUAL 6
	GO TO GET-A-MATCH-LOOP.
PARTIAL-MATCH.
	MOVE COUNTTER TO SAVED-INDEX.
	ADD 1 TO SWITCH-COUNTT.
GET-NEXT-SWITCH.
	ADD 1 TO COUNTTER.
	IF COUNTTER IS GREATER THAN MAX-SWITCH GO TO NO-MATCH.
	GO TO GET-ONE-SWITCH.
NO-MATCH.
	IF SWITCH-COUNTT NOT EQUAL 1
		DISPLAY "? SWITCH ", QUOTE WITH NO ADVANCING
		MOVE CURRENT-SWITCH TO SUPPRESS-STRING
		PERFORM DISPLAY-WITH-TRUNCATION THRU DISPLAY-WITH-TRUNCATION-EXIT
		DISPLAY QUOTE, WITH NO ADVANCING
		IF SWITCH-COUNTT GREATER 1
			DISPLAY " IS AMBIGUOUS."
			MOVE 1 TO ERROR-FLAG
			GO TO GET-SWITCH-EXIT
		ELSE
			DISPLAY " ILLEGAL."
			MOVE 1 TO ERROR-FLAG
			GO TO GET-SWITCH-EXIT.
	GO TO HAVE-SWITCH.
EXACT-MATCH.
	MOVE COUNTTER TO SAVED-INDEX.
HAVE-SWITCH.
	IF SAVED-INDEX EQUALS 1 PERFORM HELP-THE-MAN
	MOVE 1 TO ERROR-FLAG
	GO TO GET-SWITCH-EXIT.
	IF SIDE EQUALS 1 MOVE SWITCH-FLAG (SAVED-INDEX) TO OUTPUT-SWITCH (SAVED-INDEX).
	IF SIDE EQUALS 2 MOVE SWITCH-FLAG (SAVED-INDEX) TO INPUT-SWITCH (SAVED-INDEX).
GET-SWITCH-EXIT.
	EXIT.
GET-A-COMMAND-WORD.
	MOVE 0 TO ERROR-FLAG.
	MOVE SPACES TO CODE-WORD.
	IF MAX-CHARACTER GO TO GET-A-COMMAND-WORD-EXIT.
	MOVE 1 TO X.
MOVE-A-CHARACTER-LOOP.
	MOVE COMMAND-CHARACTER (XX) TO DELIMITERR.
	ADD 1 TO XX.
	IF DELIMITERR EQUALS SPACE GO TO MOVE-A-CHARACTER-LOOP-A.
	IF ONES-WE-NOTICE
		GO TO GET-A-COMMAND-WORD-EXIT.
	IF DELIMITERR IS NUMERIC GO TO MOVE-A-CHARACTER-LOOP-B.
	IF DELIMITERR GREATER "@" AND
		DELIMITERR LESS "[" GO TO MOVE-A-CHARACTER-LOOP-B.
	DISPLAY "? ILLEGAL SYNTAX CHARACTER ", QUOTE, DELIMITERR, QUOTE, ".".
	MOVE 1 TO ERROR-FLAG.
	GO TO GET-A-COMMAND-WORD-EXIT.
MOVE-A-CHARACTER-LOOP-B.
	IF X GREATER THAN 6
		GO TO MOVE-A-CHARACTER-LOOP-A.
	MOVE DELIMITERR TO CODE-CHARACTER (X).
MOVE-A-CHARACTER-LOOP-A.
	ADD 1 TO X.
	IF MAX-CHARACTER GO TO GET-A-COMMAND-WORD-EXIT.
	GO TO MOVE-A-CHARACTER-LOOP.
GET-A-COMMAND-WORD-EXIT.
	EXIT.

DISPLAY-WITH-TRUNCATION.
	MOVE 0 TO COUNTT.
	MOVE 1 TO X.
DISPLAY-WITH-TRUNCATION-LOOP.
	IF SUPPRESS-CHARACTER (X) IS EQUAL TO SPACE
		ADD 1 TO COUNTT
		GO TO DISPLAY-WITH-TRUNCATION-LOOP-B.
DISPLAY-WITH-TRUNCATION-LOOP-A.
	IF COUNTT IS NOT EQUAL TO ZERO
		DISPLAY SPACE WITH NO ADVANCING
		SUBTRACT 1 FROM COUNTT
		GO TO DISPLAY-WITH-TRUNCATION-LOOP-A.
	DISPLAY SUPPRESS-CHARACTER (X) WITH NO ADVANCING.
DISPLAY-WITH-TRUNCATION-LOOP-B.
	ADD 1 TO X.
	IF X IS NOT EQUAL TO 80 GO TO DISPLAY-WITH-TRUNCATION-LOOP.
DISPLAY-WITH-TRUNCATION-EXIT.
	EXIT.
GET-USER-NUMBER.
	MOVE 0 TO ERROR-FLAG.
	PERFORM GET-A-NUMBER THRU GET-A-NUMBER-EXIT.
	PERFORM MAKE-IT-OCTAL THRU MAKE-IT-OCTAL-EXIT.
	IF DELIMITERR NOT EQUAL ","
		GO TO BAD-PPN.
	MOVE CURRENT-NUMBER TO USER-PPN.
	PERFORM GET-A-NUMBER THRU GET-A-NUMBER-EXIT.
	PERFORM MAKE-IT-OCTAL THRU MAKE-IT-OCTAL-EXIT.
	IF DELIMITERR EQUALS "]"
		MOVE COMMAND-CHARACTER (XX) TO DELIMITERR
		ADD 1 TO XX
		GO TO FORM-USER-NUMBER.
	IF MAX-CHARACTER GO TO FORM-USER-NUMBER.
BAD-PPN.
	MOVE 1 TO ERROR-FLAG.
	DISPLAY "? INCORRECT PPN." GO TO GET-USER-NUMBER-EXIT.
FORM-USER-NUMBER.
	MULTIPLY USER-PPN BY 262144 GIVING USER-PPN.
	ADD CURRENT-NUMBER TO USER-PPN.
	IF SIDE EQUALS 2 MOVE USER-PPN TO INPUT-USER-NUMBER.
	IF SIDE EQUALS 1 MOVE USER-PPN TO OUTPUT-USER-NUMBER.
GET-USER-NUMBER-EXIT.
	EXIT.
GET-A-NUMBER.
	MOVE 0 TO CURRENT-NUMBER.
GET-A-NUMBER-LOOP.
	MOVE COMMAND-CHARACTER (XX) TO DELIMITERR.
	ADD 1 TO XX.
	IF ONES-WE-NOTICE GO TO GET-A-NUMBER-LOOP-B.
	IF DELIMITERR EQUALS SPACE GO TO GET-A-NUMBER-LOOP-A.
	IF DELIMITERR NOT NUMERIC GO TO GET-A-NUMBER-LOOP-B.
	IF DELIM-NUM GREATER THAN 7 GO TO GET-A-NUMBER-EXIT.
	COMPUTE CURRENT-NUMBER EQUALS (CURRENT-NUMBER * 8) + DELIM-NUM.
GET-A-NUMBER-LOOP-A.
	IF MAX-CHARACTER GO TO GET-A-NUMBER-EXIT.
	GO TO GET-A-NUMBER-LOOP.
GET-A-NUMBER-LOOP-B.
	MOVE SPACES TO CODE-WORD.
GET-A-NUMBER-EXIT.
	EXIT.
MAKE-IT-OCTAL.
	MOVE 1 TO X.
MAKE-IT-OCTAL-LOOP.
	DIVIDE 10 INTO CURRENT-NUMBER GIVING CURRENT-NUMBER REMAINDER R (X).
	ADD 1 TO X.
	IF CURRENT-NUMBER NOT EQUAL ZERO
		GO TO MAKE-IT-OCTAL-LOOP.
MAKE-IT-OCTAL-LOOP-A.
	IF X EQUALS ZERO GO TO MAKE-IT-OCTAL-EXIT.
	COMPUTE CURRENT-NUMBER EQUALS (CURRENT-NUMBER * 10) + R (X).
	SUBTRACT 1 FROM X.
	GO TO MAKE-IT-OCTAL-LOOP-A.
MAKE-IT-OCTAL-EXIT.
	EXIT.
HELP-THE-MAN.
	DISPLAY " ".
	DISPLAY "THE COMMAND FORMAT IS:".
	DISPLAY "FN.EXT[PPN]/SWITCHES_FN.EXT[PPN]/SWITCHES".
	DISPLAY "THE SWITCHES ARE:".
	DISPLAY "HELP-----THIS MESSAGE".
	DISPLAY "NOLIST---CREATES NO LIST FILE".
	DISPLAY "NOSOUR---CREATES NO SOURCE FILE".
	DISPLAY "SEQUEN---RESEQUENCES SOURCE FILE".
	DISPLAY "THE DEFAULT IS CBL AND LST WITH NO SEQUENCE NUMBERS".
