




            Scientific Subroutine Package (SSP)











Program Title            Scientific Subroutine Package,
                         Version III

Program Origin           IBM System/360 Application Program
                         Number 360A-CM-03X

Source Language          FORTRAN IV

Program Description      "The Scientific Subroutine Package
                         (SSP) is a collection of over 250
                         FORTRAN subroutines divided, for
                         the sake of presentation, into two
                         groups: statistics and mathematics.
                         Also, over 200 subroutines are
                         presented in both single and double
                         precision mode.  SSP is a
                         collection of input/output-free
                         computational building blocks that
                         can be combined with a user's
                         input, output, or computational
                         routines to meet his needs."

Program Documentation    This document describes the
                         implementation and use of SSP on
                         the Wesleyan Computing Center
                         DECSystem-10.  The user is referred
                         to System/360 Scientific Subroutine
                         Package, Version III, Programmer's
                         Manual (IBM publication
                         gh20-0205-4) for complete
                         descriptions and listings of the
                         subroutines.  Copies of this manual
                         are in the keypunch room, the
                         computer room, and the WCC library.

Date                     1973 July 22

Scientific Subroutine Package                       PAGE   2



Using SSP on the Dec-10

     Various files related to SSP are kept in four different
places.  The relocatable binary files of the SSP routines
are in the indexed library file WES:SSP.REL.  The test cases
(in card deck format for input to CDRSTK) are on DECtape
D00011.  MAGtape M02017 contains a separate description of
each program.  MAGtape M12142 contains all of the above,
plus the source files for all SSP routines, plus control
files for compiling and arranging the sources.

LIBRARY FILE

     To use one or more unmodified SSP routines with your
main program, simply include CALLs to those routines (the
calling sequences are described in the IBM SSP Programmer's
Manual) in your program and add ",WES:SSP/LIBRARY" to your
LOAD, EXECUTE, or DEBUG command string.  The LOADER will
load those (and only those) SSP routines that your program
calls.

SAMPLE DECKS

     If you want to run one of the SSP sample decks, (e. g.
DASCR - data screening) type the following:

     .LOGIN 30,30             (30,30 is the demonstration
                               PPN)
     .MOUNT DTA SSP/VID:D00011/WLOCKED
     .R CDRSTK
     *START SSP:DASCR.CDK     (CDRSTK treats the file as if
                               it's a card deck)
     *^C
     .DISMOUT SSP/REMOVE
     .KJOB/F

Listings of the sample main program and any special sample
subroutines that it calls, the output from the program, and
a log file describing what happened will all be printed.  If
you want to use a sample main program with your own data, or
to modify one for your own purposes, get a copy of the
program and any special sample subroutines it calls from
M12142 (see below).

INDIVIDUAL PROGRAM DESCRIPTIONS

     M02017 contains a separate description of each SSP
subroutine, sample main program, and special sample
subroutine (except FUN).  These descriptions consist of the
text from the comment cards at the beginning of each
program.  Each program description contains purpose, usage,
description of parameters, remarks, subroutines and function
subprograms required, and method.  The tape is in FAILSAFE

Scientific Subroutine Package                       PAGE   3
Using SSP on the Dec-10


format.  The files are in alphabetical order and have the
extension .DOC.  To get descriptions of, for example, MINV,
MULTR, and EIGEN, type:

     .MOUNT MTA FAILSAFE/VID:M02017/WLOCKED
     .R FAILSAFE
     */W
     */G50,1107
     *EIGEN.DOC,MINV.DOC,MULTR.DOC
     *^C
     .UNLOAD FAILSAFE:
     .DISMOUNT FAILSAFE/REMOVE
     .PRINT/FORM:3HOLE/HEADER:0/DISPOSE:RENAME *.DOC

Note that if the files are not requested in the order in
which they appear on the tape (in this case, alphabetical),
FAILSAFE will search the tape more than once in order to
find the files.

M02017

     This tape is a 556 bpi double FAILSAFE of [50,1107].
If you want to get a copy of the source code for any SSP
program, this is where it's at.  It contains the following
files:

     SSP.DIR     Checksum directory of the files on the tape
     SSP.RNO     The source for this document
     SSP.MAN     This thing
     SSP.CCL     PIP command file to rename all SSP files to
                 a different directory in this order.
     SSP.CTL     Batch control file to compile, list, and
                 fudge all SSP subroutines
     SSP.CMD     Lists all SSP sources in the order in which
                 their .REL files will appear in the library
                 file.  The order is essentially
                 alphabetical, except that a few files were
                 moved so that the LOADER won't miss
                 anything on a one-pass search.
     SSP.REL     The indexed library file created by SSP.CTL
                 containing what's listed in SSP.CMD
     *.CDK       Card image sample decks for input to CDRSTK
     *.SSP       The subroutine source files.  The order of
                 these and of *.SMP and *.SSS is the same as
                 that in the "CATEGORICAL GUIDE TO
                 SUBROUTINES AND SAMPLE PROGRAMS" in the SSP
                 Programmer's Manual.
     LOC.MAC     MACRO rewrite of LOC
     *.SMP       Sample main programs
     *.SSS       Special sample subroutines
     LOC.IBM     The original FORTRAN LOC (replaced with a
                 MACRO version)
     RANDU.IBM   The IBM 360 machine-specific RANDU which

Scientific Subroutine Package                       PAGE   4
Using SSP on the Dec-10


                 has been replaced with a routine which
                 simply calls SETRAN, RAN, and SAVRAN.
     *.DOC       Individual program document files (see
                 description above).  The order is
                 alphabetical.


Implementation

Modifications

1)   RANDU, which is, of course, machine-specific, has been
     replaced with a routine that uses the same calling
     sequence as RANDU but calls SETRAN, RAN, and SAVRAN to
     do the work.  The original RANDU is on the tape as
     RANDU.IBM.

2)   The maximum magnitude of an exponent on the 360 is
     about twice that on the 10.  The following programs
     were changed accordingly: TALLY, TAB1, TAB2, MISR,
     SMIRN, MPAIR, BDTR, CDTR, NDTRI, BISER, PHI, POINT,
     TETRA, RECP, ACFI, DACFI, DCAR, DDCAR, DBAR, DDBAR,
     GMMMA, DLGAM, BESY, BESK, EXPI, SICI, CEL1, DCEL1,
     CEL2, DCEL2.

3)   The package contains several Gaussian quadrature
     routines.  In three of these (DQL32, DQH64, DQA32) the
     exponents of the coefficients of some of the terms in
     the series were too small (i.  e.  too far negative).
     In each of these cases the exponent of each term in the
     series was increased by 20 and the sum of the series
     was multiplied by 1d-20.

4)   Tests for end of card file were inserted in the sample
     programs.

5)   A call to the subroutine VARMX in the sample program
     FACTO was short one argument.  That was fixed.

6)   The very frequently used LOC routine was rewritten in
     MACRO.  The rewrite runs 3 to 5 times faster.


Testing

     The sample programs were run and the results were
compared with those given in the IBM SSP manual.  The
results agreeed within the accuracies of the machines.  One
sample program, SMPRT produced 3992 floating overflows, but
correct results.  According to the documentation on POLRT
(the subroutine which SMPRT uses) this is not unexpected.

