      SUBROUTINE SCALE (ARRAY,AXSLEN,NPT)
C
C
C    THIS ROUTINE ALLOWS THE CALLER SCALE THE ARRAY OF DATA.
C
C
C    CALLING SEQUENCE:
C
C           CALL SCALE (ARRAY,AXSLEN,N)
C
C    ARRAY  - (I/O) THE ARRAY TO SCALED (ARRAY MUST BE DIMENSIONED TO AT
C              LEAST N+2)
C
C    AXSLEN - (I) THE LENGTH OF THE AXIS
C
C    N      - (I) THE NUMBER OF POINTS IN THE ARRAY (IF N IS LESS THAN ZERO
C              THE MAXIMUM TO MINIMUM IS FOUND AND THE ABSOLUTE VALUE
C              OF N IS USED)
C
C      NOTE: UPON RETURN ARRAY(N+1) EQUALS THE MINIMUM (OR MAXIMUM)
C            AND ARRAY(N+2) EQUALS THE DELTA VALUE
C
C
C    SUBPROGRAMS USED:
C
C      IFIX, MAXMIN, AINT, IABS, ABS AND ALOG10
C
C
      DIMENSION ARRAY(1),DEL(5)
      DATA DEL / 1,2,4,5,8 /

      IPT = IABS(NPT)
      CALL MAXMIN (ARRAY,IPT,AMAX,AMIN)

      AXSLN = AINT(ABS(AXSLEN))
      DELTA = (AMAX - AMIN) / AXSLN
      EXP = ALOG10(DELTA)
      IF (EXP .LT. 0) EXP = EXP - 0.9999999
      POWER = 10.0 ** IFIX(EXP)

      AMIN = AMIN / POWER
      IF (AMIN .LT. 0) AMIN = AMIN - 0.9999999
      AMIN = AINT(AMIN) * POWER

      DELTA = (AMAX - AMIN) / AXSLN
      EXP = ALOG10(DELTA)
      IF (EXP .LT. 0) EXP = EXP - 0.9999999
      POWER = 10.0 ** IFIX(EXP)

      DELTA = DELTA / POWER
      DO 10 I = 1,5
         IF (DELTA .GT. DEL(I)) GOTO 10
         DELTA = DEL(I)
         GOTO 20
10       CONTINUE
      DELTA = 10.0
20    DELTA = DELTA * POWER

      AMIN = AMIN / DELTA
      IF (AMIN .LT. 0.0) AMIN = AMIN - 0.9999999
      AMIN = AINT(AMIN) * DELTA
      IF (NPT .GE. 0) GOTO 30
      AMIN = AMIN + DELTA * AXSLN
      DELTA = -DELTA

30    ARRAY(IPT+1) = AMIN
      ARRAY(IPT+2) = DELTA

      RETURN
      END
