OPERATING INSTRUCTIONS FOR W.M.U. SUBROUTINES IN SYS:FORLIB.REL.


DISCLAIMER: ALTHOUGH ALL THE SUBROUTINES LISTED HEREIN HAVE BEEN
CAREFULLY TESTED, THE AUTHOR MAKES NO GUARANTEE OF THEM 
WHATSOEVER,AND CAN ASSUME NO RESPONSIBILTY FOR ANY ERRORS IN THEM OR
IN THEIR USE.



SUBROUTINES AVAILABLE:
ACMSRT:		SORT
ALLCOR:		DYNAMIC CORE ALLOCATION.
ASSIGN:		ASSIGN A DEVICE
BLOCKT:		TRANSFER A BLOCK (ARRAY OR VECTOR) OF DATA (BLT)
BUSY:		STOP PROGRAM UNTIL DEVICE IS AVAILABLE.
CHKCHN:		FIND FREE FORTRAN UNIT NUMBER
CHKNAM:		CHECK LEGALITY OF FILENAME.
CLOCK:		DETERMINE TIME OF DAY IN HOURS,MIN.,SEC.,1/60TH'S SEC.
DAY:		DETERMINE YEAR, MONTH, AND DATE.
DEASSIGN:	DEASSIGN A DEVICE
DELETE:		DELETE FILES.
DEVCHR:		DETERMINE AND RETURN DEVICE CHARACTERISTICS.
DEVICE:		CALL EXIT IF DEVICE IS NOT TELETYPE.
DEVTYP:		RETURN RESULT OF DEVTYP MONITOR CALL
DISMOUNT:	REQUEST THE OPERATOR TO DISMOUNT A DEVICE.
DROTATE:	DOUBLE PRECISION ROTATE(ROTC)
DSHIFT:		DOUBLE PRECISION LOGICAL SHIFT(LSHC)
DTRNAC:		DECTAPE RANDOM ACCESS.(I/O)
DYTIME:		DAYTIME IN MILLISECONDS.
ECHO:		TURN ECHOING OF TELETYPE INPUT ON OR OFF.
EXIST:		CHECK FOR EXISTANCE OF FILE.
FNDSPC:		FIND FILE STRUCTURE WITH MOST FREE SPACE
GETBYT:		GET AN ARBITRARY BYTE.
GETCHR:		UNPACK A CHARACTER FROM A WORD.
GETPPN:		RETURN PROJECT-PROGRAMMER NUMBER OF USER.
GTCORE:		GET LOW SEGMENT CORE FROM FOROTS.
JOBNUM:		DETERMINE JOB NUMBER.
LSCORE:		RETURN CORE ALLOCATED BY GTCORE.
MAXIMUM:	FIND MAXIMUM OF A LIST.
MAXWYT:		LIMIT WAIT FOR INPUT FROM TELETYPE.
MINIMUM:	FIND MINIMUM OF LIST.
MINVSQ:		INVERT A GENERAL SQUARE MATRIX.
MOUNT:		REQUEST THE OPERATOR TO MOUNT A DEVICE.
PEEK:		EXAMINE A MONITOR LOCATION
PRINTS:		PRINT A SPECIFIED FILE ON THE LINE PRINTER.
PROTEK:		PROTECT A FILE FROM WITHIN PROGRAM.
PUTBYT:		PUT AN ARBITRARY BYTE.
PUTCHR:		PACK A CHARACTER INTO A WORD.
QUEOUT:		QUEUE A FILE TO AN OUTPUT SPOOLER.
REASSIGN:	REASSIGN A DEVICE TO ANOTHER JOB.
REDTTY:		READ TTY PARAMETERS
RENAME:		RENAME A FILE.
RENAMS:		RENAME,DELETE, AND/OR PROTECT FILES ON ANY DEVICES.
RESTART:	RESTART PROGRAM AT BEGINNING.
RNTIME:		RUNTIME OF JOB IN MILLISECONDS.
ROTATE:		SINGLE PRECISION ROTATE(ROT)
RUNUUO:		TRANSFER CONTROL TO NEW PROGRAM.
SETTTY:		SET TTY PARAMETERS
SHIFT:		SINGLE PRECISION LOGICAL SHIFT(LSH)
SLEEP:		PUT JOB TO SLEEP FOR PREDETERMINED TIME.
SORT:		SORT.
SSORT:		SORT.
SUBMIT:		ENTER A JOB IN THE INPUT (BATCH) QUEUE.
TRUTH:		MANIPULATE COMPACTED TRUTH TABLE.
TTYNAM:		RETURN NAME OF USER'S TELETYPE.
TTYPTY:		DETERMINE IF ON TELETYPE OR PSEUDO-TELETYPE.
TYPEON:		TURN OFF CONTROL O AND TURN ON TYPE OUT
XPRODH:		FORM CROSS-PRODUCT MATRIX AND SUMS.
XPRODP:		FORM CROSS-PRODUCT MATRIX AND SUMS.
ZEROH:		ZERO MATRIX AND VECTOR.
ZEROP:		ZERO VECTOR.


************************************************************************
DESCRIPTIONS OF INDIVIDUAL SUBROUTINES.


		ACMSRT

PURPOSE		TO SORT A SINGLE DIMENSIONAL ARRAY INTO ASCENDING
	ORDER.

USAGE		CALL ACMSRT(VECTOR,N)
	WHERE	VECTOR	IS THE SINGLE DIMENSIONAL ARRAY( A VECTOR)
			TO BE SORTED.
		N	IS THE NUMBER OF ELEMENTS TO BE SORTED IN THE
			ARRAY. N IS LIMITED BY THE AMOUNT OF CORE
			AVAILABLE TO THE PROGRAM, AND BY THE PROGRAM.
			(IF CORE IS AVAILABLE, N MAY BE AS LARGE AS
			2**17-1)  20000 NUMBERS MAY BE SORTED IN
			APPROXIMATELY 3.5 SECONDS OF CPU TIME.

METHOD		ORDERING IS BY INTEGER SUBRACTION.  PROGRAM TAKEN
		FROM JOURNAL OF THE ASSOCIATION OF COMPUTING MACHINERY.

************************************************************************


		ALLCOR

PURPOSE:	DYNAMICALLY ALLOCATE CORE FOR USE BY A FORTRAN PROGRAM.
	THIS ALLOWS A PROGRAM TO HANDLE LARGE PROBLEMS WITHOUT HAVING TO
	RESERVE THAT MUCH SPACE WHEN THE PROGRAM WAS LOADED, THUS
	PENALIZING USERS WHO DON'T NEED THAT MUCH SPACE AND ALSO HURTING
	SYSTEM THROUGHPUT.

USAGE:		CALL ALLCOR(MAX,IERR,IREL,SPACE(1))
	WHERE	MAX:	TOTAL AMOUNT OF STORAGE TO BE RESERVED.
		IERR:	IS ERROR CODE RETURNED.
			IERR=0 NO ERROR.
			IERR=1 WARNING! CORE OBTAINED BUT NO MORE IS
				AVAILABLE, OR MAX<0.  MAY RESULT IN FATAL ERROR
				LATER IN RUN.
			IERR=-1 CORE NOT AVAILABLE.
		IREL:	SUBSCRIPT ON SPACE SUCH THAT SPACE(IREL) IS
			FIRST LOCATION IN ALLOCATED CORE. OTHER ARRAYS
			(BEYOND FIRST) ARE AT SPACE(IREL+LENGTH1),
			SPACE(IREL+LENGTH1+LENGTH2),ETC. WHERE LENGTHN IS
			 SIZE IN WORDS OF THE NTH ARRAY.  REMEMBER THAT DOUBLE
			 PRECISION AND COMPLEX ARRAYS USE TWO WORDS PER ENTRY.
		SPACE:	A ONE ELEMENT ARRAY WHICH ALL ALLOCATED CORE
			IS TO BE ADDRESSED RELATIVE TO. (MUST BE SINGLE PRECISION)

	THIS ROUTINE MAY OPERATE IN EITHER OF TWO MODES.  ON A NON-
	VIRTUAL MEMORY SYSTEM, IT WILL ATTEMPT TO ALLOCATE CORE IN THE
	PROGRAMS HIGH SEGMENT.  THIS REQUIRES THAT EITHER FOROTS
	BE FORCED TO LOAD INTO THE LOW SEGMENT, SO THAT THERE IS NO
	HIGH SEGMENT AT ALL, OR CREATING A NON-SHAREABLE HIGH SEGMENT
	AS PART OF THE PROGRAM (IT CANNOT BE GETSEGED).  IF A
	WRITEABLE HIGH SEGMENT CAN NOT BE CREATED, OR THE HIGH SEGMENT
	WHICH EXISTS CAN NOT BE WRITE ENABLED, ALLCOR WILL PRINT THE
	MESSAGE "CANNOT WRITE ENABLE HIGH SEGMENT DATA AREA".  THE LOAD
	COMMAND FOR A PROGRAM USING THIS FORM OF ALLCOR IS

LOAD %'SEG:LOW' FILE-SPEC,FILE-SPEC,...,SYS:FORLIB/LIB

	IF LINK-10 IS USED, OR IF LOADER IS USED,

LOAD %H FILE-SPEC,FILE-SPEC,...,SYS:FORLIB/LIB

	IF THE PROGRAM IS RUN ON A VIRTUAL MEMORY SYSTEM, AND FOROTS
	HAS BEEN MODIFIED TO UNDERSTAND PAGING(AS IT HAS AT W.M.U.)
	ALLCOR WILL ALLOCATE CORE IN THE FORM OF PAGES.  THE PAGES
	WILL HAVE ADDRESSES IMMEDIATELY ABOVE THE HIGH SEGMENT (IF
	ONE EXISTS) BUT ARE CONSIDERED TO BE NON-CONTIGUOUS LOW SEGMENT
	PAGES (WHICH IS WHY FOROTS HAS TO UNDERSTAND).  THIS ALLOWS THE
	USE OF THE SHAREABLE FOROTS, WHICH IMPROVES PERFORMANCE OF THE SYSTEM.
	IF FOROTS HAS NOT BEEN MODIFIED, ALLCOR WILL BEHAVE AS THOUGH THE SYSTEM
	WAS A NON-VIRTUAL MEMORY SYSTEM.  NO SPECIAL LOADING INSTRUCTIONS
	ARE NECESSARY IF THE PAGING FORM OF ALLCOR IS TO BE USED.



************************************************************************


		ASSIGN

PURPOSE		TO ASSIGN A NONSHARABLE DEVICE(SUCH AS CDR,LPT,CDP,ETC)
	TO A USER'S JOB FROM WITHIN THE PROGRAM.

USAGE		CALL ASSIGN(IDEV,IERR)
	OR	CALL ASSIGN(IDEV,IERR,NSECS)
	WHERE	IDEV:	FORTRAN UNIT NUMBER OF DEVICE TO ASSIGN
			OR ASCII NAME OF DEVICE
		IERR:	IS ERROR CODE
			=0 GOT IT
			=-1 NO SUCH DEVICE OR DEVICE CANNOT BE ASSIGNED.
		NSECS:	MAXIMUM NUMBER OF SECONDS TO WAIT FOR DEVICE

	NOTE THAT PROGRAM WILL SLEEP UNTIL THE DEVICE CAN BE ASSIGNED
		WHICH WILL BE INFINITE TIME IF DEVICE IS RESTRICTED.



************************************************************************


		BLOCKT

PURPOSE		TO MOVE A BLOCK (ARRAY OR VECTOR) FROM ONE AREA TO
	ANOTHER IN LESS TIME THAN IT TAKES TO DO IT ONE WORD AT A TIME.

USAGE		CALL BLOCKT(ARRAY1,ARRAY2,LENGTH)
	WHERE	ARRAY1:	IS THE BLOCK (VECTOR OR ARRAY) TO BE TRANSFERRED.
		ARRAY2:	IS THE ARRAY WHERE ARRAY1 IS TO BE PUT.
		LENGTH:	IS THE NUMBER OF WORDS TO BE TRANSFERRED.


************************************************************************


		BUSY

PURPOSE		MAKE PROGRAM WAIT UNTIL SPECIFIED DEVICE IS AVAILABLE
	TO PROGRAM.

USAGE		CALL BUSY(IDEV)
	WHERE:	IDEV:	FORTRAN UNIT NUMBER OF DESIRED DEVICE.
			OR ASCII NAME OF DEVICE

NOTE THAT RESTRICTED DEVICES WILL ALWAYS APPEAR BUSY.


************************************************************************


		CHKCHN
PURPOSE:	FIND AN UNUSED FORTRAN UNIT NUMBER OR ENQUIRE WHETHER A
		UNIT NUMBER IS IN USE, AND RETURN THAT NUMBER AND THE
		NUMBER OF THE ASSOCIATED SOFTWARE CHANNEL.

USAGE:		CALL CHKCHN(NMUNIT,NUMFND,NMSOFT)
	OR	CALL CHKCHN(NMUNIT,NUMFND)
	WHERE:	NMUNIT:	IS FORTRAN UNIT NUMBER DESIRED
			NMUNIT=1-63	UNIT NUMBER DESIRED
			NMUNIT=0	REQUESTING ANY FREE UNIT NUMBER

		NUMFND:	IS THE UNIT NUMBER FOUND
			NUMFND=1-63	FORTRAN UNIT NUMBER AVAILABLE
			NUMFND=0	IF NONE AVAILABLE
			NUMFND=-1	NMUNIT VALUE IS ILLEGAL

		NMSOFT:	SOFTWARE CHANNEL NUMBER RETURNED(OPTIONAL ARG)
			NMSOFT=-1	IF NMUNIT=0 OR IS AVAILABLE
			NMSOFT=0-17	IF NMUNIT IS NOT AVAILABLE


************************************************************************


		CHKNAM

PURPOSE:	CHECK LEGALITY OF A FILENAME.  (OF USE PRIMARILY IN
	CONVERSATIONAL PROGRAMMING WHERE INPUT PARAMETERS ARE ALWAYS
	OF DOUBTFUL ACCURACY.

USAGE:		CALL CHKNAM(NAME,IERR)
	OR	CALL CHKNAM(NAME,IERR,IEXT)
	WHERE:	NAME:	IS FILENAME.EXT.(MUST BE AT LEAST A TWO WORD
		QUANTITY.)
		IERR:	IS ERROR CODE.
			IERR=0  VALID NAME.
			IERR=-1 ILLEGAL NAME.
		IEXT:	(IF PRESENT) IS EXTENSION CODE.
			IEXT=0  NULL EXTENSION
			IEXT=-1 NON-NULL EXTENSION.


************************************************************************


		CLOCK

PURPOSE		TO DETERMINE EXACT TIME OF DAY IN HOURS (FROM MIDNITE),
	MINUTES, SECONDS, AND CLOCK TICKS(1/60TH'S OF A SECOND).
	ANSWER IN INTEGER FORM.

USAGE		CALL CLOCK(IHOUR,IMIN,ISEC,ITICK)
	WHERE	IHOUR:	HOUR OF DAY(24-HOUR TIME) FROM MIDNITE.
		IMIN:	MINUTE.
		ISEC:	SECOND.
		ITICK:	CLOCK TICK.


************************************************************************


		DAY

PURPOSE		TO DETERMINE YEAR, MONTH, AND DAY.

USAGE		CALL DAY(IYEAR,IMONTH,IDAY)
	WHERE	IYEAR:	INTEGER YEAR(RETURNED)
		IMONTH:	INTEGER MONTH(1-12)(RETURNED)
		IDAY:	INTEGER DATE OF MONTH.



************************************************************************


		DEASSIGN

PURPOSE		TO DEASSIGN A DEVICE WHICH IS ASSIGNED TO A USER'S
	JOB, FROM WITHIN A PROGRAM.

USAGE		CALL DEASSI(IDEV)
	WHERE	IDEV:	FORTRAN UNIT NUMBER OR ASCII NAME OF DEVICE
			 TO DEASSIGN.

	NOTE THAT IF DEVICE IS NOT ASSIGNED TO JOB, OR IF DEVICE IS
	NOT DEASSIGNABLE, THIS ROUTINE IS A NO-OP.
	NOTE ALSO THAT THIS ROUTINE DOES NOT WORK UNDER LEVEL-C MONITORS.


************************************************************************


		DELETE

PURPOSE:	TO DELETE FILES.

USAGE:		SEE RENAMS.


************************************************************************


		DEVCHR

PURPOSE		TO DETERMINE THE CHARACTERISTICS OF A DEVICE.

	USAGE	CALL DEVCHR(IDEV,ICHAR)
	WHERE	IDEV:	IS FORTRAN UNIT NUMBER OF DEVICE.
			OR ASCII NAME OF DEVICE
	AND	ICHAR:	IS RETURNED DEVICE CHARACTERISTICS, AS FOLLOWS:

	BIT			MEANING IF BIT IS SET
	 0		DECTAPE DIRECTORY IS IN CORE.
	 1		DEVICE IS A DISK.
	 2		DEVICE IS A CARD READER.
	 3		DEVICE IS A LINE PRINTER.
	 4		TTY ATTACHED TO JOB.
	 5		TTY IN USE AS A USER CONSOLE(EVEN IF DETACHED)
	 6		TTY IN USE AS I/O DEVICE.
	 7		DEVICE IS A DISPLAY.
	 8		DEVICE HAS A LONG DISPATCH TABLE(RECOGNIZES UUO'S
			    OTHER THAN INPUT,OUTPUT,CLOSE, AND RELEAS)
	 9		DEVICE IS A PAPER TAPE PUNCH.
	10		DEVICE IS A PAPER TAPE READER.
	11		DEVICE IS A DECTAPE.
	12		DEVICE IS AVAILABLE TO THIS JOB OR ALREADY
			    ASSIGNED TO THIS JOB.
	13		DEVICE IS A MAGNETIC TAPE.
	14		DEVICE IS A TTY.
	15		DEVICE HAS A DIRECTORY(DTA OR DSK)
	16		DEVICE CAN DO INPUT.
	17		DEVICE CAN DO OUTPUT.
	18		DEVICE ASSIGNED BY CONSOLE COMMAND.
	19		DEVICE ASSIGNED BY PROGRAM(INIT UUO)
  REMAINING BITS	IF BIT (35-N) CONTAINS A 1, THEN MODE N IS LEGAL
			    FOR THE DEVICE.


************************************************************************


		DEVICE

PURPOSE:	TO DETERMINE IF A JOB IS RUNNING FROM TELETYPE OR
	BATCH,AND IF A SPECIFIED DEVICE IS ACTUALLY THE TELETYPE.
	IF JOB IS NOT RUNNING FROM TELETYPE, OR DEVICE IS NOT TELETYPE,
	TERMINATE PROGRAM.
	THIS IS USEFUL IN CONVERSATIONAL PROGRAMS WHERE AN ILLEGAL
	PARAMETER CAN BE CORRECTED FROM TELETYPE, BUT CANNOT UNDER
	BATCH OR IF BEING ENTERED FROM SOME OTHER DEVICE THAN TELETYPE.

USAGE:		CALL DEVICE(IDEV)
	WHERE:	IDEV:	IS FORTRAN UNIT NUMBER OF INTEREST.
			OR ASCII NAME OF DEVICE


************************************************************************


		DEVTYP

PURPOSE		TO FIND OUT ABOUT A DEVICE BY DOING A DEVTYP MONITOR CALL.

USAGE		CALL DEVTYP(IDEV,ICHAR)
	WHERE	IDEV - IS FORTRAN UNIT NUMBER OF DEVICE OR ASCII DEVICE
				NAME.
		ICHAR - IS WORD RETURNED BY DEVTYP, AS FOLLOWS:
	BIT		MEANING
	 0	LOOKUP/ENTER MANDATORY.
	1-11	RESERVED FOR FUTURE
	12	DEVICE IS AVAILABLE TO THIS JOB.
	13	SPOOLED ON DISK. (OTHER BITS REFLECT PROPERTIES OF
		REAL DEVICE, EXCEPT VARIABLE BUFFER SIZE)
	14	INTERACTIVE DEVICE (OUTPUT AFTER EACH BREAK CHARACTER)
	15	CAPABLE OF VARIABLE BUFFER SIZE (USER CAN SET HIS OWN
		BUFFER LENGTHS)
	16	CAPABLE OF INPUT
	17	CAPABLE OF OUTPUT
	18-26	JOB NUMBER THAT CURRENTLY HAS DEVICE ASSIGNED OR INITED
	27-28	RESERVED FOR THE FUTURE
	29	DEVICE IS A RESTRICTED DEVICE (I.E., CAN ONLY BE ASSIGNED
		BY A PRIVILEGED JOB OR THE MOUNT COMMAND)
	30-35	DEVICE TYPE CODE (OCTAL)
		CODE	MNEMONIC	MEANING
		  0	DSK	    DISK OF SOME SORT
		  1	DTA	    DECTAPE
		  2	MTA	    MAGNETIC TAPE
		  3	TTY	    TTY OR EQUIVALENT
		  4	PTR	    PAPER-TAPE READER
		  5	PTP	    PAPER-TAPE PUNCH
		  6	DIS	    DISPLAY
		  7	LPT	    LINE PRINTER
		 10	CDR	    CARD READER
		 11	CDP	    CARD PUNCH
		 12	PTY	    PLOTTER
		 13	PLT	    PLOTTER
		 14	EXT	    EXTERNAL TASK
		 15	MPX	    SOFTWARE MPX
		 16	PAR	    PA611R ON DC44
		 17	YCR	    PC11(R) ON DC44
		 20	PAP	    PA611P ON DC44
		 21	LPC	    LPC-11 ON DC44
		 22	PCP	    PC-11(P) ON DC44
		23-57		    RESERVED FOR DIGITAL
		60-77		    RESERVED FOR CUSTOMER



************************************************************************



		DISMOUNT

PURPOSE:	TO PERFORM THE FUNCTION OF THE MONITOR COMMAND DISMOUNT
	AS A SUBROUTINE.

USAGE:		CALL DISMOUNT(LOGNAM,IERR)
	WHERE:	LOGNAM - IS THE LOGICAL OR PHYSICAL NAME OF THE
			 DEVICE TO BE DISMOUNTED.
		IERR   - IS AN ERROR CODE.
			VALUE		MEANING
			  0	DISMOUNT SUCCESSFUL. NO ERRORS.
			  1	DEVICE NAME IS ILLEGAL OR DEVICE DOES NOT
				EXIST.
			 -1	DISMOUNT WAS UNSUCCESSFUL FOR SOME UNKNOWN
				REASON.
	NOTE:	A /REMOVE IS IMPLIED IN ALL CALLS TO THIS ROUTINE.



************************************************************************


		DROTATE

PURPOSE:	TO ROTATE A DOUBLE WORD QUANTITY.

USAGE		CALL DROTATE(WORD,IPLACE,WORD1)
	WHERE	WORD	IS DOUBLE WORD TO BE ROTATED.
		IPLACE	IS NUMBER OF PLACES TO ROTATE WORD.
			IF IPLACE IS POSITIVE, ROTATE LEFT, IF NEGATIVE,
			ROTATE RIGHT.
		WORD1	IS DOUBLE WORD RESULT.


************************************************************************


		DSHIFT

PURPOSE		TO LOGICAL SHIFT A DOUBLE WORD QUANTITY.

USAGE		CALL DSHIFT(WORD,IPLACE,WORD1)
	WHERE	WORD	IS DOUBLE WORD QUANTITY TO BE SHIFTED.
		IPLACE	IS NUMBER OF PLACES TO SHIFT.
			IF IPLACE IS POSITIVE, SHIFT LEFT, IF NEGATIVE,
			SHIFT RIGHT.
		WORD1	IS DOUBLE WORD RESULT.


************************************************************************


		DTRNAC
PURPOSE:	TO RANDOM ACCESS A DECTAPE FOR INPUT AND OUTPUT.

USAGE:		CALL DTRNAC(N,A,IA,IDTA,NWORDS)
	WHERE:	N:	FIRST PHYSICAL BLOCK NUMBER DESIRED. 0<N<578.
			IF ATTEMPT IS MADE TO ACCESS AN ILLEGAL BLOCK
			NUMBER PROGRAM WILL ABORT.
		A:	DATA MATRIX.
		IA:	CODE FOR I/O.(1 FOR INPUT, 2 FOR OUTPUT)
		IDTA:	FORTRAN DEVICE NUMBER OF DTA.
		NWORDS:	NUMBER OF WORDS IN USER RECORD.

NOTE THAT SINCE THIS PROGRAM INDEXES ON PHYSICAL BLOCK NUMBER, NO
ATTENTION CAN BE PAID TO ANY PRE-EXISTING FILE STRUCTURE ON THE TAPE!
THEREFORE, THIS PROGRAM SHOULD ONLY BE USED WHERE IT'S FILE IS
SOLE OCCUPANT OF THE TAPE!

NOTE THAT ONE PHYSICAL BLOCK CONTAINS 128 WORDS, BUT THAT A RECORD MAY
CONTAIN MORE THAN ONE BLOCK.


************************************************************************


		DYTIME

PURPOSE:	FIND DAYTIME IN MILLISECONDS.

USAGE:		CALL DYTIME(ITIME)
	WHERE:	ITIME:	IS TIME OF DAY RETURNED IN MILLISECONDS.



************************************************************************



		ECHO

PURPOSE:	TO TURN ECHOING OF CHARACTERS ON THE TELETYPE ON OR OFF
	SO THAT NON-PRINTING INFORMATION CAN BE ENTERED.

USAGE:		CALL ECHO(ICMD)
	WHERE:	ICMD - IS A SWITCH SPECIFYING ECHO ON OR ECHO OFF.
		VALUE		MEANING
		  0	   TURN ECHO ON
		  1	   TURN ECHO OFF

	NOTE:	A CARRIAGE RETURN DOES NOT GENERATE A LINE-FEED WHEN
		ECHO IS TURNED OFF, SO THIS MUST BE ALLOWED FOR
		BY THE CALLING PROGRAM.



************************************************************************


		EXIST

PURPOSE:	TO CHECK TO MAKE SURE THAT A GIVEN FILENAME EXISTS ON
	DISK AND IS READABLE.

USAGE:		CALL EXIST(NAME,IERR)
	OR	CALL EXIST(NAME,IERR,IPROJ,IPROG)
	OR	CALL EXISTS(IDEV,NAME,IERR)
	OR	CALL EXISTS(IDEV,NAME,IERR,IPROJ,IPROG)
	WHERE	IDEV:	FORTRAN UNIT NUMBER OR ASCII DEVICE NAME
			TO CHECK ON. IF NO SUCH DEVICE, USE 'DSK'.
		NAME:	NAME OF FILE AND EXTENSION.  MUST BE A TWO
			WORD QUANTITY.
		IERR:	ERROR CODE.
			IERR=0  FILE EXISTS AND NAME IS LEGAL.
			IERR=-1  NAME IS ILLEGAL.
			IERR=1  FILE NOT FOUND OR NOT READABLE.
		IPROJ:	(IF PRESENT) PROJECT NUMBER.
		IPROG:	(IF PRESENT) PROGRAMMER NUMBER.

CALLS TO EXISTS ARE PREFERABLE, SINCE DEVICE MAY BE OTHER THAN DSK.


************************************************************************


		FNDSPC

PURPOSE:	TO FIND THE FILE STRUCTURE WITH THE MOST FREE SPACE AVAILABLE
	TO THIS USER.  AVAILABLE MEANS THAT THE STRUCTURE IS WRITEABLE
	AND THAT THE SPACE IS LESS THAN OR EQUAL TO THE USERS LOGGED-IN
	(FCFS) DISK QUOTA.

USAGE:		CALL FNDSPC(STRNAM,IFREE)
	WHERE	STRNAM - IS THE ASCII NAME OF THE STRUCTURE RETURNED
			 BY THE SUBROUTINE.
		IFREE  - IS THE AMOUNT OF SPACE AVAILABLE TO THE USER
			 ON THE STRUCTURE AT THE TIME OF THE CALL.


************************************************************************


		GETBYT

PURPOSE:	TO GET AN ARBITRARY BYTE FROM A WORD (SIMULATE AN
	LDB INSTRUCTION).

USAGE		CALL GETBYT(SRCWD,IBYTE,ISIZE,IRMOST,IERR)
	WHERE
		SRCWD  - WORD TO GET BYTE OUT OF
		IBYTE  - WORD TO PUT BYTE INTO
		ISIZE  - SIZE OF BYTE (1 TO 36)
			 MUST NOT BE GREATER THAN IRMOST+1
		IRMOST - POSITION OF RIGHTMOST BIT OF BYTE (0 TO 35)
		IERR   - ERROR CODE. NON-ZERO IF ARGUMENTS ARE ILLEGAL



************************************************************************


		GETCHR

PURPOSE:	TO UNPACK A CHARACTER FROM WITHIN A PACKED WORD(S)
	AND LEFT JUSTIFY IT IN A WORD.

USAGE:		CALL GETCHR(WORD,IBYTE,CHAR)
	WHERE	WORD:	PACKED WORD(S).
		IBYTE:	BYTE NUMBER IN PACKED WORD(S).
		CHAR:	UNPACKED CHARACTER.


************************************************************************


		GETPPN

PURPOSE		FIND OUT THE PROJECT PROGRAMMER NUMBER OF THE USER
	RUNNING THE JOB.

USAGE		CALL GETPPN(IPROJ,IPROG)
	WHERE	IPROJ:	PROJECT NUMBER(IN OCTAL) RETURNED.
		IPROG:	PROGRAMMER NUMBER(IN OCTAL) RETURNED.


************************************************************************

		GTCORE

PURPOSE:	TO ALLOCATE CORE IN THE LOW SEGMENT DYNAMICLY USING
	FOROTS.  THIS IS DESIREABLE SINCE IT PERMITS USE OF THE
	SHAREABLE FOROTS HIGH SEGMENT.

USAGE:		CALL GTCORE(IWORDS,BASE,IOFFST,IERR)
   OR:		CALL GTCORE(IWORDS,BASE,IOFFST,IERR,IRESV)

	WHERE
		IWORDS - NUMBER OF WORDS OF CORE TO ALLOCATE.
		BASE   - ARRAY RELATIVE TO WHICH ALLOCATED CORE IS TO
			 BE ADDRESSED.
		IOFFST - BASE OFFSET INTO ARRAY TO GET FIRST ALLOCATED
			 WORD.
		IERR   - ERROR CODE.
				VALUE	MEANING
				  0	NO ERROR. CORE ALLOCATED.
				 -1	INSUFFICIENT CORE.
				  1	INSUFFICIENT CORE TO ALLOCATED RESERVE.
					 IWORDS ALLOCATED.
		IRESV  - NUMBER OF WORDS TO RESERVE FOR FOROTS (IN ONE CHUNK)
			  THIS ARGUMENT IS OPTIONAL.

NOTES:	THIS CORE ALLOCATION ROUTINE IS USED SIMILARY TO ALLCOR.  HOWEVER,
	CORE IS ALLOCATED IN THE LOW SEGMENT, AND MUST BE GIVEN BACK TO
	FOROTS BEFORE A IT CAN BE REALLOCATED.  ADDITIONAL ALLOCATIONS
	MAY BE MADE INDEPENDENTLY, BUT THE OFFSET OF EACH MUST
	BE REMEMBERED SO THAT THE CORE MAY BE RETURNED.  FREQUENT REALLOCATIONS
	SHOULD BE AVOIDED, SINCE CORE MAY BECOME FRAGMENTED MAKING IT
	IMPOSSIBLE TO GET THE DESIRED AMOUNT OF CORE IN ONE BLOCK.

	THIS ROUTINE WORKS WELL WITH CHAINB, BUT NOT WITH LINK-OVERLAYS.
	THIS IS BECAUSE LINK-OVERLAYS DO NOT PREALLOCATE THEIR CORE
	AND THE CORE REQUIRED FOR A NON-RELOCATABLE OVERLAY MAY BE TAKEN
	BY GTCORE, MAKING THE PROGRAM NON-RUNNABLE.
	THIS PROBLEM CAN BE REDUCED BY ENSURING THAT THE LARGEST OVERLAY
	IS IN CORE WHENEVER GTCORE IS CALLED.  IF THIS IS DONE, THE SITUATION
	WILL REDUCE TO APPROXIMATELY WHAT IT WOULD BE IF GTCORE WERE
	NOT BEING USED.  HOWEVER, THE PROGRAM MAY STILL BOMB BECAUSE
	FOROTS HAS TAKEN CORE THAT AN OVERLAY NEEDS.


************************************************************************

		JOBNUM

PURPOSE		TO DETERMINE JOB NUMBER OF USER'S JOB.

USAGE		CALL JOBNUM(IJOB)
	WHERE	IJOB:	INTEGER JOB# (RETURNED)


************************************************************************


		LSCORE

PURPOSE:	TO RETURN CORE ALLOCATED BY GTCORE TO FOROTS FOR REUSE.

USAGE:		CALL LSCORE(BASE,IOFFST)
	WHERE
		BASE   - IS ARRAY RELATIVE TO WHICH THE CORE IS ADDRESSED.
		IOFFST - IS THE OFFSET INTO THE ARRAY THAT POINTS TO THE
			 FIRST ALLOCATED WORD


************************************************************************


		MAXIMUM

PURPOSE:	TO FIND MAXIMUM ELEMENT IN ONE-DIMENSIONAL ARRAY(FIXED
	POINT OR SINGLE PRECISION FLOATING POINT.)

USAGE		CALL MAXIMUM(ARRAY,NUM,ANS)
	WHERE	ARRAY	IS LIST TO PICK MAXIMUM OUT OF.
		NUM	IS SIZE OF ARRAY TO LOOK AT.
		ANS	IS MAXIMUM ELEMENT IN ARRAY.
			(SAME VARIABLE TYPE AS ARRAY)

************************************************************************


		MAXWYT

PURPOSE:	LIMIT AMOUNT OF TIME PROGRAM WILL WAIT FOR USER TO TYPE
	IN AN ANSWER.  IS OF USE PRIMARILY IN CONVERSATIONAL INSTRUCTION
	PROGRAMS WHERE IT MAY BE ASSUMED THAT NO ANSWER INDICATES
	PERPLEXITY OR SOME OTHER DIFFICULTY.

USAGE:		CALL MAXWYT(ITIME,IERR)
	WHERE:	ITIME:	IS TIME LIMIT FOR WAIT IN SECONDS.
		IERR:	IS ERROR CODE.
			IERR=0. LINE ENTERED IN TIME. GO AHEAD
				AND READ IT.
				IERR=1. NO LINE ENTERED IN TIME LIMIT.
					TAKE APPROPRIATE ALTERNATE ACTION.
	NOTE: USUAL FORM OF USE IS TO ASK A QUESTION, CALL MAXWYT,
		CHECK IERR TO SEE IF USER RESPONDED IN TIME, TAKE
		APPROPRIATE ACTION.


************************************************************************



		MINIMUM

PURPOSE:	TO FIND MINIMUM ELEMENT IN ONE-DIMENSIONAL ARRAY(FIXED
	POINT OR SINGLE PRECISION FLOATING POINT.)

USAGE		CALL MINIMUM(ARRAY,NUM,ANS)
	WHERE	ARRAY	IS LIST TO PICK MINIMUM OUT OF.
		NUM	IS SIZE OF ARRAY TO LOOK AT.
		ANS	IS MINIMUM ELEMENT IN ARRAY.
			(SAME VARIABLE TYPE AS ARRAY)

************************************************************************



		MINVSQ

PURPOSE:	INVERT A GENERAL SQUARE MATRIX.

USAGE:		CALL MINVSQ(A,N,TOL,MC,MR,NDIM,IO,METHOD,DET,IEXP)
	WHERE:	A:	IS MATRIX TO BE INVERTED.
		N:	NUMBER OF ROWS(COLUMNS) IN MATRIX A.
		TOL:	TOLERANCE FOR INVERSE(IF LARGEST
			AVAILABLE PIVOT(IN ABS.)IS LESS THAN
			.000001*TOL, INVERSE IS CONSIDERED
			NONEXISTANT.(TYPICAL CHOICE FOR TOL IS 1.)
		MC:	BOOK-KEEPING VECTOR(AT LEAST N LONG)
		MR:	BOOK-KEEPING VECTOR(AT LEAST N LONG)
		NDIM:	DIMENSION OF MATRIX A IN MAINLINE.
			I.E. A(NDIM,NDIM)
		IO:	FORTRAN UNIT NUMBER FOR ERROR MESSAGES.
			IF IO=0, ERROR MESSAGES ARE SUPPRESSED.
		METHOD:	SWITCH FOR SELECTING PIVOT METHOD.
			=0  LEAST ACCURATE(FASTEST)USES FIRST NONZERO.
			=1  COMPROMISE.USES LARGEST REMAINING IN ROW.
			=2  MOST ACCURATE(SLOWEST)USE LARGEST REMAINING IN MATRIX.
		DET:	DETERMINENT OF MATRIX A(CHARACTERISTIC ONLY).
		IEXP:	POWER OF TEN OF DETERMINENT.
				DETERMINENT=DET*10**IEXP
	NOTE: INVERSE MATRIX IS RETURNED IN A.


************************************************************************



		MOUNT

PURPOSE:	TO PERFORM SOME OF THE FUNCTIONS OF THE MONITOR MOUNT
	COMMAND AS A SUBROUTINE.

USAGE:		CALL MOUNT(DEV,LOGNAM,LOCK,VID,PHYNAM,IERR)
	OR	CALL MOUNT(DEV,LOGNAM,LOCK,VID,PHYNAM,IERR,REELID)
	WHERE:	DEV    - IS THE NAME OF THE DEVICE TO BE MOUNTED.
			 THE DEVICE MAY BE EITHER SPECIFIC (E.G. MTA1)
			 OR GENERIC (E.G. DTA). THE DEVICE MAY NOT BE A
			 FILE STRUCTURE OR A TTY.  POSSIBLE DEVICES INCLUDE
			 DTA, MTA, LPT, CDP, CDR, PTP, PTR, ETC.
		LOGNAM - IS THE LOGICAL NAME TO GIVE TO THE DEVICE.
			 IT MUST NOT ALREADY REFER TO A DEVICE.
		LOCK   - IS A SIGNAL WHETHER THE USER WANTS THE DEVICE
			 TO BE WRITE LOCKED OR WRITE ENABLED.  THIS IS
			 VALID ONLY FOR DECTAPE AND MAGTAPE.
			VALUE	   MEANING
			  0	WRITE LOCKED
			  1	WRITE ENABLED
		VID    - VISUAL IDENTIFICATION STRING, CONSISTING OF UP
			 TO 25 LETTERS, DIGITS, PERIODS, AND HYPHENS
			 TERMINATED BY A BLANK OR UP TO 50 CHARACTERS
			 ENCLOSED IN QUOTES (EITHER SINGLE OR DOUBLE).
		PHYNAM - THE PHYSICAL NAME OF THE DEVICE OBTAINED, IF
			 ANY, SUCH AS MTA1, OR DTA0.  THIS SHOULD BE A
			 DOUBLE PRECISION VARIABLE, SINCE 510/602
			 USE SIX CHARACTER DEVICE NAMES. IF THE VARIABLE
			 IS SINGLE PRECISION AND THE DEVICE NAME IS
			 SIX CHARACTERS, ONLY FIVE WILL BE RETURNED,
			 AND NO WARNING WILL BE GIVEN.
		IERR   - IS AN ERROR CODE.
			VALUE		MEANING
			  0	MOUNT SUCCESSFUL.  NO ERRORS.
			  1	DEV DOES NOT EXIST OR IS NOT RECOGNIZED.
			  2	LOGNAM IS ALREADY IN USE, OR IS ZERO.
			  3	NO MOUNT JOB IS RUNNING TO PROCESS
				THE REQUEST.
			  4	DEVICE IS NOT AVAILABLE.
			 -1	MOUNT UNSUCCESSFUL FOR UNKNOWN REASON.
		REELID - REELID ID OF DESIRED TAPE. VALID FOR MAGTAPE ONLY
			 THIS ARGUMENT IS OPTIONAL.



************************************************************************


		PEEK

PURPOSE		TO EXAMINE A LOCATION IN THE MONITOR.

USAGE		CALL PEEK(IEXEC,IWORD)
	WHERE	IEXEC:	IS ADDRESS TO EXAMINE(USUALLY IN OCTAL)
		IWORD:	IS CONTENTS OF IEXEC

	NOTE THAT THIS SUBROUTINE IS PRIVILEGED AND WILL NOT RETURN
	THE CORRECT CONTENTS UNLESS THE CORRECT PRIVILEGE BIT IS SET
	FOR THE USER'S PROJECT-PROGRAMMER NUMBER IN ACCT.SYS.
	(IT MAY NOT BE PRIVILEGED IN SOME LEVEL C SYSTEMS.)

************************************************************************


		PRINTS

PURPOSE:	TO ENTER A FILE IN THE PRINT QUEUE WITHOUT EXITING
	FROM THE PROGRAM.

USAGE:		CALL PRINTS(FILENAME,IDISP,IFORM,ICOPYS)
   OR:		CALL PRINTS(FILENAME,IDISP,IFORM,ICOPYS,ILIMIT)
	WHERE	FILENAME:	IS THE ASCII NAME OF THE FILE TO BE PRINTED.
				THIS MUST BE A TWO WORD QUANTITY.
		IDISP:		DISPOSITION CODE.
				 0 = SAVE THE FILE
				 1 = PRINT THE FILE AND THEN DELETE IT
				 2 = RENAME THE FILE INTO [3,3], AND
				     DELETE IT AFTER PRINTING. THIS WILL BE
					 TREATED AS A 1 ON GALAXY SYSTEMS.
		IFORM:		FORMAT CODE.
				 0 = NOT FORTRAN FORMATTED OUTPUT
				 1 = FORTRAN FORMATTED OUTPUT
		ICOPYS:		NUMBER OF COPIES OF THE FILE TO PRINT.
				THIS MUST BE BETWEEN 1 AND 63 INCLUSIVE.
		ILIMIT:		OPTIONAL ARGUMENT FOR SPECIFYING PAGE LIMIT
				FOR THE PRINTOUT. IF THIS IS OMITTED, THE
				DEFAULT IS (FILESIZE*ICOPYS)+21

************************************************************************


		PROTEK

PURPOSE:	TO PROTECT A NEWLY CREATED FILE FROM WITHIN THE FORTRAN
	PROGRAM, SO THAT IT WILL NOT BE LOST IF SOMETHING GOES WRONG
	LATER.

USAGE:		SEE RENAMS.


************************************************************************


		PUTBYT

PURPOSE:	TO PUT AN ARBITRARY BYTE INTO A WORD SIMULATE A
	DPB INSTRUCTION).

USAGE		CALL PUTBYT(DSTWD,IBYTE,ISIZE,IRMOST,IERR)
	WHERE
		DSTWD  - WORD TO PUT THE BYTE IN
		IBYTE  - WORD TO DPB FROM
		ISIZE  - SIZE OF BYTE (1 TO 36)
			 MUST NOT BE GREATER THAN IRMOST+1
		IRMOST - POSITION OF RIGHTMOST BIT OF BYTE (0 TO 35)
		IERR   - ERROR CODE. NON-ZERO IF ARGUMENTS ARE ILLEGAL



************************************************************************


		PUTCHR

PURPOSE:	TO PACK A CHARACTER INTO A PACKED WORD(S) TO SAVE SPACE.

USAGE:		CALL PUTCHR(WORD,IBYTE,CHAR)
	WHERE	WORD:	IS PACKED WORD(S).
		IBYTE:	IS BYTE NUMBER.
		CHAR:	CHARACTER TO BE PACKED(LEFT JUSTIFIED.)

************************************************************************


		QUEOUT

PURPOSE:	TO ENTER A FILE IN AN OUTPUT QUEUE WITHOUT EXITING
	FROM THE PROGRAM.


USAGE	CALL QUEOUT(DEVICE,FILENAME,QUE,VECTOR,IERR)

WHERE
	DEVICE - IS DEVICE FILE IS ON. (MUST BE SOME KIND OF DSK)

	FILENAME - IS TWO WORD ASCII FILENAME TO OUTPUT

	QUE      - IS ASCII NAME OF QUEUE TO PUT FILE IN
			(MAY BE LPT, CDP, PTP, OR PLT)

	IERR     - IS ERROR CODE
			VALUE	MEANING
			  0	   OK
			  1	UNDEFINED QUE
			  2	ILLEGAL DEVICE OR OPEN FAILED
			  3	ILLEGAL FILE NAME
			  4	NO SUCH FILE
			  5	ILLEGAL ARGUMENT IN VECTOR
			  6	CANNOT OPEN QUE DEVICE
			  7	CANNOT ENTER QUEUE COMMAND FILE

	VECTOR    - IS A FOURTEEN(14) WORD INTEGER ARRAY OF ARGUMENTS
		VECTOR(1)	/FILE: ARGUMENT
				 1=ASCII (DEFAULT)
				 2=FORTRAN DATA
				 3=COBOL (I.E. SIXBIT)
				 4=CREF(NOT IMPLEMENTED. ASSUMES ASCII)
				 5=RUNOFF(NOT IMPLEMENTED. ASSUMES ASCII)
				 6=ELEVEN
		VECTOR(2)	/LIMIT: ARGUMENT
		VECTOR(3)	/COPIES:N (FROM 1 TO 63)
		VECTOR(4)	/DISP:
				 1=PRESERVE
				 2=RENAME (THIS WILL BE TREATED AS A 3 - DELETE
					ON GALAXY SYSTEMS
				 3=DELETE
		VECTOR(5)	AFTER SWITCH PART ONE
				TIME OF DAY OR PLUS TIME IN MINUTES
				PLUS TIME IS INDICATED BY A NEGATIVE IN VECTOR(6)
		VECTOR(6)	AFTER SWITCH PART TWO
				DATE IN 15 BIT FORMAT OR ZERO FOR TODAY
				NEGATIVE INDICATES TIME IS PLUS FORMAT
		VECTOR(7)	DEADLINE SWITCH PART ONE. SAME AS AFTER
		VECTOR(8)	DEADLINE SWITCH PART TWO. SAME AS AFTER
		VECTOR(9)	/PRIORITY:(N+1)
				GIVE NUMBER IN RANGE 1 TO 63. ACTUAL
				PRIORITY IS ONE LESS. DEFAULT IS 10
		VECTOR(10)	/PAPER: ARGUMENT
				THIS SWITCH IS ALSO REFERED TO AS
				/PRINT FOR LPT, /PUNCH FOR CDP,
				/TAPE FOR PTP, AND /PLOT FOR PLT.
			   VALUE		MEANING
					LPT      CDP      PTP      PLT
				1	ARROW(*) ASCII(*) ASCII(*) IMAGE
				2	ASCII    026      IMAGE    ASCII(*)
				3	OCTAL    BINARY   IMG BIN  BINARY
				4	SUPPRESS D029     BINARY
				5	         IMAGE
			   NOTE THAT THE DEFAULT MODE ON LPT IS ARROW;
				ON OTHER DEVICES IT DEPENDS UPON THE MODE
				OF THE FILE. THE DEFAULTS FOR ASCII FILES
				ARE STARRED.

		VECTOR(11)	/HEAD:N
				 0=NO HEADER
				 1=FILE HEADER
		VECTOR(12)	/SPACING: ARGUMENT
				 1=SINGLE
				 2=DOUBLE
				 3=TRIPLE
		VECTOR(13)	/FORMS:NAME
				 FIRST FIVE CHARACTERS
		VECTOR(14)	  REMAINING CHARACTER TO FORMS NAME
				ASCII NAME OF SPECIAL FORMS TO USE



************************************************************************


		REASSIGN

PURPOSE		TO TRANSFER A NONSHAREABLE DEVICE WHICH IS ASSIGNED
	TO A USER'S JOB TO SOME OTHER JOB, WITHOUT PASSING IT THROUGH
	THE MONITOR RESOURCES POOL, AND UNDER PROGRAM CONTROL.

USAGE		CALL REASSI(IDEV,IJOB,IERR)
	WHERE	IDEV:	FORTRAN UNIT NUMBER OF DEVICE TO REASSIGN
			OR ASCII DEVICE NAME
		IJOB:	NUMBER OF JOB TO REASSIGN IT TO
		IERR:	ERROR CODE
			=0  SUCCESSFULLY REASSIGNED
			=-1 DEVICE DOES NOT EXIST, CANNOT BE REASSIGNED
			    (SUCH AS TTY),OR IS NOT ASSIGNED TO USER
			    CALLING THIS SUBROUTINE; OR IJOB IS NOT
			    INITIALIZED.


************************************************************************

		REDTTY

PURPOSE:	TO READ TTY PARAMETERS OF CONTROLLING TTY.

USAGE:		CALL REDTTY(IFUNCT,IVAL,IERR)
	WHERE	IFUNCT - FUNCTION TO READ
		IVAL   - VALUE OF PARAMETER
		IERR   - ERROR CODE
			VALUE	MEANING
			  0	ALL OK
			 -1	JOB NOT ON A TTY
			  1	FUNCTION NOT IMPLEMENTED
			  2	PRIVILEGED FUNCTION
			  3	ARGUMENT OUT OF RANGE
			>=4	OTHER ERRORS

	DESCRIPTION OF FUNCTIONS (SEE ALSO TRMOP. IN MONITOR CALLS MANUAL)
NUMBER	RANGE		DESCRIPTION		CORRESPONDING SET
(OCTAL)
  0	1 BIT		OUTPUT IN PROGRESS		NO
  1	1 BIT		TERMINAL AT MONITOR MODE	NO
  2	1 BIT		PAPER TAPE MODE			YES
  3	1 BIT		LOWER CASE(0=YES, 1=NO)		YES
  4	1 BIT		SLAVE SWITCH			YES*
  5	1 BIT		TAB SWITCH (0 IF SPACES,
				1 IF TAB)		YES
  6	1 BIT		FORM SWITCH (0 IF LINEFEED,
				1 IF FORMFEED)		YES
  7	1 BIT		LOCAL COPY SWITCH
			 (NO ECHO IF SET)		YES
 10	1 BIT		FREE CR-LF SWITCH
			 (NO CR-LF IF SET)		YES
 11	0 TO 255	HORIZONTAL POSITION OF
			 CARRIAGE			NO
 12	16 TO 200	CARRIAGE WIDTH			YES
 13	1 BIT		TTY NO GAG BIT			YES
 14	1 BIT		HALF-DUPLEX LINE		YES*
 15	1 BIT		REMOTE LINE			YES*
 16	1 BIT		DISPLAY TERMINAL		YES*
 17	0 TO 3		FILLER CLASS			YES
 20	1 BIT		PAPER TAPE ENABLED		YES
 21	1 BIT		TTY PAGE BIT			YES
 22	1 BIT		SUSPENDED OUTPUT (NEED XON
			 TO RESUME) UNIMPLEMENTED	YES
 23	0 TO 63		PAGE SIZE IN LINES
				UNIMPLEMENTED		YES
 24	0 TO 63		PAGE COUNTER (LINES OUTPUT
			 ON THIS PAGE) UNIMPLEMENTED	YES
 25	1 BIT		TTY NO BLANK BIT		YES
 26	1 BIT		TTY NO ALTMODE BIT		YES
 27	1 BIT		APL MODE			YES
 30	SEE MANUAL	RECEIVE SPEED			YES
 31	SEE MANUAL	TRANSMIT SPEED			YES
 32	1 BIT		DEBREAK				YES
 33	1 BIT		LINE IS 2741			YES*
 34	1 BIT		TIDY				NO
 35	1 BIT		AUTO CR BIT			YES
 36	1 BIT		RTCOMPATIBILITY SETTING		YES
 37	SEE MANUAL	PIM MODE BREAK SET		YES

(*) MEANS SET IS PRIVILEGED.



************************************************************************

		RENAME

PURPOSE:	TO CHANGE THE NAME OF AN EXISTING FILE TO SOME NEW
	NAME.

USAGE:			SEE RENAMS.


************************************************************************


		RENAMS

PURPOSE		RENAME,DELETE, AND/OR PROTECT FILES ON ANY DEVICE AVAILABLE.

USAGE		CALL DELETE(NAME1)
		CALL RENAME(NAME1,NAME2)
		CALL PROTEK(IPROT,NAME1)
		CALL RENAMS(IDEV,IFUNCT,NAME1,NAME2,IPROT)

	WHERE	NAME1	FILENAME.EXT CURRENTLY EXISTING, ON WHICH
			SPECIFIED ACTION IS TO BE PERFORMED.
			MUST BE AT LEAST A TWO WORD QUANTITY, WRITTEN
			EXACTLY AS SHOULD APPEAR.
		NAME2	FILENAME.EXT TO GIVE TO FILE OF NAME1.
			NAME MUST MEET SAME REQUIREMENTS.
		IPROT	OCTAL PROTECTION CODE DESIRED.
		IDEV	FORTRAN UNIT NUMBER, OR ASCII DEVICE NAME
		IFUNCT	FUNCTION TO BE PERFORMED.
			1: DELETE
			2: PROTECT
			3: RENAME
			4: RENAME AND PROTECT
			5: RENAME, EVEN IF A FILE OF NAME2 ALREADY EXISTS.
			6: RENAME AND PROTECT, EVEN IF A FILE OF NAME2
			   ALREADY EXISTS.

NOTE:	IF DEVICE IDEV DOES NOT EXIST, DSK WILL BE TRIED.
NOTE:	IF NAME1 IS NOT FOUND, AND EXTENSION IS NULL, AN
	EXTENSION OF DAT WILL BE TRIED.
NOTE:	THE GENERAL CALL TO RENAMS IS PREFERRED OVER THE OBSOLETE
	CALLS TO DELETE,PROTEK, AND RENAME, WHICH IT HANDLES IN
	GENERAL AND WITHOUT LIMITATION TO DEVICE DSK.

NOTE:	IF FILE NAME1 IS CURRENTLY OPEN, IT MUST BE CLOSED.(I.E. IF
	WRITING IT, ENDFILE; IF READING IT, CALL RELEASE(N) WHERE N
	IS FORTRAN DEVICE NUMBER.)


************************************************************************

		RESTART

PURPOSE		RESTART A PROGRAM FROM ANY POINT WITHIN PROGRAM,
	SUBROUTINE TO PROGRAM, ETC.
	(RESTART IS AT BEGINNING OF PROGRAM.)

USAGE:		CALL RESTART

WARNING: PROGRAM WILL RELEASE ALL DEVICES ON RESTART,AND ANY FILES NOT
	CLOSED MAY BE LOST.


************************************************************************

		RNTIME

PURPOSE:	TO FIND TOTAL RUNTIME OF YOUR JOB UP TO PRESENT TIME.
	FREQUENTLY CALLED BEFORE AND AFTER A SEGMENT OF A PROGRAM WHOSE
	EXECUTION TIME IS OF INTEREST.(EXECUTION TIME=RUNTIME AFTER-
	RUNTIME BEFORE)

USAGE:		CALL RNTIME(ITIME)
	WHERE:	ITIME:	IS TOTAL RUNTIME OF JOB UP TO PRESENT TIME IN
			MILLISECONDS.


************************************************************************

		ROTATE

PURPOSE		TO ROTATE A SINGLE WORD QUANTITY.

USAGE		CALL ROTATE(WORD,IPLACE,WORD1)
	WHERE	WORD	IS WORD TO BE ROTATED.
		IPLACE	IS NUMBER OF PLACES TO ROTATE.
			IF IPLACE IS POSITIVE, ROTATE LEFT, IF NEGATIVE,
			ROTATE RIGHT.
		WORD1	RESULTANT WORD.


************************************************************************

		RUNUUO


PURPOSE		TO ALLOW ONE PROGRAM TO TRANSFER CONTROL TO 
	ANOTHER PROGRAM, SUCH AS BY GIVING A RUN,R,EXECUTE,ETC.
	COMMAND.

USAGE		CALL RUNUUO(COMMAND)
	WHERE	COMMAND:	ASCII COMMAND STRING, 200 CHARACTERS
	OR LESS, EXACTLY AS IT WOULD APPEAR NORMALLY; MUST END WITH A
	ZERO WORD. ( IF COMMAND STRING IS A LITERAL ENCLOSED IN QUOTES
	IN CALL STATEMENT, WILL DO SO AUTOMATICALLY.)

	VALID COMMANDS ARE:  R,RUN,EXECUTE,DEBUG,LOAD,COMPILE,MAKE,
	TECO,CREATE,EDIT,RENAME,DELETE,TYPE,LIST,COPY,PRESERVE,
	PROTECT,REWIND,UNLOAD,ZERO,SKIP,BACKSPACE,EOF,LABEL
	AND THEIR STANDARD ABBREVIATIONS, WITH ALL NORMALLY LEGAL
	SWITCHES.

IMPORTANT CONSIDERATIONS:

1)	CONTROL CAN NOT BE RETURNED TO CALLING PROGRAM.  IF IT IS
	NECESSARY TO RETURN TO CALLING PROGRAM, CALLED PROGRAM MUST DO
	SO BY CALLING RUNUUO AGAIN, AND REENTRY WILL BE AT START OF
	PROGRAM.

2)	ANY OPEN OUTPUT FILE MAY BE DESTROYED, AS ALL DEVICES ARE
	RELEASED.  THEREFORE, ANY FILES WHICH MUST BE TRANSMITTED
	SHOULD BE CLOSED.(FORTRAN IV  ENDFILE)

3)	NO SEGMENTS ARE RETAINED IN THE CONTROL TRANSFER.

4)	CANNOT RESTART CALLING PROGRAM, EVEN IF ERROR OCCURS IN CALL
	PROCEDURE.




************************************************************************

		SETTTY

PURPOSE:	TO SET TTY PARAMETERS.

USAGE:		CALL SETTTY(IFUNCT,IVAL,IERR)
	WHERE	IFUNCT - FUNCTION TO SET
		IVAL   - VALUE TO SET IT TO
		IERR   - ERROR CODE

	FOR DESCRIPTIONS OF IFUNCT AND IERR, SEE SECTION ON REDTTY


************************************************************************

		SHIFT

PURPOSE		TO LOGICAL SHIFT A SINGLE WORD QUANTITY.

USAGE		CALL SHIFT(WORD,IPLACE,WORD1)
	WHERE	WORD	IS WORD TO BE LOGICAL SHIFTED.
		IPLACE	IS NUMBER OF PLACES TO SHIFT.
			IF IPLACE IS POSITIVE, SHIFT LEFT, IF NEGATIVE,
			SHIFT RIGHT.
		WORD1	IS RESULTANT WORD.


************************************************************************


		SLEEP

PURPOSE		TO FORCE JOB TO SLEEP.

USAGE		CALL SLEEP(ISEC)
	WHERE	ISEC:	MINIMUM NUMBER OF SECONDS TO SLEEP.(MAY SLEEP
			LONGER)(INTEGER.)




************************************************************************

		SORT

PURPOSE:	TO SORT AN ARRAY OR MATRIX BY ONE OR MORE SORT FIELDS
	OF DECREASING MAJORITY.

USAGE:		CALL SORT(IA,N,JA,ISF,IFIELD,IW,IB,ITAG)
	WHERE:	IA:	IS MATRIX(OR ARRAY) TO BE SORTED.
		N:	NUMBER OF ROWS FILLED IN MATRIX.
		JA:	NUMBER OF COLUMNS FILLED IN MATRIX.
		ISF:	NUMBER OF SORT FIELDS.
		IFIELD:	VECTOR TELLING WHICH COLUMN IS MOST MAJOR, NEXT
			MOST,ETC.(MUST HAVE AT LEAST ISF ELEMENTS.)
		IW:	NUMBER OF ROWS DIMENSION IN MATRIX.
		IB:	WORKING STORAGE(AT LEAST 3N/2)
		ITAG:	WORKING STORAGE(AT LEAST N).

METHOD:	MERGEING SORT.



************************************************************************




		SSORT

PURPOSE		TO SORT AN ARRAY OR MATRIX BY ONE OR MORE SORT FIELDS
	OF DECREASING MAJORITY.

USAGE		CALL SSORT(NC,NR,MC,MR,ARRAY,ISORT,KKK,IV,SP)
   OR		CALL SSORT(NC,NR,MC,MR,ARRAY,ISORT,KKK,IV,SP,KTYPE)
	WHERE	NC:	IS NUMBER OF COLUMNS FILLED IN MATRIX
		NR:	IS NUMBER OF ROWS FILLED IN MATRIX
		MC:	IS NUMBER OF COLUMNS DIMENSIONED IN MATRIX
		MR:	IS NUMBER OF ROWS DIMENSION IN MATRIX
		ARRAY:	IS DATA ARRAY TO BE SORTED
		ISORT:	IS A VECTOR CONTAINING THE COLUMN INDEXES OF
			  THE SORT FIELDS, FROM MOST MAJOR TO MOST MINOR
		KKK:	IS THE NUMBER OF SORT FIELDS IN ISORT
		IV:	IS A WORKING STORAGE VECTOR AT LEAST NR IN LENGTH.
		SP:	IS A WORKING STORAGE VECTOR AT LEAST NC IN LENGTH.
		KTYPE:	IS OPTIONAL ARGUMENT TELLING TYPE OF COMPARE TO
			MAKE ON SORT FIELDS.
			IF THE NTH ENTRY IN KTYPE IS ZERO, COMPARE THE NTH
			SORT FIELD AS SIGNED NUMBERS
			IF IT IS NON-ZERO, COMPARE AS ALPHANUMERIC OR
			UNSIGNED INTEGER SO ALPHANUMERIC ORDER IS CORRECT

COMMENT		THIS ROUTINE IS MANY TIMES FASTER THAN THE PREVIOUS SORT.
	SINCE IT ALSO REQUIRES LESS STORAGE SPACE, ITS USE IS
	RECOMMENDED OVER THE PREVIOUS ROUTINE.

************************************************************************


		SUBMIT

PURPOSE		TO ENTER A JOB IN THE INPUT (BATCH) QUEUE FROM PROGRAM
	CONTROL

USAGE		CALL SUBMIT(IVECT)
	OR	CALL SUBMIT(IVECT,IERR)

	WHERE		IVECT IS AN 19 WORD INTEGER VECTOR CONTAINING
		IVECT(1)	NAME OF CTL FILE. MAX. OF FIVE CHARACTERS ASCII.
				EXT IS ALWAYS .CTL
		IVECT(2)	NAME OF LOG FILE. MAX. OF FIVE CHARACTERS ASCII.
				EXT IS ALWAYS .LOG. DEFAULT IS SAME AS CTL FILE
		IVECT(3)	DISPOSITION FOR CTL FILE.
				0=PRESERVE
				1=DELETE
		IVECT(4)	DISPOSITION FOR LOG FILE.
				0=PRESERVE
				1=DELETE
		IVECT(5)	TIME LIMIT IN SECONDS. DEFAULT IS 60.
		IVECT(6)	PAGE LIMIT. DEFAULT IS 200
		IVECT(7)	CARD LIMIT. DEFAULT IS 0
		IVECT(8)	PAPER TAPE LIMIT. DEFAULT IS 0
		IVECT(9)	PLOTTER LIMIT. DEFAULT IS 0
		IVECT(10)	CORE LIMIT. DEFAULT IS CORMAX
		IVECT(11)	RESTARTABLITY.
				0=YES
				1=NO
		IVECT(12)	UNIQUENESS.
				0=RUN ANY NUMBER OF JOBS UNDER PPN
			    OTHER=GUARANTEE UNIQUE UNDER PPN
		IVECT(13)	PRIORITY (1-63) STANDARD IS 10
		IVECT(14)	OUTPUT SWITCH (0,1,2,3,4)
				FOR GALAXY SYSTEM, ZERO IS /OUTPUT:NOLOG,
				ALL OTHERS ARE /OUTPUT:LOG
		IVECT(15)	DEPENDENCY SWITCH (0-777777)
		IVECT(16)	AFTER SWITCH PART ONE
				TIME OF DAY OR PLUS TIME IN MINUTES
				PLUS TIME IS INDICATED BY A NEGATIVE IN IVECT(17)
		IVECT(17)	AFTER SWITCH PART TWO
				DATE IN 15 BIT FORMAT OR ZERO FOR TODAY
				NEGATIVE INDICATES TIME IS PLUS FORMAT
		IVECT(18)	DEADLINE SWITCH PART ONE. SAME AS AFTER
		IVECT(19)	DEADLINE SWITCH PART TWO. SAME AS AFTER

			IERR IS AN OPTIONAL INTEGER ERROR CODE RETURNED
			VALUE	MEANING
			  0	NO ERRORS - JOB SUBMITTED
			  2	OPEN FAILED FOR DSK
			  3	ILLEGAL FILE NAME SPECIFIED
			  4	FILE WAS NOT FOUND
			  6	CANNOT OPEN QUE DEVICE (MPB)
			  7	CANNOT ENTER QUEUE COMMAND FILE (MPB)



************************************************************************


		TRUTH

PURPOSE		TO COMPRESS A LARGE TRUTH TABLE INTO LITTLE SPACE, AND TO
	MANIPULATE THE COMPRESSED TABLE.  USING THIS ROUTINE, EACH BIT
	IN A WORD CAN REPRESENT EITHER TRUE, OR FALSE, SO THAT,
	FOR EXAMPLE, A 360 ELEMENT TRUTH TABLE WILL FIT IN 10 WORDS OF
	MEMORY.



USAGE		CALL TRUTH(TABLE,IFUNCT,IENTRY,VALUE)

	WHERE	TABLE:	IS TRUTH TABLE.
		IFUNCT:	IS FUNCTION TO BE PERFORMEED.
			IF IFUNCT=0, TEST TABLE ENTRY.
			IF IFUNCT#0, SET TABLE ENTRY TO VALUE.
		IENTRY:	NUMBER OF ENTRY TO BE TESTED OR SET.
		VALUE:	VALUE OF ENTRY, IF IFUNCT=0.
			VALUE TO SET ENTRY TO IF IFUNCT#0.
	(# MEANS NOT EQUAL.)

************************************************************************



		TTYNAM

PURPOSE		TO DETERMINE THE ACTUAL PHYSICAL DEVICE NAME OF THE
	USER'S TELETYPE.(SUCH AS TTY3,TTY30,CTY, ETC.)

USAGE		CALL TTYNAM(NAME)

	WHERE	NAME	IS NAME RETURNED. SHOULD BE DOUBLE PRECISION.

************************************************************************



		TTYPTY

PURPOSE		TO DETERMINE FOR CALLING PROGRAM WHETHER CONTROL IS
	FROM TELETYPE OR PSEUDOTELETYPE, AND ALLOW IT TO MAKE DECISION
	ACCORDINGLY.

USAGE		CALL TTYPTY(ICODE)
	WHERE	ICODE:	IS CODE FOR DEVICE.
			ICODE=0 FOR TELETYPE.
			ICODE=-1 FOR PSEUDO-TELETYPE.



************************************************************************


		TYPEON

PURPOSE		TURN OFF CONTROL O SO THAT NEXT TYPEOUT WILL PRINT
	AND NOT BE SUPPRESSED

USAGE		CALL TYPEON


************************************************************************


		XPRODH

PURPOSE:	TO FORM SUMS AND SUMS OF CROSS-PRODUCTS.  VERY USEFUL
	FOR CORRELATIONS, ETC.

USAGE:		CALL XPRODH(X,SX,SXX,N,NDIM)
	WHERE:	X:	IS VECTOR OF VARIABLES(ONE OBSERVATION)
		SX:	IS VECTOR OF SUMS OF X'S.
		SXX:	IS MATRIX OF CROSS-PRODUCTS OF X'S.(ONLY LOWER
			CORNER TRIANGULAR PORTION IS GENERATED, SINCE
			MATRIX IS SYMMETRIC.)
		N:	NUMBER OF VARIABLES.
		NDIM:	DIMENSION OF SXX IN MAINLINE(I.E. SXX(NDIM,NDIM))


************************************************************************


		XPRODP

PURPOSE:	FORM SUMS AND SUMS OF CROSS-PRODUCTS IN A STORAGE
	MODE MAKING MORE EFFICIENT USE OF SPACE.

USAGE:		CALL XPRODP(X,SX,SXX,N)
	WHERE:	X:	IS VECTOR OF VARIABLES(ONE OBSERVATION).
		SX:	IS VECTOR OF SUMS OF X'S.
			(LENGTH AT LEAST N)
		SXX:	IS VECTOR OF SUMS OF CROSS-PRODUCTS OF X'S.
			(LENGTH AT LEAST (N*N+N)/2)
			ONLY UPPER CORNER TRIANGULAR PORTION IS FORMED
			AND STORED BY COLUMNS(IN CLOSE PACKED FORM. SEE
			THE SCIENTIFIC SUBROUTINE PACKAGE FOR A MORE 
			COMPLETE DESCRIPTION OF THIS STORAGE MODE.)
		N:	IS NUMBER OF VARIABLES.


************************************************************************


		ZEROH

PURPOSE:	ZERO AN ARRAY AND A SQUARE MATRIX.  FREQUENTLY USED WITH
	XPRODH.

USAGE:		CALL ZEROH(A,A2,N,NDIM)
	WHERE:	NDIM:	IS DIMENSION OF A2 IN MAINLINE.
		A:	IS A VECTOR OF LENGTH N OR GREATER.
		A2:	IS A NDIM BY NDIM MATRIX.
		N:	IS SIZE TO BE ZEROED.
			(A AND A2 ARE TO BE ZEROED).


************************************************************************


		ZEROP

PURPOSE:	TO ZERO A VECTOR.

USAGE:		CALL ZEROP(A,N)
	WHERE:	A:	IS VECTOR TO BE ZEROED.
		N:	IS NUMBER OF ELEMENTS IN A TO BE ZEROED.


************************************************************************
  
