      SUBROUTINE DAPLAT( IPLOT,MAXWID,MAXHIH,LETTER,KONECT,
         1    XPOINT,YPOINT,MINSUB,MAXSUB, XLEFT,YLOWER,XRIGHT,
         2    YUPPER, IGRID, IEDGE,MARGIN,MSHWID,MSHHIH,LTROFF,
         3    LINOFF,LINPRT, IDISK,IRESET,LTRERR,LINERR)
 C     RENBR(/POINT, CURVE AND PIN MAP PLOTTER FOR PRINTER)
C
  C     DONALD BARTH, HARVARD BUSINESS SCHOOL
C
  C     ROUTINE  TO  CONSTRUCT  A  PLOT  OF   USER   SELECTED
    C     PROPORTIONS AND WHICH CAN CONTAIN ONE OR MORE CURVES,
    C     EACH CURVE BEING REPRESENTED BY  ITS  OWN  ALPHABETIC
    C     LETTER.    POINTS   ON  A  CURVE  CAN  OPTIONALLY  BE
    C     CONNECTED EITHER BY ASTERISKS OR BY  SOME  ALPHABETIC
    C     LETTER  WHICH  NEED  NOT  BE THE SAME AS THAT USED TO
    C     REPRESENT THE  POINTS THEMSELVES.  IF PLOTTING POINTS
    C     NOT CONNECTED BY LINES, A PIN MAP CAN BE SIMULATED BY
    C     USING THE  CLOSEST  EMPTY  LOCATION  IF THE  LOCATION
    C     REPRESENTING THE POINT IS ALREADY USED.  THE PLOT CAN
    C     BE RULED  WITH GRID LINES EVERY 10  CHARACTERS ACROSS
    C     ITS WIDTH AND EVERY 5 LINES ACROSS ITS HEIGHT.  THESE
    C     GRID DIVISION  WIDTHS AND HEIGHTS  ARE ALSO UNDER THE
    C     USER'S CONTROL.   NUMBERS PRINTED ALONGSIDE  THE PLOT
    C     ARE REPRESENTED  WITH 5 SIGNIFICANT  DIGITS, BUT WITH
    C     SUPPRESSION  OF RIGHTHAND  ZEROES TO THE RIGHT OF THE
    C     DECIMAL POINT.   IF THE  NUMBER CANNOT  BE PRINTED IN
    C     FLOATING POINT FORM,  THEN THE  NUMBER IS REPRESENTED
    C     IN SCIENTIFIC NOTATION INSTEAD.
 C
  C     IF TWO OR MORE DIFFERENT ALPHABETIC  LETTERS  ARE  TO
    C     APPEAR  IN  THE SAME LOCATION IN THE PRINTED PLOT, AN
    C     AMPERSAND  WILL  APPEAR  INSTEAD.   HOWEVER,  IF  THE
    C     POINTS  AND THE  LINES  OPTIONALLY  CONNECTING  THESE
    C     POINTS ARE TO APPEAR AS DIFFERENT LETTERS, THEN THESE
    C     LETTERS, WHERE USED FOR PREVIOUS CURVES OR WHERE USED
    C     ELSEWHERE ON  THE CURRENT CURVE,  ARE  NOT CHANGED TO
    C     AMPERSANDS BY COINCIDENCE WITH THE PRESENT CURVE.
   C
  C     THIS ROUTINE  CALLS THE WINDOWING  ROUTINE PLTCUT AND
    C     THE GENERALIZED FLOATING POINT OUTPUT ROUTINE DARITE.
    C
  C     THE FOLLOWING INPUT  ARGUMENTS ARE  USED BY EACH CALL
    C     TO DAPLAT WHETHER OR NOT A PLOT IS GENERATED
   C
  C     IPLOT  = -1, ADD THE POINTS AND/OR LINES  REPRESENTED
    C              BY  THE COORDINATES IN THE XPOINT AND YPOINT
    C              ARRAYS TO THE PLOT STORAGE, THEN  RETURN  TO
    C              THE  CALLING  PROGRAM WITHOUT GENERATING THE
    C              PLOT.   ADDITIONAL  DAPLAT  CALLS  WILL   BE
    C              EXECUTED BEFORE THE PLOT IS TO BE PRINTED.
 C            = 0, ADD THE POINTS AND/OR LINES IN THE XPOINT
    C              AND  YPOINT ARRAYS TO THE PLOT STORAGE, THEN
    C              GENERATE  THE  PLOT  AND  CLEAR   THE   PLOT
    C              STORAGE.   ADDITIONAL  CALLS  TO  DAPLAT, IF
    C              ANY, WILL STORE UPON A BLANK PLOT SURFACE.
 C            = 1, ADD THE POINTS AND/OR LINES IN THE XPOINT
    C              AND  YPOINT ARRAYS TO THE PLOT STORAGE, THEN
    C              GENERATE THE PLOT BUT DO NOT CLEAR THE  PLOT
    C              STORAGE.   THE CURRENTLY STORED PLOT WILL BE
    C              ADDED TO BY ADDITIONAL CALLS TO DAPLAT.
    C     MAXWID = WIDTH OF THE PLOT STATED AS  THE  NUMBER  OF
    C              COLUMNS OF  CHARACTERS FORMING  THE PLOTTING
    C              AREA UPON WHICH DATA CAN BE PLOTTED.  MAXWID
    C              IS NORMALLY  1 PLUS  A MULTIPLE  OF  MSHWID.
    C              MAXIMUM RECOMMENDED  VALUE OF MAXWID IS 101.
    C              NOTE THAT THE PLOT HAS AN ADDITIONAL  MARGIN
    C              OF 12  CHARACTERS ALONG  THE  LEFT  SIDE  IN
    C              WHICH SCALE NUMBERS  ARE  PRINTED.  AN ADDI-
    C              TIONAL 4 CHARACTERS  CAN APPEAR TO THE RIGHT
    C              OF THE PLOT IN THE LOWER-RIGHT SCALE NUMBER.
    C              THE LARGEST ACCEPTED VALUE OF MAXWID IS 131,
    C              WHICH CAN LEAD TO LOWER SCALE 147 CHARACTERS
    C              WIDE WHICH  IS TOO LARGE  TO OUTPUT ON  MOST
    C              LINE-PRINTERS.  IF THE  VALUE OF IGRID TURNS
    C              OFF BOTH  LEFT SCALE NUMBERS AND LOWER SCALE
    C              NUMBERS,  THEN ONLY 1  CHARACTER  (EITHER AN
    C              ASTERISK OR A SPACE) WILL APPEAR TO THE LEFT
    C              OF THE  PLOT SO MAXIMUM  WIDTH  OF A PRINTED
    C              WOULD THEN BE MERELY 1 PLUS MAXWID.
   C            = 0, USE THE LAST NONZERO VALUE SPECIFIED  FOR
    C              MAXWID AS  THE WIDTH OF THE PLOT, OR USE THE
    C              VALUE 101  IF A NONZERO  VALUE OF MAXWID HAS
    C              NOT BEEN SPECIFIED.
    C     MAXHIH = HEIGHT OF THE PLOT STATED AS THE  NUMBER  OF
    C              LINES FORMING  THE PLOTTING AREA  UPON WHICH
    C              DATA CAN BE PLOTTED.   NORMALLY MAXHIH WOULD
    C              BE 1 PLUS  A MULTIPLE  OF MSHHIH.   THE PLOT
    C              HAS AN  ADDITIONAL  LOWER MARGIN  OF 2 LINES
    C              (OR 3  LINES  IF THE  SCALE  NUMBERS  ARE IN
    C              SCIENTIFIC  NOTATION).
 C            = 0, USE THE LAST NONZERO VALUE SPECIFIED  FOR
    C              MAXHIH AS THE HEIGHT OF THE PLOT, OR USE THE
    C              VALUE 51  IF A NONZERO  VALUE OF  MAXHIH HAS
    C              NOT BEEN SPECIFIED.
    C     LETTER = 0, PLOT THE POINTS HAVING COORDINATES IN THE
    C              XPOINT AND YPOINT ARRAYS WITH ASTERISKS.  IF
    C              ONE (OR MORE)  OF THESE POINTS  IS TO APPEAR
    C              AT THE  SAME  LOCATION  ON THE PLOT  AS SOME
    C              OTHER  POINT OR  PORTION OF A  LINE SEGMENT,
    C              THE OTHER POINT OR PORTION OF A LINE SEGMENT
    C              IS SHOWN INSTEAD OF THE CURRENT POINT.
C            = 1 THRU 26, IDENTIFIES ALPHABETIC LETTER USED
    C              TO PLOT THE POINTS HAVING COORDINATES IN THE
    C              XPOINT AND YPOINT  ARRAYS.   LETTER  IS  THE
    C              SERIAL NUMBER OF THE LETTER IN THE ALPHABET.
    C              LETTER=3 WOULD CAUSE THE PLOTTED  POINTS  TO
    C              BE REPRESENTED WITH C'S.
    C            = 27, PLOT  THE POINTS  HAVING  COORDINATES IN
    C              THE XPOINT AND YPOINT ARRAYS WITH ASTERISKS.
    C              IF  ONE  (OR  MORE)  OF  THESE  POINTS IS TO
    C              APPEAR AT THE SAME  LOCATION ON THE PLOT  AS
    C              SOME  OTHER  POINT  OR  PORTION  OF  A  LINE
    C              SEGMENT,  THEN THE ASTERISK  APPEARS INSTEAD
    C              OF  THE  OTHER  POINT  OR PORTION  OF A LINE
    C              SEGMENT.
C     KONECT = .LT.-1,  SIMULATE  PIN  MAP.   STORE  POINTS
    C              HAVING  COORDINATES  IN  XPOINT  AND  YPOINT
    C              ARRAYS FOR PLOTTING (EITHER BY CURRENT  CALL
    C              TO  DAPLAT  IF  IPLOT.GE.0  OR BY SUBSEQUENT
    C              CALL TO DAPLAT IF IPLOT.NE.0).  IF LETTER IS
    C              GREATER   THAN   ZERO,   AND   IF   LOCATION
    C              REPRESENTING POINT ALREADY CONTAINS PRINTING
    C              CHARACTER  OTHER  THAN NONDOMINANT ASTERISK,
    C              THEN SEARCH FOR CLOSEST  LOCATION  WHICH  IS
    C              EMPTY    OR   WHICH   CONTAINS   NONDOMINANT
    C              ASTERISK.  IF LETTER IS  ZERO  AND  LOCATION
    C              REPRESENTING POINT ALREADY CONTAINS PRINTING
    C              CHARACTER, THEN SEARCH FOR CLOSEST  LOCATION
    C              WHICH  CONTAINS  SPACE.   IF,  AFTER  HAVING
    C              SEARCHED NUMBER OF CONCENTRIC BOXES EQUAL TO
    C              ABSOLUTE   VALUE  OF  KONECT,  NO  AVAILABLE
    C              LOCATION HAS YET BEEN  FOUND,  THEN  ABANDON
    C              ATTEMPT.    NOTE   THAT  IF  SEVERAL  POINTS
    C              COINCIDE, IT IS MUCH MORE EFFICIENT TO  HAVE
    C              THEM ADJACENT IN XPOINT AND YPOINT ARRAYS IF
    C              PIN  MAP  OPTION  IS  USED.   FOLLOWING  ARE
    C              EXAMPLES OF SIZES OF PIN GROUPS POSSIBLE FOR
    C              VARIOUS VALUES OF KONECT.
   C
  C               KONECT=-2  KONECT=-3  KONECT=-4  KONECT=-5
C
  C                                                555555555
C                                      4444444   544444445
C                            33333     4333334   543333345
C                  222       32223     4322234   543222345
C                  212       32123     4321234   543212345
C                  222       32223     4322234   543222345
C                            33333     4333334   543333345
C                                      4444444   544444445
C                                                555555555
C
  C            = -1,  STORE  POINTS  HAVING  COORDINATES   IN
    C              XPOINT   AND   YPOINT  ARRAYS  FOR  PLOTTING
    C              (EITHER  BY  CURRENT  CALL  TO   DAPLAT   IF
    C              IPLOT.GE.0  OR  BY SUBSEQUENT CALL TO DAPLAT
    C              IF IPLOT.NE.0).  IF LETTER  IS IN   RANGE  1
    C              THROUGH   26,   AND   IF  THERE  ALREADY  IS
    C              CHARACTER OTHER THAN SPACE  OR  ASTERISK  AT
    C              LOCATION   REPRESENTING  POINT,  THEN  PLACE
    C              AMPERSAND AT LOCATION INSTEAD.
   C            = 0, STORE POINTS HAVING COORDINATES IN XPOINT
    C              AND  YPOINT ARRAYS FOR PLOTTING, AND CONNECT
    C              THESE WITH  LINES  FORMED  FROM  NONDOMINANT
    C              ASTERISKS.   IF SOME OTHER CHARACTER ALREADY
    C              IS IN PLOT, OR IS LATER  ADDED  TO  PLOT  AT
    C              LOCATIONS   ALONG   LINE,  THEN  THIS  OTHER
    C              CHARACTER IS SEEN INSTEAD OF ASTERISK.
C            = 1 THRU 26, CONNECT POINTS WITH LINES  FORMED
    C              OF ALPHABETIC LETTER WHICH HAS KONECT AS ITS
    C              SERIAL NUMBER IN ALPHABET.
  C            = 27, SAME AS KONECT=0, EXCEPT THAT  ASTERISKS
    C              ARE  DOMINANT OVER ALL OTHER CHARACTERS.  IF
    C              SOME OTHER CHARACTER ALREADY IS IN PLOT,  OR
    C              IS  LATER  ADDED  TO PLOT AT LOCATIONS ALONG
    C              LINE, THEN IT IS ASTERISK WHICH IS SEEN.
   C     XPOINT = THE ARRAY OF X (HORIZONTAL)  COORDINATES  OF
    C              THE DATA POINTS TO BE PLOTTED.
   C     YPOINT = THE ARRAY OF Y (VERTICAL) COORDINATES OF THE
    C              DATA POINTS TO BE PLOTTED.
  C     MINSUB = THE SUBSCRIPT IN XPOINT AND YPOINT ARRAYS OF
    C              THE  COORDINATES  OF  THE  FIRST POINT TO BE
    C              PLOTTED
 C     MAXSUB = THE SUBSCRIPT IN XPOINT AND YPOINT ARRAYS OF
    C              THE  COORDINATES  OF  THE  FINAL POINT TO BE
    C              PLOTTED
 C     XLEFT  = THE HORIZONTAL DATA COORDINATE TO BE  PLACED
    C              AT  THE  LEFT  EDGE  OF  THE PLOT.  ONLY THE
    C              PORTION  OF  THE  CURVE  INSIDE  THE  WINDOW
    C              DEFINED  BY XLEFT, YLOWER, XRIGHT AND YUPPER
    C              WILL BE  SHOWN  IN  THE  PLOT.   IF  A  LINE
    C              SEGMENT  CROSSES  THE WINDOW, THE PORTION OF
    C              THE LINE SEGMENT WHICH IS OUTSIDE THE WINDOW
    C              WILL   NOT   BE   REPRESENTED.    THE   DATA
    C              COORDINATES CAN EITHER INCREASE OR  DECREASE
    C              FROM  LEFT  TO  RIGHT OR FROM BOTTOM TO TOP.
    C              IF MULTIPLE CURVES ARE BEING SUPERIMPOSED ON
    C              A  SINGLE PLOT, THE CURVES NEED NOT ALL HAVE
    C              THE SAME DATA  COORDINATE  LIMITS,  HOWEVER,
    C              THE  SCALE  NUMBERS  ON THE PLOT ITSELF WILL
    C              CORRESPOND TO THE DATA COORDINATE LIMITS  OF
    C              THE FINAL CURVE.
  C     YLOWER = THE VERTICAL DATA COORDINATE TO BE PLACED AT
    C              THE LOWER EDGE OF THE PLOT
  C     XRIGHT = THE HORIZONTAL DATA COORDINATE TO BE  PLACED
    C              AT THE RIGHT EDGE OF THE PLOT
    C     YUPPER = THE VERTICAL DATA COORDINATE TO BE PLACED AT
    C              THE UPPER EDGE OF THE PLOT
  C
  C     THE FOLLOWING ARGUMENTS ARE  IGNORED UNLESS A PLOT IS
    C     GENERATED BY THE CURRENT CALL TO DAPLAT
   C
  C     IGRID  = 0, IF THE PLOT IS GENERATED,  THE PLOT  WILL
    C              SHOW  AN  INTERNAL GRID.  THIS INTERNAL GRID
    C              WILL  BE  RULED  VERTICALLY   EVERY   MSHWID
    C              CHARACTERS  ACROSS THE WIDTH OF THE PLOT AND
    C              WILL  BE  RULED  HORIZONTALLY  EVERY  MSHHIH
    C              LINES ACROSS THE HEIGHT OF THE PLOT.
  C            = 1, IF THE PLOT IS GENERATED,  THE PLOT  WILL
    C              SHOW  THE  INTERSECTIONS  OF THE LINES OF AN
    C              INTERNAL GRID, BUT WILL NOT SHOW GRID  LINES
    C              THEMSELVES.   THE  INTERNAL  GRID  WOULD, IF
    C              SHOWN,  HAVE  VERTICAL  LINES  EVERY  MSHWID
    C              CHARACTERS  ACROSS THE WIDTH OF THE PLOT AND
    C              HORIZONTAL LINES EVERY MSHHIH  LINES  ACROSS
    C              THE HEIGHT OF THE PLOT.
C            = 2, IF THE PLOT  IS GENERATED,  THE PLOT WILL
    C              NOT   SHOW   AN   INTERNAL  GRID.   HOWEVER,
    C              REGARDLESS OF  THE  VALUE  OF  IGRID,  SCALE
    C              NUMBERS  WILL BE PRINTED ALONG THE SCALES AT
    C              THE  INTERVALS  INDICATED  BY   MSHWID   AND
    C              MSHHIH.
 C     IEDGE  = PLACE NUMBERS BOTH TO LEFT OF AND BELOW PLOT
    C              TO IDENTIFY COORDINATE RANGES.
   C            = 1, PLACE NUMBERS TO LEFT OF PLOT, BUT DO NOT
    C              PLACE NUMBERS BELOW PLOT.
   C            = 2, PLACE NUMBERS BELOW PLOT, BUT NOT TO LEFT
    C              OF  PLOT.   UNLESS  PREVENTED  BY  VALUE  OF
    C              MARGIN,  THE   DISTANCE   BETWEEN   CARRIAGE
    C              CONTROL  CHARACTER IN COLUMN 1 AND LEFT EDGE
    C              OF PLOT WILL BE JUST LARGE ENOUGH  TO  ALLOW
    C              SCALE  NUMBER IMMEDIATELY BELOW LEFT EDGE OF
    C              PLOT.
   C            = 3, DO NOT PLACE NUMBERS EITHER TO LEFT OF OR
    C              BELOW  PLOT.   UNLESS  PREVENTED BY VALUE OF
    C              MARGIN, NO CHARACTERS  WILL  APPEAR  BETWEEN
    C              CARRIAGE  CONTROL  CHARACTER IN COLUMN 1 AND
    C              LEFT EDGE OF PLOT.
C     MARGIN = MINIMUM   NUMBER   OF   CHARACTERS   BETWEEN
    C              CARRIAGE  CONTROL  CHARACTER  IN COLUMN 1 OF
    C              OUTPUT AND LEFT EDGE OF PLOT.   THIS  MARGIN
    C              INCLUDES  LEFT  SCALE  NUMBERS AND SPACES TO
    C              THEIR LEFT.
  C     MSHWID = WIDTH OF  THE GRID  DIVISIONS  STATED AS THE
    C              NUMBER OF COLUMNS OF CHARACTERS.   MSHWID=10
    C              WOULD GIVE THE  VERTICAL GRID LINES EVERY 10
    C              CHARACTERS  ACROSS  THE  WIDTH  OF THE  PLOT
    C              AREA.
   C            = 0, USE THE LAST NONZERO  VALUE SPECIFIED FOR
    C              MSHWID AS  THE GRID  DIVISION  WIDTH, OR USE
    C              THE VALUE  10 IF A  NONZERO VALUE  OF MSHWID
    C              HAS NOT BEEN SPECIFIED BY A PREVIOUS CALL TO
    C              THIS ROUTINE.
C     MSHHIH = HEIGHT OF  THE GRID DIVISIONS  STATED AS THE
    C              NUMBER OF  LINES.   MSHHIH=5 WOULD  GIVE THE
    C              HORIZONTAL GRID  LINES EVERY 5  LINES ACROSS
    C              THE HEIGHT OF THE PLOT AREA.
C            = 0, USE THE LAST  NONZERO VALUE SPECIFIED FOR
    C              MSHHIH AS  THE GRID DIVISION  HEIGHT, OR USE
    C              THE VALUE  5 IF A  NONZERO VALUE  OF  MSHHIH
    C              HAS NOT BEEN SPECIFIED BY A PREVIOUS CALL TO
    C              THIS ROUTINE.
C     LTROFF = DISTANCE  STATED  AS  NUMBER  OF  CHARACTERS
    C              BETWEEN  LEFT  EDGE  OF  PLOT AND LEFT SCALE
    C              LINE.  IF LTROFF=0,  THEN  LEFT  SCALE  LINE
    C              WILL BE AT LEFT EDGE OF PLOT.
    C     LINOFF = DISTANCE STATED AS NUMBER OF  LINES  BETWEEN
    C              LOWER  EDGE  OF THE PLOT AND THE LOWER SCALE
    C              LINE.  IF LINOFF=0, THEN  LOWER  SCALE  LINE
    C              WILL BE AT LOWER EDGE OF PLOT.
   C     LINPRT = -1, THE PLOT IS NOT  TO INCLUDE ANY CARRIAGE
    C              CONTROL CHARACTER AT LEFT END OF EACH LINE.
C            = 0, THE PLOT WILL BE VIEWED  BY THE USER ON A
    C              TERMINAL,  EITHER TYPED DIRECTLY  WITH IDISK
    C              BEING  GIVEN THE  TERMINAL  UNIT  NUMBER, OR
    C              TYPED  BY THE  USER AFTER  THIS ROUTINE  HAS
    C              WRITTEN  THE PLOT  INTO A  FILE ON  THE UNIT
    C              THE NUMBER OF  WHICH IS CONTAINED  IN IDISK.
    C              A BLANK  OR SPACE  WILL BE USED  AS CARRIAGE
    C              CONTROL  CHARACTER  TO GIVE  SINGLE SPACING.
    C            = 1,  THE PLOT  WILL BE  PRINTED  ON THE  LINE
    C              PRINTER  BY THE USER  AFTER THE  PROGRAM HAS
    C              WRITTEN THE  PLOT INTO A FILE.   AN ASTERISK
    C              WILL BE USED  AS CARRIAGE  CONTROL CHARACTER
    C              TO GIVE SINGLE  SPACING WITH  SUPPRESSION OF
    C              SKIPPING EXTRA LINES AT THE PAGE BOUNDARIES.
    C              ON THE PDP-10,  AN ASTERISK AS  THE CARRIAGE
    C              CONTROL CHARACTER GIVES  OVERPRINTING ON THE
    C              TERMINAL AS OPPOSED TO SINGLE SPACING.
C     IDISK  = THE UNIT NUMBER OF THE DEVICE ONTO WHICH THE
    C              PLOTS  ARE TO BE WRITTEN.  THIS ROUTINE WILL
    C              ONLY  GENERATE  THE   PLOT.    IT   IS   THE
    C              RESPONSIBLITY OF THE CALLING PROGRAM TO OPEN
    C              THE OUTPUT FILE AND TO WRITE  THE  CAPTIONS,
    C              THE FORM FEEDS AND/OR  THE SEPARATING LINES.
    C              IDISK SHOULD  ALWAYS BE  GIVEN  A LEGAL UNIT
    C              NUMBER SINCE DAPLAT WILL GENERATE THE STORED
    C              PLOT, IF ANY,  USING THE NEW  VALUE OF IDISK
    C              BEFORE STORING THE NEW CURVE IF THE NEW PLOT
    C              SIZE  DIFFERS  FROM THAT  USED TO  STORE THE
    C              PREVIOUS CURVES EVEN IF IPLOT=-1.
C
  C     FOLLOWING ARGUMENT IS USED BOTH FOR INPUT AND OUTPUT.
    C
  C     IRESET = SHOULD BE INPUT GREATER  THAN ZERO THE FIRST
    C              TIME THIS ROUTINE IS CALLED.  IRESET IS THEN
    C              RETURNED SET TO ZERO  AND SHOULD RETAIN THIS
    C              VALUE  FOR  ALL  SUBSEQUENT  CALLS  TO  THIS
    C              ROUTINE.
C            = 0, CHARACTER TEMPLATE AND PLOT STORAGE  HAVE
    C              ALREADY BEEN INITIALIZED.
   C            = 1, INITIALIZE CHARACTER TEMPLATE AND ALL  OF
    C              PLOT STORAGE.
C            = 2, INITIALIZE  CHARACTER  TEMPLATE  AND  ALL
    C              EXCEPT FIRST 3 LOCATIONS IN PLOT STORAGE.
  C            = 3, INITIALIZE CHARACTER TEMPLATE.
C            = 4, INITIALIZE ALL OF PLOT STORAGE.
    C            = 5, INITIALIZE ALL  OF  PLOT  STORAGE  EXCEPT
    C              FIRST 3 LOCATIONS.
C
  C     THE FOLLOWING ARGUMENTS ARE RETURNED AS OUTPUT
 C
  C     LTRERR = RETURNED  CONTAINING NUMBER  OF POINTS WHICH
    C              WERE OUTSIDE THE CURRENT PLOT.
   C     LINERR = RETURNED CONTAINING  NUMBER OF LINE SEGMENTS
    C              WHICH WERE  COMPLETELY  OUTSIDE  THE CURRENT
    C              PLOT.   ALSO CONTAINS  NUMBER OF POINTS IN A
    C              PIN MAP  WHICH WERE  NOT SHOWN  DUE TO THERE
    C              BEING NO EMPTY  LOCATION WITHIN  THE ALLOWED
    C              DISTANCE.
    C
  C
  C     AS AN  EXAMPLE  OF THE  USAGE  OF THIS  ROUTINE,  THE
    C     FOLLOWING PROGRAM WAS USED TO GENERATE THE PLOT SHOWN
    C     BELOW THE PROGRAM (ALONG WITH 2 NOT SHOWN).
    C
  C      DIMENSION XPOINT(10),YPOINT(10)
C      DATA XPOINT/0. ,1. ,2. ,3. ,4. ,0. ,1. ,2. ,3. ,4. /
    C      DATA YPOINT/1. ,1.5,2.5,2.5,1.5,2. ,2.3,3. ,2.5,2. /
    C      DATA IRESET,IDISK/1,1/
    C      DO 2 JGRID=1,3
  C      IGRID=JGRID-1
   C      WRITE(IDISK,1)IGRID
  C    1 FORMAT(7H IGRID=,I2)
 CC
 CC  IPLOT=-1 MAXWID=41 MAXHIH=16 LETTER=1  KONECT=2
  CC MINSUB=1  MAXSUB=5   XLEFT=0  YLOWER=.5 XRIGHT=4
  CC YUPPER=3.5 IEDGE=0  MARGIN=0  MSHWID=0  MSHHIH=0LTROFF=0
    CC LINOFF=0  LINPRT=1
  C      CALL DAPLAT(-1,41,16,1,2,
 C     1XPOINT,YPOINT,1,5,0.,.5,4.,
    C     23.5,IGRID,0,0,0,0,0,
 C     30,1,IDISK,IRESET,LTRERR,LINERR)
CCHANGING IPLOT=0, LETTER=3, KONECT=4, MINSUB=6, MAXSUB=10
C      CALL DAPLAT(0,41,16,3,4,
  C     1XPOINT,YPOINT,6,10,0.,.5,4.,
   C     23.5,IGRID,0,0,0,0,0,
 C     30,1,IDISK,IRESET,LTRERR,LINERR)
C    2 WRITE(IDISK,3)
  C    3 FORMAT(//)
 C      STOP
  C      END
   C
  C IGRID= 0
   C*      3.5 -+---------+---------+---------+---------+
    C*           !         !         !         !         !
    C*           !         !         !         !         !
    C*           !         !        DCDD       !         !
    C*           !         !     DDD !  DDDDD  !         !
    C*      2.5 -+---------+-DDDD----ABBBBBBB&&&D--------+
    C*           !       DDCD      BB!         !B&DD     !
    C*           !  DDDDD  !     BB  !         !  BBDDDD !
    C*           CDD       !   BB    !         !    BB  DC
    C*           !         ! BB      !         !      BB !
    C*      1.5 -+--------BAB--------+---------+--------BA
    C*           !     BBB !         !         !         !
    C*           ! BBBB    !         !         !         !
    C*           AB        !         !         !         !
    C*           !         !         !         !         !
    C*      0.5 -+---------+---------+---------+---------+
    C*           !         !         !         !         !
    C*           0         1         2         3         4
    C
  C     AS SUPPLIED, DAPLAT CONTAINS A  STORAGE  ARRAY  LARGE
    C     ENOUGH TO HOLD 5151 CHARACTERS, THIS BEING THE NUMBER
    C     OF CHARACTERS NEEDED FOR A PLOT OF THE  DEFAULT  SIZE
    C     OF  51  LINES  EACH  OF  101  CHARACTERS.   THIS PLOT
    C     STORAGE   IS   CONTAINED   IN   THE   LABELED   BLOCK
    C     COMMON/FASPA/  WHICH  MUST CONTAIN AT LEAST  20 WORDS
    C     MORE THAN THE WORDS  NEEDED  TO  STORE  MAXWID*MAXHIH
    C     CHARACTERS, SIX CHARACTERS BEING HELD IN THE RIGHT 30
    C     BITS  OF  EACH  WORD.    THE   20   ADDITIONAL  WORDS
    C     STORE  INFORMATION  ABOUT PLOT SIZE AND SCALING.  THE
    C     LABELED COMMON BLOCK CAN BE MADE LARGER THAN THE  879
    C     LOCATIONS  (CALCULATED  AS 20+(((51*101)+5)/6) WORDS)
    C     PROVIDED IN THIS ROUTINE IF THE LABELED COMMON  BLOCK
    C     IS LOADED FIRST BY THE USER'S PROGRAM, IF THE  USER'S
    C     PROGRAM  DEFINES  THE  1ST  3 LOCATIONS IN THIS ARRAY
    C     BEFORE THIS ROUTINE IS FIRST CALLED,  AND  IF  IRESET
    C     HAS  EITHER OF THE VALUES 2 OR 5 WHEN THIS ROUTINE IS
    C     FIRST CALLED.  THE 3 LOCATIONS WHICH MUST BE  DEFINED
    C     IN COMMON/FASPA/ ARE DEFINED AS FOLLOW
    C     KDMNSN = 15 LESS THAN  THE  NUMBER  OF  LOCATIONS  IN
    C              COMMON/FASPA/
C     LRGBYT = NUMBER   OF   DIFFERENT   CHARACTER   CODES,
    C              INCLUDING  0  FOR BLANK AND 1 FOR AMPERSAND,
    C              THAT MUST BE STORED  IN  EACH  BYTE  OF  THE
    C              ARRAY  WHICH  IS DIMENSIONED AT KDMNSN.  THE
    C              MASTER ARRAY MUST BE DIMENSIONED TO AT LEAST
    C              LRGBYT-1.
    C     MAXBYT = NUMBER OF BYTES WHICH CAN  BE  STORED  IN  A
    C              SINGLE  COMPUTER  WORD.   (LRGBYT**MAXBYT)-1
    C              MUST BE SMALL ENOUGH TO BE REPRESENTED AS  A
    C              POSITIVE  NUMBER.   THE ISHIFT ARRAY MUST BE
    C              DIMENSIONED TO AT LEAST MAXBYT.
  C     IF A PLOT IS REQUESTED WHICH IS LARGER  THAN  CAN  BE
    C     HELD IN THE LABELED  COMMON BLOCK, THEN THE EFFECTIVE
    C     VALUE OF MAXHIH IS REDUCED SO THAT THE PLOT WILL FIT.
    C
  C     THE LABELED COMMON BLOCK COMMON/FASPA/  CONTAINS  ALL
    C     THE  INFORMATION NECESSARY TO GENERATE THE PLOT, WITH
    C     THE EXCEPTION OF THE ARGUMENTS LINPRT AND  IDISK  AND
    C     THE  CHARACTER  LIST.   IF  A  LATER EXECUTION OF THE
    C     PROGRAM IS TO ADD TO THE CURRENT PLOT,  THE  CONTENTS
    C     OF  THE  LABELED  COMMON  BLOCK CAN BE WRITTEN INTO A
    C     BINARY FILE, THEN BE RESTORED  WHEN  NEEDED  PROVIDED
    C     THAT  DAPLAT  HAS BEEN CALLED WITH A NONZERO VALUE OF
    C     IPLOT WHICH WOULD NOT CLEAR THE PLOT STORAGE.
  C
  C     COMMON USED TO STORE THE INTERMEDIATE PLOTS
          COMMON/FASPA/ KDMNSN,LRGBYT,MAXBYT,JRESET,KONTNT,
        1 KWIDE, KHIGH,XFIRST,YFIRST,XFINAL,YFINAL, MGRID,
        2 MEDGE, MMRGN, IWIDE, IHIGH, IOVER,   IUP,  IERR,
        3  JERR,ISTORE(859)
    C
  C     COMMON CONTAINING CHARACTERS CORRESPONDING TO VALUES
      COMMON/FASPB/LTRALL(35)
    C
  C     COMMON CONTAINING DOMINANCE RULES
          COMMON/FASPC/MASTER(29)
    C
  C     COMMON CONTAINING DESCRIPTION OF BYTE PACKING
        COMMON/FASPD/ISHIFT(22)
    C
  C     COMMON CONTAINING PRINT BUFFER FOR 1 LINE
       COMMON/FASPE/LTRBUF(146)
   C
  C     NONARRAY ITEMS IN COMMON/FASPB/
       EQUIVALENCE (JSPACE,LTRALL(1)),(ISTAR ,LTRALL(2)),
       1            (IVRTCL,LTRALL(3)),(IHRZNT,LTRALL(4)),
       2            (ICORNR,LTRALL(5)),(ISPACE,LTRALL(6))
   C
  C     ARRAYS NOT IN COMMON
        DIMENSION XPOINT(MAXSUB),YPOINT(MAXSUB),LTRBGN(35)
  C
  C     NUMBER OF CHARACTERS IN COMMON/FASPE/ BUFFER
         DATA MAXBFR/146/
 C
  C     INITIAL DEFINITION OF CHARACTERS IN COMMON/FASPB/
         DATA LTRBGN/1H ,1H*,1H!,1H-,1H+,1H ,1H&,1H*,1HA,1HB,
     1            1HC,1HD,1HE,1HF,1HG,1HH,1HI,1HJ,1HK,1HL,
     2            1HM,1HN,1HO,1HP,1HQ,1HR,1HS,1HT,1HU,1HV,
     3            1HW,1HX,1HY,1HZ,1H*/
      DATA KSPACE/1H /
 C
  C     ****************************************
  C     *                                      *
  C     *  FIND SIZE AND CHECK IF HAS CHANGED  *
  C     *                                      *
  C     ****************************************
  C
        IF(IRESET.NE.0)GO TO 1
      IF(JRESET.EQ.999)GO TO 9
       1 IF(IRESET.NE.3)GO TO 2
      IF(JRESET.EQ.999)GO TO 5
       2 JRESET=999
        IF(IRESET.EQ.2)GO TO 3
      IF(IRESET.EQ.5)GO TO 3
C
  C     INITIALIZE FIRST 3 LOCATIONS IN PLOT STORAGE
         KDMNSN=859
        LRGBYT=30
         MAXBYT=6
    C
  C     INITIALIZE REST OF PLOT STORAGE
     3 IWIDE=10
          IHIGH=5
      KWIDE=MAXBFR-15
        IF(KWIDE.GT.101)KWIDE=101
        KHIGH=51
          KONTNT=0
          DO 4 I=1,KDMNSN
      4 ISTORE(I)=0
       IF(IRESET.GE.4)GO TO 8
C
  C     INITIALIZE CHARACTERS AND DOMINANCE RULES
     5 DO 6 I=1,35
     6 LTRALL(I)=LTRBGN(I)
         MASTER(1)=1
       MASTER(2)=-1
      DO 7 I=3,28
     7 MASTER(I)=0
       MASTER(29)=2
    8 IRESET=0
    C
  C     ESTABLISH THE SHIFTING ARRAY.  MUST DO EACH TIME
    C     SINCE NOT HELD IN COMMON AND USER MIGHT HAVE
   C     REESTABLISHED COMMON WITHOUT EVER CALLING DAPLAT.
       9 I=1
          J=1
       10 ISHIFT(I)=J
       IF(I.GE.MAXBYT)GO TO 11
          I=I+1
        J=J*LRGBYT
        GO TO 10
    C
  C     FIND SIZE REQUESTED FOR THIS PLOT
       11 JWIDE=KWIDE
       IF(MAXWID.GT.0)JWIDE=MAXWID
      IF(JWIDE.GT.(MAXBFR-15))JWIDE=MAXBFR-15
         JHIGH=KHIGH
       IF(MAXHIH.GT.0)JHIGH=MAXHIH
      I=(MAXBYT*KDMNSN)/JWIDE
          IF(JHIGH.GT.I)JHIGH=I
 C
  C     PLOT CURRENT STORAGE IF NEW SIZE REQUESTED
      IPASS=0
      IF(KONTNT.EQ.0)GO TO 12
          IF(JWIDE.NE.KWIDE)GO TO 40
       IF(JHIGH.NE.KHIGH)GO TO 40
       GO TO 13
    C
  C     ZERO OUT ERROR COUNTS IF PLOT IS EMPTY
       12 IERR=0
       JERR=0
 C
  C     GET THE VARIOUS ITEMS NEEDED TO STORE CURVE
       13 XFIRST=XLEFT
      XFINAL=XRIGHT
          YFIRST=YLOWER
          YFINAL=YUPPER
          IF(MSHWID.GT.0)IWIDE=MSHWID
      IF(MSHHIH.GT.0)IHIGH=MSHHIH
      IOVER=LTROFF
      IUP=LINOFF
        MGRID=IGRID
       MEDGE=IEDGE
       MMRGN=MARGIN
      KWIDE=JWIDE
       KHIGH=JHIGH
       WIDE=KWIDE-1
      HIGH=KHIGH-1
      LTRPNT=0
          IF(LETTER.GE.0)LTRPNT=LETTER+2
        IF(LTRPNT.GE.LRGBYT)LTRPNT=LRGBYT-1
        LTRLIN=0
          IF(LTRPNT.GT.0)LTRLIN=KONECT+2
        IF(LTRLIN.GE.LRGBYT)LTRLIN=LRGBYT-1
  C
  C     **********************
C     *                    *
C     *  STORE THE POINTS  *
C     *                    *
C     **********************
C
        IF(MAXSUB.LT.MINSUB)GO TO 39
          XSCALE=WIDE/(XFINAL-XFIRST)
      YSCALE=HIGH/(YFINAL-YFIRST)
      INSERT=LTRPNT
          KONTNT=1
          KRD=MINSUB
        MAXSQR=1
       14 IX=1.5+(XSCALE*(XPOINT(KRD)-XFIRST))
       IY=1.5+HIGH-(YSCALE*(YPOINT(KRD)-YFIRST))
       IF(IPASS.GT.0)GO TO 16
C
  C     IF PLOT POINTS, CHECK IF POINT IS INSIDE WINDOW
      IF(IX.LE.0)GO TO 15
         IF(IX.GT.KWIDE)GO TO 15
          IF(IY.LE.0)GO TO 15
         IF(IY.GT.KHIGH)GO TO 15
          IF(KONECT.GE.-1)GO TO 29
         GO TO 22
       15 IERR=IERR+1
       GO TO 38
    C
  C     IF PLOT LINES, FIND PART OF LINE INSIDE WINDOW
    16 NEWX=IX
      NEWY=IY
      CALL PLTCUT(IPLCUT,IX,IY,LASTX,LASTY,1,1,KWIDE,KHIGH)
          IF(IPLCUT.NE.0)GO TO 17
          JERR=JERR+1
       GO TO 37
    C
  C     PROVIDE FOR INTEGER ROUNDING ALONG LINE SEGMENT
   17 IF(IY.GE.LASTY)GO TO 18
          I=IX
         IX=LASTX
          LASTX=I
      I=IY
         IY=LASTY
          LASTY=I
   18 MOVEX=IX-LASTX
         MOVEY=IY-LASTY
         LAGX=0
       LAGY=0
       IUSED=0
      IF(MOVEX.NE.0)GO TO 19
      IF(MOVEY.NE.0)GO TO 20
      MULT=0
       GO TO 29
       19 MULT=MOVEX
        IF(MULT.LT.0)MULT=-MULT
          IF(MOVEY.EQ.0)GO TO 21
      LAGX=MOVEY/2
      LAGY=MULT/2
       IF(MULT.GT.MOVEY)GO TO 21
     20 MULT=MOVEY
  C
  C     GET NEXT POINT ALONG THE LINE SEGMENT
   21 IF(MOVEX.LT.0)IX=LASTX-((LAGX-(IUSED*MOVEX))/MULT)
        IF(MOVEX.GT.0)IX=LASTX+((LAGX+(IUSED*MOVEX))/MULT)
        IY=LASTY+(((IUSED*MOVEY)+LAGY)/MULT)
       GO TO 29
    C
  C     TEST IF ALREADY WITHIN PROPER SET OF TERRACES
     22 IF(MAXSQR.GT.0)GO TO 23
          IF(KEEPX.NE.IX)GO TO 23
          IF(KEEPY.NE.IY)GO TO 23
          IF(MAXSQR.EQ.0)GO TO 28
          IX=LASTX
          IY=LASTY
          GO TO 25
    C
  C     PREPARE FOR TERRACE ZERO
      23 MAXSQR=KONECT
          KEEPX=IX
          KEEPY=IY
          MOVEX=0
      MOVEY=1
      MAXPIN=0
          KNTPIN=1
          IF(LETTER.NE.-1)GO TO 24
   C
  C     IF ERASING, MOVE DIRECTLY TO OUTER TERRACE
      MOVEY=0
      MOVEX=1
      MAXSQR=-1
         MAXPIN=-KONECT-KONECT-2
          KNTPIN=MAXPIN+1
        IX=IX+KONECT+1
         IY=IY-KONECT-1
   C
  C     TEST IF POINT ON TERRACE IS AVAILABLE FOR USE
     24 KNTPIN=KNTPIN-1
        IF(IX.LE.0)GO TO 25
         IF(IX.GT.KWIDE)GO TO 25
          IF(IY.LE.0)GO TO 25
         IF(IY.LE.KHIGH)GO TO 29
       25 IF(KNTPIN.GT.0)GO TO 26
    C
  C     TURN AT CORNER OF TERRACE
        I=MOVEX
      MOVEX=MOVEY
       MOVEY=-I
          IF(MOVEX.GT.0)GO TO 27
      KNTPIN=MAXPIN
    C
  C     TRAVEL ALONG SIDE OF TERRACE
       26 IX=IX+MOVEX
       IY=IY+MOVEY
       GO TO 24
    C
  C     EXPAND OUT TO NEXT TERRACE
    27 MAXSQR=MAXSQR+1
        IF(MAXSQR.GE.0)GO TO 28
          MAXPIN=MAXPIN+2
        IY=IY+1
      KNTPIN=MAXPIN
          GO TO 24
       28 IF(INSERT.NE.0)JERR=JERR+1
       GO TO 38
    C
  C     CALCULATE WORD COUNT AND BYTE COUNT IN WORD
       29 IBYTE=IX-1+(KWIDE*(IY-1))
        IWORD=IBYTE/MAXBYT
          IBYTE=IBYTE-(MAXBYT*IWORD)+1
          IWORD=IWORD+1
    C
  C     GET CURRENT CONTENTS OF BYTE.
         IRIGHT=ISTORE(IWORD)
        IF(IBYTE.GE.MAXBYT)GO TO 30
      ILEFT=IRIGHT/ISHIFT(IBYTE+1)
          IRIGHT=IRIGHT-(ISHIFT(IBYTE+1)*ILEFT)
   30 KOMPAR=IRIGHT/ISHIFT(IBYTE)
      I=INSERT
          IF(KONECT.GE.-1)GO TO 32
   C
  C     DECIDE CHARACTER TO INSERT ON TERRACE
      IF(INSERT.GT.0)GO TO 31
          IF(KOMPAR.EQ.0)GO TO 25
          GO TO 35
       31 IF(KOMPAR.EQ.0)GO TO 35
          IF(MASTER(KOMPAR).LT.MASTER(INSERT))GO TO 35
         GO TO 25
    C
  C     DECIDE CHARACTER TO INSERT AT POINT OR LINE SEGMENT
    32 IF(KOMPAR.EQ.INSERT)GO TO 36
          IF(KOMPAR.EQ.0)GO TO 35
          IF(INSERT.EQ.0)GO TO 35
          IF(IPASS.GT.0)GO TO 33
      IF(KOMPAR.EQ.LTRLIN)GO TO 35
          GO TO 34
       33 IF(KOMPAR.EQ.LTRPNT)GO TO 36
       34 IF(MASTER(KOMPAR).GT.MASTER(INSERT))GO TO 36
         IF(MASTER(KOMPAR).EQ.MASTER(INSERT))I=1
   C
  C     INSERT THE NEW CHARACTER
      35 IRIGHT=IRIGHT-(ISHIFT(IBYTE)*KOMPAR)
       ISTORE(IWORD)=(I*ISHIFT(IBYTE))+IRIGHT
          IF(IBYTE.LT.MAXBYT)ISTORE(IWORD)=
         1ISTORE(IWORD)+(ILEFT*ISHIFT(IBYTE+1))
C
  C     IF CLEARING OUT A SET OF TERRACES, RETURN FOR NEXT
        IF(KONECT.GE.-1)GO TO 36
         LASTX=IX
          LASTY=IY
          IF(INSERT.EQ.0)GO TO 25
          GO TO 38
    C
  C     CHECK IF LINE SEGMENT IS DONE
      36 IF(IPASS.LE.0)GO TO 38
      IUSED=IUSED+1
          IF(IUSED.LE.MULT)GO TO 21
  C
  C     NEW END OF THIS LINE BECOMES OLD END FOR NEXT LINE
     37 LASTX=NEWX
        LASTY=NEWY
     38 KRD=KRD+1
         IF(KRD.LE.MAXSUB)GO TO 14
  C
  C     DONE WITH THIS PASS, CHECK IF MUST MAKE LINE SEGMENTS
          IF(IPASS.GT.0)GO TO 39
      IPASS=1
      IF(KONECT.LT.0)GO TO 39
          LASTX=1.5+(XSCALE*(XPOINT(MINSUB)-XFIRST))
      LASTY=1.5+HIGH-(YSCALE*(YPOINT(MINSUB)-YFIRST))
      INSERT=LTRLIN
          KRD=MINSUB
        GO TO 38
    C
  C     ************************
   C     *                      *
   C     *  CONSTRUCT THE PLOT  *
   C     *                      *
   C     ************************
   C
     39 LTRERR=IERR
       LINERR=JERR
       IF(IPLOT.LT.0)GO TO 93
      IF(KONTNT.EQ.0)GO TO 93
          IPASS=1
      IF(IPLOT.GT.0)GO TO 41
C
  C     MARK THAT PLOT AREA IS EMPTY
       40 KONTNT=0
    C
  C     GET SWITCHES SET BY IGRID
  C     JGRID  = ONES DIGIT
   C     KGRID  = TENS DIGIT
   C     LGRID  = HUNDREDS DIGIT
       41 LGRID=MGRID
       IF(LGRID.LT.0)LGRID=-LGRID-1
          KGRID=LGRID/10
         JGRID=LGRID-10*KGRID
        LGRID=LGRID/100
        KGRID=KGRID-10*LGRID
  C
  C     GET SWITCHES SET BY IEDGE
  C     JEDGE  = ONES DIGIT
   C     KEDGE  = TENS DIGIT
   C     LEDGE  = HUNDREDS DIGIT
          LEDGE=MEDGE
       IF(LEDGE.LT.0)LEDGE=-LEDGE-1
          KEDGE=LEDGE/10
         JEDGE=LEDGE-10*KEDGE
        LEDGE=LEDGE/100
        KEDGE=KEDGE-10*LEDGE
  C
  C     DETERMINE LOCATIONS OF LEFT AND RIGHT PLOT EDGES
          IWIDTH=10
         IF(IWIDTH.GT.IWIDE)IWIDTH=IWIDE
       JWIDTH=IWIDTH/2
        IF(JEDGE.LE.1)GO TO 42
      IFIRST=1
          IF(JEDGE.EQ.2)IFIRST=JWIDTH+1
         GO TO 43
       42 IFIRST=12
      43 IF(IFIRST.LE.MMRGN)IFIRST=MMRGN+1
    C     THIS LINE PROTECT AGAINST OVERRUN OF BUFFER
    C     TEST IS AGAINST LENGTH OF BUFFER MINUS 4 CHARACTERS
 C     WHICH COULD APPEAR RIGHT OF PLOT IN SCALE NUMBERS
         IF(IFIRST.GT.(MAXBFR-3-KWIDE))IFIRST=MAXBFR-3-KWIDE
       LEAVE=IFIRST-3
         IFINAL=IFIRST+KWIDE-1
 C
  C     DETERMINE LOCATIONS OF LEFT AND RIGHT GRID LINES
          IF(IWIDE.GT.KWIDE)GO TO 48
       LOSSX=IOVER
       IF(LOSSX.LE.-KWIDE)GO TO 48
      IF(LOSSX.GE.KWIDE)GO TO 48
    44 IF(LOSSX.GE.0)GO TO 45
      LOSSX=LOSSX+IWIDE
      GO TO 44
       45 IF(LOSSX.LT.IWIDE)GO TO 46
       LOSSX=LOSSX-IWIDE
      GO TO 45
       46 LTRLFT=IFIRST+LOSSX
         LTRRIT=LTRLFT
       47 LTRRIT=LTRRIT+IWIDE
         IF(LTRRIT.LE.IFINAL)GO TO 47
          LTRRIT=LTRRIT-IWIDE
         GO TO 49
       48 LTRLFT=IFIRST-1
        LTRRIT=IFINAL+1
        LOSSX=KWIDE
       IF(JEDGE.EQ.0)JEDGE=1
       IF(JEDGE.EQ.2)JEDGE=3
    49 IF(IHIGH.GT.KHIGH)GO TO 54
       LOSSY=IUP
         IF(LOSSY.LE.-KHIGH)GO TO 54
      IF(LOSSY.GE.KHIGH)GO TO 54
    50 IF(LOSSY.GE.0)GO TO 51
      LOSSY=LOSSY+IHIGH
      GO TO 50
       51 IF(LOSSY.LT.IHIGH)GO TO 52
       LOSSY=LOSSY-IHIGH
      GO TO 51
       52 LINLOW=KHIGH-LOSSY
          LOSSY=LINLOW-1
      53 LOSSY=LOSSY-IHIGH
      IF(LOSSY.GE.0)GO TO 53
      LOSSY=IHIGH+LOSSY
      LINHIH=LOSSY+1
         GO TO 55
       54 LINHIH=0
          LINLOW=KHIGH+1
         LOSSY=KHIGH
 C
  C     RESET LIMITS WHICH PREVENT CERTAIN BORDER LINES
   55 IF(JGRID.EQ.0)GO TO 56
      IF(KGRID.LE.1)GO TO 57
   56 LTRLFT=IFIRST
          IF(KEDGE.GT.1)LTRLFT=LTRLFT-1
      57 IF(JGRID.EQ.0)GO TO 58
      IF(KGRID.EQ.0)GO TO 59
      IF(KGRID.EQ.2)GO TO 59
   58 LTRRIT=IFINAL
          IF(KEDGE.EQ.0)GO TO 59
      IF(KEDGE.NE.2)LTRRIT=LTRRIT+1
      59 IF(JGRID.EQ.0)GO TO 60
      IF(LGRID.LE.1)GO TO 61
   60 LINLOW=KHIGH
      IF(LEDGE.GT.1)LINLOW=LINLOW+1
      61 IF(JGRID.EQ.0)GO TO 62
      IF(LGRID.EQ.0)GO TO 63
      IF(LGRID.EQ.2)GO TO 63
   62 LINHIH=1
          IF(LEDGE.EQ.0)GO TO 63
      IF(LEDGE.NE.2)LINHIH=0
   63 JGRID=JGRID-1
    C
  C     FLOATING POINT WIDTH OF PLOT
          WIDE=KWIDE-1
      HIGH=KHIGH-1
C
  C     DEFINE HEIGHT OF REGION CONSIDERED TO CONTAIN ZERO
        IF(KHIGH.LE.1)GO TO 64
      ZERO=0.25*((YFINAL-YFIRST)/HIGH)
      IF(ZERO.LT.0.0)ZERO=-ZERO
  C
  C     DEFINE VALUE IN CASE PLOT IS ONLY 1 LINE HIGH
     64 VALUE=YFINAL
C
  C     SET CARRIAGE CONTROL CHARACTER
        KONTRL=JSPACE
          IF(LINPRT.GT.0)KONTRL=ISTAR
C
  C     DEFINE THE STARTING INDEXES
C     KNTLIN = CURRENT LINE NUMBER
    C     KNTWRD = SUBSCRIPT IN STORAGE ARRAY OF WORD BEING
   C              UNPACKED
C     KNTBYT = BYTE COUNT IN THE WORD BEING UNPACKED
 C     LOSSX AND LOSSY ARE USED TO PLACE GRIDS ON PLOT
C     LOSSX  = FROM NOW IS INITIAL VALUE OF COLUMN COUNT
  C              RELATIVE TO NEXT COLUMN TO BEAR GRID LINE
  C     LOSSY  = FROM NOW IS VALUE OF LINE COUNT RELATIVE
   C              TO NEXT LINE TO BEAR A GRID LINE.
      KNTLIN=1
          KNTWRD=0
          KNTBYT=MAXBYT
    C
  C     HIDDEN SWITCH FOR TIME SERIES PLOT CONSTRUCTION
C
  C     IEDGE.LT.0 DO NOT PLOT  BOTTOM LINE OF PLOT.  DO  NOT
    C                PLOT  SCALE NUMBERS   BELOW PLOT.   BOTTOM
    C                LINE IS ROLLED  INTO  TOP LINE AND REST OF
    C                PLOT STORAGE IS LEFT EMPTY.
    C
  C     IKNTBY = BYTE INTO WHICH  TO SAVE NEXT  UNPACKED BYTE
    C              IF ROLLING LAST LINE INTO FIRST
  C     IKNTWR = WORD INTO WHICH  TO SAVE NEXT  UNPACKED BYTE
    C              IF ROLLING LAST LINE INTO FIRST
  C
        IF(MGRID.GE.0)GO TO 65
      IKNTWR=0
          IKNTBY=MAXBYT
          KONTNT=0
    C
  C     CONSTANTS RESET AT START OF EACH LINE
   65 KNTLTR=IFIRST
          KNTCLM=LOSSX
      IF(LOSSY.NE.0)GO TO 67
      IF(JEDGE.GT.1)GO TO 67
C
  C     CONSTRUCT SCALE NUMBER ON LINE WHICH CAN BE GRID
          IF(KNTLIN.LE.1)GO TO 66
          VALUE=(YFINAL*(FLOAT(KHIGH-KNTLIN)/HIGH))+
     1(YFIRST*(FLOAT(KNTLIN-1)/HIGH))
       IF(VALUE.GE.ZERO)GO TO 66
        IF(VALUE.GT.(-ZERO))VALUE=0.0
      66 CALL DARITE(VALUE,1,0,0,1,-3,0,LEAVE,-2,7,
     15,5,0,0,4,0,0,-1,0,MAXBFR,LTRBUF,I,KERR)
        IUSED=LEAVE+2
          LTRBUF(LEAVE+1)=KSPACE
      LTRBUF(IUSED)=IHRZNT
        GO TO 69
    C
  C     FILL SPACE TO LEFT WITH SPACES IF NO SCALE NUMBER
      67 IUSED=1
      I=0
       68 I=I+1
        IF(I.GE.IFIRST)GO TO 69
          LTRBUF(I)=KSPACE
       GO TO 68
    C
  C     UNPACK NEXT BYTE
    69 KNTBYT=KNTBYT+1
        IF(KNTBYT.LE.MAXBYT)GO TO 70
          KNTWRD=KNTWRD+1
        KNTBYT=1
          IVALUE=ISTORE(KNTWRD)
       IF(KONTNT.EQ.0)ISTORE(KNTWRD)=0
    70 JVALUE=IVALUE
          IVALUE=IVALUE/LRGBYT
        JVALUE=JVALUE-(LRGBYT*IVALUE)
   C
  C     IF ROLLING LAST LINE INTO FIRST, SAVE BYTE
      IF(MGRID.GE.0)GO TO 72
      IF(KNTLIN.LT.KHIGH)GO TO 72
      IKNTBY=IKNTBY+1
        IF(IKNTBY.LE.MAXBYT)GO TO 71
          IKNTBY=1
          IKNTWR=IKNTWR+1
     71 ISTORE(IKNTWR)=ISTORE(IKNTWR)+(JVALUE*ISHIFT(IKNTBY))
    C
  C     DECIDE WHAT CHARACTER TO PLACE INTO OUTPUT BUFFER
      72 IF(JVALUE.GT.0)GO TO 79
          IF(KNTLIN.EQ.LINLOW)GO TO 74
          IF(KNTLIN.EQ.LINHIH)GO TO 74
          IF(LOSSY.EQ.0)GO TO 75
      IF(KNTLTR.EQ.LTRLFT)GO TO 73
          IF(KNTLTR.EQ.LTRRIT)GO TO 73
          IF(JGRID.GE.0)GO TO 81
      IF(KNTCLM.GT.0)GO TO 81
       73 LTRBUF(KNTLTR)=IVRTCL
       GO TO 80
       74 IF(KNTLTR.EQ.LTRLFT)GO TO 78
          IF(KNTLTR.EQ.LTRRIT)GO TO 78
          GO TO 76
       75 IF(KNTLTR.EQ.LTRLFT)GO TO 78
          IF(KNTLTR.EQ.LTRRIT)GO TO 78
          IF(JGRID.GE.0)GO TO 77
   76 IF(KNTCLM.LE.0)GO TO 78
          LTRBUF(KNTLTR)=IHRZNT
       GO TO 80
       77 IF(JGRID.GT.0)GO TO 81
      IF(KNTCLM.GT.0)GO TO 81
       78 LTRBUF(KNTLTR)=ICORNR
       GO TO 80
       79 LTRBUF(KNTLTR)=LTRALL(JVALUE+6)
    80 IUSED=KNTLTR
      GO TO 82
       81 LTRBUF(KNTLTR)=ISPACE
    82 IF(KNTCLM.LE.0)KNTCLM=IWIDE
      KNTCLM=KNTCLM-1
        KNTLTR=KNTLTR+1
        IF(KNTLTR.LE.IFINAL)GO TO 69
    C
  C     OUTPUT THE COMPLETED LINE
        KNTLIN=KNTLIN+1
        IF(KNTLIN.LE.KHIGH)GO TO 83
      IF(MGRID.GE.0)GO TO 83
      KONTNT=1
          GO TO 92
       83 IF(LINPRT.LT.0)WRITE(IDISK,84)(LTRBUF(I),I=1,IUSED)
       IF(LINPRT.GE.0)WRITE(IDISK,84)KONTRL,
     1(LTRBUF(I),I=1,IUSED)
    84 FORMAT(147A1)
          IF(LOSSY.LE.0)LOSSY=IHIGH
        LOSSY=LOSSY-1
          IF(KNTLIN.LE.KHIGH)GO TO 65
C
  C     PRINT GRID LINE EXTENSIONS BELOW PLOT
      IF(JEDGE.EQ.1)GO TO 92
      IF(JEDGE.GE.3)GO TO 92
      IF(IWIDE.GT.KWIDE)GO TO 92
       IFIRST=IFIRST+LOSSX
         KNTLTR=0
          I=IFIRST
       85 KNTLTR=KNTLTR+1
        IF(KNTLTR.GE.I)GO TO 86
          LTRBUF(KNTLTR)=KSPACE
       GO TO 85
       86 LTRBUF(KNTLTR)=IVRTCL
       I=I+IWIDE
         IF(I.LE.IFINAL)GO TO 85
          IF(LINPRT.LT.0)WRITE(IDISK,84)(LTRBUF(I),I=1,KNTLTR)
      IF(LINPRT.GE.0)WRITE(IDISK,84)KONTRL,
     1(LTRBUF(I),I=1,KNTLTR)
C
  C     PRINT SCALE NUMBERS BELOW GRID LINE EXTENSIONS
       LERR=-1
      MINSIG=5
          IF(MINSIG.GT.(IWIDTH-2))MINSIG=IWIDTH-2
         IF(MINSIG.LE.0)MINSIG=1
          IF(KWIDE.LE.1)GO TO 87
      ZERO=0.25*((XFINAL-XFIRST)/WIDE)
      IF(ZERO.LT.0.0)ZERO=-ZERO
     87 KIND=LERR
         KNTLTR=IFIRST-JWIDTH-1
      I=LOSSX+1
         VALUE=XFIRST
   88 NEED=KNTLTR+IWIDE
      IF(I.LE.1)GO TO 89
          VALUE=(XFIRST*(FLOAT(KWIDE-I)/WIDE))+
     1(XFINAL*(FLOAT(I-1)/WIDE))
       IF(VALUE.GE.ZERO)GO TO 89
        IF(VALUE.GT.(-ZERO))VALUE=0.0
      89 CALL DARITE(VALUE,0,0,KIND,1,-3,0,IWIDTH,-2,-2,
     1MINSIG,5,0,0,4,0,0,-1,KNTLTR,MAXBFR,LTRBUF,KNTOUT,
       2KERR)
        KNTLTR=KNTOUT
          IF(KERR.GT.0)LERR=1
         I=I+IWIDE
         IF(I.GT.KWIDE)GO TO 91
   90 IF(NEED.LE.KNTLTR)GO TO 88
       KNTLTR=KNTLTR+1
        LTRBUF(KNTLTR)=KSPACE
       GO TO 90
       91 IF(LINPRT.LT.0)WRITE(IDISK,84)(LTRBUF(I),I=1,KNTLTR)
      IF(LINPRT.GE.0)WRITE(IDISK,84)KONTRL,
     1(LTRBUF(I),I=1,KNTLTR)
      IF(KIND.NE.LERR)GO TO 87
      92 IF(IPASS.LE.0)GO TO 12
   93 RETURN
 C581314532331!&
         END
    
