      SUBROUTINE DALINE(IGRID ,KNDBAR,LSTLIN,MARGIN,MSHLFT,
         1    MSHRIT,LNGLFT,LNGRIT,XLEFT ,XRIGHT,SEGMNT,MINSEG,
         2    MAXSEG,LETTER,MINLTR,MAXLTR,YVALUE,LABEL ,MINLBL,
         3    MAXLBL,LINPRT,IDISK )
  C     RENBR(/HORIZONTAL BAR CHART PLOTTER FOR PRINTER)
    C
  C     DONALD BARTH, HARVARD BUSINESS SCHOOL
C
  C     DALINE   CONSTRUCTS   PRINTABLE   PLOTS    CONTAINING
    C     HORIZONTAL  BARS  FORMED  OF SEGMENTS, THE LENGTHS OF
    C     WHICH REPRESENT MAGNITUDES OF  CORRESPONDING  VALUES.
    C     BARS CAN BE SUPERIMPOSED UPON BACKGROUND GRID AND CAN
                                       C     EXTEND TO EITHER SIDE OF CENTRAL COLUMN CORRESPONDING
    C     TO  ZERO.  NEGATIVE SEGMENTS (DEBITS) ARE ACCUMULATED
    C     TO ONE SIDE OF ZERO  COLUMN,  AND  POSITIVE  SEGMENTS
    C     (CREDITS)  TO  OTHER,  ALTHOUGH  USER  HAS  OPTION OF
    C     SUPPRESSING DISPLAY OF  EITHER  PORTION.   DALINE  IS
    C     CALLED AS MANY TIMES AS THERE ARE LINES IN PLOT, EACH
    C     SUBSEQUENT CALL GENERATING NEXT LOWER LINE OF PLOT.
 C
  C     ARGUMENTS OF THIS ROUTINE ARE USED ONLY FOR INPUT.
  C
  C     IGRID  = SELECTS BACKGROUND CHARACTERS  TO  BE  SHOWN
                                                           C              WHERE  NOT  HIDDEN  BY  CHARACTERS  USED  TO
    C              REPRESENT BAR SEGMENTS,  SELECTS  CHARACTER,
    C              IF  ANY,  TO  APPEAR IN CENTRAL ZERO COLUMN,
    C              AND SELECTS TYPE OF CAPTION, EITHER  NUMERIC
    C              OR  ALPHABETIC,  TO  BE  SHOWN  TO  LEFT  OF
    C              CURRENTLY  GENERATED  PANEL  OF  BAR  CHART.
    C              THESE  OPTIONS  ARE  SELECTED  BY  DIGITS IN
    C              ONES,   TENS,   AND    HUNDREDS    POSITIONS
    C              RESPECTIVELY  IN  DECIMAL  INTEGER  VALUE OF
                                                           C              IGRID.  MEANINGS ASSIGNED TO  EACH  POSITION
    C              IN VALUE OF IGRID ARE AS FOLLOW
  C
  C            ONES DIGIT OF IGRID
 C
  C              SELECTS CHARACTERS  TO  BE  INCLUDED  ACROSS
    C              WIDTH  OF  PLOT  IN  COLUMNS NOT OCCUPIED BY
    C              CHARACTERS USED TO REPRESENT  BAR  SEGMENTS,
    C              BUT DOES NOT DICTATE CHARACTERS APPEARING IN
    C              EITHER LEFT MARGIN OR IN COLUMN REPRESENTING
    C              ZERO.
   C
  C              0  SPACES WILL BE SHOWN WHERE NOT HIDDEN  BY
                                                                C                 CHARACTERS    USED   TO   REPRESENT   BAR
    C                 SEGMENTS.
 C              1  MINUS  SIGNS  WILL  BE  SHOWN  WHERE  NOT
    C                 HIDDEN  BY  CHARACTERS  USED TO REPRESENT
    C                 BAR SEGMENTS.
  C              2  IF  NOT  HIDDEN  BY  CHARACTERS  USED  TO
    C                 REPRESENT  BAR SEGMENTS, THEN EXCLAMATION
    C                 POINTS WILL BE SHOWN IN  LEFTMOST  COLUMN
    C                 WHICH  COULD  BEAR  LOWER SCALE NUMBER TO
    C                 LEFT OF ZERO  COLUMN,  AND  IN  RIGHTMOST
                                                           C                 COLUMN   WHICH  COULD  BEAR  LOWER  SCALE
    C                 NUMBER TO RIGHT OF ZERO COLUMN.
    C              3  SAME AS IGRID=2, EXCEPT THAT MINUS  SIGNS
    C                 ARE INCLUDED INSTEAD OF SPACES IN COLUMNS
    C                 WHICH CONTAIN NEITHER EXCLAMATION  POINTS
    C                 NOR   CHARACTERS   WHICH   REPRESENT  BAR
    C                 SEGMENTS.
 C              4  SAME  AS  IGRID=2,  EXCEPT  THAT  IF  NOT
    C                 HIDDEN  BY  CHARACTERS  USED TO REPRESENT
    C                 BAR SEGMENTS, THEN  PLUS  SIGNS  WILL  BE
                                       C                 SHOWN IN LEFTMOST COLUMN WHICH COULD BEAR
    C                 LOWER  SCALE  NUMBER  TO  LEFT  OF   ZERO
    C                 COLUMN,  AND  IN  RIGHTMOST  COLUMN WHICH
    C                 COULD BEAR LOWER SCALE NUMBER TO RIGHT OF
    C                 ZERO COLUMN.
   C              5  SAME AS IGRID=4, EXCEPT THAT MINUS  SIGNS
    C                 ARE INCLUDED INSTEAD OF SPACES IN COLUMNS
    C                 WHICH  CONTAIN  NEITHER  PLUS  SIGNS  NOR
    C                 CHARACTERS WHICH REPRESENT BAR SEGMENTS.
C              6  IF  NOT  HIDDEN  BY  CHARACTERS  USED  TO
                             C                 REPRESENT  BAR SEGMENTS, THEN EXCLAMATION
    C                 POINTS WILL BE SHOWN IN EACH COLUMN WHICH
    C                 COULD BEAR LOWER SCALE NUMBER.
C              7  SAME AS IGRID=6, EXCEPT THAT MINUS  SIGNS
    C                 ARE INCLUDED INSTEAD OF SPACES IN COLUMNS
    C                 WHICH CONTAIN NEITHER EXCLAMATION  POINTS
    C                 NOR   CHARACTERS   WHICH   REPRESENT  BAR
    C                 SEGMENTS.
 C              8  SAME  AS  IGRID=6,  EXCEPT  THAT  IF  NOT
    C                 HIDDEN  BY  CHARACTERS  USED TO REPRESENT
                                            C                 BAR SEGMENTS, THEN  PLUS  SIGNS  WILL  BE
    C                 SHOWN  IN  EACH  COLUMN  WHICH COULD BEAR
    C                 LOWER SCALE NUMBER.
 C              9  SAME AS IGRID=8, EXCEPT THAT MINUS  SIGNS
    C                 ARE INCLUDED INSTEAD OF SPACES IN COLUMNS
    C                 WHICH  CONTAIN  NEITHER  PLUS  SIGNS  NOR
    C                 CHARACTERS WHICH REPRESENT BAR SEGMENTS.
C
  C              FOLLOWING   EXAMPLES   DEMONSTRATE   RESULTS
    C              PRODUCED BY VARIOUS VALUES OF ONES DIGIT.
  C
  C       ONES DIGIT = 0
                                                        C                  = 1    --------------- ---------------
 C                  = 2    !                             !
 C                  = 3    !-------------- --------------!
 C                  = 4    +                             +
 C                  = 5    +-------------- --------------+
 C                  = 6    !    !    !         !    !    !
 C                  = 7    !----!----!---- ----!----!----!
 C                  = 8    +    +    +         +    +    +
 C                  = 9    +----+----+---- ----+----+----+
 C           TICK MARKS    !    !    !    !    !    !    !
                                         C        SCALE NUMBERS  -15.0-10.0-5.0   0   5.0  10.0 15.0
    C
  C            TENS DIGIT OF IGRID
 C
  C              SELECTS CHARACTER, IF ANY, TO  BE  SHOWN  IN
    C              ZERO   COLUMN,   AND   WHETHER  LOWER  SCALE
    C              NUMBERS, IF GENERATED  BY  CURRENT  CALL  TO
    C              THIS ROUTINE, IDENTIFY ZERO COLUMN.
   C
  C              0  ZERO COLUMN IS NOT REPRESENTED.
    C              1, 2, 3 OR 4, ZERO COLUMN IS REPRESENTED  BY
    C                 CHARACTER INDICATED BY TENS DIGIT, BUT IS
    C                 NOT  TO  BE  IDENTIFIED  IN  LOWER  SCALE
                             C                 NUMBERS   WHICH  MIGHT  BE  GENERATED  BY
    C                 CURRENT CALL TO THIS ROUTINE.
 C              1  ZERO COLUMN REPRESENTED BY SPACE.
  C              2  ZERO COLUMN REPRESENTED BY MINUS SIGN.
  C              3  ZERO COLUMN  REPRESENTED  BY  EXCLAMATION
    C                 POINT.
    C              4  ZERO COLUMN REPRESENTED BY PLUS SIGN.
   C              5, 6, 7 OR 8, ZERO COLUMN IS REPRESENTED  BY
    C                 SAME    CHARACTER    AS    SELECTED    BY
    C                 1, 2, 3 OR 4  RESPECTIVELY.   IF  CURRENT
                                                                C                 CALL TO THIS ROUTINE ALSO GENERATES LOWER
    C                 SCALE NUMBERS, THEN ZERO COLUMN  WILL  BE
    C                 IDENTIFIED  BY  SCALE NUMBER HAVING VALUE
    C                 ZERO.
C
  C              FOLLOWING   EXAMPLES   DEMONSTRATE   RESULTS
    C              PRODUCED BY VARIOUS VALUES OF TENS DIGIT.
  C
  C       TENS DIGIT = 0
 C
  C                +-+--+-+
   C                ! !  ! !
   C               -4-2  2 4
   C
  C       TENS DIGIT = 1          2          3          4
   C
  C                +-+- -+-+  +-+---+-+  +-+-!-+-+  +-+-+-+-+
                                  C                ! !   ! !  ! !   ! !  ! !   ! !  ! !   ! !
    C               -4-2   2 4 -4-2   2 4 -4-2   2 4 -4-2   2 4
    C
  C       TENS DIGIT = 5          6          7          8
   C
  C                +-+- -+-+  +-+---+-+  +-+-!-+-+  +-+-+-+-+
    C                ! ! ! ! !  ! ! ! ! !  ! ! ! ! !  ! ! ! ! !
    C               -4-2 0 2 4 -4-2 0 2 4 -4-2 0 2 4 -4-2 0 2 4
    C
  C            HUNDREDS DIGIT OF IGRID
  C
  C              SELECTS TYPE OF CAPTION, EITHER  NUMERIC  OR
    C              ALPHABETIC, TO BE SHOWN TO LEFT OF CURRENTLY
    C              GENERATED PANEL OF BAR CHART.
    C
            C              0  LEFT MARGIN IS TO CONTAIN SPACES.
  C              1  REPRESENTATION OF VALUE INPUT AS ARGUMENT
    C                 NAMED  YVALUE IS TO BE RIGHT JUSTIFIED IN
    C                 MARGIN TO LEFT  OF  LEFT  BORDER  OF  BAR
    C                 CHART.
    C              2  CHARACTERS INPUT IN LABEL(MINLBL) THROUGH
    C                 AND  INCLUDING  LABEL(MAXLBL)  ARE  TO BE
    C                 RIGHT JUSTIFIED IN MARGIN TO LEFT OF LEFT
    C                 BORDER OF BAR CHART.
C              3 OR 4, SAME AS 1 OR 2 RESPECTIVELY,  EXCEPT
                                                                C                 THAT  SPACE  CHARACTER  IS PLACED BETWEEN
    C                 RIGHT JUSTIFIED NUMBER OR WORD  AND  LEFT
    C                 BORDER OF PLOT.
C              5 OR 6, SAME AS 3 OR 4 RESPECTIVELY,  EXCEPT
    C                 THAT  MINUS  SIGN  IS  TO  BE PLACED INTO
    C                 COLUMN TO IMMEDIATE LEFT OF  LEFT  BORDER
    C                 OF BAR CHART.
  C
  C              FOLLOWING   EXAMPLES   DEMONSTRATE   RESULTS
    C              PRODUCED   BY  VARIOUS  VALUES  OF  HUNDREDS
    C              DIGIT.
  C
  C       HUNDREDS DIGIT = 0          +----+---- ----+----+
                     C                      = 1     12.34+----+---- ----+----+
 C                      = 2     LABEL+----+---- ----+----+
 C                      = 3    12.34 +----+---- ----+----+
 C                      = 4    LABEL +----+---- ----+----+
 C                      = 5    12.34-+----+---- ----+----+
 C                      = 6    LABEL-+----+---- ----+----+
 C               TICK MARKS          !    !         !    !
 C            SCALE NUMBERS        -10.0-5.0       5.0  10.0
    C
  C     KNDBAR = SPECIFIES  WHICH  BAR  SEGMENT  IS   TO   BE
    C              REPRESENTED  IF  MORE  THAN  ONE BAR SEGMENT
                        C              APPEARS IN SINGLE COLUMN OF PLOT, AND  WHICH
    C              COLUMNS  ARE  TO  REPRESENT  ANY BAR SEGMENT
    C              WHICH  EXTENDS  ACROSS  MORE   THAN   SINGLE
    C              COLUMN.
 C            = -1, NO BAR SEGMENTS ARE  TO  BE  PLOTTED  IN
    C              CURRENT PANEL.  RESULTING PANEL IS IDENTICAL
    C              TO THAT WHICH WOULD BE PRODUCED IF MINSEG IS
    C              SET GREATER THAN MAXSEG.
    C            = 0, EACH BAR SEGMENT  IS  TO  BE  REPRESENTED
    C              ONLY  IN  FINAL  COLUMN  (THAT FURTHEST FROM
                                                      C              ZERO  COLUMN)  IN  WHICH   IT   IS   LARGEST
    C              COMPONENT.   SPACES  ARE  INSERTED  INTO ANY
    C              OTHER  COLUMNS  IN  WHICH  BAR  SEGMENT   IS
    C              DOMINANT.
    C            = 1, EACH BAR SEGMENT  IS  TO  BE  REPRESENTED
    C              ONLY  IN  FINAL  COLUMN  (THAT FURTHEST FROM
    C              ZERO  COLUMN)  IN  WHICH   IT   IS   LARGEST
    C              COMPONENT.  GRID CHARACTERS SELECTED BY ONES
    C              DIGIT OF DECIMAL INTEGER VALUE OF IGRID  ARE
    C              INSERTED INTO ANY OTHER COLUMNS IN WHICH BAR
                             C              SEGMENT IS DOMINANT.
   C            = 2, EACH BAR SEGMENT IS TO BE REPRESENTED  IN
    C              ALL   COLUMNS   IN   WHICH   IT  IS  LARGEST
    C              COMPONENT.
   C            = 3,  4  OR  5,  SAME  AS  KIND=0,  1   OR   2
    C              RESPECTIVELY,   EXCEPT  THAT  FINAL  COLUMNS
    C              (THOSE FURTHEST TO LEFT AND TO RIGHT OF ZERO
    C              COLUMN)  WHICH  CONTAIN  FINAL  NEGATIVE AND
    C              FINAL POSITIVE VALUES  SPECIFIED  BY  SEGMNT
    C              ARRAY   INSTEAD   CONTAIN   GRID  CHARACTERS
                                                      C              SELECTED BY ONES DIGIT  OF  DECIMAL  INTEGER
    C              VALUE  OF IGRID IF LARGEST COMPONENTS WITHIN
    C              THESE  COLUMNS  ARE   SMALLER   THAN   SPACE
    C              REMAINING IN THESE COLUMNS.
 C            = 6, EACH BAR SEGMENT  IS  TO  BE  REPRESENTED
    C              ONLY  IN  FINAL  COLUMN  (THAT FURTHEST FROM
    C              ZERO COLUMN) IN WHICH BAR  SEGMENT  APPEARS.
    C              IF  TWO  OR  MORE  BAR SEGMENTS TERMINATE IN
    C              SAME COLUMN, THEN BAR SEGMENT  SPECIFIED  BY
    C              SEGMNT    ARRAY   LOCATION   HAVING   HIGHER
              C              SUBSCRIPT IS REPRESENTED,  AND  BAR  SEGMENT
    C              SPECIFIED  BY  THE  SEGMENT  ARRAY  LOCATION
    C              HAVING   LOWER    SUBSCRIPT    IS    INSTEAD
    C              REPRESENTED  IN  ADJACENT COLUMN NEXT CLOSER
    C              TO ZERO COLUMN IF THIS LOWER BAR SEGMENT  IS
    C              ONLY  BAR  SEGMENT  WHICH  APPEARS  IN  THIS
    C              ADJACENT COLUMN.  SPACES ARE  INSERTED  INTO
    C              ANY  OTHER  COLUMNS ACROSS WHICH BAR SEGMENT
    C              EXTENDS.
C            = 7,  SAME  AS  KNDBAR=6,  EXCEPT  THAT   GRID
                                  C              CHARACTERS SELECTED BY ONES DIGIT OF DECIMAL
    C              INTEGER VALUE OF IGRID ARE INSERTED INTO ANY
    C              OTHER   COLUMNS   WHICH   DO   NOT   CONTAIN
    C              TERMINATION OF BAR SEGMENT.
 C            = 8, EACH BAR SEGMENT IS REPRESENTED IN  FINAL
    C              COLUMN  (THAT  FURTHEST FROM ZERO COLUMN) IN
    C              WHICH  BAR  SEGMENT  APPEARS,  AND  IN  EACH
    C              COLUMN   IN   WHICH   BAR  SEGMENT  IS  ONLY
    C              COMPONENT.
   C
  C              AS DEMONSTRATION OF  PLOTTING  MODIFICATIONS
                                            C              CAUSED BY VARIOUS VALUES OF KNDBAR, NUMBERS
C
  C         .3  .4  .2  3.5  .1  .3  3.5  .2  .1  3.5  .3  .2
    C
  C              AND
C
  C        -.3 -.4 -.2 -3.5 -.1 -.3 -3.5 -.2 -.1 -3.5 -.3 -.2
    C
  C              ARE PLOTTED  BELOW  REPRESENTED  BY  LETTERS
    C              THROUGH       X       RESPECTIVELY      WITH
    C              LNGLFT=LNGRIT=15,  XLEFT=-15  AND  XRIGHT=15
    C              FOR ALL POSSIBLE VALUES OF KNDBAR
C
  C            KNDBAR =-1   +----+----+----+----+----+----+
 C                   = 0   +-WV   S  P   N+B   D  G   JK-+
                                         C                   = 1   +-WV-+-S--P---N+B---D--G-+-JK-+
 C                   = 2   +-WVVVVSSSPPPPN+BDDDDGGGJJJJK-+
 C                   = 3   +--V   S  P   N+B   D  G   J--+
 C                   = 4   +--V-+-S--P---N+B---D--G-+-J--+
 C                   = 5   +--VVVVSSSPPPPN+BDDDDGGGJJJJ--+
 C                   = 6   +-XV  US  RP  O+C  DF  GI  JL-+
 C                   = 7   +-XV-+US--RP--O+C--DF--GI+-JL-+
 C                   = 8   +-XVVVUSSSRPPPO+CDDDFGGGIJJJL-+
 C            TICK MARKS   !    !    !    !    !    !    !
 C         SCALE NUMBERS -15.0-10.0-5.0   0   5.0  10.0 15.0
    C
                                C              LETTERS WHICH APPEAR IN COLUMNS 1, 5, 9  AND
    C              13  WHEN  KNDBAR  IS LESS THAN OR EQUAL TO 5
    C              ARE DIFFERENT THAN WHOSE WHICH  APPEAR  WHEN
    C              KNDBAR  IS  GREATER  THAN  OR  EQUAL  TO  6.
    C              CORRESPONDENCE  OF  LETTERS  TO  COLUMNS  IS
    C              SHOWN IN CHART BELOW.
  C
  C                        COLUMNS                   COLUMNS
C           COLUMN 1    ! 2 - 4 !     COLUMN 5    ! 6 - 8 !
    C                       !       !                 !       !
    C       .3A .4B .2C .1D !  3.D  ! .4D .1E .3F .2G !  3.G  !
    C
            C                        COLUMNS
 C           COLUMN 9    !10 - 12!     COLUMN 13
 C                       !       !
C       .3G .2H .1I .4J !  3.J  ! .1J .3K .2L AND .4 SPACE
C
  C
  C     LSTLIN = -1, LOWER SCALE NUMBERS ARE TO BE GENERATED,
    C              BUT   PANEL   OF   BAR  CHART  WILL  NOT  BE
    C              GENERATED.
   C            = 0, CURRENT PANEL FINISHES BAR CHART.   SCALE
    C              NUMBERS  RANGING IN VALUE FROM THAT OF XLEFT
    C              (IF LNGLFT IS  GREATER  THAN  ZERO)  THROUGH
    C              THAT  OF  XRIGHT  (IF LNGRIT IS GREATER THAN
                                  C              ZERO) ARE TO BE WRITTEN BELOW CURRENT  PANEL
    C              OF BAR CHART.
C            = GREATER THAN ZERO, CURRENT  PANEL  DOES  NOT
    C              FINISH  BAR  CHART.   SCALE  NUMBERS ARE NOT
    C              GENERATED.
   C
  C     MARGIN = WIDTH, STATED AS NUMBER  OF  CHARACTERS,  IN
    C              MARGIN  TO  BE  INCLUDED  TO LEFT OF CURRENT
    C              PANEL OF BAR CHART.  WIDTH OF MARGIN MUST BE
    C              SAME  FOR  ALL  PANELS  FORMING  BAR  CHART.
    C              MARGIN MUST INCLUDE SUFFICIENT ROOM FOR LEFT
                                                           C              SCALE  NUMBER  OR  FOR LEFT ALPHAMERIC LABEL
    C              REQUESTED BY NONZERO VALUE OF HUNDREDS DIGIT
    C              OF  DECIMAL  INTEGER VALUE OF IGRID, AND FOR
    C              EXTRA SPACE  OR  FOR  EXTRA  MINUS  SIGN  IF
    C              HUNDREDS  DIGIT  OF IGRID IS GREATER THAN OR
    C              EQUAL TO 3.  IF  SCALE  NUMBERS  ARE  TO  BE
    C              WRITTEN  BELOW  BAR  CHART, AND IF LNGLFT IS
    C              GREATER THAN ZERO, THEN MARGIN  SHOULD  HAVE
    C              VALUE  OF AT LEAST 5 (OR OF AT LEAST HALF OF
                                                           C              MSHLFT IF MSHLFT IS LESS THAN 10)  TO  ALLOW
    C              NUMBER  TO  BE  CENTERED  BELOW  LEFT BORDER
    C              LINE.  IF LNGLFT IS NOT GREATER  THAN  ZERO,
    C              THEN  ROOM  DOES  NOT  NEED TO BE ALLOWED IN
    C              LEFT MARGIN FOR LOWER SCALE NUMBERS.
  C
  C     MSHLFT = WIDTH OF GRID DIVISIONS INDICATED EITHER  BY
    C              EXCLAMATION  POINTS OR PLUS SIGNS IN PORTION
    C              OF BAR CHART TO LEFT  OF  ZERO  COLUMN.   IF
    C              MSHLFT  IS EQUAL TO ZERO, THEN GRID DIVISION
                                                                C              WIDTH OF 10 IS ASSUMED.  MSHLFT IS EQUAL  TO
    C              ONE   MORE   THAN   NUMBER   OF  COLUMNS  OF
    C              CHARACTERS  APPEARING  BETWEEN   EXCLAMATION
    C              POINTS OR PLUS SIGNS.
  C
  C     MSHRIT = WIDTH OF GRID DIVISIONS INDICATED EITHER  BY
    C              EXCLAMATION  POINTS OR PLUS SIGNS IN PORTION
    C              OF BAR CHART TO RIGHT OF  ZERO  COLUMN.   IF
    C              MSHRIT  IS EQUAL TO ZERO, THEN GRID DIVISION
    C              WIDTH OF 10 IS ASSUMED.  MSHRIT IS EQUAL  TO
    C              ONE   MORE   THAN   NUMBER   OF  COLUMNS  OF
              C              CHARACTERS  APPEARING  BETWEEN   EXCLAMATION
    C              POINTS OR PLUS SIGNS.
  C
  C     LNGLFT = 0, BAR CHART IS NOT TO INCLUDE  ANY  COLUMNS
    C              TO  LEFT  OF  ZERO  COLUMN.   THIS  DOES NOT
    C              CHANGE WIDTH OF  LEFT  MARGIN  SPECIFIED  BY
    C              VALUE OF MARGIN.
  C            = GREATER  THAN  ZERO,  LNGLFT  IS  NUMBER  OF
    C              COLUMNS  OF CHARACTERS TO BE INCLUDED IN BAR
    C              CHART TO LEFT OF ZERO COLUMN.
    C
  C     LNGRIT = 0, BAR CHART IS NOT TO INCLUDE  ANY  COLUMNS
    C              TO RIGHT OF ZERO COLUMN.
         C            = GREATER  THAN  ZERO,  LNGRIT  IS  NUMBER  OF
    C              COLUMNS  OF CHARACTERS TO BE INCLUDED IN BAR
    C              CHART TO RIGHT OF ZERO COLUMN.
   C
  C     XLEFT  = ACCUMULATED TOTAL OF  SEGMNT  VALUES  HAVING
    C              SAME   SIGN   AS   XLEFT   WHICH  IS  TO  BE
    C              REPRESENTED BY LEFT BORDER OF PORTION OF BAR
    C              CHART  TO  LEFT  OF ZERO COLUMN IF LNGLFT IS
    C              GREATER THAN ZERO.  IF  XLEFT  IS  NEGATIVE,
    C              THEN ONLY NEGATIVE VALUES ARE REPRESENTED TO
    C              LEFT OF ZERO COLUMN.  IF XLEFT IS  POSITIVE,
    C              THEN ONLY POSITIVE VALUES ARE REPRESENTED TO
    C              LEFT OF ZERO COLUMN.
   C
  C     XRIGHT = ACCUMULATED TOTAL OF  SEGMNT  VALUES  HAVING
    C              SAME   SIGN   AS   XRIGHT  WHICH  IS  TO  BE
    C              REPRESENTED BY RIGHT BORDER  OF  PORTION  OF
    C              BAR  CHART TO RIGHT OF ZERO COLUMN IF LNGRIT
    C              IS  GREATER  THAN  ZERO.    IF   XRIGHT   IS
    C              NEGATIVE,  THEN  ONLY  NEGATIVE  VALUES  ARE
    C              REPRESENTED TO RIGHT  OF  ZERO  COLUMN.   IF
    C              XRIGHT   IS  POSITIVE,  THEN  ONLY  POSITIVE
              C              VALUES ARE  REPRESENTED  TO  RIGHT  OF  ZERO
    C              COLUMN.
 C
  C     SEGMNT = ARRAY   CONTAINING   IN   ARRAY    LOCATIONS
    C              SEGMNT(MINSEG)    THROUGH    AND   INCLUDING
    C              SEGMNT(MAXSEG)  LENGTHS  OF   BAR   SEGMENTS
    C              SPECIFIED IN SAME COORDINATE SYSTEMS AS USED
    C              FOR DEFINITIONS OF XLEFT AND  XRIGHT.   ZERO
    C              VALUES IN SEGMNT ARRAY ARE IGNORED.
   C
  C     MINSEG = SUBSCRIPT OF FIRST LOCATION IN SEGMNT  ARRAY
    C              WHICH CAN SPECIFY LENGTH OF BAR SEGMENT.  IF
                                  C              MINSEG IS GREATER THAN MAXSEG, THEN  NO  BAR
    C              SEGMENTS WILL BE REPRESENTED.
    C
  C     MAXSEG = SUBSCRIPT OF FINAL LOCATION IN SEGMNT  ARRAY
    C              WHICH CAN SPECIFY LENGTH OF BAR SEGMENT.
   C
  C     LETTER = ARRAY   CONTAINING   IN   ARRAY    LOCATIONS
    C              LETTER(MINLTR)    THROUGH    AND   INCLUDING
    C              LETTER(MAXLTR)  CHARACTERS  BY   WHICH   BAR
    C              SEGMENTS   ARE   TO   BE   REPRESENTED,  ONE
    C              CHARACTER  PER  LETTER  ARRAY  LOCATION   AS
    C              THOUGH  READ  BY  MULTIPLE  OF  A1 FORMAT OR
    C              DEFINED  BY  SEVERAL  1H  FIELDS   IN   DATA
    C              STATEMENT.    SEGMENT   HAVING   ITS  LENGTH
    C              SPECIFIED   BY   SEGMNT(MINSEG)   WILL    BE
    C              REPRESENTED    BY    CHARACTER    FOUND   IN
    C              LETTER(MINLTR), THAT HAVING  ITS  LENGTH  IN
    C              SEGMNT(MINSEG+1)     BY     CHARACTER     IN
    C              LETTER(MINLTR+1),    AND    SO    ON.     IF
    C              MAXLTR-MINLTR  IS  LESS  THAN MAXSEG-MINSEG,
    C              THEN  ASSIGNMENT  OF   CHARACTERS   RECYCLES
                                                           C              THROUGH  LETTER  ARRAY  AS MANY TIMES AS ARE
    C              NECESSARY TO REPRESENT ALL OF  BAR  SEGMENTS
    C              SO  THAT SEGMENT HAVING ITS LENGTH SPECIFIED
    C              BY     SEGMNT(MINSEG+MAXLTR-MINLTR+1)     IS
    C              REPRESENTED  BY CHARACTER IN LETTER(MINLTR),
    C              THAT     HAVING      ITS      LENGTH      IN
    C              SEGMNT(MINSEG+MAXLTR-MINLTR+2)  BY CHARACTER
    C              IN LETTER(MINLTR+1), AND SO ON.
  C
  C     MINLTR = SUBSCRIPT OF  LETTER  ARRAY  LOCATION  WHICH
    C              SPECIFIES   CHARACTER   TO   BE   USED   FOR
    C              REPRESENTATION OF  BAR  SEGMENT  HAVING  ITS
    C              LENGTH IN SEGMNT(MINSEG).
   C
  C     MAXLTR = SUBSCRIPT OF  LETTER  ARRAY  LOCATION  WHICH
    C              SPECIFIES   CHARACTER   TO   BE   USED   FOR
    C              REPRESENTATION OF  BAR  SEGMENT  HAVING  ITS
    C              LENGTH IN SEGMNT(MINSEG+MAXLTR-MINLTR).
    C
  C     YVALUE = NUMBER TO BE PLACED TO LEFT OF BAR CHART  IF
    C              HUNDREDS  DIGIT  OF DECIMAL INTEGER VALUE OF
    C              IGRID HAS VALUE 1, 3 OR 5.
  C
  C     LABEL  = ARRAY   CONTAINING   IN   ARRAY    LOCATIONS
                        C              LABEL(MINLBL)    THROUGH    AND    INCLUDING
    C              LABEL(MAXLBL) CHARACTERS TO BE SHOWN TO LEFT
    C              OF  BAR  CHART  IF HUNDREDS DIGIT OF DECIMAL
    C              INTEGER VALUE OF IGRID HAS VALUE 2, 4 OR  6.
    C              CHARACTERS  IN  LABEL  ARRAY  ARE STORED ONE
    C              CHARACTER PER ARRAY LOCATION AS THOUGH  READ
    C              BY  MULTIPLE  OF  A1  FORMAT  OR  DEFINED BY
    C              SEVERAL 1H FIELDS IN DATA STATEMENT.
  C
  C     MINLBL = SUBSCRIPT OF LABEL ARRAY LOCATION CONTAINING
    C              LEFTMOST CHARACTER.
    C
                 C     MAXLBL = SUBSCRIPT OF LABEL ARRAY LOCATION CONTAINING
    C              RIGHTMOST CHARACTER.
   C
  C     LINPRT = -1, THE PLOT IS NOT  TO INCLUDE ANY CARRIAGE
    C              CONTROL CHARACTER AT LEFT END OF EACH LINE.
C            = 0, PLOT WILL BE VIEWED BY USER ON  TERMINAL,
    C              EITHER TYPED DIRECTLY WITH IDISK BEING GIVEN
    C              TERMINAL UNIT NUMBER, OR TYPED BY USER AFTER
    C              THIS  ROUTINE  HAS WRITTEN PLOT INTO FILE ON
    C              UNIT NUMBER OF WHICH IS CONTAINED IN  IDISK.
    C              BLANK  OR  SPACE  WILL  BE  USED AS CARRIAGE
                   C              CONTROL CHARACTER TO GIVE SINGLE SPACING.
  C            = 1, PLOT WILL BE PRINTED ON LINE  PRINTER  BY
    C              USER  AFTER  PROGRAM  HAS  WRITTEN PLOT INTO
    C              FILE.  ASTERISK WILL  BE  USED  AS  CARRIAGE
    C              CONTROL  CHARACTER  TO  GIVE  SINGLE SPACING
    C              WITH SUPPRESSION OF SKIPPING EXTRA LINES  AT
    C              PAGE BOUNDARIES.
  C
  C     IDISK  = UNIT NUMBER OF DEVICE ONTO WHICH  PLOTS  ARE
    C              TO BE WRITTEN.
    C
        DIMENSION SEGMNT(MAXSEG),LETTER(MAXLTR),LABEL(MAXLBL)
          COMMON/FASPE/LTRBUF(146)
                   DATA MAXBFR/146/
 C
  C     IHRZNT = CHARACTER FOR HORIZONTAL LINES
   C     ISPACE = SPACE OF BLANK CHARACTER
    C     ISTAR  = USED AS CHARIAGE CONTROL TO PREVENT EXTRA
  C              LINES AT PAGE BOUNDARIES
    C     IVRTCL = CHARACTER FOR VERTICAL LINES
C     IZERO  = ZERO USED UNDER CENTER LINE
 C     KORNER = CHARACTER WHERE HORIZONTAL AND VERTICAL
    C              LINES MEET
   C
        DATA IHRZNT,IVRTCL,KORNER,ISTAR,IZERO,ISPACE/
       11H-,1H!,1H+,1H*,1H0,1H /
   C
  C     JGRID  = UNITS DIGIT
  C     LGRID  = TENS DIGIT
   C     NGRID  = HUNDREDS DIGIT
          LGRID=IGRID/10
                   NGRID=IGRID/100
        JGRID=IGRID-(10*LGRID)
      LGRID=LGRID-(10*NGRID)
C
  C     UNPACK INDIVIDUAL SWITCHES FROM UNITS DIGIT OF IGRID
C
  C       KUNITS JUNITS IUNITS           KUNITS JUNITS IUNITS
    C     0     -1      0      0         5      0      0      1
    C     1     -1      0      1         6      1      1      0
    C     2      0      1      0         7      1      1      1
    C     3      0      1      1         8      1      0      0
    C     4      0      0      0         9      1      0      1
    C
  C     KUNITS = -1, NEITHER RIGHT NOR INTERNAL GIRD LINES
                                C            = 0, RIGHT, BUT NOT INTERNAL, GRID LINES
C            = 1, BOTH RIGHT AND INTERNAL GRID LINES
 C     JUNITS = 0, RULE GRID LINES WITH PLUS SIGNS
    C            = 1, RULE GRID LINES WITH EXCLAMATION POINTS
 C     IUNITS = 0, INSERT SPACES BETWEEN GRID LINES
   C            = 1, INSERT MINUS SIGNS BETWEEN GRID LINES
   C
        JUNITS=JGRID/2
         IUNITS=JGRID-(2*JUNITS)
          JUNITS=JUNITS-(2*(JUNITS/2))
    C
  C     ***************************************
   C     *                                     *
   C     *  CONSTRUCT CONTENTS OF LEFT MARGIN  *
                                           C     *                                     *
   C     ***************************************
   C
  C     INSERT LEFT GRID LINE AND/OR LEFT MINUS SIGN
         MAXPRT=0
          IMRGN=MARGIN
      IF(IMRGN.LT.0)IMRGN=0
       IF(IMRGN.GT.MAXBFR)IMRGN=MAXBFR
       IF(IMRGN.LE.0)GO TO 6
       JRIGHT=IMRGN
      IF(NGRID.LE.2)GO TO 1
       LTRBUF(IMRGN)=ISPACE
        JRIGHT=JRIGHT-1
        IF(NGRID.LE.4)GO TO 1
       LTRBUF(IMRGN)=IHRZNT
        MAXPRT=IMRGN
    1 IF(JRIGHT.LE.0)GO TO 6
      IF(NGRID.GT.0)GO TO 3
 C
  C     LINE NOT BEARING SCALE NUMBER
         DO 2 I=1,JRIGHT
      2 LTRBUF(I)=ISPACE
       GO TO 6
C
  C     LINE BEARING SCALE NUMBER
      3 IF(NGRID.EQ.(2*(NGRID/2)))GO TO 4
          IF(MAXPRT.LT.JRIGHT)MAXPRT=JRIGHT
          MINSIG=JRIGHT-2
        IF(MINSIG.GT.5)MINSIG=5
          IF(MINSIG.LE.0)MINSIG=1
          CALL DARITE(YVALUE,1,0,0,1,
     1-3,0,JRIGHT,-2,7,MINSIG,5,
      20,0,4,0,0,-1,0,
       3MAXBFR,LTRBUF,I,KERR)
       GO TO 6
C
  C     BAR WITH LETTERS TO ITS LEFT
        4 J=MAXLBL-JRIGHT
        IF(J.GE.MINLBL)J=MINLBL-1
        DO 5 I=1,JRIGHT
        J=J+1
        LTRBUF(I)=ISPACE
       IF(J.LT.MINLBL)GO TO 5
      IF(MAXPRT.LT.I)MAXPRT=I
                                   LTRBUF(I)=LABEL(J)
        5 CONTINUE
    C
  C     ************************************
 C     *                                  *
 C     *  REPRESENT DATA AS BAR SEGMENTS  *
 C     *                                  *
 C     ************************************
 C
  C     GET THE PLOT WIDTH AND MESH LINE WIDTH
        6 LSTSET=KNDBAR-(3*(KNDBAR/3))-1
        KNTLTR=IMRGN
      INCR=-1
      NWIDE=0
      IWIDE=MSHLFT
      IF(IWIDE.LE.0)IWIDE=10
      LWIDE=LNGLFT
      IF(LWIDE.LT.0)LWIDE=0
       IF(LWIDE.GT.(MAXBFR-KNTLTR))LWIDE=MAXBFR-KNTLTR
      JWIDE=IWIDE
       MWIDE=LWIDE
                           IF(LWIDE.LE.0)GO TO 32
      ARIGHT=XLEFT
      KNTLTR=KNTLTR+LWIDE+1
       GO TO 8
    7 INCR=1
       IWIDE=MSHRIT
      IF(IWIDE.LE.0)IWIDE=10
      LWIDE=LNGRIT
      IF(LWIDE.LT.0)LWIDE=0
       IF(LWIDE.GT.(MAXBFR-KNTLTR))LWIDE=MAXBFR-KNTLTR
      IF(LWIDE.LE.0)GO TO 33
      ARIGHT=XRIGHT
    C
  C     INITIAL VALUES
       8 WIDE=LWIDE
        SCALE=WIDE/ARIGHT
      TOTAL=0.0
         COMPAR=0.0
        BIGEST=0.0
        KNTCLM=0
          IBEGIN=0
          NOWSEG=MINSEG
          IF(KNDBAR.LT.0)GO TO 9
      IF(LSTLIN.GE.0)GO TO 10
        9 NOWSEG=MAXSEG+1
     10 IF(JGRID.GT.5)GO TO 12
      IF(JGRID.GT.1)GO TO 11
      MRGLTR=LWIDE+1
         GO TO 13
       11 MRGLTR=IWIDE*(LWIDE/IWIDE)
       GO TO 13
       12 MRGLTR=0
    C
  C     LOOP THROUGH ALL SEGMENTS IN THE BAR
    13 NOWLTR=MINLTR
       14 LSTONE=1
          IF(NOWSEG.GT.MAXSEG)GO TO 24
          ADDING=SCALE*SEGMNT(NOWSEG)
      IF(ADDING.LE.0.0)GO TO 23
        FORMER=TOTAL
      TOTAL=TOTAL+ADDING
    C
  C     TEST IF PRESENT BAR IS DOMINANT AT ITS LEFT END
      FRACTN=TOTAL
      IF(FRACTN.GT.COMPAR)FRACTN=COMPAR
          FRACTN=FRACTN-FORMER
        IF(IBEGIN.EQ.0)GO TO 17
          IF(KNDBAR.LE.5)GO TO 15
                    IF(TOTAL.GT.COMPAR)GO TO 18
      GO TO 16
       15 IF(FRACTN.LE.BIGEST)GO TO 17
       16 I=KNTLTR-INCR
          IF(IREPLC.NE.0)LTRBUF(I)=LETTER(JREPLC)
         IREPLC=0
          GO TO 20
    C
  C     INSERT LETTERS ALONG BAR
      17 IF(TOTAL.LE.COMPAR)GO TO 22
   18 FORMER=COMPAR
          COMPAR=COMPAR+1.0
      IF(IBEGIN.GE.LWIDE)GO TO 32
      IF(LSTONE.LE.0)GO TO 21
          IREPLC=0
       19 KNTLTR=KNTLTR+INCR
          IBEGIN=IBEGIN+1
        IF(MAXPRT.LT.KNTLTR)MAXPRT=KNTLTR
          IF(KNTCLM.LE.0)KNTCLM=IWIDE
      KNTCLM=KNTCLM-1
        BIGEST=0.0
                                        20 LTRBUF(KNTLTR)=LETTER(NOWLTR)
         LSTONE=LSTSET
          JREPLC=NOWLTR
          GO TO 17
       21 IREPLC=1
          IF(LSTONE.EQ.0)GO TO 27
          LTRBUF(KNTLTR)=ISPACE
       GO TO 19
    C
  C     ALL DONE WITH THIS SEGMENT OF THE BAR
   22 FRACTN=TOTAL-FORMER
         IF(BIGEST.LT.FRACTN)BIGEST=FRACTN
       23 NOWSEG=NOWSEG+1
        NOWLTR=NOWLTR+1
        IF(NOWLTR.LE.MAXLTR)GO TO 14
          GO TO 13
    C
  C     TEST IF FINAL CHARACTER IS TO BE ALLOWED
     24 IF(KNDBAR.LE.2)GO TO 26
          IF(KNDBAR.GT.5)GO TO 26
          IF(IBEGIN.EQ.0)GO TO 26
                                        IF(BIGEST.GE.(COMPAR-TOTAL))GO TO 26
       I=KNTLTR-INCR
          IF(IREPLC.NE.0)LTRBUF(I)=LETTER(JREPLC)
         GO TO 27
    C
  C     ******************************************
C     *                                        *
C     *  CONSTRUCT GRID LINES TO RIGHT OF BAR  *
C     *                                        *
C     ******************************************
C
     25 IF(LSTONE.EQ.0)GO TO 19
       26 IF(KNTCLM.LE.0)KNTCLM=IWIDE
      KNTCLM=KNTCLM-1
        IF(IBEGIN.GE.LWIDE)GO TO 32
      KNTLTR=KNTLTR+INCR
          IBEGIN=IBEGIN+1
     27 IF(KNTCLM.GT.0)GO TO 29
                              IF(IBEGIN.LT.MRGLTR)GO TO 29
          IF(JUNITS.EQ.0)GO TO 28
          LTRBUF(KNTLTR)=IVRTCL
       GO TO 30
       28 LTRBUF(KNTLTR)=KORNER
       GO TO 30
       29 IF(IUNITS.EQ.0)GO TO 31
          LTRBUF(KNTLTR)=IHRZNT
    30 IF(MAXPRT.LT.KNTLTR)MAXPRT=KNTLTR
          GO TO 25
       31 LTRBUF(KNTLTR)=ISPACE
       GO TO 25
    C
  C     REVERSE DIRECTION FOR SECOND HALF
       32 IF(INCR.GT.0)GO TO 33
       KNTLTR=IMRGN+LWIDE
          IF(KNTLTR.GE.MAXBFR)GO TO 7
      IF(LGRID.LE.0)GO TO 7
       KNTLTR=KNTLTR+1
        NWIDE=1
      LTRBUF(KNTLTR)=ISPACE
       I=LGRID
      IF(I.GT.4)I=I-4
        IF(I.LE.1)GO TO 7
      MAXPRT=KNTLTR
          IF(I.EQ.2)LTRBUF(KNTLTR)=IHRZNT
       IF(I.EQ.3)LTRBUF(KNTLTR)=IVRTCL
       IF(I.GE.4)LTRBUF(KNTLTR)=KORNER
       GO TO 7
C
  C     OUTPUT THE COMPLETED BAR
      33 KONTRL=ISPACE
          IF(LINPRT.GT.0)KONTRL=ISTAR
      IF(LSTLIN.LT.0)GO TO 37
          IF(LINPRT.GE.0)GO TO 34
          IF(MAXPRT.LE.0)WRITE(IDISK,35)ISPACE
       IF(MAXPRT.GT.0)WRITE(IDISK,35)(LTRBUF(I),I=1,MAXPRT)
      GO TO 36
       34 IF(MAXPRT.LE.0)WRITE(IDISK,35)KONTRL,ISPACE
          IF(MAXPRT.GT.0)WRITE(IDISK,35)KONTRL,
     1(LTRBUF(I),I=1,MAXPRT)
   35 FORMAT(147A1)
    C
  C     *****************************************************
    C     *                                                   *
    C     *  CONSTRUCT AND PRINT NUMBERS FORMING LOWER SCALE  *
    C     *                                                   *
    C     *****************************************************
    C
  C     CONSTRUCT LINE CONTAINING TICK MARKS
    36 IF(LSTLIN.GT.0)GO TO 57
       37 IFINAL=IMRGN+MWIDE+LWIDE+NWIDE
        IF(IFINAL.LE.IMRGN)GO TO 57
      DO 38 I=1,IFINAL
    38 LTRBUF(I)=ISPACE
       KNTLTR=IMRGN+MWIDE+1
        IF(NWIDE.EQ.0)GO TO 40
      IF(LGRID.LE.4)GO TO 40
                  39 LTRBUF(KNTLTR)=IVRTCL
    40 KNTLTR=KNTLTR-JWIDE
         IF(KNTLTR.GT.IMRGN)GO TO 39
      KNTLTR=IMRGN+MWIDE+NWIDE
      41 KNTLTR=KNTLTR+IWIDE
         IF(KNTLTR.GT.IFINAL)GO TO 42
          LTRBUF(KNTLTR)=IVRTCL
       GO TO 41
       42 IF(LINPRT.LT.0)WRITE(IDISK,35)(LTRBUF(I),I=1,IFINAL)
      IF(LINPRT.GE.0)WRITE(IDISK,35)KONTRL,
     1(LTRBUF(I),I=1,IFINAL)
C
  C     CONSTRUCT LINE CONTAINING LOWER SCALE NUMBERS
        LERR=-1
      MAXPRT=0
          IF(NWIDE.EQ.0)GO TO 43
      IF(LGRID.LE.4)GO TO 43
      MAXPRT=IMRGN+MWIDE+1
        LTRBUF(MAXPRT)=IZERO
     43 KIND=LERR
         INCR=-1
           IWIDTH=JWIDE
      KNTLTR=1
          WIDE=MWIDE
        GO TO 45
       44 INCR=1
       IWIDTH=IWIDE
      KNTLTR=NWIDE
      WIDE=LWIDE
     45 KNTLTR=KNTLTR+IWIDTH+IMRGN+MWIDE-1
         IF(IWIDTH.GT.10)IWIDTH=10
        JWIDTH=IWIDTH/2
        KNTLTR=KNTLTR-JWIDTH
        MINSIG=IWIDTH-2
        IF(MINSIG.GT.5)MINSIG=5
          IF(MINSIG.LE.0)MINSIG=1
          I=0
          NEED=KNTLTR
       GO TO 48
       46 IF(KNTLTR.LT.0)KNTLTR=0
          CALL DARITE(VALUE,0,0,KIND,1,
        1-3,0,IWIDTH,-2,-2,MINSIG,5,
     20,0,4,0,0,-1,KNTLTR,
       3MAXBFR,LTRBUF,KNTOUT,KERR)
                                IF(KERR.GT.0)LERR=1
         KNTLTR=KNTOUT
          IF(KIND.LE.0)GO TO 47
       IF(KERR.EQ.0)GO TO 48
    47 IF(MAXPRT.LT.KNTLTR)MAXPRT=KNTLTR
       48 IF(INCR.GT.0)GO TO 51
       I=I+JWIDE
      49 IF(NEED.LE.KNTLTR)GO TO 50
       KNTLTR=KNTLTR+1
        LTRBUF(KNTLTR)=ISPACE
       GO TO 49
       50 IF(I.GT.MWIDE)GO TO 44
      VALUE=XLEFT*FLOAT(I)/WIDE
        KNTLTR=KNTLTR-JWIDE-JWIDE
        NEED=KNTLTR+JWIDE
      GO TO 46
       51 I=I+IWIDE
         IF(I.GT.LWIDE)GO TO 54
      VALUE=XRIGHT*(FLOAT(I)/WIDE)
       52 IF(NEED.LE.KNTLTR)GO TO 53
       KNTLTR=KNTLTR+1
                                 LTRBUF(KNTLTR)=ISPACE
       GO TO 52
       53 NEED=KNTLTR+IWIDE
      GO TO 46
       54 IF(MAXPRT.LE.0)GO TO 55
          IF(LINPRT.LT.0)WRITE(IDISK,35)(LTRBUF(I),I=1,MAXPRT)
      IF(LINPRT.GE.0)WRITE(IDISK,35)KONTRL,
     1(LTRBUF(I),I=1,MAXPRT)
      MAXPRT=0
       55 IF(NWIDE.EQ.0)GO TO 56
      I=IMRGN+MWIDE+1
        LTRBUF(I)=ISPACE
    56 IF(KIND.NE.LERR)GO TO 43
   C
  C     ALL DONE WITH THIS LINE OF THE PLOT
     57 RETURN
 C922171101196!
          END
    
