	program	monrpt
	implicit integer (a-v)
	parameter n=18
c
c system performance data reporter
c
	common /prfdat/
	1	daytim,sysmem,job,
	2	uptime,user,over,null,lost,idle,
	3	resp,nresp,vhresp,vlresp,usrmem,vrtmem
c
	double precision xdate,fname
c
	dimension new(n),old(n)
c
	equivalence (new(1),daytim)
c mtime = incremental sleeptime (1 minute in universal date-time format)
	data mtime/"266026/,dtime/"1000/
c xsrcnv = conversion for "double precision" response calculation (2.0**35)
	data xsrcnv/"244400000000/
	data stime/"266026/,xtic/60./,pwds/512/
c
	data dday/"1000000/
	data fname/'MONRPT.RPT'/
c ****** execution ******
c initialize
	opnflg=0
	open(unit=1,device='MONRPT',file=fname,
	1	access='APPEND',carriagecontrol='LIST',err=25)
	go to 30
25	opnflg=-1
	open(unit=1,device='tty',carriagecontrol='LIST')
30	continue
	xtime=xtic*float(mtime)/float(stime)
	xstime=0.80*xtime
	call prf
	timest=daytim
	time0=daytim
	call date(xdate)
	call itime(daytim,dth,dtm,dts)
	dtm1=dtm/10
	dtm2=dtm-(dtm1*10)
	dts1=dts/10
	dts2=dts-(dts1*10)
	write(1,1)
1	format('Monitor Statistics Report')
	write(1,3) xdate,dth,dtm1,dtm2,dts1,dts2,xtime
3	format('Date: 'a9'  Time: 'i2':'2i1':'2i1,
	2	'  Sampling interval: 'f6.2' seconds'/,
	3	' daytime  runtime intrvl',
	4	'  mem user virt job',
	5	' usr ovr nul idl lst',
	6	' resp  mean   var')
	if(opnflg.eq.0) close(unit=1)
	count=0
100	continue
c save old data
	do 150 i=1,n
150	old(i)=new(i)
c wake up at specified time
160	continue
	count=count+1
	slptim=(count*mtime)/dtime
	newtim=time0+slptim
	call wakeup(newtim)
c get next set of data
	call prf
	diftim=uptime-old(4)
	xtime=float(diftim)/xtic
c if this cycle has too small an interval (due to a previous long cycle),
c forget it, reset starting timer and try again
170	continue
	if(xtime.ge.xstime) go to 180
	time0=daytim
	count=0
	go to 160
180	continue
c process the data
	call itime(daytim,dth,dtm,dts)
	dtm1=dtm/10
	dtm2=dtm-(dtm1*10)
	dts1=dts/10
	dts2=dts-(dts1*10)
	days=(daytim-timest)/dday
	call itime(daytim-timest,rth,rtm,rts)
	rth=rth+days*24
	rtm1=rtm/10
	rtm2=rtm-(rtm1*10)
	rts1=rts/10
	rts2=rts-(rts1*10)
	syspag=sysmem/pwds
	usrpag=usrmem/pwds
	vrtpag=vrtmem/pwds
	round=diftim/2
	pcuser=(round+(user-old(5))*100)/diftim
	pcover=(round+(over-old(6))*100)/diftim
	pcnull=(round+(null-old(7))*100)/diftim
	pclost=(round+(lost-old(8))*100)/diftim
	pcidle=(round+(idle-old(9))*100)/diftim
	xmr=0
	xvr=0
	nr=nresp-old(11)
	if(nr.eq.0) go to 200
	tr=resp-old(10)
	shr=vhresp-old(12)
	slr=vlresp-old(13)
	xnr=float(nr)
	xtr=float(tr)
	xsr=float(slr)+float(shr)*xsrcnv
	xcr=xnr*xtic
	xmr=xtr/xcr
	xvr=sqrt(xsr*xnr-xtr**2)/xcr
200	continue
c output the report
	if(opnflg.eq.0) open(unit=1,device='MONRPT',file=fname,
	1	access='APPEND',carriagecontrol='LIST')
	write(1,11) dth,dtm1,dtm2,dts1,dts2,
	1	rth,rtm1,rtm2,rts1,rts2,xtime,
	2	syspag,usrpag,vrtpag,job,
	3	pcuser,pcover,pcnull,pcidle,pclost,
	4	nr,xmr,xvr
11	format(i2':'2i1':'2i1,
	1	i3':'2i1':'2i1,f7.2,
	2	3(1xi4),1xi3,
	3	5(1xi3),
	4	1xi4,1xf5.1,1xf5.1)
	if(opnflg.eq.0) close(unit=1)
	go to 100
	end
	subroutine itime(in,h,m,s)
	implicit integer (a-z)
	data mult/"400000/,mask/"777777/
	data hdiv/"12525252525/,mdiv/"133013301/,sdiv/"1410652/
	i=((in+1).and.mask)*mult
	h=i/hdiv
	i=i-(h*hdiv)
	m=i/mdiv
	i=i-(m*mdiv)
	s=i/sdiv
	end
  
