
FUNCTION DECOMPOSE ( VAR MATRIX		: REAL_MATRIX;
		     VAR PVT_VECTOR	: INT_VECTOR;
		     N			: INTEGER	) : BOOLEAN;

{ BASED ON SUBROUTINE DECOMP BY CLEVE B. MOLER,DEPT. OF MATHEMATICS,
  THE UNIVERSITY OF MICHIGAN,ANN ARBOR,MI 48104.

  REFERENCES : 1 : ALGORITHM 423 OF COLLECTED ALG. OF CACM.
	       2 : MOLER,C.B. Matrix Computations with Fortran and paging.
                   Comm.ACM 15 (Apr.1972),268-270.
               3 : FORSYTHE,G.E.;MALCOLM,M.A.;and MOLER,C.B. Computer 
		   Methods for Mathematical Computations.
			Prentice-Hall,Inc. Englewood Cliffs,N.J.
					1977

  TRANSLATED TO PASCAL/Z BY G.M.ACLAND,UNIV. OF PENNSYLVANIA.               }

VAR	INDEX1,INDEX2,INDEX3,PIVOT,FIRST	: INTEGER;
	BIGGEST,TEMP				: REAL;

BEGIN
 DECOMPOSE := SUCCESSFUL;
 FOR INDEX1 := 1 TO (N-1) DO BEGIN
  BIGGEST := 0.0;
  FOR INDEX2 := INDEX1 TO N DO BEGIN
   IF (ABS(MATRIX[INDEX2,INDEX1]) > BIGGEST) THEN BEGIN
    PIVOT   := INDEX2;
    BIGGEST := ABS(MATRIX[INDEX2,INDEX1]);
    END; { OF : IF (ABS(MATRIX[.... }
   END; { OF : INDEX2 LOOP }
   IF BIGGEST = 0.0 THEN DECOMPOSE := NOT SUCCESSFUL
    ELSE BEGIN
    PVT_VECTOR[INDEX1]  := PIVOT;
    TEMP		:= MATRIX[PIVOT,INDEX1];
    IF PIVOT <> INDEX1 THEN BEGIN
     MATRIX[PIVOT,INDEX1]  := MATRIX[INDEX1,INDEX1];
     MATRIX[INDEX1,INDEX1] := TEMP;
     TEMP		   := 1.0/TEMP;
     END; { OF : IF PIVOT <> ...   }
    FIRST := INDEX1 + 1;
    FOR INDEX2 := FIRST TO N DO BEGIN
     MATRIX[INDEX2,INDEX1] := -1.0 * MATRIX[INDEX2,INDEX1] * TEMP;
     END; { OF INDEX2 LOOP }
    FOR INDEX2 := FIRST TO N DO BEGIN
     TEMP := MATRIX[PIVOT,INDEX2];
     IF (PIVOT <> INDEX1) THEN BEGIN
      MATRIX[PIVOT,INDEX2]  := MATRIX[INDEX1,INDEX2];
      MATRIX[INDEX1,INDEX2] := TEMP;
      END; { OF : IF PIVOT... }
     IF (TEMP <> 0) THEN BEGIN
      FOR INDEX3 := FIRST TO N DO BEGIN
       MATRIX[INDEX3,INDEX2] := MATRIX[INDEX3,INDEX2] + 
				(MATRIX[INDEX3,INDEX1] * TEMP);
       END; { OF : FOR INDEX3 LOOP }
      END; { OF : IF TEMP <> 0 ... }
     END; { OF : INDEX2 LOOP }
    END; { OF : IF BIGGEST..ELSE.. }
   IF MATRIX[N,N] = 0 THEN DECOMPOSE := NOT SUCCESSFUL;
  END; { OF : INDEX1 LOOP }
END; { OF : FUNCTION DECOMPOSE }

