/* vtgraph.c
 *
 * 2 December, 1989 - Initial draft by Gregory Reid <gar@catt.ncsu.edu>
 * 28 Nov to 5 - updates by doctorgonzo to optimise for use with gifview2.2.
 * Dec 1991      removed line code, moved code about, inserted buffer flush,
 *               trapped terminal programming section, etc.
 */

#include <stdio.h>
#include <signal.h>
#include "vtgraph.h"

/* set terminal up for soft-font programming.  */

void setup_vt (out)
FILE *out; {
#ifdef TEST
    return;
#else
    /* echo vt320 standard init string. */
    fprintf (out,"\033<\033[63;1\"p\033[!p\033[?3l");
    fprintf(out,"\033[?5l\033[?7h\033[?8h");
    fprintf(out,"\033[?4l\033[?68l\033[2$~\n");
    /* echo kludge to work around terminal trouble */
    fprintf (out,"\033P1;1;0;12;1;1;12;0{ @");
    fprintf (out,"\033\\\033) @\033(B\017\n");
#endif
}

/* Clear out full bitmap image. */

void clear_image () {
    int row, col, group, slice;

    for (row = 0; row < scrheight; row++) {
	for (col = 0; col < scrwidth; col++) {
	    for (group = 0; group < groups; group++) {
		for (slice = 0; slice < charwidth; slice++) {
		    display [col][row][group][slice] = 0;
		}
	    }
	}
    }
}

/* Define and draw bitmap. */

void show_image (outF, charsX, charsY, currchar)
FILE *outF;
int charsX, charsY;
unsigned char currchar; {
    int row, col, group, slice, ypos, xpos, i;

#ifndef TEST
    /* Define full cell 96 character font */
    signal(SIGINT,SIG_IGN); /* trap until later */
    signal(SIGTSTP,SIG_IGN);
    fprintf (outF,"\033P1;0;0;15;1;2;12;1{ @\n");
    for (i=0;i<currchar;i++) {
	row=dispindy[i];
	col=dispindx[i];
	for (group=0; group < groups; group++) {
	    for (slice=0; slice < charwidth; slice++) {
		putc((display[col][row][group][slice] & 0x3f)+0x3f,outF);
	    }
	    if (!group) putc('/',outF);
	}
	fprintf (outF,";\n");
	fflush(outF); /* buffering troubles */
    }
    signal(SIGINT,SIG_DFL);
    signal(SIGTSTP,SIG_DFL); /* remove signal traps */
    fprintf (outF,"\033\\"); /* Set Definition Terminator */
    fprintf (outF,"\033) @"); /* Assign soft character set as G1 */
    fprintf (outF,"\033[1m"); /* Do boldface */
    fprintf (outF,"\016\n"); /* GL = G1 */

    /* Draw characters in softset font */
    for (ypos = 0; ypos < charsY; ypos++) {
	fprintf (outF,"\033[%d;%df", 2+ypos, (scrwidth - charsX) / 2);
	for (xpos = 0; xpos < charsX; xpos++)
	    putc(' '+scrmap[xpos][ypos],outF);
	putc('\n',outF);
    }
    fprintf (outF,"\017"); /* GL = G0 */
    fprintf (outF,"\033[0m\n");
#else
    for (ypos = 0; ypos < charsY; ypos ++) {
	for (xpos = 0; xpos < charsX; xpos ++) { 
	    if (scrmap[xpos][ypos])
		putc('@',outF);
	    else
		putc(':',outF);
	}
	putc('\n',outF);
    }
#endif
}

/* Plot a single point into the graphics window at (xpos, ypos). */

void plot (xpos,ypos)
int xpos, ypos; {
    static int row, col, group, slice, sixel;
    static char pmask [charheight / groups] = { 1, 2, 4, 8, 16, 32 };

    if ( (xpos < 0) || (ypos < 0) || (xpos > scrwidth * charwidth)
	|| (ypos > scrheight * charheight) )
	return;

    col   = xpos / charwidth;
    row   = ypos / charheight;
    group = (ypos - row * charheight) / (charheight / groups);
    slice = xpos - col * charwidth;
    sixel = ypos - (row * charheight + group * (charheight / groups) );

    display [col] [row] [group] [slice] |= (pmask [sixel]);
}
