#

/*
 * Editor
 * Copyright 1974, Bell Telephone Laboratories, Incorporated
 */

#define RTED	1
/*
 * Changes required to implement the "rted" RT-11 editing feature
 * are marked by the above symbol.
 *
 * If the rt11 flag is set, carriage returns are appended to the
 * end of every line on a write, and all cr's are removed on
 * a read.  If the flag is set and the dual case flag is set,
 * then all append mode keyboard input is translated to upper
 * case, as well as replacement characters in a substitute.
 *
 * If the first character of the of the name under which the editor
 * is invoked is 'r', then the rt11 and dual-case flags are set.
 * This allows "rted" to be linked to "ed".
 * M. Tilson, October 1978
 */

#define	SIGHUP	1
#define	SIGINTR	2
#define	SIGQUIT	3
#define	FNSIZE	64
#define	LBSIZE	512
#define	ESIZE	128
#define	GBSIZE	256
#define	NBRA	5
#define	EOF	-1

#define	CBRA	1
#define	CCHR	2
#define	CDOT	4
#define	CCL	6
#define	NCCL	8
#define	CDOL	10
#define	CEOF	11
#define	CKET	12
#define CBOI	14
#define CEOI	16

#define	STAR	01

#define	READ	0
#define	WRITE	1

int	peekc;
int	lastc;
int	penult;
char	line[70];
char	*linp	line;
char	savedfile[FNSIZE];
char	file[FNSIZE];
char	linebuf[LBSIZE];
char	rhsbuf[LBSIZE/2];
char	expbuf[ESIZE+4];
int	circfl;
int	*zero;
int	*dot;
int	*dol;
int	*endcore;
int	*fendcore;
int	*addr1;
int	*addr2;
char	genbuf[LBSIZE];
int	count[2];
char	*nextip;
char	*linebp;
int	ninbuf;
int	io;
int	pflag;
int	onhup;
int	onquit;
int	vflag	1;
int	prflag	0;
int	dflag	0;
int	rt11flag 0;
int	pagesize 20;
int	listf;
int	col;
char	*globp;
int	tfile	-1;
int	tline;
char	*tfname;
char	*loc1;
char	*loc2;
char	*locs;
char	ibuff[512];
int	iblock	-1;
char	obuff[512];
int	oblock	-1;
int	ichanged;
int	nleft;
char	TMPERR[] "TMP";
char	backup[] ":sav";	/* appended to saved file name - rcp mar/77 */
char	prompt '*';
int	names[26];
char	*braslist[NBRA];
char	*braelist[NBRA];

int *min(a, b)
int *a, *b;
{
	return(a<b?a:b);
}

rescue(){
	/* write file in savedfile:sav on hangup */
	/* rcp mar/77 */
	register char *p1, *p2;
	signal(SIGHUP,1);
	if(dol!=zero){
		addr1=zero+1;
		addr2=dol;
		p1=savedfile;
		while(*p1)
			p1++;
		p2=backup;
		do;while(*p1++= *p2++);
		if((io=creat(savedfile,0644))>=0)
			putfile();
	}
	exit();
}
/* end rcp mar/77 */

main(argc, argv)
char **argv;
{
	register char *p1, *p2;
	extern int onintr();

	onquit = signal(SIGQUIT, 1);
	onhup = signal(SIGHUP, rescue);	/* rcp mar/77 */
#ifdef RTED
	if(argc>0 && argv[0][0]=='r') {
		dflag = 1;
		rt11flag = 1;
	}
#endif
	argv++;
	if (argc > 1 && **argv=='-') {
		prflag = 0;
		vflag = 0;
		/* allow debugging quits? */
		if ((*argv)[1]=='q') {
			signal(SIGQUIT, 0);
			vflag++;
		}
		argv++;
		argc--;
	}
	if (argc>1) {
		p1 = *argv;
		p2 = savedfile;
		while (*p2++ = *p1++);
		globp = "r";
	}
	fendcore = sbrk(0);
	init();
	if ((signal(SIGINTR, 1) & 01) == 0)
		signal(SIGINTR, onintr);
	setexit();
	commands();
	unlink(tfname);
}

commands()
{
	int getfile(), gettty();
	register *a1, c;
	register char *p;
	int r;

	for (;;) {
	if (pflag) {
		pflag = 0;
		addr1 = addr2 = dot;
		goto print;
	}
	if(prflag && !globp)
		write(1, &prompt, 1);
	addr1 = 0;
	addr2 = 0;
	/* Eat leading blanks here, to make kludge for '*' and '&' work.
	 * In "standard" version, this is not necessary since "address"
	 * will eat them.
	 * mdt mod Feb/77
	 */
	while((c=getchar())==' ' || c=='\t')
		;
	peekc = c;
	/* kludge: */
	switch(c){
	case '*':
		a1=zero+1;
		break;
	case '&':
		a1=dot;
		break;
	default:
		a1=address(0);
	}
	for(;;){
		switch(c=getchar()){
		case ';':
			dot = a1;
		case ',':
			addr1=a1;
			a1=address(0);
			continue;
		case '&':
			dot=addr1=a1;
			a1=address(min(a1+pagesize, dol));
			continue;
		case '*':
			dot=addr1=a1;
			a1=address(dol);
			continue;
		}
		break;
	}
	addr2 = a1;
	if (addr1==0)
		addr1 = addr2;
	switch(c) {

	case 'a':
		setdot();
		newline();
		append(gettty, addr2);
		continue;

	case 'c':
		delete();
		append(gettty, addr1-1);
		continue;

	case 'd':
		delete();
		continue;

	case 'e':
		setnoaddr();
		if ((peekc = getchar()) != ' ')
			error('f');
		savedfile[0] = 0;
		init();
		addr2 = zero;
		goto caseread;

	case 'f':
		setnoaddr();
		if ((c = getchar()) != '\n') {
			peekc = c;
			savedfile[0] = 0;
			filename();
		}
		puts(savedfile);
		continue;

	case 'g':
		global(1);
		continue;

	case 'i':
		setdot();
		nonzero();
		newline();
		append(gettty, addr2-1);
		continue;

	case 'k':
		if ((c = getchar()) < 'a' || c > 'z')
			error('k');
		newline();
		setdot();
		nonzero();
		names[c-'a'] = *addr2 | 01;
		continue;

	case 'm':
		move(0);
		continue;

	case 'o':
		switch(c=getchar()){
#ifdef RTED
		case 'r':
			rt11flag=setreset();
			break;
#endif
		case 'p':
			prflag=setreset();
			break;
		case 'd':
			dflag=setreset();
			break;
		case 'v':
			vflag=setreset();
			break;
		case '&':
			r=0;
			while((c=getchar())>='0' && c<='9')
				r = r*10 +c-'0';
			peekc=c;
			newline();
			pagesize = r!=0?r:18;
			break;
		default:
			error('x');
		}
		continue;

	case '\n':
		if (addr2==0)
			addr2 = dot+1;
		if(penult!='&')
			addr1 = addr2;
		goto print;

	case 'l':
		listf++;
	case 'p':
		newline();
	print:
		setdot();
		nonzero();
		a1 = addr1;
		do
			puts(getline(*a1++));
		while (a1 <= addr2);
		dot = addr2;
		listf = 0;
		continue;

	case 'q':
		setnoaddr();
		newline();
		unlink(tfname);
		exit();

	case 'r':
	caseread:
		filename();
		if ((io = open(file, 0)) < 0) {
			lastc = '\n';
			error('o');
		}
		setall();
		ninbuf = 0;
		append(getfile, addr2);
		exfile();
		continue;

	case 's':
		setdot();
		nonzero();
		substitute(globp);
		continue;

	case 't':
		move(1);
		continue;

	case 'v':
		global(0);
		continue;

	case 'w':
		setall();
		nonzero();
		filename();
		if ((io = creat(file, 0644)) < 0)
			error('o');
		putfile();
		exfile();
		continue;

	case '=':
		setall();
		newline();
		count[1] = (addr2-zero)&077777;
		putd();
		putchar('\n');
		continue;

	case '!':
		unix();
		continue;

	case EOF:
		return;

	}
	error('x');
	}
}

skip(n){
	while(n--)
		while(getchar()!='\n');
}

setreset(){
	register char c;
	if((c=getchar())!='s' && c!= 'r')
		error('x');
	newline();
	return(c=='s');
}

address(aa1)
{
	register *a1, minus, c;
	int n, relerr;

	minus = 0;
	a1 = aa1;
	for (;;) {
		c = getchar();
		if ('0'<=c && c<='9') {
			n = 0;
			do {
				n =* 10;
				n =+ c - '0';
			} while ((c = getchar())>='0' && c<='9');
			peekc = c;
			if (a1==0)
				a1 = zero;
			if (minus<0)
				n = -n;
			a1 =+ n;
			minus = 0;
			continue;
		}
		relerr = 0;
		if (a1 || minus)
			relerr++;
		switch(c) {
		case ' ':
		case '\t':
			continue;
	
		case '+':
			minus++;
			if (a1==0)
				a1 = dot;
			continue;

		case '-':
		case '^':
			minus--;
			if (a1==0)
				a1 = dot;
			if((c=getchar())=='&'){
				a1 =- pagesize;
				if(a1<=zero)
					a1=zero+1;
				minus = 0;
			}
			else
				peekc = c;
			continue;
	
		case '?':
		case '/':
			compile(c);
			a1 = dot;
			for (;;) {
				if (c=='/') {
					a1++;
					if (a1 > dol)
						a1 = zero;
				} else {
					a1--;
					if (a1 < zero)
						a1 = dol;
				}
				if (execute(0, a1))
					break;
				if (a1==dot)
					error('/');
			}
			break;
	
		case '$':
			a1 = dol;
			break;
	
		case '.':
			a1 = dot;
			break;

		case '\'':
			if ((c = getchar()) < 'a' || c > 'z')
				error('$');
			for (a1=zero; a1<=dol; a1++)
				if (names[c-'a'] == (*a1|01))
					break;
			break;
	
		default:
			peekc = c;
			if (a1==0)
				return(0);
			a1 =+ minus;
			if (a1<zero || a1>dol)
				error('$');
			return(a1);
		}
		if (relerr)
			error('a');
	}
}

setdot()
{
	if (addr2 == 0)
		addr1 = addr2 = dot;
	if (addr1 > addr2)
		error('$');
}

setall()
{
	if (addr2==0) {
		addr1 = zero+1;
		addr2 = dol;
		if (dol==zero)
			addr1 = zero;
	}
	setdot();
}

setnoaddr()
{
	if (addr2)
		error('$');
}

nonzero()
{
	if (addr1<=zero || addr2>dol)
		error('$');
}

newline()
{
	register c;

	if ((c = getchar()) == '\n')
		return;
	if (c=='p' || c=='l') {
		pflag++;
		if (c=='l')
			listf++;
		if (getchar() == '\n')
			return;
	}
	error('x');
}

filename()
{
	register char *p1, *p2;
	register c;

	count[1] = 0;
	c = getchar();
	if (c=='\n' || c==EOF) {
		p1 = savedfile;
		if (*p1==0)
			error('f');
		p2 = file;
		while (*p2++ = *p1++);
		return;
	}
	if (c!=' ')
		error('f');
	while ((c = getchar()) == ' ');
	if (c=='\n')
		error('f');
	p1 = file;
	do {
		*p1++ = c;
	} while ((c = getchar()) != '\n');
	*p1++ = 0;
	if (savedfile[0]==0) {
		p1 = savedfile;
		p2 = file;
		while (*p1++ = *p2++);
	}
}

exfile()
{
	close(io);
	io = -1;
	if (vflag) {
		putd();
		putchar('\n');
	}
}

onintr()
{
	signal(SIGINTR, onintr);
	putchar('\n');
	lastc = '\n';
	error('?');
}

error(code)
{
	register c;

	listf = 0;
	putchar('?');
	putchar(code);
	putchar('\n');
	count[0] = 0;
	pflag = 0;
	peekc = lastc;
	while ((c = getchar()) != '\n' && c != EOF);
	globp = 0;
	seek(0, 0, 2);
	if (io > 0) {
		close(io);
		io = -1;
	}
	reset();
}

getchar()
{
	if (peekc) {
		lastc=peekc;
		peekc = 0;
		return(lastc);
	}
	penult=lastc;
	lastc=peekc;
	if (globp) {
		if ((lastc = *globp++) != 0)
			return(lastc);
		globp = 0;
		return(EOF);
	}
	if (read(0, &lastc, 1) <= 0)
		return(lastc = EOF);
	lastc =& 0177;
	return(lastc);
}

gettty()
{
	register c, gf;
	register char *p;

	p = linebuf;
	gf = globp;
	while ((c = getchar()) != '\n') {
		if (c==EOF) {
			if (gf)
				peekc = c;
			return(c);
		}
		if ((c =& 0177) == 0)
			continue;
#ifdef RTED
		if(rt11flag && dflag && c>='a' && c<='z')
			c =+ 'A'-'a';
#endif
		*p++ = c;
		if (p >= &linebuf[LBSIZE-2])
			error('l');
	}
	*p++ = 0;
	if (linebuf[0]=='.' && linebuf[1]==0)
		return(EOF);
	return(0);
}

getfile()
{
	register c;
	register char *lp, *fp;

	lp = linebuf;
	fp = nextip;
	do {
		if (--ninbuf < 0) {
			if ((ninbuf = read(io, genbuf, LBSIZE)-1) < 0)
				return(EOF);
			fp = genbuf;
		}
		if (lp >= &linebuf[LBSIZE])
			error('l');
		if ((*lp++ = c = *fp++ & 0177) == 0) {
			lp--;
			continue;
		}
#ifdef RTED
		if(c=='\r' && rt11flag) {
			lp--;
			continue;
		}
#endif
		if (++count[1] == 0)
			++count[0];
	} while (c != '\n');
	*--lp = 0;
	nextip = fp;
	return(0);
}

putfile()
{
	int *a1;
	register char *fp, *lp;
	register nib;

	nib = 512;
	fp = genbuf;
	a1 = addr1;
	do {
		lp = getline(*a1++);
		for (;;) {
			if (--nib < 0) {
				write(io, genbuf, fp-genbuf);
				nib = 511;
				fp = genbuf;
			}
			if (++count[1] == 0)
				++count[0];
			if ((*fp++ = *lp++) == 0) {
#ifdef RTED
				/*
				 * If the rt11 flag is set, we must
				 * write out an extra character.
				 * If the user has already managed to
				 * put a CR on the end of the line,
				 * then we don't add the extra one.
				 */
				if(rt11flag && !(&fp[-1]!=genbuf && fp[-2]=='\r')) {
					fp[-1] = '\r';
					if(--nib < 0) {
						write(io, genbuf, fp-genbuf);
						nib = 511;
						fp = genbuf;
					}
					fp++;
				}
#endif
				fp[-1] = '\n';
				break;
			}
		}
	} while (a1 <= addr2);
	write(io, genbuf, fp-genbuf);
}

append(f, a)
int (*f)();
{
	register *a1, *a2, *rdot;
	int nline, tl;
	struct { int intint; };

	nline = 0;
	dot = a;
	while ((*f)() == 0) {
		if (dol >= endcore) {
			if (sbrk(1024) == -1)
				error('c');
			endcore.intint =+ 1024;
		}
		tl = putline();
		nline++;
		a1 = ++dol;
		a2 = a1+1;
		rdot = ++dot;
		while (a1 > rdot)
			*--a2 = *--a1;
		*rdot = tl;
	}
	return(nline);
}

unix()
{
	register savint, pid, rpid;
	int retcode;

	setnoaddr();
	if ((pid = fork()) == 0) {
		signal(SIGHUP, onhup);
		signal(SIGQUIT, onquit);
		execl("/bin/sh", "sh", "-t", 0);
		exit();
	}
	savint = signal(SIGINTR, 1);
	while ((rpid = wait(&retcode)) != pid && rpid != -1);
	signal(SIGINTR, savint);
	puts("!");
}

delete()
{
	register *a1, *a2, *a3;

	setdot();
	newline();
	nonzero();
	a1 = addr1;
	a2 = addr2+1;
	a3 = dol;
	dol =- a2 - a1;
	do
		*a1++ = *a2++;
	while (a2 <= a3);
	a1 = addr1;
	if (a1 > dol)
		a1 = dol;
	dot = a1;
}

getline(tl)
{
	register char *bp, *lp;
	register nl;

	lp = linebuf;
	bp = getblock(tl, READ);
	nl = nleft;
	tl =& ~0377;
	while (*lp++ = *bp++)
		if (--nl == 0) {
			bp = getblock(tl=+0400, READ);
			nl = nleft;
		}
	return(linebuf);
}

putline()
{
	register char *bp, *lp;
	register nl;
	int tl;

	lp = linebuf;
	tl = tline;
	bp = getblock(tl, WRITE);
	nl = nleft;
	tl =& ~0377;
	while (*bp = *lp++) {
		if (*bp++ == '\n') {
			*--bp = 0;
			linebp = lp;
			break;
		}
		if (--nl == 0) {
			bp = getblock(tl=+0400, WRITE);
			nl = nleft;
		}
	}
	nl = tline;
	tline =+ (((lp-linebuf)+03)>>1)&077776;
	return(nl);
}

getblock(atl, iof)
{
	extern read(), write();
	register bno, off;
	
	bno = (atl>>8)&0377;
	off = (atl<<1)&0774;
	if (bno >= 255) {
		puts(TMPERR);
		error('\0');
	}
	nleft = 512 - off;
	if (bno==iblock) {
		ichanged =| iof;
		return(ibuff+off);
	}
	if (bno==oblock)
		return(obuff+off);
	if (iof==READ) {
		if (ichanged)
			blkio(iblock, ibuff, write);
		ichanged = 0;
		iblock = bno;
		blkio(bno, ibuff, read);
		return(ibuff+off);
	}
	if (oblock>=0)
		blkio(oblock, obuff, write);
	oblock = bno;
	return(obuff+off);
}

blkio(b, buf, iofcn)
int (*iofcn)();
{
	seek(tfile, b, 3);
	if ((*iofcn)(tfile, buf, 512) != 512) {
		puts(TMPERR);
		error('\0');
	}
}

init()
{
	register char *p;
	register pid;

	close(tfile);
	tline = 0;
	iblock = -1;
	oblock = -1;
	tfname = "/tmp/exxxxx";
	ichanged = 0;
	pid = getpid();
	for (p = &tfname[11]; p > &tfname[6];) {
		*--p = (pid&07) + '0';
		pid =>> 3;
	}
	close(creat(tfname, 0600));
	tfile = open(tfname, 2);
	brk(fendcore);
	dot = zero = dol = fendcore;
	endcore = fendcore - 2;
}

global(k)
{
	register char *gp;
	register c;
	register int *a1;
	char globuf[GBSIZE];

	if (globp)
		error('g');
	setall();
	nonzero();
	if ((c=getchar())=='\n')
		error('x');
	compile(c);
	gp = globuf;
	while ((c = getchar()) != '\n') {
		if (c==EOF)
			error('x');
		if (c=='\\') {
			c = getchar();
			if (c!='\n')
				*gp++ = '\\';
		}
		*gp++ = c;
		if (gp >= &globuf[GBSIZE-2])
			error('l');
	}
	*gp++ = '\n';
	*gp++ = 0;
	for (a1=zero; a1<=dol; a1++) {
		*a1 =& ~01;
		if (a1>=addr1 && a1<=addr2 && execute(0, a1)==k)
			*a1 =| 01;
	}
	for (a1=zero; a1<=dol; a1++) {
		if (*a1 & 01) {
			*a1 =& ~01;
			dot = a1;
			globp = globuf;
			commands();
			a1 = zero;
		}
	}
}

substitute(inglob)
{
	register gsubf, *a1, nl;
	int getsub();
	int n, m;
	char c;

	n=0;
	while((c=getchar())>='0' && c<='9'){
		n =* 10;
		n =+ c-'0';
	}
	peekc=c;
	if(n==0)
		n=1;
	gsubf = compsub();
	for (a1 = addr1; a1 <= addr2; a1++) {
		if (execute(0, a1)==0)
			continue;
		m=n;
		while(--m>0)
			if(execute(1,1)==0)
	goto out;
		inglob =| 01;
		dosub();
		if (gsubf) {
			while (*loc2) {
				if (execute(1,0)==0)
					break;
				dosub();
			}
		}
		*a1 = putline();
		nl = append(getsub, a1);
		a1 =+ nl;
		addr2 =+ nl;
out: ;
	}
	if (inglob==0)
		error('s');
}

compsub()
{
	register seof, c;
	register char *p;
	int gsubf;

	if ((seof = getchar()) == '\n')
		error('x');
	compile(seof);
	p = rhsbuf;
	for (;;) {
		c = getchar();
		if (c=='\\')
			c = getchar() | 0200;
		if (c=='\n')
			error('x');
		if (c==seof)
			break;
		*p++ = c;
		if (p >= &rhsbuf[LBSIZE/2])
			error('l');
	}
	*p++ = 0;
	if ((peekc = getchar()) == 'g') {
		peekc = 0;
		newline();
		return(1);
	}
	newline();
	return(0);
}

getsub()
{
	register char *p1, *p2;

	p1 = linebuf;
	if ((p2 = linebp) == 0)
		return(EOF);
	while (*p1++ = *p2++);
	linebp = 0;
	return(0);
}

dosub()
{
	register char *lp, *sp, *rp;
	int c;

	lp = linebuf;
	sp = genbuf;
	rp = rhsbuf;
	while (lp < loc1)
		*sp++ = *lp++;
	while (c = *rp++) {
		if (c=='&') {
			sp = place(sp, loc1, loc2);
			continue;
		} else if (c<0 && (c =& 0177) >='1' && c < NBRA+'1') {
			sp = place(sp, braslist[c-'1'], braelist[c-'1']);
			continue;
		}
#ifdef RTED
		else if(rt11flag && dflag && c>='a' && c<='z')
			c =+ 'A'-'a';
#endif
		*sp++ = c&0177;
		if (sp >= &genbuf[LBSIZE])
			error('l');
	}
	lp = loc2;
	loc2 = sp + linebuf - genbuf;
	while (*sp++ = *lp++)
		if (sp >= &genbuf[LBSIZE])
			error('l');
	lp = linebuf;
	sp = genbuf;
	while (*lp++ = *sp++);
}

place(asp, al1, al2)
{
	register char *sp, *l1, *l2;

	sp = asp;
	l1 = al1;
	l2 = al2;
	while (l1 < l2) {
		*sp++ = *l1++;
		if (sp >= &genbuf[LBSIZE])
			error('l');
	}
	return(sp);
}

move(cflag)
{
	register int *adt, *ad1, *ad2;
	int getcopy();

	setdot();
	nonzero();
	if ((adt = address(0))==0)
		error('x');
	newline();
	ad1 = addr1;
	ad2 = addr2;
	if (cflag) {
		ad1 = dol;
		append(getcopy, ad1++);
		ad2 = dol;
	}
	ad2++;
	if (adt<ad1) {
		dot = adt + (ad2-ad1);
		if ((++adt)==ad1)
			return;
		reverse(adt, ad1);
		reverse(ad1, ad2);
		reverse(adt, ad2);
	} else if (adt >= ad2) {
		dot = adt++;
		reverse(ad1, ad2);
		reverse(ad2, adt);
		reverse(ad1, adt);
	} else
		error('m');
}

reverse(aa1, aa2)
{
	register int *a1, *a2, t;

	a1 = aa1;
	a2 = aa2;
	for (;;) {
		t = *--a2;
		if (a2 <= a1)
			return;
		*a2 = *a1;
		*a1++ = t;
	}
}

getcopy()
{
	if (addr1 > addr2)
		return(EOF);
	getline(*addr1++);
	return(0);
}

compile(aeof)
{
	register eof, c;
	register char *ep;
	char *lastep;
	char bracket[NBRA], *bracketp;
	int nbra;
	int cclcnt;

	ep = expbuf;
	eof = aeof;
	bracketp = bracket;
	nbra = 0;
	if ((c = getchar()) == eof) {
		if (*ep==0)
			error('p');
		return;
	}
	circfl = 0;
	if (c=='^') {
		c = getchar();
		circfl++;
	}
	if (c=='*')
		goto cerror;
	peekc = c;
	for (;;) {
		if (ep >= &expbuf[ESIZE])
			goto cerror;
		c = getchar();
		if (c==eof) {
			*ep++ = CEOF;
			return;
		}
		if (c!='*')
			lastep = ep;
		switch (c) {

		case '\\':
			if ((c = getchar())=='(') {
				if (nbra >= NBRA)
					goto cerror;
				*bracketp++ = nbra;
				*ep++ = CBRA;
				*ep++ = nbra++;
				continue;
			}
			if (c == ')') {
				if (bracketp <= bracket)
					goto cerror;
				*ep++ = CKET;
				*ep++ = *--bracketp;
				continue;
			}
			if (c == '{') {
				*ep++ = CBOI;
				continue;
			}
			if (c == '}') {
				*ep++ = CEOI;
				continue;
			}
			*ep++ = CCHR;
			if (c=='\n')
				goto cerror;
			*ep++ = c;
			continue;

		case '.':
			*ep++ = CDOT;
			continue;

		case '\n':
			goto cerror;

		case '*':
			if (*lastep==CBRA || *lastep==CKET)
				error('p');
			*lastep =| STAR;
			continue;

		case '$':
			if ((peekc=getchar()) != eof)
				goto defchar;
			*ep++ = CDOL;
			continue;

		case '[':
			*ep++ = CCL;
			*ep++ = 0;
			cclcnt = 1;
			if ((c=getchar()) == '^') {
				c = getchar();
				ep[-2] = NCCL;
			}
			do {
				if (c=='\n')
					goto cerror;
				*ep++ = c;
				cclcnt++;
				if(dflag && (c|' ')>='a' && (c|' ')<='z'){
					*ep++ = c^' ';
					cclcnt++;
				}
				if (ep >= &expbuf[ESIZE])
					goto cerror;
			} while ((c = getchar()) != ']');
			lastep[1] = cclcnt;
			continue;

		defchar:
		default:
			if(dflag && (c|' ')>='a' && (c|' ')<='z'){
				*ep++ = CCL;
				*ep++ = 3;
				*ep++ = c;
				*ep++ = c^' ';
			}
			else{
				*ep++ = CCHR;
				*ep++ = c;
			}
		}
	}
   cerror:
	expbuf[0] = 0;
	error('p');
}

execute(gf, addr)
int *addr;
{
	register char *p1, *p2, c;

	if (gf) {
		if (circfl)
			return(0);
		if(addr==0){
			p1 = linebuf;
			p2 = genbuf;
			while (*p1++ = *p2++);
		}
		locs = p1 = loc2;
	} else {
		if (addr==zero)
			return(0);
		p1 = getline(*addr);
		locs = 0;
	}
	p2 = expbuf;
	if (circfl) {
		loc1 = p1;
		return(advance(p1, p2));
	}
	/* fast check for first character */
	if (*p2==CCHR) {
		c = p2[1];
		do {
			if (*p1!=c)
				continue;
			if (advance(p1, p2)) {
				loc1 = p1;
				return(1);
			}
		} while (*p1++);
		return(0);
	}
	/* regular algorithm */
	do {
		if (advance(p1, p2)) {
			loc1 = p1;
			return(1);
		}
	} while (*p1++);
	return(0);
}

advance(alp, aep)
{
	register char *lp, *ep, *curlp;
	char *nextep;

	lp = alp;
	ep = aep;
	for (;;) switch (*ep++) {

	case CCHR:
		if (*ep++ == *lp++)
			continue;
		return(0);

	case CDOT:
		if (*lp++)
			continue;
		return(0);

	case CDOL:
		if (*lp==0)
			continue;
		return(0);

	case CEOF:
		loc2 = lp;
		return(1);

	case CCL:
		if (cclass(ep, *lp++, 1)) {
			ep =+ *ep;
			continue;
		}
		return(0);

	case NCCL:
		if (cclass(ep, *lp++, 0)) {
			ep =+ *ep;
			continue;
		}
		return(0);

	case CBRA:
		braslist[*ep++] = lp;
		continue;

	case CKET:
		braelist[*ep++] = lp;
		continue;

	case CDOT|STAR:
		curlp = lp;
		while (*lp++);
		goto star;

	case CCHR|STAR:
		curlp = lp;
		while (*lp++ == *ep);
		ep++;
		goto star;

	case CCL|STAR:
	case NCCL|STAR:
		curlp = lp;
		while (cclass(ep, *lp++, ep[-1]==(CCL|STAR)));
		ep =+ *ep;
		goto star;

	star:
		do {
			lp--;
			if (lp==locs)
				break;
			if (advance(lp, ep))
				return(1);
		} while (lp > curlp);
		return(0);

	case CBOI:
		if(lp==expbuf)
			continue;
		if(alfmatch(lp,0) && !alfmatch(lp-1,1))
			continue;
		return(0);

	case CEOI:
		if(!alfmatch(lp,1))
			continue;
		return(0);

	default:
		error('!');
	}
}

alfmatch(alp,patflag)
{
	register char *lp;

	lp = alp;
	if(patflag)
		if('0' <= *lp && *lp <= '9')
			return(1);
	if(('a' <= *lp && *lp <= 'z')  ||
	   ('A' <= *lp && *lp <= 'Z')  ||
	   (*lp == '_'))
		return(1);
	return(0);
}
cclass(aset, ac, af)
{
	register char *set, c;
	register n;

	set = aset;
	if ((c = ac) == 0)
		return(0);
	n = *set++;
	while (--n)
		if (*set++ == c)
			return(af);
	return(!af);
}

putd()
{
	register r;
	extern ldivr;

	count[1] = ldiv(count[0], count[1], 10);
	count[0] = 0;
	r = ldivr;
	if (count[1])
		putd();
	putchar(r + '0');
}

puts(as)
{
	register char *sp;

	sp = as;
	col = 0;
	while (*sp)
		putchar(*sp++);
	putchar('\n');
}


putchar(ac)
{
	register char *lp;
	register c;

	lp = linp;
	c = ac;
	if (listf) {
		col++;
		if (col >= 72) {
			col = 0;
			*lp++ = '\\';
			*lp++ = '\n';
		}
		if (c=='\t') {
			c = '>';
			goto esc;
		}
		if (c=='\b') {
			c = '<';
		esc:
			*lp++ = '-';
			*lp++ = '\b';
			*lp++ = c;
			goto out;
		}
		if (c<' ' && c!= '\n') {
			*lp++ = '\\';
			*lp++ = (c>>3)+'0';
			*lp++ = (c&07)+'0';
			col =+ 2;
			goto out;
		}
	}
	*lp++ = c;
out:
	if(c == '\n' || lp >= &line[64]) {
		linp = line;
		write(1, line, lp-line);
		return;
	}
	linp = lp;
}

/*
 * Get process ID routine if system call is unavailable.
getpid()
{
	register f;
	int b[1];

	f = open("/dev/kmem", 0);
	if(f < 0)
		return(-1);
	seek(f, 0140074, 0);
	read(f, b, 2);
	seek(f, b[0]+8, 0);
	read(f, b, 2);
	close(f);
	return(b[0]);
}
 */
