#
/*
 * PROPRIETARY INFORMATION.  Not to be reproduced, transmitted, or disclosed
 * in any way without permission.
 *
 * UNIX RT-11 SJ Emulator.
 *
 * Produced by Human Computing Resources Corp.,
 * 10 St. Mary Street, Toronto, Ont. Canada
 *
 * Version:	2		Date:	January 1979
 * Author:	Mike Tilson
 * Description:
 *	Useful utility routines, message printers, etc.
 * Revisions:
 */
#include "defns.h"
#include "decls.h"
#include "errors.h"
extern int fout;	/* SPR 007 - putchar moved to tty.c */
#define E_ERROR		0200
#define E_INTERRUPT	(E_ERROR|0100)

/*
 * print a message on the standard diagnostic output
 */
/* messages come from the error message file */
char efile[] "/lib/rt11/errs";
char format[80];

message(prefix,a,b,c,d) {
	register int savfout;
	register int ef;
	register char *fp;
	int line;
	char inc;

	savfout = fout;
	fout = STDDIAG;
	ef = open(efile, 0);
	if(ef<0) {
		printf("no err file!");
		core();
	}
	fp = 0;
	line = 0;
	while(read(ef, &inc, 1) == 1) {
		if(inc=='\n') {
			line++;
		}
		if(line==a) {
			fp = format;
			while(read(ef, &inc, 1)==1 && inc!='\n' && fp != &format[sizeof format-1])
				*fp++ = inc;
			*fp = '\0';
			fp = format;
			break;
		}
	}
	printf("**%s at pc=%o: ", prefix, uloc);
	if(fp!=0)
		printf(fp,b,c,d);
	else
		printf("error %d", a);
	putchar('\n');
	fout = savfout;
	close(ef);
}

/*
 * Scaled down version of C Library printf.
 * Only %s %l %d (==%l) %o are recognized.
 * Used to print error messages, etc., without the full glory
 * (and full chunk of memory) of standard printf.
 */
printf(fmt,x1,x2,x3,x4,x5,x6,x7,x8,x9,xa,xb,xc)
char fmt[];
{
	register char *s;
	register *adx, c;

	adx = &x1;
loop:
	while((c = *fmt++) != '%') {
		if(c == '\0')
			return;
		putchar(c);
	}
	c = *fmt++;
	if(c == 'd' || c == 'l' || c == 'o')
		printn(*adx, c=='o'? 8: 10);
	if(c == 's') {
		s = *adx;
		while(c = *s++)
			putchar(c);
	}
	adx++;
	goto loop;
}

/*
 * Print an unsigned integer in base b.
 */
printn(n, b)
{
	register a;

	if(a = ldiv(0, n, b))
		printn(a, b);
	putchar(lrem(0, n, b) + '0');
}

/*
 * warning message--continue execution
 */



warning(a,b,c,d) {
	message("Warning",a,b,c,d);
}

/*
 * error -- stop execution with core dump
 */
error(a,b,c,d) {
	message("Error",a,b,c,d);
	if(dumpcore)
		core();
	exit(E_ERROR);
}

/*
 * abend -- fatal internal error
 */
abend(a,b,c,d) {
	message("Internal Error",a,b,c,d);
	core();
}

/*
 * produce core dump by disabling IOT signal catching and aborting.
 */
core() {
	signal(IOT_TRAP, 0);
	abort();
}

quit() {
	dumpcore = YES;
	error(QUITRECVD);
}

intr() {
	rexit(E_INTERRUPT);
}


/*
 * string handlers
 */
append(this, tothat)
	char *this, *tothat;
{
	register char *a, *b;

	for(b=tothat; *b != '\0'; b++)
		;
	for(a=this; *b++ = *a++; )
		;
}

prepend(this, tothat)
	char *this, *tothat;
{
	register char *a, *b;
	register int len;

	len = length(tothat);
	b = tothat+len+1;
	a = b+length(this);
	while(len-- >= 0)
		*--a = *--b;
	a = this;
	b = tothat;
	while(*a)
		*b++ = *a++;
}

copy(this, tothat)
	char *this, *tothat;
{
	register char *a, *b;

	a = this;
	b = tothat;
	while( *b++ = *a++)
		;
}

copyb(this, tothat, count)
	char *this, *tothat;
{
	register char *a, *b;
	register int n;

	if((n=count)<=0)
		return;
	a = this;
	b = tothat;
	do {
		*b++ = *a++;
	} while(--n);
}

length(as)
	char *as;
{
	register char *s;
	register int n;

	s = as;
	n = 0;
	while(*s++)
		n++;
	return(n);
}

zero(an, ap)
	int an;
	byte *ap;
{
	register byte *p;
	register int n;

	if((n=an) == 0)
		return;
	p = ap;
	do
		*p++ = 0;
	while(--n);
}

equal(sa, sb)
	char *sa, *sb;
{
	register char *a, *b;

	a = sa;
	b = sb;
	do {
		if(*a != *b++)
			return(NO);
	} while(*a++);
	return(YES);
}

digit(c) {
	register char rc;

	rc = c;
	if(rc>='0' && rc<='9')
		return(YES);
	return(NO);
}

alpha(c) {
	register char rc;

	rc = c;
	if((rc>='a' && rc<='z') || (rc>='A' && rc<='Z'))
		return(YES);
	return(NO);
}

lcase(c) {
	register rc;
	rc=c;
	if(rc>='A' && rc<='Z')
		rc =- 'A'-'a';
	return(rc);
}

ucase(c) {
	register rc;

	rc=c;
	if(rc>='a' && rc<='z')
		rc =+ 'A'-'a';
	return(rc);
}

convrad(ascii, radix)
	char *ascii;
	int *radix;
	/* converts at most 3 ascii char to rad50. conversion stops
	 * after the third char or after the first not in radix-set.
	 * in the latter case the missing ones are taken to be space
	 * returns the number of really conv chars */ 
	/*** IMPORTANT NOTE:
	 *
	 * this version of convrad does not consider period (056)
	 * to be in the radix-set.  this greatly simplifies the
	 * coding of the command string interpreter, which is the
	 * only caller of this routine.
	 * In addition, '%' and '*' are converted as described in rt-11
	 * system release notes for the CSI.
	 */
{
	register int i, retur;
	register char a;
	char temp[3];

	retur = 3;
	for(i = 0; i != 3; i++) {
		if(retur != 3) {
			temp[i] = 0;
			continue;
		}
		switch(a=ascii[i]) {
		case ' ':
			temp[i] = 0;
			break;
		case '$':
			temp[i] = 033;
			break;
/********
		case '.':
			temp[i] = 034;
			break;
*********/
		/* rt-11 csi mod to definition of rad50: */
		case '%':
			temp[i] = 034;
			break;
		case '*':
			temp[i] = 035;
			break;

		default:
			if(a <= 0132 && a >= 0101)
				temp[i] = a-0100;
			else if(a <= 071 && a >= 060)
				temp[i] = a-022;
			else if(a <= 0172 && a >= 0141)
				temp[i] = a-0140;
			else {
				retur = i;
				temp[i] = 0;
			}
		}
	}

	*radix = temp[0]*050*050+temp[1]*050+temp[2];
	return(retur);
}

convasc(radname, ascii)
	char *ascii;
	/* interprets radname as 3 rad50 letters converts them and    
	 * puts them into ascii */ 

{
	register int i, k;
	register char *a;
	/* to get the first char needs special treatment because
	 * radname can be negative and then "/" gives false result */ 
	if(radname&01)
		k = 1;
	else
		k = 0;
	radname =>> 1;
	radname =& 077777;
	a = ascii;
	a[2] = ((radname%024)*2)+k;
	radname =/ 024;
	/*for the rest follow the normal way*/ 
	a[1] = radname%050;
	radname =/ 050;
	a[0] = radname%050;
	for(i = 0; i != 3; i++) {
		if(*a == 0)
			*a = ' ';
		else if(*a == 033)
			*a = '$';
		else if(*a == 034)
			*a = '.';
		else if(*a == 035)	/* rt11 v3 special */
			*a = '*';
		else if(*a <= 032 && *a >= 001)
			*a = *a+0100;
		else if(*a <= 047 && *a >= 036)
			*a = *a+022;
		a++;
	}
}


/*
 * User stack adjustment
 */

/* move the user's stack up or down.  this code depends intimately upon
 * the early stages of trap catching.
 */
stackadjust(n) {
	register int i;
	register word *target, *source;
	extern word *stack;

	i = 3;
	source = stack;
	target = stack-n;
	stack = target;
	if(n<0) {
		target =+ i;
		source =+ i;
		do {
			*--target = *--source;
		} while(--i);
	}
	else {
		do {
			*target++ = *source++;
		} while(--i);
	}
}

/*
 * push an item on to the user's stack
 */
pushsp(val) {
	extern word *stack;

	stackadjust(1);
	stack[3] = val;
}
