#
/*
 * PROPRIETARY INFORMATION.  Not to be reproduced, transmitted, or disclosed
 * in any way without permission.
 *
 * UNIX RT-11 SJ Emulator.
 *
 * Produced by Human Computing Resources Corp.,
 * 10 St. Mary Street, Toronto, Ont. Canada
 *
 * Version:	2		Date:	January 1979
 * Author:	Mike Tilson
 * Description:
 *	"Console or tty" I/O
 *	TTY input is from standard input, TTY output is to standard output
 * Revisions:
 */
#include "defns.h"
#include "decls.h"
#include "stdaddrs.h"

/*
 * print a line
 */
print(r0)
	char *r0;
{
	register char *c;
	c = r0;
	while(*c>0)
		putchar(*c++);
	if(*c==0) {
		/* SPR 007 - print CR as well as NL */
		putchar('\r');
		putchar('\n');
	}
}

/*
 * read a character
 */
ttyin()
{
	register c;
	static int swflg;

	/*
	 * special feature:  if inhibit tt wait bit is on, then
	 * the program is probably trying to flush input, until
	 * ttyin returns an error.  If this is the case, then we
	 * will alternate between returning a few errors and returning
	 * a character.
	 */
	if(JSW->integ&INHBTTWAIT) {
		if(swflg<=0) {
			errcode(0);
			if(swflg==0)
				swflg--;
			else
				swflg = 1;
			return;
		}
	}
	swflg=0;

	if((c=getchar(terminal)) == EOF)
		rtexit();
	retval = YES;
	rvalue = c;
}

/*
 * print a character
 */
ttyout(r0)
{
	/* suppress nulls on output */
	if(r0)
		putchar(r0);
}


#define RAW	040
#define ECHO	010



/*
 * getchar -- read from given input.
 * RT-11 character translation is done here.
 */
/*
 * Note:  the only routines that read from the std input, rather
 * than the terminal, have to do with the CSI.  The CSI routines
 * always read complete lines, thus we do not have to maintain
 * a separate peekc,lastc for each possible fdes.
 */
getchar(in) {
	static peekc, lastc;
	char c;
	register inc;
	register retc;
	register mode;

	if(peekc) {
		retc = peekc;
		peekc = 0;
		return(retc);
	}
	mode = JSW->integ&SPCLTTY;
	if(in==terminal && mode!=ttymode)
		setmode(mode);
	do {
		if(read(in, &c, 1)<=0)
			return(EOF);
	} while((inc = (c&0177)) == 0);	/* skip nulls */	/* SPR 007 strip parity */
	if( (JSW->integ&LOWERCASE)==0)
		inc = ucase(inc);
	if(inc=='\n' && lastc!='\r') {
		/* translate newline into CR-LF */
		peekc = inc;
		retc = '\r';
	}
	/* SPR 007 -- if in raw mode, CR found on terminal input
	 * should be translated into CR-LF
	 */
	else if(inc=='\r' && (mode&SPCLTTY) && in==terminal) {
		peekc = '\n';
		retc = inc;
	}
	else
		retc = inc;
	lastc = inc;
	return(retc);
}

setmode(mode) {
	int ttybuf[3];
	gtty(terminal, ttybuf);
	ttybuf[2] =& ~(RAW|ECHO);
	if(mode)
		ttybuf[2] =| RAW;
	else
		ttybuf[2] =| ECHO;
	stty(terminal, ttybuf);
	ttymode = mode;
}

/* SPR 007 -- in raw mode, make sure output handling takes care
 * of tab expansion.
 */
int fout 0;
int colpos;
putchar(c) {
	register int mode;

	/* we must check tty mode when doing output.  otherwise we
	 * may have problems with things like VT100 terminal
	 * inquiry.  (we would send out inquiry, do a ttyin, thus
	 * causing an stty which would flush input.)
	 */
	mode = JSW->integ&SPCLTTY;
	if(mode!=ttymode)
		setmode(mode);

	if(c=='\t' && (mode&SPCLTTY)) {
		do
			putchar(' ');
		while(colpos&07);
		return;
	}
	if(c>=040 && c<0177)
		colpos++;
	else if(c=='\r')
		colpos = 0;
	write(fout==0?STDOUT:fout, &c, 1);
	return(c);
}
