#
/*
 * PROPRIETARY INFORMATION.  Not to be reproduced, transmitted, or disclosed
 * in any way without permission.
 *
 * UNIX RT-11 SJ Emulator.
 *
 * Produced by Human Computing Resources Corp.,
 * 10 St. Mary Street, Toronto, Ont. Canada
 *
 * Version:	2		Date:	January 1979
 * Author:	Mike Tilson
 * Description:
 *	Definitions for standard absolute addresses and monitor offsets
 * Revisions:
 */

#define STARTLOC	040
#define INITSPLOC	042
#define JSW		044
#define USRLOC		046
#define HIMEMLOC	050
#define ERRBYT		052
#define UERRBYT		053
#define RMONLOC		054
#define CHAINLOC	0500
#define CHAININFO	0510
#define CHAINSIZE	(01000-CHAININFO)

/*
 * Standard offsets
 */
#define FIRSTOFFSET	0220
#define INTRNCSW	0220	/* undocumented--PIP looks at it--chnl 016 csw */
#define USRADDR		0266
#define IOEXIT		0270
#define SPERRWORD	0272
#define BOOTDEV		0275
#define VNUM		0276
#define RELNUM		0277
#define CONFIG		0300
#define TTYREGS		0304
#define MAXFSIZE	0314
#define SYNCH		0324
#define VT11		0354
#define MTPS		0360
#define MFPS		0362
#define IFSTATE		0366
#define CONFIG2		0370
#define SYSGEN		0372
#define USRSIZE		0374
#define IFNEST		0377
#define LASTOFFSET	0400


/*
 * Interpretation of bits in some of the standard locations
 */
/*
 * JSW - job status word
 */
#define USRNOSWAP	0100000
#define LOWERCASE	0040000
#define REENTER		0020000
#define SPCLTTY		0010000
#define VMIMAGE		0004000
#define PLKMON		0002000
#define OVLYBIT		0001000
#define CHAINBIT	0000400
#define ERRHALT		0000200
#define INHBTTWAIT	0000100
#define FILTERESC	0000040
#define PROCESC		0000020
/* the following bit is not documented in the RT-11 manual.  Its
 * meaning was determined by experiment.  If it is on, then the
 * CSI interprets a "^C" to mean:  "switch from command file
 * reading to tty reading."  Some programs (e.g. link) set the
 * bit, so that a ^c in an indirect file means "go to users tty"
 * for input.  Others, such as macro, stop when they read "^c".
 */
#define REDIRCNTLC	0000010

/*
 * Configuration word
 */
#define USRRESID	0001000
#define PDP1103		0004000	/* this means you can't access the PS word */
#define HASCLOCK	0100000
#define FPP		0100	/* include this in STDCONFIG if you have 11/45 fpp */
#define STDCONFIG	(USRRESID|PDP1103|HASCLOCK)

/*
 * Extension configuration word
 */
#define HASEIS		0000400
#define STDEXTN		HASEIS
