#
/*
 * PROPRIETARY INFORMATION.  Not to be reproduced, transmitted, or disclosed
 * in any way without permission.
 *
 * UNIX RT-11 SJ Emulator.
 *
 * Produced by Human Computing Resources Corp.,
 * 10 St. Mary Street, Toronto, Ont. Canada
 *
 * Version:	2		Date:	January 1979
 * Author:	Mike Tilson
 * Description:
 *	Miscellaneous RT-11 system calls.
 * Revisions:
 */
#include "defns.h"
#include "decls.h"
#include "io.h"
#include "stdaddrs.h"
#include "errors.h"

/*
 * Set the high address limit of the user's space
 */
settop(r0)
	word r0;
{
	register word val;

	/*
	 * ".SET USR NOSWAP" always in effect
	 */
	if(unsgncmp(r0, himem())>=0)
		val = himem();
	else
		val = r0;
	retval = YES;
	rvalue = HIMEMLOC->integ = val;
}

/*
 * delay execution for a specified time
 */
twait(r0)
	int *r0;
{
	register int *t;

	t = r0[1];
	if(t[0]!=0 || t[1]<0) {
		warning(LONGWAIT);
		return;
	}
	sleep((t[1]+30)/60);
}

/*
 * chain to another program
 */
chain()
{
	extern boolean sfpaflg, trpflg;
	register int fsav;
	register struct chan *oc;
	struct chan savchan;

	oc = &chan[OCHAN];
	/*
	 * chain will open the sav image using channel "OCHAN".
	 * If that channel is in use, we want to save it, since
	 * manual claims "all" channels are preserved across a
	 * chain.  (Note:  OCHAN will eventually be destroyed
	 * if the chained to program uses overlays.  Also, it
	 * is not clear what the real RT-11 does here.)
	 */

	getfdes();	/* at least one file descriptor available */
	copyb(oc, &savchan, sizeof savchan);
	oc->flags = 0;
	if(!findfile(OCHAN, CHAINLOC))
		error(NOCHAIN);
	fsav = oc->fdes;	/* get our opened file */
	/* put original OCHAN back */
	copyb(&savchan, oc, sizeof savchan);
	nopen--;
	/* turn off any trap catching */
	sfpaflg = trpflg = NO;
	/* load the program */
	loadprog(fsav, YES);
	/* start him up */
	begin();
}


/*
 * exit
 */
rtexit() {
	purgeall();
	rexit(UERRBYT->charac&017);
}

rexit(code) {
	if(ttymode)
		setmode(0);
	exit(code);
}


/*
 * mark time
 *
 * in this system, mark time occurs instantaneously, as soon as mrkt
 * is called.
 *
 * CURRENTLY, MRKT IS NOT IMPLEMENTED.  USUALLY, MRKT IS USED TO
 * TIME SOME USER INPUT AND TAKE ACTION IF THE USER IS ASLEEP.
 * BY IGNORING THE MRKT, WE SIMPLY GIVE THE USER ALL DAY TO
 * RESPOND.  IF THIS CODE IS PUT IN AGAIN, THE USER MUST RESPOND
 * IN ZERO TIME.
mrkt(r0)
	word *r0;
{
	completion(r0[2], r0[3], 0);
}

cmkt(r0)
	word *r0;
{
	errcode(0);
}
**********/
