#
/*
 * PROPRIETARY INFORMATION.  Not to be reproduced, transmitted, or disclosed
 * in any way without permission.
 *
 * UNIX RT-11 SJ Emulator.
 *
 * Produced by Human Computing Resources Corp.,
 * 10 St. Mary Street, Toronto, Ont. Canada
 *
 * Version:	2		Date:	January 1979
 * Author:	Mike Tilson
 * Description:
 *	These routines implement RT-11 system calls that return various
 *	kinds of information, such as date, time, or channel status.
 * Revisions:
 */
#include "defns.h"
#include "decls.h"
#include "stdaddrs.h"

struct lcltime {
	int seconds;
	int minutes;
	int hours;
	int day;
	int month;
	int year;
	int weekday;
	int yearday;
	int dstflag;
};


/*
 * get time of day
 */
gtim(r0)
	word  *r0;
{
	register long int *result;
	long int times4;
	register int i;
	register struct lcltime *p;
	int tvec[2];

	/*
	 * convert time to 60 Hz clock ticks past midnight.  Be careful to
	 * avoid 16 bit overflow, and inadvertant generation of FP instructions
	 * via 32 bit arithmetic.
	 *
	 * this code is somewhat ugly because we want it to run on all 
	 * versions of the C compiler, including V6.0 which doesn't handle
	 * long ints very well.
	 */
	time(tvec);
	p = localtime(tvec);
	result = r0[1];
	*result = p->minutes*60 + p->seconds;
	for(i=0; i<p->hours; i++)
		*result = *result + 3600;
	/* multiply by 60, being clever */
	for(i=0; i<2; i++)
		*result = *result + *result;
	times4 = *result;
	for(i=0; i<4; i++)
		*result = *result + *result;
	/* now have times 64, subtract times 4 to get times 60 */
	*result = *result - times4;
}

/*
 * get job info
 */
gtjb(r0)
	word *r0;
{
	register word *result;

	result = r0[1];
	*result++ = 0;			/* jobnum */
	*result++ = himem();
	*result++ = 0;			/* lo mem */
	*result++ = 1;			/* I/O channel space.  If user tries
					 * to reference it, an odd address
					 * fault should kill him.
					 */
	*result++ = 0;
}

/*
 * access internal RT-11 monitor values
 */
gval(r0)
	word *r0;
{
	extern byte ldpoint;
	register int off;
	register byte *c;
	register word *i;

	off = r0[1];
	if(off<FIRSTOFFSET || off>=LASTOFFSET) {
		errcode(0);
		return;
	}
	retval = YES;
	if(off&01) {
		c = &ldpoint+off;
		rvalue = *c&0377;
	}
	else {
		i = &ldpoint+off;
		rvalue = *i;
	}
}

/*
 * internal inverse to gval
 */
setval(off, v)
	int off;
	word v;
{
	extern byte ldpoint;
	register word *i;

	i = &ldpoint+off;
	*i = v;
}

/*
 * internal gval
 */
getval(off)
	int off;
{
	extern byte ldpoint;
	register word *i;

	i = &ldpoint+off;
	return(*i);
}

/*
 * get date
 */
date()
{
	int tvec[2];

	time(tvec);
	rvalue = rtdate(tvec);
	retval = YES;
}

rtdate(tvec)
	int tvec[];
{
	register struct lcltime *p;

	p = localtime(tvec);
	return(((p->month+1)<<10) + (p->day<<5) + (p->year-72));
}
