/*
 * PROPRIETARY INFORMATION.  Not to be reproduced, transmitted, or disclosed
 * in any way without permission.
 *
 * UNIX RT-11 SJ Emulator.
 *
 * Produced by Human Computing Resources Corp.,
 * 10 St. Mary Street, Toronto, Ont. Canada
 *
 * Version:	2		Date:	January 1979
 * Author:	Mike Tilson
 * Description:
 *	Error codes are defined here.  The error file is produced 
 *	automatically from this source file.
 * Revisions:
 */

#define RETERR		1	/* "err code %d returned" --- optional message */
#define BPTRAP		2	/* "Breakpoint/Trace trap" --- error */
#define QUITRECVD	3	/* "Quit signal received" --- termination message */
#define BAD_RENAME	4	/* "ENTER rename fails: %s" --- warning */
#define FLT_TRAP	5	/* "Floating exception" --- error */
#define IOTRAP		6	/* "IOT trap" --- error */
#define ILLTRAP		7	/* "Illegal instruction" --- error */
#define INTRNL_EMT	8	/* "Internal EMT" --- error */
#define INVAL_EMT	9	/* "Invalid or not supported EMT %o %o" --- error */
#define NOSPOOL		10	/* "LP spooler missing" --- error */
#define NOREOPEN	11	/* "REOPEN %s fails: %d" --- error */
#define IOPG_REF	12	/* "Reference to I/O page" --- error */
#define RESERVED	13	/* "Reserved EMT" --- error */
#define NOSPFUN		14	/* "SPFUN not supported" --- error */
#define TRAP4		15	/* "Trap to 4" --- error */
#define V1EMT		16	/* "Version 1 EMT" --- error */
#define CANTCREAT	17	/* "Can't create %s" --- warning */
#define NOLPFORK	18	/* "Can't fork for LP spooler, output discarded" --- warning */
#define FATALREOPEN	19	/* "Can't reopen %s" --- abend */
#define FILEGONE	20	/* "File %s is gone" --- warning */
#define NOUNLINK	21	/* "File %s, unlink fails" --- warning */
#define NOFILES		22	/* "No files" --- abend */
#define LONGWAIT	23	/* "TWAIT too long" --- warning */
/*
 * The CSI error codes must be contiguous in the following order
 */
#define CSIERR		24	/* "Bad CSI command line" --- warning */
#define CSIE1		25	/* "CSI illegal device" --- warning */
#define CSIE2		26	/* "CSI unused" --- unused */
#define CSIE3		27	/* "CSI ENTER fails" --- warning */
#define CSIE4		28	/* "CSI input file not found" --- warning */

#define USAGE		29	/* "Usage: ru [-c -e -f -w -p] [-C chn] [-a phys lgc] [-i csi] sav" --- error */
#define NAME2BIG	30	/* "RU filename too long" --- error */
#define NOPROG		31	/* "RU program not found" --- error */
#define LDFAILS		32	/* "Program load fails, invalid sav image" --- error */
#define TOOBIG		33	/* "SAV image too large to load" --- error */
#define BYE_BYE_CHANNEL	34	/* "Channel %o not preserved by CHAIN" --- warning */
#define NOCHAIN		35	/* "CHAIN fails, can't find file" --- error */
#define NOCSTAT		36	/* "CSTAT not implemented" --- warning --- warning */
#define ATABFULL	37	/* "Device assignment table full" --- error */
#define CTABFULL	38	/* "CSI line table full" --- error */
#define NOCDFN		39	/* "CDFN is ignored" --- warning */
#define NOMRKT		40	/* "MRKT is ignored" --- warning */
#define NOCMKT		41	/* "CMKT is ignored" --- warning */
#define NOPROTECT	42	/* "PROTECT is ignored" --- warning */
#define NOHSERR		43	/* "HERR and SERR are ignored" --- warning */
#define NOQSET		44	/* "QSET is ignored" --- warning */
#define NOLOCK		45	/* "LOCK is ignored" --- warning */
#define NORCTRLO	46	/* "RCTRLO is ignored" --- warning */
#define NOUNLOCK	47	/* "UNLOCK is ignored" --- warning */
#define NOTTY		48	/* "/dev/tty cannot be opened for command file init" --- error */
#define NOSCCA		49	/* "CNTL-C intercept (SCCA) not supported" --- warning */
#define TRAPTRAP	50	/* "TRAP instruction" --- error */
#define DIROVERFLOW	51	/* "Directory overflow" --- warning */
