#
/*
 * PROPRIETARY INFORMATION.  Not to be reproduced, transmitted, or disclosed
 * in any way without permission.
 *
 * UNIX RT-11 SJ Emulator.
 *
 * Produced by Human Computing Resources Corp.,
 * 10 St. Mary Street, Toronto, Ont. Canada
 *
 * Version:	2		Date:	January 1979
 * Author:	Mike Tilson
 * Description:
 *	Fake directory reads on dk devices
 *	Used to keep PIP and DIR happy.
 * Revisions:
 */
#include "defns.h"
#include "decls.h"
#include "io.h"
#include "errors.h"

#define DIRSEGS	4
#define SEGWORDS	512
#define SEGSIZE		(SEGWORDS*2)
#define FILESINSEG	((SEGWORDS-5)/7)

struct dirblock {
	int	dirsiz;
	int	nextseg;
	int	highseg;
	int	extra;
	int	fstart;
	struct dentry {
		word	fstatus;
		rad50	ffn[3];
		int	flength;
		int	funused;
		int	fdate;
	} dent[FILESINSEG];
};

struct dirent {
	struct {
		int	inode;
		char	dname[14];
	} entry;
	int	dummy;	/* to end dname with null byte */
};

#define PERMFILE	02000
#define TENTATIVE	0400
#define UNUSED		01000
#define ENDOFSEG	04000


diread(fdes, reqblock, reqlen, target)
	int fdes, reqblock, reqlen;
	byte *target;
{
	register int len, block;
	register int tlen;

	if(reqblock==1 && reqlen==512) {
		/* allow the reading of the "volume id" block */
		zero(reqlen, target);
		return(reqlen);
	}
	reqblock = (reqblock-6)/2 + 1;
	if(reqlen<SEGSIZE || reqlen%SEGSIZE!=0 || reqblock<1 || reqblock>DIRSEGS)
		return(-1);
	seek(fdes, 0, 0);
	len = 0;
	block = 1;
	tlen = 0;
	while(block<reqblock) {
		tlen = gendirblock(fdes, target, block, NO, tlen);
		block++;
	}
	while(len<reqlen) {
		tlen = gendirblock(fdes, target, block, YES, tlen);
		block++;
		len =+ SEGSIZE;
		target =+ SEGSIZE;
	}
	return(len);
}

gendirblock(fdes, target, block, fillin, tl)
	int fdes;
	struct dirblock *target;
	int block;
	boolean fillin;
	int tl;
{
	struct statbuf sbuf;
	register int i;
	register struct dentry *fentry;
	register int tlen;
	boolean enddir;
	char work[20];
	struct dirent dirent;
	extern char *cin;	/* in csi.c */

	tlen = tl;
	dirent.dummy = 0;
	enddir = NO;
	if(fillin) {
		target->dirsiz = DIRSEGS;
		if(block==DIRSEGS)
			target->nextseg = 0;
		else
			target->nextseg = block+1;
		target->highseg = DIRSEGS;
		target->extra = 0;
		target->fstart = 50;
	}
	for(i=0; i<FILESINSEG-1; i++) {
		fentry = &(target->dent[i]);
		if(fillin) {
			zero(sizeof *fentry, fentry);
			fentry->fstatus = UNUSED;
		}
		if(read(fdes, &dirent, sizeof dirent.entry)==sizeof dirent.entry) {
			if(dirent.entry.inode==0 || dirent.entry.dname[0]=='.')
				continue;
			if(fillin) {
				/* fake an entry */
				/* first, convert filename to rad50, by
				 * calling some of the csi routines.
				 */
				cin = dirent.entry.dname;
				if(!getname(fentry->ffn) || *cin!='.')
					continue;
				cin++;
				getext(&(fentry->ffn[2]));
				if(*cin==':')
					fentry->fstatus = TENTATIVE;
				else if(*cin!='\0')
					continue;
				else
					fentry->fstatus = PERMFILE;
				/* rtio has placed directory name
				 * in "filename" previously
				 */
				copy(filename, work);
				append(dirent.entry.dname, work);
				stat(work, &sbuf);
				fentry->flength = (sbuf.size1>>9)&0177;
				fentry->flength =+ (sbuf.size0&0377)<<7;
				if(sbuf.size1&0777)
					fentry->flength++;
				tlen =+ fentry->flength;
				fentry->fdate = rtdate(&sbuf.modtime);
				continue;
			}
		}
		else {
			enddir = YES;
			if(fillin)
				fentry->flength = MAXSIZE-tlen;
			tlen = MAXSIZE;
		}
	}
	if(fillin)
		target->dent[i].fstatus = ENDOFSEG;
	/* if we have reached the end of our allowed RT-11 directory,
	 * and we still haven't hit the end of the UNIX directory,
	 * warn the user.
	 */
	if(block==DIRSEGS && !enddir)
		warning(DIROVERFLOW);
	return(tlen);
}
