#
/*
 * PROPRIETARY INFORMATION.  Not to be reproduced, transmitted, or disclosed
 * in any way without permission.
 *
 * UNIX RT-11 SJ Emulator.
 *
 * Produced by Human Computing Resources Corp.,
 * 10 St. Mary Street, Toronto, Ont. Canada
 *
 * Version:	2		Date:	January 1979
 * Author:	Mike Tilson
 * Description:
 *	This module implements the command string interpreter
 * Revisions:
 */
#include "defns.h"
#include "decls.h"
#include "io.h"
#include "errors.h"
#include "stdaddrs.h"

int nopts;
int noptwords;
char *cin;
char *cmarkpoint;
int cinput STDIN;

#define C_SUCCESS	(-1)
#define C_ILLCMD	0
#define C_BADDEV	1
#define C_ENTERFAILED	3
#define C_LOOKUPFAILED	4


#define C_LEN	81
#define HASVALUE	0100000
#define OUTPUTARGS	3
#define INPUTARGS	6
#define TOTALARGS	(INPUTARGS+OUTPUTARGS)

struct outspcblock {
	dblk osdblk;
	int osize;
};

struct outspc {
	struct outspcblock outp[OUTPUTARGS];
	dblk inp[INPUTARGS];
};
#define oblk	struct outspc
/*
 * the outspc is not a uniform array--the first 3 elements are larger
 */
#define forall	for(i=0,outspc=ospc; i<TOTALARGS; outspc=+((i++<OUTPUTARGS)?sizeof ospc->outp[0]:sizeof ospc->inp[0]))

/*
 * CSI in general mode
 */
csigen(devspc, defext, cstrng, linbuf)
	word devspc;
	rad50 *defext;
	char *cstrng;
	char *linbuf;
{
	oblk ospc[1];
	register word outspc;	/* anon. pointer into ospc */
	register int i;
	register char *lbuf;
	int e;

	retval = YES;
	if(devspc&01) {
		lbuf = linbuf;
		stackadjust(-4);
		devspc =& ~01;
	}
	else {
		lbuf = NULL;
		stackadjust(-3);
	}
	rvalue = devspc;

	csipurge();

Loop:
	if((e=csiget("*\200", defext, ospc, cstrng, lbuf))!=C_SUCCESS) {
		stackadjust(-noptwords);
		if(cstrng==NULL) {
			csimsg(CSIERR+e);
			goto Loop;
		}
		errcode(e);
		return;
	}
	forall {
		if(outspc->device==NULL)
			continue;
		if(i<OUTPUTARGS && (dinfo(outspc->device)->devst&RANDOM)) {
			entering = YES;
			elen = outspc->osize;
		}
		if(!findfile(i, outspc)) {
			stackadjust(-noptwords);
			if(entering)
				e = C_ENTERFAILED;
			else
				e = C_LOOKUPFAILED;
			csipurge();
			if(cstrng==NULL) {
				csimsg(CSIERR+e);
				goto Loop;
			}
			else {
				errcode(e);
				entering = NO;
				return;
			}
		}
		if(entering)
			outspc->osize = chan[i].fsize;
		entering = NO;
	}
}

csipurge() {
	register int i;

	for(i=0; i<TOTALARGS; i++)
		purge(i);
}

/*
 * CSI in special mode.
 * Note:  this call also implements GTLIN
 */
csispc(outspc, defext, cstrng, linbuf)
	word outspc;	/* really "oblk *outspc", but need to bit twiddle */
	rad50 *defext;
	char *cstrng;
	char *linbuf;
{
	register char *lbuf;
	register int e;
	register char *prompt;

	prompt = "*\200";
	if(outspc&01) {
		lbuf = linbuf;
		stackadjust(-4);
		if(outspc==1)
			prompt = defext;
	}
	else {
		lbuf = NULL;
		stackadjust(-3);
	}
Loop:
	if((e=csiget(prompt, defext, outspc&(~1), cstrng, lbuf))!=C_SUCCESS) {
		stackadjust(-noptwords);
		if(cstrng==NULL) {
			csimsg(CSIERR+e);
			goto Loop;
		}
		errcode(e);
	}
}

/*
 * csiget - read and parse the csi command string, placing filenames in
 * "ospc" and options on the user stack.
 */
rad50 defdev;

csiget(prompt, defext, ospc, cstrng, linbuf)
	char *prompt;
	rad50 *defext;
	oblk *ospc;
	char *cstrng;
	char *linbuf;
{
	char cinpt[C_LEN];
	register int ncargs;
	register word outspc;	/* anon. pointer into ospc */
	register int c;
	int lastc;
	extern char *dk[];

	outspc = ospc;
	/* assume all files are input, i.e. we have passed by
	 * OUTPUTARGS, until we find out differently.
	 */
	ncargs = OUTPUTARGS;
	convrad(dk, &defdev);

	nopts = 0;
	noptwords = 0;
	cin = cinpt;
	if(outspc!=NULL)
		zero(sizeof *ospc, outspc);
	if(cstrng != NULL) {
		if(length(cstrng)>=C_LEN)
			return(C_ILLCMD);
		copy(cstrng, cinpt);
	}
	else {
		if(!cgetline(cin, C_LEN, prompt))
			return(C_ILLCMD);
	}
	if(linbuf!=NULL)
		copy(cinpt, linbuf);
	if(outspc!=NULL) {
		cmark();
		lastc = 0;
		while(c=getcsich()) {
			if(c=='=' && lastc!='/') {
				ncargs = 0;	/* we will be having output files */
				break;
			}
			lastc = c;
		}
		cbackup();
		for( ; c=getcsich(); ncargs++) {
			if(c=='=') {
				if(ncargs>OUTPUTARGS)
					return(C_ILLCMD);
				ncargs = OUTPUTARGS-1;
				convrad(dk, &defdev);
				continue;
			}
			else if (c==',')
				continue;
			else
				ungetcsich();
			if(ncargs>=TOTALARGS)
				return(C_ILLCMD);
			if(ncargs<OUTPUTARGS)
				outspc = &ospc->outp[ncargs];
			else
				outspc = &ospc->inp[ncargs-OUTPUTARGS];
			if(!getarg(outspc, defext[ncargs<OUTPUTARGS?ncargs+1:0], ncargs))
				return(C_ILLCMD);
			/* SPR 015 -- check for null dev, there may be only a switch */
			if(outspc->device!=NULL && dinfo(outspc->device)==NULL)
				return(C_BADDEV);
		}
		pushsp(nopts);
		noptwords++;
	}
	return(C_SUCCESS);
}


/*
 * parse a single csi argument
 */
getarg(ad, defext, narg)
	struct outspcblock *ad;
	rad50 defext;
	int narg;
{
	register struct outspcblock *d;
	register word option;
	register boolean foundone;
	word value;
	char c;

	d = ad;
	foundone = NO;

	/* get the device, or fill in default device DK */
	cmark();
	if(!getdev(&(d->device)) || getcsich()!=':') {
		cbackup();
		d->device = defdev;
	}
	else {
		foundone = YES;
		defdev = d->device;
	}

	/* get the filename */
	cmark();
	if(!getname(d->fname)) {
		cbackup();
		d->fname[0] = d->fname[1] = d->extension = 0;
		/* SPR 015 -- if there is no file or device supplied,
		 * zero out the default device filled in above.
		 */
		if(!foundone)
			d->device = 0;
	}
	else {
		foundone = YES;
		if(getcsich()=='.')
			getext(&(d->extension));
		else {
			ungetcsich();
			d->extension = defext;
		}
		if(narg<OUTPUTARGS) {
			/* get the size */
			if(!getsize(&(d->osize)))
				return(NO);
		}
	}


	/* get the options */
	while((c=getcsich())=='/') {
		if((option=getcsich()) == 0)
			return(NO);
		option =& 0177;
		option =| narg<<8;
		foundone = YES;
		while(getvalue(&value)) {
			nopts++;
			pushsp(value);
			option =| HASVALUE;
			pushsp(option);
			noptwords =+ 2;
		}
		if((option&HASVALUE)==0) {
			pushsp(option);
			noptwords++;
			nopts++;
		}
	}
	if(c!=',') {
		ungetcsich();
		if(c!='=' && c!=NULL)
			return(NO);
	}
	return(foundone);
}

/*
 * get a "device" name
 */
getdev(dev)
	rad50 *dev;
{
	register int count;

	/*
	 * Note: this routine accesses the input buffer directly
	 */
	if(!alpha(*cin))
		return(NO);
	count = convrad(cin, dev);
	if(count==0)
		return(NO);
	cin =+ count;
	return(YES);
}


/*
 * get a filename
 */
getname(fn)
	rad50 fn[2];
{
	register int count;

	/*
	 * Note: this routine accesses the input buffer directly
	 */
	count = convrad(cin, &fn[0]);
	if(count==0)
		return(NO);
	cin =+ count;
	cin =+ convrad(cin, &fn[1]);
	return(YES);
}


/*
 * get an extension
 */
getext(ext)
	rad50 *ext;
{
	register int count;

	/*
	 * Note: this routine accesses the input buffer directly
	 */
	cin =+ convrad(cin, ext);
}


/*
 * Get an option value
 */
#define BOTHBASES	YES
#define DECIMALONLY	NO
getvalue(val)
	word *val;
{
	register c;

	/*
	 * Note: this routine accesses the input buffer directly
	 */
	if(getcsich()!=':') {
		ungetcsich();
		return(NO);
	}
	if(alpha(*cin)) {
		cin =+ convrad(cin, val);
		return(YES);
	}
	if(digit(*cin)) {
		*val = getnum(BOTHBASES);
		return(YES);
	}
	return(NO);
}


/*
 * Get an optional size specification
 */
getsize(siz)
	int *siz;
{

	if(getcsich()=='[') {
		if(digit(*cin)) {
			*siz = getnum(DECIMALONLY);
			if(getcsich()==']')
				return(YES);
		}
		return(NO);
	}
	*siz = 0;
	ungetcsich();
	return(YES);
	return(NO);
}


/*
 * get a number
 */
getnum(bothbase)
	boolean bothbase;
{
	register c, dnum, onum;

	dnum = onum = 0;
	while(digit(c=getcsich())) {
		c =- '0';
		dnum = dnum*10+c;
		onum = onum*8+c;
	}
	if(c=='.')
		return(dnum);
	else {
		ungetcsich();
		if(bothbase)
			return(onum);
		else
			return(dnum);
	}
}



/*
 * some csi string utilities
 */
cgetline(lne, len, prompt)
	char *lne;
	int len;
	char *prompt;
{
	register char *p;
	register int n;
	register c;
	boolean suc;

Again:
	p = lne;
	n = 0;
	suc = YES;
	/* check to see if CSI input is coming from stored lines */
	if(ctp != NULL) {
		if(*ctp == NULL) {
			ctp = NULL;
			if(JSW->integ&REDIRCNTLC)
				goto Again;
			rtexit();
		}
		if(length(*ctp) >= len) {
			ctp++;
			return(NO);
		}
		copy(*ctp++, p);
		return(YES);
	}

	/*
	 * If we have already jumped out of command file, and redirect
	 * bit is now off, then treat this like eof.
	 */
	if(commfile && cinput==terminal && (JSW->integ&REDIRCNTLC)==0)
		rtexit();
	if(!promptsuppress)
		print(prompt);

	while((c=getchar(cinput)) != EOF) {
		if(c=='\r')
			continue;
		else if(c=='\n') {
			*p = '\0';
			/* look for ^C, etc. in command files */
			if(lne[0]=='^' || lne[0]==003) {
				if(commfile && cinput!=terminal && (JSW->integ&REDIRCNTLC)!=0) {
					/* switch to tty */
					cinput = terminal;
					promptsuppress = NO;
					goto Again;
				}
				rtexit();
			}
			return(suc);
		}
		else if(n>=len-1)
			suc = NO;
		else {
			*p++ = c;
			n++;
		}
	}
	rtexit();
}

getcsich() {
	return(ucase(*cin++));
}

ungetcsich() {
	cin--;
}

cmark() {
	cmarkpoint = cin;
}

cbackup() {
	cin = cmarkpoint;
}

csimsg(e) {
	message("CSI error", e);
}
