/
/ PROPRIETARY INFORMATION.  Not to be reproduced, transmitted, or disclosed
/ in any way without permission.
/
/ UNIX RT-11 SJ Emulator.
/
/ Produced by Human Computing Resources Corp.,
/ 10 St. Mary Street, Toronto, Ont. Canada
/
/ Version:	2		Date:	January 1979
/ Author:	Mike Tilson
/ Description:
/	assem3.s -
/	All assembly language support for the RT-11 emulator.
/	The run-time startoff is also included, so /lib/crt0.o is
/	not needed.
/	This code is jmp'ed to from assem[0-2].s
/ Revisions:
/

getps=104376	/emt 376

.text
/ Reserve the stack area and the RT-11 "fixed offsets" area at the start
/ of the emulator.  We move the stack here so that the top segmentation
/ register is not used, thus references to top 4K will produce a trap.
/ The first "fixed offset" available to the user is 0220.  We will use
/ the bytes before that as our stack.  We will allocate some more words
/ in front of ldpoint to be the "usr" swapping area, and pretend
/ that a "SET USR NOSWAP" was done.  Thus those words can also be
/ used for stack.  This allocation is done at run time in initialization.
STACKSIZE=220
.globl	_ldpoint, _stack
_ldpoint:
	.=.+STACKSIZE-2
_stack:	0		/ the base of the stack
/ The fixed offsets (which are referenced from "_ldpoint") start here
	.=.+[400-STACKSIZE]

/ run time start off
/ note: code scrunching assumes that everything previous is zero to
/ begin with.
.globl _start
.globl	csv, cret
.globl	savr5
.globl	_exit
.globl	_main

_start:			/ execution will start here
/	Don't use the UNIX supplied stack, since we want all (or as many as
/	possible) references to the top page to produce a trap.
	mov	sp,r0
	mov	$_stack, sp
	mov	(r0),-(sp)
	tst	(r0)+
	mov	r0,2(sp)
	jsr	pc,_main
	mov	r0,(sp)
	jsr	pc,*$_exit
	sys	exit

.bss
savr5:	.=.+2
.text


/ C library -- signal
/ This is a modified version, which allows stack switching between
/ the trap and the call to the C routine.

/ signal(n, 0); /* default action on signal(n) */
/ signal(n, odd); /* ignore signal(n) */
/ signal(n, label); /* goto label on signal(n) */
/ returns old label, only one level.

/ The call to label is as follows:
/	label(r4, r3, r2, r1, oldsp)
/		int *oldsp;
/ where
/	oldsp[0]	is the previous r0
/	oldsp[1]	is the previous pc
/	oldsp[2]	is the previous ps

rtt	= 6
signal	= 48.
.globl	_signal, cerror
.globl	_uloc
.globl	_utrap, _utrapps

_signal:
	mov	r5,-(sp)
	mov	sp,r5
	mov	4(r5),r1
	cmp	r1,$NSIG
	bhis	2f
	mov	6(r5),r0
	mov	r1,0f
	asl	r1
	mov	dvect(r1),-(sp)
	mov	r0,dvect(r1)
	mov	r0,0f+2
	beq	1f
	bit	$1,r0
	bne	1f
	asl	r1
	asl	r1
	add	$tvect,r1
	mov	r1,0f+2
1:
	sys	0; 9f
	bes	3f
	bit	$1,r0
	beq	1f
	mov	r0,(sp)
1:
	mov	(sp)+,r0
	mov	(sp)+,r5
	rts	pc
2:
	mov	$22.,r0		/ EINVAL
	clr	-(sp)
3:
	tst	(sp)+
	jmp	cerror

NSIG = 0
tvect:
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
	mov r0,-(sp); mov dvect+[NSIG*2],r0; br 1f; NSIG=NSIG+1
1:
/ Now switch stacks, to keep out of user area.  Emulator package has
/ its own stack area.  It needs 3 words of user stack before it gets
/ to here in interrupt processing
	mov	sp, _stack
	mov	2(sp), _uloc	/ save old pc in global loc for message printing
	mov	$_stack, sp
	mov	r1,-(sp)
	mov	r2,-(sp)
	mov	r3,-(sp)
	mov	r4,-(sp)
	jsr	pc,(r0)
	mov	(sp)+,r4
	mov	(sp)+,r3
	mov	(sp)+,r2
	mov	(sp)+,r1
	mov	(sp), sp
/ before the final step of returning, see if there is a completion routine
/ to be called
	tst	completion
	beq	1f
	mov	r1,-(sp)
	mov	cmplr0,r0
	mov	cmplr1,r1
	mov	completion,-(sp)
	clr	completion
	jsr	pc,*(sp)+
	mov	(sp)+,r1
1:
	mov	(sp)+,r0
/ now see if we are passing a trap to the user
/ if so, push a new pc, ps onto the stack to jump to user's routine
/ with condition codes set.  user exits with an rti.
	tst	_utrap
	beq	1f
	mov	_utrapps,-(sp)
	mov	_utrap,-(sp)
	clr	_utrap
1:
/ and return to user
	rtt
.data
9:
	sys	signal; 0:..; ..
.bss
_utrap:	.=.+2
_utrapps: .=.+2
dvect:	.=.+[NSIG*2]
.text

/ Addition to C library -- trapcatch.
/ Requires modification to UNIX.
/ If not available, bad system call error will be returned.
/
/ trapcatch(addr, signo)
/
/ TRAP instructions that occur below address "addr" will not
/ be treated as UNIX system calls, but instead will result in
/ signal "signo".
/
.globl	_trapcatch

trapcatch=59.
_trapcatch:
	mov	r5,-(sp)
	mov	sp,r5
	mov	4(r5),0f
	mov	6(r5),0f+2
	sys	0; 9f
	bec	1f
	jmp	cerror
1:
	mov	(sp)+,r5
	rts	pc
.data
9:
	sys	trapcatch; 0:..; ..
.text

/	Begin execution of the user program
.globl	_begin
stkadr=42	/ RUN command will place initial stack address here
strtadr=40	/ RUN command will place initial transfer address here
_begin:
	mov	stkadr, sp	/ set up the user's stack 
	clr	r5		/ give him some nice registers
	clr	r4
	clr	r3
	clr	r2
	clr	r1
	clr	r0
	clr	-(sp)
	mov	strtadr,-(sp)
	rtt

/
/ completion routine caller
/
.globl	_completion
_completion:
	jsr	r5, csv
	mov	6(r5), cmplr0
	mov	8(r5), cmplr1
	mov	4(r5), completion
	jbr	cret
.bss
completion:	.=.+2
cmplr0:		.=.+2
cmplr1:		.=.+2
.text

/
/ Unsigned compare routine
/
.globl	_unsgncmp
_unsgncmp:
	clr	r0
	cmp	2(sp),4(sp)
	blo	1f
	beq	2f
	inc	r0
	br	2f
1:
	dec	r0
2:
	rts	pc

/
/ move to PS routine
/
.globl	_mtps
_mtps:
	rtt	/ surprise!  a pretty short routine.

/
/ move from PS routine
/
.globl	_mfps, _lglintrnl
_mfps:
	getps
_lglintrnl:		/ internal emt 376 can only come from here
	tst	-(sp)
	mov	2(sp),(sp)
	mov	_retps,2(sp)
	rts	pc
.bss
.globl	_retps
_retps:	.=.+2
.text
