/
/ PROPRIETARY INFORMATION.  Not to be reproduced, transmitted, or disclosed
/ in any way without permission.
/
/ UNIX RT-11 SJ Emulator.
/
/ Produced by Human Computing Resources Corp.,
/ 10 St. Mary Street, Toronto, Ont. Canada
/
/ Version:	2		Date:	January 1979
/ Author:	Mike Tilson
/ Description:
/	assem1.s - jmp to start, and reserve half the blank space for user program.
/	This method of assembling is required because the assembler and/or
/	loader blows up if there is more than 16Kw in any one file.
/
/	In order to speed up loading of the emulator, a scrunch program
/	may have manipulated the a.out to remove all the area reserved
/	for user programs (although the code is still compiled for
/	the high addresses.)  If this has been done, the code must
/	be moved up to its proper location.
/	This is not the cleanest thing in the world, but it makes
/	a significant difference in loading time on a busy system
/	when there is lots of contention for the disk on which
/	the program is stored.
/
/	The code still works if it has not been scrunched (it checks).
/ Revisions:
/


/ force code to go to a high address, since emulator loads at the top of
/ memory
.globl	_start
.if LOADHI-1
	jmp	_start
.endif
.if LOADHI
/
/ The code may have been scrunched down, so that loading time is
/ quicker.  If so, we must allocate memory and move the code up
/ to the spot for which is was compiled
/
	tst	codeloc		/ will be zero unless scruncher has moved things
	beq	js		/ If it is zero, code was not scrunched
.if BIGMEM
	mov	sp,r5		/ save current sp
	mov	$LOADPOINT,sp	/ UNIX will grow stack to hold emulator code
.endif
	mov	$MEMSIZE,r0
	mov	r0,r1		/ the highest memory location
	sub	$_start,r0	/ the number of bytes to move
	mov	r0,r2
	add	$codeloc,r2	/ the end of the emulator currently
	mov	r2,r3
	asr	r0		/ words to move
1:
	mov	-(r2),-(r1)
	clr	-(r3)	/ clear memory, just to leave most things zero
			/ this code itself will be cleared later
	sob	r0,1b
.if BIGMEM
	mov	r5,sp
.endif
js:
	jmp	_start
.globl	codeloc
codeloc:
	.=[LDKLUDGE+4]^.	/ the "+4" because "jmp _start" included in EMUSIZE
.endif
