/*
 * PROPRIETARY INFORMATION.  Not to be reproduced or transmitted in any
 * way without permission.
 *
 *
 * RT-11 V3 Command Interpreter for UNIX.
 * Version 2.0, May 1979
 *
 * Produced by:
 *	Mike Tilson
 *	Human Computing Resources Corporation
 *	10 St. Mary Street
 *	Toronto, Ontario, Canada   M4Y 1P9
 *	416-922-1937
 *
 *
 * Utility routines
 */

#include "defns.h"
#include "decls.h"


/*
 * string handlers
 */
append(this, tothat)
	char *this, *tothat;
{
	register char *a, *b;
	register int n;

	n = 0;
	for(b=tothat; *b != '\0'; b++)
		n++;
	for(a=this; *a!='\0'; a++) {
		if(n>=STRLEN)
			toolong();
		else {
			n++;
			*b++ = *a;
		}
	}
	*b = '\0';
}

prepend(this, tothat)
	char *this, *tothat;
{
	register char *a, *b;
	register int len;
	int len2;

	len = length(tothat);
	len2 = length(this);
	if((len2+len)>STRLEN) {
		toolong();
		return;
	}
	b = tothat+len+1;
	a = b+len2;
	while(len-- >= 0)
		*--a = *--b;
	a = this;
	b = tothat;
	while(*a)
		*b++ = *a++;
}

copy(this, tothat)
	char *this, *tothat;
{
	register char *a, *b;
	register int n;

	a = this;
	b = tothat;
	n = 0;
	while(*a) {
		if(n>=STRLEN)
			toolong();
		else {
			n++;
			*b++ = *a;
		}
		a++;
	}
	*b = '\0';
}

replace(this, withthat, str)
	char this, withthat;
	char *str;
{
	while(*str) {
		if(*str == this)
			*str = withthat;
		str++;
	}
}

length(as)
	char *as;
{
	register char *s;
	register int n;

	s = as;
	n = 0;
	while(*s++)
		n++;
	return(n);
}

ucase(c)
	char c;
{
	if(c>='a' && c<='z')
		c =+ 'A'-'a';
	return(c);
}

lcase(c)
	char c;
{
	if(c>='A' && c<='Z')
		c =- 'A'-'a';
	return(c);
}

digit(c) {
	return(c>='0' && c<='9');
}

alphanum(cc) {
	register char c;

	c = cc;
	return((c>='a'&&c<='z') || (c>='A'&&c<='Z') || (c>='0'&&c<='9'));
}


/* return true if char is in string */
match(ch, str)
	char ch;
	char *str;
{
	register char *s;
	register int len;

	s = str;
	while(*s)
		if(*s++ == ch)
			return(YES);
	return(NO);
}

/* return true if name matches start of target */
matchname(nm, targ)
	char *nm, *targ;
{
	register char *name, *target;

	name=nm;
	target=targ;

	while(*name++ == *target++)
		;
	if(*--name == '\0')
		return(YES);
	return(NO);
}

/* convert ascii to octal */
atoo(str)
	char *str;
{
	register char *s;
	register int n;

	n = 0;
	s = str;
	while(digit(*s))
		n = n*8 + *s++ - '0';
	return(n);
}

/* print octal number with leading zeros */
printo(nn) {
	register int i;
	register int n;
	char work[7];
	n = nn;
	for(i=0; i<6; i++) {
		work[5-i] = (n&07)+'0';
		n = (n>>3)&017777;
	}
	work[6] = '\0';
	printf("%s ", work);
}



/*
 * dynamic storage allocation
 * allocates in pieces, frees the entire thing at once.
 */

char *memcurr, *membase, *memend;

alloc(n) {
	static int initdone;
	register new, loc;

	if(!initdone) {
		memend = memcurr = membase = sbrk(0);
		initdone++;
	}
	if(memcurr+n > memend) {
		new = sbrk(512);
		if(new == -1)
			fatal("out of memory");
		memend = new+n;
	}
	loc = memcurr;
	memcurr =+ n;
	return(loc);
}

release() {
	memcurr = membase;
}




/*
 * Input & indirect file handling
 */

int clook;
getc() {
	int c;

	if(clook) {
		c = clook;
		clook = 0;
	}
	else {
		do {
			c = 0;
			while(read(input[inpsp], &c, 1) <=0) {
				if(inpsp==0)
					return(EOF);
				close(input[inpsp]);
				popinpsp();
			}
		} while(c==0 || c=='\r');	/* delete nuls */ /* SPR 001 delete CRs */
	}
	return(c);
}

termindir() {
	signal(INTR, termindir);
	errors++;
}

indirect() {
	char work[30];
	register int i;
	register c;
	register int f;

	i = 0;
	while((c=getc())!=EOF && !special(c)) {
		if(i < sizeof work -1)
			work[i++] = lcase(c);
	}
	work[i] = 0;
	/* flush remainder of line */
	while(c!=EOF && c!='\n')
		c = getc();
	if(inpsp >= NINPUTS) {
		error("Indirect nesting too deep");
		return(NO);
	}
	else {
		f = openfile(work, ".com");
		if(f==ERROR) {
			error("Indirect file %s not found", work);
			return(NO);
		}
		else
			doindirect(f);
	}
	return(YES);
}

doindirect(f) {
	/*
	 * within indirect files, a CNTL-C should
	 * terminate the indirect file execution.
	 * We insure this by setting "errors" which
	 * will cause the indirect stack to be popped.
	 */
	signal(INTR, termindir);
	inpsp++;
	input[inpsp] = f;
}

popinpsp() {
	inpsp--;
	if(inpsp==0)
		signal(INTR, IGNORE);
}


openfile(name, ext)
	char *name, *ext;
{
	char work[50];
	register int f;
	register char *file;

	file = work;
	copy(name, file);
	if(!match('.', file))
		append(ext, file);
	if(!match(':', file))
		prepend("dk:", file);
	doassign(file);
	replace(':', '/', file);
	f = open(file, 0);
	if(f<0) {
		prepend(rtlib, file);
		f = open(file, 0);
	}
	return(f);
}


/*
 * prompt as appropriate, unless within indirect file
 */
prompt(type, a, b) {
	int c;

	/* force look ahead to see if still in indirect file */
	while(inpsp>0) {
		c = 0;
		if(read(input[inpsp], &c, 1)<=0) {
			close(input[inpsp]);	/* SPR 013 */
			popinpsp();
		}
		else {
			if(c==0)
				continue;
			clook = c;
			break;
		}
	}

	if(inpsp)
		return;
	switch(type) {
	case COMMAND:
		printf("\n.");
		break;
	case INPUT:
		printf("%s", command[currcomm].c_inprompt);
		break;
	case OUTPUT:
		printf("%s", command[currcomm].c_outprompt);
		break;
	case NULL:
		printf(a,b);
		break;
	}
}

/*
 * error printers
 */

error(a,b,c) {
	printf("\n** Error: ");
	printf(a, b, c);
	printf(" **\n\n");
	errors++;
}

fatal(a,b,c) {
	printf("** Fatal error: ");
	printf(a,b,c);
	putchar('\n');
	abort();
	exit();
}

toolong() {
	if(!longmsg) {
		longmsg++;
		error("Command too long");
	}
}


/*
 * file and device string pattern matching
 */
isfile(str, allowpat)
	char *str;
{
	register char *s;
	register int i;

	s = str;
	for(i=0; i<6; i++) {
		if(!alphanum(*s) && !(allowpat && (*s=='%' || *s=='*')))
			break;
		s++;
	}
	if(*s=='\0')
		return(YES);
	if(*s++!='.')
		return(NO);
	for(i=0; i<3; i++) {
		if(!alphanum(*s) && !(allowpat && (*s=='%' || *s=='*')))
			break;
		s++;
	}
	if(*s=='\0')
		return(YES);
	return(NO);
}

isdev(str)
	char *str;
{
	register char *s;
	register int i;

	s = str;
	if(!alphanum(*s))
		return(NO);
	for(i=0; i<3; i++) {
		if(!alphanum(*s))
			break;
		s++;
	}
	if(*s++!=':')
		return(NO);
	if(*s=='\0')
		return(YES);
	return(NO);
}


/*
 * "tentative" file handling.  Files in the "dk?" directories which end
 * in ":tmp" are considered to be "tentative" entries for purposes of
 * RT-11 file system simulation.  There are two possible operations:
 * 1) keyboard CLOSE command, which renames the tentative names to the
 * "permanent" names, and
 * 2) removal of all temps upon termination of a command simulator session.
 * (this prevents accumulation of old temp files.)
 */

struct dirent {
	struct {
		int inode;
		char dname[14];
	} entry;
	char filler;	/* to provide a null byte on the end of dname in all cases */
} dirent;

struct statbuf {
	char	minor;
	char	major;
	int	inumber;
	int	flags;
	char	nlinks;
	char	uid;
	char	gid;
	char	size0;
	int	size1;
	int	addr[8];
	int	actime[2];
	int	modtime[2];
} sbuf;
#define FTYPE	060000
#define DIREC	040000


temps(op) {
	register char *disk;
	register int dir;
	register int len;
	char work[20];
	char work2[20];

	if(debug)
		return;
	disk = "dk0";
	for(disk[2]='0'; disk[2]<='7'; disk[2]++) {
		if(stat(disk, &sbuf)!=ERROR && (sbuf.flags&FTYPE)==DIREC
		  && (dir=open(disk, 0))>=0) {
			while(read(dir, &dirent.entry, sizeof dirent.entry) == sizeof dirent.entry) {
				if(dirent.inode==0)
					continue;
				len = length(dirent.dname);
				if(len>4 && equal(dirent.dname+len-4, ":tmp")) {
					copy(disk, work);
					append("/", work);
					append(dirent.dname, work);
					switch(op) {
					case DELTEMPS:
						unlink(work);
						break;
					case CLOSETEMPS:
						copy(work, work2);
						work[length(work)-4] = '\0';
						unlink(work);
						link(work2, work);
						unlink(work2);
						break;
					}
				}
			}
			close(dir);
		}
	}
}

/*
 * directory initialization.  if directory does not exist, call mkdir.
 * otherwise, delete all files.
 */
newdir(disk)
	char *disk;
{
	register dir;
	register char **av;
	char *arglist[4];
	char work[20];

	dir = open(disk, 0);
	if(dir<0) {
		av = arglist;
		*av++ = "mkdir";
		*av++ = disk;
		*av = NULL;
		ex("/bin/mkdir", arglist);
		chmod(disk, 0755);
	}
	else {
		while(read(dir, &dirent.entry, sizeof dirent.entry) == sizeof dirent.entry) {
			if(dirent.inode!=0 && dirent.dname[0]!='.') {
				copy(disk, work);
				append("/", work);
				append(dirent.dname, work);
				unlink(work);
			}
		}
	}
	close(dir);
}

/* SPR 006 -- equal library routine installed */
equal(aa,bb)
	char *aa, *bb;
{
	register char *a, *b;

	a = aa; b = bb;
	while(*a == *b++)
		if(*a++ == '\0')
			return(1);
	return(0);
}
