/*
 * PROPRIETARY INFORMATION.  Not to be reproduced or transmitted in any
 * way without permission.
 *
 *
 * RT-11 V3 Command Interpreter for UNIX.
 * Version 2.0, May 1979
 *
 * Produced by:
 *	Mike Tilson
 *	Human Computing Resources Corporation
 *	10 St. Mary Street
 *	Toronto, Ontario, Canada   M4Y 1P9
 *	416-922-1937
 *
 *
 * Command parser grammar
 *
 * Many of the structural constraints are imposed not by the grammar, but
 * by the "semantic" routines.
 *
 * This grammar includes device "factoring".
 * The generalized text factoring announced in Version 3B is not
 * implemented.
 *
 * The token T_INPUT_OUTPUT is not read from the user input.  It is faked
 * to signal that the command interpreter wants to read only those
 * subsets of the grammar.
 *
 * The token EOFINDICATOR signals that the characters "^C" were read
 * when looking for an input or an output.
 */
%term STRING DEVICE OPT T_INPUT_OUTPUT EOFINDICATOR
%left '+'
%left ','
%{
#include "defns.h"
extern root;
%}
%%
command:	name blanks filspecs blanks filspecs blanksornull
		={
			root=node(COMMAND,$1,node(FILSPECS,$3, $5));
		}
	|	name blanks filspecs blanksornull
		={
			root=node(COMMAND,$1,node(FILSPECS,$3,NULL));
		}
	|	name blanksornull
		={
			root=node(COMMAND,$1,node(FILSPECS,NULL,NULL));
		}
	|	T_INPUT_OUTPUT filspecs blanksornull
		={
			root=$2;
		}
	|	T_INPUT_OUTPUT options blanksornull
		={
			root = $2;
		}
	|	T_INPUT_OUTPUT EOFINDICATOR blanksornull
		={
			root = NULL;
		}
	;

name:		STRING optlist	={ $$=node(NAME,$1,$2); }
	;

optlist:	options		={ $$=$1; }
	|			={ $$=NULL; }
	;

options:	option		={ $$=node(OPTLIST, NULL, $1); }
	|	options option	={ $$=node(OPTLIST,$1,$2); }
	;

option:		opt STRING	={ $$=node(OPTION,$2,NULL); }
	|	opt STRING ':' spc STRING	={ $$=node(OPTION,$2,$5); }
	;

opt:	OPT			={ colon(1); }
	;

spc:				={ colon(-1); }
	;

filspecs:	fspec
		={	$$=$1;	}
	|	filspecs ',' fspec
		={	$$=node(',', $1, $3);	}
	|	filspecs '+' fspec
		={	$$=node('+', $1, $3);	}
	;

fspec:		file optlist
		={	$$=node(FSPEC, $1, $2);	}
	|	file optlist ')'
		={	$$=node(')', $1, $2);	}
	;

file:		DEVICE
		={	$$=node(FILE, $1, NULL); }
	|	DEVICE STRING
		={	$$=node(FILE, $1, $2);	}
	|	DEVICE '(' STRING
		={
			$$=node('(', $1, $3);
		}
	|	STRING
		={	$$=node(FILE, NULL, $1);	}
	;

blanks:	blank
	| blanks blank
	;

blanksornull:	blanks
	|
	;

blank:	' '
	| '\t'
	;
%%
#include "parser.c"
