/*
 * PROPRIETARY INFORMATION.  Not to be reproduced or transmitted in any
 * way without permission.
 *
 *
 * RT-11 V3 Command Interpreter for UNIX.
 * Version 2.0, May 1979
 *
 * Produced by:
 *	Mike Tilson
 *	Human Computing Resources Corporation
 *	10 St. Mary Street
 *	Toronto, Ontario, Canada   M4Y 1P9
 *	416-922-1937
 *
 *
 * Table and variable initializations
 */

#include "defns.h"
#include "decls.h"

char rtlib[] "/lib/rt11/";

/*
 * Option tables -- one per command.  There are four entries:
 *	name -	full option name (in lower case.)
 *	csiopt-	single character CSI switch, if required.
 *	type-	option type:
 *			SWITCH	option results in a CSI switch char
 *			SUPPRESS option turns off a CSI switch char
 *			IGNORE	just that
 *			FSPECn	output filespec is generated in position n.
 *	flags-	bits describing the option:
 *			ONCOMM, ONINPUT, ONOUTPUT:  describe where the
 *			   option may appear in a command.
 *			OPTARG: indicates an argument (value) is optional
 *			   (e.g. /LIST, /LIST:X)
 *			HASARG: indicates that a value argument is required.
 *			SKIPARG: indicates the value argument should be
 *			   ignored (e.g. /PASS:1)
 *			PRINTER: on FSPEC option, generate LP: for null output.
 *			TERMINAL: as above, but TT:.
 *			DELFSPEC: on FSPEC option, delete filespec.
 *			   (e.g. /NOOBJECT)
 */
struct option copyoptions[] {
	"ascii",	'A',	O_SWITCH,	ONCOMM|ONINPUT,
	"binary",	'B',	O_SWITCH,	ONCOMM|ONINPUT,
	"image",	NULL,	O_IGNORE,	ONCOMM|ONINPUT,
	"exclude",	'P',	O_SWITCH,	ONCOMM|ONINPUT,
	"concatenate",	'U',	O_SWITCH,	ONCOMM|ONINPUT,
	"log",		'W',	O_SWITCH,	ONCOMM|ONINPUT,
	"nolog",	'W',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"replace",	'N',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"noreplace",	'N',	O_SWITCH,	ONCOMM|ONINPUT,
	"newfiles",	'C',	O_SWITCH,	ONCOMM|ONINPUT,
	"query",	'Q',	O_SWITCH,	ONCOMM|ONINPUT,
	"noquery",	NULL,	O_IGNORE,	ONCOMM|ONINPUT,
	"allocate",	NULL,	O_IGNORE,	ONOUTPUT|HASARG,
	NULL,
};
struct option deloptions[] {
	"exclude",	'P',	O_SWITCH,	ONCOMM|ONINPUT,
	"log",		'W',	O_SWITCH,	ONCOMM|ONINPUT,
	"nolog",	'W',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"newfiles",	'C',	O_SWITCH,	ONCOMM|ONINPUT,
	"query",	'Q',	O_IGNORE,	ONCOMM|ONINPUT,	/* by default in command tab, query is on */
							/* if this were not true, IGNORE -> SWITCH */
	"noquery",	'Q',	O_SUPPRESS,	ONCOMM|ONINPUT,
	NULL,
};
struct option diffoptions[] {
	"output",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|HASARG,
	"allocate",	NULL,	O_IGNORE,	ONCOMM|ONINPUT|HASARG,
	"printer",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|PRINTER,
	"terminal",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|TERMINAL,
	"blanklines",	'B',	O_SWITCH,	ONCOMM|ONINPUT,
	"comments",	'C',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"nocomments",	'C',	O_SWITCH,	ONCOMM|ONINPUT,
	"formfeed",	'F',	O_SWITCH,	ONCOMM|ONINPUT,
	"match",	'L',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"spaces",	'S',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"nospaces",	'S',	O_SWITCH,	ONCOMM|ONINPUT,
	NULL,
};
struct option diroptions[] {
	"exclude",	'P',	O_SWITCH,	ONCOMM|ONINPUT,
	"fast",		'F',	O_SWITCH,	ONCOMM|ONINPUT,
	"full",		'E',	O_SWITCH,	ONCOMM|ONINPUT,
	"octal",	'O',	O_SWITCH,	ONCOMM|ONINPUT,
	"newfiles",	'D',	O_SWITCH,	ONCOMM|ONINPUT,
	"brief",	'F',	O_SWITCH,	ONCOMM|ONINPUT,
	"order",	'S',	O_SWITCH,	ONCOMM|ONINPUT|OPTARG,
	"reverse",	'R',	O_SWITCH,	ONCOMM|ONINPUT,
	"since",	'J',	O_SWITCH,	ONCOMM|ONINPUT|OPTARG,
	"before",	'K',	O_SWITCH,	ONCOMM|ONINPUT|OPTARG,
	"date",		'D',	O_SWITCH,	ONCOMM|ONINPUT|OPTARG,
	"columns",	'C',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"printer",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|PRINTER,
	"output",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|HASARG,
	"allocate",	NULL,	O_IGNORE,	ONCOMM|ONINPUT|HASARG,
	"terminal",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|TERMINAL,
	NULL,
};
struct option dumpoptions[] {
	"output",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|HASARG,
	"allocate",	NULL,	O_IGNORE,	ONCOMM|ONINPUT|HASARG,
	"printer",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|PRINTER,
	"terminal",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|TERMINAL,
	"ascii",	'N',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"noascii",	'N',	O_SWITCH,	ONCOMM|ONINPUT,
	"bytes",	'B',	O_SWITCH,	ONCOMM|ONINPUT,
	"ignore",	'G',	O_SWITCH,	ONCOMM|ONINPUT,
	"only",		'O',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"rad50",	'X',	O_SWITCH,	ONCOMM|ONINPUT,
	"start",	'S',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"end",		'E',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"words",	'W',	O_SWITCH,	ONCOMM|ONINPUT,
	NULL,
};

/* edit options are a special case.  the edit option code will use
 * the 'switch' value to determine what to do
 */
struct option editoptions[] {
	"create",	'C',	O_SWITCH,	ONCOMM|ONINPUT,
	"inspect",	'I',	O_SWITCH,	ONCOMM|ONINPUT,
	"output",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|HASARG,
	"allocate",	NULL,	O_IGNORE,	ONCOMM|ONINPUT|HASARG,
	"execute",	'X',	O_SWITCH,	ONCOMM|ONINPUT,
	"teco",		'T',	O_SWITCH,	ONCOMM|ONINPUT,
	"edit",		'E',	O_SWITCH,	ONCOMM|ONINPUT,
	"unix",		'U',	O_SWITCH,	ONCOMM|ONINPUT,	/* non-standard addition */
	NULL,
};
struct option fortoptions[] {
	"list",		NULL,	O_FSPEC2,	ONCOMM|ONINPUT|OPTARG|PRINTER,
	"allocate",	NULL,	O_IGNORE,	ONCOMM|ONINPUT|HASARG,
	"object",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|OPTARG,
	"noobject",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|DELFSPEC,
	"code",		'I',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"diagnose",	'B',	O_SWITCH,	ONCOMM|ONINPUT,
	"extend",	'E',	O_SWITCH,	ONCOMM|ONINPUT,
	"header",	'O',	O_SWITCH,	ONCOMM|ONINPUT,
	"i4",		'T',	O_SWITCH,	ONCOMM|ONINPUT,
	"linenumbers",	'S',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"nolinenumbers", 'S',	O_SWITCH,	ONCOMM|ONINPUT,
	"ondebug",	'D',	O_SWITCH,	ONCOMM|ONINPUT,
	"optimize",	'P',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"nooptimize",	'M',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"record",	'R',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"show",		'L',	O_SWITCH,	ONCOMM|ONINPUT|OPTARG,
	"statistics",	'A',	O_SWITCH,	ONCOMM|ONINPUT,
	"swap",		'U',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"noswap",	'U',	O_SWITCH,	ONCOMM|ONINPUT,
	"units",	'N',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"vectors",	'V',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"novectors",	'V',	O_SWITCH,	ONCOMM|ONINPUT,
	"warnings",	'W',	O_SWITCH,	ONCOMM|ONINPUT,
	NULL,
};
struct option helpoptions[] {
	"printer",	'P',	O_SWITCH,	ONCOMM,
	"terminal",	'P',	O_SUPPRESS,	ONCOMM,
	NULL,
};
struct option initoptions[] {
	"query",	'Y',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"noquery",	'Y',	O_SWITCH,	ONCOMM|ONINPUT,
	NULL,
};

/*]
 * NOTE:  libr switch options will be saved away, but many of them
 * will not actually be sent to the libr command.  They will be read
 * before the command is processed in order to decide what to do.
 * Thus /INSERT does not actually generate a /I switch, but merely
 * signals the libr kludge processor.
 */
struct option libroptions[] {
	"list",		NULL,	O_FSPEC2,	ONCOMM|OPTARG|PRINTER,
	"allocate",	NULL,	O_IGNORE,	ONCOMM|HASARG,
	"object",	NULL,	O_FSPEC1,	ONCOMM|OPTARG,
	"noobject",	NULL,	O_FSPEC1,	ONCOMM|DELFSPEC,
	"create",	'C',	O_SWITCH,	ONCOMM,
	"extract",	'E',	O_SWITCH,	ONCOMM,
	"insert",	'I',	O_SWITCH,	ONCOMM,
	"macro",	'M',	O_SWITCH,	ONCOMM,
	"delete",	'D',	O_SWITCH,	ONCOMM,
	"prompt",	'/',	O_SWITCH,	ONCOMM,
	"remove",	'G',	O_SWITCH,	ONCOMM,
	"replace",	'R',	O_SWITCH,	ONOUTPUT,
	"update",	'U',	O_SWITCH,	ONOUTPUT,
	NULL,
};
struct option linkoptions[] {
	"execute",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|OPTARG,
	"noexecute",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|DELFSPEC,
	"map",		NULL,	O_FSPEC2,	ONCOMM|ONINPUT|OPTARG,
	"allocate",	NULL,	O_IGNORE,	ONCOMM|ONINPUT|HASARG,
	"wide",		'W',	O_SWITCH,	ONCOMM|ONINPUT,
	"lda",		'L',	O_SWITCH,	ONCOMM|ONINPUT,
	"foreground",	'R',	O_SWITCH,	ONCOMM|ONINPUT|OPTARG,
	"fill",		'Z',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"bottom",	'B',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"stack",	'M',	O_SWITCH,	ONCOMM|ONINPUT|OPTARG,
	"boundary",	'Y',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"extend",	'E',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"include",	'I',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"prompt",	'/',	O_SWITCH,	ONCOMM|ONINPUT,
	"round",	'U',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"slowly",	'S',	O_SWITCH,	ONCOMM|ONINPUT,
	"transfer",	'T',	O_SWITCH,	ONCOMM|ONINPUT|OPTARG,
	NULL,
};
struct option macrooptions[] {
	"list",		NULL,	O_FSPEC2,	ONCOMM|ONINPUT|OPTARG|PRINTER,
	"allocate",	NULL,	O_IGNORE,	ONCOMM|ONINPUT|HASARG,
	"object",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|OPTARG,
	"noobject",	NULL,	O_FSPEC1,	ONCOMM|ONINPUT|DELFSPEC,
	"crossreference", 'C',	O_SWITCH,	ONCOMM|ONINPUT|OPTARG,
	"disable",	'D',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"enable",	'E',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"show",		'L',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"noshow",	'N',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"library",	'M',	O_SWITCH,	ONINPUT,
	"pass",		'P',	O_SWITCH,	ONINPUT|HASARG|SKIPARG,
	NULL,
};
struct option printoptions[] {
	"copies",	'K',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"delete",	'D',	O_SWITCH,	ONCOMM|ONINPUT,
	"log",		'W',	O_SWITCH,	ONCOMM|ONINPUT,
	"nolog",	'W',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"newfiles",	'C',	O_SWITCH,	ONCOMM|ONINPUT,
	"query",	'Q',	O_SWITCH,	ONCOMM|ONINPUT,
	NULL,
};
struct option renamoptions[] {
	"log",		'W',	O_SWITCH,	ONCOMM|ONINPUT,
	"nolog",	'W',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"newfiles",	'C',	O_SWITCH,	ONCOMM|ONINPUT,
	"query",	'Q',	O_SWITCH,	ONCOMM|ONINPUT,
	"replace",	'N',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"noreplace",	'N',	O_SWITCH,	ONCOMM|ONINPUT,
	"system",	'Y',	O_SWITCH,	ONCOMM|ONINPUT,
	NULL,
};
struct option typeoptions[] {
	"copies",	'K',	O_SWITCH,	ONCOMM|ONINPUT|HASARG,
	"delete",	'D',	O_SWITCH,	ONCOMM|ONINPUT,
	"query",	'Q',	O_SWITCH,	ONCOMM|ONINPUT,
	"log",		'W',	O_SWITCH,	ONCOMM|ONINPUT,
	"nolog",	'W',	O_SUPPRESS,	ONCOMM|ONINPUT,
	"newfiles",	'C',	O_SWITCH,	ONCOMM|ONINPUT,
	NULL,
};



/*
 * command table -- one entry for each legal command.
 * there are 9 fields:
 *
 *	name	the full command name (in upper case)
 *	type	the type of command.  the normal type is "EXTERNAL", which
 *		means that an RT-11 program is invoked to implement the
 *		command.  other commands are handled as special cases, each
 *		with its own type.
 *	prog	the program to be run to implement the command (in lower case.)
 *		If the program name is followed by an '*', then the
 *		remainder of the string specifies defaults for the
 *		CSI input string (in upper case).  An '=' is used to
 *		separate the output from the input.  The '=' is still
 *		required even if no outputs are supplied.
 *		Thus   "pip*=/D/Q"  says that the PIP program is to be invoked,
 *		and the delete and query options are in effect.  "pip*LP:=/W"
 *		says that PIP is to be used, with output to the line printer,
 *		and logging in effect.
 *	opts	pointer to the list of valid options.
 *	inprompt  input prompt string, if required
 *	outprompt output prompt string.
 *	inmax	maximum number of inputs.
 *	outmax  maximum number of outputs.
 *	flags	bits describing the command.
 *
 * the legal flags are as follows:
 *	NEEDINPUT	prompt for input if none supplied.
 *	NEEDOUTPUT	prompt for output
 *	EXACTINPUT	exactly "inmax" inputs are required, no more, no less.
 *	ARBARG		almost anything allowed as an input or output.
 *			in addition, the prepending of DK: in place of a
 *			missing device is suppressed.
 *			thus this flag is set for commands which do not take
 *			file names, or which may interpret a file name as a
 *			device name.  (e.g. INIT DK == INIT DK:  )
 *	GENFIL		generate "*" for a missing file name (e.g. .XXX -->
 *			*.XXX)
 *	GENEXT		generate ".*" for a missing extension.
 *	GENLST		generate ".LST" for a missing extension.
 *	GENOUT		generate an output file name from the first
 *			input file name.  E.g. MACRO A+B generates
 *				R MACRO
 *				*A=A,B
 *	USEPLUS		use the '+' file separator convention.
 *	PLUSOPT		the '+' file separator means use "/U" CSI switch.
 *	BACKWARDS	the sense of "input" and "output" is reversed.
 *			used by LIBR command.
 *	LIBRCOMM	invokes special processing for the LIBR command,
 *			which is highly non-uniform in its structure.
 *	GENINPUT	an output name is generated 
 *			from an input name.  the sense of "input" and "output"
 *			here refers to the position in the parse tree, and
 *			is independant of the BACKWARDS flag.  this flag is
 *			used only by the LIBR command.
 */
struct command command[] {

	"ASSIGN",	ASSIGN,		NULL,		NULL,		"Physical device name?", "Logical device name?",
			1,		1,		NEEDINPUT|NEEDOUTPUT|ARBARG,

	"B",		BASE,		NULL,		NULL,		NULL,		NULL,
			1,		0,		ARBARG,

	"BYE",		BYE,		NULL,		NULL,		NULL,		NULL,
			0,		0,		NULL,

	"CLOSE",	CLOSE,		NULL,		NULL,		NULL,		NULL,
			0,		0,		NULL,

	"COPY",		EXTERNAL,	"pip*=/W",	copyoptions,	"From?",	"To?  ",
			6,		1,		NEEDINPUT|NEEDOUTPUT|GENFIL|GENEXT|PLUSOPT,

	"DATE",		DATE,		NULL,		NULL,		NULL,		NULL,
			0,		0,		ARBARG,

	"DEASSIGN",	DEASSIGN,	NULL,		NULL,		NULL,		NULL,
			1,		0,		ARBARG,

	"DELETE",	EXTERNAL,	"pip*=/D/Q",	deloptions,	"Files?",	NULL,
			6,		0,		NEEDINPUT|GENEXT,

	"DIFFERENCES",	EXTERNAL,	"srccom",	diffoptions,	"File 1?",	"File 2?",
			2,		0,		EXACTINPUT,

	"DIRECTORY",	EXTERNAL,	"dir*=DK:",	diroptions,	NULL,		NULL,
			6,		0,		GENFIL|GENEXT,

	"DUMP",		EXTERNAL,	"dump",		dumpoptions,	"Device or file?", NULL,
			6,		0,		NEEDINPUT,

	"E",		EXAMINE,	NULL,		NULL,		NULL,		NULL,
			1,		0,		EXACTINPUT|ARBARG,

	"EDIT",		EDIT,		"edit",		editoptions,	"File?",		NULL,
			1,		0,		NEEDINPUT,

	"FORTRAN",	EXTERNAL,	"fortra",	fortoptions,	"Files?",	NULL,
			6,		0,		NEEDINPUT|USEPLUS|GENOUT,

	"HELP",		HELP,		"help",		helpoptions,	NULL,		NULL,
			1,		1,		ARBARG,

	"INITIALIZE",	INITIALIZE,	NULL,		initoptions,	"Device?",	NULL,
			1,		0,		NEEDINPUT|ARBARG,

	"LIBRARY",	EXTERNAL,	"libr",		libroptions,	"Library?",	"File(s)?",
			1,		6,		NEEDINPUT|NEEDOUTPUT|BACKWARDS|LIBRCOMM|GENINPUT,

	"LINK",		EXTERNAL,	"link",		linkoptions,	NULL,		NULL,
			6,		0,		GENOUT,

	"MACRO",	EXTERNAL,	"macro",	macrooptions,	"Files?",	NULL,
			6,		0,		NEEDINPUT|USEPLUS|GENOUT,

	"PRINT",	EXTERNAL,	"pip*LP:=/W",	printoptions,	"Files?",	NULL,
			6,		0,		NEEDINPUT|GENFIL|GENLST,

	"RENAME",	EXTERNAL,	"pip*=/R/W",	renamoptions,	"From?",	"To  ?",
			6,		1,		GENFIL|GENEXT|NEEDINPUT|NEEDOUTPUT,

	"R",		RUN,		NULL,		NULL,		NULL,		NULL,
			1,		0,		EXACTINPUT,

	"RUN",		RUN,		NULL,		NULL,		NULL,		NULL,
			1,		0,		EXACTINPUT,

	"SET",		SET,		NULL,		NULL,		NULL,		NULL,
			1,		1,		ARBARG|EXACTINPUT,

	"SHOW",		SHOW,		NULL,		NULL,		NULL,		NULL,
			0,		0,		ARBARG,

	"TIME",		TIME,		NULL,		NULL,		NULL,		NULL,
			0,		0,		ARBARG,

	"TYPE",		EXTERNAL,	"pip*TT:=",	typeoptions,	"Files?",	NULL,
			6,		0,		NEEDINPUT|GENFIL|GENLST,

	"UNIX",		SHELL,		NULL,		NULL,		NULL,		NULL,
			0,		0,		NULL,
	NULL,
};
