/*
 * PROPRIETARY INFORMATION.  Not to be reproduced or transmitted in any
 * way without permission.
 *
 *
 * RT-11 V3 Command Interpreter for UNIX.
 * Version 2.0, May 1979
 *
 * Produced by:
 *	Mike Tilson
 *	Human Computing Resources Corporation
 *	10 St. Mary Street
 *	Toronto, Ontario, Canada   M4Y 1P9
 *	416-922-1937
 *
 *
 * Defines header
 */

/* useful constants */
#define YES	1
#define NO	0
#define ERROR	(-1)
#define EOF	(-1)
#define NULL	0
#define STRLEN	80

/* parse node types */
#define COMMAND		1
#define FILSPECS	2
#define OPTLIST		3
#define OPTION		4
#define NAME		5
#define INPUT		6
#define OUTPUT		7
#define FSPEC		8
#define FILE		9



/* UNIX signal numbers */
#define INTR	2
#define QUIT	3
#define IGNORE	1

/* command flags */
#define NEEDINPUT	1	/* if no input supplied, prompt for it */
#define NEEDOUTPUT	2	/* if no output supplied, prompt also */
#define ARBARG		04	/* minimal checking of args if set */
#define USEPLUS		010	/* '+' concatenate operator in effect */
#define GENOUT		020	/* generate output name from input name */
#define EXACTINPUT	040	/* exact number of input args reqd */
#define GENFIL		0100	/* supply '*' for missing file name */
#define GENEXT		0200	/* supply '*' for missing extension */
#define GENLST		0400	/* generate ".lst" for missing extension */
#define PLUSOPT		01000	/* kludge: generate /U option if '+' in	*/
				/* input list.  used for COPY command.	*/
#define BACKWARDS	02000	/* reverse input & output lists before execution */
				/* (a kludge because LIBR command is so ugly */
#define LIBRCOMM	04000	/* an even worse kludge to invoke special processing for LIBR */
#define GENINPUT	010000	/* another LIBR kludge.  generate an additional
				 * output (right hand side) arg via parse tree
				 * grafting.
				 */

#define ALLOWPAT	(GENFIL|GENEXT|GENLST)	/* in any of these cases, pat matching chars ok */

/* command types */
#define EXTERNAL	1	/* call RU to execute command.  Remainder are special cases ... */
#define ASSIGN		2
#define BASE		3
#define BYE		4
#define CLOSE		5
#define DEASSIGN	6
#define DATE		7
#define EXAMINE		8
#define INITIALIZE	9
#define RUN		10
#define SHOW		11
#define TIME		12
#define SHELL		13
#define EDIT		14
#define HELP		15
#define SET		16

/* option types */
#define O_SWITCH	0	/* "normal" csi switch option */
#define O_IGNORE	1	/* option to be parsed but ignored */
#define O_FSPEC1	2	/* fill in output filspec 1 */
#define O_FSPEC2	3	/* and 2 */
#define O_FSPEC3	4	/* and 3 */
#define O_SUPPRESS	5	/* suppress the given csi switch setting */

/* option flags */
#define ONCOMM		01	/* option may be positioned on command */
#define ONINPUT		02	/* option may be positioned on input */
#define ONOUTPUT	010	/* option may be positioned on output */
#define HASARG		020	/* option takes a value. e.g. /COPIES:3 */
#define OPTARG		040	/* option may optionally take a value */
#define DELFSPEC	0100	/* option forces deletion of an output filspec */
#define SKIPARG		0200	/* any option value to be ignored if present */
#define PRINTER		0400	/* generate an LP: output if no value supplied */
#define TERMINAL	01000	/* generate TT: output if no value supplied */


/* temp file operations */
#define DELTEMPS	0
#define CLOSETEMPS	1
