#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

#include <stdio.h>
#include "asm.h"

/*
 * Read an expression. The value of the
 * expression and its associated relocation
 * information is stored into the `expr'
 * structure supplied by the user. `N' is
 * a firewall priority; all top level calls
 * (from the user) should be made with `n'
 * set to 0.
 */
expr(esp, n)
register struct expr *esp;
{
	register c, p;
	struct area *ap;
	struct expr re;

	term(esp);
	if (esp->e_mode != S_USER)
		return;
	while (ctype[c = getnb()] == BINOP) {
		if ((p = oprio(c)) <= n)
			break;
		if ((c == '>' || c == '<') && c != get())
			qerr();
		expr(&re, p);
		if (c == '+') {
			if (esp->e_base.e_ap == NULL) {
				esp->e_flag = re.e_flag;
				esp->e_base.e_ap = re.e_base.e_ap;
			} else if (re.e_base.e_ap != NULL)
				rerr();
			esp->e_addr += re.e_addr;
		} else if (c == '-') {
			if ((ap = re.e_base.e_ap) != NULL)
				if (esp->e_flag || re.e_flag ||
				    esp->e_base.e_ap != ap)
				rerr();
			esp->e_addr -= re.e_addr;
		} else {
			abscheck(esp);
			abscheck(&re);
			switch (c) {

			case '*':
				esp->e_addr *= re.e_addr;
				break;

			case '/':
				esp->e_addr /= re.e_addr;
				break;

			case '&':
				esp->e_addr &= re.e_addr;
				break;

			case '|':
				esp->e_addr |= re.e_addr;
				break;

			case '<':
				esp->e_addr <<= re.e_addr;
				break;

			case '>':
				esp->e_addr >>= re.e_addr;
				break;
			}
		}
	}
	unget(c);
}

/*
 * Read an absolute expression.
 */
absexpr()
{
	struct expr e;

	expr(&e, 0);
	abscheck(&e);
	return (e.e_addr);
}

/*
 * Read a term.
 * Handles unary operators, brackets,
 * constants in decimal, octal or hexadecimal
 * and identifiers. This routine is also
 * responsible for setting the relocation type
 * to symbol based (e.flag != 0) on global
 * references.
 */
term(esp)
register struct expr *esp;
{
	register c, n;
	struct area *ap;
	char id[NCPS];
	struct sym  *sp;
	struct tsym *tp;
	int r, v;

	c = getnb();
	if (c == '[') {
		expr(esp, 0);
		if (getnb() != ']')
			qerr();
		return;
	}
	if (c == '-') {
		expr(esp, 100);
		abscheck(esp);
		esp->e_addr = -esp->e_addr;
		return;
	}
	if (c == '~') {
		expr(esp, 100);
		abscheck(esp);
		esp->e_addr = ~esp->e_addr;
		return;
	}
	if (c == '\'') {
		esp->e_mode = S_USER;
		esp->e_flag = 0;
		esp->e_base.e_ap = NULL;
		esp->e_addr = getmap(-1);
		return;
	}
	if (ctype[c] == DIGIT) {
		esp->e_mode = S_USER;
		esp->e_flag = 0;
		esp->e_base.e_ap = NULL;
		r = 10;
		if (c == '0') {
			r = 8;
			if ((c = get()) == 'x') {
				r = 16;
				c = get();
			}
		}
		n = 0;
		while ((v = digit(c, r)) >= 0) {
			n = r*n + v;
			c = get();
		}
		if (c=='f' || c=='b') {
			if (n < 10) {
				if (c == 'f')
					tp = tsymp[n].tp_fp; else
					tp = tsymp[n].tp_bp;
				if (tp != NULL) {
					esp->e_base.e_ap = tp->t_area;
					esp->e_addr = tp->t_addr;
					return;
				}
			}
			err('u');
			esp->e_addr = 0;
			return;
		}
		unget(c);
		esp->e_addr = n;
		return;
	}
	if (ctype[c] == LETTER) {
		esp->e_mode = S_USER;
		esp->e_flag = 0;
		esp->e_base.e_ap = NULL;
		esp->e_addr = 0;
		getid(id, c);
		if ((sp = lookup(id, gflag)) != NULL) {
			if (sp->s_type == S_NEW) {
				if ((sp->s_flag&S_GBL) != 0) {
					esp->e_flag = 1;
					esp->e_base.e_sp = sp;
					return;
				}
				err('u');
				return;
			}
			esp->e_mode = sp->s_type;
			esp->e_base.e_ap = sp->s_area;
			esp->e_addr = sp->s_addr;
			return;
		}
		err('u');
		return;
	}
	qerr();
}

/*
 * If `c' is a legal radix `r' digit
 * return its value; otherwise return
 * -1.
 */
digit(c, r)
register c, r;
{
	if (r == 16) {
		if (c >= 'A' && c <= 'F')
			return (c - 'A' + 10);
		if (c >= 'a' && c <= 'f')
			return (c - 'a' + 10);
	}
	if (c >= '0' && c <= '9')
		return (c - '0');
	return (-1);
}

/*
 * Check if the value of the supplied
 * expression is absolute; if not give
 * a relocation error and force the
 * type to absolute.
 */
abscheck(esp)
register struct expr *esp;
{
	if (esp->e_flag || esp->e_base.e_ap != NULL) {
		rerr();
		esp->e_flag = 0;
		esp->e_base.e_ap = NULL;
	}
}

/*
 * Return the priority of the binary
 * operator `c'.
 */
oprio(c)
register c;
{
	if (c == '*' || c == '%')
		return (10);
	if (c == '+' || c == '-')
		return (7);
	if (c == '<' || c == '>')
		return (5);
	if (c == '&')
		return (3);
	if (c == '|')
		return (1);
	return (0);
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                