#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Modifications Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * lex -- header file for lex.c
 */

#define	NCHARS	0400	/* Size of character set */
#define	NCPW	2	/* # characters per word */
#define	NBPC	8	/* # bits per character */
#define	NBPW	(NCPW*NBPC)	/* # bits per word */

#define	MAXNFA	600	/* Number of NFA states */
#define	MAXDFA	800	/* Number of DFA states */
/*
 * Cut down maxnfa/maxdfa for Decus C
 */
#ifdef	rt11
#define MAXNFA	300	/* Number of NFA states */
#define	MAXDFA	400	/* Number of DFA states */
#else
#define MAXNFA	200	/* Number of NFA states */
#define	MAXDFA	300	/* Number of DFA states */
#endif
#define	NTRANS	128	/* Number of translations */
#define	NCCLS	50	/* Number of character classes */
#define	NNEXT	2400	/* Size of dfa move vectors (later: allocate) */

/*
 * Special node characters.
 */
#define	CCL	NCHARS		/* One of a character class */
#define	EPSILON	NCHARS+1	/* Transition on epsilon */
#define	FIN	NCHARS+2	/* Final state; NFA */

/*
 * Set of state numbers (dfa state name).
 */
struct	set {
	struct set *s_next;
	struct	dfa	*s_state;	/* pointer into dfa array  */
	struct	set	*s_group;	/* pointer to owning group (dfamin) */
	int	s_final;		/* nf state which matches  */
	char	s_flag;			/* see below */
	int	s_look;			/* look-ahead bits */
	int	s_len;			/* number of elements in set */
	struct nfa *s_els[];
};

/*
 * State entry
 */
struct	nfa {
	int	n_char;
	char	*n_ccl;
	char	n_flag;
	char	n_look;		/* lookahead index */
	struct	nfa	*n_succ[2];
	struct	trans	*n_trans;
};

/*
 * DFA transition entry.
 */
struct	move {
	struct	set	*m_next;
	struct	dfa	*m_check;
};

/*
 * Structure of DFA vector.
 */
struct	dfa {
	struct	set	*df_name;
	struct	move	*df_base;
	struct	move	*df_max;
	struct	dfa	*df_default;
	int	df_ntrans;
};

/*
 * s_flag values for DFA node
 */
#define	LOOK	01	/* Lookahead mark */
#define	ADDED	02	/* DFA construction mark */
#define	FLOOK	04	/* Mark on final state of lookahead translation */

/*
 * Flag used to print node
 */
#define	NPRT	010	/* NFA node printed */

/*
 * Transition set.
 */
struct	xset {
	struct	set	*x_set;
	char	x_char;
	char	x_defsame;
};

/*
 * Translations
 */
struct	trans {
	struct	nfa	*t_start;
	struct	nfa	*t_final;
};

/*
 * External definitions.
 */
extern	struct	trans	trans[];
extern	struct	trans	*transp;
extern	struct	nfa	nfa[];
extern	struct	nfa	*nfap;
extern	struct	dfa	dfa[];
extern	int	ndfa;
extern	struct	move	move[];
extern	struct	xset	sets[];
extern	char	insets[];
extern	struct	set	*setlist;
extern	char	ccls[][(NCHARS+1)/NBPC];
extern	int	nccls;
extern	int	nlook;
extern	int	llnxtmax;
extern	char	*tabname;
extern	FILE	*llout;
extern	FILE	*lexlog;
extern	FILE	*lexin;
extern	int	lldebug;
extern	int	aflag;
extern	char	*infile;

extern	char	*ignore;
extern	char	*illeg;
extern	char	*breakc;

extern	struct	nfa	*newnfa();
extern	struct	set	*newset();
extern	struct	set	*eclosure();
extern	struct	dfa	*defalt();
extern	struct	move	*stbase();
extern	struct	set	*chase();
extern	char	*newccl();
extern	char	*lalloc();

/*
 * Yacc externals.
 */
extern	int	yyline;
extern	char	*yysterm[];
                                                                                                                                                                                                                                 