#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Modifications Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * Copyright (c) 1978 Charles H. Forsyth
 */

/*
 * lex -- initialisation, allocation, set creation
 *
 * Revised for PDP-11 (Decus) C by Martin Minow
 */

#include <stdio.h>
#include "lexlex.h"

struct	nfa	nfa[MAXNFA];
struct	nfa	*nfap = &nfa[1];

struct	xset	sets[NCHARS];
char	insets[NCHARS];

struct	trans	trans[NTRANS];
struct	trans	*transp = &trans[0];

char	ccls[NCCLS][(NCHARS+1)/NBPC];
int	nccls;

int	ndfa;
struct	dfa	dfa[MAXDFA];
struct	move	move[NNEXT];

char	*tabname = "lextab";
char	tabfile[15];
char	*infile		= NULL;
char	*outfile	= NULL;
char	*dumpfile	= "lex.out";

int	lldebug	= 0;
int	llnxtmax = 0;

FILE	*llout;
FILE	*lexin;
FILE	*lexlog;
int	aflag;

struct	set	*setlist = 0;

main(argc, argv)
char **argv;
{
	int vflag;
	register char *cp, *cp2;


	vflag = 0;
	for (; argc>1 && *argv[1]=='-'; argv++, argc--)
	switch (argv[1][1] | 040) {
	case 'v':				/* -v => lex.out	*/
		vflag++;			/* -v x.out => x.out	*/
		if (argc > 2 && argv[2][1] != '1') {
			--argc;
			dumpfile = (++argv)[1];
		}
		break;

	case 'd':
		lldebug++;
		break;

	case 'a':
		aflag++;
		break;

	case 'i':
		if (--argc <= 1) {
			error("Missing input file");
			exit(1);
		}
		infile = (++argv)[1];
		if (freopen(infile, "r", stdin) == NULL) {
			error("Cannot open input \"%s\"\n", infile);
			exit(1);
		}
		break;

	case 'o':
		if (--argc <= 1) {
			error("Missing output file");
			exit(1);
		}
		outfile = (++argv)[1];
		break;

	case 't':
		if (--argc <= 1) {
			error("Missing table name");
			exit(1);
		}
		if (strlen(tabname = (++argv)[1]) > 8) {
			error("Table name too long\n");
			exit(1);
		}
		break;

	default:
		error("Illegal option: %s", argv[1]);
		exit(1);
	}
	lexin = stdin;
	cp = (vflag) ? dumpfile : "nl:";	/* Dec specific	*/
	if ((lexlog = fopen(cp, "w")) == NULL) {
		error("Cannot open \"%s\"", cp);
		exit(1);
	}
	if (infile == NULL) {
		infile = malloc(31);
		iovtoa(lexin, infile);
	}
	if (outfile == NULL) {
		for (cp = tabname, cp2 = tabfile; *cp2 = *cp++;)
			cp2++;
		for (cp = ".c"; *cp2++ = *cp++;)
			;
		outfile = tabfile;
	}
	if ((llout = freopen(outfile, "w", stdout))==NULL) {
		error("Can't create %s\n", outfile);
		exit(1);
	}
	heading();
	if (yyparse())
		error("parse failed\n");
}

stats()
{
	char *cp;

	fprintf(lexlog, "\n");
	fprintf(lexlog, "%d/%d NFA states, %d/%d DFA states\n",
		nfap-nfa, MAXNFA, ndfa, MAXDFA);
	fprintf(lexlog, "%d/%d entries in move vectors\n", llnxtmax, NNEXT);
}

/*
 * Dump something needed by some subroutines in different parts
 * of the overlay tree.
 */

pset(t, nf)
register struct set *t;
{
	register i;

	fprintf(lexlog, "{");
	for (i = 0; i < t->s_len; i++)
		if (nf)
			fprintf(lexlog, " %d", t->s_els[i]-nfa); else
			fprintf(lexlog, " %d", t->s_els[i]);
	fprintf(lexlog, "}");
}

/*
 * The following functions simply
 * allocate various kinds of
 * structures.
 */
struct nfa *
newnfa(ch, nf1, nf2)
struct nfa *nf1, *nf2;
{
	register struct nfa *nf;

	if ((nf = nfap++) >= &nfa[MAXNFA]) {
		error("Too many NFA states");
		exit(1);
	}
	nf->n_char = ch;
	nf->n_succ[0] = nf1;
	nf->n_succ[1] = nf2;
	nf->n_trans = 0;
	nf->n_flag = 0;
	nf->n_look = 0;
	return(nf);
}

newdfa()
{
	register struct dfa *df;

	if ((df = &dfa[ndfa++]) >= &dfa[MAXDFA]) {
		error("Out of dfa states");
		exit(1);
	}
	return(df);
}

char *
newccl(ccl)
char *ccl;
{
	register char *p, *q;
	register i;
	int j;

	for (j = 0; j < nccls; j++) {
		p = ccl;
		q = ccls[j];
		for (i = sizeof(ccls[j]); i--;)
			if (*p++ != *q++)
				goto cont;
		return(ccls[j]);
	cont:;
	}
	if (nccls >= NCCLS) {
		error("Too many character classes");
		exit(1);
	}
	p = ccl;
	q = ccls[j = nccls++];
	for (i = sizeof(ccls[j]); i--;)
		*q++ = *p++;
	return(ccls[j]);
}

struct trans *
newtrans(st, en)
struct nfa *st, *en;
{
	register struct trans *tp;

	if ((tp = transp++) >= &trans[NTRANS]) {
		error("Too many translations");
		exit(1);
	}
	tp->t_start = st;
	tp->t_final = en;
	en->n_trans = tp;
	return(tp);
}

/*
 * create a new set.
 * `sf', if set, indicates
 * that the elements of the
 * set are states of an NFA).
 * If `sf' is not set, the
 * elements are state numbers of
 * a DFA.
 */
struct set *
newset(v, i, sf)
register struct nfa **v;
register i;
{
	register struct set *t;
	register k;
	int setcomp();

	qsort(v, i, sizeof(*v), setcomp);
	for (t = setlist; t; t = t->s_next)
		if (t->s_len==i && eqvec(t->s_els, v, i))
			return(t);
	t = lalloc(1, sizeof(*t)+i*sizeof(t->s_els[0]), "set nodes");
	t->s_next = setlist;
	setlist = t;
	t->s_final = 0;
	t->s_state =  0;
	t->s_flag = 0;
	t->s_len = i;
	t->s_group = 0;
	t->s_look = 0;
	for (v += i; i;) {
		--v;
		if (sf) {
			if ((*v)->n_char==FIN)
				t->s_final =  (*v)-nfa;
			if ((*v)->n_flag&LOOK)
				t->s_look |= 1<<(*v)->n_look;
		} else {
			k = *v;
			dfa[k].df_name->s_group = t;
		}
		t->s_els[--i] = *v;
	}
	return(t);
}

setcomp(n1p, n2p)
struct nfa **n1p, **n2p;
{
	register struct nfa *n1, *n2;

	n1 = *n1p;
	n2 = *n2p;
	if (n1 > n2)
		return(1);
	if (n1==n2)
		return(0);
	return(-1);
}

eqvec(a, b, i)
register *a, *b, i;
{
	if (i)
		do {
			if (*a++ != *b++)
				return(0);
		} while (--i);
	return(1);
}

/*
 * Ask for core, and
 * complain if there is no more.
 */
char *
lalloc(n, s, w)
char *w;
{
	register char *cp;

	if ((cp = calloc(n, s)) == NULL) {
		fprintf(stderr, "No space for %s", w);
		if (lldebug)
			dfaprint();
		exit(1);
	}
	return(cp);
}
                                                                                                                                                                                                                                                                          