#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * asm83.c
 * Lex.
 */
#include <stdio.h>
#include "asm80.h"

/*
 * Get the next non white
 * character.
 */
getnb()
{
	register int c;

	while((c=getraw())==' ' || c=='\t');
	return(c);
}

/*
 * Get next character from
 * the input.
 * Apply string mappings.
 */
getmap()
{
	register int n, c, v;

	if((c=getraw()) == '\\')
		switch(c = getraw()) {

		case 'n':
			c = '\n';
			break;

		case 'r':
			c = '\r';
			break;

		case 't':
			c = '\t';
			break;

		case 'b':
			c = '\b';
			break;

		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
			v = n = 0;
			while(++n<=3 && c>='0' && c<='7') {
				v = 8*v + c - '0';
				c = getraw();
			}
			putback(c);
			c = v;
			break;

		default:
			putback(c);
			c = '\\';
		}
	return(c);
}

/*
 * Get next character.
 * Basic routine.
 * Don't screw up on end of
 * line.
 */
getraw()
{
	register int c;

	if((c = *sptr) != '\0')
		++sptr;
	return(c);
}

/*
 * Check for alpha.
 */
alpha(c)
register int c;
{
	if(c=='.' || c=='_' || (c>='a' && c<='z') || (c>='A' && c<='Z'))
		return(1);
	return(0);
}

/*
 * Put a character back.
 * A line at a time version
 * of ungetc.
 * Die if too many characters
 * are put back.
 */
putback(c)
{
	if(c != '\0')
		if(--sptr < sbuf)
			abort();
}

/*
 * Read in an indentifier.
 * Store it (padded with nulls) into the
 * supplied buffer.
 */
getid(c, id)
register int c;
char *id;
{
	register char *p;

	p = id;
	while(alpha(c) || (c>='0' && c<='9')) {
		if(p < &id[NCPS])
			*p++ = c;
		c = getraw();
	}
	while(p < &id[NCPS])
		*p++ = '\0';
	putback(c);
}

/*
 * Read numbers.
 * Trailing period means decimal.
 * Otherwise hex.
 */
getnum(c)
register int c;
{
	register int v, hexseen;
	int hex, dec, decseen, oct;

	hex = dec = oct = hexseen = decseen = 0;
	while((v=digvalue(c)) >= 0) {
		hex = 16*hex + v;
		dec = 10*dec + v;
		oct = 8*oct + v;
		if(v > 9)
			++hexseen;
		if(v > 7)
			++decseen;
		c = getraw();
	}
	if(c == 'q') {
		if(decseen)
			err('n');
		return(oct);
	} else if(c == 'h') {
		return(hex);
	} else {
		if(hexseen)
			err('n');
		putback(c);
		return(dec);
	}
}

/*
 * Return the numeric value
 * of a character (0 to 15) or
 * -1 if bad.
 */
digvalue(c)
register int c;
{
	if(c>='0' && c<='9')
		return(c-'0');
	if(c>='a' && c<='f')
		return(c-'a'+10);
	if(c>='A' && c<='F')
		return(c-'A'+10);
	return(-1);
}

/*
 * Lookup id.
 * The table is either the pst or
 * the ust.
 * Failure in the pst returns
 * NULL; failure in the ust adds
 * a symbol.
 */
struct sym *
lookup(id, stp)
char *id;
register struct sym *stp;
{
	register struct sym *tmp1, *tmp2;
	int s;

	if(stp == pst) {
		while(stp < pptr) {
			if(comp(id,stp->s_name)==0) return(stp);
			stp++;
		}
	return(NULL);
	}
	
	while ((s=comp(id,stp->s_name)) >= 0) {
		if (s == 0) {
			refgen(stp,lineno);
			return(stp);
		}
		stp++;
	}
	if (uptr >= &ust[USERMAX]) {
		fprintf(stderr,"Symbol Tabel Overflow!\n");
		exit(1);
	}
	for (tmp1 = ++uptr; tmp1 > stp;) {
		tmp2 = tmp1--;
		copy (tmp2->s_name, tmp1->s_name, NCPS);
		tmp2->s_type = tmp1->s_type;
		tmp2->s_flag = tmp1->s_flag;
		tmp2->s_ref = tmp1->s_ref;
		tmp2->s_value = tmp1->s_value;
	}
	copy (stp->s_name, id, NCPS);
	stp->s_type = S_UND;
	stp->s_flag = 0;
	stp->s_ref = NULL;
	stp->s_value = 0;
	refgen(stp,lineno);
	++symcnt;
	return(stp);
}

/*
 * Record a reference for the symbol
 */
refgen(stp, iline)
register struct sym *stp;
register int iline;
{
	if (pass!=1) return;
	if (refptr >= &reftab[REFMAX]) {
		fprintf(stderr,"Reference Table Overflow!\n");
		exit(1);
	}
	refptr->r_chain = stp->s_ref;
	refptr->r_stmtno = iline;
	stp->s_ref = refptr++;
	++refcnt;
	return;
}

/*
 * Compare two names.
 * return integer >0 if a1 > a2
 *                =0 if a1 = a2
 *                <0 if a1 < a2
 */
comp(a1,a2)
register char *a1, *a2;
{
	register int c1,c2;
	int i;

	for (i=1; i <= NCPS; i++)
		if((c1= *a1++) != (c2= *a2++)) return (c1-c2);
	return(0);
}

/*
 * Copy strings
 */
copy(s1,s2,len)
register char *s1, *s2;
register int len;
{
	while (len-- > 0) *s1++ = *s2++;
	return;
}
                                                                                           