#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 * Stdio header file.	Version of 15-Sep-80
 *
 * Edit history
 * 01 13-Aug-79 MM	Defined IOV to match the RSX package
 * 02 18-Mar-80	MM	Redefined everything for the new library
 * 03 14-May-80 MM	Do not define things twice
 * 04 13-Jun-80 MM	Define fwild stuff
 * 05 01-Aug-80 MM	Flag changes (IOV Version 08)
 * 06 15-Sep-80 RBD	Add cell for UIC under RSX.
 * 07 22-Sep-80 MM	Added VF$WLD
 * 08 25-Sep-80 MM	Removed VF$BAD
 */

#ifndef	IO_OPN
#ifdef	rsx
typedef struct IOV {
	int	io_flag;	/* Control flags	*/
	int	io_uget;	/* Unget char storage	*/
	int	io_bcnt;	/* Buffer free count	*/
	char	*io_bptr;	/* Buffer free pointer	*/
	char	*io_rbuf;	/* Record buffer start	*/
	int	io_rbsz;	/* Record buffer size	*/
	char	*io_bbuf;	/* Block buffer start	*/
	char	*io_wild;	/* Wildcard lookup buf	*/
	int	io_uic;		/* File's UIC in binary	*/
	int	io_iosb[2];	/* I/O status block	*/
	int	io_fdb[0];	/* File data block	*/
} FILE;

#endif
#ifdef rt11
typedef struct IOV {
	int	io_flag;	/* Control flags	*/
	int	io_uget;	/* Unget char storage	*/
	char	*io_name;	/* File name pointer	*/
	char	*io_wild;	/* Wild card buffer	*/
	int	io_lun;		/* RT11 channel number	*/
	int	io_bcnt;	/* Buffer free count	*/
	char	*io_bptr;	/* Buffer free pointer	*/
	int	io_bnbr;	/* Disk block number	*/
	char	io_bbuf[512];	/* Data buffer		*/
} FILE;
#endif

/*
 * Bits in iov.io_flag.
 *
 * These could be redone as
 *
 *	extern	VF$OPN;
 *	#define	IO_OPN	((int)(&VF$OPN))
 *
 * etc.
 */

#define	IO_OPN	0100000		/* Open file		*/
#define	IO_REC	0040000		/* Record device	*/
#define	IO_TTY	0020000		/* Console terminal	*/
#define	IO_EOF	0010000		/* EOF seen		*/
#define	IO_ERR	0004000		/* Error seen		*/
#define	IO_FIL	0002000		/* Disk file		*/
#define	IO_$$$	0001000		/* Unused		*/
#define	IO_NOS	0000400		/* No newlines needed	*/
#define	IO_UBF	0000200		/* User does buffering	*/
#define	IO_BZY	0000100		/* Buffer busy (RT11)	*/
#define IO_WF1	0000040		/* fwild first flag	*/
#define IO_VER	0000020		/* fwild: ;0 or ;-1	*/
#define IO_VM1	0000010		/* fwild: version ;-1	*/
#define IO_WLD	0000004		/* fwild: wildcard file	*/
#define	IO_MOD	0000003		/* File open mode 	*/
				/* 0    means read	*/
				/* 1    means write	*/
				/* 2    means append	*/
				/* != 0 means output	*/

#define EOF	(-1)
#define NULL	0
#define TRUE	1
#define FALSE	0
 
extern	FILE	*stdin;		/* Standard input file	*/
extern	FILE	*stdout;	/* Standard output file	*/
extern 	FILE	*stderr;	/* Standard error file	*/
extern	int	$$ferr;		/* Error codes set here	*/

#endif
                                                                                                                                                                                                                                                                                                                            