#
/*
 *
 *
 * The  information  in  this  document  is  subject  to  change
 * without  notice  and  should not be construed as a commitment
 * by Digital Equipment Corporation or by DECUS.
 * 
 * Neither Digital Equipment Corporation, DECUS, nor the authors
 * assume any responsibility for the use or reliability of  this
 * document or the described software.
 * 
 * 	Copyright (C) 1980, DECUS
 * 
 * 
 * General permission to copy or modify, but not for profit,  is
 * hereby  granted,  provided that the above copyright notice is
 * included and reference made to  the  fact  that  reproduction
 * privileges were granted by DECUS.
 *
 */

/*
 *			R S T S H D . H
 *
 * Header file for calling RSTS/E I/O services from C.
 *
 * The following are defined:
 *
 *	struct rsts_xrb { .. } *xrb;
 *
 *		Load/access values by xrb.xrlen, etc.
 *
 *	struct rsts_firqb { .. } *firqb;
 *
 *		Load/access values by firqb.fqjob
 *
 *	Unnamed structures for accessing words and bytes:
 *		foo->mem_word and foo->mem_byte
 *	treat foo as a pointer to the indicated storage entity.
 *
 *	RSTS/E EMT codes (CALFIP, _READ, etc.)  The '.' in the
 *	true definition is represented by '_'.
 *
 *	FIRQB function codes, PLAS (firqb.fqerno) function codes,
 *	_UUO or UUOFQ subfunction codes, handler indexes, open file
 *	flag bits, low-core layouts, and keyword status bits.
 *
 *	Also, the "get monitor tables" values are defined as offsets
 *	into the firqb.  Note that firqb/xrb values are volatile.
 *
 * The RSTS/E i/o library contains the following (macro) functions:
 *
 *	rstsys(emt)		Execute a RSTS/E emt, return error code.
 *	clrxrb()		Clear the XRB (before loading it with stuff)
 *	clrfqb()		Clear the FIRQB
 *	getxrb(myxrb)		Copy the system xrb   to   your area
 *	getfqb(myfirqb)		Copy the system firqb to   your area
 *	putxrb(myxrb)		Load the system xrb   from your area
 *	putfqb(myfqb)		Load the system firqb from your area
 *
 * For example, to check for a logical device name, you should:
 *	clrxrb();
 *	clrfqb();
 *	xrb.xrlen		= (first  word of radix-50);
 *	xrb.xrbc		= (second word of radix-50);
 *	firqb.fqdev		= (two bytes of ascii for device name check);
 *	firqb.fqdevn[0]		= (unit number);
 *	firqb.fqdevn[1]		= (non-zero if a real unit number);
 *	rstsys(_LOGS);
 */

/*
 * Define structures for accessing memory
 */

struct {
	char	mem_byte;
};
struct {
	int	mem_word;
};

/*
 * Define XRB structure
 */

struct rsts_xrb {
	int	xrlen;		/*   0 Length of i/o buffer in bytes	*/
	int	xrbc;		/*   2 Byte count for transfer		*/
	char *	xrloc;		/*   4 Buffer start address		*/
	char	xrci;		/*   6 Channel number * 2 for transfer	*/
	char	xrblkm;		/*   7 Random-access block number, MSB	*/
	int	xrblk;		/* 010 Random-access block number, LSB	*/
	int	xrtime;		/* 012 Wait time for terminal input	*/
	int	xrmod;		/* 014 Transfer modifier		*/
};
#define	xrbsiz	14		/* Length of xrb			*/
extern struct rsts_xrb xrb;

/*
 * Define FIRQB structure (twice to get all the bits)
 */

struct rsts_firqb {
	char	firqb_errcode;	/*   0 Reserved for returned error code	*/
	char	firqb_reserved;	/*   1 Reserved byte			*/
	char	fqjob;		/*   2 Holds your job number * 2	*/
	char	fqfun;		/*   3 Function requested		*/
	char	fqerno[1];	/*   4 Error message code and text	*/
	char	fqsizm;		/*   5 File size in blocks, MSB		*/
	int	fqppn;		/*   6 Project-programmer number	*/
	int	fqnam1[2];	/* 010 2-word filename in radix-50	*/
	int	fqext;		/* 014 .ext in radix-50			*/
	int	fqsiz;		/* 016 File size in blocks, low-order	*/
	int	fqnam2[3];	/* 020 3-word new radix-50 filename.ext */
	char	fqpflg;		/* 026 "Protection code real" indicator	*/
	char	fqprot;		/* 027 New protection code		*/
	int	fqdev;		/* 030 2-byte Ascii device name		*/
	char	fqdevn[2];	/* 032 1-byte unit, 1-byte real flag	*/
	int	fqclus;		/* 034 File cluster size for creates	*/
	int	fqnent;		/* 036 Number of entries on dir. lookup	*/
};
struct rsts__firqb {
	int	fq0__dummy[2];	/*	** Place holder **		*/
	char	fqfil;		/*   4 Channel number times 2		*/
	char	fq1__dummy;	/*	** Place holder **		*/
	int	fq2__dummy[5];	/*	** Place holder **		*/
	int	fqbufl;		/* 020 Default buffer length		*/
	int	fqmode;		/* 022 Mode indicator			*/
	int	fqflag;		/* 024 Opened file's flag word		*/
	int	fq3__dummy[5];	/*	** Place holder **		*/
};
#define	fqbsiz	32		/* Firqb size in bytes			*/
extern struct rsts_firqb firqb;

/*
 * Define emt codes
 */

#define	EMT	0104000		/* EMT instruction			*/
#define	CALFIP	EMT+0		/* Call FIP, with firqb loaded		*/
#define	_READ	EMT+2		/* Read					*/
#define	_WRITE	EMT+4		/* Write				*/
#define	_CORE	EMT+6		/* Change user memory size (see below)	*/
#define	_SLEEP	EMT+8		/* Sleep job for N seconds		*/
#define	_PEEK	EMT+10		/* Peek at memory			*/
#define	_SPEC	EMT+12		/* Special i/o function			*/
#define	_TTAPE	EMT+14		/* Enter tape mode			*/
#define	_TTECH	EMT+16		/* Enable echo				*/
#define	_TTNCH	EMT+18		/* Disable echo				*/
#define	_TTDDT	EMT+20		/* DDT submode				*/
#define	_TTRST	EMT+22		/* Cancel CTRL/O effect			*/
#define	_TIME	EMT+24		/* Get timing information		*/
#define	_POSTN	EMT+26		/* Get device horizontal position	*/
#define	_DATE	EMT+28		/* Get current date and time		*/
#define	_SET	EMT+30		/* Set keyword bit(s)			*/
#define	_STAT	EMT+32		/* Get my statistics			*/
#define	_RUN	EMT+34		/* Run a new program			*/
#define	_NAME	EMT+36		/* Install a new program name		*/
#define	_EXIT	EMT+38		/* Exit to default run-time system	*/
#define	_RTS	EMT+40		/* Change to a new run-time system	*/
#define	_ERLOG	EMT+42		/* Log an error from the run-time sys.	*/
#define	_LOGS	EMT+44		/* Check for logical device name	*/
#define	_CLEAR	EMT+46		/* Clear keyword bits			*/
#define	_MESAG	EMT+48		/* Message send/receive			*/
#define	_CCL	EMT+50		/* CCL checker				*/
#define	_FSS	EMT+52		/* File string scan			*/
#define	_UUO	EMT+54		/* UUO hook				*/
#define	_CHAIN	EMT+56		/* Chain to a new program		*/
#define	_PLAS	EMT+58		/* Resident library control		*/
#define	_RSX	EMT+60		/* Enter RSX emulation			*/
#define	_ULOG	EMT+62		/* Assign/reassign/deassign device	*/

/*
 * Note: do not use the _CORE directive when running under RT11 emulation
 */

/*
 * File processor function codes (loaded into firqb->fqfun)
 */

#define	CLSFQ	0		/* Close an open channel		*/
#define	OPNFQ	2		/* Open a channel			*/
#define	CREFQ	4		/* Create/extend/open a channel		*/
#define	DLNFQ	6		/* Delete a named file			*/
#define	RENFQ	8		/* Rename a file			*/
#define	DIRFQ	10		/* Directory information		*/
#define	UUOFQ	12		/* Process UUO				*/
#define	ERRFQ	14		/* Get error message text		*/
#define	RSTFQ	16		/* Reset (close) [all] channels		*/
#define	LOKFQ	18		/* Lookup a file			*/
#define	ASSFQ	20		/* Assign a device			*/
#define	DEAFQ	22		/* Deassign a device			*/
#define	DALFQ	24		/* Deassign all devices			*/
#define	CRTFQ	26		/* Create/extend/open .tmp file on disk	*/
#define	CRBFQ	28		/* Create/extend/open compiled file	*/


/*
 * _PLAS function codes (loaded into firqb->fqerno)
 */

#define	ATRFQ	0		/* Attach region (resident library)	*/
#define	DTRFQ	2		/* Detach region (resident library)	*/
#define	CRAFQ	4		/* Create address window		*/
#define	ELAFQ	6		/* Eliminate address window		*/
#define	MAPFQ	8		/* Map address window			*/
#define	UMPFQ	10		/* Unmap address window			*/

/*
 * _UUO/UUOFQ subfunction codes (UU_??? for Basic-Plus runtime requests)
 */

#define	UU_SPL	-28		/* One-shot spooling request		*/
#define	UU_DMP	-27		/* On-line monitor snapshot		*/
#define	UU_FIL	-26		/* File utility				*/
#define	UU_ATR	-25		/* Read/write file attributes		*/
#define	UU_CCL	-24		/* CCL command add/delete		*/
#define	UU_???	-23		/* Reserved (Basic-Plus)		*/
#define	UU_???	-22		/* Reserved (Basic-Plus)		*/
#define	UU_???	-21		/* Reserved (Basic-Plus)		*/
#define	UU_???	-20		/* Reserved (Basic-Plus)		*/
#define	UU_LOG	-19		/* Set number of allowed logins		*/
#define	UU_RTS	-18		/* Run-time system & res. lib. control	*/
#define	UU_NAM	-17		/* Set file's run-time system name	*/
#define	UU_DIE	-16		/* Special shutup logout		*/
#define	UU_ACT	-15		/* Accounting information dump		*/
#define	UU_DAT	-14		/* Date/time changer			*/
#define	UU_PRI	-13		/* Priority, runburst changer		*/
#define	UU_TB2	-12		/* 2nd part of monitor tables		*/
#define	UU_BCK	-11		/* Backup accounting changer		*/
#define	UU_???	-10		/* Reserved (Basic-Plus)		*/
#define	UU_HNG	-9		/* Hangup/enable a dataset		*/
#define	UU_FCB	-8		/* Get fcb/ddb information		*/
#define	UU_???	-7		/* Reserved (Basic-Plus)		*/
#define	UU_POK	-6		/* Poke monitor memory			*/
#define	UU_???	-5		/* Reserved (Basic-Plus)		*/
#define	UU_???	-4		/* Reserved (Basic-Plus)		*/
#define	UU_TB1	-3		/* 1st part of monitor tables		*/
#define	UU_NLG	-2		/* Set no logins			*/
#define	UU_YLG	-1		/* Set number of logins to maximum	*/
#define	UU_PAS	0		/* Create an account			*/
#define	UU_DLU	1		/* Delete an account			*/
#define	UU_CLN	2		/* Clean a disk pack			*/
#define	UU_MNT	3		/* Disk pack mount/dismount		*/
#define	UU_LIN	4		/* Login				*/
#define	UU_BYE	5		/* Logout				*/
#define	UU_ATT	6		/* Attach				*/
#define	UU_DET	7		/* Detach				*/
#define	UU_CHU	8		/* Change password/quota		*/
#define	UU_ERR	9		/* Get error message text		*/
#define	UU_ASS	10		/* Assign				*/
#define	UU_DEA	11		/* Deassign				*/
#define	UU_DAL	12		/* Deassign all devices			*/
#define	UU_ZER	13		/* Zero device/directory		*/
#define	UU_RAD	14		/* Read accounting information		*/
#define	UU_DIR	15		/* Get directory information		*/
#define	UU_TRM	16		/* Set terminal characteristics		*/
#define	UU_LOK	17		/* Wildcard directory lookup		*/
#define	UU_???	18		/* Reserved (Basic-Plus)		*/
#define	UU_CHE	19		/* Cache enable/disable			*/
#define	UU_CNV	20		/* Convert date/time to ascii		*/
#define	UU_SLN	21		/* Set/clear system-wide logical names	*/
#define	UU_???	22		/* Reserved (Basic-Plus)		*/
#define	UU_SWP	23		/* Add/remove swap/err/ovr files	*/
#define	UU_JOB	24		/* Job creation (spawn)			*/
#define	UU_PPN	25		/* Wildcard P,PN lookup			*/
#define	UU_SYS	26		/* Return job status information	*/
#define	UU_KMC	27		/* Connect KMC-11 to another device	*/

/*
 * Device handler indexes
 */

#define	DSKHND	0		/* Disk(s)				*/
#define	TTYHND	2		/* Terminal(s)				*/
#define	DTAHND	4		/* DECtape				*/
#define	LPTHND	6		/* Line printer(s)			*/
#define	PTRHND	8		/* Paper tape reader			*/
#define	PTPHND	10		/* Paper tape punch			*/
#define	CDRHND	12		/* Card reader				*/
#define	MTAHND	14		/* Magtape(s)				*/
#define	PKBHND	16		/* Pseudo-keyboards			*/
#define	RXDHND	18		/* Floppy disk				*/
#define	RJEHND	20		/* 2780 Remote Job Entry		*/
#define	NULHND	22		/* Null device				*/
#define	DMCHND	24		/* DMC-11 device			*/
#define	AUDHND	26		/* Autodial device (DN-11)		*/
#define	PLTHND	28		/* X-Y plotter				*/
#define	DT2HND	30		/* DECtape II (TU-58)			*/
#define	KMCHND	32		/* KMC-11 Microprocessor		*/
#define	IBMHND	34		/* IBM interconnect			*/
#define	MBXHND	36		/* Mailbox (reserved for VAX-11)	*/

/*
 * Flag bits for an open file
 */

#define	DDNFS	256		/* File(device) is non-file structured	*/
#define	DDRLO	512		/* File(device) is read-locked		*/
#define	DDWLO	1024		/* File(device) is write-locked		*/
#define	FLGPOS	2048		/* File(device) keeps it's own position	*/
#define	FLGMOD	4096		/* File(device) accepts modifiers	*/
#define	FLGFRC	8192		/* File(device) is byte-oriented	*/
#define	FLGKB	16384		/* File(device) is interactive		*/
#define	FLGRND	0100000		/* File(device) is random-access	*/


/*
 * Define job-unique low memory layout.
 */

#define	KEY			0400	/* Loc. of Job status keyword	*/
#define	FIRQB			0402	/* Loc. of firqb		*/
#define	XRB			0442	/* Loc. of xrb			*/
#define	CORCMN			0460	/* Loc. of core common		*/
extern	int		  	key;	/* Job status keyword		*/
extern	struct rsts_firqb	firqb;	/* File request queue block	*/
extern	struct rsts_xrb		xrb;	/* Transfer request queue block	*/
extern	char			corcmn[]; /* Core common area		*/
extern	int			usrppn;	/* User-assignable p,pn number	*/
extern	int			usrprt;	/* User-assignable prot. code	*/
extern	int			usrlog;	/* User logical dev. name table	*/
extern	int			rstsys(); /* Force load of rsts caller	*/
/*
 * Define keyword status bits
 */

#define	JFSPRI	000400		/* Job is at special run priority	*/
#define	JFFPP	001000		/* Job uses floating-point processor	*/
#define	JFPRIV	002000		/* Job has permanent privileges		*/
#define	JFSYS	004000		/* Job has temporary privileges active	*/
#define	JFNOPR	010000		/* Job is not yet logged in		*/
#define	JFBIG	020000		/* Job can exceed its private mem. max.	*/
#define	JFLOCK	040000		/* Job is not to be swapped		*/

                                                                                                                                                                                                                                                                                                                                                                                                  