1	EXTEND

!	*****  MATRIX INVERSION *****

!

!	THIS BASIC PROGRAM IS A TRANSLATION OF THREE ALGORITHMS

!	FROM THE 'COLLECTED ALGORITHMS OF THE ACM', USED FOR A

!	COMPARISON TO CORRESPONDING PROGRAMS TRANSLATED INTO

!	FORTRAN AND Pascal.


!	ALGORITHM 52 - A SET OF TEST MATRICES

!		JOHN R. HERNDON - APRIL 1961 PP. 180

!

!	ALGORITHM 230- MATRIX PERMUTATION

!		J. BOOTHROYD - VOL 7, NUMBER 6, JUNE, 1964 PP 347

!

!	ALGORITHM 231- MATRIX INVERSION

!		J. BOOTHROYD - VOL 7, NUMBER 6
, JUNE, 1964 PP 347

!





10	EPSILON = 1E-6

	: DIM A(50,50), R%(50), C%(50), TAG%(50), LOC%(50%)


50	N%=50% ! PRESET MATRIX SIZE

!	CONSTRUCT THE TEST MATRIX AND

!	STALL TO ALLOW USER TO SET TIME,

!	INVERT THE MATRIX



100	GOSUB 11000

	: PRINT '.'; : INPUT LINE Z$

	: GOSUB 12000

	: goto 32767



11000	! BUILD A TEST MATRIX A(N,N)

!	

!	THIS SUBROUTINE PLACES IN ARRAY,A, AN

!	N BY N MATRIX WHOSE INVERSE AND EIGENVALUES 

!	ARE KNOWN. THE N-TH ROW AND N-TH
 COLUMN OF THE

!	INVERSE ARE THE SET 1,2,3,...,N. THE MATRIX

!	FORMED BY DELETING THE N-TH ROW AND COLUMN

!	OF THE INVERSE IS THE IDENTITY MATRIX OF

!	ORDER N-1.



11010	C = N%*(N%+1.0)*(N%+N%-5.0)/6.0

	: D = 1.0 / C

	: A(N%,N%) = -D

	: FOR I% = 1% TO N%-1%

		: A(N%,I%) = D*I%

		: A(I%,N%) = A(N%,I%)

		: A(I%,I%) = D*(C-I%*I%)

		: FOR J% = 1% TO I%-1%

			: A(J%,I%) = -D*I%*J%

			: A(I%,J%) = A(J%,I%)

		: NEXT J%

	: NEXT I%

	: RETURN




12000	! INVERT A MATRIX A(N,N
) BY CACM 230,231

!	THIS SUBROUTINE INVERTS A MATRIX IN ITS OWN SPACE USING

!	THE GAUSS-JORDAN METHOD WITH COMPLETE MATRIX PIVOTING.

!	I.E., AT EACH STAGE THE PIVOT HAS THE LARGEST ABSOLUTE

!	OF ANY ELEMENT IN THE REMAINING MATRIX. THE COORDINATES

!	OF THE SUCCESSIVE MATRIX PIVOTS USED AT EACH STAGE OF THE

!	REDUCTION ARE RECORDED IN THE SUCCESSIVE ELEMENT POSITIONS

!	OF THE ROW AND COLUMN VECTORS, R AND C. THESE ARE LATER USED

!	BY A SPECIFIC MODIFICATION OF ALGORITHM 230 TO REARRANGE THE


!	ROWS AND COLUMNS OF THE MATRIX.


12010	R%(I%),C%(I%)=I% FOR I%=1% TO N%

	: PIVI%,PIVJ%=1%

	: FOR I%=1% TO N%

	: FOR J%=1% TO N%

	: IF ABS(A(I%,J%))> ABS(A(PIVI%,PIVJ%))

	  THEN	PIVI%=I%

		: PIVJ%=J%


12020	NEXT J%

	: NEXT I%

	! SET ROW AND COLUMN VECTORS

	! FIND INITIAL PIVOT


12030	FOR I%=1% TO N%

	: L%=R%(I%)

	: R%(I%)=R%(PIVI%)

	: R%(PIVI%)= L%

	: L%=C%(I%)

	: C%(I%)=C%(PIVJ%)

	: C%(PIVJ%)=L%

	: IF ABS(A(R%(I%),C%(I%))) <= EPSILON

	  THEN	SINGULAR%=-1%

	
	: RETURN




12040	A(R%(I%),C%(J%)) =A(R%(I%),C%(J%)) / A(R%(I%),C%(I%))

		IF J%<>I%

			FOR J%=N% TO 1% STEP -1%

	: A(R%(I%),C%(I%)) = 1.0 / A(R%(I%),C%(I%))

	: PIVOT = 0.0

	: FOR K%= 1% TO N%

	: GOTO 12047 IF K%=I%

	: FOR J%=N% TO 1% STEP -1%

	: GOTO 12045 IF J%=I%

	: A(R%(K%),C%(J%)) = A(R%(K%),C%(J%))-A(R%(I%),C%(J%))*A(R%(K%),C%(I%))

	: IF (K%>I%) AND (J%>I%) AND (ABS(A(R%(K%),C%(J%)))>=ABS(PIVOT))

	  THEN 	PIVI%=K%

		: PIVJ%=J%

		: PIVOT = A(R%(K%),C%(J%))


12045	NEXT
 J%

	: A(R%(K%),C%(I%)) = -A(R%(I%),C%(I%))*A(R%(K%),C%(I%))


12047	NEXT K%

	: NEXT I%

	! REDUCTION

!	THE FOLLOWING PROGRAM PARTS REPRESENT TWO

!	SPECIFIC CALLS TO ALGORITHM 230


12060	TAG%(I%),LOC%(I%)=I% FOR I% = 1% TO N%

	: FOR I%=1% TO N%

	: T%= R%(I%)

	: J%=LOC%(T%)

	: K%=C%(I%)

	: GOTO 12070 IF J%=K%

	: FOR P%=1% TO N%

	: W = A(J%,P%)

	: A(J%,P%) = A(K%,P%)

	: A(K%,P%) = W

	: NEXT P%

	: TAG%(J%) = TAG%(K%)

	: TAG%(K%) = T%

	: LOC%(T%)= LOC%(TAG%(J%))

	: L
OC%(TAG%(J%))= J%
12070	NEXT I%

	! REARRANGE ROWS
12080	TAG%(I%),LOC%(I%)=I% FOR I%=1% TO N%

	: FOR I% =1% TO N1%

	: T%=C%(I%)

	: J%= LOC%(T%)

	: K%= R%(I%)

	: GOTO 12090 IF J%=K%

	: FOR P%=1% TO N%

	: W=A(P%,J%)

	: A(P%,J%) = A(P%,K%)

	: A(P%,K%) = W

	: NEXT P%

	: TAG%(J%) = TAG%(K%)

	: TAG%(K%) =T%

	: LOC%(T%)=LOC%(TAG%(J%))

	: LOC%(TAG%(J%))= J%
12090	NEXT I%

	! REARRANGE COLUMN
12100	RETURN
32767	END


 