{$T- don't print symbol table for each procedure and function
 the above is the only compiler option in the entire program

                   ***************************************
                   *                                     *
                   } program nbspascalpcodeinterpreter;  { environment
                   *                                     * dependency
                   ***************************************

******************************************************************************
*                                                                            *
*         n b s   p a s c a l   p - c o d e   i n t e r p r e t e r          *
*         -----   -----------   -----------   ---------------------          *
*                                                                            *
*  This program interprets the P-code produced by Pass 1 of the NBS Pascal   *
*  compiler for the PDP-11 computer.  It is not intended for use directly    *
*  to interpret the p-code because it is extremely inefficient.  Its         *
*  primary objective is to describe the nbs pascal p-code machine clearly    *
*  so that it can be used as a tool in the transportation of nbs pascal to   *
*  other machines.  It therefore is an algorithmic specification (pdl        *
*  specification) of the p-code machine.                                     *
*                                                                            *
*  The development of this program was funded by:                            *
*                    The John Fluke Mfg. Co., Inc.                           *
*                    Box 43210                                               *
*                    Mountlake Terrace, WA 98043                             *
*                                                                            *
*                    (206)-774-2211 (main switchboard)                       *
*                    (206)-774-2381 (computer facilities)                    *
*                                                                            *
*  The initial development was performed by K.S. Bhaskar in Mar/Apr '79.     *
*  This interpreter corresponds to Version 1.5a of Pass 1 of the compiler.   *
*                                                                            *
*  Note:  This program was developed based on the nbs pascal compiler,       *
*  which is in the public domain.  Thus, while there is no legal obstacle    *
*  to anyone using this program for direct profit, it would be grossly       *
*  unethical to do so.  However, it would be ethical to produce and sell     *
*  software which can run under implementations of the interpreter.          *
*                                                                            *
*                                                                            *
*  History:                                                                  *
*  Version    Date      Perpetrator          Action                          *
*                                                                            *
*  1.1        6-Mar-79  K.S. Bhaskar         Initial Program Development     *
*  1.2       25-Apr-79  K.S. Bhaskar         Documentation Update            *
*                                                                            *
******************************************************************************
This program reads and interprets the P-code produced by Pass 1 of the
NBS Pascal compiler for the PDP-11.  It is written in NBS Pascal on a
PDP-11/70 under the RSTS/E Version 6C operating system.  Efforts are being
made to use a minimal subset of Pascal that is common to most Pascal
compilers, but this is not always possible.  Wherever such an implementation
dependency is suspected, the string "environment dependency" should be found
somewhere in the vicinity (for a procedure, the string will occur near the
header).

RSTS Usage: (all i/o to keyboard as per nbs pascal input and output files)

          -ccl entry:
                    <cclname> - <intfile> <datfile>
                    recommended ccl: NBSINT

          -via RUN command:
                    RUN <interpreter>
                    NBSINT>- <intfile> <datfile>
                      /|\
                       |
                    prompt

          -recommended extensions:
                    intfile: INT
                    datfile: DAT

Some features of the Pascal language (e.g. with statements) are not used
because of bugs in the nbs compiler.  Others are not supported for the same
reason.  See below.

Note that the nbs compiler is kludgy at times.  it implicitly assumes
that integersize = pointersize and booleansize = charsize.  consequently
pointers are often indistinguishable from integers and booleans are
indistinguishable from chaaracters.  this implies that at times this
author has been confused, and used booleansize for charsize and other
such (almost) inexcusable horrible things.  a thousand pardons, but ts.

Despite the striking similarity between the ISO Pascal standard and a
piece of Gruyere cheese, it is believed that a "conforming" processor will
accept this interpreter except as noted below.

The ISO standard Pascal specifies identifiers unique in the first 8
characters.  This condition is not met (all identifiers are unique in the
first 15 characters.

Two extensions of the "standard" Pascal language supported by the NBS compiler
are used for reasons of efficiency:  firstly structured constants are used
freely; secondly case statements where there are possibly undefined labels are
assumed to be null operations.

Note also that there is one semantic error in invokestandardprocedure because
of a bug in the nbs compiler.  It is well documented and the correct code is
specified.  It will be corrected when the compiler is corrected.  Note also
compiler bugs have resulted in inefficient code at times (see notes on
efficiency in implementations.  Furthermore, it is not possible to run large
programs through the interpreter because it makes a large number of procedure
calls, and a compiler bug causes the compiler to occasionally abort when
a large number of procedures have been called.  The interpreter has, however
been tested extensively on small programs.



A brief description of the p-code machine:

The nbs pascal p-code machine is not unlike a reverse Polish calculator,
except that it has statements (which can be looked upon as expressions that
have side effects and do not leave values on the operand stack.  Control
structures are a logical extension.  On a reverse Polish machine,
addition is expressed as <operand> <operand> <additionoperator>; the addition
operation is identical on the p-code machine.  The difference, however, is
that on a calculator, the rule for evaluation is to evaluate the operands
and then perform the operation and leave the result on the stack; in the
p-code machine, the rule for evaluation is determined by the operation
code (i.e. there is no automatic evaluation of all operands).  An additional
difference in style is the p-code uses the operand stack only for evaluated
results:  unevaluated "code" is stored as subtrees (see below).  This
difference is obvious since the calculator needs no conditional evaluation
or iteration per se.

The p-code machine "instruction" has the following fields, which are not all
used in all cases (in fact, some of the information is redundant and at any
given time, the same information may be available from several different
sources; this has been a source of obfuscation and frustration during the
development of the interpreter) (see definition of codenode in type):
        opcode : specifies action to be performed
        size   : size of the result (or, for a variable, parameter, etc.
                 the size of the item referred to) in "bytes" (a byte is a
                 unit of storage addressing) (pass 2 of the compiler uses
                 bits). most of the ambiguities concern the source of the
                 size information since the size is sometimes forced, etc.
        displacement : a field of miscellaneous information.  for variables,
                 specifies offset from a stackframe base, for literals
                 (immediate) quantities, the actual value, etc.
        segmentnumber : yet another miscellaneous field (mostly unused).
                 often specifies the lexical level (physical nesting or
                 static nesting) of the variable or procedure specified.
        argcount : a count of the number of arguments (operands) of the
                 "instruction"
        operands : the actual operands (e.g. left and right operands for
                 arithmetic operations, condition, then-clause and else-
                 clause for if statements, etc.)

the "processor status" specifies:
        -whether the result of the current "instruction" is to have the result
         loaded as a value or a result (only if applicable)
        -the size of the last result in bytes (or, if the last result was an
         address, then the size of the item referred to by the address)
        -the size the result is to be forced to (if possible)

the p-code machine is a recursive machine, and the concept of a program
counter is not defined.  it is, however, not needed.



a brief description of this program:

this program simulates the p-code machine in pascal.  the program (hopefully,
there will be little, if any, ambiguity with respect to the word "program",
since it could refer both to this program as well as to the program that the
simulated p-code machine will execute. in general, "this" program refers to
the interpreter, whereas "the" program refers to the program being
interpreted).  the program is passed as a file (which is read by readpcode,
so look there for information about the internal structure).  additionally,
some constants are passed in a datafile that is read by readconstsegment.  the
data is merely read and stored as a byte sequence.  in tight memory
situations, initialize, readpcode and readconstsegment can be overlaid, since
the reading of the program and the interpretation of the same do not need to
coexist.

the main simulation is performed by interpret (note that the arguments to
interpret are the recursive "processor status" values).  owing to the
limitation on the number of procedures imposed by the nbs compiler and as
an aid to clarity, interpret is implemented as a giant case statement that
splits the instructions into families.  Each family has a separate way
to split the instructions further and perform the simulation.  owing
to another bug in the compiler, the case variables for the case statements
in the families are not subranges, and this leads to inefficient storage
utilization.

memory is considered to be a series of 'bytes' starting with location
zero.  the nbs pascal compiler implicitly assumes that integersize =
pointersize and booleansize = charsize.  allocation is as follows:  2 bytes
per integer and 1 per character.  the layout is as follows:  locations
starting at zero are the global variable storage. after that is the constant
segment (the compiler allocates some constants (e.g. strings) in a data
segment which is allocated above the globals.  stack variables are allocated
starting at the top of data memory and the stack grows downwards.  the heap
is allocated above the data segment.  the variable stacklimit specifies the
top of he heap which is also the limit to which the stack can grow (thus,
allocating storage increments stacklimit and reduces the available space for
the stack.

variables, parameters are referred to by specifying an offset and a lexical
level.  the static links are maintained by displays.  each display has
the location of the stackframe base address for the latest invocation of
a procedure at the specified lexical level, and there is one display for each
permissible lexical level.  calling a procedure implies saving the display at
the called procedure's lexical level, loading the new valueand restoring the
old value upon return from the procedure.  this saving is performed on the
interpreter's dynamic stack rather than on that of the interpreted program,
but an implementation could implement it on either (using the programs stack
merely implies another item on the stack frame since the lexical level is
known at compile time).  note that this is only an implementation detail:
there is nothing in the nbs pascal machine that sepcifies that displays must
be used;  any technique that converts the pair (<lexicallevel>, <offset>)
consistently to an address is usable.

it is not deemed necessary to give details of how each operation is performed.
the code is self documenting and is far clearer than any verbal description
could possibly be after the above description.



how to implement an inefficient interpreter:

there are gross inefficiencies in this implementation, but there are no
redundancies (hopefully).  most of the overhead of the interpretation is not
in the interpretation itself, but rather in the fact that by changing one
parameter (the value of the constant debug) in the global const section, the
interpreter will write an autobiography as it executes, displaying relevant
values.  it is suggested that a global jump table used for interpret with
tight code sections for each opcode.  a problem with this is that the code
sections must be recursive, and should therefore be implemented as procedures.
this is inefficient.  note that the code in the interpreter (it is
suggested that you look at, say, integerbinaryops as you peruse this)
evaluates each operand, pops the value and then evaluates the next.  however,
if the result of the first is left on the operand stack, then the code
segment can be implemented with a much lower calling overhead since when the
time comes to pop the operand values and perform the actual arithmetic
no recursion is required and no local storage either because the operand stack
can probably be popped directly into a register at that time (a side benefit
is that registers needn't be saved because they will not contain values
(except perhaps return addresses and the like)).



features of the nbs dialect of pascal that are not supported:

    -with statements (because of a compiler bug)
    -case statements (insufficient information available to me and in the
     p-code resulting in a compiler bug) (i.e. lack of documentation and a
     compiler bug)
    -sets (they are poorly implemented in nbs pascal and the compiler has
     bugs)
    -reals (reals are partially implemented now, but their use is not possible
     because we do not have a floating point processor on the PDP-11.  when
     DEC installs it, reals will be implemented)
    -files (since files must be declared at compile time, and this means
     compile time of the interpreter).  this implies that regardless of
     file specifications, all i/o will be forced to input and output.

    some of these features may be supported in the future as the nbs compiler
    improves and as hardware becomes available.  note also that the nbs
    dialect is not always compatible with the mythical "standard" pascal.



Written by:  K.S. Bhaskar
             John Fluke Manufacturing Co.
             Box 43210
             Mountlake Terrace, WA 98043
             (206)-774-2381                                            }
{begin global data declarations}
const maxarg          = 255; {maximum number of arguments for opcode}
      debug           = false;
      datasegmentsize = 4095; {4K bytes for program data, stack and heap}
      maxstackaddress = 1 + datasegmentsize; {extra value is for empty stack}
      maxprocedures   = 120; {maximum number of procedures / functions }
      maxlexicallevel = 15; {maximum depth of procedure nesting}
      integersize     = 2; {enviornment dependency}
      realsize        = 8; {environment dependency} {??}
      booleansize     = 1; {environment dependency}
      charsize        = booleansize; {environment dependency}
      setsize         = 2; {environment dependency}
      filespecsize    = 27; {environment dependency} {RSTS filespec size + 1}
      intfilemode     = 4; {environment dependency}
      datfilemode     = 4; {environment dependency}
      nullch          = chr( 0 ); {environment dependency}
      identifiersize  = 15;
      maxoperandsize  = realsize; {assuming realsize >= integersize}
      mainprogram     = 0; {the main program is procedure #0}

      {the following are the pseudoops found in the p-code}

       nop     = 0;
       xch     = 1;
       del     = 2;
       ident   = 5;
       proc    = 6;
       endop   = 7;

      {The following define the opcodes of the P-code machine.  The
       definitions are environment dependent, but their being defined this
       way makes the definitions more clear and also more transportable
       conceptually.}

      {a few of the p-code mnemonics that conflict with pascal reserved words
       have been redefined by the addition of the suffix op}
       null    = 8;
       refer   = 9;
       stol    = 10;
       stor    = 11;
       stof    = 12;
       succop  = 16;
       predop  = 17;
       uceq    = 24;
       ucne    = 25;
       ucgt    = 26;
       ucle    = 27;
       ucge    = 28;
       uclt    = 29;
       umax    = 30;
       umin    = 31;
       iadd    = 32;
       isub    = 33;
       imul    = 34;
       idiv    = 35;
       imod    = 36;
       ineg    = 40;
       iabs    = 41;
       iodd    = 42;
       ceil    = 44;
       floor   = 45;
       iceq    = 56;
       icne    = 57;
       icgt    = 58;
       icle    = 59;
       icge    = 60;
       iclt    = 61;
       imax    = 62;
       imin    = 63;
       fadd    = 64;
       fsub    = 65;
       fmul    = 66;
       fdiv    = 67;
       fneg    = 72;
       fabs    = 73;
       floatop = 74;
       truncop = 75;
       roundop = 76;
       fceq    = 88;
       fcne    = 89;
       fcgt    = 90;
       fcle    = 91;
       fcge    = 92;
       fclt    = 93;
       fmax    = 94;
       fmin    = 95;
       notop   = 96;
       eqv     = 104;
       xor     = 105;
       nimp    = 106;
       rimp    = 107;
       imp     = 108;
       nrimp   = 109;
       orop    = 110;
       andop   = 111;
       compl   = 112;
       union   = 113;
       inter   = 114;
       sdiff   = 115;
       sgens   = 117;
       sadel   = 118;
       empty   = 119;
       sceq    = 120;
       scne    = 121;
       scgt    = 122;
       scle    = 123;
       scge    = 124;
       sclt    = 125;
       sin     = 126;
       sany    = 127;
       field   = 131;
       ofset   = 132;
       indir   = 133;
       index   = 134;
       movem   = 135;
       invok   = 138;
       rtemp   = 140;
       dtemp   = 141;
       ifop    = 144;
       caseop  = 145;
       entry   = 146;
       loopop  = 147;
       exitop  = 148;
       forop   = 149;
       seq     = 152;
       liter   = 162;
       rdata   = 163;
       litd    = 164;
       vceq    = 168;
       vcne    = 169;
       vcgt    = 170;
       vcle    = 171;
       vcge    = 172;
       vclt    = 173;
       varbl   = 176;
 {the basic varbl op-code is 176; however, the op-code mod 16 gives the
  lexical level and hence the following opcodes additionally are defined}
       varbl0  = 176;
       varbl1  = 177;
       varbl2  = 178;
       varbl3  = 179;
       varbl4  = 180;
       varbl5  = 181;
       varbl6  = 182;
       varbl7  = 183;
       varbl8  = 184;
       varbl9  = 185;
       varbl10 = 186;
       varbl11 = 187;
       varbl12 = 188;
       varbl13 = 189;
       varbl14 = 190;
       varbl15 = 191;
 {the same encoding of the lexical level applies to the param}
       param   = 192;
       param0  = 192;
       param1  = 193;
       param2  = 194;
       param3  = 195;
       param4  = 196;
       param5  = 197;
       param6  = 198;
       param7  = 199;
       param8  = 200;
       param9  = 201;
       param10 = 202;
       param11 = 203;
       param12 = 204;
       param13 = 205;
       param14 = 206;
       param15 = 207;
 {the same encoding of the lexical level applies to call}
       call    = 208;
       call0   = 208;
       call1   = 209;
       call2   = 210;
       call3   = 211;
       call4   = 212;
       call5   = 213;
       call6   = 214;
       call7   = 215;
       call8   = 216;
       call9   = 217;
       call10  = 218;
       call11  = 219;
       call12  = 220;
       call13  = 221;
       call14  = 222;
       call15  = 223;

type  {many of the following are very highly compiler dependent in order
       to make the interpreter efficient with respect to space usage}
      byte           = char; {environment dependency}
      opcodes        = nop..call15;
      operandsizes   = 0..maxoperandsize;
      address        = 0..datasegmentsize;
      datasegment    = array [ 0..datasegmentsize ] of byte;
      segmentnumbers = 0..maxlexicallevel;
      numberofargs   = 0..maxarg;
      code           = ^codenode;
      codenode       = record {environment dependency} {see note below}
                           opcode : opcodes;
                           size   : operandsizes;
                           displacement : address;
                           segmentnumber : segmentnumbers;
                           argcount : numberofargs;
                           operands : array [ 1..maxarg ] of code
                       end; {codenode}

{Note on codenode.  The NBS Pascal compiler uses an extended form of the
 new procedure to allocate variable length arrays dynamically.  To use
 the above under the mythical "standard" Pascal, operands can be implemented
 as a linked list.  Since this is so much more efficient, and since the aim
 of this interpreter is to be clear arther than transportable, and since the
 above is much clearer than a linked list, this technique and the language
 extension is used.  If your sense of aesthtics is offended, I apologize.}

      filespec       = array [ 1..filespecsize ] of char;
                             {environment dependency}
      errortype      = ( stackoverflow, stackunderflow, prematureeof,
                         notyetimplemented, stackargumentmismatch,
                         mainprogramcalled, heapoverflow );
      dataaddress    = 0..datasegmentsize;
      stackaddress   = 0..maxstackaddress;
      howtointerpret = ( noload, loadvalue, loadaddress );
      identifier     = array[ 1..identifiersize ] of char;
      procedurenumber  = 0..maxprocedures;
      programsegment = record
                           localdatasize  : dataaddress;
                           parametersize  : dataaddress;
                           instructions   : code;
                           lexicallevel   : segmentnumbers;
                           returnvaluesize: operandsizes;
                           name           : identifier;
                           internalflag   : boolean
                       end; {programsegment}
      entireprogram  = array[ procedurenumber ] of programsegment;
      staticlinks    = array[ segmentnumbers ] of stackaddress;

var   noerror : boolean; {set to false if error found while reading p-code}
      thisprogram : entireprogram;
      intfilename,
      datfilename : filespec;
      intfile,
      datfile : text;
      data : datasegment;
      stackpointer : stackaddress;
      display : staticlinks;
      stacklimit,
      constsegmentorigin, constsegmentsize : dataaddress;
      dummyoperandsize : operandsizes; {dummy operand used as write-only
                                        storage to match arguments to
                                        interpret}

{end global data declarations}

{Note on the stack: it is allocated from the top of the data segment and grows
downwards.  the globals are allocated from the bottom and grow up.  Dynamic
storage for new is allocated separately}
{begin utility procedures section}

procedure error( whaterror : errortype );
const messagelength    = 16;
      debug            = false; {error is debugged}
      attentionlength  = 6;
      beep             = chr( 7 ); {environment dependency}
type  errortext        = array[ 1..messagelength ] of char;
      errormessagelist = array[ errortype ] of errortext;
      attentionstring  = array[ 1..attentionlength ] of char;
const errormessages    = errormessagelist( 'stackoverflow   ',
              'stackunderflow  ', 'prematureeof    ', 'notyetimplemente',
              'stackargmismatch', 'mainprog.called ', 'heapoverflow    ' );
      attention        = attentionstring( beep, '*', '*', '*', '*', beep );
                              {structured constants} {environment dependency}
var   index : 1..messagelength;
begin {error}
    if debug then begin
        writeln( output, '>error ( ord = ', ord( whaterror ), ' )' );
        break( output ) end;
    writeln( output, attention, errormessages[ whaterror ], attention );
    break( output );
    noerror := false;
    if debug then begin
        writeln( output, '<error' );
        break( output ) end
end; {error}

{end utility procedures section}
procedure initialize;
{initialization of the assembler} {environment dependency}
const debug = false; {initialize is debugged, i hope}
      noofstringsoninput = 3; {argv can have 0..3 as index on ccl entry}
      firstfileoninput = 2; {argv[ 2 ]^ is first file on ccl entry}
      prompt = 'NBSINT>';

var   i : firstfileoninput..noofstringsoninput;
      tempch : char; {for efficiency}

function syntacticblank( onech : char ) : boolean; {environment dependency}
{decides if a character (on the command stream) is syntactically blank}
const blank = ' ';
      tab   = chr( 9 ); {environment dependency}
var   temp : boolean; {for easy debugging}
begin {syntacticblank}
    if debug then begin
        writeln( output, '>syntacticblank', '( ''', onech : 1, ''' )' );
        break( output ) end;
    temp := ( onech = blank ) or ( onech = tab );
    syntacticblank := temp;
    if debug then begin
        write( output, '<syntacticblank: ' );
        if temp then
            writeln( output, 'true' )
        else
            writeln( output, 'false' );
        break( output ) end
end; {syntacticblank}
function endofline( onech : char ) : boolean; {environment dependency}
{decides if the next character is a logical end of line on RSTS}
const linefeed       = chr( 10 );
      carriagereturn = chr( 13 );
      escape         = chr( 27 );
      controlz       = chr( 26 );
      formfeed       = chr( 12 );
var   temp : boolean; {used for ease in debugging}
begin {endofline}
    if debug then begin
        writeln( output, '>endofline ( ''', onech : 1, ''' )' );
        break( output ) end;
    temp := ( onech = linefeed ) or ( onech = carriagereturn ) or
            ( onech = escape ) or ( onech = controlz ) or
            ( onech = formfeed );
    endofline := temp;
    if debug then begin
        write( output, '<endofline: ' );
        if temp then
            writeln( output, 'true' )
        else
            writeln( output, 'false' );
        break( output ) end
end; {endofline}
procedure options;
{initialize options} {environment dependency}

procedure nextoption;
{process next option from input}
begin {nextoption}
    if debug then begin
        writeln( output, '>nextoption' );
        break( output ) end;
    if debug then begin
        writeln( output, '<nextoption' );
        break( output ) end
end; {nextoption}
begin {options}
    if debug then begin
        writeln( output, '>options' );
        break( output ) end;
    if argc <> 0 then begin
        if argv[ 1 ]^[ 0 ] = '-' then begin
            i := 1;
            tempch := argv[ 1 ]^[ 1 ];
            while tempch <> nullch do begin
                nextoption;
                i := i + 1;
                tempch := argv[ 1 ]^[ i ] end end end
    else begin
        repeat
            read( input, tempch )
        until tempch = '-';
        read( input, tempch );
        while not syntacticblank( tempch ) do begin
            nextoption;
            read( input, tempch ) end end;
    if debug then begin
        writeln( output, '<options' );
        break( output ) end
end; {options}
procedure getnextfilespec( var filename : filespec );
{get next file specification from input} {environment dependency}
var   j, {index into filespec string}
      debugj : integer;
begin {getnextfilespec}
    if debug then begin
        writeln( output, '>getnextfilespec' );
        break( output ) end;
    if argc <> 0 then begin
        j := -1;
        repeat
            j := j + 1;
            filename[ j + 1 ] := argv[ i ]^[ j ]
        until argv[ i ]^[ j ] = nullch end
    else begin
        repeat
            read( input, tempch )
        until not ( syntacticblank( tempch ) or endofline( tempch ));
        j := 1;
        repeat
            filename[ j ] := tempch;
            read( input, tempch );
            j := j + 1
        until syntacticblank( tempch ) or endofline( tempch );
        filename[ j ] := nullch end;
    if debug then begin
        write( output, '<getnextfilespec: ''' );
        for debugj := 1 to j - 1 do write( output, filename[ debugj ]);
        writeln( output, '''' );
        break( output ) end
end; {getnextfilespec}
begin {initialize}
    if debug then begin
        writeln( output, '>initialize' );
        break( output ) end;
    if argc = 0 then write( output, prompt );
    break( output );
    options;
    i := firstfileoninput;
    getnextfilespec( intfilename );
    reset( intfile, intfilename, intfilemode );
    i := succ( i );
    getnextfilespec( datfilename );
    reset( datfile, datfilename, datfilemode );
    stackpointer := maxstackaddress;
    if debug then begin
        writeln( output, '<initialize' );
        break( output ) end
end; {initialize}
procedure readpcode; {environment dependency}
{this procedure reads the p-code from a file and builds up the program in its
internal form, processing pseudo-ops as it does so.  unlike pass 2 of the nbs
compiler, processes 1 procedure at a time, the interpreter must be able to
read and store all procedures.  hence code is stored in trees with each tree
rooted as an array element}

{this procedure has been copied over almost verbatim from pass 2 of the
compiler.  it is rather heavily environment dependent because of the file
formats; however, it should be one of the easiest to transport}

const tempstacksize = 256; {temporary stack to convert RPN format input to
                            tree structure}
      pseudooplimit = 7;
      blankname = '               ';
      newprocedurecode = 4; {# of standard procedure "new"}
      longrealfunctionlimit = 100; {all std. procs. with #s > 100 are assumed
                                     to be long real functions}
      mainprogramread = 0;
      internal = 0;
      columnsperlevel = 4; {used in dumping pcode}

type  codestack = array[ 1..tempstacksize ] of code;
      codestackindex = 0..tempstacksize; {0 is for empty stack}

var   tempstack : codestack;
      coden : opcodes;
      addrn : address;
      debugargn, argn : numberofargs;
      sizen : operandsizes;
      segn : segmentnumbers;
      temp,
      temptree : code;
      debugindex, tempindex : codestackindex;
      currentlexicallevel : segmentnumbers;
      currentname : identifier;
      currentnamesize : integer;
      currentinternalflag : boolean;
      currentprocedurenumber : procedurenumber;

function getbyte : byte; {environment dependency}
const debug = false; {getbyte is debugged}
var   temp : byte;
begin {getbyte}
    if debug then begin
        writeln( output, '>getbyte' );
        break( output ) end;
    if eof( intfile ) then
        error( prematureeof )
    else begin
        temp := intfile^;
        getbyte := temp;
        get( intfile ) end;
    if debug then begin
        writeln( output, '<getbyte: ord = ', ord( temp ));
        break( output ) end
end; {getbyte}
function getword : integer; {environment dependency}
                            {note that the byte order is the reverse of that
                             of the PDP-11.  this is confusing}
const bytevalue = 256; {environment dependency}
      debug     = false; {getword is debugged}
var   temp : integer;
begin {getword}
    if debug then begin
        writeln( output, '>getword' );
        break( output ) end;
    if eof( intfile ) then
        error( prematureeof )
    else begin
        temp := ord( intfile^ ) * bytevalue;
        get( intfile );
        if eof( intfile ) then
            error( prematureeof )
        else begin
            temp := ord( intfile^ ) + temp;
            getword := temp;
            get( intfile ) end end;
    if debug then begin
        writeln( output, '<getword : ', temp );
        break( output ) end
end; {getword}
procedure allocatecodenode( var pointer : code; operandcount : numberofargs );
const debug             = false; {this procedure is debugged}
      maxarray          = maxarg + 4;
type  allocationunit    = integer; {environment dependency}
      dummycode         = ^dummycodenode;
      dummycodenode     = record
                              dummy : allocationunit;
                              dummyoperands : array[ 1..maxarray ] of
                                  allocationunit
                          end; {dummycodenode}
      codekludge        = record
                              case boolean of
                                  true  : ( codepointer : code );
                                  false : ( altpointer  : dummycode )
                          end; {codekludge}
var   kludge : codekludge;
      superkludge : dummycode;
      kludgecount : 0..maxarray;
begin {allocatecodenode}
    if debug then begin
        writeln( output, '>allocatecodenode ( ', operandcount, ' )' );
        break( output ) end;
    kludgecount := operandcount + 4;
    new( superkludge, kludgecount ); {environment dependency}
    kludge . altpointer := superkludge;
    pointer := kludge . codepointer;
    if debug then begin
        writeln( output, '<allocatecodenode : ', kludge . codepointer );
        break( output ) end
end; {allocatecodenode}
procedure dumppcode( node : code; skip : integer ); {dumps pcode tree node}
const blank          = ' ';
      pointersize    = 8; {environment dependency} {# of digits in pointer}
      otherfieldsize = 6; {environment dependency}
      debug          = false; {dumppcode is debugged}
var   index1, count : numberofargs;
      index2 : integer;
begin
    if debug then begin
        writeln( output, '>dumppcode' );
        break( output ) end;
    if node <> nil then begin
        for index2 := 1 to skip do write( output, blank );
        write( output, node : pointersize ); {environment dependency}
                                   {nbs pascal allows
                                    a pointer to be written.  this is used
                                    STRICTLY for debugging ONLY}
        count := node^ . argcount;
        write( output, ord( node^ . opcode ) : otherfieldsize,
                       ord( node^ . size ) : otherfieldsize,
                       ord( node^ . displacement ) : otherfieldsize,
                       ord( node^ . segmentnumber ) : otherfieldsize,
                       ord( count ) : otherfieldsize );
        for index1 := 1 to count do
            write( output, node^ . operands[ index1 ] : pointersize );
                                              {environment dependency}
        writeln( output );
        break( output );
        index1 := 1;
        while index1 <= count do begin
            dumppcode( node^ . operands[ index1 ], skip + columnsperlevel );
            index1 := succ( index1 ) end end;
        {the above used to be a for loop identical to the previous for loop,
         but some obscure bug made it into a loop forever (or other long
         time, so it has been replaced by a while loop}
    if debug then begin
        writeln( output, '<dumppcode' );
        break( output ) end
end; {dumppcode}
begin {readpcode}
    if debug then begin
        writeln( output, '>readpcode' );
        break( output ) end;
    tempindex := 0; {initialize tempstack to empty}
    currentlexicallevel := 0;
    repeat
        coden := ord( getbyte );
        if coden > pseudooplimit then begin
            if coden = null then
                temptree := nil
            else begin {assert opcode not a pseudoop and not null}
                segn := 0;
                addrn := 0;
                sizen := 0;
                argn := 0;
                case coden of
                    varbl0, varbl1, varbl2, varbl3, varbl4, varbl5, varbl6,
                    varbl7, varbl8, varbl9, varbl10, varbl11, varbl12,
                    varbl13, varbl14, varbl15,
                    param0, param1, param2, param3, param4, param5, param6,
                    param7, param8, param9, param10, param11, param12,
                    param13, param14, param15 : begin
                        segn := coden mod 16; {segn = lexicallevel}
                        sizen := ord( getbyte );
                        addrn := getword;
                        if coden >= param then {assert coden <= param15 also}
                            coden := param {remove encoded lex level}
                        else {assert coden in [varbl0..varbl15]}
                            coden := varbl end; {remove encoded lex level}
                    liter, rdata : addrn := getword;
                    litd : begin
                        write( output, coden );
                        error( notyetimplemented ) end;
                    rtemp, dtemp : begin
                        addrn := getword;
                        if coden = dtemp then
                            argn := 2;
                        write( output, coden );
                        error( notyetimplemented ) end;
                    field, ofset, indir, index, movem, vceq, vcne, vcgt,
                    vcle, vcge, vclt : begin
                        sizen := ord( getbyte );
                        addrn := getword;
                        if coden >= index then
                            argn := 2
                        else
                            argn := 1 end;
                    entry, loopop, seq :
                        argn := succ( ord( getbyte ));
                    invok, caseop : begin
                        argn := ord( getbyte );
                        addrn := ord( getbyte ); {caution: unusual}
                        if coden = invok then
                            if addrn = newprocedurecode then
                                sizen := 2
                            else if addrn > longrealfunctionlimit then
                               sizen := 8 end;
                        {note that the address specifies which proc / func
                        is to be invoked, and those with #s > 100 are floating
                        and return longreal values always}
                    call0, call1, call2, call3, call4, call5, call6, call7,
                    call8, call9, call10, call11, call12, call13, call14,
                    call15 : begin
                        segn := coden mod 16;
                        sizen := ord( getbyte );
                        addrn := ord( getbyte );
                        argn := ord( getbyte );
                        coden := call end; {remove encoded lex level}
                    forop : argn := 5;
                    ifop : argn := 3;
                    stol, stof, uceq, ucne, ucgt, ucle, ucge, uclt, umax,
                    umin, iadd, isub, imul, idiv, imod, ceil, floor,
                    iceq, icne, icgt, icle, icge, iclt, imax, imin,
                    fadd, fsub, fmul, fdiv, fceq, fcne, fcgt, fcle,
                    fcge, fclt, fmax, fmin, eqv, xor, nimp, rimp, imp,
                    nrimp, orop, andop, union, inter, sdiff, sadel,
                    sceq, scne, scgt, scle, scge, sclt, sin, exitop : begin
                        argn := 2;
                        sizen := 2 end;
                    refer, succop, predop, ineg, iabs, iodd, fneg, fabs,
                    floatop, truncop, roundop, notop, compl, sgens, sany :
                        begin argn := 1;
                        sizen := 2 end
                end; {case coden of ...}
                allocatecodenode( temptree, argn );
                temptree^ . opcode := coden;
                temptree^ . size := sizen;
                                   {this differs from the nbs pascal compiler
                                    which stores as # of bits.  this is the
                                    number of bytes}
                temptree^ . displacement := addrn;
                temptree^ . segmentnumber := segn;
                temptree^ . argcount := argn;
                if tempindex < argn then begin
                    error( stackargumentmismatch );
                    argn := 0 end; {environment dependency}
                while argn > 0 do begin
                    temptree^ . operands[ argn ] := tempstack[ tempindex ];
                    argn := pred( argn );
                    tempindex := pred( tempindex ) end end;
            if tempindex > tempstacksize then error( stackoverflow );
            tempindex := succ( tempindex );
            tempstack[ tempindex ] := temptree;
            temptree := nil end
        else {assert coden in pseudoops}
            case coden of
                xch : begin {swap top 2 elements on tempstack}
                    temp := tempstack[ tempindex ];
                    tempstack[ tempindex ] := tempstack[ pred( tempindex )];
                    tempstack[ pred( tempindex )] := temp end;
                del : if tempindex > 0 then
                        tempindex := pred( tempindex )
                    else
                        error( stackunderflow );
                ident : begin
                    argn := ord( getbyte );
                    currentnamesize := 0;
                    currentname := blankname;
                    while argn > 0 do begin
                        if currentnamesize < identifiersize then
                            currentnamesize := succ( currentnamesize );
                        currentname[ currentnamesize ] := getbyte;
                        argn := pred( argn ) end end;
                proc : begin
                    currentlexicallevel := succ( currentlexicallevel );
                    currentinternalflag := ord( getbyte )= internal end;
                endop : begin
                    if tempindex <> 1 then error( stackargumentmismatch );
                    currentprocedurenumber := ord( getbyte );
                    thisprogram[ currentprocedurenumber ] . returnvaluesize
                            := ord( getbyte );
                    thisprogram[ currentprocedurenumber ] . localdatasize
                            := getword;
                    thisprogram[ currentprocedurenumber ] . parametersize
                            := getword;
                    constsegmentsize := getword; {as of this procedure}
                    thisprogram[ currentprocedurenumber ] . instructions
                            := tempstack[ tempindex ];
                    thisprogram[ currentprocedurenumber ] . lexicallevel
                            := currentlexicallevel;
                    thisprogram[ currentprocedurenumber ] . name
                            := currentname;
                    thisprogram[ currentprocedurenumber ] . internalflag
                            := currentinternalflag;
                    if debug then begin
                        write( output, 'Proc #: ', currentprocedurenumber,
                                '; name: "', currentname,
                                '" lex. level= ', currentlexicallevel,
                                '; ret. val. size= ', thisprogram
                                [ currentprocedurenumber ] . returnvaluesize,
                                '; localdatasize= ', thisprogram
                                [ currentprocedurenumber ] . localdatasize,
                                '; parametersize= ', thisprogram
                                [ currentprocedurenumber ] . parametersize );
                        if currentinternalflag then
                            writeln( output, '; internal' )
                        else begin
                            write( output, '; external' );
                            error( notyetimplemented ) end;
                        dumppcode( thisprogram[ currentprocedurenumber ] .
                                instructions, pred( currentlexicallevel )
                                * columnsperlevel ) end;
                    tempindex := pred( tempindex );
                    currentlexicallevel := pred( currentlexicallevel ) end
            end {case coden of...}
    until not( noerror ) or ( currentlexicallevel = mainprogramread );
    constsegmentorigin := thisprogram[ mainprogram ] . localdatasize;
    stacklimit := constsegmentorigin + constsegmentsize;
    display[ thisprogram[ mainprogram ] . lexicallevel ] := 0;
    if debug then begin
        writeln( output, '<readpcode' );
        break( output ) end
end; {readpcode}
procedure readconstsegment;
{the compiler stores some constants in a constant segment.  that becomes
 the datfile.  it is read and stored in the constant segment located directly
 above the globals}
var   currentlocation : address;
begin {readconstsegment}
    if debug then begin
        writeln( output, '>readconstsegment' );
        break( output ) end;
    for currentlocation := constsegmentorigin to
            pred( constsegmentorigin + constsegmentsize ) do begin
        data[ currentlocation ] := datfile^;
        get( datfile ) end;
    if debug then begin
        writeln( output, '<readconstsegment' );
        break( output ) end
end; {readconstsegment}
procedure interpret( instruction : code; interpretmode : howtointerpret;
                 var finalsize : operandsizes; sizetoforce : operandsizes );

{ This is the main interpreter.  It assumes that the program is a correct
 well formed P-code program (see note on P-code machine architecture).
 It determines the op-code at the node and causes the appropriate action
 to be taken.  Under no circumstances should this be invoked if there are
 errors in the P-code (since there is no checking, some horrible
 death may befall the program). }

{Interpretation can occur in several ways: the value resulting from an op-code
 can be loaded, an address can be loaded, or perhaps nothing is to be loaded.
 In most cases, it is permissible to load only a value, and the quantity
 interpretmode is not checked at all.  However, in a few cases (e.g. the
 varbl op-code, either could be loaded.  In such cases, the mode is used
 to control the interpreter's actions.}

{The stack grows down from the top of the data segment.  Globals are
 allocated from the bottom}

{the variable finalsize is unused in most cases (in fact the variable used
 in the call to interpret from the main program is a write-only variable).
 however, under certain circumstances (e.g. when a for opcode is being
 executed), it is needed to specify the size of the item on the top
 of the operand stack or, if the item is an address, then the size of the
 item being referred to}

{the parameter sizetoforce specifies what size of operand is to be forced
 onto the stack.  this is because the nbs compiler is kludgy and, for example,
 boolean values are indistinguishable from integer values in the literal
 node.  consequently, when a boolean literal is encountered, without
 a size to force, 2 bytes are forced and 1 popped later, giving erroneous
 results}

procedure pop( howmanybytes : integer ); {pops operand stack}
begin {pop}
    if debug then begin
        writeln( output, '>pop ( ', howmanybytes, ' )' );
        break( output ) end;
    stackpointer := stackpointer + howmanybytes;
    if stackpointer > maxstackaddress then begin
        error( stackunderflow );
        stackpointer := stackpointer - howmanybytes end;
    if debug then begin
        writeln( output, '<pop : ', stackpointer );
        break( output ) end
end; {pop}
procedure newstack( howmanybytes : integer );
{allocates space on operand stack}
{remember that the stack grows down from the top}
begin {newstack}
    if debug then begin
        writeln( output, '>newstack ( ', howmanybytes, ' )' );
        break( output ) end;
    stackpointer := stackpointer - howmanybytes;
    if stackpointer < stacklimit then begin
        error( stackoverflow );
        stackpointer := stackpointer + howmanybytes end;
    if debug then begin
        writeln( output, '<newstack : ', stackpointer );
        break( output ) end
end; {newstack}
function popinteger : integer; {environment dependency}
{interprets top of stack as an integer returns value and pops stack}
type  integerkludge = record {environment dependency}
                        case boolean of
                            true : ( integervalue : integer );
                            false : ( bytevalue : array[ 1..integersize ]
                                        of byte )
                      end; {integerkludge}
var   kludge : integerkludge;
begin
    if debug then begin
        writeln( output, '>popinteger' );
        break( output ) end;
    kludge . bytevalue[ 1 ] := data[ stackpointer ];
    kludge . bytevalue[ 2 ] := data[ stackpointer + 1 ];
    popinteger := kludge . integervalue;
    pop( integersize );
    if debug then begin
        writeln( output, '<popinteger: ', kludge . integervalue );
        break( output ) end
end; {popinteger}
function popboolean : boolean; {environment dependency}
{interprets top of stack as boolean and returns value}
type booleankludge = record {environment dependency}
                        case boolean of
                            true : ( booleanvalue : boolean );
                            false : ( bytevalue : byte )
                     end; {booleankludge}
var  kludge : booleankludge;
begin {popboolean}
    if debug then begin
        writeln( output, '>popboolean' );
        break( output ) end;
    kludge . bytevalue := data[ stackpointer ];
    popboolean := kludge . booleanvalue;
    finalsize := booleansize;
    pop( booleansize );
    if debug then begin
        write( output, '<popboolean: ' );
        if kludge . booleanvalue then
            writeln( output, 'true' )
        else
            writeln( output, 'false' );
        break( output ) end
end; {popboolean}
function popchar : char; {environment dependency}
{interprets top of stack as char and returns value}
type charkludge = record {environment dependency}
                        case boolean of
                            true : ( charvalue : char );
                            false : ( bytevalue : byte )
                  end; {charkludge}
var  kludge : charkludge;
begin {popchar}
    if debug then begin
        writeln( output, '>popchar' );
        break( output ) end;
    kludge . bytevalue := data[ stackpointer ];
    popchar := kludge . charvalue;
    finalsize := charsize;
    pop( charsize );
    if debug then begin
        writeln( output, '<popchar: ''', kludge . charvalue, '''' );
        break( output ) end
end; {popchar}
function popreal : real; {environment dependency}
{returns top of stack as real; stack popped}
type  realkludge = record {environment dependency}
                    case boolean of
                        true : ( realvalue : real );
                        false : ( bytevalue : array[ 1..realsize ] of byte )
                   end; {realkludge}
var   kludge : realkludge;
      index : 1..realsize;
begin {popreal}
    if debug then begin
        writeln( output, '>popreal' );
        break( output ) end;
    for index := 1 to realsize do
        kludge . bytevalue[ index ] := data[ stackpointer + index - 1 ];
    popreal := kludge . realvalue;
    finalsize := realsize;
    pop( realsize );
    if debug then begin
        writeln( output, '<popreal: ', kludge . realvalue );
        break( output ) end
end; {popreal}
procedure pushchar( valuetopush : char );
forward;



procedure pushinteger( valuetopush : integer ); {environment dependency}
{push integer value on stack}
type integerkludge = record {environment dependency}
                        case boolean of
                            true : ( integervalue : integer );
                            false : ( bytevalue : array[ 1..integersize ] of byte )
                     end; {integerkludge}
var  kludge : integerkludge;
begin {pushinteger}
    if debug then begin
        writeln( output, '>pushinteger ( ', valuetopush, ' )' );
        break( output ) end;
    if ( sizetoforce = 0 ) or ( sizetoforce = integersize ) then begin
        newstack( integersize );
        kludge . integervalue := valuetopush;
        data[ stackpointer ] := kludge . bytevalue[ 1 ];
        data[ stackpointer + 1 ] := kludge . bytevalue[ 2 ];
        finalsize := integersize end
    else {assume chr function}  {program bugs may blow up here}
        pushchar( chr( valuetopush ));
    if debug then begin
        writeln( output, '<pushinteger' );
        break( output ) end
end; {pushinteger}
procedure pushboolean( valuetopush : boolean ); {environment dependency}
type  booleankludge = record {environment dependency}
                        case boolean of
                            true : ( booleanvalue : boolean );
                            false : ( bytevalue : byte )
                      end; {booleankludge}
var  kludge : booleankludge;
begin {pushboolean}
    if debug then begin
        write( output, '>pushboolean ( ' );
        if valuetopush then
            write( output, 'true' )
        else
            write( output, 'false' );
        writeln( output, ' )' );
        break( output ) end;
    if ( sizetoforce = 0 ) or ( sizetoforce = booleansize ) then begin
        newstack( booleansize );
        kludge . booleanvalue := valuetopush;
        data[ stackpointer ] := kludge . bytevalue;
        finalsize := booleansize end
    else {assume ord function} {bugs may blow up here}
        pushinteger( ord( valuetopush ));
    if debug then begin
        writeln( output, '<pushboolean' );
        break( output ) end
end; {pushboolean}
procedure pushchar{( valuetopush : char )}; {environment dependency}
{previously declared forward}
type  charkludge = record {environment dependency}
                        case boolean of
                            true : ( charvalue : char );
                            false : ( bytevalue : byte )
                   end; {charkludge}
var  kludge : charkludge;
begin {pushchar}
    if debug then begin
        writeln( output, '>pushchar ( ''', valuetopush, '''' );
        break( output ) end;
    if ( sizetoforce = 0 ) or ( sizetoforce = charsize ) then begin
        newstack( charsize );
        kludge . charvalue := valuetopush;
        data[ stackpointer ] := kludge . bytevalue;
        finalsize := charsize end
    else {assume ord function} {program bugs may blow up here}
        pushinteger( ord( valuetopush ));
    if debug then begin
        writeln( output, '<pushchar' );
        break( output ) end
end; {pushchar}
procedure pushreal( valuetopush : real ); {environment dependency}
type  realkludge = record {environment dependency}
                     case boolean of
                        true : ( realvalue : real );
                        false : ( bytevalue : array[ 1..realsize ] of byte )
                   end; {realkludge}
var  kludge : realkludge;
     index : 1..realsize;
begin {pushreal}
    if debug then begin
        writeln( output, '>pushreal ( ', valuetopush, ' )' );
        break( output ) end;
    newstack( realsize );
    kludge . realvalue := valuetopush;
    for index := 1 to realsize do
        data[ stackpointer + index - 1 ] := kludge . bytevalue[ index ];
    finalsize := realsize;
    if debug then begin
        writeln( output, '<pushreal' );
        break( output ) end
end; {pushreal}
procedure reference; {here be dragons}
{documentation on this is nonexistent.  consequently, this is being
 implemented by inference with many guesses. no warranty is either implied
 or expressed as to the correctness or incorrectness of this and similar
 procedures}

{it seems to be used to force the top of the stack to be an address rather
 than a variable}

begin {reference}
    if debug then begin
        writeln( output, '>reference' );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadaddress,
                dummyoperandsize, integersize );
    if debug then begin
        writeln( output, '<reference' );
        break( output ) end
end; {reference}
procedure store;
type  bytecount    = operandsizes;
var   bytestocopy,
      dataoffset : bytecount;
      toaddress : address;

begin {store}
    if debug then begin
        writeln( output, '>store' );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadaddress, bytestocopy,
            integersize );
    toaddress := popinteger;
    interpret( instruction^ . operands[ 2 ], loadvalue, dummyoperandsize,
            bytestocopy );
    for dataoffset := 0 to pred( bytestocopy ) do
        data[ toaddress + dataoffset ] := data[ stackpointer + dataoffset ];
    pop( bytestocopy );
    if debug then begin
        writeln( output, '<store' );
        break( output ) end
end; {store}
procedure succoppredop;
var   itemsize : operandsizes;
begin {succoppredop}
    if debug then begin
        writeln( output, '>succoppredop' );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, itemsize, 0 );
    if itemsize = charsize then
        if instruction^ . opcode = succop then
            pushchar( succ( popchar ))
        else
            pushchar( pred( popchar ))
    else
        if instruction^ . opcode = succop then
            pushinteger( succ( popinteger ))
        else
            pushinteger( pred( popinteger ));
    if debug then begin
        writeln( output, '<succoppredop' );
        break( output ) end
end; {succoppredop}
procedure unsignedcompare;
var   leftoperand, rightoperand : byte;
begin {unsignedcompare}
    if debug then begin
        writeln( output, '>unsignedcompare' );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize,
            charsize );
    leftoperand := popchar;
    interpret( instruction^ . operands[ 2 ], loadvalue, dummyoperandsize,
            charsize );
    rightoperand := popchar;
    case instruction^ . opcode of {assert instruction^.opcode in [uceq..uclt]}
        uceq : pushboolean( leftoperand = rightoperand );
        ucne : pushboolean( leftoperand <> rightoperand );
        ucgt : pushboolean( leftoperand > rightoperand );
        ucle : pushboolean( leftoperand <= rightoperand );
        ucge : pushboolean( leftoperand >= rightoperand );
        uclt : pushboolean( leftoperand < rightoperand )
    end; {case}
    if debug then begin
        writeln( output, '<unsignedcompare' );
        break( output ) end
end; {unsignedcompare}
procedure unsignedmaxmin;
var   leftoperand, rightoperand : byte;
begin {unsignedmaxmin}
    if debug then begin
        writeln( output, '>unsignedmaxmin' );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize,
            charsize );
    leftoperand := popchar;
    interpret( instruction^ . operands[ 2 ], loadvalue, dummyoperandsize,
            charsize );
    if ( instruction^ . opcode = umax ) = ( leftoperand > rightoperand ) then
        pushchar( leftoperand )
    else
        pushchar( rightoperand );
    if debug then begin
        writeln( output, '<unsignedmaxmin' );
        break( output ) end
end; {unsignedmaxmin}
procedure integerbinaryops;
var   leftoperand,
      rightoperand : integer;
begin {integerbinaryops}
    if debug then begin
        writeln( output, '>integerbinaryops : ', instruction^ . opcode );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize,
            integersize );
    leftoperand := popinteger;
    interpret( instruction^ . operands[ 2 ], loadvalue, dummyoperandsize,
            integersize );
    rightoperand := popinteger;
    case instruction^ . opcode of
        {assert opcode in [iadd, isub, imul, idiv, imod, imax, imin]}
        iadd : pushinteger( leftoperand + rightoperand );
        isub : pushinteger( leftoperand - rightoperand );
        imul : pushinteger( leftoperand * rightoperand );
        idiv : pushinteger( leftoperand div rightoperand );
        imod : pushinteger( leftoperand mod rightoperand );
        imax : if leftoperand > rightoperand then
                pushinteger( leftoperand )
            else
                pushinteger( rightoperand );
        imin : if leftoperand < rightoperand then
                pushinteger( leftoperand )
            else
                pushinteger( rightoperand )
    end {case};
    if debug then begin
        writeln( output, '<integerbinaryops' );
        break( output ) end
end; {integerbinaryops}
procedure integerunaryops;
begin {integerunaryops}
    if debug then begin
        writeln( output, '>integerunaryops : ', instruction^ . opcode );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize,
            integersize );
    if instruction^ . opcode = ineg then
        pushinteger( -popinteger )
    else {assert opcode = iabs }
        pushinteger( abs( popinteger ));
    if debug then begin
        writeln( output, '<integerunaryops' );
        break( output ) end
end; {integerunaryops}
procedure integerodd;
begin {integerodd}
    if debug then begin
        writeln( output, '>integerodd' );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize,
            integersize );
    pushboolean( odd( popinteger ));
    if debug then begin
        writeln( output, '<integerodd' );
        break( output ) end
end; {integerodd}
procedure integercompare;
var   leftoperand,
      rightoperand : integer;
begin {integercompare};
    if debug then begin
        writeln( output, '>integercompare : ', instruction^ . opcode );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize,
            integersize );
    leftoperand := popinteger;
    interpret( instruction^ . operands[ 2 ], loadvalue, dummyoperandsize,
            integersize );
    rightoperand := popinteger;
    case instruction^ . opcode of {assert instruction^.opcode in [iceq..iclt]}
        iceq : pushboolean( leftoperand = rightoperand );
        icne : pushboolean( leftoperand <> rightoperand );
        icgt : pushboolean( leftoperand > rightoperand );
        icle : pushboolean( leftoperand <= rightoperand );
        icge : pushboolean( leftoperand >= rightoperand );
        iclt : pushboolean( leftoperand < rightoperand )
    end {case};
    if debug then begin
        writeln( output, '<integercompare' );
        break( output ) end
end; {integercompare}
procedure floatingbinaryops;
var   leftoperand,
      rightoperand : real;
begin {floatingbinaryops}
    if debug then begin
        writeln( output, '>floatingbinaryops : ', instruction^ . opcode );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize,
            realsize );
    leftoperand := popreal;
    interpret( instruction^ . operands[ 2 ], loadvalue, dummyoperandsize,
            realsize );
    rightoperand := popreal;
    case instruction^ . opcode of
        {assert opcode in [fadd, fsub, fmul, fdiv, fmax, fmin]}
        fadd : pushreal( leftoperand + rightoperand );
        fsub : pushreal( leftoperand - rightoperand );
        fmul : pushreal( leftoperand * rightoperand );
        fdiv : pushreal( leftoperand / rightoperand );
        fmax : if leftoperand > rightoperand then
                pushreal( leftoperand )
            else
                pushreal( rightoperand );
        fmin : if leftoperand < rightoperand then
                pushreal( leftoperand )
            else
                pushreal( rightoperand )
        end {case};
    if debug then begin
        writeln( output, '<floatingbinaryops' );
        break( output ) end
end; {floatingbinaryops}
procedure floatingunaryops;
begin {floatingunaryops}
    if debug then begin
        writeln( output, '>floatingunaryops : ', instruction^ . opcode );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize,
            realsize );
    if instruction^ . opcode = fneg then
        pushreal( -popreal )
    else {assert opcode = fabs}
        pushreal( abs( popreal ));
    if debug then begin
        writeln( output, '<floatingunaryops' );
        break( output ) end
end; {floatingunaryops}
procedure integertofloating;
begin {integertofloating}
    if debug then begin
        writeln( output, '>integertofloating' );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize,
            integersize );
    pushreal( float( popinteger ));
    if debug then begin
        writeln( output, '<integertofloating' );
        break( output ) end
end; {integertofloating}
procedure floatingtointeger;
begin {floatingtointeger}
    if debug then begin
        writeln( output, '>floatingtointeger : ', instruction^ . opcode );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize,
            realsize );
    if instruction^ . opcode = truncop then
        pushinteger( trunc( popreal ))
    else {assert instruction^.opcode = round}
        pushinteger( round( popreal ));
    if debug then begin
        writeln( output, '<floatingtointeger' );
        break( output ) end
end; {floatingtointeger}
procedure floatingcompare;
var   leftoperand,
      rightoperand : real;
begin {floatingcompare};
    if debug then begin
        writeln( output, '>floatingcompare : ', instruction^ . opcode );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize,
            realsize );
    leftoperand := popreal;
    interpret( instruction^ . operands[ 2 ], loadvalue, dummyoperandsize,
            realsize );
    rightoperand := popreal;
    case instruction^ . opcode of {assert instruction^.opcode in [fceq..fclt]}
        fceq : pushboolean( leftoperand = rightoperand );
        fcne : pushboolean( leftoperand <> rightoperand );
        fcgt : pushboolean( leftoperand > rightoperand );
        fcle : pushboolean( leftoperand <= rightoperand );
        fcge : pushboolean( leftoperand >= rightoperand );
        fclt : pushboolean( leftoperand < rightoperand )
    end {case};
    if debug then begin
        writeln( output, '<floatingcompare' );
        break( output ) end
end; {floatingcompare}
procedure logicalunaryops;
begin {logicalunaryops}
    if debug then begin
        writeln( output, '>logicalunaryops' );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize,
            booleansize );
    pushboolean( not( popboolean ));
    if debug then begin
        writeln( output, '<logicalunaryops' );
        break( output ) end
end; {logicalunaryops}
procedure logicalbinaryops; {this may not be correct because of ambiguous
                             documentation on page 8 of the intermediate
                             file specification.  apparently true = -1 and
                             false = 0 so false > true. if so, then the
                             documentation makes sense...}
var   leftoperand,
      rightoperand : boolean;
begin {logicalbinaryops}
    if debug then begin
        writeln( output, '>logicalbinaryops : ', instruction^ . opcode );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize,
            booleansize );
    leftoperand := popboolean;
    interpret( instruction^ . operands[ 2 ], loadvalue, dummyoperandsize,
            booleansize );
    rightoperand := popboolean;
    case instruction^ . opcode of
        {assert opcode in [eqv, xor, nimp, rimp, imp, nrimp, or, and]}
        eqv  : pushboolean( leftoperand = rightoperand );
        xor  : pushboolean( leftoperand <> rightoperand );
        nimp : begin
            writeln(  output, '-ve implication-' );
            error( notyetimplemented ) end;
        rimp : if rightoperand then
                pushboolean( leftoperand )
            else
                pushboolean( true );
        imp  : if leftoperand then
                pushboolean( rightoperand )
            else
                pushboolean( true );
        nrimp : begin
            writeln( output, '-ve reverse implication-' );
            error( notyetimplemented ) end;
        orop  : pushboolean( leftoperand or rightoperand );
        andop : pushboolean( leftoperand and rightoperand )
    end {case};
    if debug then begin
        writeln( output, '<logicalbinaryops' );
        break( output ) end
end; {logicalbinaryops}
procedure complement;
begin {complement}
    if debug then begin
        writeln( output, '>complement' );
        break( output ) end;
    writeln( output, 'complement-' );
    error( notyetimplemented );
    break( output );
    if debug then begin
        writeln( output, '<complement' );
        break( output ) end
end; {complement}
procedure setbinaryops;
begin {setbinaryops}
    if debug then begin
        writeln( output, '>setbinaryops' );
        break( output ) end;
    writeln( output, 'setbinaryops-' );
    error( notyetimplemented );
    break( output );
    if debug then begin
        writeln( output, '<setbinaryops' );
        break( output ) end
end; {setbinaryops}
procedure setunaryops;
begin {setunaryops}
    if debug then begin
        writeln( output, '>setunaryops' );
        break( output ) end;
    writeln( output, 'setunaryops-' );
    error( notyetimplemented );
    break( output );
    if debug then begin
        writeln( output, '<setunaryops' );
        break( output ) end
end; {setunaryops}
procedure setcompare;
begin {setcompare}
    if debug then begin
        writeln( output, '>setcompare' );
        break( output ) end;
    writeln( output, 'setcompare-' );
    error( notyetimplemented );
    break( output );
    if debug then begin
        writeln( output, '<setcompare' );
        break( output ) end
end; {setcompare}
procedure setmiscops;
begin {setmiscops}
    if debug then begin
        writeln( output, '>setmiscops' );
        break( output ) end;
    writeln( output, 'setmiscops-' );
    error( notyetimplemented );
    break( output );
    if debug then begin
        writeln( output, '<setmiscops' );
        break( output ) end
end; {setmiscops}
procedure fieldop;
begin {fieldop}
    if debug then begin
        writeln( output, '>fieldop' );
        break( output ) end;
    writeln( output, 'fieldop-' );
    error( notyetimplemented );
    break( output );
    if debug then begin
        writeln( output, '<fieldop' );
        break( output ) end
end; {fieldop}
procedure offset;
begin {offset}
    if debug then begin
        writeln( output, '>offset' );
        break( output ) end;
    writeln( output, 'offset-' );
    error( notyetimplemented );
    break( output );
    if debug then begin
        writeln( output, '<offset' );
        break( output ) end
end; {offset}
procedure indirect; {here be dragons}
{this opcode probably was intended to access fields of a record and
 to get the value of a var parameter.  don't trust me, though. test it for
 yourself because I had no documentation to base this on.

 as implemented, it evaluates it operand to an address and loads the value
 at the address plus the offset specified in the displacement field}

var   bytestocopy, dataoffset, baseaddress : dataaddress;
begin {indirect}
    if debug then begin
        writeln( output, '>indirect' );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadaddress, dummyoperandsize,
            integersize );
    baseaddress := popinteger + instruction^ . displacement;
    if interpretmode = loadvalue then begin
        bytestocopy := instruction^ . size;
        newstack( bytestocopy );
        for dataoffset := 0 to pred( bytestocopy ) do
            data[ stackpointer + dataoffset ] := data[ baseaddress +
                    dataoffset ];
        finalsize := bytestocopy end
    else begin {assume interpretmode = loadaddress}
        pushinteger( baseaddress );
        finalsize := integersize end;
    if debug then begin
        writeln( output, '<indirect' );
        break( output ) end
end; {indirect}
procedure arrayindex;
var   indexsize : operandsizes;
      dataoffset, baseaddress, variableaddress : dataaddress;
      offsetunits : integer;
begin {arrayindex}
    if debug then begin
        writeln( output, '>arrayindex' );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadaddress, dummyoperandsize,
            0 );
    baseaddress := popinteger;
    interpret( instruction^ . operands[ 2 ], loadvalue, indexsize, 0 );
    if indexsize = charsize then
        offsetunits := ord( popchar )
    else {assume indexsize = integersize}
        offsetunits := popinteger;
    variableaddress := baseaddress + offsetunits * instruction^ . size;
    if interpretmode = loadaddress then
        pushinteger( variableaddress )
    else begin {assume interpretmode = loadvalue}
        newstack( instruction^ . size );
        for dataoffset := 0 to pred( instruction^ . size ) do
            data[ stackpointer + dataoffset ] := data[ variableaddress +
                    dataoffset ] end;
    finalsize := instruction^ . size;
    if debug then begin
        writeln( output, '<arrayindex' );
        break( output ) end
end; {arrayindex}
procedure moveblock; {here be dragons}
{this is a block move operation code.  documentation is nonexistent.
 you are therefore hereby advised to experiment for yourself before
 accepting as is}
var   bytestomove, toaddress, fromaddress, dataoffset : dataaddress;
begin {moveblock}
    if debug then begin
        writeln( output, '>moveblock' );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadaddress, dummyoperandsize,
            integersize );
    toaddress := popinteger;
    interpret( instruction^ . operands[ 2 ], loadaddress, dummyoperandsize,
            integersize );
    fromaddress := popinteger;
    bytestomove := instruction^ . size * instruction^ . displacement;
    for dataoffset := 0 to pred( bytestomove ) do
        data[ toaddress + dataoffset ] := data[ fromaddress + dataoffset ];
    if debug then begin
        writeln( output, '<moveblock' );
        break( output ) end
end; {moveblock}
procedure invokestandardprocedure;
const init                   = 0;
      exitproc               = 1;
      newproc                = 4;
      markproc               = 6;
      releaseproc            = 7;
      initfileblock          = 16;
      openfile               = 17;
      closefile              = 20;
      getproc                = 21;
      putproc                = 22;
      breakproc              = 23;
      readcharacter          = 24;
      writecharacter         = 25;
      writestring            = 27;
      writeboolean           = 29;
      readinteger            = 30;
      writeinteger           = 31;
      readreal               = 34;
      writereal              = 35;
      readdoublereal         = 36;
      writedoublereal        = 37;
      writepointer           = 39;
                            {useful for debugging; there is no read pointer}
      writeeformatreal       = 41;
      writedoubleeformatreal = 43;
      readendofline          = 44;
      writeendofline         = 45;


      {the following are standard functions}

      eolnfunc               = 46;

      {the following are longreal functions}

      sqrtfunc               = 101;
      lnfunc                 = 102;
      expfunc                = 103;
      sinfunc                = 104;
      cosfunc                = 105;
      arctanfunc             = 106;
type  standardprocedures     = pred( init )..succ( arctanfunc );
                                {work around compiler bug}
      writeabletypes         = ( integertype, chartype, realtype,
                                 booleantype, pointertype, stringtype );
      readabletypes          = integertype..realtype;

var   bytestoallocate : dataaddress;
      invokedprocedure : standardprocedures;
      {this charade of needing a local is because of a limitation in the
       nbs compiler.  Ideally, the following case statement would read
       case instruction^ . displacement of...  However, since the nbs compiler
       sets up a jump table, it assumes that the ordinal type has a range
       not exceeding 256}

procedure outputvalue( outputtype : writeabletypes );
                                     {environment dependency}
type  pointerkludge = record
                          case boolean of
                              true  : ( pointval : ^integer );
                              false : ( intval : integer )
                      end; {pointerkludge}
var   count, integervalue, fieldwidth : integer;
      charvalue : char;
      booleanvalue : boolean;
      realvalue : real;
      pointervalue : pointerkludge;
      startaddress, bytestowrite, datatowrite : dataaddress;
begin {outputvalue}
    if debug then begin
        writeln( output, '>outputvalue : ord( type )= ',
                ord( outputtype ));
        break( output ) end;
    case outputtype of
        integertype : begin
                {regardless of file selected, output is used}
                interpret( instruction^ . operands[ 2 ], loadvalue,
                        dummyoperandsize, integersize );
                integervalue := popinteger;
                interpret( instruction^ . operands[ 3 ], loadvalue,
                        dummyoperandsize, integersize );
                fieldwidth := popinteger;
                write( output, integervalue : fieldwidth );
                break( output ) end; {to make it easier to debug}
        booleantype : begin
                {regardless of file selected, output is used}
                interpret( instruction^ . operands[ 2 ], loadvalue,
                        dummyoperandsize, booleansize );
                booleanvalue := popboolean;
                interpret( instruction^ . operands[ 3 ], loadvalue,
                        dummyoperandsize, integersize );
                fieldwidth := popinteger;
                write( output, booleanvalue : fieldwidth );
                break( output ) end; {to make it easier to debug}
        chartype : begin
                {regardless of file selected, output is used}
                interpret( instruction^ . operands[ 2 ], loadvalue,
                        dummyoperandsize, charsize );
                charvalue := popchar;
                interpret( instruction^ . operands[ 3 ], loadvalue,
                        dummyoperandsize, integersize );
                fieldwidth := popinteger;
                write( output, charvalue : fieldwidth );
                break( output ) end; {to make it easier to debug}
        realtype : begin
                {regardless of file selected, output is used}
                interpret( instruction^ . operands[ 2 ], loadvalue,
                        dummyoperandsize, realsize );
                realvalue := popreal;
                interpret( instruction^ . operands[ 3 ], loadvalue,
                        dummyoperandsize, integersize );
                fieldwidth := popinteger;
                write( output, realvalue : fieldwidth );
                break( output ) end; {to make it easier to debug}
        pointertype : begin
                {regardless of file selected, output is used}
                interpret( instruction^ . operands[ 2 ], loadvalue,
                        dummyoperandsize, integersize );
                pointervalue . intval := popinteger;
                interpret( instruction^ . operands[ 3 ], loadvalue,
                        dummyoperandsize, integersize );
                fieldwidth := popinteger;
                write( output, pointervalue . pointval : fieldwidth );
                break( output ) end; {to make it easier to debug}
        stringtype : begin
            {regardless of file selected, output is used}
            interpret( instruction^ . operands[ 2 ], loadaddress,
                    dummyoperandsize, integersize );
            startaddress := popinteger;
            interpret( instruction^ . operands[ 3 ], loadvalue,
                    dummyoperandsize, integersize );
            bytestowrite := popinteger;
            interpret( instruction^ . operands[ 4 ], loadvalue,
                    dummyoperandsize, integersize );
            fieldwidth := popinteger;
            for datatowrite := startaddress to
                    pred( startaddress + bytestowrite ) do begin
                charvalue := data[ datatowrite ]; {environment dependency}
                write( output, charvalue ) end;
            for count := 1 to fieldwidth - bytestowrite do
                                                {environment dependency}
                write( output, ' ' );
            break( output ) end {to make it easier to debug}
    end; {case}
    if debug then begin
        writeln( output, '<outputvalue' );
        break( output ) end
end; {outputvalue}
procedure inputvalue( inputtype : readabletypes ); {environment dependency}
type  integerkludge = record
                          case boolean of
                              true  : ( integervalue : integer );
                              false : ( bytevalue : array[ 1..integersize ]
                                          of byte )
                      end; {integerkludge}
      realkludge    = record
                          case boolean of
                              true  : ( realvalue : real );
                              false : ( bytevalue : array[ 1..realsize ]
                                          of byte )
                      end; {realkludge}
var   toaddress : dataaddress;
      bytecount : operandsizes;
      realquantity : realkludge;
      integerquantity : integerkludge;
      charquantity : char;
begin {inputvalue}
    if debug then begin
        writeln( output, '>inputvalue : ord( type )= ',
                ord( inputtype ));
        break( output ) end;
    interpret( instruction^ . operands[ 2 ], loadaddress,
            dummyoperandsize, integersize );
    toaddress := popinteger;
    case inputtype of
        chartype : begin {environment dependency}
            read( input, charquantity );
            data[ toaddress ] := charquantity end;
        integertype : begin
            read( input, integerquantity . integervalue );
            data[ toaddress ] := integerquantity . bytevalue[ 1 ];
            data[ succ( toaddress )] := integerquantity . bytevalue[ 2 ] end;
        realtype : begin
            read( input, realquantity . realvalue );
            for bytecount := 1 to realsize do
                data[ pred( toaddress + bytecount )] := realquantity
                        . bytevalue[ bytecount ] end
    end; {case}
    if debug then begin
        write( output, '<inputvalue : ', toaddress, '^ <-' );
        case inputtype of
            chartype : writeln( output, '''', charquantity, '''' );
            integertype : writeln( output, integerquantity . integervalue );
            realtype : writeln( output, realquantity . realvalue )
        end; {case}
        break( output ) end
end; {inputvalue}
begin {invokestandardprocedure}
    if debug then begin
        writeln( output, '>invokestandardprocedure : ',
                instruction^ . displacement );
        break( output ) end;
    invokedprocedure := succ( instruction^ . displacement );

{CAUTIONCAUTIONCAUTIONCAUTIONCAUTIONCAUTIONCAUTIONCAUTIONCAUTIONCAUTIONCAUTION
 the above should not have a succ, but because of a bug in the nbs pascal
 code generation, it is there.  remove at the earliest opportunity}

    case invokedprocedure of {displacement has procedure number}
        init : begin
            writeln( output, 'proc. init-' );
            error( notyetimplemented ) end;
        exitproc : begin
            writeln( output, 'proc. exit-' );
            error( notyetimplemented ) end;
        newproc : begin
            interpret( instruction^ . operands[ 1 ], loadvalue,
                    dummyoperandsize, integersize );
            bytestoallocate := popinteger;
            pushinteger( stacklimit );
            finalsize := integersize;
            stacklimit := stacklimit + bytestoallocate;
            if stacklimit > stackpointer then begin
                error( heapoverflow );
                stacklimit := popinteger;
                pushinteger( -1 ); {some illegal abominable value}
                finalsize := 0 end end;
        markproc : begin
            writeln( output, 'proc. mark-' );
            error( notyetimplemented ) end;
        releaseproc : begin
            writeln( output, 'proc. release-' );
            error( notyetimplemented ) end;
        initfileblock : begin
            writeln( output, 'proc. initfileblock-' );
            error( notyetimplemented ) end;
        openfile : begin
            writeln( output, 'proc. openfile-' );
            error( notyetimplemented ) end;
        closefile : begin
            writeln( output, 'proc. closefile-' );
            error( notyetimplemented ) end;
        getproc : get( input ); {regardless of file specified, input assumed}
        putproc : put( output );
                                {regardless of file specified, output assumed}
        breakproc : break( output );
                                {regardless of file specified, output assumed}
        readcharacter : inputvalue( chartype );
        writecharacter : outputvalue( chartype );
        writestring : outputvalue( stringtype );
        writeboolean : outputvalue( booleantype );
        readinteger : inputvalue( integertype );
        writeinteger : outputvalue( integertype );
        readreal : inputvalue( realtype );
        writereal : outputvalue( realtype );
        readdoublereal : begin
            writeln( output, 'proc. readdoublereal-' );
            error( notyetimplemented ) end;
        writedoublereal : begin
            writeln( output, 'proc. writedoublereal-' );
            error( notyetimplemented ) end;
        writepointer : outputvalue( pointertype );
        writeeformatreal : begin
            writeln( output, 'proc. writeeformatreal-' );
            error( notyetimplemented ) end;
        writedoubleeformatreal : begin
            writeln( output, 'proc. writedoubleeformatreal-' );
            error( notyetimplemented ) end;
        readendofline : readln( input ); {all input from input only}
        writeendofline : writeln( output ); {all output to output only}
        eolnfunc : pushboolean( eoln( input ));
        sqrtfunc : begin
            writeln( output, 'proc. sqrt-' );
            error( notyetimplemented ) end;
        lnfunc : begin
            writeln( output, 'proc. ln-' );
            error( notyetimplemented ) end;
        expfunc : begin
            writeln( output, 'proc. exp-' );
            error( notyetimplemented ) end;
        sinfunc : begin
            writeln( output, 'proc. sin-' );
            error( notyetimplemented ) end;
        cosfunc : begin
            writeln( output, 'proc. cos-' );
            error( notyetimplemented ) end;
        arctanfunc : begin
            writeln( output, 'proc. arctan-' );
            error( notyetimplemented ) end
    end; {case}
    break( output );
    if debug then begin
        writeln( output, '<invokestandardprocedure' );
        break( output ) end
end; {invokestandardprocedure}
procedure refertotemp;
begin {refertotemp}
    if debug then begin
        writeln( output, '>refertotemp' );
        break( output ) end;
    writeln( output, 'refertotemp-' );
    error( notyetimplemented );
    break( output );
    if debug then begin
        writeln( output, '<refertotemp' );
        break( output ) end
end; {refertotemp}
procedure definetemp;
begin {definetemp}
    if debug then begin
        writeln( output, '>definetemp' );
        break( output ) end;
    writeln( output, 'definetemp-' );
    error( notyetimplemented );
    break( output );
    if debug then begin
        writeln( output, '<definetemp' );
        break( output ) end
end; {definetemp}
procedure ifstatement;
begin {ifstatement}
    if debug then begin
        writeln( output, '>ifstatement' );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadvalue, dummyoperandsize, 0 );
    if popboolean then
        interpret( instruction^ . operands[ 2 ], noload, dummyoperandsize, 0 )
    else
        interpret( instruction^ . operands[ 3 ], noload, dummyoperandsize, 0 );
    if debug then begin
        writeln( output, '<ifstatement' );
        break( output ) end
end; {ifstatement}
procedure casecontrol;
begin {casecontrol}
    if debug then begin
        writeln( output, '>casecontrol' );
        break( output ) end;
    writeln( output, 'casecontrol-' );
    error( notyetimplemented );
    break( output );
    if debug then begin
        writeln( output, '<casecontrol' );
        break( output ) end
end; {casecontrol}
procedure loopcontrol;
const firstoperand   = 1;
      thenclause     = 2; {for exitop}
var   currentoperand : numberofargs;
      exitcondition  : boolean;
begin {loopcontrol}
    if debug then begin
        writeln( output, '>loopcontrol : ', instruction^ . opcode );
        break( output ) end;
    if instruction^ . opcode = loopop then begin
        currentoperand := firstoperand;
        exitcondition := false;
        repeat
            interpret( instruction^ . operands[ currentoperand ], noload,
                    dummyoperandsize, 0 ); {process statement}
            if currentoperand = instruction^ . argcount then
                currentoperand := firstoperand
            else begin
                currentoperand := succ( currentoperand );
                interpret( instruction^ . operands[ currentoperand ],
                        loadvalue, dummyoperandsize,
                        booleansize ); {process condition}
                exitcondition := popboolean;
                currentoperand := succ( currentoperand ) end
                        {assert currentoperand <= argcount because
                         loopop has an odd # of arguments always}
        until exitcondition end
    else begin {assert opcode = exitop}
        interpret( instruction^ . operands[ firstoperand ], loadvalue,
                dummyoperandsize, booleansize );
        exitcondition := popboolean;
        if exitcondition then
            interpret( instruction^ . operands[ thenclause ], noload,
                    dummyoperandsize, booleansize );
        pushboolean( exitcondition ) end;
    if debug then begin
        writeln( output, '<loopcontrol' );
        break( output ) end
end; {loopcontrol}
procedure forstatement; {environment dependency}
{this assumes that a boolean loop can be executed as a char loop,
 also the usual booleansize = charsize = 1}
const increasingloop = 1;
type  integerkludge = record
                          case boolean of
                              true  : ( intvalue : integer );
                              false : ( bytevalue : array[ 1..integersize ]
                                        of byte )
                      end; {integerkludge}
      charkludge = record {environment dependency}
                       case boolean of
                           true  : ( chvalue : char );
                           false : ( bytevalue : byte )
                   end; {charkludge}
var   incrementsize, variablesize : operandsizes;
      variableaddress, succvariableaddress : address;
      indexint, initialint, finalint : integer;
      kludgeindexint : integerkludge;
      indexch, initialch, finalch : char;
      kludgeindexch : charkludge;
      uploop : boolean; {true => x to y, false => x downto y}
begin {forstatement}
    if debug then begin
        writeln( output, '>forstatement' );
        break( output ) end;
    interpret( instruction^ . operands[ 1 ], loadaddress, variablesize,
            integersize );
    variableaddress := popinteger;
    interpret( instruction^ . operands[ 2 ], loadvalue, dummyoperandsize,
            variablesize );
    interpret( instruction^ . operands[ 3 ], loadvalue, dummyoperandsize,
            variablesize );
    interpret( instruction^ . operands[ 4 ], loadvalue, incrementsize,
            integersize );
                     {note that this should be a literal +/-1 with size 2}
    if popinteger = increasingloop then
        uploop := true
    else
        uploop := false;
    if variablesize = integersize then begin {integer or enumeration loop}
        succvariableaddress := succ( variableaddress );
        finalint := popinteger;
        initialint := popinteger;
        if uploop then
            for indexint := initialint to finalint do begin
                kludgeindexint . intvalue := indexint;
                data[ variableaddress ] := kludgeindexint . bytevalue[ 1 ];
                data[ succvariableaddress ] := kludgeindexint . bytevalue[ 2 ];
                interpret( instruction^ . operands[ 5 ], noload,
                        dummyoperandsize, 0 ) end
        else
            for indexint := initialint downto finalint do begin
                kludgeindexint . intvalue := indexint;
                data[ variableaddress ] := kludgeindexint . bytevalue[ 1 ];
                data[ succvariableaddress ] := kludgeindexint . bytevalue[ 2 ];
                interpret( instruction^ . operands[ 5 ], noload,
                        dummyoperandsize, 0 ) end end
    else if variablesize = charsize then begin
        finalch := popchar;
        initialch := popchar;
        if uploop then
            for indexch := initialch to finalch do begin
                kludgeindexch . chvalue := indexch;
                data[ variableaddress ] := kludgeindexch . bytevalue;
                interpret( instruction^ . operands[ 5 ], noload,
                        dummyoperandsize, 0 ) end
        else
            for indexch := initialch downto finalch do begin
                kludgeindexch . chvalue := indexch;
                data[ variableaddress ] := kludgeindexch . bytevalue;
                interpret( instruction^ . operands[ 5 ], noload,
                        dummyoperandsize, 0 ) end end;
    break( output );
    if debug then begin
        writeln( output, '<forstatement' );
        break( output ) end
end; {forstatement}
procedure sequence;
type  countindex = numberofargs;
var   count : countindex;
begin {sequence}
    if debug then begin
        writeln( output, '>sequence' );
        break( output ) end;
    for count := 1 to instruction^ . argcount do
        interpret( instruction^ . operands[ count ], noload,
                dummyoperandsize, 0 );
    if debug then begin
        writeln( output, '<sequence' );
        break( output ) end
end; {sequence}
procedure literal;
{this specifies a literal constant in the 'displacement'
 field of the opcode}

begin {literal}
    if debug then begin
        writeln( output, '>literal' );
        break( output ) end;
    if sizetoforce = charsize then begin {environment dependency}
                                            {assume booleansize = charsize}
        pushchar( chr( instruction^ . displacement ));
        finalsize := charsize end
    else begin
        pushinteger( instruction^ . displacement );
        finalsize := integersize end;
    if debug then begin
        writeln( output, '<literal : ', instruction^ . displacement );
        break( output ) end
end; {literal}
procedure refertodata; {here be dragons}

{once again our intrepid implementors are confronted by the unknown.  it
 is believed that this is like a call to variable with a request to load
 an address.  the argument is an offset to the constant segment, to be
 converted to a memory "address"}

var   temp : dataaddress;
begin {refertodata}
    if debug then begin
        writeln( output, '>refertodata : ', instruction^ . displacement );
        break( output ) end;
    temp := constsegmentorigin + instruction^ . displacement;
    pushinteger( temp );
    if debug then begin
        writeln( output, '<refertodata : ', temp );
        break( output ) end
end; {refertodata}
procedure floatingliteral;
begin {floatingliteral}
    if debug then begin
        writeln( output, '>floatingliteral' );
        break( output ) end;
    writeln( output, 'floatingliteral-' );
    error( notyetimplemented );
    break( output );
    if debug then begin
        writeln( output, '<floatingliteral' );
        break( output ) end
end; {floatingliteral}
procedure vectorcompare;
begin {vectorcompare}
    if debug then begin
        writeln( output, '>vectorcompare' );
        break( output ) end;
    writeln( output, 'vectorcompare-' );
    error( notyetimplemented );
    break( output );
    if debug then begin
        writeln( output, '<vectorcompare' );
        break( output ) end
end; {vectorcompare}
procedure variable;
type  byterange = 0..255;
var   dataoffset,
      variableaddress : dataaddress;
      tempsize : byterange; {environment dependency}
                            {since size is stored as char}

{the varbl opcode has fields as follows:
      size : size of the variable (in bytes? different from pass2 which is
                                   in bits - 1 )
      displacement : offset from the stackframe pointer of variable origin
      segmentnumber : lexical level where variable is defined}

begin {variable}
    if debug then begin
        writeln( output, '>variable' );
        break( output ) end;
    variableaddress := display[ instruction^ . segmentnumber ] +
            instruction^ . displacement;
    tempsize := instruction^ . size;
    if interpretmode = loadaddress then begin
        pushinteger( variableaddress );
        finalsize := tempsize end {caution: finalsize <> size of top of stack}
    else if interpretmode = loadvalue then begin
        newstack( tempsize );
        for dataoffset := 0 to pred( tempsize ) do
            data[ stackpointer + dataoffset ] := data[ variableaddress
                    + dataoffset ];
        if ( sizetoforce <> 0 ) and ( sizetoforce <> tempsize ) then begin
            if sizetoforce = charsize then {assume chr( integer )}
                pushchar( chr( popinteger ))
            else {assume ord( char )}
                pushinteger ( ord( popchar ));
            finalsize := sizetoforce end
        else
            finalsize := tempsize end;
    if debug then begin
        writeln( output, '<variable : ', variableaddress );
        break( output ) end
end; {variable}
procedure callprocedure;
var   operandsize : operandsizes;
      count : numberofargs;
      calledprocedure : procedurenumber;
      saveddisplay : dataaddress;
      calledlexicallevel : segmentnumbers;
begin {callprocedure}
    if debug then begin
        write( output, '>callprocedure : ' );
        break( output ) end;
    calledprocedure := instruction^ . displacement;
    if calledprocedure = mainprogram then
        error( mainprogramcalled )
    else begin
        if debug then begin
            writeln( output, thisprogram[ calledprocedure ] . name );
            break( output ) end;
        newstack( thisprogram[ calledprocedure ] . returnvaluesize );
            {allocate space on stack for return value, if any}
        for count := 1 to instruction^ . argcount do begin
           interpret( instruction^ . operands[ count ], loadvalue,
                   operandsize, 0 ); {environment dependency}
           if operandsize = 1 then begin
                newstack( 1 );
                data[ stackpointer ] := data[ succ( stackpointer )] end end;
                           {environment dependency}
                           {all parameters must be 2 bytes.  nbs pascal
                            implicit limitation cum kludge}
        newstack( -thisprogram[ calledprocedure ] . localdatasize );
        calledlexicallevel := thisprogram[ calledprocedure ] . lexicallevel;
        saveddisplay := display[ calledlexicallevel ];
        display[ calledlexicallevel ] := stackpointer +
                thisprogram[ calledprocedure ] . localdatasize;
        interpret( thisprogram[ calledprocedure ] . instructions, noload,
                dummyoperandsize, 0 ); {pascal is not expression oriented, so
                              the called procedure is a statement but
                              it can look like an expression to the caller}
        display[ instruction^ . segmentnumber ] := saveddisplay;
        pop( thisprogram[ calledprocedure ] . parametersize -
                thisprogram[ calledprocedure ] . localdatasize );
        finalsize := thisprogram[ calledprocedure ] . returnvaluesize end;
    if debug then begin
        writeln( output, '<callprocedure' );
        break( output ) end
end; {callprocedure}
begin {interpret}
    if debug then begin
        writeln( output, '>interpret( ', instruction, ' )' );
        break( output ) end;
    if instruction <> nil then begin
        case instruction^ . opcode of
            refer : reference;
            stol, stof : store;
            succop, predop : succoppredop;
            uceq, ucne, ucgt, ucle, ucge, uclt : unsignedcompare;
            umax,umin : unsignedmaxmin;
            iadd, isub, imul, idiv, imod ,imax, imin: integerbinaryops;
            ineg, iabs : integerunaryops;
            iodd : integerodd;
            iceq, icne, icgt, icle, icge, iclt : integercompare;
            fadd, fsub, fmul, fdiv ,fmax, fmin: floatingbinaryops;
            fneg, fabs : floatingunaryops;
            floatop : integertofloating;
            roundop, truncop : floatingtointeger;
            fceq, fcne, fcgt, fcle, fcge, fclt : floatingcompare;
            notop : logicalunaryops;
            eqv, xor, nimp, rimp, imp, nrimp, orop, andop : logicalbinaryops;
            compl : complement; {not specified yet} {setunaryops???}
            union, inter, sdiff : setbinaryops;
            sgens, sadel, empty : setunaryops;
            sceq, scne, scgt, scle, scge, sclt : setcompare;
            sin, sany : setmiscops;
            field : fieldop; {??}
            ofset : offset; {??}
            indir : indirect;
            index : arrayindex;
            movem : moveblock;
            invok : invokestandardprocedure;
            rtemp : refertotemp;
            dtemp : definetemp;
            ifop : ifstatement;
            caseop, entry : casecontrol;
            loopop, exitop : loopcontrol;
            forop : forstatement;
            seq : sequence;
            liter : literal;
            rdata : refertodata;
            litd : floatingliteral;
            vceq, vcne, vcgt, vcle, vcge, vclt : vectorcompare;
            varbl, param : variable;
            call : callprocedure
         end {case opcode of} end;
    if debug then begin
        writeln( output, '<interpret : ', finalsize );
        break( output ) end
end; {interpret}
{main program}
begin
    if debug then begin
        writeln( output, '>main program' );
        break( output ) end;
    noerror := true;
    initialize;
    if noerror then begin
        readpcode;
        readconstsegment;
        if noerror then
           interpret( thisprogram[ mainprogram ] . instructions, noload,
                      dummyoperandsize, 0 ) end;
    if debug then begin
        writeln( output, '<main program' );
        break( output ) end
end.
