/*	Copyright (c) 1990 UNIX System Laboratories, Inc.	*/
/*	Copyright (c) 1984, 1986, 1987, 1988, 1989, 1990 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF     	*/
/*	UNIX System Laboratories, Inc.                     	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ifndef _SYS_IPL_H
#define _SYS_IPL_H

#ident	"@(#)head.sys:sys/ipl.h	1.1.2.1"

/*
 * Interrupt Priority Levels
 *
 * The following defines are used in misc.s to map
 * spl*() functions to interrupt priority levels,
 * and in initializing the intpri[] array in conf.c,
 * which is generated by the config command.
 * The interrupt priority (intpri) levels specified in the
 * master.d/ * /config files are SPL* constants, not ipl's.
 * Thus the spl to ipl mapping can be changed to add new spls and ipls
 * without changing the intpri values in the config files.
 *
 * IPLHI is the priority level at which interrupts are entirely disabled
 * by clearing the IF flag with a cli instruction.
 * Interrupts are selectively disabled at lower priority levels
 * by loading interrupt masks into the PICs.
 */

#define IPLHI           8

/*      spl             ipl     */

#define SPL0            0
#define SPL1            1
#define SPL2            2
#define SPL3            3
#define SPL4            4
#define SPL5            5
#define SPLPP           5
#define SPL6            6
#define SPLNI           6
#define SPLVM		6		/* 4.0 specific */
#define SPLIMP		7		/* 4.0 specific */
#define SPLTTY          7

/*
 * SPL7 and SPLHI must be at the same priority level, typically IPLHI.
 * The clock must be the only device at SPL7/SPLHI.
 */

#define SPL7            IPLHI
#define SPLHI           IPLHI

#endif	/* _SYS_IPL_H */
