/*	Copyright (c) 1990 UNIX System Laboratories, Inc.	*/
/*	Copyright (c) 1988 AT&T	*/
/*	  All Rights Reserved  	*/

/*	THIS IS UNPUBLISHED PROPRIETARY SOURCE CODE OF     	*/
/*	UNIX System Laboratories, Inc.                     	*/
/*	The copyright notice above does not evidence any   	*/
/*	actual or intended publication of such source code.	*/

#ident	"@(#)libc-port:stdio/tmpfile.c	1.12"
/*LINTLIBRARY*/
/*
 *	tmpfile - return a pointer to an update file that can be
 *		used for scratch. The file will automatically
 *		go away if the program using it terminates.
 */
#include "synonyms.h"
#include <stdio.h>
#include <string.h>
#include <stdio.h>

extern int unlink();
extern void perror();

static char seed[] = { 'a', 'a', 'a', '\0' };

#define XS "\bXXXXXX"		/* a '\b' character is prepended to this
				* string to avoid conflicts with names
				* generated by tmpnam() */

FILE *
tmpfile()
{
	char	tfname[L_tmpnam];
	register FILE	*p;
	register char	*q;


	(void) strcpy(tfname, P_tmpdir);
	(void) strcat(tfname, seed);
	(void) strcat(tfname, XS);

	q = seed;
	while(*q == 'z')
		*q++ = 'a';
	if (*q != '\0')
		++*q;

	(void) mktemp(tfname);
	if((p = fopen(tfname, "w+")) == NULL)
		return NULL;
	else
		(void) unlink(tfname);
	return(p);
}
